-------------------------------------
require("modules/module_utils")
-------------------------------------

local m = Module:new("q_divine_might")

m:addOverride('xi.server.onServerStart', function()
    super()

    xi.module.modifyInteractionEntry('scripts/quests/outlands/Divine_Might', function(quest)
        -- We could attempt to override the onTrigger for the blank_divine_might npc, but doing this check onZoneIn is much simpler
        -- when a player on the first DivineMight quest zones into the shrine, it'll check if they've done the DM fight and flag the quest progress so they can redeem the earring
        -- once that quest is complete, this bit of code never runs again
        quest.sections[2][xi.zone.THE_SHRINE_OF_RUAVITAU].onZoneIn =
        {
            function(player, prevZone)
                -- Progress quest to get DM earring if completed fight ('DivineMight' charvar) but didn't complete quest by talking to fountain on WingsXI
                -- note that this code will not trigger once DM quest is completed and they move onto the Divine Might Repeat (different quest id)
                if
                    player and
                    player:getCharVar('DM_Earring') == 0 and    -- has not redeemed earring (shouldn't be possible if this quest is active, but just to be sure)
                    player:getCharVar('DivineMight') == 2       -- has completed DM fight
                then
                    quest:setVar(player, 'Prog', 1)
                end
            end,
        }
    end)
end)

return m
