-----------------------------------
-- Soup of the Day (Lv5)
-----------------------------------
-- !setvar [CW]SOUP_DAY 0
-- Cokhe-Lohke !pos 64.557 -14.558 5.696 248
-- !additem 539
-- Reward: 500 gil
-----------------------------------
-- !setvar [CW]SOUP_DAY 2

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-soup_of_the_day")

local info =
{
    name   = "Soup of the Day",
    author = "Loxley",
    var    = "[CW]SOUP_DAY",
    reward =
    {
        gil = 500,
    },

    required =
    {
        item = 539,
        name = "a crab apron",
    },
}

local CHEF     = "CHEF"
local Name     = "Cokhe-Lokhe"

local entity =
{
    {
        id     = CHEF,
        name   = Name,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.TARU_M,
            face = cexi.face.B1,
            head = 124, -- Chef's Hat
            body = cexi.model.CULINARIANS_APRON,
            hand = cexi.model.TUNIC,
            legs = cexi.model.TUNIC,
            feet = cexi.model.TUNIC,
        }),
        area   = "Selbina",
        pos    = { 64.557, -14.558, 5.696, 60 }, -- !pos 64.557 -14.558 5.696 248
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "I don't have anything for you." },
            START    =
            {
                { emote = xi.emote.PANIC },
                "I'm ruined... I'm ruined...",
                "My shift is coming up but there's nothing to cook!",
                { emote = xi.emote.HUH },
                "Say, could you fetch me a crab apron? It makes the most delicious soup!",
                { delay = 2000 },
            },
            REMINDER = { "Please bring me a crab apron if you find one!" },
            ACCEPTED =
            {
                { emote = xi.emote.CHEER },
                "Wonderful! This soup is going to be simply exquisite!",
                { delay = 2000 },
            },
            DECLINED =
            {
                { emote = xi.emote.SIGH },
                "I'm desperate but not quite thataru desperate.",
                { delay = 2000 },
            },
            AFTER    = { "If you find more crab aprons, I will gladly accept them!" },
        },
    },
}

local step =
{
    {
        check  = cq.checks({ CW = true, level = 5 }),
        [CHEF] = cq.talkStep("START", info.name),
    },
    {
        [CHEF] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("ACCEPTED", "DECLINED", info.required.item, info.reward, info.name, cexi.music.SELBINA),
        },
    },
    {
        [CHEF] =
        {
            onTrigger = cq.talkOnly("AFTER"),
            onTrade   = cq.tradeOnly("ACCEPTED", "DECLINED", info.required.item, info.reward, info.name, cexi.music.SELBINA),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
