-----------------------------------
-- Shattering Stone (Lv1/UCW)
-----------------------------------
-- !setvar [CW]SHATTERING 0
-- Shattered Stone !pos -51.102 -4.090 27.248 249
-- !additem 613
-- Removes: "Unbreakable" status
-----------------------------------
-- !setvar [CW]SHATTERING 0

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-head_first")

local info =
{
    name   = "Shattering Stone",
    author = "Loxley",
    var    = "[CW]SHATTERING",
    reward =
    {
        gil   = 100,
        after = function(player)
            player:setUnbreakable(false)
            return true
        end,
    },
}

local STONE    = "SHATTERING"

local WARNING1 = "Completing this quest will remove your \"Unbreakable\" status. This cannot be reversed!"
local WARNING2 = "You will no longer be \"Unbreakable\" and you will become a standard Crystal Warrior."
local WARNING3 = "Standard Crystal Warriors do not reset to level 1 on death but are not eligible for Master stars."

local entity =
{
    {
        id       = STONE,
        name     = "Shattered Stone",
        type     = xi.objType.NPC,
        look     = cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.A4,
            head = cexi.model.VELVET_ROBE,
            body = cexi.model.DOUBLET,
            hand = cexi.model.KENPOGI,
            legs = cexi.model.KENPOGI,
            feet = cexi.model.KENPOGI,
        }),
        area     = "Mhaura",
        pos      = { -51.102, -4.090, 27.248, 219 },-- !pos -51.102 -4.090 27.248 249
        dialog   =
        {
            NAME     = true,
            DEFAULT  = { "Nuthin' to say to you." },
            DECLINED = { "Thanks, but I don't need this." },
            START    =
            {
                WARNING1,
                WARNING2,
                WARNING3,
                { delay = 3000 },
                { emote = xi.emote.HUH },
                "You there. Got any faded crystals?",
                "Bring me one and I'll let you try a very special potion.",
            },
            ACCEPTED =
            {
                WARNING1,
                WARNING2,
                WARNING3,
                { delay = 3000 },
                "All right, here's the deal.",
                " You're one of those \"Unbreakables\", right?",
                { emote = xi.emote.THINK },
                { delay = 2000 },
                "Take my special brew and your status is removed. Gone.",
                " Speak to me again if you're still interested."
            },
            ACCEPTED2 =
            {
                WARNING1,
                WARNING2,
                WARNING3,
                { delay = 3000 },
                "You're really serious about this huh?",
                " Last chances to turn back.",
                { emote = xi.emote.YES },
            },
            ACCEPTED3 =
            {
                WARNING1,
                WARNING2,
                WARNING3,
                "Speak to me one last time and it's done."
            },
            ACCEPTED4 =
            { 
                "Here goes...",
                { entity = "player", emote = xi.emote.KNEEL },
                { message = "You are no longer \"Unbreakable\"." },
                { message = "You are now a standard Crystal Warrior." },
            },
            FINISHED =
            {
                { emote = xi.emote.SALUTE },
                "Best of luck on your journey."
            },
        },
    },
}

local checks =
{
    UCW   = true,        -- Player is an Unbreakable Crystal Warrior
    zero  = "[CW]SPENT", -- Player has not spent any milestone points
}

local step =
{
    {
        check   = cq.checks(checks),
        [STONE] = 
        {
            onTrigger = cq.talkOnly("START"),
            onTrade   = cq.tradeStep("ACCEPTED", "DECLINED", 613), -- Faded Crystal
        },
    },
    {
        check   = cq.checks(checks),
        [STONE] = cq.menuStep("Remove your 'Unbreakable' status?", { { "No" }, { "Yes", "ACCEPTED2" } }, 2, info.name),
    },
    {
        check   = cq.checks(checks),
        [STONE] = cq.menuStep("Remove your 'Unbreakable' status?", { { "No" }, { "Yes", "ACCEPTED3" } }, 2),
    },
    {
        check   = cq.checks(checks),
        [STONE] = cq.restoreJob("ACCEPTED4", info.name, cexi.music.SELBINA)
    },
    {
        check   = cq.checks(checks),
        [STONE] = cq.talkOnly("FINISHED")
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
