----------------------------------------------------
-- Searching the Citadel -- Obtain Seer's Set (Lv30)
----------------------------------------------------
-- !setvar [CW]SEARCHING_CITADEL 0
-- Cramp           !pos -193.317 -0.874 226.827 200
-- Creature Tracks !pos 121.334 6.801 -214.974 120
-- Damaged Crown   !pos -154.287 20.419 219.681 200
-- Damaged Mitts   !pos -100.676 0 63.587 200
-- Damaged Slacks  !pos -127.178 0.019 379.211 200
-- Damaged Pumps   !pos -2.651 5.620 262.880 200
-- Damaged Tunic   !pos 228.672 0.443 -304.356 120
----------------------------------------------------
-- !setvar [CW]SEARCHING_CITADEL 13

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
----------------------------------------------------
local m = Module:new("cw_searching_the_citadel")

local vars =
{
    CW_EMILIA_UNLOCK = "[CW]SEARCHING_CITADEL",
}

local info =
{
    name   = "Searching the Citadel",
    author = "Carver",
    var    = "[CW]SEARCHING_CITADEL",
}

local BATTERED_CROWN   = "BATTERED_CROWN"
local TATTERED_TUNIC   = "TATTERED_TUNIC"
local TATTERED_MITTS   = "TATTERED_MITTS"
local TATTERED_SLACKS  = "TATTERED_SLACKS"
local TATTERED_PUMPS   = "TATTERED_PUMPS"
local CREATURE_TRACKS = "CREATURE_TRACKS"
local GROGU           = "GROGU"
local CRAMP           = "CRAMP"

local ARTIFACT_DIALOG =
{
    DEFAULT = cq.NOTHING,
    AFTER   = cq.NOTHING_ELSE,
    FINISH   =
    {
        { animation = 48, target = "player", duration = 3000 }, -- Crouch down
        { emotion   = "retrieves the damaged artifact." },
    },
}

local entity =
{
    {
        id          = CREATURE_TRACKS,
        name        = "Creature Tracks",
        marker      = cq.SIDE_QUEST,
        area        = "Sauromugue_Champaign",
        pos         = { 121.334, 6.801, -214.974 }, -- !pos 121.334 6.801 -214.974 120
        widescan    = 1,
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        }
    },
    {
        id          = GROGU,
        name        = "Grogu",
        type        = xi.objType.MOB,
        look        = 316,
        groupId     = 16,
        groupZoneId = 98,
        area        = "Sauromugue_Champaign",
        pos         = { 121.334, 6.801, -214.974, 194 }, -- !pos 121.334 6.801 -214.974 120
        widescan    = 1,
        level       = 28,
    },
    {
        id     = CRAMP,
        name   = "Cramp",
        type   = xi.objType.NPC,
        look   = "0x05000A0400000000000000000000000000000000",
        area   = "Garlaige_Citadel",
        pos    = { -193.317, -0.874, 226.827, 63 }, -- !pos -193.317 -0.874 226.827 200
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Get out of here! Quit wasting my time ..." },
            START    =
            {
                "I know the location of these pieces you seek but first you most prove yourself worthy. ",
                " Track down the elusive Grogu from Sauromugue Champaign and bring me proof.",
                { delay = 3000 },
                "You can find him just south of the Gausebit Mountains.",
                { emote = xi.emote.PSYCH },
            },
            STEP1 =
            {
                "The first piece lies deep within the basement of this catacomb, where an infamous scorpion roams near.",
                { emote = xi.emote.STAGGER },
            },
            STEP2 =
            {
                "The second piece you seek lies just behind the second banishing gate.",
                { emote = xi.emote.STAGGER },
            },
            STEP3 =
            {
                "The third piece can be found past the third banishing gate in a dead end guarded by some Wraiths.",
                { emote = xi.emote.STAGGER },
            },
            STEP4 =
            {
                "The fourth piece rests deep in the basement of this catacomb, near a group of Arcana, just at the bottom of a staircase.",
                { emote = xi.emote.STAGGER },
            },
            STEP5 = 
            {
                "The final piece of the set rests through the other end of the Citadel.",
                { emote = xi.emote.CHEER },
            },
            RENOVIO =
            {
                "Hmmm..",
                { emote = xi.emote.THINK },
                " These items are too far gone for me to repair. Take them to Renovio in Selbina.",
                { delay = 3000 },
                "If anyone can restore these, it would definitely be him!",
            },
            AFTER = { "Take these items to Renovio in Selbina." },
        },
    },
    {
        id     = BATTERED_CROWN,
        name   = "Battered Crown",
        marker = cq.SIDE_QUEST,
        area   = "Garlaige_Citadel",
        pos    = { -154.287, 20.419, 219.681 }, -- !pos -154.287 20.419 219.681 200
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = TATTERED_MITTS,
        name   = "Tattered Mitts",
        marker = cq.SIDE_QUEST,
        area   = "Garlaige_Citadel",
        pos    = { -100.676, 0, 63.587 }, -- !pos -100.676 0 63.587 200
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = TATTERED_SLACKS,
        name   = "Tattered Slacks",
        marker = cq.SIDE_QUEST,
        area   = "Garlaige_Citadel",
        pos    = { -127.178, 0.019, 379.211 }, -- !pos -127.178 0.019 379.211 200
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = TATTERED_PUMPS,
        name   = "Tattered Pumps",
        marker = cq.SIDE_QUEST,
        area   = "Garlaige_Citadel",
        pos    = { -2.651, 5.620, 262.880 }, -- !pos -2.651 5.620 262.880 200
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = TATTERED_TUNIC,
        name   = "Tattered Tunic",
        marker = cq.SIDE_QUEST,
        area   = "Sauromugue_Champaign",
        pos    = { 228.672, 0.443, -304.356 }, -- !pos 228.672 0.443 -304.356 120
        dialog = ARTIFACT_DIALOG,
    },
}

local step =
{
    {
        check   = cq.checks({ CW = true, level = 30 }),
        [CRAMP] = cq.talkStep("START", info.name),
    },
    {
        [CRAMP]           = cq.talkOnly("START"),
        [CREATURE_TRACKS] = cq.spawnMob(GROGU),
        [GROGU]           = cq.killStep(CREATURE_TRACKS),
    },
    {
        [CREATURE_TRACKS] = cq.talkOnly("AFTER"),
        [CRAMP]           = cq.talkStep("STEP1"),
    },
    {
        [CRAMP]        = cq.talkOnly("STEP1"),
        [BATTERED_CROWN] = cq.menuStep("You find a battered crown.", { { "Leave it." }, { "Uncover it.", "FINISH" } }, 2),
    },
    {
        [CRAMP] = cq.talkStep("STEP2"),
    },
    {
        [CRAMP]        = cq.talkOnly("STEP2"),
        [TATTERED_MITTS] = cq.menuStep("You find tattered mitts.", { { "Leave them." }, { "Dig them up.", "FINISH" } }, 2),
    },
    {
        [CRAMP] = cq.talkStep("STEP3"),
    },
    {
        [CRAMP]         = cq.talkOnly("STEP3"),
        [TATTERED_SLACKS] = cq.menuStep("You find tattered slacks.", { { "Leave them." }, { "Dig them up.", "FINISH" } }, 2),
    },
    {
        [CRAMP] = cq.talkStep("STEP4"),
    },
    {
        [CRAMP]        = cq.talkOnly("STEP4"),
        [TATTERED_PUMPS] = cq.menuStep("You find tattered pumps.", { { "Leave them." }, { "Dig them up.", "FINISH" } }, 2),
    },
    {
        [CRAMP] = cq.talkStep("STEP5"),
    },
    {
        [CRAMP]        = cq.talkOnly("STEP5"),
        [TATTERED_TUNIC] = cq.menuStep("You find a tattered tunic.", { { "Leave it." }, { "Uncover it.", "FINISH" } }, 2),
    },
    {
        [CRAMP] = cq.talkFinish("RENOVIO", info.name, cexi.music.NONE),
    },
    {
        [CRAMP] = cq.talkOnly("AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
