--------------------------------------------
-- Running on the Range -- Garish Set (Lv30)
--------------------------------------------
-- !setvar [CW]ON_THE_RANGE 0
-- Nefari          !pos 811.301 -64.790 656.182 101
-- Roasted Remains !pos 761.758 -60.000 399.168 101
-- Dented Crown    !pos -133.655 -3.056 -95.489 166
-- Ragged Mitts    !pos 158.496 5.310 -59.455 166
-- Ragged Slacks   !pos 140.592 26.980 -210.136 166
-- Ragged Pumps    !pos -292.149 -46.143 197.002 166
-- Ragged Tunic    !pos -5.569 -34.781 151.762 166
--------------------------------------------
-- !setvar [CW]ON_THE_RANGE 8

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-------------------------------------------
local m = Module:new("cw_running_on_the_range")

local info =
{
    name   = "Running on the Range",
    author = "Carver",
    var    = "[CW]ON_THE_RANGE",
}

local DENTED_CROWN    = "DENTED_CROWN"
local RAGGED_TUNIC    = "RAGGED_TUNIC"
local RAGGED_MITTS    = "RAGGED_MITTS"
local RAGGED_SLACKS   = "RAGGED_SLACKS"
local RAGGED_PUMPS    = "RAGGED_PUMPS"
local ROASTED_REMAINS = "ROASTED_REMAINS"
local MALIGNANT_WORM  = "MALIGNANT_WORM"
local NEFARI          = "NEFARI"

local ARTIFACT_DIALOG =
{
    DEFAULT  = { "There is nothing out of the ordinary." },
    FINISH   =
    {
        { animation = 48, target = "player", duration = 3000 }, -- Crouch down
        { emotion = "retrieves the damaged artifact." }
    },
}

local entity =
{
    {
        id          = MALIGNANT_WORM,
        name        = "Malignant Worm",
        type        = xi.objType.MOB,
        look        = 426,
        groupId     = 8,   -- Land Worm (25-27)
        groupZoneId = 126, -- Qufim Island
        area        = "East_Ronfaure",
        pos         = { 761.758, -60.000, 399.168, 131 }, -- !pos 761.758 -60.000 399.168 101
        widescan    = 1,
        level       = 28,
    },
    {
        id          = ROASTED_REMAINS,
        name        = "Roasted Remains",
        marker      = cq.SIDE_QUEST,
        area        = "East_Ronfaure",
        pos         = { 761.758, -60.000, 399.168, 131 }, -- !pos 761.758 -60.000 399.168 101
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        }
    },
    {
        id     = DENTED_CROWN,
        name   = "Dented Crown",
        marker = cq.SIDE_QUEST,
        area   = "Ranguemont_Pass",
        pos    = { -133.655, -3.056, -95.489 }, -- !pos -133.655 -3.056 -95.489 166
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = RAGGED_MITTS,
        name   = "Ragged Mitts",
        marker = cq.SIDE_QUEST,
        area   = "Ranguemont_Pass",
        pos    = { 158.496, 5.310, -59.455 }, -- !pos 158.496 5.310 -59.455 166
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = RAGGED_SLACKS,
        name   = "Ragged Slacks",
        marker = cq.SIDE_QUEST,
        area   = "Ranguemont_Pass",
        pos    = { 140.592, 26.980, -210.136 }, -- !pos 140.592 26.980 -210.136 166
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = RAGGED_PUMPS,
        name   = "Ragged Pumps",
        marker = cq.SIDE_QUEST,
        area   = "Ranguemont_Pass",
        pos    = { -292.149, -46.143, 197.002 }, -- !pos -292.149 -46.143 197.002 166
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = RAGGED_TUNIC,
        name   = "Ragged Tunic",
        marker = cq.SIDE_QUEST,
        area   = "Ranguemont_Pass",
        pos    = { -5.569, -34.781, 151.762 }, -- !pos -5.569 -34.781 151.762 166
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = NEFARI,
        name   = "Nefari",
        type   = xi.objType.NPC,
        look = cexi.util.look({
            race = xi.race.HUME_F,
            face = 1,
            head = 0,
            body = cexi.model.ROYAL_SQUIRE,
            hand = cexi.model.ROYAL_SQUIRE,
            legs = cexi.model.ROYAL_SQUIRE,
            feet = cexi.model.ROYAL_SQUIRE,
        }),
        area   = "East_Ronfaure",
        pos    = { 811.301, -64.790, 656.182, 19 }, -- !pos 811.301 -64.790 656.182 101
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Get out of here! Quit wasting my time ..." },
            START    =
            {
                { emote = xi.emote.BOW },
                "Fellow adventurer, My name is Nefari.",
                " I've been contracted by the Kingdom to establish a new eco-system within the pass ahead.",
                { delay = 2000 },
                "My crew needs some help clearing out some old relics.",
                " If you are willing to give us a hand you can keep whatever you find.",
                "Before we start, though, you'll need to prove you're capable in battle.",
                { emote = xi.emote.LAUGH },
                { delay = 2000 },
                "See if you can find the Roasted Remains of our latest applicant nearby, then return to me for more instructions.",
            },
            REMINDER_NM = 
            {
                "See if you can find the Roasted Remains of our latest applicant nearby, then return to me for more instructions.",
            },
            STEP1 =
            {
                "Well, you've already made it further than poor Jeremiah, all right!",
                { emote = xi.emote.CHEER },
                { delay = 2000 },
                " The first artifact can be found just past the Granite Door inside Ranguemont Pass."
            },
            STEP2 =
            {
                "The second artifact can be found on the east side of the map.",
                "There are two on that side, make sure you retrieve the northern one first,",
                " then return to me.",
            },
            STEP3 =
            {
                "Great work, adventurer. Now retrieve the artifact on the southeast of the map and return to me.",
            },
            STEP4 =
            {
                "Great work, adventurer. Now retrieve the artifact from the northwest of the map and return to me.",
            },
            STEP5 =
            {
                "Great work, adventurer. Now retrieve the artifact from the northern part of the map and return to me.",
            },
            RENOVIO =
            {
                { emote = xi.emote.THINK },
                "This pile of scraps vaguely remind of the Garish Tunic attire.",
                " Take these items to Renovio in Selbina, perhaps he can restore them for you.",
                { delay = 1000 },
                { emote = xi.emote.GOODBYE },
            },
            AFTER = { "Take these items to Renovio in Selbina." },
        },
    },
}


local step =
{
    {
        check    = cq.checks({ CW = true, level = 30 }),
        [NEFARI] = cq.talkStep("START", info.name),
    },
    {
        [NEFARI] = cq.talkOnly("REMINDER_NM"),
        [ROASTED_REMAINS] = cq.spawnMob(MALIGNANT_WORM),
        [MALIGNANT_WORM]  = cq.killStep(ROASTED_REMAINS),
    },
    {
        [NEFARI]       = cq.talkOnly("STEP1"),
        [DENTED_CROWN] = cq.menuStep("You find a dented crown.", { { "Leave it." }, { "Pick it up.", "FINISH" } }, 2),
    },
    {
        [NEFARI]       = cq.talkOnly("STEP2"),
        [RAGGED_MITTS] = cq.menuStep("You find a pair of ragged mitts.", { { "Leave them." }, { "Pick them up.", "FINISH" } }, 2),
    },
    {
        [NEFARI]        = cq.talkOnly("STEP3"),
        [RAGGED_SLACKS] = cq.menuStep("You find a pair of ragged slacks.", { { "Leave them." }, { "Pick them up.", "FINISH" } }, 2),
    },
    {
        [NEFARI]       = cq.talkOnly("STEP4"),
        [RAGGED_PUMPS] = cq.menuStep("You find a pair of ragged pumps.", { { "Leave them." }, { "Pick them up.", "FINISH" } }, 2),
    },
    {
        [NEFARI]       = cq.talkOnly("STEP5"),
        [RAGGED_TUNIC] = cq.menuStep("You find a ragged tunic.", { { "Leave it." }, { "Pick it up.", "FINISH" } }, 2),
    },
    {
        [NEFARI] = cq.talkFinish("RENOVIO", info.name, cexi.music.NONE),
    },
    {
        [NEFARI] = cq.talkOnly("AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
