-----------------------------------
-- Rolling with Punches (Lv20)
-- Black and Blue (Requires Black Belt)
-----------------------------------
-- !setvar [CW]ROLLING_PUNCHES 0
-- Raving Fist   !pos 37.394 -8.136 53.857 249
-- !additem 541
-- Mating Ground !pos 198.176 -16.000 78.754 118
-- Raving Fist   !pos 37.394 -8.136 53.857 249
-- Reward: Cotton Tekko
-----------------------------------
-- !setvar [CW]ROLLING_PUNCHES 5

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-rolling_with_punches")

local info =
{
    name   = "Rolling With Punches",
    author = "Loxley",
    var    = "[CW]ROLLING_PUNCHES",
    reward =
    {
        item    = 12713,                    -- Cotton Tekko (Lv18)
        augment = { 512, 1, 25, 3, 32, 3 }, -- STR +2, Attack +4, Evasion -4
    },

    required =
    {
        item = 541,
        name = "a cup of dhalmel saliva",
    },
}

local FIST       = "FIST"
local RavingFist = "Raving Fist"
local GROUND     = "GROUND"
local ENRAGED    = "ENRAGED"
local FURIOUS    = "FURIOUS"
local SEETHING   = "SEETHING"

local entity =
{
    {
        id     = FIST,
        name   = RavingFist,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.A6,
            head = cexi.model.BRONZE_HARNESS,
            body = cexi.model.KENPOGI,
            hand = cexi.model.KENPOGI,
            legs = cexi.model.BRONZE_HARNESS,
            feet = cexi.model.KENPOGI,
        }),
        area   = "Mhaura",
        pos    = { 37.394, -8.136, 53.857, 34 }, -- !pos 37.394 -8.136 53.857 249
        dialog =
        {
            NAME     = true,
            DEFAULT  =
            {
                { emote = xi.emote.FUME },
                "Leave. Now.",
                { delay = 3000 },
            },
            START    =
            {
                "WOAH, WATCH WHERE YOU'RE GOING!",
                " You think you're tough huh? BAH!",
                { emote = xi.emote.LAUGH },
                "Let's see you knock out a dhalmel with your bare hands!",
                { emote = xi.emote.DOUBT },
                "Punch that thing until it's drooling and bring back a cup of saliva as proof!",
                " Or are you a wimp now?",
                { emote = xi.emote.LAUGH },
                { delay = 1000 },
            },
            REMINDER =
            {
                { emote = xi.emote.LAUGH },
                "Bring that cup of dhalmel saliva if you're so tough.",
            },
            ACCEPTED =
            {
                "Oh yeah!? Oh yeah!?",
                "Let's see you fight TWO... Uh, I mean THREE!! Dhalmels at the same time!",
                { emote = xi.emote.LAUGH },
                "Step foot in their Mating Ground and that'll really rile them up HAH!",
            },
            DECLINED   = { "What's this? Too scared now? All talk I see..." },
            REMINDER_2 = { "Not a word until you're done pal!" },
            AFTER      = {
                { emote = xi.emote.SHOCKED },
                "WHAT!! IMPOSSIBLE. I take it all back. I'm so~rry! I'm sorry!",
                { emote = xi.emote.SULK },
                "I was just kidding, boss! I promise!! Here, take these gloves...",
            },
            AFTER_2    = { "Good day, sir." },
            START_2    =
            {
                { emote = xi.emote.SHOCKED },
                "WOAH! Is that... a BLACK BELT?",
                "Boss, you've sure come a long way...",
                " Why it was like yesterday when you were here punching Dhalmels!",
                { emote = xi.emote.LAUGH },
                { delay = 2000 },
                "Erm... About that. Any chance you'd be up for MORE punching? ",
                { emote = xi.emote.THINK },
                { delay = 1000 },
                "Word is, the Dhalmel leader carries some blue necklace. ",
                " They say she roams around Tahrongi Canyon.",
                { emote = xi.emote.DOUBT },
                { delay = 2000 },
                "Knock that Dhalmel out cold, grab the necklace and I'll have something for you.",
            },
            DECLINED_2  = { "Wot? This ain't the blue necklace I want." },
            REMINDER_3  = { "Knock that Dhalmel out cold, grab the necklace and I'll have something for you." },
            AFTER_3     =
            {
                { emote = xi.emote.SHOCKED },
                "WOAH. So it's real...",
                { delay = 1000 },
                " The truth is, I was once an aspiring Black Belt myself.",
                { emote = xi.emote.SIGH },
                { delay = 2000 },
                "I never made the cut an' I guess... I always felt I had to prove somethin'",
                " I've been 'olding onta this far too long. It's yours now.",
                { emote = xi.emote.YES },
                { delay = 1000 },
                "You're a good sport though. Thanks for all the laughs.",
            },
            AFTER_4     = { "Good day, sir." },
        },
    },
    {
        id       = GROUND,
        name     = "Mating Ground",
        marker   = cq.SIDE_QUEST,
        area     = "Buburimu_Peninsula",
        pos      = { 198.176, -16.000, 78.754, 105 }, --!pos 198.176 -16.000 78.754 118
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            COLLECT =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                "You smother yourself with dhalmel pheromones.",
                { animate = 251, mode = 4 },
            },
        },
    },
    {
        id          = ENRAGED,
        name        = "Enraged Dhalmel",
        type        = xi.objType.MOB,
        look        = 332,
        flags       = 328,
        groupId     = 16,
        groupZoneId = 118,
        area        = "Buburimu_Peninsula",
        pos         = { 197.626, -16.000, 82.717, 62 }, --!pos 197.626, -16.000, 82.717 118
        widescan    = 1,
        level       = 14,
    },

    {
        id          = FURIOUS,
        name        = "Furious Dhalmel",
        type        = xi.objType.MOB,
        look        = 332,
        flags       = 328,
        groupId     = 16,
        groupZoneId = 118,
        area        = "Buburimu_Peninsula",
        pos         = { 194.704, -15.936, 80.669, 21 }, --!pos 194.704 -15.936 80.669 118
        widescan    = 1,
        level       = 14,
    },

    {
        id          = SEETHING,
        name        = "Seething Dhalmel",
        type        = xi.objType.MOB,
        look        = 332,
        flags       = 328,
        groupId     = 16,
        groupZoneId = 118,
        area        = "Buburimu_Peninsula",
        pos         = { 201.673, -16.000, 79.509, 118 }, --!pos 201.673 -16.000 79.509 118
        widescan    = 1,
        level       = 14,
    },
}

local dhalmels = { ENRAGED, FURIOUS, SEETHING }

local step =
{
    {
        check   = cq.checks({ CW = true, level = 20 }),
        [FIST] = cq.talkStep("START", info.name),
    },
    {
        [FIST] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("ACCEPTED", "DECLINED", info.required.item),
        },
    },
    {
        [FIST]     = cq.talkOnly("REMINDER_2"),
        [GROUND]   = cq.menuSpawn(dhalmels, "Stand your ground?", { { "I'm a wimp." }, { "Bring it on!" } }, 2 ),
        [ENRAGED]  = cq.killStep(GROUND, dhalmels),
        [FURIOUS]  = cq.killStep(GROUND, dhalmels),
        [SEETHING] = cq.killStep(GROUND, dhalmels),
    },
    {
        [GROUND] = cq.talkStep("COLLECT"),
    },
    {
        [GROUND] = cq.talkOnly("AFTER"),
        [FIST]   = cq.giveStep("AFTER", info.reward, info.name, cexi.music.MHAURA),
    },
    {
        [FIST] = cq.checkStep("START_2", "AFTER_2", "Black and Blue", { item = xi.item.BLACK_BELT }),
    },
    {
        [FIST] =
        {
            onTrigger = cq.talkOnly("REMINDER_3"),
            onTrade   = cq.tradeStep("AFTER_3", "DECLINED_2", xi.item.CERULEAN_PENDANT, { item = xi.item.BROWN_BELT }, "Black and Blue", cexi.music.MHAURA),
        },
    },
    {
        [FIST] = cq.talkOnly("AFTER_4")
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
