-----------------------------------
-- Rock Cooking (Lv1)
-----------------------------------
-- !setvar [CW]ROCK_COOKING 0
-- Dusty Footprint !pos -332.270 -8.000 394.271 11
-- !additem 656 12
-- !additem 1654
-- Reward: Various rocks
-----------------------------------
-- !setvar [CW]ROCK_COOKING 3

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-rock_cooking")

local info =
{
    name   = "Rock Cooking",
    author = "Loxley",
    var    = "[CW]ROCK_COOKING",
    reward =
    {
        gil = 300,

        after = function(player)
            player:printToPlayer("You have unlocked Smolderoq's services in Oldton Movalpolos!", xi.msg.channel.SYSTEM_3)
            return true
        end,
    },
    exchange =
    {
        [xi.item.IGNEOUS_ROCK] =
        {
            { cexi.rate.VERY_COMMON, 2531, "a shard of obsidian"   }, --  (24%)
            { cexi.rate.COMMON,       736, "a chunk of silver ore" }, --  (15%)
            { cexi.rate.COMMON,       788, "a peridot"             }, --  (15%)
            { cexi.rate.UNCOMMON,     798, "a turqouise"           }, --  (10%)
            { cexi.rate.RARE,         790, "a garnet"              }, --  ( 5%)
            { cexi.rate.RARE,         811, "an ametrine"           }, --  ( 5%)
            { cexi.rate.RARE,         815, "a sphene"              }, --  ( 5%)
            { cexi.rate.RARE,         798, "a turqouise"           }, --  ( 5%)
            { cexi.rate.RARE,         808, "a goshenite"           }, --  ( 5%)
            { cexi.rate.RARE,         799, "an onyx"               }, --  ( 5%)
            { cexi.rate.RARE,         796, "a light opal"          }, --  ( 5%)
            { cexi.rate.VERY_RARE,   2840, "an imperial topaz"     }, --  ( 1%)
            { cexi.rate.SUPER_RARE,   787, "a diamond"             }, -- (0.5%)
        }
    },
}

local FOOTPRINT = "FOOTPRINT"
local Smolderoq = "Smolderoq"
local DustyFoot = "Dusty_Footprint"

local entity =
{
    {
        id       = FOOTPRINT,
        name     = "Dusty Footprint",
        marker   = cq.SIDE_QUEST,
        area     = "Oldton_Movalpolos",
        pos      = { -332.270, -8.000, 394.271, 120 },-- !pos -332.270 -8.000 394.271
        from     = Smolderoq,
        dialog   =
        {
            DEFAULT =
            {
                "Ash is scattered over the ground.",
                "You may have to look closer...",
            },
            START   =
            {
                { despawn = { DustyFoot } },
                { spawn   = { Smolderoq } },
                { delay   = 500 },
                "Smolderoq : Oi, you! What you doin' in my kitchen!",
                { delay   = 2000 },

                "Smolderoq : What do I cook? Anythin' lyin' around... mostly rocks",
                "Smolderoq : Don't gimme that look overgrounder!",
                " Don't you even know how to cook a rock!?",
                { delay = 2000 },

                "Smolderoq : Hold up. You think this knowledge comes cheap?",
                "Smolderoq : First I'm gonna need payment for this very exclusive know-how!",
                " And I don't want none of your people money neither!",
                { delay   = 3000 },
                "Smolderoq : Let's say... 12 beastcoins and I'll spill the beans.",
                { delay   = 500 },
                { despawn = { Smolderoq } },
                { spawn   = { DustyFoot } },
            },

            REMINDER   = { "Smolderoq : Gimme 12 beastcoins exactly." },
            OTHER      = { "Smolderoq : Whaa? 'member now, it's 12 beastcoins or nuthin'!" },
            PAYMENT    = { "Smolderoq : Coins! Awright I'll show how. Gimme one igneous rock." },

            ROCKMINDER = { "Smolderoq : Gimme one igneous rock and I'll shows ya how it's done." },
            DECLINED   = { "Smolderoq : What's this junk? Come back with a real rock." },
        },
    },
    {
        id     = "MOBLIN",
        name   = Smolderoq,
        type   = xi.objType.NPC,
        hidden = true,
        look   = 699,
        area   = "Oldton_Movalpolos",
        pos    = { -332.270, -8.000, 394.271, 120 }, -- !pos -332.270 -8.000 394.271 11
    },
}

local step =
{
    {
        [FOOTPRINT] = cq.talkStep("DEFAULT"),
    },
    {
        [FOOTPRINT] = cq.menuStep("Investigate further?", { { "Yes", "START" }, { "No" } }, 1, info.name),
    },
    {
        [FOOTPRINT] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("PAYMENT", "OTHER", { { xi.item.BEASTCOIN, 12 } }, info.reward, info.name, cexi.music.MOVALPOLOS),
        },
    },
    {
        [FOOTPRINT] =
        {
            onTrigger = cq.talkOnly("ROCKMINDER"),
            onTrade   = cq.trade({
                quest    = info.name,
                music    = cexi.music.MOVALPOLOS,
                tally    = info.tally,
                name     = Smolderoq,
                step     = false,
                exchange = info.exchange,
                accepted =
                {
                   { despawn = { DustyFoot } },
                    { delay   = 500 },
                    { spawn   = { Smolderoq } },
                    { delay   = 2000 },
                    "Awright, let's cook this one up and see what comes out!",
                    { delay = 1000 },
                    { entity = Smolderoq, packet = "cabk" },
                    { delay = 3000 },
                    { entity = Smolderoq, animate = 892, target= "player" },
                    { entity = Smolderoq, packet = "shbk" },
                    "Well, well, look at that!",
                    { delay   = 1000 },
                    { despawn = { Smolderoq } },
                    { delay   = 500 },
                    { spawn   = { DustyFoot } },
                },
                declined =
                {
                    "What's this junk? Come back with a real rock.",
                },
            }),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
