--------------------------------------------------------------
-- Negotiating the Necropolis -- Eisenbrust (Plate) Set (Lv30)
--------------------------------------------------------------
-- !setvar [CW]NECROPOLIS 0
-- Aletta              !pos 386.955 -40.000 30.508 195
-- Scarred Remains     !pos 210.087 4.806 -503.726 105
-- Damaged Sallet      !pos 265.288 -32.000 -51.558 195
-- Damaged Gauntlets   !pos 91.445 -32.000 -54.629 195
-- Damaged Hose        !pos 107.995 -32.000 94.757 195
-- Damaged Greaves     !pos 251.691 -32.000 94.879 195
-- Damaged Breastplate !pos 171.633 -8.000 25.339 195
--------------------------------------------------------------
-- !setvar [CW]NECROPOLIS 14

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
--------------------------------------------------------------
local m = Module:new("cw_negotiating_the_necropolis")

local info =
{
    name   = "Negotiating the Necropolis",
    author = "Carver",
    var    = "[CW]NECROPOLIS",
}

local DAMAGED_SALLET      = "DAMAGED_SALLET"
local DAMAGED_BREASTPLATE = "DAMAGED_BREASTPLATE"
local DAMAGED_GAUNTLETS   = "DAMAGED_GAUNTLETS"
local DAMAGED_HOSE        = "DAMAGED_HOSE"
local DAMAGED_GREAVES     = "DAMAGED_GREAVES"
local SCARRED_REMAINS     = "SCARRED_REMAINS"
local OSU                 = "OSU"
local ALETTA              = "ALETTA"

local ARTIFACT_DIALOG =
{
    DEFAULT  = { "There is nothing out of the ordinary." },
    FINISH   =
    {
        { animation = 48, target = "player", duration = 3000 }, -- Crouch down
        { emotion = "retrieves the damaged artifact." }
    },
}

local entity =
{
    {
        id          = SCARRED_REMAINS,
        name        = "Scarred Remains",
        marker      = cq.SIDE_QUEST,
        area        = "Batallia_Downs",
        pos         = { 210.087, 4.806, -503.726 }, -- !pos 210.087 4.806 -503.726 105
        widescan    = 1,
        dialog      =
        {
            DEFAULT      = { "There is nothing out of the ordinary here." },
            TERRIBLE_LIE =
            {
                { entity = "player", emote = xi.emote.THINK },
                "After defeating the Osu, you discover the true fate of Aletta's Husband.",
                " But you don't have the heart to tell her.",
                { delay = 2000 },
                "You decide to return to her, and give her hope ...",
            },
        }
    },
    {
        id          = OSU,
        name        = "Osu",
        type        = xi.objType.MOB,
        look        = 272,
        groupId     = 97,
        groupZoneId = 98,
        area        = "Batallia_Downs",
        pos         = { 210.087, 4.806, -503.726, 180 }, -- !pos 210.087 4.806 -503.726 105
        widescan    = 1,
        level       = 28,
    },
    {
        id     = ALETTA,
        name   = "Aletta",
        type   = xi.objType.NPC,
        look = cexi.util.look({
            race = xi.race.ELVAAN_F,
            face = 3,
            head = 0,
            body = cexi.model.ADAMAN_CUIRASS,
            hand = cexi.model.ADAMAN_CUIRASS,
            legs = cexi.model.ADAMAN_CUIRASS,
            feet = cexi.model.ADAMAN_CUIRASS,
        }),
        area   = "The_Eldieme_Necropolis",
        pos    = { 386.955, -40.000,  30.508, 92 }, -- !pos 386.955 -40.000 30.508 195
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "My poor Asher ... I await his safe return..." },
            REMINDER = { "Take those artifacts to Steel Teeth in Mhaura to get those pieces back into shape." },
            START    =
            {
                { emote = xi.emote.SIGH },
                "My dear husband Asher and I came to explore the tombs in search of some old relics.",
                " One clue we recovered sent him searching in the southern tip of Batallia Downs.",
                { delay = 2000 },
                "But he's been gone for far too long. Will you find him for me?",
                { emote = xi.emote.CRY },
                { delay = 3000 },
            },
            STEP1 =
            {
                "Thank Altana! You've found him? Bless you brave adventurer. These old relics should be yours!",
                " The first piece can be found in the south-eastern part of the necropolis.",
                { emote = xi.emote.CHEER },
            },
            STEP2 =
            {
                "The second piece can be found in the south-western part of the necropolis.",
                { emote = xi.emote.PSYCH },
            },
            STEP3 =
            {
                "The third piece can be found in the north-western part of the necropolis.",
                { emote = xi.emote.CHEER },
            },
            STEP4 =
            {
                "The fourth piece can be found in the north-eastern part of the necropolis.",
                { emote = xi.emote.PSYCH },
            },
            STEP5 = 
            {
                "The final piece of the set rests somewhere in the caves at the bottom of this hellhole.",
                { emote = xi.emote.CHEER },
            },
            STEEL_TEETH =
            {
                "Hmmm..",
                { emote = xi.emote.THINK },
                " Amazing you were able to recover all of these items.",
                "Take them to Steel Teeth in Mhaura.",
                " If anyone can restore these, it would definitely be him!",
            },
        },
    },
    {
        id     = DAMAGED_SALLET,
        name   = "Damaged Sallet",
        marker = cq.SIDE_QUEST,
        area   = "The_Eldieme_Necropolis",
        pos    = { 265.288, -32.000, -51.558 }, -- !pos 265.288 -32.000 -51.558 195
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = DAMAGED_GAUNTLETS,
        name   = "Damaged Gauntlets",
        marker = cq.SIDE_QUEST,
        area   = "The_Eldieme_Necropolis",
        pos    = { 91.445, -32.000, -54.629 }, -- !pos 91.445 -32.000 -54.629 195
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = DAMAGED_HOSE,
        name   = "Damaged Hose",
        marker = cq.SIDE_QUEST,
        area   = "The_Eldieme_Necropolis",
        pos    = { 107.995, -32.000, 94.757 }, -- !pos 107.995 -32.000 94.757 195
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = DAMAGED_GREAVES,
        name   = "Damaged Greaves",
        marker = cq.SIDE_QUEST,
        area   = "The_Eldieme_Necropolis",
        pos    = { 251.691, -32.000, 94.879 }, -- !pos 251.691 -32.000 94.879 195
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = DAMAGED_BREASTPLATE,
        name   = "Damaged Breastplate",
        marker = cq.SIDE_QUEST,
        area   = "The_Eldieme_Necropolis",
        pos    = { 171.633, -8.000, 25.339 }, -- !pos 171.633 -8.000 25.339 195
        dialog = ARTIFACT_DIALOG,
    },
}

local step =
{
    {
        check    = cq.checks({ CW = true, level = 30 }),
        [ALETTA] = cq.talkStep("START", info.name),
    },
    {
        [ALETTA]          = cq.talkOnly("START"),
        [SCARRED_REMAINS] = cq.spawnMob(OSU),
        [OSU]             = cq.killStep(SCARRED_REMAINS),
    },
    {
        [SCARRED_REMAINS] = cq.talkStep("TERRIBLE_LIE")
    },
    {
        [ALETTA] = cq.talkStep("STEP1"),
    },
    {
        [ALETTA]         = cq.talkOnly("STEP1"),
        [DAMAGED_SALLET] = cq.menuStep("You find a damaged sallet.", { { "Leave it." }, { "Pick it up.", "FINISH" } }, 2),
    },
    {
        [ALETTA] = cq.talkStep("STEP2"),
    },
    {
        [ALETTA]            = cq.talkOnly("STEP2"),
        [DAMAGED_GAUNTLETS] = cq.menuStep("You find damaged gauntlets.", { { "Leave them." }, { "Pick it them.", "FINISH" } }, 2),
    },
    {
        [ALETTA] = cq.talkStep("STEP3"),
    },
    {
        [ALETTA]       = cq.talkOnly("STEP3"),
        [DAMAGED_HOSE] = cq.menuStep("You find a pair of damaged hose.", { { "Leave them." }, { "Pick it them.", "FINISH" } }, 2),
    },
    {
        [ALETTA] = cq.talkStep("STEP4"),
    },
    {
        [ALETTA]          = cq.talkOnly("STEP4"),
        [DAMAGED_GREAVES] = cq.menuStep("You find damaged greaves.", { { "Leave them." }, { "Pick it them.", "FINISH" } }, 2),
    },
    {
        [ALETTA] = cq.talkStep("STEP5"),
    },
    {
        [ALETTA]              = cq.talkOnly("STEP5"),
        [DAMAGED_BREASTPLATE] = cq.menuStep("You find a damaged breastplate.", { { "Leave it." }, { "Pick it up.", "FINISH" } }, 2),
    },
    {
        [ALETTA] = cq.talkFinish("STEEL_TEETH", info.name, cexi.music.NONE),
    },
    {
        [ALETTA] = cq.talkOnly("REMINDER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
