------------------------------------------
-- Navigating the Nest -- Noct  Set (Lv30)
------------------------------------------
-- !setvar [CW]NAVIGATE_NEST 0
-- Bella          !pos 130.955 -32.915 -70.073 197
-- Buried Beret   !pos 121.949 -32.599 37.025 197
-- Buried Gloves  !pos 49.99 -0.803 187.910 197
-- Buried Brais   !pos 17.088 -0.534 286.904 197
-- Buried Boots   !pos -62.976 -0.525 247.013 197
-- Buried Doublet !pos -698.62 -26.954 -404.009 110
------------------------------------------
-- !setvar [CW]NAVIGATE_NEST 13

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-------------------------------------------
local m = Module:new("cw_navigating_the_nest")

local info =
{
    name   = "Navigating the Nest",
    author = "Carver",
    var    = "[CW]NAVIGATE_NEST",
}

local BURIED_BERET   = "BURIED_BERET"
local BURIED_DOUBLET = "BURIED_DOUBLET"
local BURIED_GLOVES  = "BURIED_GLOVES"
local BURIED_BRAIS   = "BURIED_BRAIS"
local BURIED_BOOTS   = "BURIED_BOOTS"
local MISURGH        = "MISURGH"
local BELLA          = "BELLA"
local LARPING_LARZY  = "LARPING_LARZY"

local ARTIFACT_DIALOG =
{
    DEFAULT  = { "There is nothing out of the ordinary." },
    FINISH   =
    {
        { animation = 48, target = "player", duration = 3000 }, -- Crouch down
        { emotion = "retrieves the damaged artifact." }
    },
}

local entity =
{
    {
        id          = MISURGH,
        name        = "Misurgh",
        type        = xi.objType.MOB,
        groupId     = 120,
        groupZoneId = 77,
        area        = "Rolanberry_Fields",
        pos         = { -698.62, -26.954, -404.00, 156 }, -- !pos -698.62 -26.954 -404.00 110
        widescan    = 1,
        level       = 28,
    },
    {
        id          = LARPING_LARZY,
        name        = "Larping Larzy",
        look        = 328,
        type        = xi.objType.MOB,
        groupId     = 29,
        groupZoneId = 107,
        area        = "Crawlers_Nest",
        pos         = { 146.789, -32.275, -92.022, 156 }, -- !pos 146.789 -32.275 -92.022 197
        widescan    = 1,
        level       = 28,
    },
    {
        id   = BELLA,
        name = "Bella",
        type = xi.objType.NPC,
        look = cexi.util.look({
            race = xi.race.MITHRA,
            face = 3,
            head = 0,
            body = cexi.model.COEURL_JERKIN,
            hand = cexi.model.COEURL_JERKIN,
            legs = cexi.model.COEURL_JERKIN,
            feet = cexi.model.COEURL_JERKIN,
        }),
        area   = "Crawlers_Nest",
        pos    = { 130.955, -32.915, -70.073, 107 }, -- !pos 130.955 -32.915 -70.073 197
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "I've had it with these lizards!" },
            REMINDER = { "Take the artifacts to Renovia in Selbina to patch these pieces back together." },
            START    =
            {
                "Hey, You look an aspiring adventurer! These lizards have me pinned down and I'm due home for supper.",
                " Look out! There's another one behind you!",
                { emote = xi.emote.PANIC },
            },
            STEP1 =
            {
                { emote = xi.emote.BOW },
                "Whoa! You really saved my skin there! How could I ever repay you? Tell you what...",
                { delay = 3000 },
                "There are a few artifacts scattered throughout the nest. Seek them out and I'll give you a handsome reward.",
                " The first piece can be found nearby in a room full of scorpions.",
            },
            AFTER = { "The first piece can be found nearby in a room full of scorpions." },
            STEP2 =
            {
                "The second piece can be found just over a ledge within the nest.",
                { emote = xi.emote.PSYCH },
            },
            STEP3 =
            {
                "The third piece can be found just over a ledge within the nest.",
                { emote = xi.emote.CHEER },
            },
            STEP4 =
            {
                "The fourth piece can be found just over a ledge within the nest.",
                { emote = xi.emote.PSYCH },
            },
            STEP5 = 
            {
                "The final piece of the set rests all the way through the nest in Rolanberry Fields.",
                { emote = xi.emote.CHEER },
            },
            RENOVIO =
            {
                "Hmmm..",
                { emote = xi.emote.SIGH },
                " These are in far worse condition than I could have ever imagined.",
                { delay = 3000 },
                "Take them to Renovio in Selbina. If anyone can restore these, it would definitely be him!",
            },
        },
    },
    {
        id     = BURIED_BERET,
        name   = "Buried Beret",
        marker = cq.SIDE_QUEST,
        area   = "Crawlers_Nest",
        pos    = { 121.949, -32.599, 37.025 }, -- !pos 121.949 -32.599 37.025 197
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = BURIED_GLOVES,
        name   = "Buried Gloves",
        marker = cq.SIDE_QUEST,
        area   = "Crawlers_Nest",
        pos    = { 49.99, -0.803, 187.910 }, -- !pos 49.99 -0.803 187.910 197
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = BURIED_BRAIS,
        name   = "Buried Brais",
        marker = cq.SIDE_QUEST,
        area   = "Crawlers_Nest",
        pos    = { 17.088, -0.534, 286.904 }, -- !pos 17.088 -0.534 286.904 197
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = BURIED_BOOTS,
        name   = "Buried Boots",
        marker = cq.SIDE_QUEST,
        area   = "Crawlers_Nest",
        pos    = { -62.976, -0.525, 247.013 }, -- !pos -62.976 -0.525 247.013 197
        dialog = ARTIFACT_DIALOG,
    },
    {
        id     = BURIED_DOUBLET,
        name   = "Buried Doublet",
        marker = cq.SIDE_QUEST,
        area   = "Rolanberry_Fields",
        pos    = { -698.62, -26.954, -404.009 }, -- !pos -698.62 -26.954 -404.009 110
        dialog = ARTIFACT_DIALOG,
    },
}

local step =
{
    {
        [BELLA]         = cq.spawnMob(LARPING_LARZY, "START", false, { levelCap = 40 }),
        [LARPING_LARZY] = cq.killStep(),
    },
    {
        [BELLA] = cq.talkStep("STEP1", info.name)
    },
    {
        [BELLA]        = cq.talkOnly("AFTER"),
        [BURIED_BERET] = cq.menuStep("Dig out the buried beret?", { { "No" }, { "Yes", "FINISH" } }, 2),
    },
    {
        [BELLA] = cq.talkStep("STEP2"),
    },
    {
        [BELLA]         = cq.talkOnly("STEP2"),
        [BURIED_GLOVES] = cq.menuStep("Dig out the buried gloves?", { { "No" }, { "Yes", "FINISH" } }, 2),
    },
    {
        [BELLA] = cq.talkStep("STEP3"),
    },
    {
        [BELLA]        = cq.talkOnly("STEP3"),
        [BURIED_BRAIS] = cq.menuStep("Dig out the buried brais?", { { "No" }, { "Yes", "FINISH" } }, 2),
    },
    {
        [BELLA] = cq.talkStep("STEP4"),
    },
    {
        [BELLA]        = cq.talkOnly("STEP4"),
        [BURIED_BOOTS] = cq.menuStep("Dig out the buried boots?", { { "No" }, { "Yes", "FINISH" } }, 2),
    },
    {
        [BELLA] = cq.talkStep("STEP5"),
    },
    {
        [BELLA]           = cq.talkOnly("STEP5"),
        [BURIED_DOUBLET]  = cq.spawnMob(MISURGH),
        [MISURGH]         = cq.killStep(BURIED_DOUBLET)
    },
    {
        [BURIED_DOUBLET] = cq.menuStep("Dig out the buried doublet?", { { "No" }, { "Yes", "FINISH" } }, 2),
    },
    {
        [BELLA] = cq.talkFinish("RENOVIO", info.name, cexi.music.NONE),
    },
    {
        [BELLA] = cq.talkOnly("REMINDER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
