-----------------------------------
-- Likely Tails (Lv10)
-----------------------------------
-- !setvar [CW]LIKELY_TAILS 0
-- Mithra Tracks !pos 366.220 -9.068 -85.519 117
-- !additem 542
-- Reward: Cotton Cape
-----------------------------------
-- !setvar [CW]LIKELY_TAILS 2

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-head_first")

local info =
{
    name   = "Likely Tails",
    author = "Loxley",
    var    = "[CW]LIKELY_TAILS",
    reward =
    {
        item    = 13584,            -- Cotton Cape
        augment = { 9, 4, 516, 0 }, -- MP +5, INT +1
    },
    required = 
    {
        item = 542,
        name = "a wild rabbit tail",
    },
}

local SHURHU       = "SHURHU"
local Shu          = "Shu Rhuli"
local SHU_TRACKS   = "SHU_TRACKS"
local Tracks       = "Mithra Tracks"

local entity =
{
    {
        id       = SHU_TRACKS,
        name     = Tracks,
        marker   = cq.SIDE_QUEST,
        area     = "Tahrongi_Canyon",
        pos      = { 366.220, -9.068, -85.519, 150 },-- !pos 366.220 -9.068 -85.519 117
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            START   =
            {
                { despawn = { Tracks } },
                { spawn   = { Shu } },
                { delay   = 500 },
                { entity  = Shu, face = "player" },
                { delay   = 1500 },
                "Shu Rhuli : Hearrrd about wild rabbit tails? I've been told they brrrring good luck.",
                { entity  = Shu, emote = xi.emote.THINK },
                { delay   = 2000 },
                "Shu Rhuli : I came here in searrr~ch but Buburimu Peninsula seems much too dangerous.",
                " Brrr~ing me a wild rarab tail and I'll rewarrr~d you.",
                { delay   = 500 },
                { despawn = { Shu } },
                { spawn   = { Tracks } },
            },
            REMINDER = { "Shu Rhuli : Brrr~ing me a wild rarab tail and I'll rewarrr~d you." },
            ACCEPTED =
            {
                { despawn = { Tracks } },
                { spawn   = { Shu } },
                { delay   = 500 },
                { entity  = Shu, face = "player" },
                { delay   = 1500 },
                { entity  =  Shu, emote = xi.emote.THINK },
                "Shu Rhuli : This is the one. Verrry well, he~rrre's your reward.",
                { delay   = 2000 },
                { delay   = 500 },
                { despawn = { Shu } },
                { spawn   = { Tracks } },
            },
            AFTER = { "Whoever was here is long gone..." },
        },
    },
    {
        id     = SHURHU,
        name   = Shu,
        type   = xi.objType.NPC,
        hidden = true,
        area   = "Tahrongi_Canyon",
        pos    = { 366.220, -9.068, -85.519, 150 },-- !pos 366.220 -9.068 -85.519 117
        look   = cexi.util.look({
            race = xi.race.MITHRA,
            face = cexi.model.A4,
            head = cexi.model.ROBE,
            body = cexi.model.DOUBLET,
            hand = cexi.model.TUNIC,
            legs = cexi.model.DOUBLET,
            feet = cexi.model.DOUBLET,
        }),
    },
}

local step =
{
    {
        check        = cq.checks({ CW = true, level = 10 }),
        [SHU_TRACKS] = cq.talkStep("START", info.name),
    },
    {
        [SHU_TRACKS] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("ACCEPTED", "REMINDER", info.required.item, info.reward, info.name, cexi.music.NONE),
        },
    },
    {
        [SHU_TRACKS] = cq.talkOnly("AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
