-----------------------------------
-- Here be dragon (Gustav Tunnel Mining)
-----------------------------------
-- !setvar [CW]HERE_BE_DRAGONS 0
-- Khartes        !pos 53.340 -15.273 9.958 248
-- Miner's Helmet !pos -228.663 -21.546 -252.635 212
-----------------------------------
require("modules/module_utils")
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_here_be_dragons")

local info =
{
    name     = "Here be dragons",
    author   = "Loxley",
    var      = "[CW]HERE_BE_DRAGONS",
    reward =
    {
        item  = xi.item.DRAGON_CHRONICLES,
        after = function(player)
            player:setCharVar("[CW]GT_MINING", 1)
            player:sys("You have unlocked the ability to perform Mining in Gustav Tunnel.")
            return true
        end,
    },
}

local KHARTES       = "KHARTES"
local MINERS_HELMET = "MINERS_HELMET"
local ORE_MELTER    = "ORE_MELTER"

local entity  =
{
    {
        id     = KHARTES,
        name   = "Khartes",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.HUME_M,
            face = cexi.face.B1,
            main = 266,
            body = cexi.model.DOUBLET,
            hand = cexi.model.DOUBLET,
            legs = cexi.model.DOUBLET,
            feet = cexi.model.DOUBLET,
        }),
        area   = "Selbina",
        pos    = { 53.340, -15.273, 9.958, 157 }, -- !pos 53.340 -15.273 9.958 248
        dialog =
        {
            DEFAULT =
            {
                "Khartes : This town may not look like much, but it's a great place to start a big adventure!",
            },
            FINISH =
            {
                "Khartes : Woah! You really fought a dragon all by yourself!?",
                { emote = xi.emote.HUH },
                " I think I'll stay put and get a bit more experience before I wander in there!",
            },
        },
    },
    {
        id          = MINERS_HELMET,
        name        = "Miner's Helmet",
        marker      = cq.SIDE_QUEST,
        area        = "Gustav_Tunnel",
        pos         = { -228.663, -21.546, -252.635, 227 }, -- !pos -228.663 -21.546 -252.635 212
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id          = ORE_MELTER,
        name        = "Ore Melter",
        type        = xi.objType.MOB,
        groupId     = 21,
        groupZoneId = 205,
        area        = "Gustav_Tunnel",
        pos         = { -228.663, -21.546, -252.635, 227 }, -- !pos -228.663 -21.546 -252.635
        level       = 35,
    },
}

local step =
{
    {
        check     = cq.checks({ cw = true, level = 40 }),
        [KHARTES] = cq.dialog({
            name  = "Khartes",
            quest = info.name,
            event =
            {
                { delay = 500 },
                { emote = xi.emote.SHOCKED },
                "Oh hey! You caught me by surprise.",
                " Have you been down to Gustav Tunnel by any chance? ",
                { emote = xi.emote.THINK },
                { delay = 1000 },
                " Supposedly it's filled with valuable rocks... but the locals said there are dragons guarding it!",
                "Could you go check it out for me?",
            },
        }),
    },
    {
        [KHARTES] = cq.dialog({
            name  = "Khartes",
            step  = false,
            event =
            {
                "Hey, have you checked out Gustav Tunnel yet?",
            },
        }),
        [MINERS_HELMET] = cq.menuSpawn(ORE_MELTER, "Pick up the helmet?", { { "No way!" }, { "Let's have a closer look..." } }, 2),
        [ORE_MELTER]    = cq.killStep(MINERS_HELMET),
    },
    {
        [KHARTES] = cq.giveStep("FINISH", info.reward, info.name, cexi.music.SELBINA),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
