-----------------------------------
-- Helping Hands (Lv20)
-----------------------------------
-- !setvar [CW]HELPING_HANDS 0
-- Manusiel       !pos 65.078 -15.273 7.888 248
-- !additem 537
-- Damselfly Eggs !pos -24.995 -13.077 217.090 103
-- Manusiel       !pos 65.078 -15.273 7.888 248
-- Reward: Lizard Gloves
-----------------------------------
-- !setvar [CW]HELPING_HANDS 5

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-helping_hands")

local info =
{
    name   = "Helping Hands",
    author = "Loxley",
    var    = "[CW]HELPING_HANDS",
    reward =
    {
        item    = 12697,                    -- Lizard Gloves (Lv17)
        augment = { 1, 4, 513, 1, 518, 1 }, -- HP +5, DEX +2, CHR +2
    },

    required =
    {
        item = 537,
        name = "a damselfly worm",
    },
}

local MANUS    = "MANUS"
local Manusiel = "Manusiel"
local EGGS     = "EGGS"
local LARVAE_1 = "LARVAE_1"
local LARVAE_2 = "LARVAE_2"
local LARVAE_3 = "LARVAE_3"

local entity =
{
    {
        id     = MANUS,
        name   = Manusiel,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A1,
            head = cexi.model.LIZARD_JERKIN,
            body = cexi.model.LIZARD_JERKIN,
            hand = cexi.model.KENPOGI,
            legs = cexi.model.HARA_ATE,
            feet = cexi.model.KENPOGI,
        }),
        area   = "Selbina",
        pos    = { 65.078, -15.273, 7.888, 161 }, -- !pos 65.078 -15.273 7.888 248
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "I'm here on very important research." },
            START    =
            {
                "I'm here studying the fauna of Zulkheim.",
                { emote = xi.emote.THINK },
                " In particular, I've an interest in the native Damselfly.",
                "Please bring me any related items so I can examine them.",
            },
            REMINDER = { "Please bring me any Damselfly related items so I can examine them." },
            ACCEPTED =
            {
                "Fascinating. I wonder if this parasite is present in the larval stage?",
                { emote = xi.emote.THINK },
                "Give me a hand by collecting some Damselfly Eggs and I'll return the favor.",
            },
            DECLINED   = { "Sorry, this isn't what I'm looking for." },
            REMINDER_2 = { "Give me a hand by collecting some Damselfly Eggs and I'll return the favor." },
            AFTER      = {
                { emote = xi.emote.PRAISE },
                "Yes, this is it! I can finally continue my research.",
            },
        },
    },
    {
        id       = EGGS,
        name     = "Damselfly Eggs",
        type     = xi.objType.NPC,
        look     = cq.marker.SPARKLE,
        hidename = true,
        area     = "Valkurm_Dunes",
        pos      = { -24.995, -13.077, 217.090, 83 }, --!pos -24.995 -13.077 217.090 103
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            COLLECT =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion   = "collects the Damselfly Eggs." },
            },
        },
    },
    {
        id          = LARVAE_1,
        name        = "Damselarva",
        type        = xi.objType.MOB,
        look        = 449,
        flags       = 328,
        groupId     = 12,
        groupZoneId = 103,
        area        = "Valkurm_Dunes",
        pos         = { -26.884, -12.860, 216.183, 27 }, --!pos -26.884 -12.860 216.183 103
        widescan    = 1,
        level       = 18,
    },
    {
        id          = LARVAE_2,
        name        = "Damselarvae",
        type        = xi.objType.MOB,
        look        = 449,
        flags       = 328,
        groupId     = 12,
        groupZoneId = 103,
        area        = "Valkurm_Dunes",
        pos         = { -24.995, -13.077, 217.090, 83 }, --!pos -24.995 -13.077 217.090 103
        widescan    = 1,
        level       = 18,
    },
    {
        id          = LARVAE_3,
        name        = "Damselarval",
        type        = xi.objType.MOB,
        look        = 449,
        flags       = 328,
        groupId     = 12,
        groupZoneId = 103,
        area        = "Valkurm_Dunes",
        pos         = { -23.566, -13.106, 215.611, 104 }, --!pos -23.566 -13.106 215.611 103
        widescan    = 1,
        level       = 18,
    },
}

local flies = { LARVAE_1, LARVAE_2, LARVAE_3 }

local step =
{
    {
        check   = cq.checks({ CW = true, level = 20 }),
        [MANUS] = cq.talkStep("START", info.name),
    },
    {
        [MANUS] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("ACCEPTED", "DECLINED", info.required.item),
        },
    },
    {
        [MANUS]    = cq.talkOnly("REMINDER_2"),
        [EGGS]     = cq.menuSpawn(flies, "Pick up the eggs?", { { "Take the plunge." }, { "This looks gross." } }, 1 ),
        [LARVAE_1] = cq.killStep(EGGS, flies),
        [LARVAE_2] = cq.killStep(EGGS, flies),
        [LARVAE_3] = cq.killStep(EGGS, flies),
    },
    {
        [EGGS] = cq.talkStep("COLLECT"),
    },
    {
        [EGGS]  = cq.talkOnly("AFTER"),
        [MANUS] = cq.giveStep("AFTER", info.reward, info.name, cexi.music.SELBINA),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
