-----------------------------------
-- Head First - Lizard Mantle
-----------------------------------
-- !setvar [CW]HEAD_FIRST 0
-- Hume Footprint !pos 639.090 24.000 120.994 108
-- !additem 538
-- Reward: Lizard Mantle
-----------------------------------
-- !setvar [CW]HEAD_FIRST 3

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-head_first")

local info =
{
    name   = "Head First",
    author = "Loxley",
    var    = "[CW]HEAD_FIRST",
    reward =
    {
        item    = 13592,      -- Lizard Mantle
        augment = { 512, 0 }, -- STR +1
    },
}

local HUME_1    = "HUME_1"
local Leidl     = "Leidl"
local FOOTPRINT = "FOOTPRINT"
local HumeFoot  = "Hume Footprint"

local entity =
{
    {
        id       = FOOTPRINT,
        name     = HumeFoot,
        marker   = cq.SIDE_QUEST,
        area     = "Konschtat_Highlands",
        pos      = { 639.090, 24.000, 120.994, 24 },-- !pos 639.090 24.000 120.994 108
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            START   =
            {
                { despawn = { HumeFoot } },
                { spawn   = { Leidl } },
                { delay   = 500 },
                { entity  = Leidl, face = "player" },
                { delay   = 500 },
                { entity  = Leidl, emote = xi.emote.SHOCKED },
                "Leidl : Hey! Help!",
                " I mean... everything is fine but...",
                { delay   = 2000 },
                { entity  = Leidl, emote = xi.emote.PANIC },

                "Leidl : Some old man asked me to fetch a magicked skull from these mines.",
                " But... I can't! I just can't!",
                { delay  = 1000 },
                { entity = Leidl, emote = xi.emote.THINK },

                "Leidl : You look brave... You'll go in there for me, right?",
                { delay = 1000 },
                " Please bring back a magicked skull and I'll make it worth your time!",

                { delay   = 500 },
                { despawn = { Leidl } },
                { spawn   = { HumeFoot } },
            },
            REMINDER = { "Leidl : Please bring back a magicked skull and I'll make it worth your time!" },
            ACCEPTED =
            {
                { despawn = { HumeFoot } },
                { spawn   = { Leidl } },
                { delay   = 500 },
                { entity  = Leidl, face = "player" },
                { delay   = 500 },
                { entity  = Leidl, emote = xi.emote.CHEER },
                "Leidl : You did it! You actually did it!",
                { delay   = 2000 },

                "Leidl : Thank you. I can't wait to get out of here.",
                { delay  = 1000 },
                { entity = Leidl, emote = xi.emote.POINT },
                "Leidl : As promised, here's your reward. I hope you find it useful.",

                { delay   = 500 },
                { despawn = { Leidl } },
                { spawn   = { HumeFoot } },
            },
            AFTER = { "Whoever was here is long gone..." },
        },
    },
    {
        id     = HUME_1,
        name   = Leidl,
        type   = xi.objType.NPC,
        hidden = true,
        look   = "0x01000F020010032008300A400850006000700000",
        area   = "Konschtat_Highlands",
        pos    = { 639.090, 24.000, 120.994, 24 }, -- !pos 639.090 24.000 120.994 108
    },
}

local step =
{
    {
        check       = cq.checks({ CW = true, level = 10 }),
        [FOOTPRINT] = cq.talkStep("START", info.name),
    },
    {
        [FOOTPRINT] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("ACCEPTED", "REMINDER", 538, info.reward, info.name, cexi.music.NONE), -- Magicked Skull
        },
    },
    {
        [FOOTPRINT] = cq.talkOnly("AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
