-----------------------------------
-- CW Anniversary (Lv10)
-----------------------------------
-- !setvar [CW]ANNIVERSARY 0
-- Knotlox !pos 477.877 29.134 -464.846 222
-- Wadnir  !pos -382.393 2.282 -101.697 191
-- Giggnix !pos 600.038 23.951 238.517 108
-- Ghoul   !pos -64.494 -62.013 -223.718 196
-- Toucan  !pos 723.513 -16.181 194.581 51
-- Yagudo  !pos -267.886 -15.997 121.419 151
-- Coeurl  !pos 647.516 0.174 -199.141 121
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw-anniversary_event")

local info =
{
    name     = "Crystal Anniversary",
    author   = "Loxley",
    var      = "[CW]ANNIVERSARY",
    enabled  = true,
}

local KNOTLOX_CS        = "KNOTLOX"
local Knotlox           = "Knotlox Bigshoe"
local SHOELACE_CS       = "GOBLIN_SHOELACE"
local Shoelace          = "Goblin Shoelace"
local GOBLIN_SATCHEL    = "GOBLIN_SATCHEL"
local Satchel           = "Goblin Satchel"
local WADNIR            = "WADNIR"
local SUS_LUMP          = "SUS_LUMP"
local Lump              = "Suspicious Lump"
local Giggnix           = "Giggnix Lowbrow"
local Bobnix            = "Bobnix Twochin"
local Slugnix           = "Slugnix Boghead"
local GOBLIN_PURSE      = "GOBLIN_PURSE"
local GHOUL_1           = "GHOUL_1"
local GHOUL_2           = "GHOUL_2"
local AccursedGhoul     = "Accursed Ghoul"
local GOBLIN_LUNCH      = "GOBLIN_LUNCH"
local ANGRY_TOUCAN_1    = "ANGRY_TOUCAN_1"
local ANGRY_TOUCAN_2    = "ANGRY_TOUCAN_2"
local ANGRY_TOUCAN_3    = "ANGRY_TOUCAN_3"
local ANGRY_TOUCAN_4    = "ANGRY_TOUCAN_4"
local GOBLIN_FRYING_PAN = "GOBLIN_FRYING_PAN"
local YAGUDO_RUFFIAN_1  = "YAGUDO_RUFFIAN_1"
local YAGUDO_RUFFIAN_2  = "YAGUDO_RUFFIAN_2"
local YAGUDO_RUFFIAN_3  = "YAGUDO_RUFFIAN_3"
local RUSTED_WHISTLE    = "RUSTED_WHISTLE"
local CRYSTAL_COEURL    = "CRYSTAL_COEURL"

local function goblinDialog(tbl)
    return cq.npcSpawner(tbl, Knotlox, Shoelace)
end

local function lumpDialog(tbl)
    return cq.npcSpawner(tbl, { Giggnix, Bobnix, Slugnix }, Lump)
end

local function purseDialog(tbl)
    return cq.npcSpawner(tbl, { Giggnix, Bobnix, Slugnix }, Lump)
end

local entity =
{
    {
        id     = KNOTLOX_CS,
        name   = Knotlox,
        type   = xi.objType.NPC,
        look   = 484, -- Goblin
        area   = "Provenance",
        pos    = { 477.877, 29.134, -464.846, 39 }, -- !pos 477.877 29.134 -464.846 222
        hidden = true,
    },
    {
        id     = SHOELACE_CS,
        name   = Shoelace,
        marker = cq.MAIN_QUEST,
        area   = "Provenance",
        pos    = { 477.877, 29.134, -464.846, 39 }, -- !pos 477.877 29.134 -464.846 222
        dialog =
        {
            DEFAULT = cq.NOTHING,
        },
    },
    {
        id     = GOBLIN_SATCHEL,
        name   = Satchel,
        marker = cq.MAIN_QUEST,
        area   = "Dangruf_Wadi",
        pos    = { -382.393, 2.282, -101.697, 225 }, -- !pos -382.393 2.282 -101.697 191
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id          = WADNIR,
        name        = "Wadnir",
        type        = xi.objType.MOB,
        groupId     = 18,  -- Wadi Crab
        groupZoneId = 191, -- Dangruf Wadi
        look        = 783, -- Fafnir
        area        = "Dangruf_Wadi",
        pos         = { -382.393, 2.282, -101.697, 225 }, -- !pos -382.393 2.282 -101.697 191
        widescan    = 1,
        level       = 7,
        hp          = 600,
        loot        =
        {
            { cexi.rate.GUARANTEED,      4198 }, -- Dragon Chronicles (24%)
            { cexi.rate.COMMON,          4358 }, -- Hare Meat         (15%)
            { cexi.rate.UNCOMMON,         508 }, -- Goblin Helm       (10%)
            { cexi.rate.UNCOMMON,       16552 }, -- Scimitar          (10%)
        },
    },
    {
        id     = SUS_LUMP,
        name   = Lump,
        marker = cq.MAIN_QUEST,
        area   = "Konschtat_Highlands",
        pos    = { 600.038, 23.951, 238.517, 66 }, -- !pos 600.038 23.951 238.517 108
        dialog =
        {
            DEFAULT = cq.NOTHING,
        },
    },
    {
        id     = "GIGGNIX",
        name   = Giggnix,
        type   = xi.objType.NPC,
        look   = 492, -- Goblin
        area   = "Konschtat_Highlands",
        pos    = { 600.419, 23.395, 241.874, 65 }, -- !pos 600.419 23.395 241.874 108
        hidden = true,
    },
    {
        id     = "SLUGNIX",
        name   = Slugnix,
        type   = xi.objType.NPC,
        look   = 499, -- Goblin
        area   = "Konschtat_Highlands",
        pos    = { 597.069, 22.936, 242.202, 37 }, -- !pos 597.069 22.936 242.202 108
        hidden = true,
    },
    {
        id     = "BOBNIX",
        name   = Bobnix,
        type   = xi.objType.NPC,
        look   = 490, -- Goblin
        area   = "Konschtat_Highlands",
        pos    = { 603.845, 22.780, 241.563, 105 }, -- !pos 603.845 22.780 241.563 108
        hidden = true,
    },
    {
        id     = GOBLIN_PURSE,
        name   = "Goblin Purse",
        marker = cq.MAIN_QUEST,
        area   = "Gusgen_Mines",
        pos    = { -64.494, -62.013, -223.718, 225 }, -- !pos -64.494 -62.013 -223.718 196
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id          = GHOUL_1,
        name        = "Fiendish Ghoul 2",
        packetName  = "Fiendish Ghoul",
        type        = xi.objType.MOB,
        groupId     = 14,  -- Ghoul
        groupZoneId = 196, -- Gusgen Mines
        area        = "Gusgen_Mines",
        pos         = { -66.863, -62.247, -220.407, 39 }, -- !pos -66.863 -62.247 -220.407 196
        level       = 16,
        hp          = 800,
        loot        =
        {
            { cexi.rate.VERY_COMMON,      538 }, -- Magicked Skull    (24%)
            { cexi.rate.COMMON,           880 }, -- Bone Chip         (15%)
        },
    },
    {
        id          = GHOUL_2,
        name        = "Fiendish Ghoul 1",
        packetName  = "Fiendish Ghoul",
        type        = xi.objType.MOB,
        groupId     = 14,  -- Ghoul
        groupZoneId = 196, -- Gusgen Mines
        area        = "Gusgen_Mines",
        pos         = { -62.415, -62.013, -225.223, 163 }, -- !pos -62.415 -62.013 225.223 196
        level       = 16,
        hp          = 800,
        loot        =
        {
            { cexi.rate.VERY_COMMON,      538 }, -- Magicked Skull    (24%)
            { cexi.rate.COMMON,           880 }, -- Bone Chip         (15%)
        },
    },
    {
        id     = "GIGGNIX_2",
        name   = Giggnix,
        type   = xi.objType.NPC,
        look   = 492, -- Goblin
        area   = "Gusgen_Mines",
        pos    = { -62.746, -62.013, -223.595, 126 }, -- !pos -62.746 -62.013 -223.595 196
        hidden = true,
    },
    {
        id     = "SLUGNIX_2",
        name   = Slugnix,
        type   = xi.objType.NPC,
        look   = 499, -- Goblin
        area   = "Gusgen_Mines",
        pos    = { -62.826, -62.013, -224.821, 131 }, -- !pos -62.826 -62.013 -224.821 196
        hidden = true,
    },
    {
        id     = "BOBNIX_2",
        name   = Bobnix,
        type   = xi.objType.NPC,
        look   = 490, -- Goblin
        area   = "Gusgen_Mines",
        pos    = { -61.288, -61.900, -222.751, 117 }, -- !pos -61.288 -61.900 -222.751 196
        hidden = true,
    },
    {
        id     = "ACCURSED",
        name   = AccursedGhoul,
        type   = xi.objType.NPC,
        look   = 576, -- Ghoul
        flags  = 592, -- Big
        area   = "Gusgen_Mines",
        pos    = { -60.954, -61.800, -224.074, 132 }, -- !pos -60.954 -61.800 -224.074 196
        hidden = true,
    },
    {
        id     = GOBLIN_LUNCH,
        name   = "Goblin Lunch",
        marker = cq.MAIN_QUEST,
        area   = "Wajaom_Woodlands",
        pos    = { 723.513, -16.181, 194.581, 162 }, -- !pos 723.513 -16.181 194.581 51
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id          = ANGRY_TOUCAN_1,
        name        = "Angry Toucan 1",
        packetName  = "Angry Toucan",
        type        = xi.objType.MOB,
        groupId     = 14,
        groupZoneId = 4,  -- Toucan
        area        = "Wajaom_Woodlands",
        pos         = { 719.235, -16.240, 194.128, 244 }, -- !pos 723.513 -16.181 194.581 51
        level       = 27,
        hp          = 1200,
        loot        =
        {
            { cexi.rate.VERY_COMMON,     2150 }, -- Colibri Feather   (24%)
            { cexi.rate.COMMON,          4539 }, -- Goblin Pie        (15%)
            { cexi.rate.UNCOMMON,        4495 }, -- Goblin Chocolate  (10%)
        },
    },
    {
        id          = ANGRY_TOUCAN_2,
        name        = "Angry Toucan 2",
        packetName  = "Angry Toucan",
        type        = xi.objType.MOB,
        groupId     = 14,
        groupZoneId = 4,  -- Toucan
        area        = "Wajaom_Woodlands",
        pos         = { 715.757, -16.000, 197.286, 5 }, -- !pos 723.513 -16.181 194.581 51
        level       = 27,
        hp          = 1200,
        loot        =
        {
            { cexi.rate.VERY_COMMON,     2150 }, -- Colibri Feather   (24%)
            { cexi.rate.COMMON,          4539 }, -- Goblin Pie        (15%)
            { cexi.rate.UNCOMMON,        4495 }, -- Goblin Chocolate  (10%)
        },
    },
    {
        id          = ANGRY_TOUCAN_3,
        name        = "Angry Toucan 3",
        packetName  = "Angry Toucan",
        type        = xi.objType.MOB,
        groupId     = 14,
        groupZoneId = 4,  -- Toucan
        area        = "Wajaom_Woodlands",
        pos         = { 718.021, -15.948, 204.846, 28 }, -- !pos 723.513 -16.181 194.581 51
        level       = 27,
        hp          = 1200,
        loot        =
        {
            { cexi.rate.VERY_COMMON,     2150 }, -- Colibri Feather   (24%)
            { cexi.rate.COMMON,          4539 }, -- Goblin Pie        (15%)
            { cexi.rate.UNCOMMON,        4495 }, -- Goblin Chocolate  (10%)
        },
    },
    {
        id          = ANGRY_TOUCAN_4,
        name        = "Angry Toucan 4",
        packetName  = "Angry Toucan",
        type        = xi.objType.MOB,
        groupId     = 14,
        groupZoneId = 4,  -- Toucan
        area        = "Wajaom_Woodlands",
        pos         = { 723.149, -15.761, 207.846, 56 }, -- !pos 723.513 -16.181 194.581 51
        level       = 27,
        hp          = 1200,
        loot        =
        {
            { cexi.rate.VERY_COMMON,     2150 }, -- Colibri Feather   (24%)
            { cexi.rate.COMMON,          4539 }, -- Goblin Pie        (15%)
            { cexi.rate.UNCOMMON,        4495 }, -- Goblin Chocolate  (10%)
        },
    },
    {
        id     = GOBLIN_FRYING_PAN,
        name   = "Gob. Frying Pan",
        marker = cq.MAIN_QUEST,
        area   = "Castle_Oztroja",
        pos    = { -265.477, -16.000, 120.934, 196 }, -- !pos -265.477 -16.000 120.934 151
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id          = YAGUDO_RUFFIAN_1,
        name        = "Yagudo Ruffian 1",
        packetName  = "Yagudo Ruffian",
        type        = xi.objType.MOB,
        look        = 581, -- MNK
        flags       = 592,
        groupId     = 21,
        groupZoneId = 119,
        area        = "Castle_Oztroja",
        pos         = { -267.886, -15.997, 121.419, 205 }, -- !pos -267.886 -15.997 121.419 151
        level       = 54,
        loot        =
        {
            { cexi.rate.VERY_COMMON,      748 }, -- Gold Beastcoin    (24%)
            { cexi.rate.COMMON,           749 }, -- Mythril Beastcoin (15%)
        },
    },
    {
        id          = YAGUDO_RUFFIAN_2,
        name        = "Yagudo Ruffian 2",
        packetName  = "Yagudo Ruffian",
        type        = xi.objType.MOB,
        look        = 581, -- MNK
        flags       = 592,
        groupId     = 21,
        groupZoneId = 119,
        area        = "Castle_Oztroja",
        pos         = { -268.797, -16.000, 117.191, 205 }, -- !pos -267.886 -15.997 121.419 151
        level       = 54,
        loot        =
        {
            { cexi.rate.VERY_COMMON,      748 }, -- Gold Beastcoin    (24%)
            { cexi.rate.COMMON,           749 }, -- Mythril Beastcoin (15%)
        },
    },
    {
        id          = YAGUDO_RUFFIAN_3,
        name        = "Yagudo Ruffian 3",
        packetName  = "Yagudo Ruffian",
        type        = xi.objType.MOB,
        look        = 581, -- MNK
        flags       = 592,
        groupId     = 21,
        groupZoneId = 119,
        area        = "Castle_Oztroja",
        pos         = { -263.543, -16.000, 117.890, 174 }, -- !pos -267.886 -15.997 121.419 151
        level       = 54,
        loot        =
        {
            { cexi.rate.VERY_COMMON,      748 }, -- Gold Beastcoin    (24%)
            { cexi.rate.COMMON,           749 }, -- Mythril Beastcoin (15%)
        },
    },
    {
        id     = RUSTED_WHISTLE,
        name   = "Rusted Whistle",
        marker = cq.MAIN_QUEST,
        area   = "The_Sanctuary_of_ZiTah",
        pos    = { 647.516, 0.174, -199.141, 81 }, -- !pos 647.516 0.174 -199.141 121
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id          = CRYSTAL_COEURL,
        name        = "Crystal Coeurl",
        type        = xi.objType.MOB,
        flags       = 592,
        groupId     = 28,
        groupZoneId = 121,
        look        = 2108,
        area        = "The_Sanctuary_of_ZiTah",
        pos         = { 647.516, 0.174, -199.141, 81 }, -- !pos 647.516 0.174 -199.141 121
        level       = 78,
        hp          = 25000,
        mods        =
        {
            [xi.mod.UDMGPHYS]   = -6000,
            [xi.mod.UDMGRANGE]  = -6000,
            [xi.mod.UDMGMAGIC]  = -6000,
            [xi.mod.UDMGBREATH] = -6000,
        },
        aeffect     = xi.mob.ae.ENTHUNDER,
        loot        =
        {
            { cexi.rate.VERY_COMMON,     4377 }, -- Coeurl Meat    (24%)
            { cexi.rate.COMMON,           863 }, -- Coeurl Hide    (15%)
            { cexi.rate.UNCOMMON,         927 }, -- Coeurl Whisker (10%)
        },
    },
}

local function diceStep(obj)
    return function(player, npc, tbl, var, step)
        if player:getCharVar("[CU]BLOCKING") == 1 then
            return
        end

        local roll = math.random(0, 999)
        player:sys("Dice roll! {} rolls {}!", player:getName(), roll)

        if roll > obj.threshold then
            player:incrementCharVar(info.var, 1)
        else
            cexi.util.dialog(player, obj.failed, nil, { npc = npc })
            player:setCharVar(info.var, obj.reset)
        end
    end
end

local goblinPurseEarly = cq.dialog({
    step  = false,
    event =
    {
        "You have a feeling you should check outside Gusgen Mines first.",
    },
})

local step =
{
    {
        check     = cq.checks({ level = 99 }),
        [SHOELACE_CS] = cq.dialog({
            quest = info.name,
            name  = Knotlox,
            event = goblinDialog({
                { delay = 500 },
                { entity = Knotlox, animate = 2582, mode = 4 },
                "Woah, watch where you're going buddy!! You almost stepped on my toe!",
                { delay = 1000 },
                " Huh? What's a gob like me doing here? Well... it's a long story.",
                { delay = 500 },
                "And uh actually, I lost a few things on my way here.",
                " Would you be willing to help a gob out?",
                " I think I have a few things that may be of interest to a Crystal Warrior like yourself.",
            }),
        }),
    },
    {
        [SHOELACE_CS] = cq.menu({
            name    = Knotlox,
            title   = "Help a gob out?",
            options =
            {
                {
                    "Not a chance",
                },
                {
                    "Why not",
                    goblinDialog({
                        "Haha, good deal. Let's get started.",
                        { delay = 500 },
                        " You see, I was strolling through Dangruf Wadi when suddenly.... A huge dragon appeared out of nowhere!",
                        { delay = 1000 },
                        " Crazy, huh?",
                        { delay = 2000 },
                        "Well, In the rush to get out, I must have dropped my satchel.",
                        " Bring me the satchel and I'll tell you what happened next!",
                    }),
                },
            },
        }),
    },
    {
        [SHOELACE_CS] = cq.dialog({
            name  = Knotlox,
            step  = false,
            event = goblinDialog({
                "Doesn't look like you have my satchel yet. I dropped it somewhere in Dangruf Wadi...",
            }),
        }),

        [GOBLIN_SATCHEL] = cq.menu({
            title    = "You sense a hostile presence...",
            spawn    = { WADNIR },
            levelCap = 10,
            options  =
            {
                {
                    "Run away!",
                },
                {
                    "I'm not scared...",
                    true,
                },
            },
        }),

        [WADNIR] = cq.killStep(GOBLIN_SATCHEL, { WADNIR }, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "CW_ANNI_WADNIR" }),
    },
    {
        [GOBLIN_SATCHEL] = cq.dialog({
            reward = 3652,
            event  =
            {
                "You attempt to pick up the satchel...",
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion = "feels something squishy." },
                " Huh!? What's this?",
            },
        }),
    },
    {
        [GOBLIN_SATCHEL] = cq.dialog({
            step  = false,
            event = cq.NOTHING_ELSE
        }),

        [SHOELACE_CS] = cq.dialog({
            name  = Knotlox,
            event = goblinDialog({
                "You found a cake? Haha... don't worry, that one's on me buddy! Help yourself.",
                { delay = 1000 },
                " Where were we... ",
                { entity = Knotlox, animate = 250, mode = 4 }, -- Lightbulb
                "Right, I was headed up to Valkurm Dunes to get my gobbie subjob.",
                { delay = 500 },
                "On the way, I bumped into some dodgy fellows outside of Gusgen Mines.",
                " They said they could get me a magicked skull, then ran off with my beastcoins!",
                { delay = 2000 },
                "Go teach them a lesson and recover my gobbie purse, then I'll tell you the rest.",
            }),
        }),
    },
    {
        [GOBLIN_PURSE] = goblinPurseEarly,
        [SHOELACE_CS] = cq.dialog({
            name  = Knotlox,
            step  = false,
            event = goblinDialog({
                "Before we continue... Recover my goblin purse from the crooks outside Gusgen Mines!",
            }),
        }),
        [SUS_LUMP] = cq.dialog({
            event = lumpDialog({
                { entity = Giggnix, packet = "horu" },
                Giggnix .. " : Woah, woah, woah. Hold it right there! This our turf!",
                Slugnix .. " : Uhh... Yeah! This spot is ours!",
                { delay = 2000 },
                Bobnix .. " : Wait a sec boss, what if this adventurer here has money?",
                Giggnix .. " : ... Yeah, I was getting to that!",
                Slugnix .. " : Yeah, he was getting to that!",
                { delay = 2000 },
                Giggnix .. " : *Psst* What should we do boys?",
                { entity = Bobnix, face = Giggnix },
                Bobnix .. " : Make 'm roll dice!",
                { entity = Slugnix, face = Giggnix },
                Slugnix .. " : Uh yeah, what he said.",
                { delay = 1000 },
                Giggnix .. " : Hmmm....",
                " All right! If you win at dice, we'll let you pass!",
            }),
        }),
    },
    {
        [GOBLIN_PURSE] = goblinPurseEarly,
        [SUS_LUMP] =
        {
            onTrigger = cq.dialog({
                name  = Giggnix,
                step  = false,
                event = lumpDialog({
                    "What do you think this is, a charity? It's gonna cost ya 3 beastcoins to play dice!",
                }),
            }),

            onTrade   = cq.trade({
                required = { { 656, 3 } },
                accepted = lumpDialog({
                    Giggnix .. " : Hahaha... This is gonna be fun!",
                    " *Psst* (Fellas we're gonna be rich! This adventurer looks loaded!)",
                    " Awright, The rules are real simple. If you roll above 700, you win. If you roll less, we win!",
                }),
                declined = lumpDialog({
                    Giggnix .. " : What do you think this is, a charity? It's gonna cost ya 3 beastcoins to play dice!",
                }),
            }),
        },
    },
    {
        [GOBLIN_PURSE] = goblinPurseEarly,
        [SUS_LUMP] = diceStep({
            threshold = 700,
            reset     = 6,
            failed    = lumpDialog({
                Giggnix .. " : Bwahahaha... You're gonna have to do better than that!",
                Slugnix .. " : Yeah!",
                Bobnix .. " : Try again, pal!",
            }),
        }),
    },
    {
        [GOBLIN_PURSE] = goblinPurseEarly,
        [SUS_LUMP] = cq.dialog({
            event = lumpDialog({
                Giggnix .." : Aww man...",
                { entity = Giggnix, packet = "dead" },
                { delay = 2000 },
                { entity = Giggnix, packet = "idle" },
                " *Psst* (Boys, what else can we get out of this one?)",
                { entity = Bobnix, face = Giggnix },
                { entity = Slugnix, face = Giggnix },
                Bobnix .." : *Whisper* *Whisper*",
                Slugnix .. " : *Whisper* *Whisper*",
                { entity = Giggnix, packet = "horu" },
                { delay = 2000 },
                Giggnix .. " : Haha. Yeah. Looks like you forgot your Mines insurance.",
                " Can't be strolling off into Gusgen Mines without your insurance!",
                { entity = Slugnix, face = "player" },
                Slugnix .. " : Y-Yeah!",
                { entity = Bobnix, face = "player" },
                Bobnix .. " : No insurance, no access!",
                { delay = 2000 },
                { entity = Giggnix, animate = 250, mode = 4 }, -- Lightbulb
                Giggnix .. " : Awright, we're gonna need some collateral.",
                " Hand over a Damselfly Worm and... a Crab Apron, and we'll issue the... uh... insurance!",
            }),
        }),
    },
    {
        [GOBLIN_PURSE] = goblinPurseEarly,
        [SUS_LUMP] =
        {
            onTrigger = cq.dialog({
                name  = Giggnix,
                step  = false,
                event = lumpDialog({
                    "Hand over a Damselfly Worm and... a Crab Apron, and we'll issue the... uh... insurance!",
                }),
            }),

            onTrade   = cq.trade({
                required = { { 537, 1 }, { 539, 1 } },
                accepted = lumpDialog({
                    Giggnix .. " : Woah lads, this adventurer ain't messing around!",
                    " Maybe we can let you into the Mines after all... If you do us a favor while you're inside.",
                    { delay = 2000 },
                    Giggnix .. " : There's a Goblin Purse we may have dropped while trying to escape.",
                    " Bring us the purse and give us our cut. Or... um... there will be consequences!",
                    { entity = Slugnix, face = "player" },
                    { delay = 500 },
                    Slugnix .. " : Yeah, there'll be consequences!",
                }),
                declined = lumpDialog({
                    Giggnix .. " : What the heck is this? Bring that Damselfly Worm and the Crab Apron or forget it!",
                }),
            }),
        },
    },
    {
        [SUS_LUMP] = cq.dialog({
            step  = false,
            event = lumpDialog({
                Giggnix .. " : There's a Goblin Purse we may have dropped while trying to escape.",
                " Bring us the purse and give us our cut. Or... um... there will be consequences!",
                { entity = Bobnix, face = "player" },
                Slugnix .. " : Yeah, there'll be consequences!",
            }),
        }),

        [GOBLIN_PURSE] = cq.menu({
            title    = "This place doesn't look safe.",
            spawn    = { GHOUL_1, GHOUL_2 },
            levelCap = 20,
            options  =
            {
                {
                    "Come back later",
                },
                {
                    "I'm unbreakable! Uh wait...",
                    true,
                },
            },
        }),

        [GHOUL_1] = cq.killStep(GOBLIN_PURSE, { GHOUL_1, GHOUL_2 }, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "CW_ANNI_GHOUL" }),
        [GHOUL_2] = cq.killStep(GOBLIN_PURSE, { GHOUL_1, GHOUL_2 }, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "CW_ANNI_GHOUL" }),
    },
    {
        [GOBLIN_PURSE] = cq.dialog({
            event = purseDialog({
                Giggnix .. " : All right! Hand it over! We're here to take our cut!",
                { delay = 500 },
                Slugnix .. " : B-Boss, I'm s-scared.",
                { entity = Slugnix, face = Giggnix },
                { delay = 500 },
                Bobnix .. " : Uh I don't think we should be here...",
                { entity = Bobnix, face = Giggnix },
                { entity = Giggnix, packet = "ati0" },
                Giggnix .. " : Shut up! We're not leaving without the bag!",
                { delay = 2000 },
                { spawn = { AccursedGhoul } },
                Slugnix .. " : Uhh boss, I think I just heard a noise.",
                { delay = 1000 },
                Slugnix .. " : Uhh...",
                { entity = Slugnix, face = AccursedGhoul },
                Bobnix .. " : Behind us!",
                { entity = Bobnix, face = AccursedGhoul },
                Giggnix .. " : Yikes!",
                { entity = Giggnix, face = AccursedGhoul },
                { entity = AccursedGhoul, animate = 485, mode = 0 },
                { delay = 2000 },
                { entity = Giggnix, packet = "dead" },
                { entity = Slugnix, packet = "dead" },
                { entity = Bobnix, packet = "dead" },
                { delay = 3000 },
                { despawn = { AccursedGhoul } },
            }),
        }),
    },
    {
        [GOBLIN_PURSE] = cq.dialog({
            step  = false,
            event = cq.NOTHING_ELSE
        }),

        [SHOELACE_CS] = cq.dialog({
            name   = Knotlox,
            reward = { { 748, 12 }, { 4035, 5 } },
            event  = goblinDialog({
                "All right! You found my Goblin Purse!",
                " As I was saying... I went to get my gobbie subjob and then I took a trip across the sea.",
                { delay = 2000 },
                "Over in Wajaoam Woodlands, I was just about to tuck into my lunch when a flock of angry birds descended on me!",
                { delay = 1000 },
                " There's probably not any food left but if you could pick up my lunchbox, I'd really appreciate it.",
                { delay = 1000 },
                "Oh also, here's a little reward for your help so far.",
            }),
        }),
    },
    {
        [SHOELACE_CS] = cq.dialog({
            name  = Knotlox,
            step  = false,
            event = goblinDialog({
                "So, could you recover my lunchbox from Wajaom Woodlands? I'd really appreciate that.",
            }),
        }),

        [GOBLIN_LUNCH] = cq.menu({
            title    = "It looks delicious...",
            spawn    = { ANGRY_TOUCAN_1, ANGRY_TOUCAN_2, ANGRY_TOUCAN_3, ANGRY_TOUCAN_4 },
            levelCap = 30,
            options  =
            {
                {
                    "I'm not hungry",
                },
                {
                    "Take a bite",
                    true,
                },
            },
        }),

        [ANGRY_TOUCAN_1] = cq.killStep(GOBLIN_LUNCH, { ANGRY_TOUCAN_1, ANGRY_TOUCAN_2, ANGRY_TOUCAN_3, ANGRY_TOUCAN_4 }, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "CW_ANNI_TOUCAN" }),
        [ANGRY_TOUCAN_2] = cq.killStep(GOBLIN_LUNCH, { ANGRY_TOUCAN_1, ANGRY_TOUCAN_2, ANGRY_TOUCAN_3, ANGRY_TOUCAN_4 }, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "CW_ANNI_TOUCAN" }),
        [ANGRY_TOUCAN_3] = cq.killStep(GOBLIN_LUNCH, { ANGRY_TOUCAN_1, ANGRY_TOUCAN_2, ANGRY_TOUCAN_3, ANGRY_TOUCAN_4 }, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "CW_ANNI_TOUCAN" }),
        [ANGRY_TOUCAN_4] = cq.killStep(GOBLIN_LUNCH, { ANGRY_TOUCAN_1, ANGRY_TOUCAN_2, ANGRY_TOUCAN_3, ANGRY_TOUCAN_4 }, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "CW_ANNI_TOUCAN" }),
    },
    {
        [GOBLIN_LUNCH] = cq.dialog({
            reward = { { 4458, 3 }, { 4578, 4 } },
            event  =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                "You rummage through the lunchbox.",
                { emotion = "finds some half eaten goblin food. Yum." },
            },
        }),
    },
    {
        [GOBLIN_LUNCH] = cq.dialog({
            step  = false,
            event = cq.NOTHING_ELSE
        }),

        [SHOELACE_CS] = cq.dialog({
            name   = Knotlox,
            reward = 9493,
            event  = goblinDialog({
                "Incredible! Um... You can keep the food. But thanks for bringing back the box!",
                " You've been so helpful! I'm going to give you a little something from my friends in Movalpolos.",
            }),
        }),
    },
    {
        [GOBLIN_LUNCH] = cq.dialog({
            step  = false,
            event = cq.NOTHING_ELSE
        }),

        [SHOELACE_CS] = cq.dialog({
            name   = Knotlox,
            event  = goblinDialog({
                "Where were we... Aha, yes. After that catastrophe, I headed back to the mainland.",
                { delay = 2000 },
                " I thought I'd check in with my pals at Oztroja but I ran into some ruffians.",
                " They insisted I fight in their \"arena\" or something.",
                { delay = 2000 },
                "That wasn't really my cup of tea, so I politely declined. However, they were very persuasive.",
                { delay = 3000 },
                "After smacking them a few times with my frying pan, I managed to escape unscathed.",
                " I had to leave it behind the frying pan and I'd really like it back.",
            }),
        }),
    },
    {
        [SHOELACE_CS] = cq.dialog({
            name  = Knotlox,
            step  = false,
            event = goblinDialog({
                "Please be a buddy and get back my frying pan from those feathered fiends.",
                " I left it somewhere on the upper floor of Castle Oztroja.",
            }),
        }),

        [GOBLIN_FRYING_PAN] = cq.menu({
            title    = "You feel like you're being watched...",
            spawn    = { YAGUDO_RUFFIAN_1, YAGUDO_RUFFIAN_2, YAGUDO_RUFFIAN_3 },
            levelCap = 50,
            options  =
            {
                {
                    "Fly away",
                },
                {
                    "Rustle some feathers",
                    true,
                },
            },
        }),

        [YAGUDO_RUFFIAN_1] = cq.killStep(GOBLIN_FRYING_PAN, { YAGUDO_RUFFIAN_1, YAGUDO_RUFFIAN_2, YAGUDO_RUFFIAN_3 }, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "CW_ANNI_YAGUDO" }),
        [YAGUDO_RUFFIAN_2] = cq.killStep(GOBLIN_FRYING_PAN, { YAGUDO_RUFFIAN_1, YAGUDO_RUFFIAN_2, YAGUDO_RUFFIAN_3 }, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "CW_ANNI_YAGUDO" }),
        [YAGUDO_RUFFIAN_3] = cq.killStep(GOBLIN_FRYING_PAN, { YAGUDO_RUFFIAN_1, YAGUDO_RUFFIAN_2, YAGUDO_RUFFIAN_3 }, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "CW_ANNI_YAGUDO" }),
    },
    {
        [GOBLIN_FRYING_PAN] = cq.dialog({
            reward = { { 750, 24 } },
            event  =
            {
                { animation = 48, target = "player", duration = 2000 }, -- Crouch down
                "You pick up the goblin frying pan and find some beastcoins underneath."
            },
        }),
    },
    {
        [SHOELACE_CS] = cq.dialog({
            name   = Knotlox,
            reward = { { 9491, 3 } },
            event  = goblinDialog({
                "Mmmm... I can't wait to cook up something nice with this tonight!",
                { delay = 1000 },
                "It's been quite an adventure so far, huh?",
                " I hope you've enjoyed following along as much as I've had fun telling my story!",
                { delay = 2000 },
                "And I couldn't have got my stuff back without you, so I'll leave ya with one more surprise before I head off to Movalpolos.",
                { delay = 1000 },
                " There's something waiting for you somewhere in The Sanctuary of Zi'Tah...",
                { delay = 2000 },
                "I have a feeling many great things lie on the road ahead, I look forward to sharing more with you!",
                " This is just the beginning. Goodbye for now.",
            }),
        }),
    },
    {
        [SHOELACE_CS] = cq.dialog({
            name  = Knotlox,
            step  = false,
            event =
            {
                "Knotlox Bigshoe has already gone but apparently there is something waiting for you somewhere in The Sanctuary of Zi'Tah..."
            },
        }),

        [RUSTED_WHISTLE] = cq.menu({
            title    = "Time has worn away this mysterious whistle...",
            spawn    = { CRYSTAL_COEURL },
            levelCap = 75,
            options  =
            {
                {
                    "Leave it",
                },
                {
                    "Pick it up",
                    true,
                },
            },
        }),

        [CRYSTAL_COEURL] = cq.killStep(RUSTED_WHISTLE, { CRYSTAL_COEURL }, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "CW_ANNI_COEURL" }),
    },
    {
        [RUSTED_WHISTLE] = cq.dialog({
            quest  = info.name,
            reward = { { 8966, 10 } }, -- Crystal Fragment x10
            event  =
            {
                { animation = 48, target = "player", duration = 1000 }, -- Crouch down
                { message = "You've learned how to ride the Coeurl!" },
                { message = "You have unlocked Riding Thunder's services in Upper Jeuno!" },
            },
            after = function(player)
                local mountList = player:getCharVar("[CW]MOUNT_LIST")
                local result    = utils.mask.setBit(mountList, 17, true)
                player:setCharVar("[CW]MOUNT_LIST", result)
            end,
        }),
    },
    {
        [RUSTED_WHISTLE] = cq.dialog({
            step  = false,
            event = cq.NOTHING_ELSE,
        }),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
