---------------------------------------------------------
-- Stocked Up -- Quest to Unlock Curio Vendor Moogles
---------------------------------------------------------
-- !setvar [CQ]STOCKED_UP 0
-- Shady Dealer !pos 49.403 -12.000 -115.162 232
-- !additem 768 12
-- !additem 889 12
-- !additem 640 12
---------------------------------------------------------
-- !setvar [CQ]STOCKED_UP 0

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-------------------------------------------------------
local m = Module:new("cq_stocked_up")


local STOCKED_UP   = "STOCKED_UP"
local SHADY_DEALER = "SHADY_DEALER"

local info =
{
    author = "Carver",
    name   = "Stocked Up",
    var    = "[CQ]STOCKED_UP",

    reward =
    {
        gil   = 1000,
        after = function(player)
            player:setCharVar("[CQ]CURIO_MOOGLES", 1)
            player:printToPlayer("You have unlocked Curio Moogles!", xi.msg.channel.SYSTEM_3)
            return true
        end,
    },
}

local SHADY_DEALER_DIALOG =
{
    NAME     = true,
    DEFAULT  = { "I'm a hustler, baby... I just want you to know." },
    START    =
    {
        "You see that Curio Vendor Moogle next to me? ",
        " There's one in each of the three nations.",
        " They stock items like food, ninjutsu tools, consumables and more.",
        " Would you like to know how to access them?",
    },
    STEP1   =
    {
        "The Curio Vendor Moogles across Vana'diel are short stocked on many items.",
        { emote = xi.emote.THINK },
        " Bring me a stack of flint stones so I can restock our inventory.",
    },
    STEP2   =
    {
        "Thanks for your help with the flint stones.",
        " The Curio Vendor Moogles across Vana'diel are short stocked on many items.",
        { emote = xi.emote.THINK },
        " Bring me a beetle shell so I can restock our inventory.",
    },
    STEP3   =
    {
        "Thanks for your help with the beetle shell.",
        " The Curio Vendor Moogles across Vana'diel are short stocked on many items.",
        { emote = xi.emote.THINK },
        " Bring me a chunk of copper ore so I can restock our inventory.",
    },
    DECLINE = { "This isn't what I asked for!" },
    FINISH  =
    {
        "Congratulations! You can now access the Curio Vendor Moogles.",
        { emote = xi.emote.CHEER },
    },
}

local entity =
{
    {
        id     = "SHADY_DEALER_SANDY",
        name   = "Shady Dealer",
        type   = xi.objType.NPC,
        look   = "0x01000F0300100320083000000000000000000000",
        area   = "Port_San_dOria",
        pos    = { 49.403, -12.000, -115.162, 196 }, -- !pos 49.403 -12.000 -115.162
        dialog = SHADY_DEALER_DIALOG,
    },
    {
        id     = "SHADY_DEALER_BASTOK",
        name   = "Shady Dealer",
        type   = xi.objType.NPC,
        look   = "0x01000F0300100320083000000000000000000000",
        area   = "Port_Bastok",
        pos    = { 83.294, 8.500, -246.010, 127 }, -- !pos 83.145 8.500 -244.692
        dialog = SHADY_DEALER_DIALOG,
    },
    {
        id     = "SHADY_DEALER_WINDURST",
        name   = "Shady Dealer",
        type   = xi.objType.NPC,
        look   = "0x01000F0300100320083000000000000000000000",
        area   = "Port_Windurst",
        pos    = { 206.720, -12.000, 233.676, 63 }, -- !pos 206.720 -12.000 233.676
        dialog = SHADY_DEALER_DIALOG,
    },
}

local step =
{
    {
        check            = cq.checks({ CW = false, level = 10 }),
        ["SHADY_DEALER_SANDY"]    = cq.talkStep("START"),
        ["SHADY_DEALER_BASTOK"]   = cq.talkStep("START"),
        ["SHADY_DEALER_WINDURST"] = cq.talkStep("START"),
    },
    {
        ["SHADY_DEALER_SANDY"]    = cq.menuStep("Help the Shady Dealer?", { { "Yes", "STEP1" }, { "No " } }, 1, info.name ),
        ["SHADY_DEALER_BASTOK"]   = cq.menuStep("Help the Shady Dealer?", { { "Yes", "STEP1" }, { "No " } }, 1, info.name ),
        ["SHADY_DEALER_WINDURST"] = cq.menuStep("Help the Shady Dealer?", { { "Yes", "STEP1" }, { "No " } }, 1, info.name ),
    },
    {
        ["SHADY_DEALER_SANDY"] =
        {
            onTrigger = cq.talkOnly("STEP1"),
            onTrade   = cq.tradeStep("STEP2", "DECLINE", { { xi.item.FLINT_STONE, 12 } }),
        },
        ["SHADY_DEALER_BASTOK"] =
        {
            onTrigger = cq.talkOnly("STEP1"),
            onTrade   = cq.tradeStep("STEP2", "DECLINE", { { xi.item.FLINT_STONE, 12 } }),
        },
        ["SHADY_DEALER_WINDURST"] =
        {
            onTrigger = cq.talkOnly("STEP1"),
            onTrade   = cq.tradeStep("STEP2", "DECLINE", { { xi.item.FLINT_STONE, 12 } }),
        },
    },
    {
        ["SHADY_DEALER_SANDY"] =
        {
            onTrigger = cq.talkOnly("STEP2"),
            onTrade   = cq.tradeStep("STEP3", "DECLINE", { { xi.item.BEETLE_SHELL, 1 } }),
        },
        ["SHADY_DEALER_BASTOK"] =
        {
            onTrigger = cq.talkOnly("STEP2"),
            onTrade   = cq.tradeStep("STEP3", "DECLINE", { { xi.item.BEETLE_SHELL, 1 } }),
        },
        ["SHADY_DEALER_WINDURST"] =
        {
            onTrigger = cq.talkOnly("STEP2"),
            onTrade   = cq.tradeStep("STEP3", "DECLINE", { { xi.item.BEETLE_SHELL, 1 } }),
        },
    },
    {
        ["SHADY_DEALER_SANDY"] =
        {
            onTrigger = cq.talkOnly("STEP3"),
            onTrade   = cq.tradeStep("FINISH", "DECLINE", { { xi.item.CHUNK_OF_COPPER_ORE, 1 } }, info.reward, info.name, cexi.music.SANDORIA),
        },
        ["SHADY_DEALER_BASTOK"] =
        {
            onTrigger = cq.talkOnly("STEP3"),
            onTrade   = cq.tradeStep("FINISH", "DECLINE", { { xi.item.CHUNK_OF_COPPER_ORE, 1 } }, info.reward, info.name, cexi.music.BASTOK),
        },
        ["SHADY_DEALER_WINDURST"] =
        {
            onTrigger = cq.talkOnly("STEP3"),
            onTrade   = cq.tradeStep("FINISH", "DECLINE", { { xi.item.CHUNK_OF_COPPER_ORE, 1 } }, info.reward, info.name, cexi.music.WINDURST),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
