-----------------------------------
-- Novice Trial (Lv15)
-----------------------------------
-- Mellie  !pos 11.297 -14.558 80.158 248
-- !setvar [CQ]NOVICE 0
-- !setvar [CQ]NOVICE_ITEM 0
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
----------------------------------------------------------
local m = Module:new("cq_novice_trial")

for itemID, trial in pairs(cexi.trials.novice.list) do
    if trial.mobs ~= nil then
        for index, mobInfo in pairs(trial.mobs) do
            cexi.util.ensureMob(mobInfo[2], mobInfo[1])

            m:addOverride(string.format("xi.zones.%s.mobs.%s.onMobDeath", mobInfo[2], mobInfo[1]), function(mob, player, optParams)
                super(mob, player, optParams)

                if
                    player and
                    player:isPC() and
                    player:getCharVar("[CQ]NOVICE_ITEM") == itemID
                then
                    local lookup = string.format("[CQ]NOVICE_%u_%u", itemID, index)
                    local result = player:getCharVar(lookup)

                    if result < mobInfo[3] then
                        local mobName  = string.gsub(mobInfo[1], "_", " ")
                        local zoneName = string.gsub(mobInfo[2], "_", " ")
                        local message  = string.format("Novice Trial [%s] %u/%u (%s in %s)", trial.name, result + 1, mobInfo[3], mobName, zoneName)

                        player:printToPlayer(message, xi.msg.channel.SYSTEM_3)
                        player:incrementCharVar(lookup, 1)

                        if result + 1 >= mobInfo[3] then
                            player:printToPlayer(string.format("%s Trial Complete! %s", "\129\154", "\129\154"), xi.msg.channel.SYSTEM_3)
                        end
                    end
                end
            end)
        end
    end
end

local info =
{
    author = "Loxley",
    name   = "Novice Trial",
    var    = "[CQ]NOVICE",
}

local MELLIE = "MELLIE"

local entity =
{
    {
        id     = MELLIE,
        name   = "Mellie",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.HUME_F,
            face = cexi.face.B1,
            head = cexi.model.TRADERS_SAIO,
            body = cexi.model.DOUBLET,
            hand = cexi.model.TUNIC,
            legs = cexi.model.TUNIC,
            feet = cexi.model.TRADERS_SAIO,
        }),
        area   = "Selbina",
        pos    = { 11.297, -14.558, 80.158, 31 }, -- !pos 11.297 -14.558 80.158 248
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Do I know you?" },

            QUESTION =
            {
                { emote = xi.emote.WAVE },
                "Looking to upgrade your existing armor or weapons?",
                { face = "player" },
                " Bring an item and if it's eligible, I'll give you a trial to upgrade it.",
                { emote = xi.emote.YES },
            },

            REJECTED =
            {
                { emote = xi.emote.NO },
                "Sorry, I can't offer upgrades for that item right now."
            },

            CANCELLED =
            {
                { emote = xi.emote.SIGH },
                "Oh, I see. I've put in a note to cancel that trial for you.",
            },

            ACCEPTED_MOBS =
            {
                { emote = xi.emote.THINK },
                "To upgrade that {} with {}, you'll need the following:"
            },

            REMINDER_MOBS =
            {
                { emote = xi.emote.HUH },
                "Need a reminder? Here's what you'll need to upgrade that %s:"
            },

            ACCEPTED_BOSS =
            {
                { emote = xi.emote.THINK },
                "To upgrade that %s with %s, you'll need to find the %s in %s."
            },

            PASSED =
            {
                { face = "player" },
                "Congratulations on completing the trial!",
                { emote = xi.emote.CLAP },
                " When you're ready, trade me that %s and I'll upgrade it immediately!",
            },

            REMOVED =
            {
                { emote = xi.emote.NO },
                "It looks like this trial no longer exists. I've removed your registration.",
            },
        },
    },
}

local function nameToID(str)
    return string.upper(string.gsub(str, " ", "_"))
end

for itemID, trial in pairs(cexi.trials.novice.list) do
    if trial.boss ~= nil then
        table.insert(entity, {
            id          = nameToID(trial.boss.pop),
            name        = trial.boss.pop,
            marker      = cq.SIDE_QUEST,
            area        = trial.boss.area,
            pos         = trial.boss.pos,
            look        = trial.boss.popLook,
            dialog      =
            {
                DEFAULT = cq.NOTHING,
                AFTER   = cq.NOTHING_ELSE,
            },
        })

        table.insert(entity, {
            id          = nameToID(trial.boss.mob),
            name        = trial.boss.mob,
            type        = xi.objType.MOB,
            groupId     = trial.boss.groupId,
            groupZoneId = trial.boss.groupZoneId,
            look        = trial.boss.look,
            flags       = trial.boss.flags,
            area        = trial.boss.area,
            pos         = trial.boss.pos,
            level       = trial.boss.level,
        })
    end
end

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

-----------------------------------
-- Trial Quest Step Functions
-----------------------------------
local tq = {}

tq.trialOffer = function(questName, itemVar)
    return function(player, npc, trade, tbl, var, step)
        -- Offer to transfer stats to HQ
        for nq, hq in pairs(cexi.trials.novice.upgrade) do
            if npcUtil.tradeHasExactly(trade, { { nq, 1 }, { hq[2], 1 } }) then
                delaySendMenu(player, {
                    title   = string.format("Transfer stats to %s?", hq[1]),
                    options =
                    {
                        {
                            "No",
                            function()
                            end,
                        },
                        {
                            "Yes",
                            function()
                                npc:independentAnimation(player, 16, 2)
                                cq.transferAugments(player, trade, nq, hq[2])
                            end,
                        },
                    },
                })

                return
            end
        end

        -- List trial requirements for NQ
        for itemID, trial in pairs(cexi.trials.novice.list) do
            if npcUtil.tradeHasExactly(trade, itemID) then
                local delay   = 0

                if trial.mobs ~= nil then
                    local message =
                    {
                        tbl.dialog.ACCEPTED_MOBS[1],
                        fmt(tbl.dialog.ACCEPTED_MOBS[2], trial.name, trial.desc),
                    }

                    if trial.mobs ~= nil then
                        for _, mobInfo in pairs(trial.mobs) do
                            local mobName  = string.gsub(mobInfo[1], "_", " ")
                            local zoneName = string.gsub(mobInfo[2], "_", " ")

                            table.insert(message, string.format(" %u %s in %s", mobInfo[3], mobName, zoneName))
                        end
                    end

                    delay = cexi.util.dialogDelay(message)
                    cexi.util.dialog(player, message, tbl.name, { npc = npc })

                elseif trial.boss ~= nil then
                    cexi.util.dialog(player, tbl.dialog.ACCEPTED_BOSS, tbl.name,
                        {
                            [1] = trial.name,
                            [2] = trial.desc,
                            [3] = trial.boss.pop,
                            [4] = string.gsub(trial.boss.area, "_", " "),
                            [5] = trial.boss.mob,
                            npc = npc
                        }
                    )
                    delay = cexi.util.dialogDelay(tbl.dialog.ACCEPTED_BOSS)
                end

                player:timer(delay, function()
                    delaySendMenu(player, {
                        title   = string.format("Begin %s trial?", trial.name),
                        options =
                        {
                            {
                                "Not yet",
                                function()
                                end,
                            },
                            {
                                "I'm ready",
                                function()
                                    player:printToPlayer(string.format("\129\158 Quest Accepted: %s (%s)", questName, trial.name), xi.msg.channel.SYSTEM_3)
                                    player:setCharVar(var, step)
                                    player:setCharVar(itemVar, itemID)
                                end,
                            },
                        },
                    })
                end)

                return
            end
        end

        cexi.util.dialog(player, tbl.dialog.REJECTED, tbl.name, { npc = npc })
    end
end

tq.trialStatus = function(progressVar, itemVar, passed, questName)
    return function(player, npc, tbl, var, step)
        local itemID = player:getCharVar(itemVar)
        local trial  = cexi.trials.novice.list[itemID]

        if trial == nil then
            print(string.format("[CQ] %s attempted to get task list for Novice Trial with itemID: %u", player:getName(), itemID))

            player:setCharVar("[CQ]NOVICE_ITEM", 0)
            player:setCharVar(info.var, 0)

            cexi.util.dialog(player, tbl.dialog.REMOVED, tbl.name, { npc = npc })

            return
        end

        local delay = 0

        if trial.mobs ~= nil then
            local pass    = true
            local message = {}

            for _, row in pairs(tbl.dialog.REMINDER_MOBS) do
                table.insert(message, row)
            end

            for index, mobInfo in pairs(trial.mobs) do
                local result = player:getCharVar(string.format(progressVar, itemID, index))

                if result < mobInfo[3] then
                    pass = false
                end

                local mobName  = string.gsub(mobInfo[1], "_", " ")
                local zoneName = string.gsub(mobInfo[2], "_", " ")

                table.insert(message, string.format(" %u/%u (%s in %s)", result, mobInfo[3], mobName, zoneName))
            end

            if pass then
                cexi.util.dialog(player, tbl.dialog[passed], tbl.name, { [1] = trial.name, npc = npc })
                player:setCharVar(var, step)

                return
            else
                delay = cexi.util.dialogDelay(message)
                cexi.util.dialog(player, message, tbl.name, { [1] = trial.name, npc = npc })
            end

        elseif trial.boss ~= nil then
            delay = cexi.util.dialogDelay(tbl.dialog.ACCEPTED_BOSS)
            cexi.util.dialog(player, tbl.dialog.ACCEPTED_BOSS, tbl.name,
                {
                    [1] = trial.name,
                    [2] = trial.desc,
                    [3] = trial.boss.pop,
                    [4] = string.gsub(trial.boss.area, "_", " "),
                    [5] = trial.boss.mob,
                    npc = npc
                }
            )
        end

        player:timer(delay, function()
            delaySendMenu(player, {
                title   = string.format("Would you like to cancel this trial?", trial.name),
                options =
                {
                    {
                        "Not yet",
                        function()
                        end,
                    },
                    {
                        "Cancel trial",
                        function()
                            delaySendMenu(player, {
                                title = "Are you sure?",
                                options =
                                {
                                    {
                                        "No",
                                        function()
                                        end,
                                    },
                                    {
                                        "Yes",
                                        function()
                                            local delay = cexi.util.dialogDelay(tbl.dialog.CANCELLED)
                                            cexi.util.dialog(player, tbl.dialog.CANCELLED, tbl.name, { npc = npc })

                                            player:timer(delay, function()
                                                player:printToPlayer(string.format("\129\158 Quest Cancelled: %s (%s)", questName, trial.name), xi.msg.channel.SYSTEM_3)
                                            end)

                                            -- Reset the quest
                                            player:setCharVar(var, 0)
                                            player:setCharVar(itemVar, 0)

                                            -- Reset trials progress
                                            if trial.mobs ~= nil then
                                                for index, mobInfo in pairs(trial.mobs) do
                                                    player:setCharVar(string.format(progressVar, itemID, index), 0)
                                                end
                                            end
                                        end,
                                    }
                                },
                            })
                        end,
                    },
                },
            })
        end)
    end
end

tq.trialAfter = function(itemVar, passed)
    return function(player, npc, tbl, var, step)
        local itemID = player:getCharVar(itemVar)
        local trial  = cexi.trials.novice.list[itemID]

        cexi.util.dialog(player, tbl.dialog[passed], tbl.name, { [1] = trial.name, npc = npc })
    end
end

tq.trialFinish = function(progressVar, itemVar, questName, music)
    return function(player, npc, trade, tbl, var, step)
        local itemID = player:getCharVar(itemVar)
        local trial  = cexi.trials.novice.list[itemID]

        if npcUtil.tradeHasExactly(trade, itemID) then
            if player:getFreeSlotsCount() > 0 then
                player:tradeComplete()
                player:addItem(itemID, 1, unpack(trial.augs))
                npc:independentAnimation(player, 4, 2)

                npc:timer(2000, function()
                    local ID = zones[player:getZoneID()]
                    player:messageSpecial(ID.text.ITEM_OBTAINED, itemID)
                end)

                -- Reset the quest
                player:setCharVar(var, 0)
                player:setCharVar(itemVar, 0)

                -- Reset trials progress
                if trial.mobs ~= nil then
                    for index, mobInfo in pairs(trial.mobs) do
                        player:setCharVar(string.format(progressVar, itemID, index), 0)
                    end
                end

                player:printToPlayer(string.format("\129\159 Quest Completed: %s (%s)", questName, trial.name), xi.msg.channel.SYSTEM_3)
                player:incrementCharVar("[CQ]NOVICE_TRIALS", 1)

                player:changeMusic(0, 67)
                player:changeMusic(1, 67)
                player:timer(5000, function(playerArg)
                    player:changeMusic(0, music or 0)
                    player:changeMusic(1, music or 0)
                end)
            else
                local ID = zones[player:getZoneID()]
                player:tradeRelease()
                player:messageSpecial(ID.text.ITEM_CANNOT_BE_OBTAINED, itemID)
            end
        end
    end
end

local step =
{
    {
        [MELLIE] =
        {
            onTrigger = cq.talkOnly("QUESTION"),
            onTrade   = tq.trialOffer(info.name, "[CQ]NOVICE_ITEM"),
        },
    },
    {
        [MELLIE] = tq.trialStatus("[CQ]NOVICE_%u_%u", "[CQ]NOVICE_ITEM", "PASSED", info.name),
    },
    {
        [MELLIE] =
        {
            onTrigger = tq.trialAfter("[CQ]NOVICE_ITEM", "PASSED"),
            onTrade   = tq.trialFinish("[CQ]NOVICE_%u_%u", "[CQ]NOVICE_ITEM", info.name, cexi.music.SELBINA),
        },
    },
}

-- Automatically create steps from trials table
for itemID, trial in pairs(cexi.trials.novice.list) do
    if trial.boss ~= nil then
        local popID = nameToID(trial.boss.pop)
        local mobID = nameToID(trial.boss.mob)

        -- Spawn mob from item trade if specified
        if trial.boss.item ~= nil then
            step[2][popID] =
            {
                check     = cq.checks({ vareq = { "[CQ]NOVICE_ITEM", itemID } }),
                onTrade   = cq.tradeSpawn(mobID, trial.boss.item[2], { levelCap = trial.boss.capped, hideSpawner = true }),
                onTrigger = cq.talkString(string.format("Something may happen here if you have %s.", trial.boss.item[1])),
            }

        -- Otherwise use ready check menu to spawn
        else
            step[2][popID] = 
            {
                check     = cq.checks({ vareq = { "[CQ]NOVICE_ITEM", itemID } }),
                onTrigger = cq.menuSpawn(mobID, "Are you ready?", { { "Not yet." }, { "I'm ready." } }, 2, true, { levelCap = trial.boss.capped }),
            }
        end

        step[2][mobID] =
        {
            check      = cq.checks({ vareq = { "[CQ]NOVICE_ITEM", itemID } }),
            onMobDeath = cq.killStep(popID, { mobID }, nil,
                {
                    message = string.format("%s Trial Complete! %s", "\129\154", "\129\154"),
                }
            ),
        }

        step[3][popID] =
        {
            check     = cq.checks({ vareq = { "[CQ]NOVICE_ITEM", itemID } }),
            onTrigger = cq.talkOnly("AFTER"), -- "There is nothing else to do here."
        }
    end
end

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
