-------------------------------------------------------
-- Near Death Experience (Lv50)
-------------------------------------------------------
-- Steps
-------------------------------------------------------
-- !setvar [CQ]NEAR_DEATH_EXPERIENCE 0
-- Andrus       !pos -510.266 -5.363 -39.524 24
-- Page 1       !pos -422.678 -24.062 156.264 24
-- Page 2       !pos -203.400 -16.284 308.786 24
-- Page 3       !pos 120.984 -7.500 14.108 24
-- NM           !pos 129.888 -7.921 17.015 24
-- Unlocks EXP Guide
-------------------------------------------------------
-- !setvar [CQ]NEAR_DEATH_EXPERIENCE 5

local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-------------------------------------------------------
local m = Module:new("cq_quest-near-death-exp")

local info =
{
    name   = "Near Death Experience",
    author = "Carver",
    var    = "[CQ]NEAR_DEATH_EXPERIENCE",
    reward =
    {
        gil   = 5000,
    },
}

local ANDRUS       = "ANDRUS"
local PAGE1        = "PAGE1"
local PAGE2        = "PAGE2"
local PAGE3        = "PAGE3"
local PAGE4        = "PAGE4"
local MEGALOMANIAC = "MEGALOMANIAC"

local PAGE_DIALOG =
{
    DEFAULT  = { "There is nothing out of the ordinary." },
    FINISH   =
    {
        { animation = 48, target = "player", duration = 3000 }, -- Crouch down
        { emotion = "retrieves the book page." }
    },
}

local entity =
{
    {
        id     = ANDRUS,
        name   = "Andrus",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = 1,
            face = 12,
            head = 114,
            body = 63,
            hand = 63,
            legs = 62,
            feet = 139,
            main = 198,
        }),
        area      = "Lufaise_Meadows",
        pos       = { -510.266, -5.363, -39.524, 142 }, -- !pos -510.266 -5.363 -39.524 24
        dialog    =
        {
            NAME      = true,
            DEFAULT   = { "Today I have found myself in a dilemma..." },
            START     =
            {
                "What's going on folks? Today I have found myself in a dilemma.",
                { delay = 1000 },
                { emote = xi.emote.SIGH },
                " Bugards ambushed me on my way to deliver these pages of experience to Jeuno.",
                { delay = 1000 },
                { emote = xi.emote.PANIC },
                { delay = 1000 },
                " I dropped some of them as I fled to the safety of the Safehold.",
                " Could you help me out and recover them please? ",
                " The first page can be found just north east of here. ",
            },
            REMINDER1  = { "The first page can be found just north east of here, try checking from a vantage point!" },
            REMINDER2  = { "The second page can be found near a scary looking shack." },
            REMINDER3  = { "The third page can be found near the Leremieu Lagoon, but be careful!" },
            FINISH =
            {
                { emote = xi.emote.BLUSH },
                "Gee, thanks, you really saved the day!",
                { delay = 1000 },
                " So that's it folks. Remember to take those pages back to Jeuno. Thanks for watching.",
                { delay = 1000 },
                { emote = xi.emote.GOODBYE },
            },
            AFTER     = { "Please like, share, comment, and subscribe." },
        },
    },
    {
        id     = PAGE1,
        name   = "Torn Page",
        marker = cq.SIDE_QUEST,
        area   = "Lufaise_Meadows",
        pos    = { -422.678, -24.062, 156.264 }, -- !pos -422.678 -24.062 156.264 24
        dialog = PAGE_DIALOG,
    },
    {
        id     = PAGE2,
        name   = "Tattered Page",
        marker = cq.SIDE_QUEST,
        area   = "Lufaise_Meadows",
        pos    = { -203.400, -16.284, 308.786 }, -- !pos -203.400 -16.284 308.786 24
        dialog = PAGE_DIALOG,
    },
    {
        id     = PAGE3,
        name   = "Shredded Page",
        marker = cq.SIDE_QUEST,
        area   = "Lufaise_Meadows",
        pos    = { 120.984, -7.500, 14.108 }, -- !pos 120.984 -7.500 14.108 24
        dialog = PAGE_DIALOG,
    },
    {
        id          = MEGALOMANIAC,
        name        = "Megalomaniac",
        look        = 1351,
        type        = xi.objType.MOB,
        groupId     = 65,
        groupZoneId = 24,
        area        = "Lufaise_Meadows",
        pos         = { 129.888, -7.921, 17.015, 96 }, -- !pos 129.888 -7.921 17.015 24
        widescan    = 1,
        level       = 57,
    },
}

local step =
{
    {
        check    = cq.checks({ level = 50, cw = false }),
        [ANDRUS] = cq.talkStep("START", info.name),
    },
    {
        [ANDRUS] = cq.talkOnly("REMINDER1"),
        [PAGE1]  = cq.menuStep("Pick up the torn book page?", { { "No" }, { "Yes", "FINISH" } }, 2),
    },
    {
        [ANDRUS] = cq.talkOnly("REMINDER2"),
        [PAGE2]  = cq.menuStep("Pick up the torn book page?", { { "No" }, { "Yes", "FINISH" } }, 2),
    },
    {
        [ANDRUS] = cq.talkOnly("REMINDER3"),
        [PAGE3]  = cq.menuSpawn(MEGALOMANIAC, "Pick up the torn book page?", { { "No." }, { "Yes." } }, 2, true, { levelCap = 60 }),
        [MEGALOMANIAC] = cq.killStep(PAGE3),
    },
    {
        [ANDRUS] = cq.giveStep("FINISH", info.reward, info.name, cexi.music.NONE),
    },
    {
        [ANDRUS] = cq.talkOnly("AFTER"),
    }
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
