-----------------------------------
-- From the Depths (Lv15)
-----------------------------------
-- !setvar [CQ]FROM_THE_DEPTHS 0
-- Marceo !pos -23.229 1.097 -32.487 252
-----------------------------------
-- !setvar [CQ]FROM_THE_DEPTHS 1

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cq_quest-from_the_depths")

local info =
{
    name   = "From the Depths",
    author = "Loxley",
    var    = "[CQ]FROM_THE_DEPTHS",
    tally  = "[CQ]MARCEO_FISH",
}

local exchange =
{
    -- Greedie (14)
    [4500] =
    {
        { cexi.rate.VERY_COMMON, 16997, "some balls of crayfish paste", { 1, 6 }  }, -- (24%)
        { cexi.rate.VERY_COMMON, 16996, "some balls of sardine paste",  { 1, 6 }  }, -- (24%)
        { cexi.rate.COMMON,        750, "a silver beastcoin"                      }, -- (15%)
        { cexi.rate.UNCOMMON,      750, "a silver beastcoin"                      }, -- (10%)
        { cexi.rate.UNCOMMON,    16993, "some peeled crayfish", { 1, 6 }          }, -- (10%)
        { cexi.rate.UNCOMMON,     4155, "a remedy"                                }, -- (10%)
        { cexi.rate.RARE,        13218, "a bronze moogle belt"                    }, -- ( 5%)
        { cexi.rate.VERY_RARE,    5810, "a creel of moat carp"                    }, -- ( 1%)
        { cexi.rate.VERY_RARE,    6520, "a rancid coffee"                         }, -- ( 1%)
    },

    -- Copper Frog (16)
    [4515] =
    {
        { cexi.rate.VERY_COMMON,   846, "an insect wing",        { 1, 3 } }, -- (24%)
        { cexi.rate.VERY_COMMON,   640, "a chunk of copper ore", { 1, 3 } }, -- (24%)
        { cexi.rate.VERY_COMMON, 17296, "a pebble"                        }, -- (15%)
        { cexi.rate.COMMON,        641, "a chunk of tin ore",    { 1, 2 } }, -- (15%)
        { cexi.rate.UNCOMMON,      642, "a chunk of zinc ore",            }, -- (10%)
        { cexi.rate.RARE,          914, "a vial of mercury",              }, -- ( 5%)
        { cexi.rate.RARE,         5810, "a creel of moat carp"            }, -- ( 5%)
        { cexi.rate.VERY_RARE,     737, "a chunk of gold ore"             }, -- ( 1%)
        { cexi.rate.VERY_RARE,   13469, "a leather ring"                  }, -- ( 1%)
    },

    -- Forest Carp (20)
    [4289] =
    {
        { cexi.rate.COMMON,   16047, "a norg earring"                             }, -- (15%)
        { cexi.rate.COMMON,     748, "a gold beastcoin"                           }, -- (15%)
        { cexi.rate.COMMON,   16998, "some balls of insect paste" , { 1, 6 }      }, -- (15%)
        { cexi.rate.COMMON,   16998, "some balls of insect paste" , { 1, 6 }      }, -- (15%)
        { cexi.rate.COMMON,   16998, "some balls of insect paste" , { 1, 6 }      }, -- (15%)
        { cexi.rate.COMMON,   16998, "some balls of insect paste" , { 1, 6 }      }, -- (15%)
        { cexi.rate.RARE,     16998, "some balls of insect paste" , { 1, 6 }      }, -- (10%)
        { cexi.rate.VERY_RARE, 1649, "a scarlet stone"                            }, -- ( 1%)
    },

    -- Gurnard (26)
    [5132] =
    {
        { cexi.rate.VERY_COMMON, 1179, "some tools of shihei" , { 1, 6 }          }, -- (24%)
        { cexi.rate.COMMON,       694, "a chestnut log"                           }, -- (15%)
        { cexi.rate.COMMON,       690, "an elm log "                              }, -- (15%)
        { cexi.rate.COMMON,       699, "an oak log "                              }, -- (15%)
        { cexi.rate.COMMON,      1126, "a beastman seal"                          }, -- (10%)
        { cexi.rate.COMMON,     18700, "some wind arrows" , { 3, 9 }              }, -- (10%)
        { cexi.rate.COMMON,      5810, "a creel of moat carp"                     }, -- (10%)
        { cexi.rate.SUPER_RARE, 11043, "a giants earring"                         }, -- (.5%)
    },

    -- Blindfish (28)
    [4313] =
    {
        { cexi.rate.VERY_COMMON, 1228, "a darksteel nugget"                       }, -- (24%)
        { cexi.rate.COMMON,      1228, "some darksteel nuggets" , { 1, 2 }        }, -- (15%)
        { cexi.rate.COMMON,      4150, "a flask of eye drops"                     }, -- (15%)
        { cexi.rate.UNCOMMON,    4111, "a dark cluster "                          }, -- (10%)
        { cexi.rate.UNCOMMON,    2183, "some dark cards" , { 1, 6 }               }, -- (10%)
        { cexi.rate.UNCOMMON,    1188, "some sairui-ran" , { 1, 6 }               }, -- (10%)
        { cexi.rate.RARE,        5810, "a creel of moat carp"                     }, -- ( 5%)
        { cexi.rate.RARE,        2542, "a goblin mess tin"                        }, -- ( 5%)
        { cexi.rate.RARE,        4163, "a blinding potion"                        }, -- ( 5%)
        { cexi.rate.SUPER_RARE, 11042, "a rebel earring"                          }, -- (.5%)
    },

    -- Pipara (29)
    [4464] =
    {
        { cexi.rate.VERY_COMMON,   575, "a bag of grain seeds"    }, -- (24%)
        { cexi.rate.VERY_COMMON,   938, "a sprig of papaka grass" }, -- (24%)
        { cexi.rate.COMMON,       1156, "a crawler calculus"      }, -- (15%)
        { cexi.rate.COMMON,       5810, "a creel of moat carp"    }, -- (15%)
        { cexi.rate.UNCOMMON,      833, "a clump of moko grass"   }, -- (10%)
        { cexi.rate.UNCOMMON,      834, "a ball of saruta cotton" }, -- (10%)
        { cexi.rate.VERY_RARE,     816, "a spool of silk thread"  }, -- ( 1%)
        { cexi.rate.VERY_RARE,   13332, "a clear earring"         }, -- ( 1%)
    },

    -- Yayinbaligi (31)
    [5463] =
    {
        { cexi.rate.UNCOMMON, 16050, "a nashmau earring"                          }, -- (10%)
        { cexi.rate.COMMON,    2229, "a chimera blood"                            }, -- (15%)
        { cexi.rate.COMMON,     701, "a rosewood log"                             }, -- (15%)
        { cexi.rate.RARE,       701, "a rosewood log"                             }, -- ( 5%)
        { cexi.rate.COMMON,     702, "an ebony log"                               }, -- (15%)
        { cexi.rate.RARE,       702, "an ebony log"                               }, -- ( 5%)
        { cexi.rate.UNCOMMON,  2157, "an imp horn"                                }, -- (10%)
        { cexi.rate.UNCOMMON,  2181, "some water cards" , { 1, 6 }                }, -- (10%)
        { cexi.rate.RARE,      2503, "an almond"                                  }, -- ( 5%)
        { cexi.rate.RARE,      2488, "an alexandrite"                             }, -- ( 5%)
        { cexi.rate.RARE,      2184, "an imperial bronze piece"                   }, -- ( 5%)
        { cexi.rate.SUPER_RARE, 585, "a muddy bar tab"                            }, -- (.5%)
    },

    -- Veydal Wrasse (37)
    [5141] =
    {
        { cexi.rate.VERY_COMMON, 5810, "a creel of moat carp"                     }, -- (24%)
        { cexi.rate.VERY_COMMON,  895, "a ram horn"                               }, -- (24%)
        { cexi.rate.COMMON,       702, "an ebony log"                             }, -- (15%)
        { cexi.rate.COMMON,      1618, "an uragnite shell"                        }, -- (15%)
        { cexi.rate.UNCOMMON,    1234, "some iron nuggets" , { 1, 3 }             }, -- (10%)
        { cexi.rate.UNCOMMON,    2417, "chunk of aht urhgan brass"                }, -- (10%)
        { cexi.rate.VERY_RARE,  16221, "an aileron mantle"                        }, -- ( 1%)
        { cexi.rate.SUPER_RARE, 11823, "a cocoon band"                            }, -- (.5%)
    },

    -- Nosteau Herring (39)
    [4482] =
    {
        { cexi.rate.VERY_COMMON, 4057, "a gelid aggregate"                        }, -- (24%)
        { cexi.rate.COMMON,       853, "a raptor skin"                            }, -- (15%)
        { cexi.rate.UNCOMMON,     854, "a cockatrice skin"                        }, -- (10%)
        { cexi.rate.UNCOMMON,    2177, "some ice cards" , { 1, 6 }                }, -- (10%)
        { cexi.rate.UNCOMMON,    1182, "some tools of jusatsu" , { 1, 6 }         }, -- (10%)
        { cexi.rate.UNCOMMON,   17323, "some ice arrows" , { 3, 9 }               }, -- (10%)
        { cexi.rate.UNCOMMON,    1126, "a beastman seal"                          }, -- (10%)
        { cexi.rate.RARE,        5810, "a creel of moat carp"                     }, -- ( 5%)
        { cexi.rate.RARE,       14952, "a pair of ice gauntlets"                  }, -- ( 5%)
        { cexi.rate.VERY_RARE,  11677, "a prouesse ring"                          }, -- ( 1%)
    },

    -- Coral Butterfly (40)
    [4580] =
    {
        { cexi.rate.VERY_COMMON,  17395, "some lugworms" , { 1, 3 }                   }, -- (24%)
        { cexi.rate.COMMON,         832, "a clump of sheep wool"                      }, -- (15%)
        { cexi.rate.UNCOMMON,     16039, "a kingdom earring"                          }, -- (10%)
        { cexi.rate.UNCOMMON,     16040, "a republic earring"                         }, -- (10%)
        { cexi.rate.UNCOMMON,     16041, "a federation earring"                       }, -- (10%)
        { cexi.rate.UNCOMMON,     16042, "a duchy earring"                            }, -- (10%)
        { cexi.rate.UNCOMMON,     16043, "a selbina earring"                          }, -- (10%)
        { cexi.rate.UNCOMMON,     16044, "a mhaura earring"                           }, -- (10%)
        { cexi.rate.VERY_RARE,     2315, "a clump of karakul wool"                    }, -- ( 1%)
    },

    -- Giant Donko (50)
    [4306] =
    {
        { cexi.rate.VERY_COMMON,  644, "a chunk of mythril ore"                   }, -- (24%)
        { cexi.rate.SUPER_RARE,   644, "a chunk of mythril ore"                   }, -- (.5%)
        { cexi.rate.COMMON,       843, "giant bird plume" ,                       }, -- (15%)
        { cexi.rate.COMMON,      1163, "a manticore hair"                         }, -- (15%)
        { cexi.rate.UNCOMMON,    5810, "a creel of moat carp"                     }, -- (10%)
        { cexi.rate.UNCOMMON,     889, "a beetle shell"                           }, -- (10%)
        { cexi.rate.UNCOMMON,   16045, "a rabao earring"                          }, -- (10%)
        { cexi.rate.RARE,         838, "a spider web"                             }, -- ( 5%)
        { cexi.rate.RARE,        2198, "a water spider's web"                     }, -- ( 5%)
        { cexi.rate.RARE,       16065, "a storm zucchetto"                        }, -- ( 5%)
        { cexi.rate.SUPER_RARE, 11920, "a pair of melaco mittens"                 }, -- (.5%)
    },

    -- Kaplumbaga (53)
    [5464] =
    {
        { cexi.rate.VERY_COMMON, 5569, "a puk egg"                                }, -- (24%)
        { cexi.rate.COMMON,      5568, "an apkallu egg"                           }, -- (15%)
        { cexi.rate.RARE,        5568, "an apkallu egg"                           }, -- ( 5%)
        { cexi.rate.COMMON,       885, "a turtle shell"                           }, -- (15%)
        { cexi.rate.UNCOMMON,    5566, "a sweet sticky date"                      }, -- (10%)
        { cexi.rate.UNCOMMON,    2175, "a chunk of flan meat"                     }, -- (10%)
        { cexi.rate.RARE,       14999, "a pair of vampiric mitts"                 }, -- ( 5%)
        { cexi.rate.RARE,       15745, "a pair of vampiric boots"                 }, -- ( 5%)
        { cexi.rate.RARE,        2763, "a chunk of swamp ore"                     }, -- ( 5%)
        { cexi.rate.RARE,        2365, "a demon blood"                            }, -- ( 5%)
        { cexi.rate.SUPER_RARE,  1271, "a pigeon's blood ruby"                    }, -- (.5%)
    },   

    -- Vongola Clam (53)
    [5131] =
    {
        { cexi.rate.VERY_COMMON,  792, "a pearl"                                  }, -- (24%)
        { cexi.rate.VERY_COMMON, 2305, "an auric sand"                            }, -- (24%)
        { cexi.rate.ULTRA_RARE,  2305, "an auric sand"                            }, -- (0.1%)
        { cexi.rate.ULTRA_RARE,  2305, "an auric sand"                            }, -- (0.1%)
        { cexi.rate.ULTRA_RARE,  2305, "an auric sand"                            }, -- (0.1%)
        { cexi.rate.SUPER_RARE,  2305, "an auric sand"                            }, -- (0.5%)
        { cexi.rate.UNCOMMON,     887, "a coral fragment"                         }, -- (10%)
        { cexi.rate.UNCOMMON,     793, "a black pearl"                            }, -- (10%)
        { cexi.rate.UNCOMMON,    4318, "a bibiki urchin"                          }, -- (10%)
        { cexi.rate.UNCOMMON,    4450, "a coral fungus"                           }, -- (10%)
        { cexi.rate.RARE,        1715, "a vivified coral"                         }, -- ( 5%)
        { cexi.rate.RARE,       15968, "a storm loop"                             }, -- ( 5%)
        { cexi.rate.VERY_RARE,  11041, "a liminus earring"                        }, -- ( 1%)
        { cexi.rate.ULTRA_RARE,  1274, "a southern pearl"                         }, -- (.1%)
    },

    -- Elshimo Newt (60)
    [4579] =
    {
        { cexi.rate.VERY_COMMON,   846, "an insect wing",                { 1, 3 } }, -- (24%)
        { cexi.rate.COMMON,        912, "a beehive chip",                { 1, 2 } }, -- (15%)
        { cexi.rate.COMMON,      17296, "a pebble"                                }, -- (15%)
        { cexi.rate.COMMON,       5810, "some creels of moat carp",      { 1, 2 } }, -- (15%)
        { cexi.rate.UNCOMMON,      925, "a giant stinger"                         }, -- (10%)
        { cexi.rate.UNCOMMON,     4432, "a kazham pineapple"                      }, -- (10%)
        { cexi.rate.RARE,          574, "a bag of fruit seeds"                    }, -- ( 5%)
        { cexi.rate.RARE,         4357, "a crawler egg"                           }, -- ( 5%)
        { cexi.rate.VERY_RARE,    5680, "an agaricus"                             }, -- ( 1%)
    },

    -- Kilicbaligi (61)
    [5451] =
    {
        { cexi.rate.VERY_COMMON,  736, "some chunks of silver ore" , { 1, 3 }     }, -- (24%)
        { cexi.rate.COMMON,      2488, "some pieces of alexandrite" , { 1, 6 }    }, -- (15%)
        { cexi.rate.COMMON,       737, "some chunks of gold ore" , { 1, 2 }       }, -- (15%)
        { cexi.rate.COMMON,      2147, "a marid tusk"                             }, -- (15%)
        { cexi.rate.UNCOMMON,     738, "a platinum ore"                           }, -- (10%)
        { cexi.rate.RARE,       17726, "an immortal's shotel"                     }, -- ( 5%)
        { cexi.rate.RARE,        2185, "an imperial silver piece"                 }, -- ( 5%)
        { cexi.rate.RARE,        2228, "a chunk of luminium ore"                  }, -- ( 5%)
        { cexi.rate.RARE,        4474, "a gigant squid"                           }, -- ( 5%)
        { cexi.rate.SUPER_RARE, 18624, "a numen staff"                            }, -- (.5%)
    },

    -- Crescent Fish (69)
    [4473] =
    {
        { cexi.rate.VERY_COMMON, 1449, "a tukuku whiteshell"                      }, -- (24%)
        { cexi.rate.UNCOMMON,     912, "a beehive chip"                           }, -- (10%)
        { cexi.rate.UNCOMMON,    2475, "a kaolin"                                 }, -- (10%)
        { cexi.rate.UNCOMMON,    1165, "a doll shard"                             }, -- (10%)
        { cexi.rate.UNCOMMON,    1310, "a platinum leaf"                          }, -- (10%)
        { cexi.rate.UNCOMMON,    1524, "a sprig of fresh mugwort"                 }, -- (10%)
        { cexi.rate.UNCOMMON,    2198, "a water spider's web"                     }, -- (10%)
        { cexi.rate.RARE,        4387, "a wild onion"                             }, -- ( 5%)
        { cexi.rate.RARE,       15705, "a pair of ataractic solea"                }, -- ( 5%)
        { cexi.rate.RARE,        2539, "a tuft of dhalmel hair"                   }, -- ( 5%)
        { cexi.rate.SUPER_RARE, 11575, "a grapevine cape"                         }, -- (.5%)
        { cexi.rate.SUPER_RARE,  1270, "an arachne web"                           }, -- (.5%)
    },
    
    -- Tavnazian Goby (75)
    [5130] =
    {
        { cexi.rate.VERY_COMMON, 1452, "an ordelle's bronzepiece"                 }, -- (24%)
        { cexi.rate.VERY_COMMON, 1226, "some mythril nuggets" , { 1, 3 }          }, -- (24%)
        { cexi.rate.COMMON,      5810, "some creels of moat carp", { 1, 2 }       }, -- (15%)
        { cexi.rate.COMMON,       842, "a giant bird feather"                     }, -- (15%)
        { cexi.rate.COMMON,       845, "a black chocobo feather"                  }, -- (15%)
        { cexi.rate.RARE,       18487, "an erik's axe"                            }, -- ( 5%)
        { cexi.rate.VERY_RARE,   4279, "a tavnazian salad"                        }, -- ( 1%)
        { cexi.rate.SUPER_RARE, 18784, "a pair of metasoma katars"                }, -- (.5%)
    },

    -- Silver Shark (76)
    [4451] =
    {
        { cexi.rate.VERY_COMMON, 1233, "some silver nuggets" , { 1, 2 }           }, -- (24%)
        { cexi.rate.UNCOMMON,    1225, "some gold nuggets" , { 1, 2 }             }, -- (10%)
        { cexi.rate.UNCOMMON,     861, "a black tiger hide"                       }, -- (10%)
        { cexi.rate.SUPER_RARE,  8798, "a pinch of high-purity bayld"             }, -- (.5%)
        { cexi.rate.UNCOMMON,    5810, "some creels of moat carp", { 1, 3 }       }, -- (10%)
        { cexi.rate.RARE,         930, "a vial of beastman blood"                 }, -- ( 5%)
        { cexi.rate.RARE,        4096, "a fire crystal"                           }, -- ( 5%)
        { cexi.rate.RARE,        4097, "an ice crystal"                           }, -- ( 5%)
        { cexi.rate.RARE,        4098, "a wind crystal"                           }, -- ( 5%)
        { cexi.rate.RARE,        4099, "an earth crystal"                         }, -- ( 5%)
        { cexi.rate.RARE,        4100, "a lightning crystal"                      }, -- ( 5%)
        { cexi.rate.RARE,        4101, "a water crystal"                          }, -- ( 5%)
        { cexi.rate.RARE,        4102, "a light crystal"                          }, -- ( 5%)
        { cexi.rate.RARE,        4103, "a dark crystal"                           }, -- ( 5%)
        { cexi.rate.SUPER_RARE, 13614, "a bonze cape"                             }, -- (0.5%)
    },

    -- Jungle Catfish (80)
    [4307] =
    {
        { cexi.rate.VERY_COMMON, 5810, "some creels of moat carp", { 2, 4 }       }, -- (24%)
        { cexi.rate.COMMON,      1446, "a lacquer tree log"                       }, -- (15%)
        { cexi.rate.COMMON,      4598, "a wild pineapple"                         }, -- (15%)
        { cexi.rate.COMMON,       920, "a malboro vine"                           }, -- (15%)
        { cexi.rate.UNCOMMON,    4357, "a crawler egg"                            }, -- (10%)
        { cexi.rate.UNCOMMON,    4468, "bunches of pamamas"                       }, -- (10%)
        { cexi.rate.RARE,        4290, "an elshimo frog"                          }, -- ( 5%)
        { cexi.rate.RARE,        4412, "a thundermelon"                           }, -- ( 5%)
        { cexi.rate.VERY_RARE,   4273, "a handful of kitrons", { 2, 3 }           }, -- ( 1%)
    },

    -- Gavial Fish (81)
    [4477] =
    {
        { cexi.rate.VERY_COMMON, 1455, "a 1 byne bill"                            }, -- (24%)
        { cexi.rate.COMMON,       895, "a ram horn"                               }, -- (15%)
        { cexi.rate.COMMON,       898, "a chicken bone"                           }, -- (15%)
        { cexi.rate.UNCOMMON,     866, "a wyvern scale"                           }, -- (10%)
        { cexi.rate.UNCOMMON,    2747, "a gargouille horn"                        }, -- (10%)
        { cexi.rate.UNCOMMON,    1616, "an antlion jaw"                           }, -- (10%)
        { cexi.rate.UNCOMMON,    5810, "a creel of moat carp"                     }, -- (10%)
        { cexi.rate.RARE,       15517, "a sniper's collar"                        }, -- ( 5%)
        { cexi.rate.VERY_RARE,  13217, "a silver moogle belt"                     }, -- ( 1%)
    },

    -- Black Ghost (88)
    [5138] =
    {
        { cexi.rate.VERY_COMMON, 2488, "some pieces of alexandrite" , { 6, 18 }   }, -- (24%)
        { cexi.rate.COMMON,       878, "a karakul skin"                           }, -- (15%)
        { cexi.rate.COMMON,       703, "a petrified log", { 1, 3 }                }, -- (15%)
        { cexi.rate.COMMON,       738, "a chunk of platinum ore"                  }, -- (15%)
        { cexi.rate.COMMON,      5810, "a creel of moat carp" ,                   }, -- (15%)
        { cexi.rate.RARE,        2156, "a clump of imperial tea leaves"           }, -- ( 5%)
        { cexi.rate.RARE,        2228, "some chunks of luminium ore" , { 1, 3 }   }, -- ( 5%)
        { cexi.rate.RARE,       15998, "a kocco's earring"                        }, -- ( 5%)
        { cexi.rate.SUPER_RARE, 11576, "a bond cape"                              }, -- (.5%)
    },
    
    -- Morinabaligi (91)
    [5462] =
    {
        { cexi.rate.VERY_COMMON, 2147, "a marid tusk"                             }, -- (24%)
        { cexi.rate.COMMON,      5566, "a sweet sticky date"                      }, -- (15%)
        { cexi.rate.COMMON,      5810, "a creel of moat carp", { 2, 3 }           }, -- (15%)
        { cexi.rate.COMMON,      1446, "a lacquer tree log"                       }, -- (15%)
        { cexi.rate.UNCOMMON,    2175, "a flan meat"                              }, -- (10%)
        { cexi.rate.UNCOMMON,    2156, "a clump of imperial tea leaves"           }, -- (10%)
        { cexi.rate.RARE,         838, "some spider webs" , { 1, 3}               }, -- ( 5%)
        { cexi.rate.RARE,        2185, "an imperial silver piece"                 }, -- ( 5%)
        { cexi.rate.SUPER_RARE, 19780, "a mana ampulla"                           }, -- (.5%)
    },
    
    -- Tiger Shark (99)
    [5817] =
    {
        { cexi.rate.VERY_COMMON,   856, "a rabbit hide"                           }, -- (24%)
        { cexi.rate.UNCOMMON,     4096, "a fire crystal"                          }, -- (10%)
        { cexi.rate.UNCOMMON,     4097, "an ice crystal"                          }, -- (10%)
        { cexi.rate.UNCOMMON,     4098, "a wind crystal"                          }, -- (10%)
        { cexi.rate.UNCOMMON,     4099, "an earth crystal"                        }, -- (10%)
        { cexi.rate.UNCOMMON,     4100, "a lightning crystal"                     }, -- (10%)
        { cexi.rate.UNCOMMON,     4101, "a water crystal"                         }, -- (10%)
        { cexi.rate.RARE,         4102, "a light crystal"                         }, -- ( 5%)
        { cexi.rate.RARE,         4103, "a dark crystal"                          }, -- ( 5%)
        { cexi.rate.RARE,          737, "a gold ore"                              }, -- ( 5%)
        { cexi.rate.SUPER_RARE,  19779, "a potestas bomblet"                      }, -- (.5%)
    },
    
    -- Sea Zombie (100)
    [4475] =
    {
        { cexi.rate.VERY_COMMON, 17006, "a drill calamary"                        }, -- (24%)
        { cexi.rate.UNCOMMON,     4104, "a fire cluster", { 2, 4 }                }, -- (10%)
        { cexi.rate.UNCOMMON,     4105, "an ice cluster", { 2, 4 }                }, -- (10%)
        { cexi.rate.UNCOMMON,     4106, "a wind cluster", { 2, 4 }                }, -- (10%)
        { cexi.rate.UNCOMMON,     4107, "an earth cluster", { 2, 4 }              }, -- (10%)
        { cexi.rate.UNCOMMON,     4108, "a lightning cluster", { 2, 4 }           }, -- (10%)
        { cexi.rate.UNCOMMON,     4109, "a water cluster", { 2, 4 }               }, -- (10%)
        { cexi.rate.RARE,         4110, "a light cluster", { 2, 4 }               }, -- ( 5%)
        { cexi.rate.RARE,         4111, "a dark cluster", { 2, 4 }                }, -- ( 5%)
        { cexi.rate.RARE,          739, "a orichalcum ore"                        }, -- ( 5%)
        { cexi.rate.SUPER_RARE,  10991, "a rancourous mantle"                     }, -- (.5%)
    },
    
    -- Armored Pisces (108)
    [4316] =
    {
        { cexi.rate.VERY_COMMON,  644, "a chunk of mythril ore"                   }, -- (24%)
        { cexi.rate.COMMON,      5810, "a creel of moat carp" ,                   }, -- (15%)
        { cexi.rate.RARE,        5810, "a creel of moat carp" ,                   }, -- ( 5%)
        { cexi.rate.SUPER_RARE,  5810, "a creel of moat carp" ,                   }, -- (.5%)
        { cexi.rate.UNCOMMON,     736, "a chunk of silver ore",                   }, -- (10%)
        { cexi.rate.UNCOMMON,     643, "some chunks of iron ore", { 1, 3 }        }, -- (10%)
        { cexi.rate.UNCOMMON,     738, "a chunk of platinum ore", { 1, 2 }        }, -- (10%)
        { cexi.rate.UNCOMMON,     645, "a chunk of darksteel ore", { 1, 2 }       }, -- (10%)
        { cexi.rate.UNCOMMON,    1155, "a pile of iron sand"                      }, -- (10%)
        { cexi.rate.RARE,         646, "a chunk of adaman ore", { 1, 2 }          }, -- ( 5%)
        { cexi.rate.SUPER_RARE, 18816, "a wizzan grip"                            }, -- (.5%)
    },

    [5127] = -- Gugrusaurus (120)
    {
        {                955,  { gil = 1760 }, "a handful of gil" }, -- (95.5%)
        { cexi.rate.SUPER_RARE,          1837, "a saber shoot"    }, -- ( 0.5%)
    },

    [5129] = -- Lik (120)
    {
        {                955,  { gil = 1760 }, "a handful of gil"     }, -- (95.5%)
        { cexi.rate.SUPER_RARE,          1826, "a spool of opal silk" }, -- ( 0.5%)
    },

    -- Cave Cherax (130)
    [4309] =
    {
        { cexi.rate.VERY_COMMON, 17007, "a dwarf pugil"                           }, -- (24%)
        { cexi.rate.UNCOMMON,     4104, "a fire cluster", { 1, 3 }                }, -- (10%)
        { cexi.rate.UNCOMMON,     4105, "an ice cluster", { 1, 3 }                }, -- (10%)
        { cexi.rate.UNCOMMON,     4106, "a wind cluster", { 1, 3 }                }, -- (10%)
        { cexi.rate.UNCOMMON,     4107, "an earth cluster", { 1, 3 }              }, -- (10%)
        { cexi.rate.UNCOMMON,     4108, "a lightning cluster", { 1, 3 }           }, -- (10%)
        { cexi.rate.UNCOMMON,     4109, "a water cluster", { 1, 3 }               }, -- (10%)
        { cexi.rate.RARE,         4110, "a light cluster", { 1, 3 }               }, -- ( 5%)
        { cexi.rate.RARE,         4111, "a dark cluster", { 1, 3 }                }, -- ( 5%)
        { cexi.rate.RARE,         2228, "a luminium ore"                          }, -- ( 5%)
        { cexi.rate.SUPER_RARE,  11038, "a dragonkin earring"                     }, -- (.5%)
    },

    -- Quicksilver Blade (130)
    [6371] =
    {
        { cexi.rate.VERY_COMMON,  5571, "a karakul meat"                          }, -- (24%)
        { cexi.rate.UNCOMMON,     4104, "a fire cluster", { 1, 3 }                }, -- (10%)
        { cexi.rate.UNCOMMON,     4105, "an ice cluster", { 1, 3 }                }, -- (10%)
        { cexi.rate.UNCOMMON,     4106, "a wind cluster", { 1, 3 }                }, -- (10%)
        { cexi.rate.UNCOMMON,     4107, "an earth cluster", { 1, 3 }              }, -- (10%)
        { cexi.rate.UNCOMMON,     4108, "a lightning cluster", { 1, 3 }           }, -- (10%)
        { cexi.rate.UNCOMMON,     4109, "a water cluster", { 1, 3 }               }, -- (10%)
        { cexi.rate.RARE,         4110, "a light cluster", { 1, 3 }               }, -- ( 5%)
        { cexi.rate.RARE,         4111, "a dark cluster", { 1, 3 }                }, -- ( 5%)
        { cexi.rate.RARE,         2156, "an imperial tea leaf"                    }, -- ( 5%)
        { cexi.rate.SUPER_RARE,  18812, "an ossa grip"                            }, -- (.5%)
    },
    
    -- Matsaya (150)
    [5468] =
    {
        { cexi.rate.VERY_COMMON,  8798, "pinches of high-purity bayld", { 3, 6 }  }, -- (24%)
        { cexi.rate.UNCOMMON,      887, "a coral fragment"                        }, -- (10%)
        { cexi.rate.RARE,         4104, "a fire cluster", { 2, 4 }                }, -- ( 5%)
        { cexi.rate.RARE,         4105, "an ice cluster", { 2, 4 }                }, -- ( 5%)
        { cexi.rate.RARE,         4106, "a wind cluster", { 2, 4 }                }, -- ( 5%)
        { cexi.rate.RARE,         4107, "an earth cluster", { 2, 4 }              }, -- ( 5%)
        { cexi.rate.RARE,         4108, "a lightning cluster", { 2, 4 }           }, -- ( 5%)
        { cexi.rate.RARE,         4109, "a water cluster", { 2, 4 }               }, -- ( 5%)
        { cexi.rate.RARE,         4110, "a light cluster", { 2, 4 }               }, -- ( 5%)
        { cexi.rate.RARE,         4111, "a dark cluster", { 2, 4 }                }, -- ( 5%)
        { cexi.rate.RARE,         4273, "a kitron"                                }, -- ( 5%)
        { cexi.rate.RARE,          734, "a chunk of thokcha ore"                  }, -- ( 5%)
        { cexi.rate.RARE,          741, "a chunk of palladium brass ore"          }, -- ( 5%)
        { cexi.rate.RARE,          740, "a chunk of phrygian ore"                 }, -- ( 5%)
        { cexi.rate.RARE,        11009, "a shaper's shawl"                        }, -- ( 5%)
    },

}

local MARCEO = "MARCEO"
local entity =
{
    {
        id        = MARCEO,
        name      = "Marceo",
        type      = xi.objType.NPC,
        look      = cexi.util.look({
            race = xi.race.HUME_M,
            face = cexi.face.A1,
            head = cexi.model.TACTICIAN_MAGICIAN,
            body = cexi.model.RASETSU_SAMUE,
            hand = cexi.model.RASETSU_SAMUE,
            legs = cexi.model.RASETSU_SAMUE,
            feet = cexi.model.RASETSU_SAMUE,
        }),
        area   = "Norg",
        pos    = { -23.229, 1.097, -32.487, 157 }, -- !pos -23.229 1.097 -32.487 252
        dialog =
        {
            NAME     = true,
            DEFAULT  =
            {
                "Many years ago, I left my life behind and came here to fish."
            },
        },
    },
}

local step =
{
    {
        check    = cq.checks({ level = 15 }),
        [MARCEO] = cq.dialog({
            quest = info.name,
            name  = "Marceo",
            event =
            {
                "Many years ago, I left my life behind and came here to fish.",
                " Fishing is not just an art but a process of discovery.",
                "In these depths we find ourselves and many items left long ago.",
                " Bring me particular fish and I'll look inside for items.",
            },
        }),
    },
    {
        [MARCEO] =
        {
            onTrigger = cq.dialog({
                step  = false,
                name  = "Marceo",
                event =
                {
                    "Bring me particular fish and I'll look inside for items.",
                    " Make sure you can carry it. I won't hold on to the excess.",
                },
            }),
            onTrade   = cq.trade({
                quest    = info.name,
                music    = cexi.music.NORG,
                tally    = info.tally,
                name     = "Marceo",
                step     = false,
                exchange = exchange,
                replacements =
                {
                    [1826] = xi.item.BLANK_KEY, -- Rancorous Mantle -> Blank key
                    [11038] = xi.item.AETHER_KEY, -- dragonkin earring -> Aether key
                    [18812] = xi.item.ELEMENTIUM_INGOT, -- ossa grip -> Elementium Ingot
                    [11009] = xi.item.PRISMATIC_KEY, -- shaper's shawl -> prismatic key
                },
                accepted =
                {
                    { delay = 300 },
                    { emote = xi.emote.THINK },
                    "All right, let's see what's inside...",
                    { delay = 200 },
                },
                declined =
                {
                    "Unfortunately, I don't know anything about this species."
                },
            }),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
