-----------------------------------
-- Broken Bones (Lv65)
-----------------------------------
-- !setvar [CQ]BROKEN_BONES 0
-- Reward: Access to Onzozo Excavation
-- Felyna      !pos -55.619 -23.956 23.418 249
-- Buried Note !pos -489.512 -27.642 93.076 96
-- Felyna      !pos -55.619 -23.956 23.418 249
-----------------------------------
-- !setvar [CQ]BROKEN_BONES 3

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-broken_bones")

local info =
{
    name   = "Broken Bones",
    author = "Loxley",
    var    = "[CQ]BROKEN_BONES",
    reward =
    {
        item    = 17355,                    -- Rose Harp
        augment = { 514, 0, 31, 3, 51, 1 }, -- VIT +1, Evasion +4, HP recovered while healing+2
        after = function(player)
            player:setCharVar("[CQ]ONZOZO_EXCAVATION", 1)
            player:printToPlayer("You have unlocked the ability to perform Excavation in The Labyrinth of Onzozo.", xi.msg.channel.SYSTEM_3)
            return true
        end,
    },
}

local FELYNA = "FELYNA"
local BURIED = "BURIED"

local entity =
{
    {
        id     = FELYNA,
        name   = "Felyna",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.HUME_F,
            face = cexi.face.B3,
            head = cexi.model.NOTHING,
            body = cexi.model.VERMILLION_CLOAK,
            hand = cexi.model.NOTHING,
            legs = cexi.model.SHAIR_MANTEEL,
            feet = cexi.model.SHAIR_MANTEEL,
        }),
        area   = "Mhaura",
        pos    = { -55.619, -23.956, 23.418, 19 }, -- !pos -55.619 -23.956 23.418 249
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "So much lies buried beneath our feet..." },
            START    =
            {
                "Many years ago, I was stationed in Fort Karugo-Narugo, not far from here.",
                { music = cexi.music.SORROW },
                " One day, the Yagudo overran us and now it's left in ruins.",
                " I escaped with a few broken bones but many did not have that luxury.",
                { emote = xi.emote.SIGH },
                { music = 159 },
                { delay = 2000 },
                "It may be impossible to reach the Fort now. Forever lost, like my lover to be.",
                { emote = xi.emote.NO },
                { delay = 1000 },
                " He'd get off duty, and we'd sneak around the back to stare out at the Bastore Sea.",
                " We used to leave each other messages there, in that very spot.",
                { emote = xi.emote.THINK },
                { delay = 3000 },
                "So much lies buried beneath our feet... But please forgive my rambling.",
                { music = cexi.music.MHAURA },
            },
            REMINDER =
            {
                "I'd get off duty, and we'd sneak around the back to stare out at the Bastore Sea.",
                " We used to leave each other messages there, in that very spot.",
            },
            FINISH   =
            {
                { emote = xi.emote.SHOCKED },
                "What!? How did you?...",
                "... Thank you.",
                { delay = 500 },
                { emote = xi.emote.CRY },
                { delay = 2000 },
                "It's not much, but I know of a place nearby where you may find treasure of your own...",
            },
        },
    },
    {
        id       = "BURIED",
        name     = "Buried Note",
        marker   = cq.SIDE_QUEST,
        area     = "Fort_Karugo-Narugo_[S]",
        pos      = { -489.512,  -27.642, 93.076 }, --!pos -489.512 -27.642 93.076 96
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            COLLECT =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                "You dig out the crumpled note.",
            },
        },
    },
}

local step =
{
    {
        check    = cq.checks({ level = 65 }),
        [FELYNA] = cq.talkStep("START", info.name),
    },
    {
        [FELYNA] = cq.talkOnly("REMINDER"),
        [BURIED] = cq.talkStep("COLLECT"),
    },
    {
        [BURIED] = cq.talkOnly("AFTER"),
        [FELYNA] = cq.giveStep("FINISH", info.reward, info.name, cexi.music.MHAURA),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
