-------------------------------------------------------
-- Blast to the Past (Lv60)
-------------------------------------------------------
-- Steps
-------------------------------------------------------
-- !setvar [CQ]BLAST_TO_THE_PAST 0
-- Ash          !pos -153.897 -7.296 448.043 84
-- Page 1       !pos -257.179 -9.363 402.705 84
-- Page 2       !pos -81.192  0.493 212.948 84
-- Page 3       !pos -88.002 -7.978  32.456 84
-- NM           !pos -92.019 -8.000  27.755 84
-- Unlocks EXP Guide (S)
-------------------------------------------------------
-- !setvar [CQ]BLAST_TO_THE_PAST 5

local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-------------------------------------------------------
local m = Module:new("cq_quest-blast_to_the_past")

local info =
{
    name   = "Blast to the Past",
    author = "Carver",
    var    = "[CQ]BLAST_TO_THE_PAST",
    reward =
    {
        gil   = 5000,
    },
}

local ASH                  = "ASH"
local PAGE1                = "PAGE1"
local PAGE2                = "PAGE2"
local PAGE3                = "PAGE3"
local PAGE4                = "PAGE4"
local ASSASSIN_COCKATRICE  = "ASSASSIN_COCKATRICE"

local PAGE_DIALOG =
{
    DEFAULT  = { "There is nothing out of the ordinary." },
    FINISH   =
    {
        { animation = 48, target = "player", duration = 3000 }, -- Crouch down
        { emotion = "retrieves the book page." }
    },
}

local entity =
{
    {
        id     = ASH,
        name   = "Ash",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = 1,
            face = 1,
            head = 119,
            body = 67,
            hand = 67,
            legs = 67,
            feet = 67,
            main = 143,
            offh = 143,
        }),
        area      = "Batallia_Downs_[S]",
        pos       = { -153.897, -7.296, 448.043, 0 }, -- !pos -153.897 -7.296 448.043 84
        dialog    =
        {
            NAME      = true,
            DEFAULT   = { "Go make yourself a cuppa tea!" },
            START     =
            {
                "Well aren't you just a beefy unit! I've got a favor to ask. ",
                { delay = 1000 },
                { emote = xi.emote.SHOCKED },
                " I was on my way to return a legendary book to Ru'Lude Gardens when I was suddenly distracted by an Elvaan Summoner sliding past.",
                { delay = 1000 },
                { emote = xi.emote.STAGGER },
                { delay = 1000 },
                " A gust of hot wind lifted the book from my hands and left some pages scattered nearby.",
                " Would you be a good lad and retrieve them for me? ",
                " The first page can be found just west of here, please fetch it for me! ",
            },
            REMINDER1  = { "The first page can be found just west of here, please fetch it for me lad!" },
            REMINDER2  = { "The second page can be found just off the path to the sea of shumeyo near the center of the map." },
            REMINDER3  = { "The third page can be found near the center of the map, please fetch it for me lad!" },
            FINISH =
            {
                { emote = xi.emote.JOY },
                "What an absolute unit! You must displace a lot of water!",
                { delay = 1000 },
                " Please take these pages back to the EXP Guide (S) in Ru'Lude Gardens.",
                { delay = 1000 },
                { emote = xi.emote.GOODBYE },
            },
            AFTER     = { "The sky giveth and the sky taketh away." },
        },
    },
    {
        id     = PAGE1,
        name   = "Torn Page",
        marker = cq.SIDE_QUEST,
        area   = "Batallia_Downs_[S]",
        pos    = { -257.179, -9.363, 402.705 }, -- !pos -257.179 -9.363 402.705 84
        dialog = PAGE_DIALOG,
    },
    {
        id     = PAGE2,
        name   = "Tattered Page",
        marker = cq.SIDE_QUEST,
        area   = "Batallia_Downs_[S]",
        pos    = { -81.192, 0.493, 212.948 }, -- !pos -81.192  0.493 212.948 84
        dialog = PAGE_DIALOG,
    },
    {
        id     = PAGE3,
        name   = "Shredded Page",
        marker = cq.SIDE_QUEST,
        area   = "Batallia_Downs_[S]",
        pos    = { -88.002, -7.978, 32.456 }, -- !pos -88.002 -7.978 32.456 84
        dialog = PAGE_DIALOG,
    },
    {
        id          = ASSASSIN_COCKATRICE,
        name        = "Assassin Coq",
        look        = 288,
        type        = xi.objType.MOB,
        groupId     = 34,
        groupZoneId = 120,
        area        = "Batallia_Downs_[S]",
        pos         = { -92.019, -8.000, 27.755, 0 }, -- !pos -92.019 -8.000 27.755 84
        widescan    = 1,
        level       = 60,
    },
}

local step =
{
    {
        check = cq.checks({ level = 60 }),
        [ASH] = cq.talkStep("START", info.name),
    },
    {
        [ASH]   = cq.talkOnly("REMINDER1"),
        [PAGE1] = cq.menuStep("Pick up the torn book page?", { { "No" }, { "Yes", "FINISH" } }, 2),
    },
    {
        [ASH]   = cq.talkOnly("REMINDER2"),
        [PAGE2] = cq.menuStep("Pick up the torn book page?", { { "No" }, { "Yes", "FINISH" } }, 2),
    },
    {
        [ASH]   = cq.talkOnly("REMINDER3"),
        [PAGE3] = cq.menuSpawn(ASSASSIN_COCKATRICE, "Pick up the torn book page?", { { "No." }, { "Yes." } }, 2, true, { levelCap = 60 }),
        [ASSASSIN_COCKATRICE] = cq.killStep(PAGE3, { ASSASSIN_COCKATRICE }, nil, { helper = xi.item.DRAGON_CHRONICLES }),
    },
    {
        [ASH] = cq.giveStep("FINISH", info.reward, info.name, cexi.music.NONE),
    },
    {
        [ASH] = cq.talkOnly("AFTER"),
    }
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
