-----------------------------------
-- Adept Reforging (Lv65)
-----------------------------------
-- !setvar [CQ]ADEPT 0
-- Adeptus !pos 118.823 8.000 115.162 247

-- (White Mage Example)

-- 10 Ghoul in Maze of Shakhrami
-- !setvar [CQ]ADEPT_TRIAL_WHM_1 8
-- !gotoid 17588317
-- !gotoid 17588318

-- 10 Tomb Mage in The Eldieme Necropolis
-- !setvar [CQ]ADEPT_TRIAL_WHM_2 8
-- !gotoid 17576223
-- !gotoid 17576224

-- 10 Tomb Warrior in The Eldieme Necropolis
-- !setvar [CQ]ADEPT_TRIAL_WHM_3 8
-- !gotoid 17576221
-- !gotoid 17576222

-- Adeptus         !pos 118.823 8.000 115.162 247
-- Pile of Bones   !pos 326.081 -60.426 477.909 106

-- Adeptus         !pos 118.823 8.000 115.162 247
-- Disturbed Rocks !pos 150.785 -12.360 -90.396 212

-- Adeptus         !pos 118.823 8.000 115.162 247
-- Shimmering Sand !pos -411.223 -1.307 328.763 125

-- Adeptus         !pos 118.823 8.000 115.162 247
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
----------------------------------------------------------
local m = Module:new("cq_adept_reforging")

local ADEPTUS         = "ADEPTUS"
local SHIMMERING_SAND = "SHIMMERING_SAND"
local DESERT_HARE     = "DESERT_HARE"

-----------------------------------
-- Trials (Add new trials here)
-----------------------------------

local trial =
{
    [xi.job.BLM] =
    {
        sets  =
        {
            "Genie Attire",
        },
        kills =
        {
            { "Goblin_Bombardier",       "Meriphataud_Mountains_[S]", 10 }, -- !gotoid 17174622
            { "Sapphire_Quadav",         "Beadeaux",                  10 }, -- !gotoid 17379738
            { "Tonberry_Maledictor",     "Temple_of_Uggalepih",       30 }, -- !gotoid 17428670
            { "Bistre-hearted_Malberry", "Den_of_Rancor",              1 }, -- !spawnmob 17432845 !gotoid 17432845
            { "Marquis_Naberius",        "Castle_Zvahl_Baileys",       1 }, -- !spawnmob 17436876 !gotoid 17436876
        },
        battle =
        {
            LEVEL_30 =
            {
                mobID       = "TIMELOST_TOME",
                popID       = "CRYPTIC_MARKING",
                mob         = "Timelost Tome",
                pop         = "Cryptic Marking",
                area        = "Outer_Horutoto_Ruins",
                look        = 2228,
                groupId     = 67,
                groupZoneId = 289,
                pos         = { -384.257, -2.471, 718.328, 60 }, -- !pos -384.257 -2.471 718.328 194
                level       = 30,
            },
            LEVEL_50 =
            {
                mobID       = "FROST_HARBINGER",
                popID       = "CORRUPTED_SEAL",
                mob         = "Frost Harbinger",
                pop         = "Corrupted Seal",
                area        = "PsoXja", -- (I-7) Entrance (Uncapped)
                groupId     = 55,
                groupZoneId = 194,
                pos         = { 243.063, 16.000, 356.995, 32 }, -- !pos 243.063 16.000 356.995 9
                level       = 50,
            },
        },
        armor =
        {
            {
                base = {       15159, "Igqira Tiara"       },
                high = {       15160, "Genie Tiara"        },
                item = { { 506, 12 }, "Coeurl Leather x12" },
                augs =
                {
                    { 516, 3, 35, 2, 140, 0          }, -- INT +4, Magic Accuracy +3,  Fast Cast +1%
                    { 516, 5, 35, 3, 140, 1, 1251, 4 }, -- INT +6, Magic Accuracy +4,  Fast Cast +2%, Enfeebling Magic Duration +5%
                    { 516, 7, 35, 4, 140, 2, 1251, 9 }, -- INT +8, Magic Accuracy +5,  Fast Cast +3%, Enfeebling Magic Duration +10%
                },
            },
            {
                base = {      14420, "Igqira Weskit"   },
                high = {      14421, "Genie Weskit"    },
                item = { { 903, 3 }, "Dragon Talon x3" },
                augs =
                {
                    { 516, 1, 141, 3, 268,  4        }, -- INT +2, Conserve MP +4, Staff Skill +5
                    { 516, 3, 141, 4, 268,  9, 49, 1 }, -- INT +4, Conserve MP +5, Staff Skill +10, Haste +2%
                    { 516, 5, 141, 5, 268, 14, 49, 3 }, -- INT +6, Conserve MP +6, Staff Skill +15, Haste +4%
                },
            },
            {
                base = {        14852, "Igqira Manillas"    },
                high = {        14853, "Genie Manillas"     },
                item = { { 1618, 12 }, "Urganite Shell x12" },
                augs =
                {
                    { 516, 3, 57, 3, 141, 1          }, -- INT +4, Magic Crit Rate +4%, Conserve MP +2
                    { 516, 5, 57, 5, 141, 3, 237, 14 }, -- INT +6, Magic Crit Rate +6%, Conserve MP +4, Occult Acumen +15
                    { 516, 7, 57, 7, 141, 5, 237, 29 }, -- INT +8, Magic Crit Rate +8%, Conserve MP +6, Occult Acumen +30
                },
            },
            {
                base = {        14321, "Igqira Lappas"      },
                high = {        14322, "Genie Lappas"       },
                item = { { 1618, 12 }, "Urganite Shell x12" },
                augs =
                {
                    { 35, 2, 268,  4, 49, 1          }, -- Magic Accuracy +3, Staff Skill  +5, Haste +2%
                    { 35, 3, 268,  9, 49, 2, 1251, 4 }, -- Magic Accuracy +4, Staff Skill +10, Haste +3%, Enfeebling Magic Duration +5%
                    { 35, 4, 268, 14, 49, 4, 1251, 9 }, -- Magic Accuracy +5, Staff Skill +15, Haste +5%, Enfeebling Magic Duration +10%
                },
            },
            {
                base = {        15309, "Igqira Huaraches"   },
                high = {        15310, "Genie Huaraches"    },
                item = { { 1618, 12 }, "Urganite Shell x12" },
                augs =
                {
                    { 517, 3, 290, 1, 293, 5         }, -- MND +4, Enhancing magic skill +2, Dark magic skill  +6
                    { 517, 5, 290, 3, 293, 7, 343, 2 }, -- MND +6, Enhancing magic skill +4, Dark magic skill  +8, Drain/Aspir +3
                    { 517, 7, 290, 5, 293, 9, 343, 5 }, -- MND +8, Enhancing magic skill +6, Dark magic skill +10, Drain/Aspir +6
                },
            },
        },
    },
    [xi.job.BRD] =
    {
        sets  =
        {
            "Sha'ir Attire",
        },
        kills =
        {
            { "Yagudo_Lutenist",     "Garlaige_Citadel_[S]", 10 },
            { "Mamool_Ja_Frogman",   "Mamook",               10 },
            { "Yagudo_Conductor",    "Castle_Oztroja",       30 },
            { "Denn_the_Orcavoiced", "Sea_Serpent_Grotto",    1 },
            { "Devil_Manta",         "Kuftal_Tunnel",         1 },
        },
        battle =
        {
            LEVEL_30 =
            {
                mobID       = "SONGBIRD",
                popID       = "FALLEN_FEATHER",
                mob         = "Songbird",
                pop         = "Fallen Feather",
                area        = "Bibiki_Bay",
                groupId     = 21,
                groupZoneId = 4,
                pos         = { 465.643, -21.333, 814.317, 90 }, --!pos 465.643 -21.333 814.317 4
                level       = 32,
            },
            LEVEL_50 =
            {
                mobID       = "COVE_SAHAGIN",
                popID       = "SLIPPERY_SCALE",
                mob         = "Cove Sahagin",
                pop         = "Slippery Scale",
                area        = "Yuhtunga_Jungle",
                groupId     = 23,
                groupZoneId = 123,
                pos         = { -549.297, 19.337, -492.792, 249 }, --!pos -549.297 19.337 -492.792 123
                level       = 52,
            },
        },
        armor =
        {
            {
                base = {        15153, "Sha'ir Turban"          },
                high = {        15154, "Sheikh Turban"          },
                item = { { 1619, 12 }, "Hippogryph Feather x12" },
                augs =
                {
                    { 1,  9, 514, 1, 329, 1         }, -- HP +10, VIT +2, Cure Potency +2%,
                    { 1, 14, 514, 2, 329, 2         }, -- HP +15, VIT +3, Conserve MP +1, Cure Potency +3%
                    { 1, 19, 514, 4, 329, 4, 141, 1 }, -- HP +20, VIT +5, Conserve MP +2, Cure Potency +5%
                },
            },
            {
                base = {       14414, "Sha'ir Manteel"     },
                high = {       14415, "Sheikh Manteel"     },
                item = { { 1713, 1 }, "Cashmere Thread x1" },
                augs =
                {
                    { 1,  9, 513, 1, 23, 4         }, -- HP +10, DEX +2, Accuracy +5
                    { 1, 14, 513, 2, 23, 7         }, -- HP +15, DEX +3, Accuracy +8
                    { 1, 24, 513, 4, 23, 9, 137, 0 }, -- HP +25, DEX +5, Accuracy +10, Regen +1
                },
            },
            {
                base = {        14846, "Sha'ir Gages"         },
                high = {        14847, "Sheikh Gages"         },
                item = { { 1680, 12 }, "H.Q. Bugard Skin x12" },
                augs =
                {
                    { 1,  9, 49, 0, 259, 2         }, -- HP +10, Haste +1%, Sword Skill +3
                    { 1, 14, 49, 1, 259, 4         }, -- HP +15, Haste +2%, Sword Skill +5
                    { 1, 19, 49, 2, 259, 7, 142, 1 }, -- HP +20, Haste +3%, Store TP+2, Sword Skill +8
                },
            },
            {
                base = {        14315, "Sha'ir Seraweels"     },
                high = {        14316, "Sheikh Seraweels"     },
                item = { { 1680, 12 }, "H.Q. Bugard Skin x12" },
                augs =
                {
                    { 1,  9, 49, 2, 54, 1         }, -- HP+10, Haste +3%, Physical Damage Taken -2%
                    { 1, 14, 49, 3, 54, 2, 195, 2 }, -- HP+15, Haste +4%, Subtle Blow +3, Physical Damage Taken -3%, 
                    { 1, 24, 49, 4, 54, 3, 195, 3 }, -- HP+25, Haste +5%, Subtle Blow +4, Physical Damage Taken -4%
                },
            },
            {
                base = {        15303, "Sha'ir Crackows"      },
                high = {        15304, "Sheikh Crackows"      },
                item = { { 1680, 12 }, "H.Q. Bugard Skin x12" },
                augs =
                {
                    { 1,  9, 23, 2        }, -- HP +10, Accuracy +3
                    { 1, 14, 23, 3        }, -- HP +15, Accuracy +4
                    { 1, 19, 23, 4, 53, 9 }, -- HP +20, Accuracy +5, Spell interruption rate down 10%
                },
            },
        },
    },
    [xi.job.BST] =
    {
        sets  =
        {
            "Stout Attire",
        },
        kills =
        {
            { "Jotunn_Wildkeeper",  "Upper_Delkfutts_Tower",     10 }, -- !gotoid 17424455
            { "Mamool_Ja_Stabler",  "Bhaflau_Thickets",          10 }, -- !gotoid 16990435
            { "Blooming_Rafflesia", "Castle_Oztroja_[S]",        30 }, -- !gotoid 17182763
            { "Kirtimukha",         "Fort_Karugo-Narugo_[S]",     1 }, -- !spawnmob 17170499 !gotoid 17170499
            { "Pallas",             "Vunkerl_Inlet_[S]",          1 }, -- !spawnmob 17117250 !gotoid 17117250
        },
        battle =
        {
            LEVEL_30 =
            {
                mobID       = "PUSCHKAYTS",
                popID       = "FORGOTTEN_EARTH",
                mob         = "Puschkayts",
                pop         = "Forgotten Earth",
                area        = "Batallia_Downs",
                groupId     = 25,   -- Eurymedon
                groupZoneId = 184,
                pos         = { -456.474, -31.309, 474.723, 155 }, -- !pos -456.474 -31.309 474.723 105  (F-5)
                level       = 33,
            },
            LEVEL_50 =
            {
                mobID       = "ALFWALDA",
                popID       = "VANERN",
                mob         = "Alfwalda",
                pop         = "Vanern",
                area        = "Beaucedine_Glacier",
                groupId     = 15,   -- Fomor Beastmaster Sacrarium
                groupZoneId = 28,
                pos         = { 253.895, 0.352, 235.122, 4 }, -- !pos 253.895 0.352 235.122 111 (J-7)
                level       = 53,
            },
        },
        armor =
        {
            {
                base = {       16104, "Khimaira Bonnet" },
                high = {       16105, "Stout Bonnet"    },
                item = { { 1623, 12 }, "Eft Skin x12"   },
                augs =
                {
                    { 517, 3, 131, 3, 332, 0         }, -- MND +4, MAB/MACC +4, Skillchain damage +1%
                    { 517, 5, 131, 5, 332, 1         }, -- MND +6, MAB/MACC +6, Skillchain damage +2%
                    { 517, 7, 131, 7, 332, 3, 137, 0 }, -- MND +8, MAB/MACC +8, Skillchain damage +4%, Regen +1
                },
            },
            {
                base = {      14566, "Khimaira Jacket"   },
                high = {      14567, "Stout Jacket"      },
                item = { { 2373, 3 }, "Khimaira Tail x3" },
                augs =
                {
                    { 329, 3,  141, 3, 108, 3         }, -- Cure Potency +4%,  Conserve MP +4,  Pet: MAB/MACC +4
                    { 329, 7,  141, 7, 108, 7, 140, 0 }, -- Cure Potency +8%,  Conserve MP +8,  Pet: MAB/MACC +8,  Fast Cast +1%
                    { 329, 11, 141, 9, 108, 9, 140, 2 }, -- Cure Potency +12%, Conserve MP +10, Pet: MAB/MACC +10, Fast Cast +3%
                },
            },
            {
                base = {        14981, "Khimaira Wristbands"   },
                high = {        14982, "Stout Wristbands"      },
                item = { { 1117, 12 }, "Manticore Leather x12" },
                augs =
                {
                    { 513, 3, 25, 3, 333, 3         }, -- DEX +4, Attack +4, Conserve TP +4
                    { 513, 5, 25, 5, 333, 5         }, -- DEX +6, Attack +6, Conserve TP +6,
                    { 513, 7, 25, 7, 333, 7, 110, 1 }, -- DEX +8, Attack +8, Conserve TP +8, Pet: Regen+2
                },
            },
            {
                base = {        15645, "Khimaira Kecks"        },
                high = {        15646, "Stout Kecks"           },
                item = { { 1117, 12 }, "Manticore Leather x12" },
                augs =
                {
                    { 71, 0, 124,  3, 104, 1         }, -- Damage Taken -1%, Pet:Acc/Atk  +4, Pet:Enmity +2
                    { 71, 1, 124,  7, 104, 2         }, -- Damage Taken -2%, Pet:Acc/Atk  +8, Pet:Enmity +3, 
                    { 71, 2, 124, 11, 104, 4, 138, 0 }, -- Damage Taken -3%, Pet:Acc/Atk +12, Pet:Enmity +5, Refresh +1
                },
            },
            {
                base = {        15731, "Khimaira Gamashes"   },
                high = {        15732, "Stout Gamashes"      },
                item = { { 1629, 12 }, "Buffalo Leather x12" },
                augs =
                {
                    { 17,  9, 145, 0, 49, 0         }, -- HP/MP +10, Counter +1, Haste +1%
                    { 17, 14, 145, 1, 49, 1, 127, 0 }, -- HP/MP +15, Counter +2, Haste +2%, Pet: Magic Dmg. Taken -1%
                    { 17, 19, 145, 3, 49, 2, 127, 2 }, -- HP/MP +20, Counter +4, Haste +3%, Pet: Magic Dmg. Taken -3%
                },
            },
        },
    },
    [xi.job.DRG] =
    {
        sets  =
        {
            "Dragon Mail Attire",
        },
        kills =
        {
            { "Snaggletooth_Peapuk", "The_Boyahda_Tree", 10 },
            { "Dahak",               "Mount_Zhayolm",    10 },
            { "Watch_Wyvern",        "Mamook",           30 },
            { "Vouivre",             "Ifrits_Cauldron",   1 },
            { "Ungur",               "Gustav_Tunnel",     1 },
        },
        battle =
        {
            LEVEL_30 =
            {
                mobID       = "GLOOM_DRAGON",
                popID       = "ROYAL_BLOOD",
                mob         = "Gloom Dragon",
                pop         = "Royal Blood",
                area        = "Ranguemont_Pass",
                groupId     = 5,
                groupZoneId = 112,
                pos         = { -243.287, 5.500, -169.341, 101 }, --!pos -243.287 5.500 -169.341 166
                level       = 32,
            },
            LEVEL_50 =
            {
                mobID       = "WADIVRE",
                popID       = "MOLTEN_ROCKS",
                mob         = "Wadivre",
                pop         = "Molten Rocks",
                area        = "Dangruf_Wadi",
                groupId     = 2,
                groupZoneId = 29,
                look        = 2245,
                pos         = { -463.438, 3.035, 266.221, 49 }, --!pos -463.438 3.035 266.221 191
                level       = 52,
            },
        },
        armor =
        {
            {
                base = {      12436,  "Dragon Mask"    },
                high = {      13860,  "Dragon Mask +1" },
                item = { { 867, 1 }, "Dragon Scales x1" },
                augs =
                {
                    { 9, 29, 49, 1                }, -- MP +30, Haste +2%
                    { 9, 29, 49, 2, 54, 1         }, -- MP +30, Haste +3%, Phys. dmg. taken -2%
                    { 9, 29, 49, 3, 54, 3, 147, 0 }, -- MP +30, Haste +4%, Phys. dmg. taken -4%, Treasure Hunter +1
                },
            },
            {
                base = {      12564, "Dragon Mail"       },
                high = {      13762, "Dragon Mail +1"    },
                item = { { 865, 1 }, "Nidhogg Scales x1" },
                augs =
                {
                    { 10, 27, 512, 7, 513, 7         }, -- MP +60, STR +8, DEX +8
                    { 10, 27, 512, 7, 513, 7, 23,  9 }, -- MP +60, STR +8, DEX +8, Accuracy +10
                    { 10, 27, 512, 7, 513, 7, 23, 14 }, -- MP +60, STR +8, DEX +8, Accuracy +15
                },
            },
            {
                base = {       12692, "Dragon Fng. Gauntlets"    },
                high = {       13991, "Dragon Fng. Gauntlets +1" },
                item = { { 866, 12 }, "Wyvern Scales x12"        },
                augs =
                {
                    { 10, 7, 49, 1         }, -- MP +40, Haste +2%
                    { 10, 7, 49, 2, 148, 0 }, -- MP +40, Haste +3%, Gilfinder +1
                    { 10, 7, 49, 3, 148, 1 }, -- MP +40, Haste +4%, Gilfinder +2
                },
            },
            {
                base = {       12820, "Dragon Cuisses"    },
                high = {       14231, "Dragon Cuisses +1" },
                item = { { 866, 12 }, "Wyvern Scales x12" },
                augs =
                {
                    { 10, 17, 49, 1         }, -- MP +50, Haste +2%
                    { 10, 17, 49, 2, 141, 1 }, -- MP +50, Haste +3%, Conserve MP +2
                    { 10, 17, 49, 3, 141, 2 }, -- MP +50, Haste +4%, Conserve MP +3
                },
            },
            {
                base = {       12948, "Dragon Greaves"     },
                high = {       14107, "Dragon Greaves +1"  },
                item = { { 866, 12 }, "Wyvern Scales x12"  },
                augs =
                {
                    { 10, 7, 49, 0         }, -- MP +40, Haste +1%
                    { 10, 7, 49, 1, 145, 1 }, -- MP +40, Haste +2%, Counter +2
                    { 10, 7, 49, 2, 145, 3 }, -- MP +40, Haste +3%, Counter +4
                },
            },
        },
    },
    [xi.job.DRK] =
    {
        sets  =
        {
            "Plastron Attire",
        },
        kills =
        {
            { "Lamia_Idolater", "Arrapago_Reef",            10 },
            { "Demon_Befouler", "Xarcabard_[S]",            10 },
            { "Doom_Guard",     "Gustav_Tunnel",            30 },
            { "Count_Bifrons",  "Castle_Zvahl_Keep",         1 },
            { "Wulgaru",        "Alzadaal_Undersea_Ruins",   1 },
        },
        battle =
        {
            LEVEL_30 =
            {
                mobID       = "PAVUK",
                popID       = "CONGEALED_WEB",
                mob         = "Pavuk",
                pop         = "Congealed Web",
                area        = "Beaucedine_Glacier",
                groupId     = 28, -- Diremite Stalker
                groupZoneId = 9,
                pos         = { 385.644, -0.945, -291.965, 189 }, -- (J-10) -- !pos -385.644 -0.945 -291.965 111
                level       = 32,
            },
            LEVEL_50 =
            {
                mobID       = "CONDOTTIERI",
                popID       = "TAINTED_PURSE",
                mob         = "Condottieri",
                pop         = "Tainted Purse",
                area        = "East_Ronfaure_[S]",
                groupId     = 33, -- Goblin Freelancer
                groupZoneId = 11,
                pos         = { 802.378, -60.000, 637.101, 141 }, -- (K-4) -- !pos -802.378 -60.000 637.101 81
                level       = 52,
            },
        },
        armor =
        {
            {
                base = {      13887,  "Black Sallet"       },
                high = {      13888,  "Onyx Sallet"        },
                item = { { 747, 3 }, "Orichalcum Ingot x3" },
                augs =
                {
                    { 512, 1, 142, 1, 260, 1         }, -- STR+2, STP+2, Greatsword Skill+2
                    { 512, 3, 142, 2, 260, 2, 332, 0 }, -- STR+4, STP+3, Greatsword Skill+3, Skillchain Damage+1
                    { 512, 5, 142, 4, 260, 4, 332, 1 }, -- STR+6, STP+5, Greatsword Skill+5, Skillchain Damage+2
                },
            },
            {
                base = {      14382,  "Plastron"            },
                high = {      14383,  "Plastron +1"         },
                item = { { 1705, 1 }, "Kunwu Iron Sheet x1" },
                augs =
                {
                    { 512, 0, 333, 5, 263, 5         }, -- STR+1, Conserve TP+6,  Scythe Skill+6
                    { 512, 1, 333, 7, 263, 7, 332, 0 }, -- STR+2, Conserve TP+8,  Scythe Skill+8,  Skillchain Damage+1
                    { 512, 2, 333, 9, 263, 9, 332, 2 }, -- STR+3, Conserve TP+10, Scythe Skill+10, Skillchain Damage+3
                },
            },
            {
                base = {       14010, "Black Gadlings"      },
                high = {       14011, "Onyx Gadlings"       },
                item = { { 664, 12 }, "Darksteel Sheet x12" },
                augs =
                {
                    { 25, 0, 333, 1, 260, 1         }, -- Attack+1, Conserve TP+2, Greatsword Skill+2
                    { 25, 2, 333, 2, 260, 2, 332, 0 }, -- Attack+3, Conserve TP+3, Greatsword Skill+3, Skillchain Damage+1
                    { 25, 4, 333, 4, 260, 4, 332, 2 }, -- Attack+5, Conserve TP+5, Greatsword Skill+5, Skillchain Damage+3
                },
            },
            {
                base = {       15400, "Black Cuisses"       },
                high = {       15401, "Onyx Cuisses"        },
                item = { { 664, 12 }, "Darksteel Sheet x12" },
                augs =
                {
                    { 516, 0, 133, 3, 263, 3         }, -- INT+1, MAB+4, Scythe Skill+4
                    { 516, 1, 133, 5, 263, 5, 332, 0 }, -- INT+2, MAB+6, Scythe Skill+6, Skillchain Damage+1
                    { 516, 3, 133, 7, 263, 7, 332, 2 }, -- INT+4, MAB+8, Scythe Skill+8, Skillchain Damage+3
                },
            },
            {
                base = {       15339, "Black Sollerets"     },
                high = {       15340, "Onyx Sollerets"      },
                item = { { 664, 12 }, "Darksteel Sheet x12" },
                augs =
                {
                    { 516, 1, 25, 1, 263, 1, 333, 0 }, -- INT+2, Attack+2, Scythe Skill+2, Conserve TP+1
                    { 516, 3, 25, 2, 263, 2, 333, 1 }, -- INT+4, Attack+3, Scythe Skill+3, Conserve TP+2
                    { 516, 5, 25, 4, 263, 4, 333, 3 }, -- INT+6, Attack+5, Scythe Skill+5, Conserve TP+4
                },
            },
        },
    },
    [xi.job.NIN] =
    {
        sets  =
        {
            "Yasha Attire",
        },
        kills =
        {
            { "Tonberry_Decapitator",  "Den_of_Rancor",              3 },
            { "Yagudo_Missionary",     "Sauromugue_Champaign_[S]",  10 },
            { "Yagudo_Assassin",       "Castle_Oztroja",            30 },
            { "Beryl-footed_Molberry", "Temple_of_Uggalepih",        1 },
            { "Zhuu_Buxu_the_Silent",  "Castle_Oztroja_[S]",         1 },
        },
        battle =
        {
            LEVEL_30 =
            {
                mobID       = "YAGUDO_SHINOBI",
                popID       = "SILVER_SHURIKEN",
                mob         = "Yagudo Shinobi",
                pop         = "Silver Shuriken",
                area        = "Giddeus",
                groupId     = 11,
                groupZoneId = 120,
                pos         = { 216.8, -1.8, -303.8, 200 }, -- !pos 216.8 -1.8 -303 145 (originally on a ledge that is inaccessible, draw in doesn't reliably bring you up there)
                level       = 32,
            },
            LEVEL_50 =
            {
                mobID       = "RARBERRY",
                popID       = "ASSSASSIN_ORDER",
                mob         = "Sozu Rarberry",
                pop         = "Assassin Order",
                area        = "Yhoator_Jungle",
                groupId     = 19,
                groupZoneId = 159,
                look        = 1196,
                pos         = { 322.090, -18.000, -554.779, 193 }, --!pos 322.090 -18.000 -554.779 124
                level       = 52,
            },
        },
        armor =
        {
            {
                base = {       12490, "Yasha Jinpachi"    },
                high = {       15192, "Yasha Jinpachi +1" },
                item = { { 830, 12 }, "Rainbow Cloth x12" },
                augs =
                {
                    { 31, 5, 49, 1, 53, 1, 39, 0 }, -- Evasion  +6, Haste +2%, SIR 2%, Enmity +1
                    { 31, 7, 49, 2, 53, 2, 39, 1 }, -- Evasion  +8, Haste +3%, SIR 3%, Enmity +2
                    { 31, 9, 49, 4, 53, 3, 39, 2 }, -- Evasion +10, Haste +5%, SIR 4%, Enmity +3
                },
            },
            {
                base = {       12618,  "Yasha Samue"      },
                high = {       14442,  "Yasha Samue +1"   },
                item = { { 1764, 3 },  "Kejusu Satin x3"  },
                augs =
                {
                    { 516, 3, 295, 5, 133, 3, 140, 1 }, -- INT +4,. Ninjutsu Skill  +6, MAB +4, FC +2%
                    { 516, 5, 295, 7, 133, 5, 140, 2 }, -- INT +6,. Ninjutsu Skill  +8, MAB +6, FC +3%
                    { 516, 7, 295, 9, 133, 7, 140, 3 }, -- INT +8,. Ninjutsu Skill +10, MAB +8, FC +4%
                },
            },
            {
                base = {       13957, "Yasha Tekko"         },
                high = {       14882, "Yasha Tekko +1"      },
                item = { { 664, 12 }, "Darksteel Sheet x12" },
                augs =
                {
                    { 516, 3, 295, 3, 49, 0, 334, 1 }, -- INT +4, Ninjutsu Skill +4, Haste +1%, MB +2%
                    { 516, 5, 295, 5, 49, 1, 334, 3 }, -- INT +6, Ninjutsu Skill +6, Haste +2%, MB +4%
                    { 516, 7, 295, 7, 49, 2, 334, 5 }, -- INT +8, Ninjutsu Skill +8, Haste +3%, MB +6%
                },
            },
            {
                base = {       12847, "Yasha Hakama"        },
                high = {       15398, "Yasha Hakama +1"     },
                item = { { 664, 12 }, "Darksteel Sheet x12" },
                augs =
                {
                    { 516, 3, 133, 1, 49, 1, 39, 0 }, -- INT +4, MAB +2, Haste +2%, Enmity +1
                    { 516, 5, 133, 3, 49, 2, 39, 1 }, -- INT +6, MAB +4, Haste +3%, Enmity +2
                    { 516, 7, 133, 4, 49, 3, 39, 2 }, -- INT +8, MAB +5, Haste +4%, Enmity +3
                },
            },
            {
                base = {       13002, "Yasha Sune-Ate"      },
                high = {       15336, "Ysh. Sune-Ate +1"    },
                item = { { 664, 12 }, "Darksteel Sheet x12" },
                augs =
                {
                    { 31, 3, 49, 0, 53, 1, 55, 1 }, -- Evasion +4, Haste +1%, SIR +2%, MDT -2%
                    { 31, 5, 49, 1, 53, 3, 55, 2 }, -- Evasion +6, Haste +2%, SIR +4%, MDT -3%
                    { 31, 7, 49, 2, 53, 5, 55, 3 }, -- Evasion +8, Haste +3%, SIR +6%, MDT -4%
                },
            },
        },
    },
    [xi.job.PLD] =
    {
        sets  =
        {
            "Lord's Attire",
        },
        kills =
        {
            { "Orcish_Trooper",       "Batallia_Downs_[S]", 10 },
            { "Orcish_Protector",     "La_Vaule_[S]",       10 },
            { "Antican_Antesignanus", "Quicksand_Caves",    30 },
            { "Orcish_Overlord",      "Monastic_Cavern",     1 },
            { "Proconsul_XII",        "Quicksand_Caves",     1 },
        },
        battle =
        {
            LEVEL_30 =
            {
                mobID       = "ORCISH_GUARDIAN",
                popID       = "FADED_BANNER",
                mob         = "Orcish Guardian",
                pop         = "Faded Banner", -- (J-11)
                area        = "Jugner_Forest",
                popLook     = 817,
                groupId     = 22,
                groupZoneId = 104,
                pos         = { 279.896, -16.913, -556.334, 170 }, -- !pos 279.896 -16.913 -556.334 104
                level       = 32,
            },
            LEVEL_50 =
            {
                mobID       = "CURIATE",
                popID       = "FADED_SAND",
                mob         = "Antican Curiate",
                pop         = "Faded Sand", -- (F-7)
                area        = "Western_Altepa_Desert",
                groupId     = 22,
                groupZoneId = 208,
                pos         = { -449.964, 12.000, 118.019, 190 }, -- !pos -449.964 12.000 118.019 125
                level       = 52,
            },
        },
        armor =
        {
            {
                base = {      15189,  "Lord's Armet"       },
                high = {      15193,  "King's Armet"       },
                item = { { 746, 12 }, "Platinum Ingot x12" },
                augs =
                {
                    { 1, 14, 514, 3, 49, 1        }, -- HP +15, VIT +4, Haste +2%
                    { 1, 19, 514, 5, 49, 2, 53, 3 }, -- HP +20, VIT +6, Haste +3%, Spell interruption rate down -4%
                    { 1, 24, 514, 7, 49, 4, 53, 7 }, -- HP +25, VIT +8, Haste +5%, Spell interruption rate down -8%
                },
            },
            {
                base = {      13757,  "Lord's Cuirass"       },
                high = {      13758,  "King's Cuirass"       },
                item = { { 747, 12 }, "Orichalcum Ingot x12" },
                augs =
                {
                    { 514, 3, 53, 5                 }, -- VIT +4, Spell interrupt rate down -6%
                    { 514, 5, 53, 7, 140, 1, 356, 1 }, -- VIT +6, Spell interrupt rate down -8%, Fast Cast +2%, Potency of Cure received +2%
                    { 514, 7, 53, 9, 140, 3, 356, 3 }, -- VIT +8, Spell interrupt rate down -10%, Fast Cast +4%, Potency of Cure received +4%
                },
            },
            {
                base = {       14879, "Lord's Gauntlets" },
                high = {       14883, "King's Gauntlets" },
                item = { { 745, 12 }, "Gold Ingot x12"   },
                augs =
                {
                    { 1,  9, 514, 3, 137, 0        }, -- HP +10, VIT +4, Regen +1
                    { 1, 14, 514, 5, 137, 1, 54, 1 }, -- HP +15, VIT +6, Regen +2, Phys. dmg taken -2%
                    { 1, 19, 514, 7, 137, 2, 54, 2 }, -- HP +20, VIT +8, Regen +3, Phys. dmg taken -3%
                },
            },
            {
                base = {       15395, "Lord's Cuisses" },
                high = {       15399, "King's Cuisses" },
                item = { { 745, 12 }, "Gold Ingot x12" },
                augs =
                {
                    { 1, 19, 33, 5, 514, 3         }, -- HP +20, DEF  +6, VIT +4
                    { 1, 24, 33, 7, 514, 5, 368, 1 }, -- HP +25, DEF  +8, VIT +6, Phalanx +2
                    { 1, 29, 33, 9, 514, 7, 368, 2 }, -- HP +30, DEF +10, VIT +8, Phalanx +3
                },
            },
            {
                base = {       15333, "Lord's Sabatons" },
                high = {       15337, "King's Sabatons" },
                item = { { 745, 12 }, "Gold Ingot x12"  },
                augs =
                {
                    { 1,  9, 33, 3, 514, 3         }, -- HP +10, DEF +4, VIT +4
                    { 1, 14, 33, 5, 514, 5, 323, 3 }, -- HP +15, DEF +6, VIT +6, Cure spellcasting time -4%
                    { 1, 19, 33, 7, 514, 7, 323, 5 }, -- HP +20, DEF +8, VIT +8, Cure spellcasting time -6%
                },
            },
        },
    },
    [xi.job.RDM] =
    {
        sets  =
        {
            "Chasuble Attire",
        },
        kills =
        {
            { "Troll_Cameist",      "Halvung",           10 }, -- !gotoid 17031187
            { "Star_Ruby_Quadav",   "Beadeaux_[S]",      10 }, -- !gotoid 17154066
            { "Dustbuster",         "VeLugannon_Palace", 30 }, -- !gotoid 17502331
            { "Zoraal_Jas_Pkuucha", "Wajaom_Woodlands",   1 }, -- !spawnmob 16986197 !gotoid 16986197
            { "Ruby_Quadav",        "Qulun_Dome",         1 }, -- !spawnmob 17383433 !gotoid 17383433
        },
        battle =
        {
            LEVEL_30 =
            {
                mobID       = "WHIRLING_WEAPON",
                popID       = "SWORD_DUST",
                mob         = "Whirling Weapon",
                pop         = "Sword Dust",
                area        = "Jugner_Forest",
                groupId     = 7,
                groupZoneId = 126,
                pos         = { 322.671, -1.386, -247.558, 239 }, -- !pos 322.671 -1.386 -247.558 104
                level       = 32,
            },
            LEVEL_50 =
            {
                mobID       = "ATHOX_MAGEBLADE",
                popID       = "BROKEN_BOTTLE",
                mob         = "Athox Mageblade",
                pop         = "Broken Bottle",
                area        = "Garlaige_Citadel", -- (x-x) Entrance (Uncapped)
                groupId     = 14,
                groupZoneId = 213,
                pos         = { -343.188, -0.071, 233.237, 26 }, -- !pos -343.188 -0.071 233.237 200
                level       = 52,
            },
        },
        armor =
        {
            {
                base = {       15190,  "Wise Cap"              },
                high = {       15191,  "Wise Cap +1"           },
                item = { { 1117, 12 }, "Manticore Leather x12" },
                augs =
                {
                    { 258, 1, 49, 1, 363, 1        },  -- Dagger Skill +2, Haste +2, Chance of successful block +2%
                    { 258, 3, 49, 2, 363, 2,       },  -- Dagger Skill +4, Haste +3, Chance of successful block +3%
                    { 258, 5, 49, 4, 363, 4, 61, 2 },  -- Dagger Skill +6, Haste +5, Chance of successful block +5%, Occ. inc. resist to stat ailments+3
                },
            },
            {
                base = {      14440,  "Chasuble"          },
                high = {      14441,  "Chasuble +1"       },
                item = { { 1767, 3 }, "Eltoro Leather x3" },
                augs =
                {
                    { 559, 5, 68, 3, 146, 1        }, -- STR/MND  +6, Accuracy/Attack +4, Dual Wield +2
                    { 559, 7, 68, 5, 146, 2        }, -- STR/MND  +8, Accuracy/Attack +6, Dual Wield +3
                    { 559, 9, 68, 7, 146, 4, 55, 3 }, -- STR/MND +10, Accuracy/Attack +8, Dual Wield +5, Magic dmg. taken -4%
                },
            },
            {
                base = {       14880, "Wise Gloves"      },
                high = {       14881, "Wise Gloves +1"   },
                item = { { 828, 12 }, "Velvet Cloth x12" },
                augs =
                {
                    { 558, 1, 259, 1, 333, 3        }, -- STR/INT +2, Sword Skill +2, Conserve TP +4
                    { 558, 2, 259, 3, 333, 5, 49, 0 }, -- STR/INT +3, Sword Skill +4, Conserve TP +6, Haste +1%
                    { 558, 4, 259, 5, 333, 7, 49, 2 }, -- STR/INT +5, Sword Skill +6, Conserve TP +8, Haste +3%
                },
            },
            {
                base = {       15396, "Wise Braconi"     },
                high = {       15397, "Wise Braconi +1"  },
                item = { { 828, 12 }, "Velvet Cloth x12" },
                augs =
                {
                    { 68, 3, 44, 1, 49, 1        }, -- Accuracy/Attack +4, Store TP/Subtle Blow +2, Haste +2%
                    { 68, 5, 44, 2, 49, 2, 37, 2 }, -- Accuracy/Attack +6, Store TP/Subtle Blow +3, Haste +3%, Magic Evasion +3
                    { 68, 7, 44, 4, 49, 3, 37, 4 }, -- Accuracy/Attack +8, Store TP/Subtle Blow +5, Haste +4%, Magic Evasion +5
                },
            },
            {
                base = {        15334, "Wise Pigaches"     },
                high = {        15335, "Wise Pigaches +1"  },
                item = { { 855, 12 },  "Tiger Leather x12" },
                augs =
                {
                    { 552, 1, 281,  4, 142, 1,        }, -- STR/AGI +2, Archery Skill  +5, Store TP +2
                    { 552, 2, 281,  9, 142, 2, 368, 0 }, -- STR/AGI +3, Archery Skill +10, Store TP +3, Phalanx +1
                    { 552, 4, 281, 14, 142, 3, 368, 1 }, -- STR/AGI +5, Archery Skill +15, Store TP +4, Phalanx +2
                },
            },
        },
    },
    [xi.job.SAM] =
    {
        sets  =
        {
            "Hachiman Armor",
        },
        kills =
        {
            { "Blood_Demon",             "Castle_Zvahl_Baileys", 10 }, -- !gotoid 17436869
            { "Merrow_Kabukidancer",     "Arrapago_Reef",        10 }, -- !gotoid 16998533
            { "Yagudo_Yojimbo",          "Castle_Oztroja_[S]",   30 }, -- !gotoid 17182872
            { "Moo_Ouzi_the_Swiftblade", "Castle_Oztroja",        1 }, -- !spawnmob 17395816 !gotoid 17395816
            { "Duu_Masa_the_Onecut",     "Castle_Oztroja_[S]",    1 }, -- !spawnmob 17182790 !gotoid 17182790
        },
        battle =
        {
            LEVEL_30 =
            {
                mobID       = "SHORYO",
                popID       = "TORN_OBI",
                mob         = "Shoryo",
                pop         = "Torn Obi",
                area        = "Yuhtunga_Jungle", -- (J-7)
                groupId     = 36,
                groupZoneId = 27,
                look        = 1264,
                pos         = { 277.243, 4.000, 284.280, 181 }, -- !pos 277.243 4.000 284.280 123
                level       = 30,
            },
            LEVEL_50 =
            {
                
                mobID       = "DOJI",
                popID       = "CRACKED_KABUTO",
                mob         = "Doji",
                pop         = "Cracked Kabuto",
                area        = "The_Sanctuary_of_ZiTah", -- (E-9)
                groupId     = 20,
                groupZoneId = 112,
                pos         = { -455.003, -1.235, -111.807, 0 }, -- !pos -455.003 -1.235 -111.807 121
                level       = 52,
            },
        },
        armor =
        {
            {
                base = {       15188,  "Hachiman Jinpachi"    },
                high = {       15187,  "Hachiman Jinpachi +1" },
                item = { { 1415, 12 }, "Urushi x12"           },
                augs =
                {
                    { 25, 5, 198, 1, 49, 1         },  -- Attack +6,  Zanshin +2, Haste +2%
                    { 25, 7, 198, 2, 49, 2, 145, 1 },  -- Attack +8,  Zanshin +3, Haste +3%, Counter +2%
                    { 25, 9, 198, 4, 49, 3, 145, 3 },  -- Attack +10, Zanshin +5, Haste +4%, Counter +4%
                },
            },
            {
                base = {      14437,  "Hachiman Domaru"    },
                high = {      14439,  "Hachiman Domaru +1" },
                item = { { 1763, 3 }, "Viridian Urushi x3" },
                augs =
                {
                    { 512, 1, 333, 3, 25,  7         }, -- STR +2, Conserve TP +4, Attack +8
                    { 512, 3, 333, 4, 25,  9         }, -- STR +4, Conserve TP +5, Attack +10
                    { 512, 5, 333, 5, 25, 11, 332, 2 }, -- STR +6, Conserve TP +6, Attack +12, Skillchain Dmg +3
                },
            },
            {
                base = {        14876, "Hachiman Kote"    },
                high = {        14878, "Hachiman Kote +1" },
                item = { { 1415, 12 }, "Urushi x12"       },
                augs =
                {
                    { 25, 5, 326, 3, 133, 3         }, -- Attack  +6, Weapon Skill Acc +4, Magic Atk. Bonus +4
                    { 25, 7, 326, 5, 133, 5, 353, 0 }, -- Attack  +8, Weapon Skill Acc +6, Magic Atk. Bonus +6, TP Bonus  +50
                    { 25, 9, 326, 7, 133, 7, 353, 1 }, -- Attack +10, Weapon Skill Acc +8, Magic Atk. Bonus +8, TP Bonus +100
                },
            },
            {
                base = {        15392, "Hachiman Hakama"    },
                high = {        15394, "Hachiman Hakama +1" },
                item = { { 1699, 12 }, "Scarlet Linen x12"  },
                augs =
                {
                    { 512, 1, 515, 3, 29, 3         }, -- STR +2, AGI +4, Rng. Atk. +4
                    { 512, 3, 515, 5, 29, 5, 211, 1 }, -- STR +4, AGI +6, Rng. Atk. +6, Snapshot +2%
                    { 512, 5, 515, 7, 29, 7, 211, 3 }, -- STR +6, AGI +8, Rng. Atk. +8, Snapshot +4%
                },
            },
            {
                base = {        15330, "Hachiman Sune-Ate"    },
                high = {        15332, "Hachiman Sune-Ate +1" },
                item = { { 830, 12 },  "Rainbow Cloth x12"    },
                augs =
                {
                    { 512, 0, 515, 3, 281, 2, 264, 5 }, -- STR +1, AGI +4, Archery Skill +3, Polearm Skill  +6
                    { 512, 1, 515, 5, 281, 3, 264, 7 }, -- STR +2, AGI +6, Archery Skill +4, Polearm Skill  +8
                    { 512, 3, 515, 7, 281, 5, 264, 9 }, -- STR +4, AGI +8, Archery Skill +6, Polearm Skill +10
                },
            },
        },
    },
    [xi.job.THF] =
    {
        sets  =
        {
            "Dragon Harness Set",
        },
        kills =
        {
            { "Goblin_Pioneer",          "Grauberg_[S]",        10 }, -- !gotoid 17142104
            { "Platinum_Quadav",         "Qulun_Dome",          10 }, -- !gotoid 17383427
            { "Tonberry_Pursuer",        "Temple_of_Uggalepih", 30 }, -- !gotoid 17428671
            { "DaDha_Hundredmask",       "Beadeaux_[S]",         1 }, -- !gotoid 17154195
            { "Tawny-fingered_Mugberry", "Den_of_Rancor",        1 }, -- !gotoid 17432798
        },
        battle =
        {
            LEVEL_30 =
            {
                mobID       = "TIN_QUADAV",
                popID       = "BURIED_STASH",
                mob         = "Tin Quadav",
                pop         = "Buried Stash", -- (K-7)
                area        = "Pashhow_Marshlands",
                groupId     = 20,
                groupZoneId = 109,
                pos         = { 546.059, 24.415, 204.797, 0 }, -- !pos 546.059 24.415 204.797 109
                level       = 32,
            },
            LEVEL_50 =
            {
                mobID       = "BANDITO",
                popID       = "LOOSE_CHANGE",
                mob         = "Goblin Bandito",
                pop         = "Loose Change", -- (J-11)
                area        = "Oldton_Movalpolos",
                look        = 502,
                groupId     = 3,   -- Goblin Robber
                groupZoneId = 212,
                pos         = { 80.109, 15.0533, -140.0148, 0 }, -- !pos 80.109 15.0533 -140.0148 11
                level       = 52,
            },
        },
        armor =
        {
            {
                base = {       13936, "Dragon Cap"     },
                high = {       13937, "Dragon Cap +1"  },
                item = { { 1771, 1 }, "Dragon Bone x1" },
                augs =
                {
                    { 515, 1, 258, 3, 195, 1         }, -- AGI +2 Dagger Skill +4, Subtle Blow +2
                    { 515, 3, 258, 5, 195, 3         }, -- AGI +4 Dagger Skill +6, Subtle Blow +4
                    { 515, 5, 258, 7, 195, 5, 147, 0 }, -- AGI +6 Dagger Skill +8, Subtle Blow +6, Treasure Hunter +1
                },
            },
            {
                base = {       14389, "Dragon Harness"    },
                high = {       14390, "Dragon Harness +1" },
                item = { { 1816, 1 }, "Wyrm Horn x1"      },
                augs =
                {
                    { 513, 0, 515, 0, 25,  3         }, -- DEX +1, AGI +1, Attack +4
                    { 513, 1, 515, 1, 25,  7, 332, 1 }, -- DEX +2, AGI +2, Attack +8, Skillchain DMG +2%
                    { 513, 2, 515, 2, 25, 11, 332, 3 }, -- DEX +3, AGI +3, Attack +12, Skillchain DMG +4%
                },
            },
            {
                base = {       14823, "Dragon Mittens"       },
                high = {       14824, "Dragon Mittens +1"    },
                item = { { 1629, 12 }, "Buffalo Leather x12" },
                augs =
                {
                    { 513, 3, 25, 3, 37, 1, 49, 0 }, -- DEX +4, Attack +4, Magic Evasion +2, Haste +1%
                    { 513, 5, 25, 5, 37, 3, 49, 1 }, -- DEX +6, Attack +6, Magic Evasion +4, Haste +2%
                    { 513, 7, 25, 7, 37, 5, 49, 2 }, -- DEX +8, Attack +8, Magic Evasion +6, Haste +3%
                },
            },
            {
                base = {        14305, "Dragon Subligar"  },
                high = {        14306, "Drn. Subligar +1" },
                item = { { 1629, 12 }, "Buffalo Leather x12" },
                augs =
                {
                    { 31, 3, 25, 3, 49, 0         }, -- Evasion +4, Attack +4, Haste +1%
                    { 31, 5, 25, 5, 330, 2, 49, 1 }, -- Evasion +6, Attack +6, "Waltz" Potency +3%, Haste +2%
                    { 31, 7, 25, 9, 330, 4, 49, 2 }, -- Evasion +8, Attack +10, "Waltz" Potency +5%, Haste +3%
                },
            },
            {
                base = {        14186, "Dragon Leggings"  },
                high = {        14187, "Drn. Leggings +1" },
                item = { { 1629, 12 }, "Buffalo Leather x12" },
                augs =
                {
                    { 23, 3, 25, 3, 195, 1        }, -- Accuracy +4, Attack +4, Subtle Blow +2
                    { 23, 5, 25, 5, 195, 3, 41, 0 }, -- Accuracy +6, Attack +6, Subtle Blow +4, Critical Hit Rate +1%
                    { 23, 7, 25, 7, 195, 5, 41, 2 }, -- Accuracy +8, Attack +8, Subtle Blow +6, Critical Hit Rate +3%
                },
            },
        },
    },
    [xi.job.WAR] =
    {
        sets  =
        {
            "Unicorn Attire",
        },
        kills =
        {
            { "Ancient_Quadav",     "Beadeaux",              10 },
            { "Goblin_Mercenary",   "Labyrinth_of_Onzozo",   10 },
            { "Orcish_Dreadnought", "Davoi",                 30 },
            { "Alkyoneus",          "Upper_Delkfutts_Tower",  1 },
            { "Triarius_X-XV",      "Quicksand_Caves",        1 },
        },
        battle =
        {
            LEVEL_30 =
            {
                mobID       = "ORCISH_WARMAKER",
                popID       = "ORCISH_WARPLANS",
                mob         = "Orcish Warmaker",
                pop         = "Orcish Warplans",
                area        = "Fort_Ghelsba",
                groupId     = 15,
                groupZoneId = 141,
                pos         = { -29.363, -20.000, -118.190, 186 }, --!pos -29.363 -20.000 -118.190 141
                level       = 32,
            },
            LEVEL_50 =
            {
                mobID       = "GRUFFLOX_BIGJAW",
                popID       = "WORN_BATTLEMENT",
                mob         = "Grufflox Bigjaw",
                pop         = "Worn Battlement",
                area        = "Sauromugue_Champaign",
                groupId     = 10,
                groupZoneId = 212,
                pos         = { -127.500, 10.463, 233.376, 92 }, --!pos -127.500 10.463 233.376 120
                level       = 52,
            },
        },
        armor =
        {
            {
                base = {      15209, "Unicorn Cap"         },
                high = {      15210, "Unicorn Cap +1"      },
                item = { { 747, 1 }, "Orichalcum Ingot x1" },
                augs =
                {
                    { 1, 23, 49, 1, 145, 1        }, -- HP +24, Haste +2%, Counter +2
                    { 1, 23, 49, 2, 145, 2        }, -- HP +24, Haste +3%, Counter +3
                    { 1, 23, 49, 3, 145, 3, 39, 3 }, -- HP +24, Haste +4%, Counter +4, Enmity +4
                },
            },
            {
                base = {      14448, "Unicorn Harness"    },
                high = {      14449, "Unicorn Harness +1" },
                item = { { 658, 1 }, "Damascus Ingot x1"  },
                augs =
                {
                    { 1, 31, 23,  9, 55, 1,        }, -- HP +32, Accuracy +10, Magic dmg. taken -2%
                    { 1, 31, 23, 11, 55, 2, 145, 1 }, -- HP +32, Accuracy +12, Magic dmg. taken -3%, Counter +2
                    { 1, 31, 23, 14, 55, 3, 145, 3 }, -- HP +32, Accuracy +15, Magic dmg. taken -4%, Counter +4
                },
            },
            {
                base = {       14055, "Unicorn Mittens"    },
                high = {       14056, "Unicorn Mittens +1" },
                item = { { 655, 12 }, "Adaman Ingot x3"    },
                augs =
                {
                    { 1, 25, 55, 1        }, -- HP +26, Magic dmg. taken -2%
                    { 1, 25, 49, 1, 55, 2 }, -- HP +26, Haste +2%, Magic dmg. taken -3%
                    { 1, 25, 49, 2, 55, 3 }, -- HP +26, Haste +3%, Magic dmg. taken -4%
                },
            },
            {
                base = {       15406, "Unicorn Subligar"    },
                high = {       15407, "Unicorn Subligar +1" },
                item = { { 655, 12 }, "Adaman Ingot x3"    },
                augs =
                {
                    { 1, 27, 23, 3, 55, 1,       }, -- HP +28, Accuracy +4, Magic dmg. taken -2%
                    { 1, 27, 23, 5, 49, 1, 55, 2 }, -- HP +28, Accuracy +6, Haste +2%, Magic dmg. taken -3%
                    { 1, 27, 23, 7, 49, 3, 55, 3 }, -- HP +28, Accuracy +8, Haste +4%, Magic dmg. taken -4%
                },
            },
            {
                base = {       15345, "Unicorn Leggings"    },
                high = {       15346, "Unicorn Leggings +1" },
                item = { { 655, 12 }, "Adaman Ingot x3"    },
                augs =
                {
                    { 1, 19, 55, 1,        }, -- HP +20, Magic dmg. taken -2%
                    { 1, 19, 55, 2, 145, 1 }, -- HP +20, Magic dmg. taken -3%, Counter +2
                    { 1, 19, 55, 3, 145, 3 }, -- HP +20, Magic dmg. taken -4%, Counter +4
                },
            },
        },
    },
    [xi.job.WHM] =
    {
        sets  =
        {
            "Blessed Bliaut Attire",
        },
        kills =
        {
            { "Tomb_Warrior",    "The_Eldieme_Necropolis", 10 },
            { "Lich",            "Toraimarai_Canal",       10 },
            { "Reserve_Draugar", "Arrapago_Reef",          30 },
            { "Namtar",          "Sea_Serpent_Grotto",      1 },
            { "Taxim",           "Gustav_Tunnel",           1 },
        },
        battle =
        {
            LEVEL_30 =
            {
                mobID       = "LOST_WANDERER",
                popID       = "PILE_OF_BONES",
                mob         = "Lost Wanderer",
                pop         = "Pile of Bones",
                area        = "North_Gustaberg",
                groupId     = 12,
                groupZoneId = 196,
                pos         = { 326.081, -60.426, 477.909, 127 }, --!pos 326.081 -60.426 477.909 106
                level       = 32,
            },
            LEVEL_50 =
            {
                mobID       = "LOST_BETRAYER",
                popID       = "DISTURBED_ROCKS",
                mob         = "Lost Betrayer",
                pop         = "Disturbed Rocks",
                area        = "Gustav_Tunnel",
                groupId     = 26,
                groupZoneId = 204,
                pos         = { 150.785, -12.360, -90.396, 220 }, --!pos 150.785 -12.360 -90.396 212
                level       = 52,
            },
        },
        armor =
        {
            {
                base = {      14436, "Blessed Bliaut"    },
                high = {      14438, "Blessed Bliaut +1" },
                item = { { 831, 1 }, "Shining Cloth x1"  },
                augs =
                {
                    { 9, 19, 513, 1, 25, 4 }, -- MP +20, DEX +2, Attack +5
                    { 9, 29, 513, 2, 25, 7 }, -- MP +30, DEX +3, Attack +8
                    { 10, 7, 513, 4, 25, 9 }, -- MP +40, DEX +5, Attack +10
                },
            },
            {
                base = {      14875, "Blessed Mitts"      },
                high = {      14877, "Blessed Mitts +1"   },
                item = { { 836, 3 }, "Damascene Cloth x3" },
                augs =
                {
                    { 513, 1, 23, 2         }, -- DEX +2, Accuracy +3
                    { 513, 2, 23, 4, 140, 0 }, -- DEX +3, Accuracy +5, Fast Cast +1%
                    { 513, 4, 23, 7, 140, 1 }, -- DEX +5, Accuracy +8, Fast Cast +2%
                },
            },
            {
                base = {      15391, "Blessed Trousers"    },
                high = {      15393, "Blessed Trousers +1" },
                item = { { 836, 3 }, "Damascene Cloth x3"  },
                augs =
                {
                    { 512, 1, 25, 4         }, -- STR +2, Attack +5
                    { 512, 2, 25, 7, 143, 0 }, -- STR +3, Attack +8, Double Attack +1
                    { 512, 4, 25, 9, 143, 1 }, -- STR +5, Attack +10, Double Attack +2
                },
            },
            {
                base = {      15329, "Blessed Pumps"      },
                high = {      15331, "Blessed Pumps +1"   },
                item = { { 836, 3 }, "Damascene Cloth x3" },
                augs =
                {
                    { 512, 1, 286,  9         }, -- STR +2, Shield Skill +10
                    { 512, 2, 286, 11, 363, 0 }, -- STR +3, Shield Skill +12, Block Chance +1
                    { 512, 4, 286, 14, 363, 1 }, -- STR +5, Shield Skill +15, Block Chance +2
                },
            },
        },
    },
}

-- build hq table for book trade-up
local highQuality = {}
for _, job in pairs(trial) do
    for _, armor in pairs(job.armor) do
        -- highQuality[<nqID>] = { "<hqName>", <hqID> }
        highQuality[armor.base[1]] = { armor.high[2], armor.high[1] }
    end
end

-----------------------------------
-- End of Trials
-----------------------------------

for jobID, job in pairs(trial) do
    for index, kills in pairs(job.kills) do
        cexi.util.ensureMob(kills[2], kills[1])

        m:addOverride(string.format("xi.zones.%s.mobs.%s.onMobDeath", kills[2], kills[1]), function(mob, player, optParams)
            super(mob, player, optParams)

            if
                player ~= nil and
                player:isPC() and
                player:getMainJob() == jobID and
                player:getCharVar("[CQ]ADEPT_LOCK") == jobID
            then
                local lookup = string.format("[CQ]ADEPT_TRIAL_%s_%u", xi.jobNames[jobID][1], index)
                local result = player:getCharVar(lookup)

                if result < kills[3] then
                    local mobName  = string.gsub(kills[1], "_", " ")
                    local zoneName = string.gsub(kills[2], "_", " ")
                    local message  = string.format("Adept Trial [%s] %u/%u (%s in %s)", xi.jobNames[jobID][1], result + 1, kills[3], mobName, zoneName)

                    player:printToPlayer(message, xi.msg.channel.SYSTEM_3)
                    player:incrementCharVar(lookup, 1)

                    if result + 1 == kills[3] then
                        player:printToPlayer(string.format("%s Trial Complete! %s", "\129\154", "\129\154"), xi.msg.channel.SYSTEM_3)
                    end
                end
            end
        end)
    end
end

local info =
{
    author = "Loxley",
    name   = "Adept Reforging",
    var    = "[CQ]ADEPT",
}

local entity =
{
    {
        id     = "ADEPTUS",
        name   = "Adeptus",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A1,
            head = cexi.model.GOLIARD_SAIO,
            body = cexi.model.CORSELET,
            hand = cexi.model.GOLIARD_SAIO,
            legs = cexi.model.GOLIARD_SAIO,
            feet = cexi.model.GOLIARD_SAIO,
        }),
        area   = "Rabao",
        pos    = { 118.823, 8.000, 115.162, 71 }, -- !pos 118.823 8.000 115.162 247
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "I have nothing to say to you." },
            START    = { "Your first task is to defeat the following:" },
            QUESTION =
            {
                "Greetings. So you think you've mastered %s? Hmmm...",
                " There's a special kind of armor reforging that I can offer only to those who pass a series of trials.",
                "If you truly think you're ready, let's begin.",
            },
            DELAY    = { "Unfortunately, I cannot offer you a new trial for another %u hour(s) (Earth time)." },
            NOJOB    = { "Unfortunately, I cannot offer you a trial for %s yet." },
            FINISH   = 
            { "Congratulations! You've proven your mastery of %s! As a reward, I will reforge one piece of the %s.",
              "A word of caution, trade the Book of Mastery first if you are converting an item of lesser quality.",
              "Otherwise, you will forever lose your item to the ethereal void between space and time. No do-overs.",
            },
            AFTER    = { "When you're ready, trade me one piece of the %s and I'll tell you the required materials." },
            TRADE_NQ = { "%s? I require %s to reforge this piece. Please bring both of these together." },
            TRADE_HQ = { "%s? I require %s and a regular %s. Please bring all three of these together." },
            MAXED    = { "Unfortunately this %s has reached its maximum potential and can no longer be reforged." },
            REMINDER_KILLS = { "Here's a reminder of your current trials:" },
            REMINDER_LV30  =
            {
                { emote = xi.emote.CLAP },
                "You've completed the first trial. Next, I'd like to test your one-on-one combat.",
                " Find the %s in %s and defeat the %s. Return here once you're done.",
            },
            REMINDER_LV50  =
            {
                { emote = xi.emote.CLAP },
                "Well, well. Now let's test your ability against a stronger opponent",
                " Find the %s in %s then defeat whatever approaches. Return here once you're done.",
            },
            REMINDER_LV75  =
            {
                "I have one final challenge for you.",
                { emote = xi.emote.YES },
                " You must hunt down and defeat the elusive Desert Hare!",
                { emote = xi.emote.THINK },
                "Do not underestimate this ferocious creature, you will need strong allies.",
                " Look for Shimmering Sand in Western Altepa Desert...",
            },
        },
    },
    {
        id       = "BOX1",
        name     = "Box 1",
        type     = xi.objType.NPC,
        look     = 2331,
        notarget = true,
        hidename = true,
        area     = "Rabao",
        pos      = { 117.596, 8.000, 115.821, 74 }, -- !pos 117.596 8.000 115.821 247
    },
    {
        id       = "BOX2",
        name     = "Box 2",
        type     = xi.objType.NPC,
        look     = 2331,
        notarget = true,
        hidename = true,
        area     = "Rabao",
        pos      = { 120.686, 8.000, 114.786, 96 }, -- !pos 120.686 8.000 114.786 247
    },
    {
        id          = SHIMMERING_SAND,
        name        = "Shimmering Sand",
        marker      = cq.SIDE_QUEST,
        area        = "Western_Altepa_Desert",         -- (F-5)
        pos         = { -411.223, -1.307, 328.763, 31 }, --!pos -411.223 -1.307 328.763 125
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id          = DESERT_HARE,
        name        = "Desert Hare",
        type        = xi.objType.MOB,
        groupId     = 10,
        groupZoneId = 5,
        look        = 1937,
        area        = "Western_Altepa_Desert",
        pos         = { -411.223, -1.307, 328.763, 31 }, --!pos -411.223 -1.307 328.763 125
        level       = 90,
    },
}

-- Automatically create entities from trial table
for jobID, job in pairs(trial) do
    local battles =
    {
        job.battle.LEVEL_30,
        job.battle.LEVEL_50
    }

    for _, battle in pairs(battles) do
        table.insert(entity, {
            id          = battle.popID,
            name        = battle.pop,
            marker      = cq.SIDE_QUEST,
            area        = battle.area,
            pos         = battle.pos,
            look        = battle.popLook,
            dialog      =
            {
                DEFAULT = cq.NOTHING,
                AFTER   = cq.NOTHING_ELSE,
            },
        })

        table.insert(entity, {
            id          = battle.mobID,
            name        = battle.mob,
            type        = xi.objType.MOB,
            groupId     = battle.groupId,
            groupZoneId = battle.groupZoneId,
            look        = battle.look,
            area        = battle.area,
            pos         = battle.pos,
            level       = battle.level,
        })
    end
end

-----------------------------------
-- Trial Quest Step Functions
-----------------------------------
local tq = {}

local function trialList(player, jobID, npc, tbl, progressMessage)
    local jobID   = player:getMainJob()
    local message = { tbl.dialog[progressMessage][1] }

    for k, v in pairs(trial[jobID].kills) do
        local mobName  = string.gsub(v[1], "_", " ")
        local zoneName = string.gsub(v[2], "_", " ")

        table.insert(message, string.format(" %u %s in %s", v[3], mobName, zoneName))
    end

    cexi.util.dialog(player, message, tbl.name, { npc = npc })
end

local function trialMenu(player, jobID, npc, tbl, var, step, lockVar, questName, progressMessage)
    player:customMenu({
        title   = string.format("Begin %s trials?", xi.jobNames[jobID][2]),
        options =
        {
            {
                "Not yet",
                function()
                end,
            },
            {
                "I'm ready",
                function()
                    player:printToPlayer(string.format("\129\158 Quest Accepted: %s", questName), xi.msg.channel.SYSTEM_3)
                    player:setCharVar(var, step)
                    player:setCharVar(lockVar, jobID)
                    trialList(player, jobID, npc, tbl, progressMessage)
                end,
            },
        }
    })
end

tq.trialBegin = function(trial, questionMessage, progressMessage, declineMessage, delayMessage, delayVar, lockVar, questName)
    return function(player, npc, tbl, var, step)
        local jobID     = player:getMainJob()
        local remaining = player:getCharVar(delayVar) - os.time() 

        if trial[jobID] == nil then
            cexi.util.dialog(player, tbl.dialog[declineMessage], tbl.name, { [1] = xi.jobNames[jobID][2], npc = npc })
        elseif remaining > 0 then
            cexi.util.dialog(player, tbl.dialog[delayMessage], tbl.name, { [1] = math.ceil(remaining / 3600), npc = npc })
        else
            cexi.util.dialog(player, tbl.dialog[questionMessage], tbl.name, { [1] = xi.jobNames[jobID][2], npc = npc })
            local delay = cexi.util.dialogDelay(tbl.dialog[questionMessage])

            player:timer(delay, function()
                trialMenu(player, jobID, npc, tbl, var, step, lockVar, questName, progressMessage)
            end)
        end
    end
end

tq.trialStep = function(trial, progressVar, reminderMessage, progressMessage)
    return function(player, npc, tbl, var, step)
        local jobID   = player:getMainJob()
        local message = { tbl.dialog[reminderMessage][1] }
        local pass    = true

        for k, v in pairs(trial[jobID].kills) do
            local result = player:getCharVar(string.format(progressVar, xi.jobNames[jobID][1], k))

            if result < v[3] then
                pass = false
            end

            local mobName  = string.gsub(v[1], "_", " ")
            local zoneName = string.gsub(v[2], "_", " ")

            table.insert(message, string.format(" %u/%u (%s in %s)", result, v[3], mobName, zoneName))
        end

        if pass then
            local battle = trial[jobID].battle.LEVEL_30
            local zoneName = string.gsub(battle.area, "_", " ")

            cexi.util.dialog(player, tbl.dialog[progressMessage], tbl.name, { [1] = battle.pop, [2] = zoneName, [3] = battle.mob, npc = npc })
            player:setCharVar(var, step)
        else
            cexi.util.dialog(player, message, tbl.name, { npc = npc })
        end
    end
end

tq.trialReminder = function(trial, reminderMessage, specified)
    return function(player, npc, tbl)
        local jobID  = player:getMainJob()
        local battle = trial[jobID].battle[specified]
        local zoneName = string.gsub(battle.area, "_", " ")

        cexi.util.dialog(player, tbl.dialog[reminderMessage], tbl.name, { [1] = battle.pop, [2] = zoneName, [3] = battle.mob, npc = npc })
    end
end

tq.trialTalkFinish = function(trial, text, progressVar, questName, music)
    return function(player, npc, tbl, var, step)
        local jobID  = player:getMainJob()
        local setName = trial[jobID].sets[1]
        local jobName = xi.jobNames[jobID][2]

        cexi.util.dialog(player, tbl.dialog[text], tbl.name, { [1] = jobName, [2] = setName, npc = npc })
        player:setCharVar(var, step)

        -- Reset trials progress
        for k, v in pairs(trial[jobID].kills) do
            player:setCharVar(string.format(progressVar, xi.jobNames[jobID][1], k), 0)
        end

        player:printToPlayer(string.format("\129\159 Quest Completed: %s", questName), xi.msg.channel.SYSTEM_3)

        player:changeMusic(0, 67)
        player:changeMusic(1, 67)
        player:timer(5000, function(playerArg)
            player:changeMusic(0, music or 0)
            player:changeMusic(1, music or 0)
        end)
    end
end

tq.trialTalkOnly = function(trial, text)
    return function(player, npc, tbl)
        local jobID  = player:getMainJob()
        local setName = trial[jobID].sets[1]
        cexi.util.dialog(player, tbl.dialog[text], tbl.name, { [1] = setName, npc = npc })
    end
end

local function trialNext(player, var, resetStep, delayVar, lockVar)
    player:tradeComplete()
    player:setCharVar(var, resetStep)
    player:setCharVar(lockVar, 0)
    player:setCharVar(delayVar, getMidnight())
end

local function getNextTier(item, augs)
    local aug0 = item:getAugment(0)
    local aug1 = item:getAugment(1)

    for i = 1, #augs do
        if
            augs[i][1] == aug0[1] and
            augs[i][2] == aug0[2] and
            augs[i][3] == aug1[1] and
            augs[i][4] == aug1[2]
        then
            return i + 1
        end
    end

    return 1
end

local function getAugTier(trade, itemID, augs)
    for i = 0, trade:getSlotCount() - 1 do
        if trade:getItemId(i) == itemID then
            return getNextTier(trade:getItem(i), augs)
        end
    end

    return 1
end

local function giveAugUpgrade(player, npc, trade, armor, piece, maxTier)
    local currentTier = getAugTier(trade, piece, armor.augs)

    if currentTier < maxTier then
        local ID = zones[player:getZoneID()]

        if player:getFreeSlotsCount() > 0 then
            player:tradeComplete()
            player:addItem(piece, 1, unpack(armor.augs[currentTier]))
            npc:independentAnimation(player, 4, 2)

            npc:timer(2000, function()
                player:messageSpecial(ID.text.ITEM_OBTAINED, piece)
            end)

            return true
        else
            player:messageSpecial(ID.text.ITEM_CANNOT_BE_OBTAINED, piece)
            return false
        end
    end

    return false
end

tq.trialReward = function(trial, delayVar, resetStep, lockVar, tradeNQ, tradeHQ, maxed)
    return function(player, npc, trade, entity, var, step)
        local armorSets = trial[player:getMainJob()].armor

        for _, armor in pairs(armorSets) do
            if npcUtil.tradeHasExactly(trade, { armor.high[1], armor.base[1], armor.item[1] }) then
                if
                    cexi.util.augment.isAugmented(trade, armor.base[1]) and
                    player:getLocalVar("[CQ]Adept_Warning") == 0
                then
                    player:sys("You are attempting to trade augmented Normal Quality armor.")
                    player:sys("If you are trying to transfer an NQ augment to an HQ armor then trade the Book of Mastery first.")
                    player:sys("Otherwise, if you trade an augmented NQ with a blank HQ then it will become a stage 1 HQ.")
                    player:sys("Repeat this trade again if you are absolutely sure.")
                    player:setLocalVar("[CQ]Adept_Warning", 1)
                    player:tradeRelease()

                    return
                end

                if giveAugUpgrade(player, npc, trade, armor, armor.high[1], 4) then
                    trialNext(player, var, resetStep, delayVar, lockVar)
                end

                return

            elseif npcUtil.tradeHasExactly(trade, { armor.base[1], armor.item[1] }) then
                if giveAugUpgrade(player, npc, trade, armor, armor.base[1], 3) then
                    trialNext(player, var, resetStep, delayVar, lockVar)
                end

                return

            elseif npcUtil.tradeHasExactly(trade, { armor.high[1] } ) then
                local currentTier = getAugTier(trade, armor.high[1], armor.augs)

                if currentTier < 4 then
                    cexi.util.dialog(player, entity.dialog[tradeHQ], entity.name, { [1] = armor.high[2], [2] = armor.item[2], [3] = armor.base[2], npc = npc })
                else
                    cexi.util.dialog(player, entity.dialog[maxed], entity.name, { [1] = armor.base[2], npc = npc })
                end

                player:incrementCharVar("[CQ]Adept_Tally", 1)

                return

            elseif npcUtil.tradeHasExactly(trade, { armor.base[1] } ) then
                local currentTier = getAugTier(trade, armor.base[1], armor.augs)

                if currentTier < 3 then
                    cexi.util.dialog(player, entity.dialog[tradeNQ], entity.name, { [1] = armor.base[2], [2] = armor.item[2], npc = npc })
                else
                    cexi.util.dialog(player, entity.dialog[maxed], entity.name, { [1] = armor.base[2], npc = npc })
                end

                player:incrementCharVar("[CQ]Adept_Tally", 1)

                return
            end
        end
    end
end

-----------------------------------

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

cexi.util.liveReload(m, {
    ["Rabao"] =
    {
        {
            objtype  = xi.objType.NPC,
            name     = "Book of Mastery",
            look     = 2809,
            x        = 121.444,
            y        = 8.000,
            z        = 113.640,
            rotation = 95,

            onTrigger = function(player, npc)
                local prog = player:getCharVar("[CQ]ADEPT")

                if prog == 0 then
                    player:printToPlayer("You see nothing out of the ordinary.", xi.msg.channel.NS_SAY)
                    return
                end

                local jobID   = player:getCharVar("[CQ]ADEPT_LOCK")
                local jobName = ""

                if
                    jobID ~= 0 and
                    xi.jobNames[jobID] ~= nil
                then
                    jobName = xi.jobNames[jobID][1]
                else
                    player:printToPlayer("You see nothing out of the ordinary.", xi.msg.channel.NS_SAY)
                    return
                end

                delaySendMenu(player, {
                    title  = string.format("Reset your %s trial progress?", jobName),
                    options =
                    {
                        {
                            "No",
                            function()
                            end,
                        },
                        {
                            "Yes",
                            function()
                                local jobID = player:getCharVar("[CQ]ADEPT_LOCK")
                                local jobTrial = trial[jobID]

                                player:setCharVar("[CQ]ADEPT", 0)
                                player:setCharVar("[CQ]ADEPT_LOCK", 0)

                                if jobTrial ~= nil then
                                    for index, _ in pairs(jobTrial.kills) do
                                        player:setCharVar(string.format("[CQ]ADEPT_TRIAL_%s_%u", xi.jobNames[jobID][1], index), 0)
                                    end
                                end

                                player:independentAnimation(player, 248, 4)

                                player:timer(2000, function()
                                    player:printToPlayer("Your Adept trials have been reset!", xi.msg.channel.SYSTEM_3)
                                end)
                            end,
                        }
                    },
                })
            end,

            onTrade = function(player, npc, trade)
                -- Offer to transfer stats to HQ
                for nq, hq in pairs(highQuality) do
                    if npcUtil.tradeHasExactly(trade, { { nq, 1 }, { hq[2], 1 } }) then
                        delaySendMenu(player, {
                            title   = string.format("Transfer stats to %s?", hq[1]),
                            options =
                            {
                                {
                                    "No",
                                    function()
                                    end,
                                },
                                {
                                    "Yes",
                                    function()
                                        npc:independentAnimation(player, 16, 2)
                                        cq.transferAugments(player, trade, nq, hq[2])
                                    end,
                                },
                            },
                        })

                        return
                    end
                end
            end,
        },
    },
})

local step =
{
    {
        check     = cq.checks({ level = 65 }),
        [ADEPTUS] = tq.trialBegin(trial, "QUESTION", "START", "NOJOB", "DELAY", "[CQ]ADEPT_DELAY", "[CQ]ADEPT_LOCK", info.name),
    },
    {
        check     = cq.checks({ jobvar = "[CQ]ADEPT_LOCK" }),
        [ADEPTUS] = tq.trialStep(trial, "[CQ]ADEPT_TRIAL_%s_%u", "REMINDER_KILLS", "REMINDER_LV30"),
    },
    {
        check     = cq.checks({ jobvar = "[CQ]ADEPT_LOCK" }),
        [ADEPTUS] = tq.trialReminder(trial, "REMINDER_LV30", "LEVEL_30"),
    },
    {
        check     = cq.checks({ jobvar = "[CQ]ADEPT_LOCK" }),
        [ADEPTUS] = tq.trialReminder(trial, "REMINDER_LV50", "LEVEL_50"),
    },
    {
        check     = cq.checks({ jobvar = "[CQ]ADEPT_LOCK" }),

        -- [CQ]ADEPT 4
        [ADEPTUS]         = cq.talkOnly("REMINDER_LV75"),
        [SHIMMERING_SAND] = cq.menuSpawn(DESERT_HARE, "Are you ready?", { { "Not yet." }, { "I'm ready." } }, 2),
        [DESERT_HARE]     = cq.killStep(SHIMMERING_SAND),
    },
    {
        check     = cq.checks({ jobvar = "[CQ]ADEPT_LOCK" }),
        [ADEPTUS] = tq.trialTalkFinish(trial, "FINISH", "[CQ]ADEPT_TRIAL_%s_%u", info.name, cexi.music.RABAO),
    },
    {
        check     = cq.checks({ jobvar = "[CQ]ADEPT_LOCK" }),
        -- [CQ]ADEPT 6
        [ADEPTUS] =
        {
            onTrigger = tq.trialTalkOnly(trial, "AFTER"),
            onTrade   = tq.trialReward(trial, "[CQ]ADEPT_DELAY", 0, "[CQ]ADEPT_LOCK", "TRADE_NQ", "TRADE_HQ", "MAXED"),
        }
    },
}

-- Automatically create steps from trial table
for jobID, job in pairs(trial) do
    -- Level 30 battle
    step[3][job.battle.LEVEL_30.popID] = cq.menuSpawn(job.battle.LEVEL_30.mobID, "Are you ready?", { { "Not yet." }, { "I'm ready." } }, 2, true, { levelCap = 30, partySize = 1, job = jobID })
    step[3][job.battle.LEVEL_30.mobID] = cq.killStep(job.battle.LEVEL_30.popID)

    -- Level 50 battle
    step[4][job.battle.LEVEL_30.popID] = cq.talkOnly("AFTER") -- "There is nothing else to do here."
    step[4][job.battle.LEVEL_50.popID] = cq.menuSpawn(job.battle.LEVEL_50.mobID, "Are you ready?", { { "Not yet." }, { "I'm ready." } }, 2, true, { levelCap = 50, partySize = 1, job = jobID })
    step[4][job.battle.LEVEL_50.mobID] = cq.killStep(job.battle.LEVEL_50.popID)

    step[5][job.battle.LEVEL_50.popID] = cq.talkOnly("AFTER") -- "There is nothing else to do here."
end

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
