-------------------------------------------------------
-- Up, Up and Away! (Lv30)
-------------------------------------------------------
-- Steps
-------------------------------------------------------
-- !setvar [CW]UP_UP_AND_AWAY 0
-- Disarmed Knight   !pos 344 0 -42 184
-- Training Supplies !pos -276.003 -144.006 -15.622 158
-- Disarmed Knight   !pos 344 0 -42 184
-- Unlocks: Emilia (Outpost Warps in Jeuno)
-------------------------------------------------------
-- !setvar [CW]UP_UP_AND_AWAY 0

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-------------------------------------------------------
local m = Module:new("cw_quest-up_up_and_away")

local info =
{
    name   = "Up, Up and Away!",
    var    = "[CW]UP_UP_AND_AWAY",
    reward =
    {
        item  = xi.item.ICARUS_WING,
        after = function(player)
            player:setCharVar("[CW]EMILIA", 1)
            player:printToPlayer("You have unlocked Emilia's services in Lower Jeuno!", xi.msg.channel.SYSTEM_3)
            return true
        end,
    },
}

local entity =
{
    {
        id     = "KNIGHT",
        name   = "Disarmed Knight",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.B4,
            head = cexi.model.LEATHER_VEST,
            body = cexi.model.SCALE_MAIL,
            hand = cexi.model.LEATHER_VEST,
            legs = cexi.model.SCALE_MAIL,
            feet = cexi.model.SCALE_MAIL,
        }),
        area      = "Lower_Delkfutts_Tower",
        pos       = { 343.906, 0.000, -42.044, 239 }, -- !pos 344 0 -42 184
        animation = 48,
        dialog    =
        {
            NAME     = true,
            DEFAULT  = { "My battalion should be back here any minute ..." },
            START    =
            {
                "Hey... I left my training supplies in Upper Delkfutts Tower. If I go back without them I'll be the laughing stock of the battalion!",
                { emote = xi.emote.DISGUSTED },
                " Can you help me retrieve it? I think I left it somewhere near the elevator.",
            },
            REMINDER =
            {
                "Hey! No rush with my training supplies... I'll just be here... waiting...",
                { emote = xi.emote.STAGGER },
            },
            FINISH   =
            {
                { emote = xi.emote.JOY },
                "You're a lifesaver! Oh, not a thing about this to anyone, right?",
            },
        },
    },
    {
        id     = "SUPPLIES",
        name   = "Training Supplies",
        marker = cq.SIDE_QUEST,
        area   = "Upper_Delkfutts_Tower",
        pos    = { -276.003, -144.006, -15.622 }, -- !pos -276.003 -144.006 -15.622 158
        dialog =
        {
            DEFAULT  = { "There is nothing out of the ordinary." },
            FINISH   =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion   = "retrieves the training supplies." },
            },
        },
    },
}

local step =
{
    {
        check        = cq.checks({ level = 30 }),
        ["KNIGHT"]   = cq.talkStep("START", info.name),
    },
    {
        ["KNIGHT"]   = cq.talkOnly("REMINDER"),
        ["SUPPLIES"] = cq.menuStep("Retrieve the training supplies?", { { "Yes", "FINISH" }, { "No" } }, 1 ),
    },
    {
        ["KNIGHT"]   = cq.giveStep("FINISH", info.reward, info.name, cexi.music.NONE),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
