-----------------------------------
-- Leg Day     (Lv15)
-- Leg Day II  (Lv20)
-- Leg Day III (Lv25)
-- Leg Work    (Lv35)
-- Leg Work II (Lv35)
-----------------------------------
-- Steps
-----------------------------------
-- !setvar [CW]LEG_DAY 0
-- Pedro      !pos -109.302 0.000 11.311 246
-- River Bank !pos 167.728 2.853 -341.006 149
-- Reward: 800 gil
-----------------------------------
-- !setvar [CW]LEG_DAY 4
-- Pedro           !pos -109.302 0.000 11.311 246
-- Beadeaux Sludge !pos -132.281 1.000 61.863 147
-- Reward: 1600 gil
-----------------------------------
-- !setvar [CW]LEG_DAY 7
-- Pedro          !pos -109.302 0.000 11.311 246
-- Oztroja Gravel !pos 111.277 0.000 -177.022 151
-- Reward: 2400 gil
-----------------------------------
-- !setvar [CW]LEG_DAY 10
-- Pedro        !pos -109.302 0.000 11.311 246
-- Qufim Source !pos -205.642 -19.916 252.775 126
-- Reward: 2400 gil, Silver Hose (Lv36)
-----------------------------------
-- !setvar [CW]LEG_DAY 12
-- Pedro           !pos -109.302 0.000 11.311 246
-- Delkfutt Source !pos 339.800 -15.600 20.088 184
-- Reward: 2400 gil, Velvet Slops (Lv38)
-----------------------------------
-- !setvar [CW]LEG_DAY 16

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-wanting_ore")

local info =
{
    name    = "Leg Day",
    author  = "Loxley",
    var     = "[CW]LEG_DAY",

    reward_davoi    = { gil =  800 },
    reward_beadeaux = { gil = 1600 },
    reward_oztroja  = { gil = 2400 },

    reward_qufim =
    {
        item    = 12809,                            -- Silver Hose
        augment = { 1, 14, 512, 1, 514, 1, 25, 2 }, -- HP +15, STR +2, VIT +2, Attack +3
        gil     = 2400,
    },

    reward_delkfutt =
    {
        item    = 12859,                    -- Velvet Slops
        augment = { 9, 14, 513, 1, 25, 3 }, -- MP +15, DEX +2, Attack +4
        gil     = 2400,
    },
}

local PED               = "PEDRO"
local Pedro             = "Pedro"
local DAVOI_SAMPLE      = "DAVOI_SAMPLE"
local BEADEAUX_SAMPLE   = "BEADEAUX_SAMPLE"
local OZTROJA_SAMPLE    = "OZTROJA_SAMPLE"
local QUFIM_SOURCE      = "QUFIM_SOURCE"
local QUFIM_SENTINEL    = "QUFIM_SENTINEL"
local DELKFUTT_SOURCE   = "DELKFUTT_SOURCE"
local DELKFUTT_SENTINEL = "DELKFUTT_SENTINEL"

local entity =
{
    {
        id     = PED,
        name   = Pedro,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.B8,
            head = cexi.model.NOTHING,
            body = cexi.model.BLACK_CLOAK,
            hand = cexi.model.SHAIR_MANTEEL,
            legs = cexi.model.SHAIR_MANTEEL,
            feet = cexi.model.CROW_JUPON,
        }),
        area   = "Port_Jeuno",
        pos    = { -109.302, 0.000, 11.311, 20 }, -- !pos -109.302 0.000 11.311 246
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "So much to do..." },
            START    =
            {
                { emote = xi.emote.THINK },
                "I'm looking for a research assistant to assist me with certain trifles",
                "Are you up to the task?",
            },
            ACCEPTED       =
            {
                { emote = xi.emote.YES },
                "Excellent. First I'll need a dirt sample from Davoi.",
                " Not just any, mind you. It must be from the river bank.",
            },

            DAVOI_REMINDER = { "Collect a soil sample from the river bank in Davoi." },
            DAVOI_AFTER    =
            {
                { emote = xi.emote.THINK },
                "Interesting. The properties of this dirt are quite peculiar.",
                "Here's your payment. Let me know when you're ready for another task.",
            },

            BEADEAUX_START    = { "Next, I require a sludge sample from Beadeaux." },
            BEADEAUX_REMINDER = { "Collect a sludge sample from Beadeaux." },
            BEADEAUX_AFTER    =
            {
                { emote = xi.emote.THINK },
                "There are inconsistencies but I'm noticing a pattern.",
                "Traces of magicite...",
                { delay = 2000 },
                "Let me know when you're ready to continue. Here's your payment.",
            },

            OZTROJA_START    = { "Next, I require a gravel sample from Castle Oztroja." },
            OZTROJA_REMINDER = { "Collect a gravel sample from Castle Oztroja." },
            OZTROJA_AFTER    =
            {
                { emote = xi.emote.THINK },
                "Yes, that confirms it. Something is contaminating the soil in these areas.",
                { delay = 2000 },
                " The next task will pose significant danger. You must be prepared.",
                { delay = 2000 },
                "Come back when you're ready. Here's your payment.",
            },

            QUFIM_START =
            {
                "I suspect the Zilart structure in Qufim has something to do with this.",
                { delay = 2000 },
                "To confirm, I'll need you to place this device just before the line meets the tower.",
                { emote = xi.emote.TOSS },
                { delay = 2000 },
                "The disruption is likely to cause some attention.",
                "Be prepared to fight what ever comes out to defend the structure.",
            },
            QUFIM_REMINDER = { "Place the device just before the line meets the tower." },
            QUFIM_AFTER    =
            {
                "Impressive. You have done well. This data is sure to assist in my conclusion.",
                { emote = xi.emote.BOW },
                { delay = 2000 },
                "Since you have been of some use to me, I bestow upon you this gift.",
                { delay = 2000 },
                "We still have more work to do. Come back to me when you're ready to continue.",
            },

            DELKFUTT_START =
            {
                "Thanks for collecting those readings.",
                { emote = xi.emote.THINK },
                " Unfortunately the data wasn't enough to establish a concrete cause.",
                { delay = 2000 },
                "I'll need you to travel into the tower itself and find another source",
                { emote = xi.emote.SIGH },
                { delay = 3000 },
                "This is going to be dangerous, prepare yourself for combat.",
                " Travel into Lower Delkfutt's Tower and find somewhere to place the device.",
            },
            DELKFUTT_REMINDER =
            {
                "This is going to be dangerous, prepare yourself for combat.",
                " Travel into Lower Delkfutt's Tower and find somewhere to place the device.",
            },
            DELKFUTT_AFTER       =
            {
                "These are strong readings. Well done! This concludes my research for now.",
                "I am in your debt. Please take these for your trouble.",
                { emote = xi.emote.BOW },
            },
        },
    },

    {
        id     = DAVOI_SAMPLE,
        name   = "River Bank",
        marker = cq.SIDE_QUEST,
        area   = "Davoi",
        pos    = { 167.728, 2.853, -341.006, 0 }, --!pos 167.728 2.853 -341.006 149
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            COLLECT =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion   = "collects a river bank sample." },
            },
        },
    },

    {
        id     = BEADEAUX_SAMPLE,
        name   = "Beadeaux Sludge",
        marker = cq.SIDE_QUEST,
        area   = "Beadeaux",
        pos    = { -132.281, 1.000, 61.863, 0 }, --!pos -132.281 1.000 61.863 147
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            COLLECT =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion   = "collects a sludge sample." },
            },
        },
    },

    {
        id     = OZTROJA_SAMPLE,
        name   = "Oztroja Gravel",
        marker = cq.SIDE_QUEST,
        area   = "Castle_Oztroja",
        pos    = { 111.277, 0.000, -177.022, 0 }, --!pos 111.277 0.000 -177.022 151
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            COLLECT =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion   = "collects a gravel sample." },
            },
        },
    },

    {
        id     = QUFIM_SOURCE,
        name   = "Qufim Source",
        marker = cq.SIDE_QUEST,
        area   = "Qufim_Island",
        pos    = { -205.642, -19.916, 252.775, 98 }, --!pos -205.642 -19.916 252.775 126
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            DEVICE  =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion = "places the device." },
            },
        },
    },

    {
        id          = QUFIM_SENTINEL,
        name        = "Weary Sentinel",
        type        = xi.objType.MOB,
        look        = 304,
        flags       = 135,
        groupId     = 32,
        groupZoneId = 157,
        area        = "Qufim_Island",
        pos         = { -205.642, -19.916, 252.775, 98 }, --!pos -205.642 -19.916 252.775 126
        level       = 38,
    },

    {
        id     = DELKFUTT_SOURCE,
        name   = "Delkfutt Source",
        marker = cq.SIDE_QUEST,
        area   = "Lower_Delkfutts_Tower",
        pos    = { 339.800, -15.600, 20.088, 0 }, --!pos 339.800 -15.600 20.088 184
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            DEVICE  =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion = "places the device." },
            },
        },
    },

    {
        id          = DELKFUTT_SENTINEL,
        name        = "Active Sentinel",
        type        = xi.objType.MOB,
        look        = 412,
        flags       = 135,
        groupId     = 14,
        groupZoneId = 157,
        area        = "Lower_Delkfutts_Tower",
        pos         = { 339.800, -15.600, 20.088, 0 }, --!pos 339.800 -15.600 20.088 184
        level       = 38,
    },
}

local step =
{
    {
        check = cq.checks({ CW = true, level = 15 }),
        [PED] = cq.talkStep("START"),
    },
    {
        [PED] = cq.menuStep("Become an assistant?", { { "Yes, sir.", "ACCEPTED" }, { "I'm not your slave!" } }, 1, info.name),
    },
    {
        [PED]          = cq.talkOnly("DAVOI_REMINDER"),
        [DAVOI_SAMPLE] = cq.menuStep("Take a sample?", { { "Yes.", "COLLECT" }, { "No." } }, 1),
    },
    {
        [DAVOI_SAMPLE] = cq.talkOnly("AFTER"),
        [PED] = cq.giveStep("DAVOI_AFTER", info.reward_davoi, info.name, cexi.music.JEUNO),
    },
    {
        check = cq.checks({ CW = true, level = 20 }),
        [PED] = cq.menuStep("Ready for another task?", { { "Yes, sir.", "BEADEAUX_START" }, { "No, thank you." } }, 1, info.name .. " II"),
    },
    {
        [PED]             = cq.talkOnly("BEADEAUX_REMINDER"),
        [BEADEAUX_SAMPLE] = cq.menuStep("Take a sample?", { { "Yes.", "COLLECT" }, { "No." } }, 1),
    },
    {
        [BEADEAUX_SAMPLE] = cq.talkOnly("AFTER"),
        [PED] = cq.giveStep("BEADEAUX_AFTER", info.reward_beadeaux, info.name .. " II", cexi.music.JEUNO),
    },
    {
        check = cq.checks({ CW = true, level = 25 }),
        [PED] = cq.menuStep("Ready for another task?", { { "Yes, sir.", "OZTROJA_START" }, { "No, thank you." } }, 1, info.name .. " III"),
    },
    {
        [PED]            = cq.talkOnly("OZTROJA_REMINDER"),
        [OZTROJA_SAMPLE] = cq.menuStep("Take a sample?", { { "Yes.", "COLLECT" }, { "No." } }, 1),
    },
    {
        [OZTROJA_SAMPLE] = cq.talkOnly("AFTER"),
        [PED] = cq.giveStep("OZTROJA_AFTER", info.reward_oztroja, info.name .. " III", cexi.music.JEUNO),
    },
    {
        check = cq.checks({ CW = true, level = 35 }),
        [PED] = cq.menuStep("Ready for another task?", { { "Yes, sir.", "QUFIM_START" }, { "No, thank you." } }, 1, "Leg Work"),
    },
    {
        [PED]            = cq.talkOnly("QUFIM_REMINDER"),
        [QUFIM_SOURCE]   = cq.menuSpawn(QUFIM_SENTINEL, "Place the device?", { { "I'm ready.", "DEVICE" }, { "Not yet." } }, 1 ),
        [QUFIM_SENTINEL] = cq.killStep(QUFIM_SOURCE),
    },
    {
        [QUFIM_SOURCE] = cq.talkOnly("AFTER"),
        [PED]          = cq.giveStep("QUFIM_AFTER", info.reward_qufim, "Leg Work", cexi.music.JEUNO),
    },
    {
        check  = cq.checks({ CW = true, level = 35 }),
        [PED] = cq.menuStep("Ready for another task?", { { "Yes, sir.", "DELKFUTT_START" }, { "No, thank you." } }, 1, "Leg Work II"),
    },
    {
        [PED]               = cq.talkOnly("DELKFUTT_REMINDER"),
        [DELKFUTT_SOURCE]   = cq.menuSpawn(DELKFUTT_SENTINEL, "Place the device?", { { "I'm ready.", "DEVICE" }, { "Not yet." } }, 1 ),
        [DELKFUTT_SENTINEL] = cq.killStep(DELKFUTT_SOURCE),
    },
    {
        [DELKFUTT_SOURCE]   = cq.talkOnly("AFTER"),
        [PED]               = cq.giveStep("DELKFUTT_AFTER", info.reward_delkfutt, "Leg Work II", cexi.music.JEUNO),
    },
    -- [CW]LEG_DAY 16
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
