----------------------------------------------------------
-- Harboring Fugitives (Lv50)
----------------------------------------------------------
-- Steps
----------------------------------------------------------
-- !setvar [CW]FUGITIVES 0
-- Agent M-97 !pos 22.378 -0.100 3.079 245
-- Dafoe      !pos -161.589 -24.000 19.847 161
-- Agent M-97 !pos 22.378 -0.100 3.079 245
-- Reward: Artifact Materials
----------------------------------------------------------

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
----------------------------------------------------------
local m = Module:new("cw_harboring_fugitives")

local HARBORING_FUGITIVES   = "HARBORING_FUGITIVES"
local OPERATIVE             = "OPERATIVE"
local EXCISION              = "EXCISION"

local rewardTable =
{
    [0] = { 4198 }, -- Dragon Chronicles

    [xi.job.MNK] =
    {
        4558, -- Yagudo Drink
    },

    [xi.job.WHM] =
    {
        12995, -- Moccasins
    },
    [xi.job.BLM] =
    {
        829, -- Silk Cloth
    },
    [xi.job.RDM] =
    {
        828, -- Velvet Cloth
    },
    [xi.job.THF] =
    {
        { { 17314, 4 } }, -- Quake grenade x 4
    },
    [xi.job.DRK] =
    {
        654, -- Darksteel Ingot
    },
    [xi.job.BST] =
    {
        717, -- Mahogany Lumber
    },
    [xi.job.RNG] =
    {
        13315, -- Gold Earring
    },
    [xi.job.SAM] =
    {
        823, -- Gold Thread
    },
    [xi.job.NIN] =
    {
        17098, -- Oak Pole
    },
    [xi.job.DRG] =
    {
        12494, -- Gold Hairpin
    },
    [xi.job.SMN] =
    {
        { { 17299, 4 } }, -- Astragalos x4
    },
    [xi.job.BLU] =
    {
        761,  828, 2175, 2340, -- (magus_charuqs) gold_chain, velvet_cloth, flan_meat, imperial_silk_cloth
        754,  828,  879, 4158, -- (magus_chalwar) platinum_sheet, velvet_cloth, karakul_leather,venom_potion
        828, 2229, 2288, 2340, -- (magus_jubbah) velvet_Cloth, chimera_blood, karakul_cloth, imperial_silk_cloth
    },
    [xi.job.COR] =
    {
        823,  879, 1829, 2304, -- (corsairs_gants) gold_thread, karakul_leather, red_grass_cloth, wamoura_silk
        879, 2007,  663, 2010, -- (corsairs bottes) karakul_leather, laminated_buffalo_leather, mythril_sheet, wolf_felt
        761, 1829, 1997,  828, -- (corsairs frac) gold_chain, red_grass_cloth, sailcloth, velvet_cloth
    },
    [xi.job.PUP] =
    {
        4161,                  -- (puppetry_churidars) sleeping_potion
        786, 2289, 2152,  754, -- (puppetry_babouches) ruby, wamoura_cloth, marid_leather, platinum_sheet
        821, 2289, 2152,  754, -- (puppetry_dastanas) rainbow_thread, wamoura_cloth, marid_leather, platinum_sheet
        786, 1636, 1699, 2289, -- (puppetry_tobe) ruby, moblinweave, scarlet_linen, mamoura_cloth
    },
    [xi.job.DNC] =
    {
        2288,  830, 1996,      -- (dancers_bangles) karakul_cloth, rainbow_cloth, rainbow_velvet
        2340, 1991, 2010,      -- (dancers_toe_shoes) Imperial_silk_cloth, silver_brocade, wolf_felt
        2289, 1636, 1999,      -- (dancers_casaque) wamoura_cloth, moblinweave, gold_brocade
    },
    [xi.job.GEO] =
    {
        2704, -- (geomancy_pants) oil-soaked_cloth
    },
}

local info =
{
    author = "Carver",
    name   = "Harboring Fugitives",
    var    = "[CW]FUGITIVES",
}

local entity =
{
    {
        id     = "AGENT_M97",
        name   = "Agent M-97",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = 1,
            head = 0,
            body = cexi.model.SHINOBI,
            hand = cexi.model.SHINOBI,
            legs = cexi.model.SHINOBI,
            feet = cexi.model.SHINOBI,
        }),
        area   = "Lower_Jeuno",
        pos    = { 22.378, -0.100, 3.079, 150 }, -- !pos 22.378 -0.100 3.079 245
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Hey, do you mind? I'm kinda busy." },
            START    =
            {
                "Hey, I recognize you from the Tenshodo. You're an operative, right?",
                { emote = xi.emote.POINT },
                { delay = 1000 },
                "I've been getting reports out of Castle Zvahl Baileys from one our agents.",
                " He may have finally met his match in that beastman filled conglomeration.",
                { emote = xi.emote.THINK },
                { delay = 2000 },
                "Could you head down there to check on him? He goes by the name of Dafoe."
            },
            REMINDER =
            {
                "Please head down to Castle Zvahl Baileys and find Dafoe before its too late!",
            },
            CONFRONT =
            {
                "Oh, you're back, operative?",
                " Of course! Did you find the fate of our comrade Dafoe?",
                { delay = 2000 },
                { emote = xi.emote.THINK },
                "So you've found me out... That wimp had it coming for ages.",
                " He'd bully me relentlessly in operative school years back.",
                "I've been plotting my revenge ever since.",
                { delay = 2000 },
                { emote = xi.emote.SIGH },
                "Do with the information what you will...",
                " Or choose a reward from the chest in exchange for your silence.",
            },
            FINISH =
            {
                "Good choice, initiate. You may choose the reward at your convenience.",
            },
            COMEBACK =
            {
                "Do with the information what you will then! Offer will remain open.",
            },
        },
    },
    {
        id     = "ARTIFACTS",
        name   = "Treasure Coffer",
        type   = xi.objType.NPC,
        look   = 969,
        area   = "Lower_Jeuno",
        pos    = { 19.906, -0.100, 1.285, 20 }, -- !pos 19.906 -0.100 1.285 245
        dialog =
        {
            DEFAULT =
            {
                "It's locked.",
            },

            COOLDOWN =
            {
                { message = "You may only receive these rewards once per day." },
            },
        },
    },
    {
        id          = "EXCISION",
        name        = "Excision M-72",
        type        = xi.objType.MOB,
        groupId     = 46,
        groupZoneId = 87,
        look        = 2155,
        area        = "Castle_Zvahl_Baileys",
        pos         = { -142.724, -24.015, 19.547, 128 }, -- !pos -142.724 -24.015 19.547 161
        level       = 53,
    },
    {
        id        = "DAFOE",
        name      = "Dafoe",
        type      = xi.objType.NPC,
        look      = cexi.util.look({
            race = xi.race.HUME_M,
            face = 5,
            head = 0,
            body = cexi.model.JUJITSU_GI,
            hand = cexi.model.JUJITSU_GI,
            legs = cexi.model.JUJITSU_GI,
            feet = cexi.model.JUJITSU_GI,
        }),
        animation = 33,
        area      = "Castle_Zvahl_Baileys",
        pos       = { -161.589, -24.000, 19.847, 2 }, -- !pos -161.589 -24.000 19.847 161
        dialog    =
        {
            NAME    = true,
            DEFAULT =
            {
                { noturn = true },
                "I... can't... go on much longer...",
            },
            BETRAYAL =
            {
                { noturn = true },
                "That snake, double crossed me. Sent me down here to recover a treasure for him...",
                " And I was ambushed by that abomination of his!",
                { delay = 2000 },
                "He'd been looking to test his latest creation against a formidable foe...",
                " And I guess... he thought...",
                " I was... it...",
                { entity = "Dafoe", packet = "dead" },
                { delay = 3000 },
                { despawn = { "Dafoe" } },
            },
        },
    },
}

local step =
{
    {
        check            = cq.checks({ CW = true, level = 50, cooldown = "[CW]FUGITIVES_MIDNIGHT" }),
        ["AGENT_M97"]    = cq.talkStep("START", info.name),
        ["DAFOE"]        = cq.talkOnly("DEFAULT"),
    },
    {
        ["AGENT_M97"] = cq.talkOnly("REMINDER"),
        ["DAFOE"]     = cq.spawnMob(EXCISION, "BETRAYAL", false, { levelCap = 50 }),
        ["EXCISION"]  = cq.killStep()
    },
    {
        ["AGENT_M97"] = cq.menuStep("Confront Agent M-97?", { { "Yes", "CONFRONT" }, { "No" } }, 1),
    },
    {
        ["AGENT_M97"] = cq.menuStep("Give a vow of silence?", { { "Yes", "FINISH" }, { "No", "COMEBACK" } }, 1, info.name, true, cexi.music.JEUNO),
    },
    {
        check         = cq.checks({ CW = true, level = 50 }), -- Ensure current job is 50 before distributing rewards
        ["AGENT_M97"] = cq.talkOnly("FINISH"),
        ["ARTIFACTS"] = cq.jobReward(rewardTable, info.var, 0),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
