-----------------------------------
-- Finding Nemosyne (Lv15)
-----------------------------------
-- Steps
-----------------------------------
-- !setvar [CW]FINDING_NEMOSYNE 0
-- Letheb      !pos -40.703 5.900 -87.803 245
-- Aery Source !pos 99.623 8.057 60.668 154
-- Letheb      !pos -40.703 5.900 -87.803 245
-- Reward: Holy Water x3
-- Unlocks: Nemosyne
-----------------------------------
-- !setvar [CW]FINDING_NEMOSYNE 4

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-finding_nemosyne")

local info =
{
    name   = "Finding Nemosyne",
    author = "Loxley",
    var    = "[CW]FINDING_NEMOSYNE",
    reward =
    {
        item  = { { 4154, 3 } }, -- Holy Water x3
        after = function(player)
            player:setCharVar("[CW]NEMOSYNE", 1)
            player:printToPlayer("You have unlocked Nemosyne's services in Upper Jeuno!", xi.msg.channel.SYSTEM_3)
            return true
        end,
    },
}

local LETH        = "LETH"
local Letheb      = "Letheb"
local AERY_SOURCE = "AERY_SOURCE"

local entity   =
{
    {
        id     = LETH,
        name   = Letheb,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.HUME_M,
            face = cexi.face.B4,
            head = 0,
            body = cexi.model.JUSTAUCORPS,
            hand = cexi.model.WHITE_CLOAK,
            legs = cexi.model.TUNIC,
            feet = cexi.model.WHITE_CLOAK,
        }),
        area   = "Lower_Jeuno",
        pos    = { -40.703, 5.900, -87.803, 75 }, -- !pos -40.703 5.900 -87.803 245
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Oh man... why was I here again?" },
            START    =
            {
                { emote = xi.emote.THINK },
                "Oh man... why was I here again?",
                "...Oh hey, maybe you could help me out?",
            },

            ACCEPTED =
            {
                "Some lady who restores... I forget what exactly...",
                { emote = xi.emote.THINK },
                { delay = 3000 },
                "Restores rewards from your quests. Yes, that was it.",
                "But I can't remember where she was!",
                { emote = xi.emote.SIGH },
                { delay = 3000 },

                { emote = xi.emote.SHOCKED },
                "This is going to sound crazy but...",
                "Someone told me that drinking from a certain pool brings back memories!",
                { delay = 3000 },

                "...that would be really useful right about now haha...",

                { emote = xi.emote.THINK },
                "I think it was...",
                " ...it was in Dragon's Aery!",

                "Bring me some water from Dragon's Aery and maybe I'll remember where that lady was.",
                { emote = xi.emote.CHEER },
            },

            REMINDER = { "Bring me some water from Dragon's Aery and maybe I'll remember where that lady was." },

            FINISH =
            {
                { emote = xi.emote.SHOCKED },
                "Woah! This stuff actually works!",
                { delay = 3000 },
                "I remembered what day it is! I remembered my wife's birthday. I remembered our anniversary... wait. Oh no! I missed it again!!",
                { emote = xi.emote.STAGGER },
                { delay = 1000 },
                "Um anyway, that lady was at the Temple of the Goddess in Upper Jeuno!",
                "Phew!",
            },

            AFTER  = { "Thanks to you, I finally remember why I'm here!" },
        },
    },

    {
        id     = AERY_SOURCE,
        name   = "Aery Pool",
        marker = cq.SIDE_QUEST,
        area   = "Dragons_Aery",
        pos    = { -29.061, -2.191, 65.617, 105 }, --!pos  -29.061 -2.191 65.617 154
        dialog =
        {
            DEFAULT  = cq.NOTHING,
            AFTER    = cq.NOTHING_ELSE,
            ACCEPTED =
            {
                { animation = 48, target = "player", duration = 3000 },
                { emotion   = "collects some aery water." },
            },
        },
    },
}

local step =
{
    {
        check  = cq.checks({ CW = true, level = 15 }),
        [LETH] = cq.talkStep("START"),
    },
    {
        [LETH] = cq.menuStep("Agree to help?", { { "Yes.", "ACCEPTED" }, { "Forget it." } }, 1, info.name),
    },
    {
        [LETH]        = cq.talkOnly("REMINDER"),
        [AERY_SOURCE] = cq.menuStep("Why are you here?", { { "I remember.", "ACCEPTED" }, { "Why am I here?" } }, 1),
    },
    {
        [AERY_SOURCE] = cq.talkOnly("AFTER"),
        [LETH]        = cq.giveStep("FINISH", info.reward, info.name, cexi.music.JEUNO),
    },
    {
        [LETH] = cq.talkOnly("AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
