-----------------------------------
-- Empty Handed (Lv25)
-----------------------------------
-- !setvar [CW]EMPTY_HANDED 0
-- Faded Footprint !pos -4.495 -5.000 29.256 243
-- Echo of Holla   !pos -103.411 0.000 147.617 16
-- Echo of Dem     !pos 207.167 0.000 -285.535 18
-- Echo of Mea     !pos -186.502 -0.269 298.338 20
-- Faded Footprint !pos -4.495 -5.000 29.256 243
-- Steel Teeth     !pos -58.409 -16.000 29.167 249
-----------------------------------
-- !setvar [CW]EMPTY_HANDED 8

require("modules/module_utils")
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-empty_handed")

local info =
{
    name    = "Empty Handed",
    author  = "Loxley",
    var     = "[CW]EMPTY_HANDED",
}

local CASSUS         = "CASSUS"
local FADED          = "FADED"
local CassusNPC      = "Cassus"
local FadedFootprint = "Faded Footprint"

local ECHO_HOLLA = "ECHO_HOLLA"
local ECHO_DEM   = "ECHO_DEM"
local ECHO_MEA   = "ECHO_MEA"

local MOB_HOLLA  = "MOB_HOLLA"
local MOB_DEM    = "MOB_DEM"
local MOB_MEA    = "MOB_MEA"

local gainImpression = function(area)
    return {
        { animate = 117, mode = 1 },
        { delay   = 1000 },
        { entity  = "player", emote = xi.emote.THINK },
        { delay   = 1000 },
        { emotion = string.format("gains an impression of the %s echo.", area) },
    }
end

local entity =
{
    {
        id     = CASSUS,
        name   = CassusNPC,
        type   = xi.objType.NPC,
        hidden = true,
        look   = cexi.util.look({
            race = xi.race.HUME,
            face = cexi.face.A6,
            head = 0,
            body = cexi.model.BLACK_CLOAK,
            hand = cexi.model.DALMATICA,
            legs = cexi.model.DALMATICA,
            feet = cexi.model.DALMATICA,
        }),
        area   = "RuLude_Gardens",                -- (H-7)
        pos    = { -4.495, -5.000, 29.256, 255 }, -- !pos -4.495 -5.000 29.256 243
    },
    {
        id     = FADED,
        name   = FadedFootprint,
        marker = cq.MAIN_QUEST,
        area   = "RuLude_Gardens",                -- (H-7)
        pos    = { -4.495, -5.000, 29.256, 255 }, -- !pos -4.495 -5.000 29.256 243
        dialog =
        {
            DEFAULT  = cq.NOTHING,
            START    =
            {
                { despawn = { FadedFootprint } },
                { spawn   = { CassusNPC } },
                { delay   = 2000 },
                { entity  = CassusNPC, face = "player" },
                "Cassus : I see it in your eyes... You have ventured into the emptiness.",
                " I was like you once. I have in my possession, a certain set of armor.",
                "Cassus : If you truly wish to overcome the emptiness, you will need it.",
                { entity  = CassusNPC, emote = xi.emote.THINK },
                { delay = 2000 },
                "Cassus : Travel to Promyvion - Holla, Dem and Mea. Confront the echoes of each memory.",
                " Collect their impressions then return to me and I will attempt to restore the armor.",
                { delay = 2000 },
                { despawn = { CassusNPC } },
                { spawn   = { FadedFootprint } },
            },

            AFTER_START =
            {
                { despawn = { FadedFootprint } },
                { spawn   = { CassusNPC } },
                { delay   = 2000 },
                { entity  = CassusNPC, face = "player" },
                "Cassus : Travel to Promyvion - Holla, Dem and Mea. Confront the echoes of each memory.",
                " Collect their impressions then return to me and I will attempt to restore the armor.",
                { delay = 2000 },
                { despawn = { CassusNPC } },
                { spawn   = { FadedFootprint } },
            },

            AFTER_HOLLA = { "You've gained an impression of Holla but you still lack Dem and Mea." },
            AFTER_DEM   = { "You've gained an impression of Holla and Dem but you still lack Mea." },

            AFTER =
            {
                { despawn = { FadedFootprint } },
                { spawn   = { CassusNPC } },
                { delay   = 2000 },
                { entity  = CassusNPC, face = "player" },
                "Cassus : Well done, you've collected all three memories.",
                " Let's see what I can do.",
                { entity  = CassusNPC, emote = xi.emote.THINK },
                "...",
                "..",
                ".",
                "Cassus : Unfortunately, this armor is beyond my ability to repair completely.",
                " Take these pieces to Steel Teeth in Mhaura and see if he can finish the work.",
                { delay = 2000 },
                { despawn = { CassusNPC } },
                { spawn   = { FadedFootprint } },
            },

            REMINDER =
            {
                { despawn = { FadedFootprint } },
                { spawn   = { CassusNPC } },
                { delay   = 2000 },
                { entity  = CassusNPC, face = "player" },
                "Cassus : Unfortunately, this armor is beyond my ability to repair completely.",
                " Take those pieces to Steel Teeth in Mhaura and see if he can finish the work.",
                { delay = 2000 },
                { despawn = { CassusNPC } },
                { spawn   = { FadedFootprint } },
            },
        },
    },
    {
        id       = ECHO_HOLLA,
        name     = "Echo of Holla",
        marker   = cq.SIDE_QUEST,
        area     = "Promyvion-Holla",
        pos      = { -103.411, 0.000, 147.617, 29 }, --!pos -103.411 0.000 147.617 16
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            PROG    = gainImpression("Holla"),
        },
    },
    {
        id          = MOB_HOLLA,
        name        = "Dwelling Memory",
        type        = xi.objType.MOB,
        groupId     = 1,
        groupZoneId = 17,
        area        = "Promyvion-Holla",
        pos         = { -103.411, 0.000, 147.617, 29 }, --!pos -103.411 0.000 147.617 16
        level       = 34,
    },
    {
        id       = ECHO_DEM,
        name     = "Echo of Dem",
        marker   = cq.SIDE_QUEST,
        area     = "Promyvion-Dem",
        pos      = { 207.167, 0.000, -285.535, 14 }, --!pos 207.167 0.000 -285.535 18
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            PROG    = gainImpression("Dem"),
        },
    },
    {
        id          = MOB_DEM,
        name        = "Bursting Memory",
        type        = xi.objType.MOB,
        groupId     = 1,
        groupZoneId = 19,
        area        = "Promyvion-Dem",
        pos         = { 207.167, 0.000, -285.535, 14 }, --!pos 207.167 0.000 -285.535 18
        level       = 34,
    },
    {
        id       = ECHO_MEA,
        name     = "Echo of Mea",
        marker   = cq.SIDE_QUEST,
        area     = "Promyvion-Mea",
        pos      = { -186.502, -0.269, 298.338, 49 }, --!pos -186.502, -0.269, 298.338 20
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            PROG    = gainImpression("Mea"),
        },
    },
    {
        id          = MOB_MEA,
        name        = "Piercing Memory",
        type        = xi.objType.MOB,
        groupId     = 1,
        groupZoneId = 21,
        area        = "Promyvion-Mea",
        pos         = { -186.502, -0.269, 298.338, 49 }, --!pos -186.502, -0.269, 298.338 20
        level       = 34,
    },
}

local step =
{
    {
        check        = cq.checks({ CW = true, level = 25 }),
        [FADED]      = cq.talkStep("START", info.name),
    },
    {
        [FADED]      = cq.talkOnly("AFTER_START"),
        [ECHO_HOLLA] = cq.menuSpawn(MOB_HOLLA, "Are you ready?", { { "No" }, { "Yes" } }, 2),
        [MOB_HOLLA]  = cq.killStep(ECHO_HOLLA, nil, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "EMPTY_HANDED_HOLLA" }),
    },
    {
        [ECHO_HOLLA] = cq.talkStep("PROG"),
    },
    {
        [ECHO_HOLLA] = cq.talkOnly("AFTER"),
        [FADED]      = cq.talkOnly("AFTER_HOLLA"),
        [ECHO_DEM]   = cq.menuSpawn(MOB_DEM, "Are you ready?", { { "No" }, { "Yes" } }, 2),
        [MOB_DEM]    = cq.killStep(ECHO_DEM, nil, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "EMPTY_HANDED_DEM" }),
    },
    {
        [ECHO_DEM]   = cq.talkStep("PROG"),
    },
    {
        [ECHO_DEM]   = cq.talkOnly("AFTER"),
        [FADED]      = cq.talkOnly("AFTER_DEM"),
        [ECHO_MEA]   = cq.menuSpawn(MOB_MEA, "Are you ready?", { { "No" }, { "Yes" } }, 2),
        [MOB_MEA]    = cq.killStep(ECHO_MEA, nil, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "EMPTY_HANDED_MEA" }),
    },
    {
        [ECHO_MEA]   = cq.talkStep("PROG"),
    },
    {
        [FADED]      = cq.talkFinish("AFTER", info.name, cexi.music.RULUDE_GARDENS),
    },
    {
        [FADED]      = cq.talkOnly("REMINDER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
