-------------------------------------------------------------
-- Digging up Dirt (Lv30)
-------------------------------------------------------------
-- Steps
-------------------------------------------------------------
-- !setvar [CW]DIGGING_DIRT 0
-- Sebastian      !pos 17.251 -0.100 -8.980 245
-- Balgas Dirt    !pos 307.913 -124.077 349.267 146
-- Sebastian      !pos 17.251 -0.100 -8.980 245
-- Waughroon Dirt !pos -328.281 104.415 -260.073 144
-- Sebastian      !pos 17.251 -0.100 -8.980 245
-- Horlais Dirt   !pos -513.302 158.275 -204.319 139
-- Sebastian      !pos 17.251 -0.100 -8.980 245
-- Reward: 500 gil
-- Unlocks: BCNM Warp NPC in Jeuno (Domenic)
-------------------------------------------------------------
-- !setvar [CW]DIGGING_DIRT 6

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-------------------------------------------------------
local m = Module:new("cw_digging_up_dirt")

local BALGAS_DIRT    = "BALGAS_DIRT"
local WAUGHROON_DIRT = "WAUGHROON_DIRT"
local HORLAIS_DIRT   = "HORLAIS_DIRT"
local SEBASTIAN      = "SEBASTIAN"

local info =
{
    author = "Carver",
    name   = "Digging Up Dirt",
    var    = "[CW]DIGGING_DIRT",
    reward =
    {
        gil   = 500,
        after = function(player)
            player:setCharVar("[CW]DOMENIC", 1)
            player:printToPlayer("You have unlocked Domenic's services in Lower Jeuno!", xi.msg.channel.SYSTEM_3)
            return true
        end,
    }
}

local DIRT_DIALOG =
{
    DEFAULT = cq.NOTHING,
    AFTER   = cq.NOTHING_ELSE,
    FINISH  =
    {
        { animation = 48, target = "player", duration = 3000 }, -- Crouch down
        { emotion = "digs up some dirt on Domenic." },
    },
}

local entity =
{
    {
        id     = "SEBASTIAN",
        name   = "Sebastian",
        type   = xi.objType.NPC,
        look   = "0x010001010010A220183005404051006000700000",
        area   = "Lower_Jeuno",
        pos    = { 17.251, -0.100, -8.980, 245 }, -- !pos 17.251 -0.100 -8.980 245
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "If you don't have business with The Tenshodo, you best keep it movin' ..." },
            START    =
            {
                "Hey, see that wannabe guard at the end of the hallway?",
                { delay = 500 },
                { entity = "Sebastian", face = 20 },
                { delay = 500 },
                { emote = xi.emote.POINT },
                { delay = 2000 },
                { entity = "Sebastian", face = "player" },
                "Yeah, that one.",
                " I've had it up to here with that jerk!",
                { emote = xi.emote.ANGRY },
                { delay = 2000 },
                "Anyways, he's been charging adventurers an arm and a leg for fast-travel to battlefield areas for far too long.",
                { delay = 1000 },
                { emote = xi.emote.THINK },
                " Gather some evidence of his deceitful practices for me, and I'll make sure you make it on the VIP list.",
                "What do you say?",
            },
            ACCEPTED =
            {
                { emote = xi.emote.YES },
                "Great. Travel to Balga's Dais and bring back some dirt on that low-life.",
            },
            STEP1 =
            {
                "Travel to Balga's Dais and bring back some dirt on that low-life.",
            },
            STEP2 =
            {
                "Ooh.. Oooh... This is juicy! See if you can find anything else on him in Waughroon Shrine.",
                { emote = xi.emote.JOY },
            },
            STEP3 =
            {
                "It just keeps getting better, doesn't it? See what you can find in Horlais Peak.",
                { emote = xi.emote.LAUGH },
            },
            FINISH   =
            {
                { emote = xi.emote.JOY },
                "This is perfect. I couldn't have done it without you.",
                " We can use this as blackmail to get you on the free-flyer list.",
                { delay = 1000 },
                "If he gives me any more trouble, straight to the boss I go with all of this evidence.",
                "Thank you adventurer!",
                { emote = xi.emote.BOW },
            },
            COMPLETED =
            {
                "Thanks again for your help. Domenic has been a model employee since we put him in his place.",
            },
        },
    },
    {
        id     = "BALGAS_DIRT",
        name   = "Balgas Dirt",
        marker = cq.SIDE_QUEST,
        area   = "Balgas_Dais",
        pos    = { 307.913, -124.077, 349.267 }, -- !pos 307.913 -124.077 349.267 146
        dialog = DIRT_DIALOG,
    },
    {
        id     = "WAUGHROON_DIRT",
        name   = "Waughroon Dirt",
        marker = cq.SIDE_QUEST,
        area   = "Waughroon_Shrine",
        pos    = { -328.281, 104.415, -260.073 }, -- !pos -328.281 104.415 -260.073 144
        dialog = DIRT_DIALOG,
    },
    {
        id     = "HORLAIS_DIRT",
        name   = "Horlais Dirt",
        marker = cq.SIDE_QUEST,
        area   = "Horlais_Peak",
        pos    = { -513.302, 158.275, -204.319 }, -- !pos -513.302 158.275 -204.319 139
        dialog = DIRT_DIALOG,
    },
}

local step =
{
    {
        check         = cq.checks({ era = true, level = 30 }),
        ["SEBASTIAN"] = cq.talkStep("START"),
    },
    {
        ["SEBASTIAN"] = cq.menuStep("What do you say?", { { "Yes", "ACCEPTED" }, { "No" } }, 1, info.name ),
    },
    {
        ["SEBASTIAN"]   = cq.talkOnly("STEP1"),
        ["BALGAS_DIRT"] = cq.menuStep("Dig up the dirt on Domenic?", { { "Yes", "FINISH" }, { "No" } }, 1 ),
    },
    {
        ["BALGAS_DIRT"]    = cq.talkOnly("AFTER"),
        ["SEBASTIAN"]      = cq.talkOnly("STEP2"),
        ["WAUGHROON_DIRT"] = cq.menuStep("Dig up the dirt on Domenic?", { { "Yes", "FINISH" }, { "No" } }, 1 ),
    },
    {
        ["WAUGHROON_DIRT"] = cq.talkOnly("AFTER"),
        ["SEBASTIAN"]      = cq.talkOnly("STEP3"),
        ["HORLAIS_DIRT"]   = cq.menuStep("Dig up the dirt on Domenic?", { { "Yes", "FINISH" }, { "No" } }, 1 ),
    },
    {
        ["HORLAIS_DIRT"] = cq.talkOnly("AFTER"),
        ["SEBASTIAN"]    = cq.giveStep("FINISH", info.reward, info.name, cexi.music.JEUNO),
    },
    {
        ["SEBASTIAN"] = function(player, npc, tbl)
            cexi.util.dialog(player, tbl.dialog.COMPLETED, npc:getPacketName(), { npc = npc })
            xi.shop.general(player, {
                4376,  120, -- Meat Jerky
                4394,   10, -- Ginger Cookie
                1179,  125, -- Shihei
                1194,  125, -- Shinobi-Tabi
                4151,  800, -- Echo Drops
                 605,  200, -- Pickaxe
                1020,  300, -- Sickle
                1021,  500, -- Hatchet
            }, xi.fameArea.NORG)
        end,
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
