-----------------------------------
-- Decrypting Antiquity    (Lv45)
-- Decrypting Antiquity II (Lv50)
-----------------------------------
-- Steps
-----------------------------------
-- !setvar [CW]DECRYPTING_ANTIQUITY 0
-- Lectilas     !pos -91.405 0.799 85.281 244
-- !additem 917
-- Ancient Text !pos 382.983 -40.000 14.995 195
-- Lectilas     !pos -91.405 0.799 85.281 244
-- Reward: 3000 gil
-----------------------------------
-- !setvar [CW]DECRYPTING_ANTIQUITY 0
-- Lectilas     !pos -91.405 0.799 85.281 244
-- !additem 1088
-- Reward: Various scrolls
-----------------------------------
-- !setvar [CW]DECRYPTING_ANTIQUITY 0

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-decrypting_antiquity")

local info =
{
    name   = "Decrypting Antiquity",
    author = "Loxley",
    var    = "[CW]DECRYPTING_ANTIQUITY",
    tally  = "[CW]SCROLLS_DECRYPTED",
    reward =
    {
        gil = 3000,
    },
    required =
    {
        item = xi.item.PIECE_OF_ANCIENT_PAPYRUS,
        name = "a piece of ancient papyrus",
    },
    exchange =
    {
        [xi.item.PIECE_OF_ANCIENT_PAPYRUS] =
        {
            { cexi.rate.VERY_COMMON, 4198, "a page from the Dragon Chronicles" }, --  (24%)
            { cexi.rate.UNCOMMON,    4814, "a scroll of Freeze"                }, --  (10%)
            { cexi.rate.UNCOMMON,    4816, "a scroll of Tornado"               }, --  (10%)
            { cexi.rate.UNCOMMON,    4818, "a scroll of Quake"                 }, --  (10%)
            { cexi.rate.UNCOMMON,    4820, "a scroll of Burst"                 }, --  (10%)
            { cexi.rate.UNCOMMON,    4822, "a scroll of Flood"                 }, --  (10%)
            { cexi.rate.UNCOMMON,    4812, "a scroll of Flare"                 }, --  (10%)
            { cexi.rate.UNCOMMON,    4665, "a scroll of Haste"                 }, --  (10%)
            { cexi.rate.UNCOMMON,    4736, "a scroll of Protectra IV"          }, --  (10%)
            { cexi.rate.UNCOMMON,    4717, "a scroll of Refresh"               }, --  (10%)
            { cexi.rate.UNCOMMON,    4868, "a scroll of Dispel"                }, --  (10%)
            { cexi.rate.RARE,        4714, "a scroll of Phalanx"               }, --  ( 5%)
            { cexi.rate.RARE,        4751, "a scroll of Erase"                 }, --  ( 5%)
            { cexi.rate.RARE,        4621, "a scroll of Raise II"              }, --  ( 5%)
            { cexi.rate.RARE,        4947, "a scroll of Utsusemi: Ni"          }, --  ( 5%)
            { cexi.rate.RARE,        5074, "a scroll of Maiden's Virelai"      }, --  ( 5%)
            { cexi.rate.RARE,        4995, "a scroll of Mage's Ballad II"      }, --  ( 5%)
            { cexi.rate.VERY_RARE,   4780, "a scroll of Water IV"              }, --  ( 1%)
            { cexi.rate.VERY_RARE,   4789, "a scroll of Blizzaga III"          }, --  ( 1%)
        },
    },
}

local LECT        = "LECT"
local Lectilas    = "Lectilas"
local TEXT        = "TEXT"
local AncientText = "Ancient Text"

local entity   =
{
    {
        id     = LECT,
        name   = Lectilas,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A4,
            head = cexi.model.TRADERS_SAIO,
            body = cexi.model.DALMATICA,
            hand = cexi.model.WHITE_CLOAK,
            legs = cexi.model.NASHIRA_MANTEEL,
            feet = cexi.model.WHITE_CLOAK,
        }),
        area   = "Upper_Jeuno",
        pos    = { -91.405, 0.799, 85.281, 205 }, -- !pos -91.405 0.799 85.281 244
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Studying the ancient writings is my life's work." },
            START    =
            {
                { emote = xi.emote.THINK },
                "Greetings adventurer. I'm uncovering the mysteries of the past.",
                { delay = 1000 },
                "I'd appreciate some assistance and will gladly provide compensation.",
            },
            ACCEPTED =
            {
                { emote = xi.emote.YES },
                "Very good. Let's get to work.",
                "First I require a copy of an inscription in The Eldieme Necropolis.",
                { delay = 1000 },
                "Take a sheet of parchment and record it for my reference.",
            },
            AFTER    =
            {
                { emote = xi.emote.THINK },
                "Hmm... As I suspected. There is so much more to learn.",
                "Here's your compensation for this work.",
                { delay = 1000 },
                "Please come back if you'd like to do more.",
            },

            PAPYRUS  =
            {
                { emote = xi.emote.WAVE },
                "Hello again. I'm glad you've decided to join me in uncovering the past.",
                "There are countless lost manuscripts throughout this world. Many are hidden in dark places.",
                { delay = 2000 },
                { emote = xi.emote.BOW },
                "Please deliver any ancient papyri you find and I will attempt to decypher them.",
                { message = "You have unlocked scroll storage services at Gramateus!" },
            },
        },
    },

    {
        id     = TEXT,
        name   = AncientText,
        marker = cq.SIDE_QUEST,
        area   = "The_Eldieme_Necropolis",
        pos    = { 382.983, -40.000, 14.995, 0 }, --!pos 382.983 -40.000 14.995 195
        dialog =
        {
            DEFAULT  = cq.NOTHING,
            CHECK    = { "You see an ancient inscription. If only you had a parchment to copy it." },
            DECLINED = { "Nothing happens." },
            ACCEPTED =
            {
                { entity = "player", emote = xi.emote.THINK },
                { delay = 3000 },
                "You copy the inscription.",
            },
            AFTER = cq.NOTHING_ELSE,
        },
    },
}

local step =
{
    {
        check  = cq.checks({ CW = true, level = 45 }),
        [LECT] = cq.talkStep("START"),
    },
    {
        [LECT] = cq.menuStep("Agree to help?", { { "Sounds interesting.", "ACCEPTED" }, { "History is boring." } }, 1, info.name),
    },
    {
        [TEXT] =
        {
            onTrigger = cq.talkOnly("CHECK"),
            onTrade   = cq.tradeStep("ACCEPTED", "DECLINED", 917),
        },
    },
    {
        [TEXT] = cq.talkOnly("AFTER"),
        [LECT] = cq.giveStep("AFTER", info.reward, info.name, cexi.music.JEUNO),
    },
    {
        check  = cq.checks({ CW = true, level = 50 }),
        [LECT] = cq.menuStep("Continue the quest?", { { "I love history!", "PAPYRUS" }, { "This is not for me." } }, 1, info.name .. " II"),
    },
    {
        [LECT] =
        {
            onTrigger = cq.talkOnly("DEFAULT"),
            onTrade   = cq.trade({
                quest    = info.name .. " II",
                music    = cexi.music.JEUNO,
                tally    = info.tally,
                name     = Lectilas,
                step     = false,
                exchange = info.exchange,
                accepted =
                {
                    "Fascinating...",
                    { emote = xi.emote.THINK },
                    " Yes...",
                    { emote = xi.emote.BOW },
                    "Thank you. I've taken all the notes I need. You can have this back.",
                },
                declined =
                {
                    "Sorry but this is not what I'm looking for.",
                },
                conditional = function(player, exchangeList)
                    local result = {}

                    for _, itemInfo in pairs(exchangeList) do
                        local itemID   = itemInfo[2]

                        if itemID == xi.item.DRAGON_CHRONICLES then
                            table.insert(result, itemInfo)
                        elseif not player:hasItem (itemID) then
                            local index    = cexi.crystal_warrior.scrolls_tradeable[itemID][1]
                            local category = cexi.crystal_warrior.scrolls_tradeable[itemID][3]
                            local tier     = cexi.crystal_warrior.scrolls_tradeable[itemID][4]
                            local varName  = fmt("[CW]SCROLL_{}_{}", cexi.crystal_warrior.scrolls_short[category], cexi.numeral[tier])
                            local value    = player:getCharVar(varName)

                            if not utils.mask.getBit(value, index) then
                                table.insert(result, itemInfo)
                            end
                        end
                    end

                    return result
                end,
            }),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
