-----------------------------------
-- Timeless Echoes (Lv65)
-----------------------------------
-- !setvar [CQ]TIMELESS_ECHOES 0
-- !setvar [NEO]SAND 0
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cq-timeless_echoes")

local info =
{
    name     = "Timeless Echoes",
    author   = "Loxley",
    var      = "[CQ]TIMELESS_ECHOES",
    tally    = "[NEO]SAND",
    required = xi.item.TIMELESS_SAND,
}

local UMBRA_CS = "UMBRA"
local Umbra    = "Umbra"
local SAND_CS  = "SCATTERED_SAND"
local Sand     = "Scattered Sand"

local function umbraDialog(tbl)
    return cq.npcSpawner(tbl, Umbra, Sand)
end

local entity =
{
    {
        id     = UMBRA_CS,
        name   = Umbra,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A1,
            main = 201, -- Death Scythe
            body = cexi.model.BLACK_CLOAK,
            hand = cexi.model.PLASTRON,
            legs = cexi.model.PLASTRON,
            feet = cexi.model.PLASTRON,
        }),
        area   = "RuLude_Gardens",
        pos    = { 21.031, 9.000, -48.088, 63 }, -- !pos 21.031 9.000 -48.088 243
        hidden = true,
    },
    {
        id     = SAND_CS,
        name   = Sand,
        marker = cq.MAIN_QUEST,
        area   = "RuLude_Gardens",
        pos    = { 21.031, 9.000, -48.088, 63 }, -- !pos 21.031 9.000 -48.088 243
        dialog =
        {
            DEFAULT = cq.NOTHING,
        },
    },
}

local step =
{
    {
        check     = cq.checks({ level = 65, bool = xi.settings.main.DYNAMIS_CAMPAIGN }),
        [SAND_CS] = cq.dialog({
            quest = info.name,
            event = umbraDialog({
                "Mysterious Figure : You have the look of one who has travelled beyond this world of mere mortals.",
                { delay = 2000 },
                { entity = Umbra, emote = xi.emote.THINK },
                " Through this land lie hidden trails that lead to an alternate realm of darkness called Dynamis.",
                { delay = 2000 },
                "Mysterious Figure : I'm in need of an extraordinarily rare substance from that realm.",
                { delay = 1000 },
                " If you should find any timeless sand in your adventures, bring it to me and I shall make it worth your time.",
                { entity = Umbra, emote = xi.emote.BOW },
                { delay = 3000 },
            }),
        }),
    },
    {
        [SAND_CS] =
        {
            onTrigger = cq.shop({
                var    = info.tally,
                title  = "Choose something... ({} sand)",
                dialog = { "A mysterious voice calls out to you..." },
                list   =
                {
                    { "F.Pouch (Head)",  6541,   5 },
                    { "F.Pouch (Body)",  6542,   5 },
                    { "F.Pouch (Hands)", 6543,   5 },
                    { "F.Pouch (Legs)",  6544,   5 },
                    { "F.Pouch (Feet)",  6545,   5 },
                    { "Mutsunokami",    21977,  50 },
                    { "Lost Sickle",    21820,  75 },
                    { "Morbol Mount",   10055, 100 },
                },
            }),

            onTrade   = cq.trade({
                required = info.required,
                tally    = info.tally,
                step     = false,
                accepted = umbraDialog({
                    "Umbra : Yes... %u timeless sand? Very good. That brings your total to %u.",
                    { entity = Umbra, emote = xi.emote.YES },
                    { delay = 2000 },
                }),
                declined = umbraDialog({
                    "Umbra : This isn't what I need.",
                    { entity = Umbra, emote = xi.emote.NO },
                    { delay = 2000 },
                }),
            }),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
