-----------------------------------
-- The Junk Collector
-----------------------------------
-- !setvar [CQ]JUNK_COLLECTOR 0
-- !pos -26.967 0.000 -48.796 245
-----------------------------------
require("modules/module_utils")
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cq_the_junk_collector")

local info =
{
    name     = "The Junk Collector",
    author   = "Loxley",
    var      = "[CQ]JUNK_COLLECTOR",
    tally    = "[CQ]JUNK_COLLECTED",
    points   = "[CQ]GOBLIN_SCRAPS",
}

local exchange =
{
    -- Digging
    [3509]  = { { cexi.rate.GUARANTEED, { gil = 4325, pts = 300 } } }, -- Heavy Metal
    [1236]  = { { cexi.rate.GUARANTEED, { gil =  600, pts = 100 } } }, -- Cactus Stems
    [2603]  = { { cexi.rate.GUARANTEED, { gil = 1500, pts = 100 } } }, -- Coin of Birth
    [2604]  = { { cexi.rate.GUARANTEED, { gil = 1500, pts = 100 } } }, -- Coin of Adv.
    [2605]  = { { cexi.rate.GUARANTEED, { gil = 1500, pts = 100 } } }, -- Coin of Glory
    [2606]  = { { cexi.rate.GUARANTEED, { gil = 1500, pts = 100 } } }, -- Coin of Decay
    [2607]  = { { cexi.rate.GUARANTEED, { gil = 1500, pts = 100 } } }, -- Coin of Ruin

    -- Ghelsba
    [530]   = { { cexi.rate.GUARANTEED, { gil =  250, pts =  25 } } }, -- Castle Floor Plans
    [1662]  = { { cexi.rate.GUARANTEED, { gil =  250, pts =  25 } } }, -- Cathedral Tapestry
    [2757]  = { { cexi.rate.GUARANTEED, { gil =  250, pts =  25 } } }, -- Orcish Armor Plate

    -- Palborough Mines
    [2758]  = { { cexi.rate.GUARANTEED, { gil =  150, pts =  15 } } }, -- Quadav Backscale

    -- Giddeus
    [16509] = { { cexi.rate.GUARANTEED, { gil =  200, pts =  20 } } }, -- Aspir Knife
    [12298] = { { cexi.rate.GUARANTEED, { gil =  200, pts =  20 } } }, -- Parana Shield
    [2759]  = { { cexi.rate.GUARANTEED, { gil =  150, pts =  15 } } }, -- Yagudo Caulk

    -- Testimonies
    [1426]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- warriors_testimony
    [1427]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- monks_testimony
    [1428]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- white_mages_testimony
    [1429]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- black_mages_testimony
    [1430]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- red_mages_testimony
    [1431]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- thiefs_testimony
    [1432]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- paladins_testimony
    [1433]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- dark_knights_testimony
    [1434]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- beastmasters_testimony
    [1435]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- bards_testimony
    [1436]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- rangers_testimony
    [1437]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- samurais_testimony
    [1438]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- ninjas_testimony
    [1439]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- dragoons_testimony
    [1440]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- summoners_testimony
    [2331]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- blue_mages_testimony
    [2332]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- corsairs_testimony
    [2333]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- puppetmasters_testimony
    [2556]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- dancers_testimony
    [2557]  = { { cexi.rate.GUARANTEED, { gil =  500, pts =  30 } } }, -- scholars_testimony
}

local exclude = set {
    -- Misc.
    28470, -- Provenance Ring
    513,   -- Linkshell
    514,   -- Pearlsack
    515,   -- Linkpearl

    -- Free Scrolls
    xi.item.SCROLL_OF_INSTANT_WARP,
    xi.item.SCROLL_OF_INSTANT_RERAISE,
    xi.item.SCROLL_OF_INSTANT_RETRACE,

    -- Relic Weapons
    xi.item.MANDAU,
    xi.item.MJOLLNIR,
    xi.item.SPHARAI,
    xi.item.EXCALIBUR,
    xi.item.GUTTLER,
    xi.item.GUNGNIR,
    xi.item.RAGNAROK,
    xi.item.GJALLARHORN,
    xi.item.BRAVURA,
    xi.item.AMANOMURAKUMO,
    xi.item.APOCALYPSE,
    xi.item.AEGIS,
    xi.item.KIKOKU,
    xi.item.CLAUSTRUM,
    xi.item.YOICHINOYUMI,
    xi.item.ANNIHILATOR,

    -- Mythic Weapons
    18990,
    18991,
    18992,
    18993,
    18994,
    18995,
    18996,
    18997,
    18998,
    18999,
    19000,
    19001,
    19002,
    19003,
    19004,
    19005,
    19006,
    19007,
    19008,

    -- Rare items
    16555, -- Ridill
    13566, -- Defending Ring
    17440, -- Kraken Club
    18852, -- Octave Club
}

local JUNKNIX = "JUNKNIX"
local entity  =
{
    {
        id     = JUNKNIX,
        name   = "Junknix",
        type   = xi.objType.NPC,
        look   = 491, -- Goblin Tinkerer
        area   = "Lower_Jeuno",
        pos    = { -26.967, 0.000, -48.796, 117 }, -- !pos -26.967 0.000 -48.796 245
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "What d'ya want?" },
        },
    },
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local step =
{
    {
        [JUNKNIX] = cq.dialog({
            name  = "Junknix",
            quest = info.name,
            event =
            {
                "Hey you! Looks like you're carrying quite a bit.",
                " I'm in the business of helping out struggling adventurers just like you!",
                "Bring me your assorted junk and I'll see what it's worth.",
                " What d'ya say?",
            },
        }),
    },
    {
        [JUNKNIX] =
        {
            onTrigger = cq.shop({
                var    = info.points,
                title  = "Wanna buy somethin? ({} scraps):",
                list   =
                {
                    { "Cotton Purse (Alex)",              5735,   400 },
                    { "Moat Carp Creel x4",   { { 5810,  4 } },   600 },
                    { "Darksteel Ore x12",    { {  645, 12 } },  1200 },
                    { "Orichalcum Ore x12",   { {  739, 12 } },  5000 },
                    { "Epic Lure",           xi.item.EPIC_LURE, 30000 },
                },
            }),

            onTrade   = cq.trade({
                quest    = info.name,
                music    = cexi.music.JEUNO,
                tally    = info.tally,
                name     = "Junknix",
                step     = false,
                exchange = exchange,
                exclude  = exclude,
                points   =
                {
                    var  = info.points,
                    name = "goblin scraps",
                },
                sellrate = 0.10,
                accepted =
                {
                    "What have we got here? Let's have a look...",
                    { delay = 200 },
                },
                declined =
                {
                    "I dunno what this is but I'm not interested."
                },
            }),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
