-----------------------------------
-- The Collection
-----------------------------------
-- !pos 39.222 3.900 -41.920 245
-- !setvar [CQ]COLLECTION 0
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cq_collection")

local info =
{
    name   = "The Collection",
    author = "Loxley",
    var    = "[CQ]COLLECTION",
}

local MYRIOS = "MYRIOS"
local entity =
{
    {
        id   = MYRIOS,
        name = "Myrios",
        type = xi.objType.NPC,
        look = cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.B4,
            head = 119, -- Magnifying Spectacles
            body = cexi.model.HARA_ATE,
            hand = cexi.model.HARA_ATE,
            legs = cexi.model.SHINOBI,
            feet = cexi.model.SHINOBI,
        }),
        area = "Lower_Jeuno",
        pos  = { 39.222, 3.900, -41.920, 215 }, -- !pos 39.222 3.900 -41.920 245
        dialog =
        {
            DEFAULT =
            {
                "Myrios : Huh... who are you?",
            },
        },
    },
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function pointsReward(varName, varValue, msg)
    return function(player)
        player:incrementCharVar(varName, varValue)
        player:sys(msg, player:getName(), varValue)
    end
end

local function unlockReward(varName, varValue, msg)
    return function(player)
        player:setCharVar(varName, varValue)
        player:sys(msg)
    end
end

local items =
{
    {
        "Promathia",
        {
            {
                name = "Sea Organs",
                item = unlockReward("[NPC]ULMORIA", 1, "You have gained access to the Ul'moria Efflux in Al'Taieu!"),
                pts  = 500,
                list =
                {
                    { "Phuabo Organ",       1784 },
                    { "H.Q. Phuabo Org.",   1852 },
                    { "Xzomit Organ",       1785 },
                    { "H.Q. Xzomit Org.",   1855 },
                    { "Aern Organ",         1786 },
                    { "H.Q. Aern Organ",    1900 },
                    { "Hpemde Organ",       1787 },
                    { "H.Q. Hpemde Org.",   1871 },
                    { "Euvhi Organ",        1818 },
                    { "H.Q. Euvhi Organ",   1899 },
                    { "Yovra Organ",        1788 },
                    { "Luminion Chip",      1819 },
                },
            },
        },
    },
    {
        "Armoury",
        {
            {
                name = "Skill Torques",
                item = xi.item.INCANTERS_TORQUE,
                pts  = 500,
                list =
                {
                    { "Elementium Trq. +1", 10917 },
                    { "Evasion Torque",     13148 },
                    { "Parrying Torque",    13149 },
                    { "Shield Torque",      13150 },
                    { "Guarding Torque",    13151 },
                    { "Divine Torque",      13152 },
                    { "Dark Torque",        13153 },
                    { "Enhancing Torque",   13154 },
                    { "Enfeebling Torque",  13155 },
                    { "Elemental Torque",   13156 },
                    { "Healing Torque",     13157 },
                    { "Summoning Torque",   13158 },
                    { "Ninjutsu Torque",    13159 },
                    { "String Torque",      13160 },
                    { "Wind Torque",        13161 },
                },
            },
        },
    },
    {
        "Garrison",
        {
            {
                name = "Beginner",
                item = pointsReward("[GARRISON]POINTS", 1000, "{} gains {} garrison points."),
                pts  = 100,
                list =
                {
                    { "Red Cryptex",        1528 },
                    { "Dst. Engraving",     1529 },
                    { "7-Knot Quipu",       1530 },
                    { "Galka Fang Sack",    1531 },

                    { "Jade Cryptex",       1532 },
                    { "Silver Engraving",   1533 },
                    { "Mithra Fang Sack",   1534 },
                    { "13-Knot Quipu",      1535 },

                    { "R. Leather Missive", 1538 },
                },
            },
            {
                name = "Advanced",
                item = pointsReward("[GARRISON]POINTS", 2000, "{} gains {} garrison points."),
                pts  = 500,
                list =
                {
                    { "T. Leather Missive", 1536 },
                    { "Hound Fang Sack",    1539 },
                    { "S. Leather Missive", 1542 },
                    { "B. Leather Missive", 1537 },

                    { "D. Leather Missive", 1540 },
                    { "C. Leather Missive", 1543 },
                    { "Bunny Fang Sack",    1541 },
                },
            },
        },
    },
    {
        "Gathering",
        {
            {
                name = "Logs I",
                item = { { 1021, 48 } }, -- Hatchet x48
                pts  = 100,
                list =
                {
                    { "Arrowwood Log",     688 },
                    { "Lauan Log",         689 },
                    { "Elm Log",           690 },
                    { "Maple Log",         691 },

                    { "Walnut Log",        693 },
                    { "Chestnut Log",      694 },
                    { "Willow Log",        695 },
                    { "Yew Log",           696 },
                },
            },
            {
                name = "Logs II",
                item = { { 1021, 99 } }, -- Hatchet x99
                pts  = 500,
                list =
                {
                    { "Holly Log",         697 },
                    { "Ash Log",           698 },
                    { "Oak Log",           699 },
                    { "Mahogany Log",      700 },

                    { "Rosewood Log",      701 },
                    { "Ebony Log",         702 },
                    { "Aquilaria Log",     731 },
                    { "Kapor Log",         732 },
                },
            },
            --[[
            {
                name = "Logs III",
                item = { { 1021, 99 } }, -- Hatchet x99 TODO: This needs a better reward
                pts  = 1000,
                list =
                {
                    { "Beech Log",         692 },
                    { "Divine Log",        722 },
                    { "Dogwood Log",       727 },
                    { "Bloodwood Log",     729 },

                    { "Lacquer Tree log", 1446 },
                    { "Lancewood Log",    1464 },
                    { "Teak Log",         2532 },
                    { "Jacaranda Log",    2534 },
                },
            },
            ]]
            {
                name = "Ore I",
                item = { { 605, 99 } }, -- Pickaxe x99
                pts  = 100,
                list =
                {
                    { "Copper Ore",        640 },
                    { "Tin Ore",           641 },
                    { "Zinc Ore",          642 },
                    { "Iron Ore",          643 },

                    { "Silver Ore",        736 },
                    { "Gold Ore",          737 },
                    { "Mythril Ore",       644 },
                    { "Darksteel Ore",     645 },
                },
            },
            {
                name = "Fiber I",
                item = { { 1020, 99 } }, -- Sickle x99
                pts  = 100,
                list =
                {
                    { "Moko Grass",        833 },
                    { "Saruta Cotton",     834 },
                    { "Flax Flower",       835 },
                    { "Red Moko Grass",   1845 },

                    { "Crawler Cocoon",    839 },
                    { "Mohbwa Grass",     2295 },
                    { "Spider Web",        838 },
                    { "Wamoura Cocoon",   2173 },
                },
            },
        },
    },
}

local lookup    = {}
local tradeable = {}

for categoryIndex, categoryInfo in pairs(items) do
    lookup[categoryInfo[1]] = {}

    for tierIndex, tierInfo in pairs(categoryInfo[2]) do
        lookup[categoryInfo[1]][tierInfo.name] =
        {
            categoryIndex = categoryIndex,
            tierIndex     = tierIndex,
            listComplete  = bit.lshift(1, #tierInfo.list) - 1
        }

        for index, itemInfo in pairs(tierInfo.list) do
            tradeable[itemInfo[2]] = { index - 1, itemInfo[1], categoryInfo[1], tierInfo.name }
        end
    end
end

local function getListVar(category, tier)
    return string.gsub(fmt("[CL]{}_{}", string.upper(category), string.upper(tier)), " ", "_")
end

local function itemList(player, npc, tier, category)
    local listVar = getListVar(category, tier[2].name)
    local listVal = player:getCharVar(listVar)

    if
        listVal > 0 and
        listVal == bit.lshift(1, #tier[2].list) - 1
    then
        cexi.util.dialog(player, { "Thanks to your help, this collection is already completed!" }, npc:getPacketName(), { npc = npc })
        return
    end

    local tbl   = { fmt("Here's everything I still need for {} ({}):", category, tier[2].name) }
    local delay = cexi.util.dialogDelay(tbl)
    cexi.util.dialog(player, tbl, npc:getPacketName(), { npc = npc })

    player:timer(delay, function()
        local total = 0

        for index, itemInfo in pairs(tier[2].list) do
            if utils.mask.getBit(listVal, index - 1) then
                player:fmt("\129\156 {}", itemInfo[1])
                total = total + 1
            else
                player:fmt("\129\155 {}", itemInfo[1])
            end
        end

        player:fmt(" ~ Progress: {}/{} ~", total, #tier[2].list)
    end)
end

local function tierList(player, npc, category)
    local options = {}

    for _, tierInfo in pairs(category[2]) do
        local listName = fmt("\129\155 {}", tierInfo.name)
        local listVar  = getListVar(category[1], tierInfo.name)
        local listVal  = player:getCharVar(listVar)

        if
            listVal > 0 and
            listVal == bit.lshift(1, #tierInfo.list) - 1
        then
            listName = fmt("\129\156 {}", tierInfo.name)
        end

        table.insert(options, {
            listName,
            tierInfo,
        })
    end

    cexi.util.simpleMenu(player, npc, options, function(playerArg, npcArg, tier)
        itemList(player, npc, tier, category[1])
    end, fmt("Select tier ({}):", category[1]))
end

local function categoryList(player, npc)
    npc:facePlayer(player, true)
    cexi.util.simpleMenu(player, npc, items, tierList, "Which list?:")
end

local function onTrigger(player, npc, tbl, var, step)
    categoryList(player, npc)
end

local function onTrade(player, npc, trade, entity, var, step)
    local lastSlot = trade:getSlotCount() - 1
    local complete = {}
    local storing  =
    {
        fmt("{} : Excellent. This is exactly what I need.", npc:getPacketName()),
    }

    -- Check if tradeable
    for i = 0, lastSlot do
        local itemID = trade:getItemId(i)

        if tradeable[itemID] == nil then
            player:fmt("You cannot store this item.")
            return
        end

        local itemQty = trade:getSlotQty(i)

        if itemQty > 1 then
            player:fmt("You cannot trade multiples of the same item.")
            return
        end
    end

    -- Check if already stored
    for i = 0, lastSlot do
        local itemID   = trade:getItemId(i)
        local itemQty  = trade:getSlotQty(i)

        local index    = tradeable[itemID][1]
        local itemName = tradeable[itemID][2]
        local category = tradeable[itemID][3]
        local tier     = tradeable[itemID][4]
        local varName  = getListVar(category, tier)
        local value    = player:getCharVar(varName)

        if utils.mask.getBit(value, index) then
            cexi.util.dialog(player, { fmt("Hey, I've already collected this {}. I don't need another one.", itemName) }, npc:getPacketName(), { npc = npc })
            return
        end
    end

    -- Store all items
    local curios = 0

    for i = 0, lastSlot do
        local itemID   = trade:getItemId(i)
        local itemQty  = trade:getSlotQty(i)

        local index    = tradeable[itemID][1]
        local itemName = tradeable[itemID][2]
        local category = tradeable[itemID][3]
        local tier     = tradeable[itemID][4]
        local varName  = getListVar(category, tier)
        local value    = player:getCharVar(varName)
        local updated  = utils.mask.setBit(value, index, true)

        player:setCharVar(varName, updated)
        table.insert(storing, fmt("You add {} to the collection ({} \129\168 {})", itemName, category, tier))

        if updated == lookup[category][tier].listComplete then
            local categoryIndex = lookup[category][tier].categoryIndex
            local tierIndex     = lookup[category][tier].tierIndex

            table.insert(complete, {
                message  = fmt("You have completed the {} ({}) collection!", category, tier),
                reward   = items[categoryIndex][2][tierIndex].item,
                firstVar = string.gsub(fmt("[CL]{}_{}", category, tier), " ", "_"),
                firstMsg = fmt("{} is the first player to complete the {} ({}) collection!", player:getName(), category, tier)
            })

            curios = curios + items[categoryIndex][2][tierIndex].pts
        end
    end

    -- Complete trade and show dialog
    player:tradeComplete()
    npc:facePlayer(player, true)

    for _, msg in pairs(storing) do
        player:fmt(msg)
    end

    if #complete > 0 then
        player:timer(1000, function()
            for _, msg in pairs(complete) do
                player:sys(msg.message)
                player:sys("{} gains {} curios.", player:getName(), curios)
                player:incrementCharVar("[CL]CURIOS", curios)

                if
                    type(msg.reward) == "table" or
                    type(msg.reward) == "number"
                then
                    npcUtil.giveItem(player, msg.reward)
                else
                    msg.reward(player)
                end

                cexi.crystal_warrior.announcement.worldFirst(player, msg.firstVar, msg.firstMsg, true)
            end
        end)
    end
end

local step =
{
    {
        [MYRIOS] = cq.menu({
            name    = "Myrios",
            title   = "What do you want?",
            options =
            {
                {
                    "Never seen you around here before...",
                },
                {
                    " ",
                    {
                        "Haha... Very good. So you know a thing or two.",
                        { emote = xi.emote.LAUGH },
                        " Maybe you could be helpful around here after all.",
                    },
                },
            },
        }),
    },
    {
        [MYRIOS] = cq.dialog({
            name    = "Myrios",
            event   =
            {
                "Oh, you actually want to help out? Haha...",
                { emote = xi.emote.YES },
                " I'm something of a collector and I'm always looking for new pieces.",
                "I have many different collections. If you bring me enough things that I need then... I'll can offer rewards you can't get anywhere else!",
                "So, what do you say?",
            },
        }),
    },
    {
        [MYRIOS] = cq.menu({
            quest   = info.name,
            name    = "Myrios",
            title   = "Ready to catch them all?",
            options =
            {
                {
                    "No thanks",
                },
                {
                    "I wanna be the very best!",
                    {
                        "Haha... I knew you'd come around!",
                        { emote = xi.emote.LAUGH },
                        " All right, check in with me whenever you want to see the list.",
                        { message = "You have unlocked the Collection system in Lower Jeuno!" },
                    },
                },
            },
        }),
    },
    {
        [MYRIOS] =
        {
            onTrigger = onTrigger,
            onTrade   = onTrade,
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
