-----------------------------------
-- Gobbie Travels (Lv15)
-----------------------------------
-- Steps
-----------------------------------
-- !setvar [CQ]GOBBIE_TRAVELS 0

-- Reward: Goblin Pie x1
-- Unlocks: Gobbie Travels
-----------------------------------
-- !setvar [CQ]GOBBIE_TRAVELS 2

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cq_gobbie_travels")

local info =
{
    name     = "Gobbie Travels",
    author   = "Loxley",
    var      = "[CQ]GOBBIE_TRAVELS",
    required = { 2740, 2741, 2742 },
    reward   =
    {
        item  = 4539, -- Goblin Pie
        after = function(player)
            player:printToPlayer("You have unlocked Portalix's services in Lower Jeuno!", xi.msg.channel.SYSTEM_3)
            return true
        end,
    },
}

local PORTALIX = "PORTALIX"
local entity   =
{
    {
        id     = PORTALIX,
        name   = "Portalix",
        type   = xi.objType.NPC,
        look    = 85,
        area   = "Lower_Jeuno",
        pos    = { -55.191, 5.900, -114.607, 237 }, -- !pos -55.191 5.900 -114.607 245
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "What d'ya want?" },
            START    =
            {
                "Hey, so you wanna sneak into beastie areas?",
                " With my super powerful gobbie magic I could take you straight there!",
                { delay = 1000 },
                "But... first I'm gonna need something from you..",
                " Bring a Speedspall Astrum, Speedspall Luna and Speedspall Lux, then we'll talk.",
            },

            REMINDER = { "Bring a Speedspall Astrum, Speedspall Luna and Speedspall Lux, then we'll talk." },
            FINISH   = { "Aha! This is the stuff! Well then, a promise is a promise." },
            PROMPT   = { "Where to, boss?" },
        },
    },
}

local areas =
{
    { "Castle Oztroja", { 752.631, -32.000,  -40.035, 129, 119 } }, -- !pos 752.631 -32.000  -40.035 119
    { "Beadeaux",       { 578.786,  25.000, -376.731, 126, 109 } }, -- !pos 578.786 25.000 -376.731 109
    { "Davoi",          { -239.556, -7.764, -591.281, 187, 104 } }, -- !pos -239.556 -7.764 -591.281 104
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function gotoLocation(player, location)
    player:injectActionPacket(player:getID(), 6, 600, 0, 0, 0, 0, 0)

    player:timer(2000, function(playerArg)
        playerArg:setPos(unpack(location))
    end)
end

local function confirmTele(player, npc, area)
    delaySendMenu(player, {
        title   = string.format("Travel to %s?", area[1]),
        options =
        {
            {
                "Not yet.",
                function()
                end,
            },
            {
                "Let's go!",
                function()
                    npc:facePlayer(player, true)
                    gotoLocation(player, area[2])
                end,
            },
        },
    })
end

local function teleMenu()
    return function(player, npc, tbl, var, step)
        player:printToPlayer(string.format("%s : Where to, boss?", npc:getPacketName()), xi.msg.channel.NS_SAY)
        cexi.util.simpleMenu(player, npc, areas, confirmTele, "Choose a location:")
    end
end

local step =
{
    {
        check      = cq.checks({ level = 10 }),
        [PORTALIX] = cq.talkStep("START", info.name),
    },
    {
        [PORTALIX] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("FINISH", "REMINDER", info.required, info.reward, info.name, cexi.music.JEUNO),
        },
    },
    {
        [PORTALIX] = teleMenu(),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
