-----------------------------------
-- Allied Incursion II (Crystal Warrior)
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_allied_incursion_ii")

local info =
{
    name      = "Allied Incursion II",
    author    = "Loxley",
    var       = "[INC]STEP",
    required  = xi.item.BEASTMAN_BANNER,
}

local tiers =
{
    {
        levelCap        = 20,
        bossLevel       = 28,
        mobsRequired    = 20,
        currencyAwarded = { 4, 7 },
    },
    {
        levelCap        = 30,
        bossLevel       = 38,
        bonusLevel      = 35,
        mobsRequired    = 20,
        currencyAwarded = { 3, 6 },
    },
    {
        levelCap        = 40,
        bossLevel       = 48,
        bonusLevel      = 45,
        mobsRequired    = 15,
        currencyAwarded = { 4, 7 },
    },
    {
        levelCap        = 50,
        bossLevel       = 58,
        bonusLevel      = 56,
        mobsRequired    = 15,
        currencyAwarded = { 8, 12 },
    },
}

local clusters =
{
    { cexi.rate.COMMON, xi.item.FIRE_CLUSTER      },
    { cexi.rate.COMMON, xi.item.ICE_CLUSTER       },
    { cexi.rate.COMMON, xi.item.WIND_CLUSTER      },
    { cexi.rate.COMMON, xi.item.EARTH_CLUSTER     },
    { cexi.rate.COMMON, xi.item.LIGHTNING_CLUSTER },
    { cexi.rate.COMMON, xi.item.WATER_CLUSTER     },
    { cexi.rate.COMMON, xi.item.LIGHT_CLUSTER     },
    { cexi.rate.COMMON, xi.item.DARK_CLUSTER      },
}

local battles        = {}
local DAVOI          = 1
local BEADEAUX       = 2
local CASTLE_OZTROJA = 3

-----------------------------------
-- Davoi (Allied Incursion)
-----------------------------------
battles[DAVOI] =
{
    area  = "Davoi", -- (J-8)
    zone  = xi.zone.DAVOI,
    pos   = { 166.800, 0.776, -136.945, 193 }, -- !pos 166.800, 0.776, -136.945 149
    exp   = 3500, -- Per boss
    scale = 15,
    size  = 6,
    merit = 4,
    mats  =
    {
        { cexi.rate.COMMON,   xi.item.ORCISH_CHAIN }, -- Orcish Chain     (15%)

        { cexi.rate.UNCOMMON,                  690 }, -- Elm Log          (10%)
        { cexi.rate.UNCOMMON,                  693 }, -- Walnut Log       (10%)
        { cexi.rate.UNCOMMON,                  694 }, -- Chestnut Log     (10%)
        { cexi.rate.UNCOMMON,                  695 }, -- Willow Log       (10%)
        { cexi.rate.UNCOMMON,                  698 }, -- Ash Log          (10%)

        { cexi.rate.UNCOMMON,                  699 }, -- Oak Log          (10%)
        { cexi.rate.UNCOMMON,                  700 }, -- Mahogany Log     (10%)
        { cexi.rate.UNCOMMON,                  701 }, -- Rosewood Log     (10%)
        { cexi.rate.UNCOMMON,                  702 }, -- Ebony Log        (10%)
        { cexi.rate.UNCOMMON,                  703 }, -- Petrified Log    (10%)

        { cexi.rate.COMMON,   xi.item.ORCISH_CHAIN }, -- Orcish Chain     (15%)

        { cexi.rate.UNCOMMON,                  852 }, -- Lizard Skin      (10%)
        { cexi.rate.UNCOMMON,                  853 }, -- Raptor Skin      (10%)
        { cexi.rate.UNCOMMON,                  858 }, -- Wolf Hide        (10%)
        { cexi.rate.UNCOMMON,                  859 }, -- Ram Skin         (10%)
        { cexi.rate.UNCOMMON,                  861 }, -- Tiger Hide       (10%)

        { cexi.rate.UNCOMMON,                  863 }, -- Coeurl Hide      (10%)
        { cexi.rate.UNCOMMON,                 1116 }, -- Manticore Hide   (10%)
        { cexi.rate.UNCOMMON,                 1591 }, -- H.Q. Coeurl Hide (10%)
        { cexi.rate.UNCOMMON,                 1628 }, -- Buffalo Hide     (10%)
        { cexi.rate.UNCOMMON,                 1640 }, -- Bugard Skin      (10%)
    },
    currency = xi.item.ORCISH_STEEL,
    extra    = xi.item.HUNTERS_SHAWL,
    bonus    =
    {
        {
            { cexi.rate.VERY_COMMON, xi.item.ORCISH_LEATHER }, -- 100%
        },
        {
            {                   760, 0                      },
            { cexi.rate.VERY_COMMON, xi.item.ORCISH_LEATHER }, -- 24%
        },
        {
            {                900, 0                         },
            { cexi.rate.UNCOMMON, xi.item.ILLUSIONISTS_GARB }, -- 10%
        },
    },
    phases   = {},
    required = info.item,
}

-----------------------------------
-- Davoi: Phase I
-----------------------------------
battles[DAVOI].phases[1] =
{
    cap  = tiers[1].levelCap,
    mobs =
    {
        "Orcish_Fighter",
        "Orcish_Serjeant",
        "Orcish_Cursemaker",
    },
    boss =
    {
        name     = "Orcish Marcher",
        base     = { 149, 8 }, -- Orcish_Serjeant
        pos      = { 307.913, 0.879, -27.173, 182 }, -- !pos 307.913, 0.879, -27.173 149
        desc     = "(K-7)",
        lv       = tiers[1].bossLevel,
        reqs     = tiers[1].mobsRequired,
        currency = tiers[1].currencyAwarded,
        loot     =
        {
            { cexi.rate.COMMON, 12441 }, -- Lizard Helm
            { cexi.rate.COMMON, 12697 }, -- Lizard Gloves
            { cexi.rate.COMMON, 12825 }, -- Lizard Trousers
            { cexi.rate.COMMON, 12953 }, -- Lizard Ledelsens
            { cexi.rate.RARE,   16853 }, -- Lizard Piercer
        },
    },
}

-----------------------------------
-- Davoi: Phase II
-----------------------------------
battles[DAVOI].phases[2] =
{
    cap  = tiers[2].levelCap,
    mobs =
    {
        "Orcish_Beastrider",
        "Orcish_Nightraider",
        "Orcish_Impaler",
        "Orcish_Brawler",
    },
    boss =
    {
        name     = "Orcish Spearman",
        base     = { 149, 11 }, -- Orcish_Impaler
        pos      = { 169.004, 2.691, -342.073, 224 }, -- !pos 169.004, 2.691, -342.073 149
        desc     = "(J-11)",
        lv       = tiers[2].bossLevel,
        reqs     = tiers[2].mobsRequired,
        currency = tiers[2].currencyAwarded,
        loot     =
        {
            { cexi.rate.COMMON, 16833 }, -- Bronze Spear
            { cexi.rate.COMMON, 16834 }, -- Brass Spear
            { cexi.rate.COMMON, 16835 }, -- Spear
            { cexi.rate.COMMON, 16845 }, -- Lance
            { cexi.rate.RARE,   16856 }, -- Obelisk
        },
    },
    bonus =
    {
        chest =
        {
            { 294.698, 3.890, -244.317, 185 }, -- (K-10) !pos 294.698 3.890 -244.317 149
            { 244.795, 4.000, -225.938,  57 }, -- (K-9)  !pos 244.795 4.000 -225.938 149
            { 237.530, 3.856, -252.610, 153 }, -- (J-10) !pos 237.530 3.856 -252.610 149
            { 257.105, 3.059, -304.737, 207 }, -- (K-10) !pos 257.105 3.059 -304.737 149
            { 288.720, 4.250, -221.834,  87 }, -- (K-9)  !pos 288.720 4.250 -221.834 149
        },
        mobs = { "War_Lizard", 5 },
        boss =
        {
            name = "Battle Lizard",
            base = { 149, 15 }, -- War_Lizard
            pos  = { 325.098, 3.638, -191.349, 213 }, -- (L-9) !pos 325.098 3.638 -191.349 149
            desc = "(L-9)",
            lv   = tiers[2].bonusLevel,
        },
    },
}

-----------------------------------
-- Davoi: Phase III
-----------------------------------
battles[DAVOI].phases[3] =
{
    cap  = tiers[3].levelCap,
    mobs =
    {
        "Orcish_Footsoldier",
        "Orcish_Bowshooter",
        "Orcish_Trooper",
        "Orcish_Gladiator",
    },
    boss =
    {
        name     = "Orcish Savager",
        base     = { 149, 20 }, -- Tigerbane_Bakdak
        pos      = { 12.968, 0.833, -268.397, 225 }, -- !pos 12.968 0.833 -268.397 149
        desc     = "(H-10)",
        lv       = tiers[3].bossLevel,
        reqs     = tiers[3].mobsRequired,
        currency = tiers[3].currencyAwarded,
        loot     =
        {
            { cexi.rate.COMMON, 16641 }, -- Brass Axe
            { cexi.rate.COMMON, 16642 }, -- Bone Axe
            { cexi.rate.COMMON, 16655 }, -- Rusty Pick
            { cexi.rate.COMMON, 16650 }, -- War Pick
            { cexi.rate.RARE,   16672 }, -- Tigerhunter
        },
    },
    bonus =
    {
        chest =
        {
            { 177.500, 4.140, -374.510, 161 }, -- (J-11) !pos 177.500 4.140 -374.510 149
            { 172.259, 3.573, -388.047, 218 }, -- (J-11) !pos 172.259 3.573 -388.047 149
            { 185.337, 1.830, -379.863, 214 }, -- (J-11) !pos 185.337 1.830 -379.863 149
            { 134.673, 3.604, -260.447, 254 }, -- (I-10) !pos 134.673 3.604 -260.447 149
            {  98.945, 2.958, -222.045, 218 }, -- (I-9)  !pos 98.945 2.958 -222.045 149
        },
        mobs = { "Morbol", 2 },
        boss =
        {
            name = "River Morbol",
            base = { 149, 38 }, -- Morbol
            pos  = { 141.493, 2.981, -218.036, 99 }, -- (I-9) !pos 141.493, 2.981, -218.036 149
            desc = "(I-9)",
            lv   = tiers[3].bonusLevel,
        },
    }
}

-----------------------------------
-- Davoi: Phase IV
-----------------------------------
battles[DAVOI].phases[4] =
{
    cap  = tiers[4].levelCap,
    mobs =
    {
        "Orcish_Veteran",
        "Orcish_Predator",
        "Orcish_Warchief",
        "Orcish_Zerker",
    },
    boss =
    {
        name     = "Orcish Watcher",
        base     = { 149, 31 }, -- Orcish_Zerker
        pos      = { 13.760, 3.834, -197.395, 85 }, -- !pos 13.760 3.834 -197.395 149
        desc     = "(H-9)",
        lv       = tiers[4].bossLevel,
        reqs     = tiers[4].mobsRequired,
        currency = tiers[4].currencyAwarded,
        loot     =
        {
            {              850, 12672                        }, -- Gauntlets
            { cexi.rate.COMMON, xi.item.AXEMASTERS_GAUNTLETS },
        },
    },
    bonus =
    {
        chest =
        {
            {  -67.998, 3.787, -255.777, 223 }, -- (G-10) !pos -67.998 3.787 -255.777 149
            {  -43.578, 4.000, -254.186,   0 }, -- (G-10) !pos -43.578 4.000 -254.186 149
            {  -26.955, 4.000, -239.186,  93 }, -- (G-9)  !pos -26.955 4.000 -239.186 149
            { -152.847, 3.886, -227.382, 146 }, -- (F-9)  !pos -152.847 3.886 -227.382 149
            {  -97.755, 3.500, -260.063, 180 }, -- (F-10) !pos -97.755 3.500 -260.063 149
        },
        mobs = { "Geezard", 5 },
        boss =
        {
            name  = "Orcish Warcat",
            base  = { 104, 16 }, -- Forest_Tiger
            pos   = { -186.550, -0.375, -301.263, 239 }, -- (E-10) !pos -186.550, -0.375, -301.263 149
            desc  = "(E-10)",
            lv    = tiers[4].bonusLevel,
            mount = { "Tiger", 1 },
        },
    },
}

-----------------------------------
-- Beadeaux (Allied Incursion)
-----------------------------------
battles[BEADEAUX] =
{
    area  = "Beadeaux",
    zone  = xi.zone.BEADEAUX,
    pos   = { -99.848, 0.500, 56.788, 194 }, -- !pos -99.848 0.500 56.788 147
    exp   = 3500, -- Per boss
    scale = 15,
    size  = 6,
    merit = 4,
    mats  =
    {
        { cexi.rate.COMMON,   xi.item.QUADAV_CHAIN }, -- Quadav Chain    (15%)

        { cexi.rate.UNCOMMON, 643                  }, -- Iron Ore        (10%)
        { cexi.rate.UNCOMMON, 645                  }, -- Darksteel Ore   (10%)
        { cexi.rate.UNCOMMON, 646                  }, -- Adaman Ore      (10%)
        { cexi.rate.UNCOMMON, 657                  }, -- Tama-Hagane     (10%)
        { cexi.rate.UNCOMMON, 1155                 }, -- Iron Sand       (10%)

        { cexi.rate.UNCOMMON, 1232                 }, -- Bronze Nugget   (10%)
        { cexi.rate.UNCOMMON, 1234                 }, -- Iron Nugget     (10%)
        { cexi.rate.UNCOMMON, 1235                 }, -- Steel Nugget    (10%)
        { cexi.rate.UNCOMMON, 1228                 }, -- Dst. Nugget     (10%)
        { cexi.rate.UNCOMMON, 1229                 }, -- Adaman Nugget   (10%)

        { cexi.rate.COMMON,   xi.item.QUADAV_CHAIN }, -- Quadav Chain    (15%)

        { cexi.rate.UNCOMMON, 644                  }, -- Mythril Ore     (10%)
        { cexi.rate.UNCOMMON, 678                  }, -- Aluminium Ore   (10%)
        { cexi.rate.UNCOMMON, 736                  }, -- Silver Ore      (10%)
        { cexi.rate.UNCOMMON, 737                  }, -- Gold Ore        (10%)
        { cexi.rate.UNCOMMON, 738                  }, -- Platinum Ore    (10%)

        { cexi.rate.UNCOMMON, 739                  }, -- Orichalcum Ore  (10%)
        { cexi.rate.UNCOMMON, 1225                 }, -- Gold Nugget     (10%)
        { cexi.rate.UNCOMMON, 1226                 }, -- Mythril Nugget  (10%)
        { cexi.rate.UNCOMMON, 1227                 }, -- Platinum Nugget (10%)
        { cexi.rate.UNCOMMON, 1233                 }, -- Silver Nugget   (10%)

    },
    currency = xi.item.QUADAV_BRASS,
    extra    = xi.item.CURATES_EARRING,
    bonus    =
    {
        {
            { cexi.rate.VERY_COMMON, xi.item.QUADAV_THREAD }, -- 100%
        },
        {
            {                   760, 0                     },
            { cexi.rate.VERY_COMMON, xi.item.QUADAV_THREAD }, -- 24%
        },
        {
            {                900, 0               },
            { cexi.rate.UNCOMMON, xi.item.REVENGE }, -- 10%
        },
    },
    phases   = {},
    required = info.item,
}

-----------------------------------
-- Beadeaux: Phase I
-----------------------------------
battles[BEADEAUX].phases[1] =
{
    cap  = tiers[1].levelCap,
    mobs =
    {
        "Copper_Quadav",
        "Brass_Quadav",
        "Old_Quadav",
    },
    boss =
    {
        name     = "Flint Quadav",
        base     = { 147, 1 }, -- Old_Quadav
        pos      = { -226.977, 24.000, 100.437, 0 }, -- !pos -226.977 24.000 100.437 147
        desc     = "(F-7) Map #2",
        lv       = tiers[1].bossLevel,
        reqs     = tiers[1].mobsRequired,
        currency = tiers[1].currencyAwarded,
        loot     =
        {
            { cexi.rate.COMMON, 12449 }, -- Brass Cap
            { cexi.rate.COMMON, 12705 }, -- Brass Mittens
            { cexi.rate.COMMON, 12833 }, -- Brass Subligar
            { cexi.rate.COMMON, 12961 }, -- Brass Leggings
            { cexi.rate.RARE,     768 }, -- Flint Stone
        },
    },
}

-----------------------------------
-- Beadeaux: Phase II
-----------------------------------
battles[BEADEAUX].phases[2] =
{
    cap  = tiers[2].levelCap,
    mobs =
    {
        "Silver_Quadav",
        "Garnet_Quadav",
        "Zircon_Quadav",
        "Bronze_Quadav",
    },
    boss =
    {
        name     = "Opal Quadav",
        base     = { 147, 8 }, -- Garnet_Quadav
        pos      = { -53.051, -2.113, -141.430, 38 }, -- !pos -53.051 -2.113 -141.430 147
        desc     = "(H-10) Map #1",
        lv       = tiers[2].bossLevel,
        reqs     = tiers[2].mobsRequired,
        currency = tiers[2].currencyAwarded,
        loot     =
        {
            { cexi.rate.COMMON, 17042 }, -- Bronze Hammer
            { cexi.rate.COMMON, 17043 }, -- Brass Hammer
            { cexi.rate.COMMON, 17044 }, -- Warhammer
            { cexi.rate.COMMON, 17045 }, -- Maul
            { cexi.rate.RARE,     796 }, -- Light Opal
        },
    },
    bonus =
    {
        chest =
        {
            { -225.005, 0.524,   -4.304, 231 }, -- (F-8)  !pos -225.005 0.524 -4.304 147
            { -183.378, 1.000,  -50.373,  69 }, -- (F-9)  !pos -183.378 1.000 -50.373 147
            { -146.434, 1.000,  -57.456,  65 }, -- (G-9)  !pos -146.434 1.000 -57.456 147
            { -141.243, 0.963, -127.516, 132 }, -- (G-10) !pos -141.243 0.963 -127.516 147
            { -225.310, 0.997, -103.871,   0 }, -- (F-9)  !pos -225.310 0.997 -103.871 147
        },
        mobs = { "Caterpillar", 5 },
        boss =
        {
            name = "Earthen Grub",
            base = { 147, 11 }, -- Caterpillar
            pos  = { -132.620, 24.000, 100.144, 127 }, -- (G-7) !pos 132.620 24.000 100.144 147
            desc = "(G-7) Map #2",
            lv   = tiers[2].bonusLevel,
        },
    },
}

-----------------------------------
-- Beadeaux: Phase III
-----------------------------------
battles[BEADEAUX].phases[3] =
{
    cap  = tiers[3].levelCap,
    mobs =
    {
        "Iron_Quadav",
        "Spinel_Quadav",
        "Emerald_Quadav",
        "Elder_Quadav",
    },
    boss =
    {
        name     = "Aged Quadav",
        base     = { 147, 19 }, -- Elder_Quadav
        pos      = { 284.953, -3.192, 118.260, 0 }, -- !pos 284.953 -3.192 118.260 147
        desc     = "(L-7) Map #1",
        lv       = tiers[3].bossLevel,
        reqs     = tiers[3].mobsRequired,
        currency = tiers[3].currencyAwarded,
        loot     =
        {
            { cexi.rate.COMMON, 17088 }, -- Ash Staff
            { cexi.rate.COMMON, 17089 }, -- Holly Staff
            { cexi.rate.COMMON, 17090 }, -- Elm Staff
            { cexi.rate.COMMON, 17091 }, -- Oak Staff
            { cexi.rate.COMMON, 12474 }, -- Wool Hat
        },
    },
    bonus =
    {
        chest =
        {
            {  12.286, -3.000, -176.663, 152 }, -- (I-10) !pos 12.286 -3.000 -176.663 147
            {  46.892, -3.000, -136.977, 151 }, -- (I-10) !pos 46.892 -3.000 -136.977 147
            {  15.737, -3.020,  -68.116,  93 }, -- (I-9)  !pos 15.737 -3.020 -68.116 147
            { -48.464, -2.206,  -95.842, 212 }, -- (H-9)  !pos -48.464 -2.206 -95.842 147
            { -41.630, -3.463,  -47.383,  47 }, -- (H-9)  !pos -41.630 -3.463 -47.383 147
        },
        mobs = { "Charging_Sheep", 2 },
        boss =
        {
            name = "Barraging sheep",
            base = { 147, 14 }, -- Charging_Sheep
            pos  = { -54.682, 1.000, -176.004, 117 }, -- (H-10) !pos -54.682 1.000 -176.004 147
            desc = "(H-10) Map #1",
            lv   = tiers[3].bonusLevel,
        },
    }
}

-----------------------------------
-- Beadeaux: Phase IV
-----------------------------------
battles[BEADEAUX].phases[4] =
{
    cap  = tiers[4].levelCap,
    mobs =
    {
        "Gold_Quadav",
        "Mythril_Quadav",
        "Steel_Quadav",
        "Topaz_Quadav",
    },
    boss =
    {
        name     = "Bismuth Quadav",
        base     = { 147, 27 }, -- Steel_Quadav
        pos      = { 169.431, -2.438, 69.083, 161 }, -- !pos 169.431 -2.438 69.083 147
        desc     = "(K-7) Map #1",
        lv       = tiers[4].bossLevel,
        reqs     = tiers[4].mobsRequired,
        currency = tiers[4].currencyAwarded,
        loot     =
        {
            {              850, 13570                  }, -- Ram Mantle
            { cexi.rate.COMMON, xi.item.BRUISERS_CLOAK },
        },
    },
    bonus =
    {
        chest =
        {
            { 226.689, -1.833,  80.191, 255 }, -- (K-7) !pos 226.689 -1.833 80.191 147
            { 212.334, -1.833, 111.037, 189 }, -- (K-7) !pos 212.334 -1.833 111.037 147
            { 198.237, -1.833,  92.501,  62 }, -- (K-7) !pos 198.237 -1.833 92.501 147
            { 217.830, -1.534,  51.076, 138 }, -- (K-7) !pos 217.830 -1.534 51.076 147
            { 200.970, -1.833,  27.093, 192 }, -- (K-8) !pos 200.970 -1.833 27.093 147
        },
        mobs = { "Broo", 5 },
        boss =
        {
            name  = "Bru",
            base  = { 147, 24 }, -- Broo
            pos   = { 222.870, 1.118, -16.080, 97 }, -- (K-8) !pos 222.870 1.118 -16.080 147
            desc  = "(K-8) Map #1",
            lv    = tiers[4].bonusLevel,
            mount = { "Ram", 5 },
        },
    },
}

-----------------------------------
-- Castle Oztroja (Allied Incursion)
-----------------------------------
battles[CASTLE_OZTROJA] =
{
    area  = "Castle_Oztroja",
    zone  = xi.zone.CASTLE_OZTROJA,
    pos   = { -136.043, 0.248, -105.970, 164 }, -- !pos -136.043 0.248 -105.970 151
    exp   = 3500, -- Per boss
    scale = 15,
    size  = 6,
    merit = 4,
    mats  =
    {
        { cexi.rate.COMMON,   xi.item.YAGUDO_CHAIN }, -- Yagudo Chain    (15%)

        { cexi.rate.UNCOMMON, 880                  }, -- Bone Chip       (10%)
        { cexi.rate.UNCOMMON, 884                  }, -- Blk. Tiger Fang (10%)
        { cexi.rate.UNCOMMON, 885                  }, -- Turtle Shell    (10%)
        { cexi.rate.UNCOMMON, 887                  }, -- Coral Fragment  (10%)
        { cexi.rate.UNCOMMON, 893                  }, -- Giant Femur     (10%)

        { cexi.rate.UNCOMMON, 894                  }, -- Beetle Jaw      (10%)
        { cexi.rate.UNCOMMON, 895                  }, -- Ram Horn        (10%)
        { cexi.rate.UNCOMMON, 896                  }, -- Scorpion Shell  (10%)
        { cexi.rate.UNCOMMON, 897                  }, -- Scorpion Claw   (10%)
        { cexi.rate.UNCOMMON, 889                  }, -- Beetle Shell    (10%)

        { cexi.rate.COMMON,   xi.item.YAGUDO_CHAIN }, -- Yagudo Chain    (15%)

        { cexi.rate.UNCOMMON, 816                  }, -- Silk Thread     (10%)
        { cexi.rate.UNCOMMON, 832                  }, -- Sheep Wool      (10%)
        { cexi.rate.UNCOMMON, 834                  }, -- Saruta Cotton   (10%)
        { cexi.rate.UNCOMMON, 835                  }, -- Flax Flower     (10%)
        { cexi.rate.UNCOMMON, 838                  }, -- Spider Web      (10%)

        { cexi.rate.UNCOMMON, 839                  }, -- Crawler Cocoon  (10%)
        { cexi.rate.UNCOMMON, 842                  }, -- Giant Bird Ftr. (10%)
        { cexi.rate.UNCOMMON, 843                  }, -- G. Bird Plume   (10%)
        { cexi.rate.UNCOMMON, 1163                 }, -- Manticore Hair  (10%)
        { cexi.rate.UNCOMMON, 1845                 }, -- Red Moko Grass  (10%)
    },
    currency = xi.item.YAGUDO_SILVER,
    extra    = xi.item.YOIYAMI,
    bonus    =
    {
        {
            { cexi.rate.VERY_COMMON, xi.item.YAGUDO_CLOTH }, -- 100%
        },
        {
            {                   760, 0                    },
            { cexi.rate.VERY_COMMON, xi.item.YAGUDO_CLOTH }, -- 24%
        },
        {
            {                900, 0                      },
            { cexi.rate.UNCOMMON, xi.item.CHAPLAINS_RING }, -- 10%
        },
    },
    phases   = {},
    required = info.item,
}

-----------------------------------
-- Castle Oztroja: Phase I
-----------------------------------
battles[CASTLE_OZTROJA].phases[1] =
{
    cap  = tiers[1].levelCap,
    mobs =
    {
        "Yagudo_Votary",
        "Yagudo_Priest",
        "Yagudo_Theologist",
    },
    boss =
    {
        name     = "Yagudo Bouncer",
        base     = { 151, 1 }, -- Yagudo_Votary
        pos      = { -24.264, 0.2500, -95.700, 32 }, -- !pos -24.264 0.2500 -95.700 151
        desc     = "(I-9) (Map #1)",
        lv       = tiers[1].bossLevel,
        reqs     = tiers[1].mobsRequired,
        currency = tiers[1].currencyAwarded,
        loot     =
        {
            { cexi.rate.COMMON, 12457 }, -- Cotton Hacimaki
            { cexi.rate.COMMON, 12713 }, -- Cotton Tekko
            { cexi.rate.COMMON, 12841 }, -- Cotton Sitabaki
            { cexi.rate.COMMON, 12969 }, -- Cotton Kyahan
            { cexi.rate.RARE,   16385 }, -- Cesti
        },
    },
}

-----------------------------------
-- Castle Oztroja: Phase II
-----------------------------------
battles[CASTLE_OZTROJA].phases[2] =
{
    cap  = tiers[2].levelCap,
    mobs =
    {
        "Yagudo_Herald",
        "Yagudo_Interrogator",
        "Yagudo_Oracle",
        "Yagudo_Drummer",
    },
    boss =
    {
        name     = "Yagudo Diviner",
        base     = { 151, 7 }, -- Yagudo_Oracle
        pos      = { -148.806, -15.935, -38.749, 58 }, -- !pos -148.806 -15.935 -38.749
        desc     = "(G-8) Map #2",
        lv       = tiers[2].bossLevel,
        reqs     = tiers[2].mobsRequired,
        currency = tiers[2].currencyAwarded,
        loot     =
        {
            { cexi.rate.COMMON, 4733 }, -- Scroll of Protectra
            { cexi.rate.COMMON, 4744 }, -- Scroll of Invisible
            { cexi.rate.COMMON, 4745 }, -- Scroll of Sneak
            { cexi.rate.COMMON, 4746 }, -- Scroll of Deodorize
            { cexi.rate.RARE,   4132 }, -- Hi-Ether
        },
    },
    bonus =
    {
        -- North Room
        chest =
        {
            { -171.763, -0.215, 127.562, 119 }, -- (I-8) !pos -171.763 -0.215 127.562
            { -191.549,  0.000, 188.096,  54 }, -- (I-7  !pos -191.549 0.000 188.096
            { -239.456,  0.000, 187.245,  47 }, -- (H-7) !pos -239.456 0.000 187.245
            { -268.129, -0.215, 152.686, 243 }, -- (H-8) !pos -268.129 -0.215 152.686
            { -209.878, -0.038,  88.011, 166 }, -- (H-8) !pos 209.878 -0.038 88.011
        },

        mobs = { "Meat_Maggot", 5 },

        -- South Room
        boss =
        {
            name  = "Herb Crawler",
            base  = { 151, 10 }, -- Meat_Maggot
            look  = 397, -- Habetrot
            pos   = { 113.259, -0.453, -174.120, 65 }, -- (I-8) !pos 113.259 -0.453 -174.120 151
            desc  = "(I-8) Map #5",
            lv    = tiers[2].bonusLevel,
            mount = { "Crawler", 7 },
        },
    },
}

-----------------------------------
-- Castle Oztroja: Phase III
-----------------------------------
battles[CASTLE_OZTROJA].phases[3] =
{
    cap  = tiers[3].levelCap,
    mobs =
    {
        "Yagudo_Conquistador",
        "Yagudo_Lutenist",
        "Yagudo_Prior",
        "Yagudo_Zealot",
    },
    boss =
    {
        name     = "Yagudo Whistler",
        base     = { 151, 23 }, -- Yagudo_Lutenist
        pos      = { -146.801, -39.865, -64.817, 220 }, -- !pos -146.801 -39.865 -64.817 151
        desc     = "(G-9) Map #3",
        lv       = tiers[3].bossLevel,
        reqs     = tiers[3].mobsRequired,
        currency = tiers[3].currencyAwarded,
        loot     =
        {
            { cexi.rate.COMMON,  5008 }, -- Scroll of Blade Madrigal
            { cexi.rate.COMMON,  5012 }, -- Scroll of Dragonfoe Mambo
            { cexi.rate.COMMON,  5071 }, -- Scroll of Foe Lullaby
            { cexi.rate.COMMON,  4984 }, -- Scroll of Horde Lullaby
            { cexi.rate.COMMON,  5070 }, -- Scroll of Magic Finale
            { cexi.rate.COMMON,  5020 }, -- Scroll of Gold Carpriccio
            { cexi.rate.COMMON,  4980 }, -- Scroll of Foe Requiem V
            { cexi.rate.COMMON, 17344 }, -- Cornette
            { cexi.rate.COMMON, 17345 }, -- Flute
            { cexi.rate.COMMON, 17347 }, -- Piccolo
            { cexi.rate.COMMON, 17353 }, -- Maple Harp
            { cexi.rate.COMMON, 17354 }, -- Harp
        },
    },
    bonus =
    {
        chest =
        {
            { -145.544, -16.077, -10.169,  51 }, -- (G-8) !pos -145.544 -16.077 -10.169
            {  -90.980, -16.085, -39.617, 188 }, -- (H-8) !pos -90.980 -16.085 -39.617
            {  -69.002, -16.029,  27.830,   0 }, -- (H-8) !pos -69.002 -16.029 27.830
            { -262.433, -20.000, -60.290, 254 }, -- (F-9) !pos -262.433 -20.000 -60.290
            { -145.113, -39.736, -16.430,  29 }, -- (G-8) !pos -145.113 -39.736 -16.430
        },
        mobs = { "Bulwark_Bat", 5 },
        boss =
        {
            name = "Bloodfang Bat",
            base = { 151, 18 }, -- Bulwark_Bat
            pos  = { -21.553, -15.750, 25.528, 104 }, -- (I-8) !pos -21.553 -15.750 25.528
            desc = "(I-8) Map #2",
            lv   = tiers[2].bonusLevel,
        },
    }
}

-----------------------------------
-- Castle Oztroja: Phase IV
-----------------------------------
battles[CASTLE_OZTROJA].phases[4] =
{
    cap  = tiers[4].levelCap,
    mobs =
    {
        "Yagudo_Chanter",
        "Yagudo_Abbot",
        "Yagudo_Sentinel",
        "Yagudo Inquisitor",
    },
    boss =
    {
        name     = "Yagudo Keeper",
        base     = { 151, 24 }, -- Yagudo_Sentinel
        pos      = { -16.871, -39.723, -137.458, 97 }, -- !pos -16.871 -39.723 -137.458 151
        desc     = "(I-11)",
        lv       = tiers[4].bossLevel,
        reqs     = tiers[4].mobsRequired,
        currency = tiers[4].currencyAwarded,
        loot     =
        {
            {              850, 12507                  }, -- Horn Hairpin
            { cexi.rate.COMMON, xi.item.HEROIC_HAIRPIN },
        },
    },
    bonus =
    {
        chest =
        {
            {  -50.334, -39.782,  -79.672, 127 }, -- (H-9) !pos -50.334 -39.782 -79.672
            {  -79.745, -39.782, -109.057, 189 }, -- (H-9) !pos -79.745 -39.782 -109.057
            { -107.671, -39.782, -107.637, 221 }, -- (H-9) !pos -107.671 -39.782 -107.637
            { -108.776, -39.782,  -80.034,   0 }, -- (H-9) !pos -108.776 -39.782 -80.034
            {  -81.417, -39.782,  -51.870,  62 }, -- (H-9) !pos -81.417 -39.782 -51.870
        },
        mobs = { "Yagudo Parasite", 5 },
        boss =
        {
            name = "Yagudo Sucker",
            base = { 151, 30 }, -- Yagudo_Parasite
            look = 277, -- Caedarva Leech
            pos  = { -52.918, -39.782, -52.472, 96 }, -- (H-9) !pos -52.918 -39.782 -52.472 151
            desc = "(H-9) (Map #3)",
            lv   = tiers[4].bonusLevel,
        },
    },
}

-----------------------------------
-- Steps
-----------------------------------
local entity = {}
local step   = {}

-----------------------------------
-- Entity Setup
-----------------------------------
local function createGenericEntities(battle, battleIndex)
    local entryEntityID = fmt("INC_{}", string.upper(battle.area))

    table.insert(entity, {
        id       = entryEntityID,
        name     = "Rallying Point",
        marker   = cq.MAIN_QUEST,
        area     = battle.area,
        pos      = battle.pos,
        dialog   =
        {
            DEFAULT = cq.NOTHING,
        },
    })

    table.insert(entity, {
        id       = entryEntityID .. "_FLAG",
        name     = "Incursion Flag",
        type     = xi.objType.NPC,
        look     = 817, -- Banner
        notarget = true,
        hidden   = true,
        area     = battle.area,
        pos      = battle.pos,
    })

    table.insert(entity, {
        id       = fmt("INCURSION_CHEST_{}", battleIndex),
        name     = "Incursion Chest",
        type     = xi.objType.NPC,
        look     = 968,
        area     = battle.area,
        pos      = { 1, 1, 1, 1 },
        hidden   = true,
        dialog   =
        {
            DEFAULT = cq.NOTHING,
        },
    })

    table.insert(entity, {
        id       = "ETHEREAL_SOURCE",
        name     = "Ethereal Source",
        type     = xi.objType.NPC,
        look     = 1525,
        area     = battle.area,
        pos      = { 1, 1, 1, 1 },
        hidden   = true,
        hidehp   = true,
        hidename = true,
        dialog   =
        {
            DEFAULT = cq.NOTHING,
        },
    })

    step[1][entryEntityID] =
    {
        onTrigger = function(player, npc)
            cexi.incursion.checkInstance(player, npc, battle)
        end,

        onTrade = function(player, npc, trade)
            cexi.incursion.beginInstance(player, npc, trade, battle, info.required)
        end,
    }
end

-----------------------------------
-- Regular Objectives
-----------------------------------
local function createRegularObjectives(battle, phase, phaseIndex)
    -----------------------------------
    -- Mob Objective
    -----------------------------------
    for mobIndex, mobName in pairs(phase.mobs) do
        cexi.util.ensureMob(battle.area, mobName)

        m:addOverride(fmt("xi.zones.{}.mobs.{}.onMobDeath", battle.area, mobName), function(mob, player, optParams)
            super(mob, player, optParams)
            cexi.incursion.defeatMob(player, battle, phase, phaseIndex)
        end)
    end

    -----------------------------------
    -- Boss Objective
    -----------------------------------
    local spawnerEntityID = fmt("INC_{}_P{}", string.upper(battle.area), phaseIndex)

    table.insert(entity, {
        id         = spawnerEntityID,
        name       = fmt("Incursion Point {}", phaseIndex),
        packetName = "Incursion Point",
        marker     = cq.MAIN_QUEST,
        area       = battle.area,
        pos        = phase.boss.pos,
        dialog     =
        {
            DEFAULT = cq.NOTHING,
        },
    })

    local bossEntityID = fmt("INC_{}_B{}", string.upper(battle.area), phaseIndex)

    local bossPool =
    {
        clusters,
        battle.mats,
        battle.mats,
    }

    if phase.boss.loot ~= nil then
        table.insert(bossPool, phase.boss.loot)
    end

    -- If extra zone loot is defined, roll it for each boss except the final one
    if
        battle.extra ~= nil and
        phaseIndex < #battle.phases
    then
        table.insert(bossPool, {
            {            950, 0            },
            { cexi.rate.RARE, battle.extra },
        })
    end

    table.insert(entity, {
        id          = bossEntityID,
        name        = phase.boss.name,
        type        = xi.objType.MOB,
        groupId     = phase.boss.base[2],
        groupZoneId = phase.boss.base[1],
        look        = phase.boss.look,
        flags       = phase.boss.flags or 1157,
        area        = battle.area,
        pos         = phase.boss.pos,
        level       = phase.boss.lv,
        pool        = bossPool,

        onMobFight  = function(mob, target)
            if mob:getLocalVar("SCALED") == 0 then
                if
                    target ~= nil and
                    target:isPC()
                then
                    local alliance = target:getAlliance()
                    mob:setMod(xi.mod.HPP, #alliance * battle.scale)
                    mob:updateHealth()
                    mob:setHP(mob:getMaxHP())
                    mob:setLocalVar("SCALED", 1)
                end
            end

            cexi.incursion.wsTrigger(mob, battle.currency)
        end,
    })

    step[1][spawnerEntityID] = cq.menu({
        title        = "Are you ready?",
        spawn        = { bossEntityID },
        levelCap     = phase.boss.cap or phase.cap,
        raiseAllowed = true,
        check        = cq.checks(cexi.incursion.getBossChecks(battle, phase, phaseIndex)),
        default      = cexi.incursion.getBossSpawnerRequirements(phase, phaseIndex),
        options      = cq.spawnerOptions(),
    })

    step[1][bossEntityID] = function(mob, player, entity, var, step, entities, check)
        cq.respawnSpawner(player, entities, spawnerEntityID)
        cexi.incursion.defeatBoss(mob, player, battle, phase, phaseIndex)
    end

    step[1]["ETHEREAL_SOURCE"] = function(player, npc)
        cexi.incursion.etherealSource(player, npc)
    end
end

-----------------------------------
-- Bonus Objectives
-----------------------------------
local function createBonusObjectives(battle, battleIndex, phase, phaseIndex)
    -----------------------------------
    -- Bonus Chest
    -----------------------------------
    step[1][fmt("INCURSION_CHEST_{}", battleIndex)] = function(player, npc)
        cexi.incursion.openBonusChest(player, npc, battle)
    end

    -----------------------------------
    -- Bonus Mobs
    -----------------------------------
    cexi.util.ensureMob(battle.area, phase.bonus.mobs[1])

    m:addOverride(fmt("xi.zones.{}.mobs.{}.onMobDeath", battle.area, phase.bonus.mobs[1]), function(mob, player, optParams)
        super(mob, player, optParams)
        cexi.incursion.defeatBonusMob(mob, player, battle, phase, phaseIndex)
    end)

    -----------------------------------
    -- Bonus Boss
    -----------------------------------
    local bossEntityID = fmt("INC_{}_BB{}", string.upper(battle.area), phaseIndex)

    local bossPool =
    {
        battle.mats,
        battle.mats,
    }

    table.insert(entity, {
        id          = bossEntityID,
        name        = phase.bonus.boss.name,
        type        = xi.objType.MOB,
        groupId     = phase.bonus.boss.base[2],
        groupZoneId = phase.bonus.boss.base[1],
        look        = phase.bonus.boss.look,
        flags       = phase.bonus.boss.flags or 1157,
        area        = battle.area,
        pos         = phase.bonus.boss.pos,
        level       = phase.bonus.boss.lv,
        pool        = battle.bonus,

        onMobFight  = function(mob, target)
            if mob:getLocalVar("SCALED") == 0 then
                if
                    target ~= nil and
                    target:isPC()
                then
                    local alliance = target:getAlliance()
                    mob:setMod(xi.mod.HPP, #alliance * battle.scale)
                    mob:updateHealth()
                    mob:setHP(mob:getMaxHP())
                    mob:setLocalVar("SCALED", 1)
                end
            end

            cexi.incursion.wsTrigger(mob, battle.currency)
        end,
    })

    local spawnerEntityID = fmt("INC_{}_PB{}", string.upper(battle.area), phaseIndex)

    table.insert(entity, {
        id         = spawnerEntityID,
        name       = fmt("Incursion Bonus {}", phaseIndex),
        packetName = "Incursion Point",
        marker     = cq.MAIN_QUEST,
        area       = battle.area,
        pos        = phase.bonus.boss.pos,
        dialog     =
        {
            DEFAULT = cq.NOTHING,
        },
    })

    step[1][spawnerEntityID] = cq.menu({
        title        = "Are you ready?",
        spawn        = { bossEntityID },
        levelCap     = phase.boss.cap or phase.cap,
        raiseAllowed = true,
        check        = cq.checks(cexi.incursion.getBonusChecks(battle, phaseIndex)),
        setVarAll    = cexi.incursion.getBonusVarReset,
        default      = cexi.incursion.getBonusSpawnerRequirements(phase, phaseIndex),
        options      = cq.spawnerOptions(),
    })

    step[1][bossEntityID] = function(mob, player, entity, var, step, entities, check)
        cq.respawnSpawner(player, entities, spawnerEntityID)
        cexi.incursion.defeatBonusBoss(mob, player, battle, phase, phaseIndex)
    end
end

-----------------------------------
-- Allied Incursion Battles
-----------------------------------
for battleIndex, battle in pairs(battles) do
    -----------------------------------
    -- Reconnecting
    -----------------------------------
    m:addOverride(fmt("xi.zones.{}.Zone.onZoneIn", battle.area), function(player, prevZone)
        cexi.incursion.recoverSession(player, prevZone, super, battle)
    end)

    -----------------------------------
    -- Create entities and objectives
    -----------------------------------
    if step[1] == nil then
        step[1] = {}
    end

    createGenericEntities(battle, battleIndex)

    if battle.phases ~= nil then
        for phaseIndex, phase in pairs(battle.phases) do
            createRegularObjectives(battle, phase, phaseIndex)

            if
                phase ~= nil and
                phase.bonus ~= nil
            then
                createBonusObjectives(battle, battleIndex, phase, phaseIndex)
            end
        end
    end
end

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
