-----------------------------------
-- Allied Incursion (Crystal Warrior)
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_allied_incursion")

local info =
{
    name      = "Allied Incursion",
    author    = "Loxley",
    var       = "[INC]STEP",
    required  = xi.item.BEASTMAN_BANNER,
}

local tiers =
{
    {
        levelCap        = 8,
        bossLevel       = 11,
        mobsRequired    = 20,
        currencyAwarded = { 2, 5 },
    },
    {
        levelCap        = 10,
        bossLevel       = 15,
        bonusLevel      = 13,
        mobsRequired    = 20,
        currencyAwarded = { 3, 6 },
    },
    {
        levelCap        = 12,
        bossLevel       = 19,
        bonusLevel      = 18,
        mobsRequired    = 15,
        currencyAwarded = { 4, 7 },
    },
    {
        levelCap        = 16,
        bossLevel       = 24,
        bonusLevel      = 22,
        mobsRequired    = 15,
        currencyAwarded = { 8, 12 },
    },
}

local battles          = {}
local FORT_GHELSBA     = 1
local PALBOROUGH_MINES = 2
local GIDDEUS          = 3

-----------------------------------
-- Fort Ghelsba (Allied Incursion)
-----------------------------------
battles[FORT_GHELSBA] =
{
    area  = "Fort_Ghelsba", -- (F-8)
    zone  = xi.zone.FORT_GHELSBA,
    pos   = { -142.947, -20.275, 32.396, 45 }, -- !pos -142.947 -20.275 32.396 141
    exp   = 2500, -- Per boss
    scale = 20,
    size  = 6,
    merit = 4,
    mats  =
    {
        { cexi.rate.VERY_COMMON, xi.item.ORCISH_LEATHER }, -- Orcish Leather (24%)
        { cexi.rate.UNCOMMON,    689                    }, -- Lauan Log      (10%)
        { cexi.rate.UNCOMMON,    688                    }, -- Arrowwood Log  (10%)
        { cexi.rate.UNCOMMON,    696                    }, -- Yew Log        (10%)
        { cexi.rate.UNCOMMON,    697                    }, -- Holly Log      (10%)
        { cexi.rate.UNCOMMON,    691                    }, -- Maple Log      (10%)
        { cexi.rate.RARE,        694                    }, -- Chestnut Log   ( 5%)
        { cexi.rate.RARE,        690                    }, -- Elm Log        ( 5%)
        { cexi.rate.VERY_RARE,   700                    }, -- Mahogany Log   ( 1%)

        { cexi.rate.VERY_COMMON, xi.item.ORCISH_LEATHER }, -- Orcish Leather (24%)
        { cexi.rate.UNCOMMON,    505                    }, -- Sheepskin      (10%)
        { cexi.rate.UNCOMMON,    852                    }, -- Lizard Skin    (10%)
        { cexi.rate.UNCOMMON,    856                    }, -- Rabbit Hide    (10%)
        { cexi.rate.UNCOMMON,    859                    }, -- Ram Skin       (10%)
        { cexi.rate.UNCOMMON,    861                    }, -- Tiger Hide     (10%)
        { cexi.rate.RARE,        863                    }, -- Coeurl Hide    ( 5%)
        { cexi.rate.VERY_RARE,   853                    }, -- Raptor Skin    ( 1%)
    },
    currency = xi.item.ORCISH_STEEL,
    extra    = xi.item.TRIBAL_EARRING,
    bonus    =
    {
        {
            { cexi.rate.VERY_COMMON, xi.item.ORCISH_LEATHER }, -- 100%
        },
        {
            {                   760, 0                      },
            { cexi.rate.VERY_COMMON, xi.item.ORCISH_LEATHER }, -- 24%
        },
        {
            {                900, 0                   },
            { cexi.rate.UNCOMMON, xi.item.DRUIDS_ROBE }, -- 10%
        },
    },
    weapons  =
    {
        { cexi.rate.COMMON, xi.item.WORN_KNUCKLES },
        { cexi.rate.COMMON, xi.item.WORN_SWORD    },
        { cexi.rate.COMMON, xi.item.WORN_AXE      },
        { cexi.rate.COMMON, xi.item.WORN_CHOPPER  },
        { cexi.rate.COMMON, xi.item.WORN_LANCE    },
        { cexi.rate.COMMON, xi.item.WORN_SHIELD   },
    },
    phases = {},
}

-----------------------------------
-- Fort Ghelsba: Phase I
-----------------------------------
battles[FORT_GHELSBA].phases[1] =
{
    cap  = tiers[1].levelCap,
    mobs =
    {
        "Orcish_Grappler",
        "Orcish_Mesmerizer",
        "Orcish_Fodder",
    },
    boss =
    {
        name     = "Orcish Martial",
        base     = { 141, 5 }, -- Orcish_Fodder
        pos      = { -16.781, -24.000, 146.674, 70 }, -- !pos -16.781 -24.000 146.674 141
        desc     = "(G-6)",
        lv       = tiers[1].bossLevel,
        reqs     = tiers[1].mobsRequired,
        currency = tiers[1].currencyAwarded,
        loot     =
        {
            { cexi.rate.VERY_COMMON, 16535 }, -- Bronze Sword
            { cexi.rate.COMMON,      16530 }, -- Xiphos
            { cexi.rate.UNCOMMON,    16565 }, -- Spatha
            { cexi.rate.RARE,        16512 }, -- Bilbo
        },
    },
}
-----------------------------------
-- Fort Ghelsba: Phase II
-----------------------------------
battles[FORT_GHELSBA].phases[2] =
{
    cap  = tiers[2].levelCap,
    mobs =
    {
        "Orcish_Grappler",
        "Orcish_Mesmerizer",
        "Orcish_Fodder",
    },
    boss =
    {
        name     = "Orcish Axesmith",
        base     = { 141, 11 }, -- Hundredscar_Hajwaj
        pos      = { 132.097, -45.000, 105.530, 198 }, -- !pos 132.097 -45.000 105.530 141
        desc     = "(I-7)",
        lv       = tiers[2].bossLevel,
        reqs     = tiers[2].mobsRequired,
        currency = tiers[2].currencyAwarded,
        loot     =
        {
            { cexi.rate.VERY_COMMON, 16640 }, -- Bronze Axe
            { cexi.rate.COMMON,      16641 }, -- Brass Axe
            { cexi.rate.UNCOMMON,    16642 }, -- Bone Axe
            { cexi.rate.RARE,        16705 }, -- Greataxe
        },
    },
    bonus =
    {
        chest =
        {
            { 153.923, -32.000, 141.490, 194 }, -- (I-6) !pos 153.923 -32.000 141.490 141
            { 173.356, -44.868, 102.043, 147 }, -- (J-7) !pos 173.356 -44.868 102.043 141
            {  32.025, -52.013, 109.775,  24 }, -- (H-7) !pos 32.025 -52.013 109.775 141
            { -23.352, -28.103, 105.706, 252 }, -- (G-7) !pos -23.352 -28.103 105.706 141
            { -68.556, -24.029, 135.590, 252 }, -- (G-6) !pos -68.556 -24.029 135.590 141
        },
        mobs = { "Orcish_Flamethrower", 2 },
        boss =
        {
            name = "Orcish Torcher",
            base = { 141, 10 }, -- Orcish_Flamethrower
            pos  = { 1.771, -28.000, -58.708, 147 }, -- (H-9) !pos 1.771 -28.000 -58.708 141
            desc = "(H-9)",
            lv   = tiers[2].bonusLevel,
        },
    },
}


-----------------------------------
-- Fort Ghelsba: Phase III
-----------------------------------
battles[FORT_GHELSBA].phases[3] =
{
    cap  = tiers[3].levelCap,
    mobs =
    {
        "Orcish_Grunt",
        "Orcish_Neckchopper",
        "Orcish_Stonechucker",
    },
    boss =
    {
        name     = "Orcish Sieger",
        base     = { 141, 10 }, -- Orcish_Flamethrower
        pos      = { 79.664, -52.000, -61.127, 128 }, -- !pos 79.664 -52.000 -61.127 141
        desc     = "(I-9)",
        lv       = tiers[3].bossLevel,
        reqs     = tiers[3].mobsRequired,
        currency = tiers[3].currencyAwarded,
        loot     =
        {
            { cexi.rate.VERY_COMMON, 17152 }, -- Shortbow
            { cexi.rate.COMMON,      17160 }, -- Longbow
            { cexi.rate.UNCOMMON,    17217 }, -- Crossbow
            { cexi.rate.RARE,        17161 }, -- Power Bow
        },
    },
    bonus =
    {
        chest =
        {
            {  44.262, -52.000,  116.866,  31 }, -- (H-7) !pos 44.262 -52.000 116.866 141
            { 127.286, -44.341, -105.111,  47 }, -- (I-9) !pos 127.286 -44.341 -105.111 141
            { 103.040, -44.097, -144.091, 191 }, -- (I-10) !pos 103.040 -44.097 -144.091 141
            {  24.025, -44.000, -143.506, 193 }, -- (H-10) !pos 24.025 -44.000 -143.506 141
            {  16.981, -52.000,  -85.884,   0 }, -- (H-9) !pos 16.981 -52.000 -85.884 141
        },
        mobs = { "Sentry_Lizard", 5 },
        boss =
        {
            name = "Sentinel Lizard",
            base = { 141, 16 }, -- Sentry_Lizard
            pos  = { 149.300, -44.000, -121.869, 112 }, -- (I-10) !pos 149.300 -44.000 -121.869 141
            desc = "(I-10)",
            lv   = tiers[3].bonusLevel,
        },
    },
}

-----------------------------------
-- Fort Ghelsba: Phase IV
-----------------------------------
battles[FORT_GHELSBA].phases[4] =
{
    cap  = tiers[4].levelCap,
    mobs =
    {
        "Orcish_Grunt",
        "Orcish_Neckchopper",
        "Orcish_Stonechucker",
    },
    boss =
    {
        name     = "Orcish Ironlord",
        base     = { 140, 24 }, -- Thousandarm_Deshglesh
        pos      = { 138.205, -84.000, 21.511, 247 }, -- !pos 138.205 -84.000 21.511 141
        desc     = "(I-8)",
        lv       = tiers[4].bossLevel,
        reqs     = tiers[4].mobsRequired,
        currency = tiers[4].currencyAwarded,
        loot     =
        {
            {              850, 16832                  }, -- Harpoon
            { cexi.rate.COMMON, xi.item.ORCISH_AXEGRIP },
        },
    },
    bonus =
    {
        chest =
        {
            {  58.158, -60.000,  37.019,  17 }, -- (H-8) !pos 58.158 -60.000 37.019 141
            {  69.881, -60.057,  -8.105, 199 }, -- (H-8) !pos 69.881 -60.057 -8.105 141
            { 125.494, -60.000, -26.627, 131 }, -- (I-8) !pos 125.494 -60.000 -26.627 141
            {  93.519, -64.121, -48.214, 244 }, -- (I-9) !pos 93.519 -64.121 -48.214 141
            { 177.725, -84.119,  47.511,  58 }, -- (J-7) !pos 177.725 -84.119 47.511 141
        },
        mobs = { "Sentry_Lizard", 5 },
        boss =
        {
            name = "Bronze Bat",
            base = { 142, 6 }, -- Stealth_Bat
            pos  = { 64.016, -61.584, 19.874, 0 }, -- (H-8) !pos 64.016 -61.584 19.874 141
            desc = "(H-8)",
            lv   = tiers[4].bonusLevel,
        },
    },
}

-----------------------------------
-----------------------------------
-----------------------------------

-----------------------------------
-- Palborough Mines (Allied Incursion)
-----------------------------------
battles[PALBOROUGH_MINES] =
{
    area  = "Palborough_Mines", -- (I-8)
    zone  = xi.zone.PALBOROUGH_MINES,
    pos   = { 201.968, 0.193, 100.398, 246 }, -- !pos 201.968 0.193 100.398 143
    exp   = 2500, -- Per boss
    scale = 20,
    size  = 6,
    merit = 4,
    mats  =
    {
        { cexi.rate.VERY_COMMON, xi.item.QUADAV_THREAD }, -- Quadav Thread  (24%)
        { cexi.rate.UNCOMMON,    640                   }, -- Copper Ore     (10%)
        { cexi.rate.UNCOMMON,    641                   }, -- Tin Ore        (10%)
        { cexi.rate.UNCOMMON,    643                   }, -- Iron Ore       (10%)
        { cexi.rate.UNCOMMON,    645                   }, -- Darksteel Ore  (10%)
        { cexi.rate.UNCOMMON,   1230                   }, -- Copper Nugget  (10%)
        { cexi.rate.RARE,       1232                   }, -- Bronze Nugget  ( 5%)
        { cexi.rate.RARE,       1234                   }, -- Iron Nugget    ( 5%)
        { cexi.rate.VERY_RARE,   657                   }, -- Tama-Hagane    ( 1%)

        { cexi.rate.VERY_COMMON, xi.item.QUADAV_THREAD }, -- Quadav Thread (24%)
        { cexi.rate.UNCOMMON,    642                   }, -- Zinc Ore      (10%)
        { cexi.rate.UNCOMMON,    736                   }, -- Silver Ore    (10%)
        { cexi.rate.UNCOMMON,    768                   }, -- Flint Stone   (10%)
        { cexi.rate.UNCOMMON,    644                   }, -- Mythril Ore   (10%)
        { cexi.rate.UNCOMMON,    737                   }, -- Gold Ore      (10%)
        { cexi.rate.RARE,        678                   }, -- Aluminium Ore ( 5%)
        { cexi.rate.VERY_RARE,   738                   }, -- Platinum Ore  ( 1%)
    },
    currency = xi.item.QUADAV_BRASS,
    extra    = xi.item.TERRAPIN_TRAITOR,
    bonus    =
    {
        {
            { cexi.rate.VERY_COMMON, xi.item.QUADAV_THREAD }, -- 100%
        },
        {
            {                   760, 0                     },
            { cexi.rate.VERY_COMMON, xi.item.QUADAV_THREAD }, -- 24%
        },
        {
            {                900, 0                          },
            { cexi.rate.UNCOMMON, xi.item.COARSE_BREASTPLATE }, -- 10%
        },
    },
    weapons  =
    {
        { cexi.rate.COMMON, xi.item.WORN_RAPIER },
        { cexi.rate.COMMON, xi.item.WORN_BLADE  },
        { cexi.rate.COMMON, xi.item.WORN_SCYTHE },
        { cexi.rate.COMMON, xi.item.WORN_HAMMER },
        { cexi.rate.COMMON, xi.item.WORN_STAFF  },
        { cexi.rate.COMMON, xi.item.WORN_MUSKET },
    },
    phases = {},
}


-----------------------------------
-- Palborough Mines: Phase I
-----------------------------------
battles[PALBOROUGH_MINES].phases[1] =
{
    cap  = tiers[1].levelCap,
    mobs =
    {
        "Young_Quadav",
        "Amber_Quadav",
        "Amethyst_Quadav",
    },
    boss =
    {
        name     = "Granite Quadav",
        base     = { 143, 10}, -- QuVho_Deathhurler
        pos      = { 298.699, -15.919, 201.542, 198 }, -- !pos 298.699 -15.919 201.542 143
        desc     = "(J-6) (Map #2)",
        lv       = tiers[1].bossLevel,
        reqs     = tiers[1].mobsRequired,
        currency = tiers[1].currencyAwarded,
        loot     =
        {
            { cexi.rate.VERY_COMMON, 17024 }, -- Ash Club
            { cexi.rate.COMMON,      17034 }, -- Bronze Mace
            { cexi.rate.UNCOMMON,    17081 }, -- Brass Rod
            { cexi.rate.RARE,        17025 }, -- Chestnut Club
        },
    },
}

-----------------------------------
-- Palborough Mines: Phase II
-----------------------------------
battles[PALBOROUGH_MINES].phases[2] =
{
    cap  = tiers[2].levelCap,
    mobs =
    {
        "Greater_Quadav",
        "Veteran_Quadav",
        "Onyx_Quadav",
    },
    boss =
    {
        name     = "Quartz Quadav",
        base     = { 147, 12 }, -- DaDha_Hundredmask
        pos      = { 217.362, -15.891, 68.384, 49 }, -- !pos 217.362 -15.891 68.384 143
        desc     = "(I-8) (Map #2)",
        lv       = tiers[2].bossLevel,
        reqs     = tiers[2].mobsRequired,
        currency = tiers[2].currencyAwarded,
        loot     =
        {
            { cexi.rate.VERY_COMMON, 16768 }, -- Bronze Zaghnal
            { cexi.rate.COMMON,      16465 }, -- Bronze Knife
            { cexi.rate.UNCOMMON,    17089 }, -- Holly Staff
            { cexi.rate.RARE,        17257 }, -- Bandit's Gun
        },
    },
    bonus =
    {
        chest =
        {
            { 148.035, -17.391, 244.555, 234 }, -- (H-6) !pos 148.035 -17.391 244.555
            { 258.691, -16.150, 231.217,  73 }, -- (J-6) !pos 258.691 -16.150 231.217
            { 311.228, -16.317, 183.268,  72 }, -- (J-7) !pos 311.228 -16.317 183.268
            { 289.643, -15.535, 103.106,  74 }, -- (J-8) !pos 289.643 -15.535 103.106
            { 309.427, -16.052,  66.672,  99 }, -- (J-8) !pos 309.427 -16.052 66.672
        },
        mobs = { "Pit_Hare", 5 },
        boss =
        {
            name = "Death Hare",
            base = { 143, 8 }, -- Pit Hare
            pos  = { 178.908, -15.936, 204.535, 173 }, -- !pos 178.908 -15.936 204.535 143
            desc = "(I-6) (Map #2)",
            lv   = tiers[2].bonusLevel,
        }
    },
}

-----------------------------------
-- Palborough Mines: Phase III
-----------------------------------
battles[PALBOROUGH_MINES].phases[3] =
{
    cap  = tiers[3].levelCap,
    mobs =
    {
        "Greater_Quadav",
        "Veteran_Quadav",
        "Onyx_Quadav",
    },
    boss =
    {
        name     = "Obsidian Quadav",
        base     = { 147, 18 }, -- ZoKhu_Blackcloud
        pos      = { 242.384, -31.767, 60.075, 253 }, -- !pos 242.384, -31.767, 60.075 143
        desc     = "(J-8) (Map #3)",
        lv       = tiers[3].bossLevel,
        reqs     = tiers[3].mobsRequired,
        currency = tiers[3].currencyAwarded,
        loot     =
        {
            { cexi.rate.VERY_COMMON,  4299 }, -- Orange Au Lait
            { cexi.rate.COMMON,       4300 }, -- Apple Au Lait
            { cexi.rate.UNCOMMON,     4112 }, -- Potion
            { cexi.rate.RARE,         4113 }, -- Potion +1
        },
    },
    bonus =
    {
        chest =
        {
            { 260.984, -32.206,  88.906, 219 }, -- (J-7) !pos 260.984 -32.206 88.906
            { 228.310, -32.004,  68.041,  96 }, -- (I-8) !pos 228.310 -32.004 68.041
            { 258.785, -31.924,  81.949,  62 }, -- (J-7) !pos 258.785 -31.924 81.949
            { 265.452, -31.617,  35.384, 130 }, -- (J-8) !pos 265.452 -31.617 35.384
            { 250.005, -32.134, 173.457, 228 }, -- (J-6) !pos 250.005 -32.134 173.457
        },
        mobs = { "Copper_Beetle", 5 },
        boss =
        {
            name = "Brass Beetle",
            base = { 143, 14 }, -- Copper Beetle
            pos  = { 202.202, -32.000, 99.982, 0 }, -- (I-7) !pos 202.202 -32.000 99.982
            desc = "(I-7) (Map #3)",
            lv   = tiers[3].bonusLevel,
        },
    },
}

-----------------------------------
-- Palborough Mines: Phase IV
-----------------------------------
battles[PALBOROUGH_MINES].phases[4] =
{
    cap  = tiers[4].levelCap,
    mobs =
    {
        "Old_Quadav",
        "Copper_Quadav",
        "Brass_Quadav",
    },
    boss =
    {
        name     = "Marble Quadav",
        base     = { 147, 25 }, -- GaBhu_Unvanquished
        pos      = { 55.207, -31.624, 5.459, 0 }, -- !pos 55.207 -31.624 5.459 143
        desc     = "(G-8) (Map #3)",
        lv       = tiers[4].bossLevel,
        reqs     = tiers[4].mobsRequired,
        currency = tiers[4].currencyAwarded,
        loot     =
        {
            {              850, 12289                }, -- Lauan Shield
            { cexi.rate.COMMON, xi.item.PIXIE_SHIELD },
        },
    },
    bonus =
    {
        chest =
        {
            {  99.916, -31.982, 117.152,  64 }, -- (H-7) !pos 99.916 -31.982 117.152 143
            { 140.104, -32.026, 117.077,  64 }, -- (H-7) !pos 140.104 -32.026 117.077 143
            { 197.455, -32.026, 100.062, 127 }, -- (I-7) !pos 197.455 -32.026 100.062 143
            { 129.798, -29.735,  27.950,   0 }, -- (H-8) !pos 129.798 -29.735 27.950 143
            {  16.391, -31.296, -99.946,   0 }, -- (G-10) !pos 16.391 -31.296 -99.946 143
        },
        mobs = { "Scimitar_Scorpion", 2 },
        boss =
        {
            name = "Mine Stinger",
            base = { 143, 15 }, -- Mine_Scorpion
            pos  = {  19.019, -31.879, 79.022,  59 }, -- (G-8) !pos 19.019, -31.879, 79.022 143
            desc = "(G-8) (Map #3)",
            lv   = tiers[4].bonusLevel,
        },
    },
}

-----------------------------------
-----------------------------------
-----------------------------------

-----------------------------------
-- Giddeus (Allied Incursion)
-----------------------------------
battles[GIDDEUS] =
{
    area  = "Giddeus", -- (H-5)
    zone  = xi.zone.GIDDEUS,
    pos   = { -55.653, 4.108, 303.747, 208 }, -- !pos -55.653 4.108 303.747 145
    exp   = 2500, -- Per boss
    scale = 20,
    size  = 6,
    merit = 4,
    mats  =
    {
        { cexi.rate.VERY_COMMON, xi.item.YAGUDO_CLOTH }, -- Yagudo Cloth   (24%)
        { cexi.rate.UNCOMMON,    880                  }, -- Bone Chip      (10%)
        { cexi.rate.UNCOMMON,    881                  }, -- Crab Shell     (10%)
        { cexi.rate.UNCOMMON,    893                  }, -- Giant Femur    (10%)
        { cexi.rate.UNCOMMON,    897                  }, -- Scorpion Claw  (10%)
        { cexi.rate.UNCOMMON,    889                  }, -- Beetle Shell   (10%)
        { cexi.rate.RARE,        894                  }, -- Beetle Jaw     ( 5%)
        { cexi.rate.RARE,        896                  }, -- Scorpion Shell ( 5%)
        { cexi.rate.VERY_RARE,   885                  }, -- Turtle Shell   ( 1%)

        { cexi.rate.VERY_COMMON, xi.item.YAGUDO_CLOTH }, -- Yagudo Cloth   (24%)
        { cexi.rate.UNCOMMON,   1845                  }, -- Red Moko Grass (10%)
        { cexi.rate.UNCOMMON,    834                  }, -- Saruta Cotton  (10%)
        { cexi.rate.UNCOMMON,    835                  }, -- Flax Flower    (10%)
        { cexi.rate.UNCOMMON,    832                  }, -- Sheep Wool     (10%)
        { cexi.rate.UNCOMMON,    839                  }, -- Cocoon         (10%)
        { cexi.rate.RARE,        838                  }, -- Spider Web     ( 5%)
        { cexi.rate.VERY_RARE,   822                  }, -- Silver Thread  ( 1%)
    },
    currency = xi.item.YAGUDO_SILVER,
    extra    = xi.item.GAMBLERS_CHAPEAU,
    bonus    =
    {
        {
            { cexi.rate.VERY_COMMON, xi.item.YAGUDO_CLOTH }, -- 100%
        },
        {
            {                   760, 0                    },
            { cexi.rate.VERY_COMMON, xi.item.YAGUDO_CLOTH }, -- 24%
        },
        {
            {                900, 0                      },
            { cexi.rate.UNCOMMON, xi.item.SNIPERS_SHROUD }, -- 10%
        },
    },
    weapons  =
    {
        { cexi.rate.COMMON, xi.item.WORN_KNIFE   },
        { cexi.rate.COMMON, xi.item.WORN_KATANA  },
        { cexi.rate.COMMON, xi.item.WORN_TACHI   },
        { cexi.rate.COMMON, xi.item.WORN_POLE    },
        { cexi.rate.COMMON, xi.item.WORN_LONGBOW },
        { cexi.rate.COMMON, xi.item.WORN_FIFE    },
    },
    phases = {},
}

-----------------------------------
-- Giddeus: Phase I
-----------------------------------
battles[GIDDEUS].phases[1] =
{
    cap  = tiers[1].levelCap,
    mobs =
    {
        "Yagudo_Initiate",
        "Yagudo_Scribe",
        "Yagudo_Acolyte",
    },
    boss =
    {
        name     = "Yagudo Scout",
        base     = { 145, 7 }, -- Yagudo_Initiate
        pos      = { 93.729, 0.793, -77.214, 127 }, -- !pos 93.729 0.793 -77.214 145
        desc     = "(J-9) (Map #1)",
        lv       = tiers[1].bossLevel,
        reqs     = tiers[1].mobsRequired,
        currency = tiers[1].currencyAwarded,
        loot     =
        {
            { cexi.rate.VERY_COMMON, 16896 }, -- Kunai
            { cexi.rate.COMMON,      16551 }, -- Sapara
            { cexi.rate.UNCOMMON,    16966 }, -- Tachi
            { cexi.rate.RARE,        16552 }, -- Scimitar
        },
    },
}

-----------------------------------
-- Giddeus: Phase II
-----------------------------------
battles[GIDDEUS].phases[2] =
{
    cap  = tiers[2].levelCap,
    mobs =
    {
        "Yagudo_Persecutor",
        "Yagudo_Piper",
        "Yagudo_Mendicant",
    },
    boss =
    {
        name     = "Yagudo Sparrer",
        base     = { 145, 21 }, -- Yagudo_Votary
        pos      = { -186.345, 16.907, 185.434,  26 }, -- !pos -186.345 16.907 185.434 145
        desc     = "(F-6) (Map #2)",
        lv       = tiers[2].bossLevel,
        reqs     = tiers[2].mobsRequired,
        currency = tiers[2].currencyAwarded,
        loot     =
        {
            { cexi.rate.VERY_COMMON, 16385 }, -- Cesti
            { cexi.rate.COMMON,      16390 }, -- Bronze Knuckles
            { cexi.rate.UNCOMMON,    16391 }, -- Brass Knuckles
            { cexi.rate.RARE,        16386 }, -- Lizard Cesti
        },
    },
    bonus =
    {
        chest =
        {
            {  84.980,  -0.290, -135.166, 192 }, -- (J-11) !pos 84.980 -0.290 -135.166 145
            { 134.859,   1.280, -113.114, 109 }, -- (J-10) !pos 134.859 1.280 -113.114 145
            { 210.775,   1.018, -183.529, 109 }, -- (K-11) !pos 210.775 1.018 -183.529 145
            { 220.663,  -2.042, -307.476, 187 }, -- (K-12) !pos 220.663 -2.042 -307.476 145
            { 133.847,   0.956, -204.736, 116 }, -- (J-11) !pos 133.847 0.956 -204.736 145
        },
        mobs = { "Giddeus_Pugil", 5 },
        boss =
        {
            name = "Venomous Bee",
            base = { 145, 10 }, -- Giddeus_Bee
            pos  = { 207.701,  1.255, -185.096, 109 }, -- (K-11) !pos 207.701 1.255 -185.096 145
            desc = "(K-11) (Map #1)",
            lv   = tiers[2].bonusLevel,
        },
    },
}

-----------------------------------
-- Giddeus: Phase III
-----------------------------------
battles[GIDDEUS].phases[3] =
{
    cap  = tiers[3].levelCap,
    mobs =
    {
        "Yagudo_Persecutor",
        "Yagudo_Piper",
        "Yagudo_Mendicant",
    },
    boss =
    {
        name     = "Yagudo Conjurer",
        base     = { 145, 9 }, -- Yagudo_Scribe
        pos      = { 90.166, -0.277, -188.834,  82 }, -- !pos 90.166 -0.277 -188.834 145
        desc     = "(J-11) (Map #1)",
        lv       = tiers[3].bossLevel,
        reqs     = tiers[3].mobsRequired,
        currency = tiers[3].currencyAwarded,
        loot     =
        {
            { cexi.rate.VERY_COMMON,  4422 }, -- Orange Juice
            { cexi.rate.COMMON,       4423 }, -- Apple Juice
            { cexi.rate.UNCOMMON,     4424 }, -- Melon Juice
            { cexi.rate.RARE,         4558 }, -- Yagudo Drink
        },
    },
    bonus =
    {
        chest =
        {
            { -143.381,  -2.654,  -13.175, 242 }, -- (G-9) !pos -143.381 -2.654 -13.175 145
            { -107.786,   1.073, -179.580, 163 }, -- (G-11) !pos -107.786 1.073 -179.580 145
            { -255.466,   0.969, -190.710,  42 }, -- (E-11) !pos -255.466 0.969 -190.710 145
            {  -63.661,   0.264,  -60.238,  77 }, -- (H-9) !pos -63.661  0.264 -60.238 145
            {  -23.250,   0.924,  -62.434,  81 }, -- (H-9) !pos -23.250 0.924 -62.434 145
        },
        mobs = { "Earth_Eater", 5 },
        boss =
        {
            name = "Ironscale Pugil",
            base = { 145, 11 }, -- Giddeus_Pugil
            pos  = { -157.482,  1.000, -121.503, 0 }, -- (G-10) !pos -157.482 1.000 -121.503 145
            desc = "(G-10) (Map #1)",
            lv   = tiers[3].bonusLevel,
        },
    }
}

-----------------------------------
-- Giddeus: Phase IV
-----------------------------------
battles[GIDDEUS].phases[4] =
{
    cap  = tiers[4].levelCap,
    mobs =
    {
        "Yagudo_Votary",
        "Yagudo_Priest",
        "Yagudo_Theologist",
    },
    boss =
    {
        name     = "Yagudo Seer",
        base     = { 145, 23 }, -- Hoo_Mjuu_the_Torrent
        pos      = { -23.224, 0.137, -460.204, 179 }, -- !pos -23.224 0.137 -460.204 145
        desc     = "(H-14) (Map #1)",
        lv       = tiers[4].bossLevel,
        reqs     = tiers[4].mobsRequired,
        currency = tiers[4].currencyAwarded,
        loot     =
        {
            {              850, 13075                  }, -- Feather Collar
            { cexi.rate.COMMON, xi.item.PEGASUS_COLLAR },
        },
    },
    bonus =
    {
        chest =
        {
            {  61.362,  -1.537, -189.471, 230 }, -- (I-11) !pos 61.362 -1.537 -189.471 145
            { 120.937,  -3.000, -259,406, 129 }, -- (J-12) !pos 120.937 -3.000 -259,406 145
            {  16.627,   1.068, -336.320, 166 }, -- (I-13) !pos 16.627 1.068 -336.320 145
            { -56.104,   1.106, -383.106,  51 }, -- (H-13) !pos -56.104 1.106 -383.106 145
            {  19.720,   0.264, -422.982, 126 }, -- (I-14) !pos 19.720 0.264 -422.982 145
        },
        mobs = { "Digger_Wasp", 5 },
        boss =
        {
            name = "Dust Eater",
            base = { 145, 12 }, -- Dirt_Eater
            pos  = { -16.362, 1.079, -303.482, 12 }, -- (H-12) !pos -16.362 1.079 -303.482 145
            desc = "(H-12) (Map #1)",
            lv   = tiers[4].bonusLevel,
        },
    },
}

-----------------------------------
-- Steps
-----------------------------------
local entity = {}
local step   = {}

-----------------------------------
-- Entity Setup
-----------------------------------
local function createGenericEntities(battle, battleIndex)
    local entryEntityID = fmt("INC_{}", string.upper(battle.area))

    table.insert(entity, {
        id       = entryEntityID,
        name     = "Rallying Point",
        marker   = cq.MAIN_QUEST,
        area     = battle.area,
        pos      = battle.pos,
        dialog   =
        {
            DEFAULT = cq.NOTHING,
        },
    })

    table.insert(entity, {
        id       = entryEntityID .. "_FLAG",
        name     = "Incursion Flag",
        type     = xi.objType.NPC,
        look     = 817, -- Banner
        notarget = true,
        hidden   = true,
        area     = battle.area,
        pos      = battle.pos,
    })

    table.insert(entity, {
        id       = fmt("INCURSION_CHEST_{}", battleIndex),
        name     = "Incursion Chest",
        type     = xi.objType.NPC,
        look     = 968,
        area     = battle.area,
        pos      = { 1, 1, 1, 1 },
        hidden   = true,
        dialog   =
        {
            DEFAULT = cq.NOTHING,
        },
    })

    table.insert(entity, {
        id       = "ETHEREAL_SOURCE",
        name     = "Ethereal Source",
        type     = xi.objType.NPC,
        look     = 1525,
        area     = battle.area,
        pos      = { 1, 1, 1, 1 },
        hidden   = true,
        hidehp   = true,
        hidename = true,
        dialog   =
        {
            DEFAULT = cq.NOTHING,
        },
    })

    step[1][entryEntityID] =
    {
        onTrigger = function(player, npc)
            cexi.incursion.checkInstance(player, npc, battle)
        end,

        onTrade = function(player, npc, trade)
            cexi.incursion.beginInstance(player, npc, trade, battle, info.required)
        end,
    }
end

-----------------------------------
-- Regular Objectives
-----------------------------------
local function createRegularObjectives(battle, phase, phaseIndex)
    -----------------------------------
    -- Mob Objective
    -----------------------------------
    for mobIndex, mobName in pairs(phase.mobs) do
        cexi.util.ensureMob(battle.area, mobName)

        m:addOverride(fmt("xi.zones.{}.mobs.{}.onMobDeath", battle.area, mobName), function(mob, player, optParams)
            super(mob, player, optParams)
            cexi.incursion.defeatMob(player, battle, phase, phaseIndex)
        end)
    end

    -----------------------------------
    -- Boss Objective
    -----------------------------------
    local spawnerEntityID = fmt("INC_{}_P{}", string.upper(battle.area), phaseIndex)

    table.insert(entity, {
        id         = spawnerEntityID,
        name       = fmt("Incursion Point {}", phaseIndex),
        packetName = "Incursion Point",
        marker     = cq.MAIN_QUEST,
        area       = battle.area,
        pos        = phase.boss.pos,
        dialog     =
        {
            DEFAULT = cq.NOTHING,
        },
    })

    local bossEntityID = fmt("INC_{}_B{}", string.upper(battle.area), phaseIndex)

    local bossPool =
    {
        battle.mats,
        battle.mats,
        battle.weapons,
    }

    if phase.boss.loot ~= nil then
        table.insert(bossPool, phase.boss.loot)
    end

    -- If extra zone loot is defined, roll it for each boss except the final one
    if
        battle.extra ~= nil and
        phaseIndex < #battle.phases
    then
        table.insert(bossPool, {
            {            950, 0            },
            { cexi.rate.RARE, battle.extra },
        })
    end

    table.insert(entity, {
        id          = bossEntityID,
        name        = phase.boss.name,
        type        = xi.objType.MOB,
        groupId     = phase.boss.base[2],
        groupZoneId = phase.boss.base[1],
        look        = phase.boss.look,
        flags       = phase.boss.flags or 1157,
        area        = battle.area,
        pos         = phase.boss.pos,
        level       = phase.boss.lv,
        pool        = bossPool,

        onMobFight  = function(mob, target)
            if mob:getLocalVar("SCALED") == 0 then
                if
                    target ~= nil and
                    target:isPC()
                then
                    local alliance = target:getAlliance()
                    mob:setMod(xi.mod.HPP, #alliance * battle.scale)
                    mob:updateHealth()
                    mob:setHP(mob:getMaxHP())
                    mob:setLocalVar("SCALED", 1)
                end
            end

            cexi.incursion.wsTrigger(mob, battle.currency)
        end,
    })

    step[1][spawnerEntityID] = cq.menu({
        title        = "Are you ready?",
        spawn        = { bossEntityID },
        levelCap     = phase.boss.cap or phase.cap,
        raiseAllowed = true,
        check        = cq.checks(cexi.incursion.getBossChecks(battle, phase, phaseIndex)),
        default      = cexi.incursion.getBossSpawnerRequirements(phase, phaseIndex),
        options      = cq.spawnerOptions(),
    })

    step[1][bossEntityID] = function(mob, player, entity, var, step, entities, check)
        cq.respawnSpawner(player, entities, spawnerEntityID)
        cexi.incursion.defeatBoss(mob, player, battle, phase, phaseIndex)
    end

    step[1]["ETHEREAL_SOURCE"] = function(player, npc)
        cexi.incursion.etherealSource(player, npc)
    end
end

-----------------------------------
-- Bonus Objectives
-----------------------------------
local function createBonusObjectives(battle, battleIndex, phase, phaseIndex)
    -----------------------------------
    -- Bonus Chest
    -----------------------------------
    step[1][fmt("INCURSION_CHEST_{}", battleIndex)] = function(player, npc)
        cexi.incursion.openBonusChest(player, npc, battle)
    end

    -----------------------------------
    -- Bonus Mobs
    -----------------------------------
    cexi.util.ensureMob(battle.area, phase.bonus.mobs[1])

    m:addOverride(fmt("xi.zones.{}.mobs.{}.onMobDeath", battle.area, phase.bonus.mobs[1]), function(mob, player, optParams)
        super(mob, player, optParams)
        cexi.incursion.defeatBonusMob(mob, player, battle, phase, phaseIndex)
    end)

    -----------------------------------
    -- Bonus Boss
    -----------------------------------
    local bossEntityID = fmt("INC_{}_BB{}", string.upper(battle.area), phaseIndex)

    local bossPool =
    {
        battle.mats,
        battle.mats,
        battle.weapons,
    }

    table.insert(entity, {
        id          = bossEntityID,
        name        = phase.bonus.boss.name,
        type        = xi.objType.MOB,
        groupId     = phase.bonus.boss.base[2],
        groupZoneId = phase.bonus.boss.base[1],
        look        = phase.bonus.boss.look,
        flags       = phase.bonus.boss.flags or 1157,
        area        = battle.area,
        pos         = phase.bonus.boss.pos,
        level       = phase.bonus.boss.lv,
        pool        = battle.bonus,

        onMobFight  = function(mob, target)
            if mob:getLocalVar("SCALED") == 0 then
                if
                    target ~= nil and
                    target:isPC()
                then
                    local alliance = target:getAlliance()
                    mob:setMod(xi.mod.HPP, #alliance * battle.scale)
                    mob:updateHealth()
                    mob:setHP(mob:getMaxHP())
                    mob:setLocalVar("SCALED", 1)
                end
            end

            cexi.incursion.wsTrigger(mob, battle.currency)
        end,
    })

    local spawnerEntityID = fmt("INC_{}_PB{}", string.upper(battle.area), phaseIndex)

    table.insert(entity, {
        id         = spawnerEntityID,
        name       = fmt("Incursion Bonus {}", phaseIndex),
        packetName = "Incursion Point",
        marker     = cq.MAIN_QUEST,
        area       = battle.area,
        pos        = phase.bonus.boss.pos,
        dialog     =
        {
            DEFAULT = cq.NOTHING,
        },
    })

    step[1][spawnerEntityID] = cq.menu({
        title        = "Are you ready?",
        spawn        = { bossEntityID },
        levelCap     = phase.boss.cap or phase.cap,
        raiseAllowed = true,
        check        = cq.checks(cexi.incursion.getBonusChecks(battle, phaseIndex)),
        setVarAll    = cexi.incursion.getBonusVarReset,
        default      = cexi.incursion.getBonusSpawnerRequirements(phase, phaseIndex),
        options      = cq.spawnerOptions(),
    })

    step[1][bossEntityID] = function(mob, player, entity, var, step, entities, check)
        cq.respawnSpawner(player, entities, spawnerEntityID)
        cexi.incursion.defeatBonusBoss(mob, player, battle, phase, phaseIndex)
    end
end

-----------------------------------
-- Allied Incursion Battles
-----------------------------------
for battleIndex, battle in pairs(battles) do
    -----------------------------------
    -- Reconnecting
    -----------------------------------
    m:addOverride(fmt("xi.zones.{}.Zone.onZoneIn", battle.area), function(player, prevZone)
        cexi.incursion.recoverSession(player, prevZone, super, battle)
    end)

    -----------------------------------
    -- Create entities and objectives
    -----------------------------------
    if step[1] == nil then
        step[1] = {}
    end

    createGenericEntities(battle, battleIndex)

    if battle.phases ~= nil then
        for phaseIndex, phase in pairs(battle.phases) do
            createRegularObjectives(battle, phase, phaseIndex)

            if
                phase ~= nil and
                phase.bonus ~= nil
            then
                createBonusObjectives(battle, battleIndex, phase, phaseIndex)
            end
        end
    end
end

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
