-----------------------------------
-- Moblin Mayhem (Lv65+)
-----------------------------------
-- !setvar [CW]MOBLIN_MAYHEM 0
-- !setvar [CW]MOBLIN_MAYHEM_DELAY 0
-- Moblin Moneybox !pos -140.357, 8.000, 200.656 11
-- !additem 9493
-----------------------------------
-- !setvar [CW]MOBLIN_MAYHEM 1
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-moblin_mayhem")

local info =
{
    name     = "Moblin Mayhem",
    author   = "Loxley",
    var      = "[CW]MOBLIN_MAYHEM",
    delay    = "[CW]MOBLIN_MAYHEM_DELAY",
    dial     = "[CW]MOBLIN_MAYHEM_DIAL",
    required = xi.item.MOBLIN_MASTER_KEY, -- Moblin Master Key
}

local rewards =
{
    -- Trash (30%)
    { cexi.rate.UNCOMMON, xi.item.GOLD_BEASTCOIN            }, -- (10%) Gold Beastcoin
    { cexi.rate.UNCOMMON, xi.item.AETHER_FRAGMENT           }, -- (10%) Aether Fragment
    { cexi.rate.UNCOMMON, xi.item.MOBLIN_MEDALLION          }, -- (10%) Moblin Medallion

    -- Rare Materials (50%)
    { cexi.rate.RARE, xi.item.CHUNK_OF_PLATINUM_ORE         }, -- ( 5%) Platinum Ore
    { cexi.rate.RARE, xi.item.CHUNK_OF_MOLYBDENUM_ORE       }, -- ( 5%) Molybdenum Ore
    { cexi.rate.RARE, xi.item.DIVINE_LOG                    }, -- ( 5%) Divine Log
    { cexi.rate.RARE, xi.item.SQUARE_OF_DAMASCENE_CLOTH     }, -- ( 5%) Damascene Cloth
    { cexi.rate.RARE, xi.item.ADAMANTOISE_SHELL             }, -- ( 5%) Adamantoise Shell

    { cexi.rate.RARE, xi.item.SQUARE_OF_KEJUSU_SATIN        }, -- ( 5%) Kejusu Satin
    { cexi.rate.RARE, xi.item.SQUARE_OF_GALATEIA            }, -- ( 5%) Galateia
    { cexi.rate.RARE, xi.item.DRAGON_BONE                   }, -- ( 5%) Dragon Bone
    { cexi.rate.RARE, xi.item.SQUARE_OF_ELTORO_LEATHER      }, -- ( 5%) Eltoro Leather
    { cexi.rate.RARE, xi.item.POT_OF_VIRIDIAN_URUSHI        }, -- ( 5%) Viridian Urushi

    -- Very Rare Materials (10%)
    { cexi.rate.VERY_RARE, xi.item.LOCK_OF_SIRENS_HAIR      }, -- ( 1%) Siren's Hair
    { cexi.rate.VERY_RARE, xi.item.PIECE_OF_ANGEL_SKIN      }, -- ( 1%) Angel Skin
    { cexi.rate.VERY_RARE, xi.item.PIECE_OF_OXBLOOD         }, -- ( 1%) Oxblood
    { cexi.rate.VERY_RARE, xi.item.HANDFUL_OF_DRAGON_SCALES }, -- ( 1%) Dragon Scales
    { cexi.rate.VERY_RARE, xi.item.VIAL_OF_DRAGON_BLOOD     }, -- ( 1%) Dragon Blood

    { cexi.rate.VERY_RARE, xi.item.ORICHALCUM_INGOT         }, -- ( 1%) Orichalcum Ingot
    { cexi.rate.VERY_RARE, xi.item.CHUNK_OF_KHROMA_ORE      }, -- ( 1%) Khroma Ore
    { cexi.rate.VERY_RARE, xi.item.SPOOL_OF_MALBORO_FIBER   }, -- ( 1%) Malboro Fiber
    { cexi.rate.VERY_RARE, xi.item.KHIMAIRA_TAIL            }, -- ( 1%) Khimaira Tail
    { cexi.rate.VERY_RARE, xi.item.STAR_SAPPHIRE            }, -- ( 1%) Star Sapphire

    -- Very Rare Materials (10%)
    { cexi.rate.VERY_RARE, xi.item.CHUNK_OF_KUNWU_IRON      }, -- ( 1%) Kunwu Ore
    { cexi.rate.VERY_RARE, xi.item.DRAGON_TALON             }, -- ( 1%) Dragon Talon
    { cexi.rate.VERY_RARE, xi.item.WYRM_HORN                }, -- ( 1%) Wyrm Horn
    { cexi.rate.VERY_RARE, xi.item.DAMASCUS_INGOT           }, -- ( 1%) Damascus Ingot
    { cexi.rate.VERY_RARE, xi.item.BEHEMOTH_HORN            }, -- ( 1%) Behemoth Horn

    { cexi.rate.VERY_RARE, xi.item.BEHEMOTH_HIDE            }, -- ( 1%) Behemoth Hide
    { cexi.rate.VERY_RARE, xi.item.DRAGON_HEART             }, -- ( 1%) Dragon Heart
    { cexi.rate.VERY_RARE, xi.item.CHAMPION_BELT            }, -- ( 1%) Champion Belt
    { cexi.rate.VERY_RARE, xi.item.MOBLINIUM_MIGHT          }, -- ( 1%) Moblinium Might
    { cexi.rate.VERY_RARE, xi.item.WARLOQS_LOCKET           }, -- ( 1%) Warloq's Locket
}

local function spawnAdd(source, target, name)
    local zone    = source:getZone()
    local result  = zone:queryEntitiesByName("DE_" .. name)

    for _, mob in pairs(result) do
        if mob ~= nil and not mob:isAlive() then
            local pos = source:getPos()
            mob:setSpawn(pos.x, pos.y, pos.z, pos.rot)
            mob:setDropID(0)

            mob:spawn()
            mob:setMobLevel(80)
            mob:updateClaim(target)
            mob:setLocalVar("NO_CASKET", 1)

            mob:setRespawnTime(0)
            DisallowRespawn(mob:getID(), true)

            mob:setHP(mob:getMaxHP())
            mob:updateHealth()

            mob:setMobMod(xi.mobMod.DRAW_IN, 15)

            mob:addImmunity(xi.immunity.DARK_SLEEP)
            mob:addImmunity(xi.immunity.GRAVITY)
            mob:addImmunity(xi.immunity.LIGHT_SLEEP)
            mob:addImmunity(xi.immunity.PETRIFY)
            mob:addImmunity(xi.immunity.SILENCE)
            mob:addImmunity(xi.immunity.TERROR)

            mob:addStatusEffectEx(
                xi.effect.LEVEL_RESTRICTION,
                xi.effect.LEVEL_RESTRICTION,
                75,
                0,
                0,
                0,
                0,
                0,
                xi.effectFlag.DEATH + xi.effectFlag.ON_ZONE + xi.effectFlag.CONFRONTATION
            )
        end
    end
end

local MOBLIN_1 = "MOBLIN_1"
local MOBLIN_2 = "MOBLIN_2"
local BUGBEAR  = "BUGBEAR"
local CHEST    = "CHEST"

local adds =
{
    { "Jittering Jack",    8, 105 }, -- Lumber_Jack
    { "Hardshell Henry", 153,  14 }, -- Aquarius
    { "Stingtip Susan",  205,  14 }, -- Tyrannic_Tunnok
    { "Feverish Frank",  174,  33 }, -- Arachne
    { "Limping Larry",   174,  16 }, -- Amemet
    { "Nibbling Norman",   5,  46 }, -- White_Coney
}

local entity =
{
    {
        id     = CHEST,
        name   = "Moblin Moneybox",
        type   = xi.objType.NPC,
        look   = 969,
        area   = "Oldton_Movalpolos",
        pos    = { -140.357, 8.000, 200.656, 189 }, -- !pos -140.357, 8.000, 200.656 11
        dialog =
        {
            DEFAULT = { "It's locked." },
        },
    },
    {
        id          = BUGBEAR,
        name        = "Bugbear Bigman",
        type        = xi.objType.MOB,
        groupId     = 34, -- Bugbear_Matman
        groupZoneId = 12,
        area        = "Oldton_Movalpolos",
        pos         = { -149.441, 7.737, 219.077, 17 }, -- !pos -149.441, 7.737, 219.077 11
        level       = 84,
        jobSpecial  = true,
        mods        =
        {
            -- Reduced magic damage taken
            [xi.mod.FIRE_SDT]    = 500,
            [xi.mod.ICE_SDT]     = 500,
            [xi.mod.WIND_SDT]    = 500,
            [xi.mod.EARTH_SDT]   = 500,
            [xi.mod.THUNDER_SDT] = 500,
            [xi.mod.WATER_SDT]   = 500,
            [xi.mod.LIGHT_SDT]   = 500,
            [xi.mod.DARK_SDT]    = 500,
            [xi.mod.SLEEPRES]    = 100,
            [xi.mod.LULLABYRES]  = 100,
        },
        loot        =
        {
            { cexi.rate.VERY_COMMON,                     1624 }, -- Bugbear Mask     (24%)
            { cexi.rate.VERY_COMMON, xi.item.MOBLIN_MEDALLION }, -- Moblin Medallion (24%)
        },
    },
    {
        id          = MOBLIN_1,
        name        = "Lakitak",
        type        = xi.objType.MOB,
        groupId     = 36, -- Sword_Sorcerer_Solisoq
        groupZoneId = 12,
        area        = "Oldton_Movalpolos",
        pos         = { -140.143, 7.990, 214.544, 60 }, -- !pos -140.143 7.990 214.544 11
        level       = 85,
        jobSpecial  = true,
        mods        =
        {
            -- Reduced magic damage taken
            [xi.mod.FIRE_SDT]    = 500,
            [xi.mod.ICE_SDT]     = 500,
            [xi.mod.WIND_SDT]    = 500,
            [xi.mod.EARTH_SDT]   = 500,
            [xi.mod.THUNDER_SDT] = 500,
            [xi.mod.WATER_SDT]   = 500,
            [xi.mod.LIGHT_SDT]   = 500,
            [xi.mod.DARK_SDT]    = 500,
        },
        loot        =
        {
            { cexi.rate.VERY_COMMON,                     1638 }, -- Moblin Mask      (24%)
            { cexi.rate.COMMON,      xi.item.MOBLIN_MEDALLION }, -- Moblin Medallion (15%)
        },
    },
    {
        id          = MOBLIN_2,
        name        = "Wiz Wart Warloq",
        type        = xi.objType.MOB,
        groupId     = 35, -- Mythril_Mouth_Monamaq
        groupZoneId = 62,
        area        = "Oldton_Movalpolos",
        pos         = { -142.939, 7.916, 208.208, 38 }, -- !pos -142.939 7.916 208.208 11
        level       = 85,
        jobSpecial  = true,
        mods        =
        {
            -- Reduced magic damage taken
            [xi.mod.FIRE_SDT]    = 500,
            [xi.mod.ICE_SDT]     = 500,
            [xi.mod.WIND_SDT]    = 500,
            [xi.mod.EARTH_SDT]   = 500,
            [xi.mod.THUNDER_SDT] = 500,
            [xi.mod.WATER_SDT]   = 500,
            [xi.mod.LIGHT_SDT]   = 500,
            [xi.mod.DARK_SDT]    = 500,
        },
        onMobFight = function(mob, target)
            if
                mob:getHPP() <= 50 and
                mob:getLocalVar("CALLED") == 0
            then
                if target ~= nil then
                    mob:setLocalVar("CALLED", 1)
                    spawnAdd(mob, target, adds[math.random(1, #adds)][1])

                    if target:isPC() then
                        target:printToArea("summons reinforcements!", xi.msg.channel.EMOTION, xi.msg.area.SAY, "Wiz Wart Warloq")
                    end
                end
            end
        end,
        loot        =
        {
            { cexi.rate.VERY_COMMON, xi.item.MOBLIN_MEDALLION }, -- Moblin Medallion (24%)
            { cexi.rate.VERY_COMMON,                     1625 }, -- Moblin Helm      (24%)
        },
    },
}

for _, mobInfo in pairs(adds) do
    table.insert(entity, {
        id          = string.upper(mobInfo[1]),
        name        = mobInfo[1],
        type        = xi.objType.MOB,
        groupId     = mobInfo[3],
        groupZoneId = mobInfo[2],
        area        = "Oldton_Movalpolos",
        pos         = { -142.939, 7.916, 208.208, 38 }, -- !pos -142.939 7.916 208.208 11
        level       = 85,
        onMobRoam   = function(mob)
            mob:setHP(0)
        end,
        loot        =
        {
            { cexi.rate.VERY_COMMON, xi.item.MOBLIN_MEDALLION }, -- Moblin Medallion (24%)
            { cexi.rate.UNCOMMON,    xi.item.MOBLIN_MEDALLION }, -- Moblin Medallion (10%)
        },
    })
end

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function rollRewards(player, npc, rewardList, questVar, delayVar, dialVar)
    local current = player:getLocalVar(dialVar)

    npc:entityAnimationPacket("open")
    npc:timer(5000, function(npcArg)
        npcArg:entityAnimationPacket("close")
    end)

    local rolls = 2

    if current == 11 then
        rolls = rolls + 3
    elseif current == 10 then
        rolls = rolls + 2
    elseif current > 7 then
        rolls = rolls + 1
    end

    for i = 1, rolls do
        local result = cexi.util.pickItem(rewardList)
        player:addTreasure(result[2], npc)
    end

    player:addTreasure(xi.item.MOBLIN_MEDALLION, npc)

    player:setCharVar(delayVar, 1, JstMidnight())
    player:setCharVar(questVar, 0)
    player:setLocalVar(dialVar, 0)
    player:setLocalVar("[CW]MM_POP", 0) -- Prevent player from interacting with subsequent chests

    local zoneID   = player:getZoneID()
    local alliance = player:getAlliance()

    for _, member in pairs(alliance) do
        if
            member ~= nil and
            member:isPC() and
            member:getZoneID() == zoneID
        then
            local currency = math.random(2, 6) + rolls
            member:sys("{} gains {} gobbie grandeur.", member:getName(), currency)
            member:incrementCharVar("[CW]GAMBIT_GG", currency)
        end
    end
end

local function strangeLever(rewardList, questVar, delayVar, dialVar)
    return function(player, npc, tbl)
        local current = player:getLocalVar(dialVar)

        delaySendMenu(player, {
            title   = fmt("The dial reads: {}", current),
            options =
            {
                {
                    "Pull the lever",
                    function()
                        local roll  = math.random(1, 6)
                        local total = current + roll

                        local zoneID   = player:getZoneID()
                        local alliance = player:getAlliance()

                        for i = 1, #alliance do
                            if
                                alliance[i]:isPC() and
                                alliance[i]:getZoneID() == zoneID
                            then
                                alliance[i]:sys("The dial increases by {}! (Total: {})", roll, total)
                            end
                        end

                        player:setLocalVar(dialVar, utils.clamp(total, 1, 11))

                        if total > 11 then
                            for i = 1, #alliance do
                                if
                                    alliance[i]:isPC() and
                                    alliance[i]:getZoneID() == zoneID
                                then
                                    alliance[i]:fmt("{} broke the lever.", player:getName(), roll, total)
                                end
                            end

                            player:setLocalVar(dialVar, 0)
                            rollRewards(player, npc, rewardList, questVar, delayVar, dialVar)
                        end
                    end,
                },
                {
                    "Quit (Claim reward)",
                    function()
                        rollRewards(player, npc, rewardList, questVar, delayVar, dialVar)
                    end,
                },
            },
        })
    end
end

local wave = { BUGBEAR, MOBLIN_1, MOBLIN_2 }
local step =
{
    {
        check   = cq.checks({ CW = true, level = 65, zero = info.delay }),
        [CHEST] =
        {
            onTrigger = cq.dialog({
                step  = false,
                event = { { noturn = true }, "You see a strange keyhole." },
            }),
            onTrade = cq.tradeSpawn(wave, info.required, {
                levelCap     = 75,
                raiseAllowed = true,
                hideSpawner  = false,
                flag         = "[CW]MM_POP"
            }),
        },
        [BUGBEAR]  = cq.killStep(CHEST, wave, nil, { helper = xi.item.DRAGON_CHRONICLES, flag = "[CW]MM_POP" }),
        [MOBLIN_1] = cq.killStep(CHEST, wave, nil, { helper = xi.item.DRAGON_CHRONICLES, flag = "[CW]MM_POP" }),
        [MOBLIN_2] = cq.killStep(CHEST, wave, nil, { helper = xi.item.DRAGON_CHRONICLES, flag = "[CW]MM_POP" }),
    },
    {
        [CHEST] = strangeLever(rewards, info.var, info.delay, info.dial),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
