-----------------------------------
-- Goblin's Gambit (Lv65+)
-----------------------------------
-- !setvar [CW]GAMBIT 0
-- !setvar [CW]GAMBIT_DELAY 0
-- Bagatrix !pos -140.000 8.000 140.000 11
-- !additem gold_beastcoin 12
-----------------------------------
-- !setvar [CW]GAMBIT 4
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-goblins_gambit")

local info =
{
    name    = "Goblin's Gambit",
    author  = "Loxley",
    var     = "[CW]GAMBIT",
    pattern = { 1, 2, 3 },
}

local rewards =
{
    -- One out of three pooled categories is chosen based on the box
    pooled =
    {
        -- Missing CW ciphers currently available for QoL
        {
            {  "Cipher: Adelheid",   10153,  50 }, -- Records of Eminence
            {  "Cipher: Elivira",    10130,  50 }, -- Curio Moogle
            {  "Cipher: Mihli",      10115,  50 }, -- Records of Eminence
            {  "Cipher: Uka",        10136,  50 }, -- Curio Moogle

            {  "Cipher: Joachim",    10117, 100 }, -- Records of Eminence
            {  "Cipher: Koru-Moru",  10140, 100 }, -- Curio Moogle
            {  "Cipher: Valaineral", 10116, 100 }, -- Records of Eminence
            -- "Cipher: Tenzen" -- Records of Eminence (Needs rebalance?)
        },
        -- Previously removed from vendors for CW (Available for QoL)
        {
            { "Scroll of Distract",    4912,  30 },
            { "Scroll of Frazzle",     4914,  30 },
            { "Scroll of Quake II",    4819,  40 },
            { "Scroll of Flood II",    4823,  40 },
 
            { "Scroll of Tornado II",  4817,  40 },
            { "Scroll of Flare II",    4813,  40 },
            { "Scroll of Freeze II",   4815,  40 },
            { "Scroll of Burst II",    4821,  40 },
 
            { "Scroll of Dia III",     4633,  50 },
            { "Scroll of Phalanx II",  6571,  50 },
            { "Scroll of Bio III",     4840,  50 },
            { "Scroll of Blind II",    4884,  50 },
 
            { "Scroll of Paralyze II", 6570, 100 },
            { "Scroll of Protectra V", 4737, 100 },
            { "Scroll of Shellra V",   4742, 100 },
            { "Scroll of Slow II",     6569, 100 },

            { "Scroll of Crusade",     5103, 100 },
        },
        -- Previously removed from vendors for CW (Available for QoL)
        {
            { "Arcanic Cell II",     9073,  50 },
            { "Arcanoclutch",        9887,  50 },
            { "Condenser",           2352,  50 },
            { "Economizer",          2354,  50 },

            { "Magniplug",           9885,  50 },
            { "Mana Tank III",       9045,  50 },
            { "Optic Fiber",         2353,  50 },
            { "Reactive Shield",     2347,  50 },

            { "Resister II",         9071,  50 },
            { "Steam Jacket",        2414,  50 },
            { "Tranquilizer",        2348,  50 },
            { "Turbo Charger",       2349,  50 },

            { "Dynamo",              2351, 100 },
            { "Schurzen",            2350, 100 },
            { "Auto-Repair Kit III", 9044, 100 },
            { "Coiler",              2413, 100 },

            -- Otherwise unavailable due to ENM not being implemented
            { "Flame Holder",        2409, 100 },
            { "Ice Maker",           2410, 100 },
        }, 
    },
    weapons =
    {
        -- Adaman weapons
        -- These are selected to be entry level weapons for endgame while inferior to most endgame loot
        -- The broad range of augments creates many interesting new combos and unique items to chase
        -- Augments are: one base stat (2-5) + one secondary stat (2-3)
        { "Adaman Kilij",  17727, 50 }, -- Sword
        { "Adaman Kris",   16461, 50 }, -- Dagger
        { "Adaman Sainti", 18745, 50 }, -- Hand-to-Hand
        { "Anelace",       16547, 50 }, -- Sword
        { "Bahadur",       19151, 50 }, -- Great Sword
        { "Buzdygan",      17038, 50 }, -- Club
        { "Kazaridachi",   16972, 50 }, -- Great Katana
        { "Culverin",      17252, 50 }, -- Gun
        { "Gully",         16470, 50 }, -- Dagger
        { "Iron-splitter", 17569, 50 }, -- Staff
        { "Kaskara",       16579, 50 }, -- Sword
        { "Misericorde",   16452, 50 }, -- Dagger
        { "Manoples",      16423, 50 }, -- Hand-to-Hand
        { "Nadziak",       16653, 50 }, -- Axe
        { "Flamberge",     16596, 50 }, -- Great Sword
        { "Ox Tongue",     16840, 50 }, -- Polearm
        { "Scepter",       17064, 50 }, -- Club
        { "Tabarzin",      16659, 50 }, -- Axe
        { "Ice Lance",     16861, 50 }, -- Polearm
        { "Bhuj",          16707, 50 }, -- Great Axe
        { "Verdun",        16520, 50 }, -- Sword
    },
    -- Two of these materials are rolled per chest
    material =
    {
        { "Adaman Ore",        646 },
        { "Platinum Ore",      738 },
        { "Orichalcum Ore",    739 },
        { "Darksteel Ore",     645 },
  
        { "Mahogany Log",      700 },
        { "Rosewood Log",      701 },
        { "Ebony Log",         702 },
        { "Petrified Log",     703 },
  
        { "Spider Web",        838 },
        { "Crawler Cocoon",    839 },
        { "Black C. Feather",  845 },
        { "Moblin Thread",    1651 },
  
        { "Tiger Hide",        861 },
        { "Coeurl Hide",       863 },
        { "Raptor Skin",       853 },
        { "Manticore Hide",   1116 },
  
        { "Phil. Stone",       942 },
        { "Firesand",          947 },
        { "Cermet Chunk",      931 },
        { "Dryad Root",        923 },
  
        { "Painite",           797 },
        { "Goshenite",         808 },
        { "Iolite",           1740 },
        { "Deathstone",        812 },
  
        { "Silver Shark",     4451 },
        { "Crescent Fish",    4473 },
        { "Gavial Fish",      4477 },
        { "Black Sole",       4384 },
  
        { "Buffalo Meat",     5152 },
        { "Holy Basil",       1590 },
        { "King Truffle",     4386 },
        { "Persikos",         4274 },
    },
    -- One piece of food is rolled per chest
    food =
    {
        { "Dhalmel Steak",     4438 },
        { "Blackened Toad",    4599 },
        { "Tavnazian Salad",   4279 },
        { "Herb Crawler Eggs", 4552 },
        { "Mushroom Stew",     4544 },
        { "Pumpkin Soup",      4430 },
        { "Turtle Soup",       4418 },
        { "Mushroom Risotto",  4434 },
        { "Konigskuchen",      5614 },
        { "Chocomilk",         4498 },
        { "San d'Orian Tea",   4494 },
        { "Pamama Au Lait",    4302 },
        { "Moblin Medallion",  xi.item.MOBLIN_MEDALLION },
    },
}

local miscRewards =
{
    { "Moblin Master Key", 9493, 60, "[CQ]MM_KEY_COOLDOWN" },
}

local weaponHQs =
{
    [17727] = { "Adaman Kilij +1",  17728 }, -- Sword
    [16461] = { "Adaman Kris +1",   18022 }, -- Dagger
    [18745] = { "Gem Sainti +1",    18746 }, -- Hand-to-Hand
    [16547] = { "Anelace +1",       17657 }, -- Sword
    [19151] = { "Bahadur +1",       19152 }, -- Great Sword
    [17038] = { "Buzdygan +1",      17460 }, -- Club
    [16972] = { "Kazaridachi +1",   17805 }, -- Great Katana
    [17252] = { "Culverin +1",      18147 }, -- Gun
    [16470] = { "Gully +1",         17621 }, -- Dagger
    [17569] = { "Iron-splitter +1", 17570 }, -- Staff
    [16579] = { "Kaskara +1",       17712 }, -- Sword
    [16452] = { "Misericorde +1",   17620 }, -- Dagger
    [16423] = { "Manoples +1",      17518 }, -- Hand-to-Hand
    [16653] = { "Nadziak +1",       16685 }, -- Axe
    [16596] = { "Flameberge +1",    16941 }, -- Great Sword
    [16840] = { "Ox Tongue +1",     16894 }, -- Polearm
    [17064] = { "Scepter +1",       17459 }, -- Club
    [16659] = { "Tabarzin +1",      17935 }, -- Axe
    [16861] = { "Ice Lance +1",     16895 }, -- Polearm
    [16707] = { "Bhuj +1",          18197 }, -- Great Axe
    [16520] = { "Verdun +1",        17656 }, -- Sword
}

local augs =
{
    {
        { 512, 2, 4 }, -- STR +2-5
        { 513, 2, 4 }, -- DEX +2-5
        { 514, 2, 4 }, -- VIT +2-5
        { 515, 2, 4 }, -- AGI +2-5
        { 516, 2, 4 }, -- INT +2-5
        { 517, 2, 4 }, -- MND +2-5
        { 518, 2, 4 }, -- CHR +2-5
    },
    {
        {  23, 1, 2 }, -- Accuracy +2-3
        {  25, 1, 2 }, -- Attack +2-3
        {  69, 1, 2 }, -- Rng.Acc. +2-3 / Rng.Atk. +2-3
        {  35, 1, 2 }, -- Mag.Acc. +2-3
        {  31, 1, 2 }, -- Evasion +2-3
        {  40, 1, 2 }, -- Enmity -2-3
        {  54, 1, 2 }, -- Phys. dmg. taken -2-3%
        {  55, 1, 2 }, -- Magic dmg. taken -2-3%
        { 133, 1, 2 }, -- Mag.Atk.Bns.+2-3
        { 329, 1, 2 }, -- Cure potency +2-3%
        { 330, 1, 2 }, -- Waltz potency +2-3%
        {  51, 1, 2 }, -- HP recovered while healing +2-3
        {  52, 1, 2 }, -- MP recovered while healing +2-3
    },
}

local attributeNames =
{
    [512] = "STR",
    [513] = "DEX",
    [514] = "VIT",
    [515] = "AGI",
    [516] = "INT",
    [517] = "MND",
    [518] = "CHR",
}

local statNames =
{
    [23]  = "Accuracy+",
    [25]  = "Attack+",
    [69]  = "Rng.Acc+ / Rng.Atk+",
    [35]  = "Mag.Acc+",
    [31]  = "Evasion+",
    [40]  = "Enmity-",
    [54]  = "Phys. dmg. taken-",
    [55]  = "Magic dmg. taken-",
    [133] = "Magic Atk. Bonus+",
    [329] = "Cure potency+",
    [330] = "Waltz potency+",
    [51]  = "HP recovery+",
    [52]  = "MP recovery+",
}

local gambiloxDialog =
{
    DEFAULT   = { "I can't do anything for you yet. Speak to Bagatrix." },
    WELCOME   = { "Nice fighting out there! Earned yourself a few Gobbie Grandeur?\n Spend them here at my humble little shoppe for champions!" },
    CONFIRM   = { "Is this the one ya want?" },
    WEAPON    = { "For the low, low price of 50 GGs. I'll let you roll any weapon you want!\n Is that a deal or what?" },
    BOUGHT    = { "Here ya go." },
    DECLINED  = { "Woah, hey now. Looks like you don't have enough GGs for that pal!" },
    UPGRADE   = { "Awright here's the deal. Trade me one of those Gobbie weapons and I can make it even stronger!" },
    UPGRADING = { "Upgrading this %s? Awright, 'ere's what I can do for ya." },
    TRANSFER  = { "You wanna transfer this stuff to that %s... Do I look like a charity? That'll be 12 beastcoins! Gimme all of it at once." },
    COMPLETE  = { "Awright, here it is then." },
    FULL      = { "Woah, slow down Greedalox! You can't carry that much." },
    MOBLIN_UPGRADE  = { "Woah, been to see the Moblins have ya?\nTell ya what, bring me here {} Moblin Medallions and I can make that {} even better!" },
    MOBLIN_UPGRADED = { "It's a deal. Here ya go buddy!" },
    MOBLIN_FINISHED = { "Woah, that's a fine piece... I don't think there's anybody who could exceed that incredible workmanship!" },
}

local BAGA = "BAGA"
local GOB1 = "GOB1"
local GOB2 = "GOB2"
local BAT1 = "BAT1"
local RED  = "RED"
local BLUE = "BLUE"
local GOLD = "GOLD"

local entity =
{
    {
        id     = BAGA,
        name   = "Bagatrix",
        type   = xi.objType.NPC,
        look   = 700,
        area   = "Oldton_Movalpolos",              -- (G-8)
        pos    = { -140.000, 8.000, 140.000, 68 }, -- !pos -140.000 8.000 140.000 11
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Hey, you! This area is off limits!" },
            START    =
            {
                "Hey, you! This area is off limits!",
                " You're here to challenge the gobs? Well then...",
                "Bring 4 gold beastcoins and I'll let ya meet my pals.",
            },
            REMINDER = { "Bring 4 gold beastcoins and I'll let ya meet my pals." },
            DELAY    =
            {
                "Woah, woah, woah. Ya think you're just walking off with everything?",
                " Come back tomorrow buddy. We'll talk then.",
            },
            ACCEPTED =
            {
                "That'll do nicely. All right, let us know when you're ready.",
            },
            BATTLE   = { "Get 'em boys!" },
            REWARD   =
            {
                "You beat us! Under the gobbie code we have to offer you a prize.",
                " Can't promise it'll be anything good though. Hahaha...",
                " Pick one of these here boxes and see what ya get!",
            },
            REMINDER2 = { "What're you waitin' for? Pick a box!" },
        },
    },
    {
        id     = GOLD,
        name   = "Garish Goldibox",
        type   = xi.objType.NPC,
        look   = 969,
        area   = "Oldton_Movalpolos",
        pos    = { -139.715, 8.125, 141.870, 68 },
        dialog =
        {
            DEFAULT = { "It's locked." },
        },
    },
    {
        id     = BLUE,
        name   = "Cerulean Casket",
        type   = xi.objType.NPC,
        look   = 965,
        area   = "Oldton_Movalpolos",
        pos    = { -138.144, 8.023, 141.765, 68 },
        dialog =
        {
            DEFAULT = { "It's locked." },
        },
    },
    {
        id     = RED,
        name   = "Rouge Reliquary",
        type   = xi.objType.NPC,
        look   = 968,
        area   = "Oldton_Movalpolos",
        pos    = { -141.270, 8.047, 141.944, 68 },
        dialog =
        {
            DEFAULT = { "It's locked." },
        },
    },
    {
        id          = GOB1,
        name        = "Healix Longtoes",
        type        = xi.objType.MOB,
        look        = 510,
        groupId     = 45,
        groupZoneId = 188,
        area        = "Oldton_Movalpolos",
        pos         = { -137.021, 8.000, 154.570, 70 }, -- !pos -137.021 8.000 154.570 11
        level       = 80,
        jobSpecial  = true,
        mods        =
        {
            -- Vulnerable to slashing damage
            [xi.mod.SLASH_SDT]  = 1000,
            [xi.mod.PIERCE_SDT] = 100,
            [xi.mod.IMPACT_SDT] = 100,
            [xi.mod.HTH_SDT]    = 100,
            -- Reduced magic damage taken
            [xi.mod.FIRE_SDT]    = 500,
            [xi.mod.ICE_SDT]     = 500,
            [xi.mod.WIND_SDT]    = 500,
            [xi.mod.EARTH_SDT]   = 500,
            [xi.mod.THUNDER_SDT] = 500,
            [xi.mod.WATER_SDT]   = 500,
            [xi.mod.LIGHT_SDT]   = 500,
            [xi.mod.DARK_SDT]    = 500,
        },
    },
    {
        id          = GOB2,
        name        = "Gruflox Hognose",
        type        = xi.objType.MOB,
        look        = 716,
        groupId     = 40,
        groupZoneId = 188,
        area        = "Oldton_Movalpolos",
        pos         = { -143.254, 8.000, 154.562, 50 }, -- !pos -143.254 8.000 154.562 11
        level       = 80,
        jobSpecial  = true,
        mods        =
        {
            -- Vulnerable to blunt damage
            [xi.mod.SLASH_SDT]  = 100,
            [xi.mod.PIERCE_SDT] = 100,
            [xi.mod.IMPACT_SDT] = 1000,
            [xi.mod.HTH_SDT]    = 1000,
            -- Reduced magic damage taken
            [xi.mod.FIRE_SDT]    = 500,
            [xi.mod.ICE_SDT]     = 500,
            [xi.mod.WIND_SDT]    = 500,
            [xi.mod.EARTH_SDT]   = 500,
            [xi.mod.THUNDER_SDT] = 500,
            [xi.mod.WATER_SDT]   = 500,
            [xi.mod.LIGHT_SDT]   = 500,
            [xi.mod.DARK_SDT]    = 500,
        },
    },
    {
        id          = BAT1,
        name        = "Flapix Twofang",
        type        = xi.objType.MOB,
        look        = 256,
        groupId     = 11,
        groupZoneId = 12,
        area        = "Oldton_Movalpolos",
        pos         = { -143.104, 8.000, 157.410, 56 }, -- !pos -143.104 8.000 157.410 11
        level       = 80,
        mods        =
        {
            -- Vulnerable to piercing damage
            [xi.mod.SLASH_SDT]   = 100,
            [xi.mod.PIERCE_SDT]  = 1000,
            [xi.mod.IMPACT_SDT]  = 100,
            [xi.mod.HTH_SDT]     = 100,
            -- Reduced magic damage taken
            [xi.mod.FIRE_SDT]    = 500,
            [xi.mod.ICE_SDT]     = 500,
            [xi.mod.WIND_SDT]    = 500,
            [xi.mod.EARTH_SDT]   = 500,
            [xi.mod.THUNDER_SDT] = 500,
            [xi.mod.WATER_SDT]   = 500,
            [xi.mod.LIGHT_SDT]   = 500,
            [xi.mod.DARK_SDT]    = 500,
        },
    },
}

local function rollWeapon(player, weaponType)
    local aug1  = augs[1][math.random(1, #augs[1])]
    local aug1t = aug1[1]
    local aug1v = math.random(aug1[2], aug1[3])

    local aug2  = augs[2][math.random(1, #augs[2])]
    local aug2t = aug2[1]
    local aug2v = math.random(aug2[2], aug2[3])

    local ID = zones[player:getZoneID()]

    player:addItem(weaponType[2], 1, aug1t, aug1v, aug2t, aug2v)
    player:messageSpecial(ID.text.ITEM_OBTAINED, weaponType[2])
end

local function rollLoot(player, npc, delayVar, resetStep, boxID)
    if player:getFreeSlotsCount() < 5 then
        player:printToPlayer("Bagatrix : Hey, your hands are already lookin' pretty full there! Make some space...", xi.msg.channel.NS_SAY)
        return
    end

    npc:entityAnimationPacket("open")
    npc:timer(5000, function(npcArg)
        npcArg:entityAnimationPacket("close")
    end)

    local result = {}

    local poolReward = rewards.pooled[info.pattern[boxID]]

    table.insert(result, poolReward[math.random(1, #poolReward)])
    table.insert(result, rewards.food[math.random(1, #rewards.food)])
    table.insert(result, rewards.material[math.random(1, #rewards.material)])
    table.insert(result, rewards.material[math.random(1, #rewards.material)])

    local obtained = true

    for _, item in pairs(result) do
        if not npcUtil.giveItem(player, item[2]) then
            obtained = false
        end
    end

    local weaponType = rewards.weapons[math.random(1, #rewards.weapons)]
    rollWeapon(player, weaponType)

    local currency = math.random(7, 15)
    player:printToPlayer(string.format("%s gains %u gobbie grandeur.", player:getName(), currency), xi.msg.channel.SYSTEM_3)
    player:incrementCharVar("[CW]GAMBIT_GG", currency)

    -- We can be generous with this gil reward, as it's CW
    npcUtil.giveCurrency(player, 'gil', math.random(8000, 20000))

    -- If the player already has the cipher, or something else wrong, give cheeky goblin dialog to mitigate tickets
    if not obtained then
        player:printToPlayer("Bagatrix : Sorry, no refunds!", xi.msg.channel.NS_SAY)
    end

    player:setCharVar(delayVar, JstMidnight())
    player:setCharVar(info.var, resetStep)
    player:incrementCharVar("[CW]GAMBIT_COUNT", 1)
end

local boxReward = function(delayVar, resetStep, boxID)
    return function(player, npc, trade, entity, var, step)
        player:customMenu({
            title   = string.format("Take a chance with the %s?", npc:getPacketName()),
            options =
            {
                {
                    "Let me think about it.",
                    function()
                    end,
                },
                {
                    "This is the one!",
                    function(playerArg)
                        rollLoot(playerArg, npc, delayVar, resetStep, boxID)
                    end,
                },
            }
        })
    end
end

local function questAccepted(player, questName)
    player:printToPlayer(string.format("\129\158 Quest Accepted: %s", questName), xi.msg.channel.SYSTEM_3)
end

local gambitBegin = function(text, questName, delayVar, delayText)
    return function(player, npc, tbl, var, step)
        if os.time() < player:getCharVar(delayVar) then
            cexi.util.dialog(player, tbl.dialog[delayText], npc:getPacketName(), { npc = npc })
            return
        end

        cexi.util.dialog(player, tbl.dialog[text], npc:getPacketName(), { npc = npc })

        local delay = cexi.util.dialogDelay(tbl.dialog[text])

        player:timer(delay, function(playerArg)
            player:setCharVar(var, step)

            if questName ~= nil then
                questAccepted(player, questName)
            end
        end)
    end
end

-- Every game day, different chests will award ciphers, scrolls or attachments.
-- Players can co-operate to figure out which is which for the current day
m:addOverride("xi.zones.Oldton_Movalpolos.Zone.onGameDay", function()
    super()
    info.pattern = utils.shuffle(info.pattern)
end)

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function getGrandeur(player)
    local total = player:getCharVar("[CW]GAMBIT_GG")

    if total < 0 then
        return 0
    else
        return total
    end
end

local function purchaseWeapon(player, npc, item)
    local total = getGrandeur(player)

    if total < 50 then
        player:printToPlayer("Gambilox : " .. gambiloxDialog.DECLINED[1], xi.msg.channel.NS_SAY)
        return
    end

    if player:getFreeSlotsCount() < 1 then
        player:printToPlayer("Gambilox : ", gambiloxDialog.FULL[1], xi.msg.channel.NS_SAY)
        return
    end

    delaySendMenu(player, {
        title   = string.format("Roll a %s for %u GG?", item[1], item[3]),
        options =
        {
            {
                "Nope",
                function()
                end,
            },
            {
                "Let's do it",
                function()
                    npc:facePlayer(player, true)
                    player:printToPlayer("Gambilox : " .. gambiloxDialog.BOUGHT[1], xi.msg.channel.NS_SAY)
                    player:incrementCharVar("[CW]GAMBIT_GG", -50)

                    rollWeapon(player, item)
                end,
            },
        },
    })
end

local function confirmPurchase(player, npc, item)
    local total = getGrandeur(player)

    if total < item[3] then
        cexi.util.dialog(player, gambiloxDialog.DECLINED, npc:getPacketName(), { npc = npc })
        return
    end

    if player:getFreeSlotsCount() < 1 then
        cexi.util.dialog(player, gambiloxDialog.FULL, npc:getPacketName(), { npc = npc })
        return
    end

    if
        item[4] ~= nil and
        player:getCharVar(item[4]) > 0
    then
        cexi.util.dialog(player, { "Woah, woah, hold up. I already sold you one of those today!" }, npc:getPacketName(), { npc = npc })
        return
    end

    delaySendMenu(player, {
        title   = string.format("Buy %s for %u GG?", item[1], item[3]),
        options =
        {
            {
                "Nope",
                function()
                end,
            },
            {
                "I'll take it",
                function()
                    if npcUtil.giveItem(player, item[2]) then
                        npc:facePlayer(player, true)
                        player:printToPlayer("Gambilox : " .. gambiloxDialog.BOUGHT[1], xi.msg.channel.NS_SAY)
                        player:incrementCharVar("[CW]GAMBIT_GG", -(item[3]))

                        if item[4] ~= nil then
                            player:setCharVar(item[4], 1, JstMidnight())
                        end
                    end
                end,
            },
        },
    })
end

local shoppeTbl =
{
    {
        "Attachments",
        rewards.pooled[3]
    },
    {
        "Ciphers",
        rewards.pooled[1],
    },
    {
        "Scrolls",
        rewards.pooled[2],
    },
    {
        "Weapons",
        function(player, npc)
            local balance = player:getCharVar("[CW]GAMBIT_GG")
            player:printToPlayer("Gambilox : " .. gambiloxDialog.WEAPON[1], xi.msg.channel.NS_SAY)
            cexi.util.simpleShop(player, npc, rewards.weapons, purchaseWeapon, string.format("Select a Weapon (%u GG):", balance))
        end,
    },
    {
        "Misc.",
        function(player, npc)
            local balance = player:getCharVar("[CW]GAMBIT_GG")
            cexi.util.simpleShop(player, npc, miscRewards, confirmPurchase, fmt("Select an item ({} GG):", balance))
        end,
    },
    {
        "Upgrades",
        function(player, npc)
            cexi.util.dialog(player, gambiloxDialog.UPGRADE, npc:getPacketName(), { npc = npc } )
        end,
    }
}

local function getAugItem(trade, weapon)
    for i = 0, trade:getSlotCount() - 1 do
        if trade:getItemId(i) == weapon[2] then
            return trade:getItem(i)
        end
    end
end

local function increaseRoll(player, npc, trade, itemID, augItem, add0, add1)
    local aug0 = augItem:getAugment(0)
    local aug1 = augItem:getAugment(1)
    local ID   = zones[player:getZoneID()]

    player:tradeComplete()
    player:addItem(itemID, 1, aug0[1], aug0[2] + add0, aug1[1], aug1[2] + add1)
    npc:facePlayer(player, true)
    npc:independentAnimation(player, 12, 2)

    npc:timer(1000, function()
        player:messageSpecial(ID.text.ITEM_OBTAINED, itemID)
    end)
end

local function addAttribute(player, npc, trade, weapon)
    local augItem        = getAugItem(trade, weapon)
    local aug0           = augItem:getAugment(0)
    local attributeName  = attributeNames[aug0[1]]
    local attributeValue = aug0[2]
    local options        =
    {
        {
            "None",
            function()
            end,
        },
    }

    if attributeValue < 4 then
        table.insert(options, {
            string.format("Increase %s (15 GG)?", attributeName),
            function()
                local total = getGrandeur(player)

                if total < 15 then
                    player:printToPlayer("Gambilox : " .. gambiloxDialog.DECLINED[1], xi.msg.channel.NS_SAY)
                else
                    increaseRoll(player, npc, trade, weapon[2], augItem, 1, 0)
                    player:incrementCharVar("[CW]GAMBIT_GG", -15)
                end
            end,
        })
    end

    delaySendMenu(player, {
        title   = string.format("%s %s %u/5", weapon[1], attributeName, attributeValue + 1),
        options = options
    })
end

local function addStat(player, npc, trade, weapon)
    local augItem     = getAugItem(trade, weapon)
    local aug1        = augItem:getAugment(1)
    local statName    = statNames[aug1[1]]
    local statValue   = aug1[2]
    local options     =
    {
        {
            "None",
            function()
            end,
        },
    }

    if statValue < 4 then
        table.insert(options, {
            string.format("Increase %s (25 GG)?", statName),
            function()
                local total = getGrandeur(player)

                if total < 25 then
                    player:printToPlayer("Gambilox : " .. gambiloxDialog.DECLINED[1], xi.msg.channel.NS_SAY)
                else
                    increaseRoll(player, npc, trade, weapon[2], augItem, 0, 1)
                    player:incrementCharVar("[CW]GAMBIT_GG", -25)
                end
            end,
        })
    end

    delaySendMenu(player, {
        title   = string.format("%s %s %u/5", weapon[1], statName, statValue + 1),
        options = options
    })
end

local function increaseQuality(player, npc, trade, weapon)
end

-----------------------------------
-- Upgrade Items
-----------------------------------
local cost     = { 4, 8, 12, 16 }
local upgrades =
{
    {
        name = "Champion Belt",
        item = xi.item.CHAMPION_BELT,
        augs =
        {
            { 518, 0, 49, 0 }, -- CHR+1, Haste+1%
            { 518, 1, 49, 1 }, -- CHR+2, Haste+2%
            { 518, 2, 49, 2 }, -- CHR+3, Haste+3%
            { 518, 3, 49, 3 }, -- CHR+4, Haste+4%
        },
    },
    {
        name = "Moblinium Might",
        item = xi.item.MOBLINIUM_MIGHT,
        augs =
        {
            { 512, 0, 517, 0 }, -- STR+1, MND+1
            { 512, 1, 517, 1 }, -- STR+2, MND+2
            { 512, 2, 517, 2 }, -- STR+3, MND+3
            { 512, 3, 517, 3 }, -- STR+4, MND+4
        },
    },
    {
        name = "Moblin Mallet",
        item = xi.item.MOBLIN_MALLET,
        augs =
        {
            { 512, 0, 267, 0 }, -- STR+1, Club skill+1
            { 512, 1, 267, 1 }, -- STR+2, Club skill+2
            { 512, 2, 267, 2 }, -- STR+3, Club skill+3
            { 512, 3, 267, 3 }, -- STR+4, Club skill+4
        },
    },
    {
        name = "Warloq's Locket",
        item = xi.item.WARLOQS_LOCKET,
        augs =
        {
            { 40, 0, 54, 0 }, -- Enmity-1, Physical dmg.taken -1%
            { 40, 1, 54, 1 }, -- Enmity-2, Physical dmg.taken -2%
            { 40, 2, 54, 2 }, -- Enmity-3, Physical dmg.taken -3%
            { 40, 3, 54, 3 }, -- Enmity-4, Physical dmg.taken -4%
        },
    },
}

local function getAugTier(itemInfo, itemAug)
    local tier = 0

    for augTier = 1, #itemInfo.augs do
        if
            itemInfo.augs[augTier][1] == itemAug[1][1] and
            itemInfo.augs[augTier][2] == itemAug[1][2] and
            itemInfo.augs[augTier][3] == itemAug[2][1] and
            itemInfo.augs[augTier][4] == itemAug[2][2]
        then
            tier = augTier
        end
    end

    return tier
end

local function gambiloxOnTrade(player, npc, trade)
    for _, itemInfo in pairs(upgrades) do
        if npcUtil.tradeHas(trade, itemInfo.item, false) then
            local item = cexi.util.augment.getTradedItem(trade, itemInfo.item)
            local augs = cexi.util.augment.getAugments(player, item)
            local tier = 0

            if #augs > 0 then
                tier = getAugTier(itemInfo, augs)
            end

            if tier == 4 then
                cexi.util.dialog(player, gambiloxDialog.MOBLIN_FINISHED, npc:getPacketName(), { npc = npc })
                return
            end

            if cexi.util.tradeHasExactly(trade, itemInfo.item) then
                cexi.util.dialog(player, { fmt(gambiloxDialog.MOBLIN_UPGRADE[1], cost[tier + 1], itemInfo.name) }, npc:getPacketName(), { npc = npc })
                return
            end

            if npcUtil.tradeHasExactly(trade, { { itemInfo.item, 1 }, { xi.item.MOBLIN_MEDALLION, cost[tier + 1] } } ) then
                player:tradeComplete()
                cexi.util.dialog(player, gambiloxDialog.MOBLIN_UPGRADED, npc:getPacketName(), { npc = npc })
                npc:independentAnimation(player, 12, 2)

                player:addItem(itemInfo.item, 1, itemInfo.augs[tier + 1][1], itemInfo.augs[tier + 1][2], itemInfo.augs[tier + 1][3], itemInfo.augs[tier + 1][4])
                player:timer(100, function()
                    player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, itemInfo.item)
                end)
            end
        end
    end

    for baseWeapon, hqWeapon in pairs(weaponHQs) do
        if cexi.util.tradeHasExactly(trade, { baseWeapon, hqWeapon[2] }) then
            player:printToPlayer("Gambilox : " .. string.format(gambiloxDialog.TRANSFER[1], hqWeapon[1]), xi.msg.channel.NS_SAY)
            return
        end

        if npcUtil.tradeHasExactly(trade, { baseWeapon, hqWeapon[2], { 656, 12 } }) then
            player:printToPlayer("Gambilox : " .. gambiloxDialog.COMPLETE[1], xi.msg.channel.NS_SAY)
            cq.transferAugments(player, trade, baseWeapon, hqWeapon[2])
            npc:facePlayer(player, true)
            npc:independentAnimation(player, 12, 2)
            return
        end
     end

    for _, weapon in pairs(rewards.weapons) do
        if cexi.util.tradeHasExactly(trade, weapon[2]) then
            local balance = player:getCharVar("[CW]GAMBIT_GG")
            local options =
            {
                {
                    "None",
                    function()
                    end,
                },
                {
                    "Attribute+ (15 GG)",
                    function()
                        addAttribute(player, npc, trade, weapon)
                    end,
                },
                {
                    "Stat+ (25 GG)",
                    function()
                        addStat(player, npc, trade, weapon)
                    end,
                }

                -- TODO:
                --[[
                {
                    "Quality+ (120 GG)",
                    function()
                        increaseQuality(player, npc, trade, weapon)
                    end,
                },
                ]]
            }

            npc:facePlayer(player, true)
            player:printToPlayer("Gambilox : " .. string.format(gambiloxDialog.UPGRADING[1], weapon[1]), xi.msg.channel.NS_SAY)

            delaySendMenu(player, {
                title   = string.format("Upgrade %s (%u GG):", weapon[1], balance),
                options = options,
            })
        end
    end
end

local function gambiloxOnTrigger(player, npc)
    local total = getGrandeur(player)

    if total == 0 then
        cexi.util.dialog(player, gambiloxDialog.DEFAULT, npc:getPacketName(), { npc = npc })
        return
    end

    npc:facePlayer(player, true)
    player:printToPlayer("Gambilox : " .. gambiloxDialog.WELCOME[1], xi.msg.channel.NS_SAY)
    cexi.util.categoryMenu(player, npc, shoppeTbl, confirmPurchase, string.format("Gobbie Shoppe (%u GG):", total))
end

cexi.util.liveReload(m, {
    ["Oldton_Movalpolos"] = -- !pos -137.264 7.823, 123.875 11
    {
        {
            objtype   = xi.objType.NPC,
            name      = "Gambilox",
            look      = 702,
            x         = -137.264,
            y         = 7.823,
            z         = 123.875,
            rotation  = 107,
            onTrigger = gambiloxOnTrigger,
            onTrade   = gambiloxOnTrade,
        },
    },
})

local wave = { GOB1, GOB2, BAT1 }

local step =
{
    {
        check  = cq.checks({ CW = true, level = 65 }),
        [BAGA] = gambitBegin("START", info.name, "[CW]GAMBIT_DELAY", "DELAY"),
    },
    {
        [BAGA] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("ACCEPTED", "REMINDER", { { xi.item.GOLD_BEASTCOIN, 4 } }),
        },
    },
    {
        [BAGA] = cq.menuSpawn(wave, "Meet the gobs?", { { "Not yet." }, { "I'm ready.", "BATTLE" } }, 2, true, { levelCap = 75 } ),
        [GOB1] = cq.killStep(BAGA, wave, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "GOBLINS_GAMBIT", raise = 1 }),
        [GOB2] = cq.killStep(BAGA, wave, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "GOBLINS_GAMBIT", raise = 1 }),
        [BAT1] = cq.killStep(BAGA, wave, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "GOBLINS_GAMBIT", raise = 1 }),
    },
    {
        [BAGA] = cq.talkFinish("REWARD", info.name, cexi.music.MOVALPOLOS),
    },
    {
        [BAGA] = cq.talkOnly("REMINDER2"),
        [GOLD] = boxReward("[CW]GAMBIT_DELAY", 0, 1),
        [BLUE] = boxReward("[CW]GAMBIT_DELAY", 0, 2),
        [RED]  = boxReward("[CW]GAMBIT_DELAY", 0, 3),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
