-----------------------------------
-- Tonberry Trouble (Lv60+)
-----------------------------------
-- !setvar [CW]TONBERRY_TROUBLE 0
-- !setvar [CW]TONBERRY_TROUBLE_DELAY 0
-- !pos 299.888 -18.000 -497.900 124
-----------------------------------
-- !setvar [CW]TONBERRY_TROUBLE 1
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-tonberry_trouble")

local info =
{
    name     = "Tonberry Trouble",
    author   = "Loxley",
    var      = "[CW]TONBERRY_TROUBLE",
    delay    = "[CW]TONBERRY_TROUBLE_DELAY",
    points   = "[CW]TONBERRY_TOKENS",
}

local loot =
{
    {
        { cexi.rate.COMMON, xi.item.FIRE_CLUSTER      }, -- (15%) Fire Cluster
        { cexi.rate.COMMON, xi.item.ICE_CLUSTER       }, -- (15%) Ice Cluster
        { cexi.rate.COMMON, xi.item.WIND_CLUSTER      }, -- (15%) Wind Cluster
        { cexi.rate.COMMON, xi.item.EARTH_CLUSTER     }, -- (15%) Earth Cluster
        { cexi.rate.COMMON, xi.item.LIGHTNING_CLUSTER }, -- (15%) Lightning Cluster
        { cexi.rate.COMMON, xi.item.WATER_CLUSTER     }, -- (15%) Water Cluster
        { cexi.rate.COMMON, xi.item.LIGHT_CLUSTER     }, -- (15%) Light Cluster
        { cexi.rate.COMMON, xi.item.DARK_CLUSTER      }, -- (15%) Dark Cluster
    },
    {
        { cexi.rate.VERY_COMMON,  xi.item.DRAGON_CHRONICLES }, -- (24%) Dragon Chronicles
        { cexi.rate.COMMON,       4930 }, -- (15%) Katon: San
        { cexi.rate.COMMON,       4933 }, -- (15%) Hyoton: San
        { cexi.rate.COMMON,       4936 }, -- (15%) Huton: San
        { cexi.rate.COMMON,       4939 }, -- (15%) Doton: San
        { cexi.rate.COMMON,       4942 }, -- (15%) Raiton: San
        { cexi.rate.COMMON,       4945 }, -- (15%) Suiton: San
    },
    {
        { cexi.rate.VERY_COMMON,  1443 }, -- (24%) Dried Mugwort
        { cexi.rate.COMMON,       6302 }, -- (15%) Fuma Sh. Pouch
        { cexi.rate.UNCOMMON,     1162 }, -- (10%) Tonberry Lantern
        { cexi.rate.UNCOMMON,     1119 }, -- (10%) Tonberry Coat
        { cexi.rate.RARE,          915 }, -- ( 5%) Toad Oil
    },
    {
        { cexi.rate.VERY_COMMON,  2532 }, -- (24%) Teak Log
        { cexi.rate.COMMON,        700 }, -- (15%) Mahogany Log
        { cexi.rate.UNCOMMON,      702 }, -- (10%) Ebony Log
        { cexi.rate.UNCOMMON,      703 }, -- (10%) Petrified Log
        { cexi.rate.UNCOMMON,      721 }, -- (10%) Rattan Lumber
        { cexi.rate.RARE,          655 }, -- ( 5%) Adaman Ingot
    },
    {
        {            750,                         0 }, -- (75%) Nothing
        { cexi.rate.RARE, xi.item.AETHER_FRAGMENT   }, -- ( 5%) Aether Fragment
        { cexi.rate.RARE, xi.item.SAVAGE_SHIV       }, -- ( 5%) Savage Shiv
        { cexi.rate.RARE, xi.item.RADIANT_LANTERN   }, -- ( 5%) Radiant Lantern
        { cexi.rate.RARE, xi.item.BANDITS_EARRING   }, -- ( 5%) Bandit's Earring
        { cexi.rate.RARE, xi.item.MADOUSHI_SHURIKEN }, -- ( 5%) Madoushi Shuriken
    },
    {
        { cexi.rate.VERY_COMMON,   748 }, -- (24%) Gold Beastcoin
        { cexi.rate.COMMON,        750 }, -- (15%) Silver Beastcoin
    },
}

local cost     = { 300, 500, 800, 1200 }
local upgrades =
{
    {
        -- Accuracy-3 Haste+1%
        -- Enhances "Sneak Attack" effect (10%)
        -- WAR/DRK/SAM/RUN
        name = "Savage Shiv",
        id   = xi.item.SAVAGE_SHIV,
        tier =
        {
            { augs = { 25, 0, 31, 0         }, mats = { 724, 2 }, desc = "2 magnolia lumber" }, -- Attack+1, Evasion+1
            { augs = { 25, 1, 31, 1         }, mats = { 724, 3 }, desc = "3 magnolia lumber" }, -- Attack+2, Evasion+2
            { augs = { 25, 2, 31, 2         }, mats = { 724, 4 }, desc = "4 magnolia lumber" }, -- Attack+3, Evasion+3
            { augs = { 25, 3, 31, 3, 513, 1 }, mats = { 724, 6 }, desc = "6 magnolia lumber" }, -- Attack+4, Evasion+4, DEX+2
        },
    },
    {
        -- MP+40 Enmity-2
        -- Geomancy skill+2
        -- Enhances "Elemental Siphon" effect
        -- WHM/BLM/RDM/SMN/SCH/GEO
        name = "Radiant Lantern",
        id   = xi.item.RADIANT_LANTERN,
        tier =
        {
            { augs = { 516, 0, 517, 0         }, mats = { 1739, 2 }, desc = "2 balloon cloths" }, -- INT+1, MND+1
            { augs = { 516, 1, 517, 1         }, mats = { 1739, 3 }, desc = "3 balloon cloths" }, -- INT+2, MND+2
            { augs = { 516, 2, 517, 2         }, mats = { 1739, 4 }, desc = "4 balloon cloths" }, -- INT+3, MND+3
            { augs = { 516, 3, 517, 3, 112, 1 }, mats = { 1739, 6 }, desc = "6 balloon cloths" }, -- INT+4, MND+4, Pet: Damage taken -2%
        },
    },
    {
        -- Parrying Skill+5 Enmity+2
        -- Enhances "Mug" effect
        -- THF/BRD/NIN/DNC/RUN
        name = "Bandit's Earring",
        id   = xi.item.BANDITS_EARRING,
        tier =
        {
            { augs = { 31, 0, 515, 0          }, mats = { 1738, 2 }, desc = "2 shakudo ingots" }, -- Evasion+1, AGI+1
            { augs = { 31, 1, 515, 1          }, mats = { 1738, 3 }, desc = "3 shakudo ingots" }, -- Evasion+2, AGI+2
            { augs = { 31, 2, 515, 2          }, mats = { 1738, 4 }, desc = "4 shakudo ingots" }, -- Evasion+3, AGI+3
            { augs = { 31, 3, 515, 3, 1472, 1 }, mats = { 1738, 6 }, desc = "6 shakudo ingots" }, -- Evasion+4, AGI+4, Parrying rate+2%
        },
    },
    {
        -- DMG:80 Delay:192 Ranged Attack+8
        -- "Magic Attack Bonus"+6
        -- NIN
        name = "Madoushi Shuriken",
        id   = xi.item.MADOUSHI_SHURIKEN,
        tier =
        {
            { augs = { 17, 0, 516, 0        }, mats = { 677, 2 }, desc = "2 white steel" }, -- HP/MP+4,  INT+1
            { augs = { 17, 1, 516, 1        }, mats = { 677, 3 }, desc = "3 white steel" }, -- HP/MP+6,  INT+2
            { augs = { 17, 2, 516, 2        }, mats = { 677, 4 }, desc = "4 white steel" }, -- HP/MP+8,  INT+3
            { augs = { 17, 3, 516, 3, 35, 1 }, mats = { 677, 6 }, desc = "6 white steel" }, -- HP/MP+10, INT+4, Magic Acc +2
        },
    },
}

local function getAugTier(itemInfo, itemAug)
    local tier = 0

    for augTier = 1, #itemInfo.tier do
        if
            itemInfo.tier[augTier].augs[1] == itemAug[1][1] and
            itemInfo.tier[augTier].augs[2] == itemAug[1][2] and
            itemInfo.tier[augTier].augs[3] == itemAug[2][1] and
            itemInfo.tier[augTier].augs[4] == itemAug[2][2]
        then
            tier = augTier
        end
    end

    return tier
end

local function onTrade(player, npc, trade)
    local npcName = npc:getPacketName()

    for _, item in pairs(upgrades) do
        if npcUtil.tradeHas(trade, item.id, false) then
            local obj  = cexi.util.augment.getTradedItem(trade, item.id)
            local augs = cexi.util.augment.getAugments(player, obj)
            local tier = 0
            local next = 1

            if #augs > 0 then
                tier = getAugTier(item, augs)
                next = tier + 1
            end

            if tier == #item.tier then
                cexi.util.dialog(player, { fmt("...{}? Hmm... finished.", item.name) }, npcName, { npc = npc })
                return
            end

            if cexi.util.tradeHasExactly(trade, { { item.id, 1 }, item.tier[next].mats }) then
                local tokens = player:getCharVar(info.points)

                if tokens < cost[next] then
                    cexi.util.dialog(player, { fmt("... Tokens. {}... You. {}...", cost[next], tokens) }, npcName, { npc = npc })
                    return
                end

                player:tradeComplete()
                player:incrementCharVar(info.points, -cost[next])

                cexi.util.dialog(player, { "... Done." }, npcName, { npc = npc })

                local augInfo = item.tier[next].augs

                player:addItem(item.id, 1, augInfo[1], augInfo[2], augInfo[3], augInfo[4], augInfo[5], augInfo[6])
                player:timer(1000, function()
                    npc:independentAnimation(player, 12, 2)
                    player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, item.id)
                end)
            else
                local tbl =
                {
                    fmt("...{}? Upgrade... You...", item.name),
                    fmt(" {}... {} tokens...", item.tier[next].desc, cost[next]),
                }

                npc:facePlayer(player, true)
                cexi.util.dialog(player, tbl, npcName, { npc = npc })
            end
        end
    end
end


local SCRAWL         = "SCRAWL"
local RoughScrawl    = "Rough Scrawl"

local SOZU           = "SOZU"
local SozuBurberry   = "Sozu Burberry"

local SPIRIT         = "SPIRIT"
local TonberrySpirit = "Tonberry Spirit"

local COFFER         = "COFFER"
local TonberryCoffer = "Tonberry Coffer"

local spells =
{
    {
        element = xi.element.FIRE,
        cast    = 322, -- Katon:  San
        list    =
        {
            xi.weaponskill.WASP_STING,
            xi.weaponskill.VIPER_BITE,
            xi.weaponskill.BLADE_TEKI,
        },
    },
    {
        element = xi.element.ICE,
        cast    = 325, -- Hyoton: San
        list    =
        {
            xi.weaponskill.BURNING_BLADE,
            xi.weaponskill.RED_LOTUS_BLADE,
            xi.weaponskill.SKULLBREAKER,
            xi.weaponskill.TACHI_KAGERO,
            xi.weaponskill.FLAMING_ARROW,
            xi.weaponskill.DULLING_ARROW,
            xi.weaponskill.HOT_SHOT,
            xi.weaponskill.SNIPER_SHOT,
        },
    },
    {
        element = xi.element.WIND,
        cast    = 328, -- Huton:  San
        list    =
        {
            xi.weaponskill.FROSTBITE,
            xi.weaponskill.FREEZEBITE,
            xi.weaponskill.SHADOWSTITCH,
            xi.weaponskill.BLADE_RETSU,
            xi.weaponskill.BLADE_TO,
        },
    },
    {
        element = xi.element.EARTH,
        cast    = 331, -- Doton:  San
        list    =
        {
            xi.weaponskill.GUST_SLASH,
            xi.weaponskill.CYCLONE,
            xi.weaponskill.TACHI_JINPU,
            xi.weaponskill.GUILLOTINE,
            xi.weaponskill.GALE_AXE,
            xi.weaponskill.PIERCING_ARROW,
            xi.weaponskill.SPLIT_SHOT,
        },
    },
    {
        element = xi.element.THUNDER,
        cast    = 334, -- Raiton:  San
        list    =
        {
            xi.weaponskill.ROCK_CRUSHER,
            xi.weaponskill.EARTH_CRUSHER,
            xi.weaponskill.BLADE_CHI,
        },
    },
    {
        element = xi.element.WATER,
        cast    = 337, -- Suiton:  San
        list    =
        {
            xi.weaponskill.THUNDER_THRUST,
            xi.weaponskill.RAIDEN_THRUST,
            xi.weaponskill.LEG_SWEEP,
            xi.weaponskill.SMASH_AXE,
            xi.weaponskill.TACHI_HOBAKU,
            xi.weaponskill.TACHI_GOTEN,
            xi.weaponskill.SHOULDER_TACKLE,
        },
    },
}

for _, spell in pairs(spells) do
    spell.ws = {}

    for _, ws in pairs(spell.list) do
        spell.ws[ws] = true
    end
end

local sozuMessage =
{
    { 0,  "barely acknowledges you."      },
    { 1,  "finds you mildly annoying."    },
    { 3,  "regards you as a nuisance."    },
    { 5,  "grows weary of your presence." },
    { 10, "considers you a threat."       },
    { 20, "has made you a mortal enemy."  },
}

local function updateElement(mob)
    local roll = math.random(1, #spells)

    mob:setLocalVar("ELEMENT", roll)
    mob:castSpell(spells[roll].cast)

    return roll
end

local function wsTrigger(mob)
    mob:addListener('WEAPONSKILL_TAKE', 'WS_PROC_CHECK', function(target, user, wsid)
        local element = mob:getLocalVar("ELEMENT")

        if element == 0 then
            element = updateElement(mob)
        end

        if spells[element].ws[wsid] then
            local sent   = mob:getLocalVar("MESSAGE")
            local procs  = mob:getLocalVar("PROCS")
            local result = procs + 1

            for index, msg in pairs(sozuMessage) do
                if
                    result > msg[1] and
                    sent   < index
                then
                    user:printToArea(msg[2], xi.msg.channel.EMOTION, xi.msg.area.SAY, SozuBurberry)
                    mob:setLocalVar("MESSAGE", index)
                end
            end

            if sent == #sozuMessage then
                mob:setMod(xi.mod.UDMGPHYS,   2500)
                mob:setMod(xi.mod.UDMGRANGE,  2500)
                mob:setMod(xi.mod.UDMGMAGIC,  2500)
                mob:setMod(xi.mod.UDMGBREATH, 2500)
                mob:removeListener("WEAPONSKILL_TAKE")
            end

            mob:setLocalVar("PROCS", result)
            mob:weaknessTrigger(2)
            mob:addStatusEffectEx(xi.effect.TERROR, xi.effect.TERROR, 0, 0, 3)
            updateElement(mob)
        end
    end)
end

local adds =
{
    { "Lizard Illusion", 124,  6, xi.element.WATER   }, -- White_Lizard    (Fire)
    { "Coeurl Illusion", 124, 19, xi.element.EARTH   }, -- Master_Coeurl   (Lightning)
    { "Bee Illusion",    159, 37, xi.element.ICE     }, -- Temple_Bee      (Wind)
    { "Pugil Illusion",  160, 27, xi.element.THUNDER }, -- Den_of_Rancor   (Water)
    { "Beetle Illusion", 125, 12, xi.element.WIND    }, -- Desert_Beetle   (Earth)
    { "Ghost Illusion",  196, 39, xi.element.FIRE    }, -- Wandering_Ghost (Ice)
}

local addPos =
{
    { 306.772, -18.000, -511.679, 158 },
    { 310.984, -18.000, -511.925, 158 },
    { 312.234, -18.000, -507.244, 152 },
}

local function summonAdd(mob, target, percent, wave)
    local called = mob:getLocalVar("CALLED")

    if
        mob:getHPP() <= percent and
        called == wave and
        target ~= nil
    then
        if target:isPC() then
            local roll = adds[math.random(1, #adds)]
            cq.spawnAdd(mob, target, roll[1], 60, addPos[wave + 1], 63, 10000)
            target:printToArea("conjures an illusion!", xi.msg.channel.EMOTION, xi.msg.area.SAY, SozuBurberry)
            mob:setLocalVar("CALLED", called + 1)
        end
    end
end

local entity =
{
    {
        id     = SCRAWL,
        name   = RoughScrawl,
        marker = cq.SIDE_QUEST,
        area   = "Yhoator_Jungle",
        pos    = { 299.888, -18.000, -497.900,  63 }, -- !pos 299.888 -18.000 -497.900 124
        dialog =
        {
            DEFAULT = cq.NOTHING,
        },
    },
    {
        id      = SPIRIT,
        name    = TonberrySpirit,
        type    = xi.objType.NPC,
        look    = 1203,
        namevis = 0x80,  -- Ghost
        area    = "Yhoator_Jungle",
        pos     = { 378.933, -18.000, -540.583, 108 }, -- !pos 378.933 -18.000 -540.583 124
        dialog =
        {
            DEFAULT = { "This peculiar being does not notice your presence." },
        },
    },
    {
        id     = COFFER,
        name   = TonberryCoffer,
        type   = xi.objType.NPC,
        look   = 969,
        area   = "Yhoator_Jungle",
        pos    = { 299.888, -18.000, -497.900,  63 }, -- !pos 299.888 -18.000 -497.900 124
        hidden = true,
        dialog =
        {
            DEFAULT = { "It's locked." },
        },
    },
    {
        id          = "WYVERN",
        name        = "Wyvern Illusion",
        type        = xi.objType.MOB,
        groupId     = 21, -- Hurricane Wyvern
        groupZoneId = 205,
        area        = "Yhoator_Jungle",
        pos         = { 299.888, -18.000, -497.900,  63 }, -- !pos 299.888 -18.000 -497.900 124
        level       = 66,
        hp          = 15000,
        jobSpecial  = true,
        effects     =
        {
            [xi.effect.REGAIN]        = { 300, 0, 0 },
            [xi.effect.HUNDRED_FISTS] = {   1, 0, 0 },
        },

        onMobSpawn = function(mob)
            mob:addImmunity(xi.immunity.DARK_SLEEP)
            mob:addImmunity(xi.immunity.GRAVITY)
            mob:addImmunity(xi.immunity.LIGHT_SLEEP)
            mob:addImmunity(xi.immunity.PETRIFY)
            mob:addImmunity(xi.immunity.SILENCE)
            mob:addImmunity(xi.immunity.TERROR)

            mob:useMobAbility(624) -- Dust cloud
        end,

        onMobRoam = function(mob)
            mob:setHP(0)
        end,
    },
    {
        id          = SOZU,
        name        = SozuBurberry,
        type        = xi.objType.MOB,
        groupId     = 29, -- Tonberry_Stabber
        groupZoneId = 159,
        look        = 1204,
        area        = "Yhoator_Jungle",
        pos         = { 299.987, -18.000, -499.961,  63 }, -- !pos 299.987 -18.000 -499.961 124
        level       = 65,
        hp          = 15000,
        jobSpecial  = true,
        mods        =
        {
            [xi.mod.REGAIN]     = 10,
            [xi.mod.DELAY]      = -400,
            [xi.mod.UDMGPHYS]   = -5000,
            [xi.mod.UDMGRANGE]  = -5000,
            [xi.mod.UDMGMAGIC]  = -5000,
            [xi.mod.UDMGBREATH] = -5000,
        },

        onMobSpawn = function(mob)
            mob:addImmunity(xi.immunity.DARK_SLEEP)
            mob:addImmunity(xi.immunity.GRAVITY)
            mob:addImmunity(xi.immunity.LIGHT_SLEEP)
            mob:addImmunity(xi.immunity.PETRIFY)
            mob:addImmunity(xi.immunity.SILENCE)

            mob:setSpellList(0)

            wsTrigger(mob)
        end,

        onMobFight = function(mob, target)
            summonAdd(mob, target, 80, 0)
            summonAdd(mob, target, 60, 1)
            summonAdd(mob, target, 40, 2)
            summonAdd(mob, target, 20, 3)

            local called = mob:getLocalVar("CALLED")

            if
                mob:getHPP() <= 15 and
                target ~= nil
            then
                local dragons = mob:getLocalVar("DRAGONS")

                if dragons == 0 then
                    cq.spawnAdd(mob, target, "Wyvern Illusion", 60, { 300.830, -18.000, -537.390, 190 }, 64, 15000)
                    mob:setLocalVar("DRAGONS", 1)
                end
            end
        end,
    },
}

for _, mobInfo in pairs(adds) do
    table.insert(entity, {
        id          = string.upper(mobInfo[1]),
        name        = mobInfo[1],
        type        = xi.objType.MOB,
        groupId     = mobInfo[3],
        groupZoneId = mobInfo[2],
        namevis     = 0x80,  -- Ghost
        area        = "Yhoator_Jungle",
        pos         = { 299.888, -18.000, -497.900,  63 }, -- !pos 299.888 -18.000 -497.900 124
        level       = 63,
        hp          = 10000,
        mods        =
        {
            [xi.mod.REGAIN] = 1000,
        },

        onMobSpawn  = function(mob)
            mob:addListener("MAGIC_TAKE", "MAGIC_PROC", function(target, caster, spell)
                if spell:getElement() == mobInfo[4] then
                    mob:weaknessTrigger(1)
                    mob:setHP(0)
                end
            end)
        end,

        onMobRoam   = function(mob)
            mob:setHP(0)
        end,
    })
end

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function sozuDialog(tbl)
    return cq.npcSpawner(tbl, TonberrySpirit, RoughScrawl, true)
end

local function rollLoot()
    return function(player, npc, tbl)
        -- Guard against players spamming click
        if player:getLocalVar("LOOT_ROLLED") ~= 0 then
            return
        end

        if player:getFreeSlotsCount() < #loot then
            player:fmt("You do not have enough inventory space to continue.")
            return
        end

        player:setLocalVar("LOOT_ROLLED", 1)

        local tbl =
        {
            { spawn = { TonberryCoffer } },
            { delay = 2000 },
            { entity = TonberryCoffer, packet = "open" },
            { delay = 5000 },
            { despawn = { TonberryCoffer } },
        }

        cexi.util.dialog(player, tbl, "", { npc = npc })

        local delay = cexi.util.dialogDelay(tbl)

        player:timer(delay, function()
            for _, pool in pairs(loot) do
                local result = cexi.util.pickItem(pool)

                if result[2] > 0 then
                    npcUtil.giveItem(player, result[2])
                end
            end

            player:setCharVar(info.delay, 1, JstMidnight())
            player:setCharVar(info.var, 0)
            player:setLocalVar("LOOT_ROLLED", 0)
        end)
    end
end

local shopOnly =
{
    checks    = { gt = { info.points, 0 } },
    onTrigger = cq.shop({
        var    = info.points,
        title  = "Choose a reward... ({} tokens)",
        dialog = { "The Tonberry beckons you to take something." },
        list   =
        {
            { "Silver Beastcoin x12", { {  750, 12 } },           200 },
            { "Gold Beastcoin x12",   { {  748, 12 } },           300 },
            { "Antacid x12",          { { 4153, 12 } },           500 },
            { "Koga Cabinet",         "[EB]NINJUTSU",            2000, "You have unlocked the Ninjutsu expansion for the Ephemeral Box!" },
            { "Chef's Pantry",        "[EB]FOOD",                3000, "You have unlocked the Food expansion for the Ephemeral Box!"     },
            { "Aether Fragment",      xi.item.AETHER_FRAGMENT,   3000 },
            { "Savage Shiv",          xi.item.SAVAGE_SHIV,       5000 },
            { "Radian Lantern",       xi.item.RADIANT_LANTERN,   5000 },
            { "Bandit's Earring",     xi.item.BANDITS_EARRING,   5000 },
            { "Madoushi Shuriken",    xi.item.MADOUSHI_SHURIKEN, 5000 },
            { "Cipher: Aldo",         10126,                     5000 },
            { "Cipher: Tenzen",       10114,                     7000 },
        },
    }),
    onTrade   = onTrade,
}

local step =
{
    {
        [SCRAWL] =
        {
            check = cq.checks({ CW = true, level = 60, zero = info.delay }),
            onTrigger = cq.dialog({
                step  = false,
                event =
                {
                    "You see a barely legible scrawl written in a strange dialect:",
                    " tAKe oFFeRIng BEaSTcoIN MyT...",
                },
            }),
            onTrade = cq.trade({
                required = { { 749, 4 } },
                accepted =
                {
                    "You feel like somebody is watching."
                },
                declined =
                {
                    "Nothing happens."
                },
            }),
        },
        [SPIRIT] = shopOnly,
    },
    {
        [SCRAWL] = cq.menu({
            title        = "Are you prepared?",
            spawn        = { SOZU },
            levelCap     = 60,
            raiseAllowed = true,
            options      =
            {
                {
                    "Not yet",
                },
                {
                    "I'm ready!",
                    true,
                },
            },
        }),
        [SOZU] = cq.killStep(SCRAWL, { SOZU }, nil, {
            pointsVar  = info.points,
            points     = 32,
            message    = "{} gains {} tonberry tokens.",
            multiplier =
            {
                var   = "PROCS",
                range = { 120, 450 },
            },
        }),
        [SPIRIT] = shopOnly,
    },
    {
        [SCRAWL] = rollLoot(),
        [SPIRIT]      = shopOnly,
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
