-----------------------------------
-- Featherweight (Lv50)
-----------------------------------
-- !setvar [CW]ARENA 0
-- Yagudo Outlaw !pos -166.503 -17.181 77.725 151
-- !additem 1530
-- !additem 1535
-- Reward: 500
-----------------------------------
-- !setvar [CW]ARENA 2
-- Yagudo Outlaw !pos -166.503 -17.181 77.725 151
-- !additem 750 12
-- Yagudo Stash  !pos 638.559 -24.000 -77.644 119
-----------------------------------
-- !setvar [CW]ARENA 4

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-featherweight")

local info =
{
    name   = "Featherweight",
    author = "Loxley",
    var    = "[CW]ARENA",
    points = "[CW]ARENA_POINTS",
    reward =
    {
        gil = 500,
    },

    required =
    {
        seven_knot       = 1530,
        thirteen_knot    = 1535,
        silver_beastcoin = 750,
    },
}

local upgrades =
{
    ["Shinobi Hachigane +1"]   = { 12460, 13844 },
    ["Shinobi Gi +1"]          = { 12588, 13733 },
    ["Shinobi Tekko +1"]       = { 12716, 13955 },
    ["Shinobi Hakama +1"]      = { 12844, 12925 },
    ["Shinobi Kyahan +1"]      = { 12972, 14082 },

    ["White Cloak +1"]         = { 12611, 12651 },
    ["Mage's Mitts"]           = { 12739, 12794 },
    ["White Slacks +1"]        = { 12867, 12926 },
    ["Moccasins +1"]           = { 12995, 13050 },

    ["Mythril Sallet +1"]      = { 12417, 13847 },
    ["Mythril Breastplate +1"] = { 12545, 13737 },
    ["Mythril Gauntlets +1"]   = { 12673, 13958 },
    ["Mythril Cuisses +1"]     = { 12801, 14211 },
    ["Mythril Leggings +1"]    = { 12929, 14086 },

    ["Dino Helm"]              = { 12444, 13835 },
    ["Dino Jerkin"]            = { 12572, 13727 },
    ["Dino Gloves"]            = { 12700, 12795 },
    ["Dino Trousers"]          = { 12828, 12919 },
    ["Dino Ledelsens"]         = { 12956, 13049 },
}

local OUTLAW         = "OUTLAW"
local OUTLAW_OUTSIDE = "OUTLAW_OUTSIDE"
local YagudoOutlaw   = "Yagudo Outlaw"

local FENCE          = "FENCE"
local YagudoFence    = "Yagudo Fence"

local TRACKS         = "TRACKS"
local STASH          = "STASH"
local OutlawsStash   = "Outlaw's Stash"

local B1_YAG1        = "B1_YAG1"
local B1_YAG2        = "B1_YAG2"
local B1_YAG3        = "B1_YAG3"

local B2_YAG1        = "B2_YAG1"
local B2_YAG2        = "B2_YAG2"

local B3_YAG1        = "B3_YAG1"

local B4_YAG1        = "B4_YAG1"
local B4_MON1        = "B4_MON1"
local B4_MON2        = "B4_MON2"

local B5_YAG1        = "B5_YAG1"
local B5_YAG2        = "B5_YAG2"

local POS_LEFT   = { 640.096, -23.876, -73.490, 55 } -- !pos 640.096, -23.876, -73.490 119
local POS_MIDDLE = { 646.004, -24.257, -76.733, 106 } -- !pos 646.004 -24.257 -76.733 119
local POS_RIGHT  = { 643.500, -23.976, -73.564, 90 } -- !pos 643.500 -23.976 -73.564 119

local entity =
{
    {
        id     = OUTLAW,
        name   = YagudoOutlaw,
        type   = xi.objType.NPC,
        look   = 592,
        area   = "Castle_Oztroja",
        pos    = { -166.503, -17.181, 77.725, 164 }, -- !pos -166.503 -17.181 77.725 151
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "What's this!? *Squark* You be leaving now!" },
            START    =
            {
                "*Squark*! You want secrets? First earns trust!",
                "You gives us seven-knot quipu and thirteen-knot quipu!",
            },
            ACCEPTED =
            {
                "Goo~d... smoothskin did well!",
                { delay = 1000 },
                { message = "You have unlocked the Yagudo Arena in Meriphataud Mountains!" },
                { delay = 1000 },
                "You brings us tribute! 4 silver coin and yous face Yagudo strongest!",
                "Glory, honor, prizes! *Squark* E~very week Meriphataud Mountains arena match!",
            },
            REMINDER2 =
            {
                "You brings us tribute! 4 silver coin and you faces Yagudo strongest!",
                "Glory, honor, prizes! *Squark* E~very week Meriphataud Mountains arena match!",
            },
            ACCEPTED2 = { "Goo~d goo~d. You come Meriphataud Mountains. We fights." },
            DECLINED  = { "What's this!? *Squark* You be leaving now!" },

            REWARD =
            {
                "You takes one reward... That makes %u wins for yooou~ but we win next!",
            },
        },
    },
    {
        id     = FENCE,
        name   = YagudoFence,
        type   = xi.objType.NPC,
        look   = 591,
        area   = "Castle_Oztroja",
        pos    = { -164.283, -16.320, 80.107, 151 }, -- -164.283 -16.320 80.107 151
        dialog = {},
    },
    {
        id       = TRACKS,
        name     = "Yagudo Tracks",
        marker   = cq.MAIN_QUEST,
        hidename = true,
        area     = "Meriphataud_Mountains",
        pos      = { 636.735, -24.000, -82.146, 0 }, -- !pos 636.735 -24.000 -82.146 119
        dialog   =
        {
            NAME     = false,
            DEFAULT  = { "Nothing happens." },
            START    =
            {
                { spawn   = { YagudoOutlaw } },
                { delay   = 3000 },
                "Yagudo Outlaw : You pay tribute but are~ you prepared? Ghahwaha *Squark*",
                { delay   = 3000 },
                { despawn = { YagudoOutlaw } },
            },

            AFTER =
            {
                { despawn = { "Yagudo_Tracks" } },
                { spawn   = { "Yagudo_Outlaw", OutlawsStash } },
                { delay   = 3000 },
                { removeEffect = xi.effect.LEVEL_RESTRICTION },
                "Yagudo Outlaw : Bahh!! Smoothskin wins this time!",
                { entity = "Outlaw's Stash", packet = "open" },
                { delay = 6000 },
                { despawn = { "Yagudo_Outlaw", "Yagudo_Watcher", OutlawsStash } },
                { spawn   = { "Yagudo_Tracks" } },
            },
        },
    },

    {
        id       = OUTLAW_OUTSIDE,
        name     = YagudoOutlaw,
        type     = xi.objType.NPC,
        hidden   = true,
        notarget = true,
        look     = 592,
        area     = "Meriphataud_Mountains",
        pos      = { 639.785, -24.000, -78.751, 90 }, -- !pos 639.785 -24.000 -78.751 119
    },

    {
        id       = STASH,
        name     = OutlawsStash,
        type     = xi.objType.NPC,
        hidden   = true,
        notarget = true,
        look     = 968,
        area     = "Meriphataud_Mountains",
        pos      = { 638.559, -24.000, -77.644, 90 }, -- !pos 638.559 -24.000 -77.644 119
    },

    -----------------------------------
    -- Terrible Trio
    -----------------------------------
    {
        id          = B1_YAG1,
        name        = "Yagudo Heretic",
        type        = xi.objType.MOB,
        look        = 589,
        flags       = 592, -- BLM
        groupId     = 24,
        groupZoneId = 119,
        area        = "Meriphataud_Mountains",
        pos         = POS_LEFT, -- !pos 640.096, -23.876, -73.490 119
        level       = 55,
        jobSpecial  = true,
        loot        =
        {
            { cexi.rate.COMMON,      4128 }, -- Ether           (15%)
            { cexi.rate.UNCOMMON,     498 }, -- Yagudo Necklace (10%)
            { cexi.rate.RARE,         749 }, -- Mtl. Beastcoin  ( 5%)
        },
    },
    {
        id          = B1_YAG2,
        name        = "Yagudo Exile",
        type        = xi.objType.MOB,
        look        = 581, -- MNK
        flags       = 592,
        groupId     = 21,
        groupZoneId = 119,
        area        = "Meriphataud_Mountains",
        pos         = POS_MIDDLE, -- !pos 646.004 -24.257 -76.733 119
        level       = 55,
        jobSpecial  = true,
        loot        =
        {
            { cexi.rate.UNCOMMON,   16388 }, -- Himantes        (10%)
            { cexi.rate.UNCOMMON,     498 }, -- Yagudo Necklace (10%)
            { cexi.rate.RARE,         749 }, -- Mtl. Beastcoin  ( 5%)
        },
    },
    {
        id          = B1_YAG3,
        name        = "Yagudo Paraiah",
        type        = xi.objType.MOB,
        look        = 587, -- NIN
        flags       = 592,
        groupId     = 36,
        groupZoneId = 119,
        area        = "Meriphataud_Mountains",
        pos         = POS_RIGHT, -- !pos 643.500 -23.976 -73.564 119
        level       = 54,
        jobSpecial  = true,
        loot        =
        {
            { cexi.rate.COMMON,     17301 }, -- Shuriken        (15%)
            { cexi.rate.UNCOMMON,     498 }, -- Yagudo Necklace (10%)
            { cexi.rate.RARE,         749 }, -- Mtl. Beastcoin  ( 5%)
        },
    },

    -----------------------------------
    -- Deadly Duo
    -----------------------------------
    {
        id          = B2_YAG1,
        name        = "Yagudo Shinobi",
        type        = xi.objType.MOB,
        look        = 587, -- NIN
        flags       = 592,
        groupId     = 36,
        groupZoneId = 119,
        area        = "Meriphataud_Mountains",
        pos         = POS_LEFT, -- !pos 640.096, -23.876, -73.490 119
        level       = 56,
        jobSpecial  = true,
        mods        =
        {
            [xi.mod.ATTP]  = 50,
            [xi.mod.DELAY] = -200,
        },
        aeffect     = xi.mob.ae.ENTHUNDER,
        loot        =
        {
            { cexi.rate.COMMON,     17304 }, -- Fuma Shuriken   (15%)
            { cexi.rate.UNCOMMON,     498 }, -- Yagudo Necklace (10%)
            { cexi.rate.RARE,         749 }, -- Mtl. Beastcoin  ( 5%)
        },
    },
    {
        id          = B2_YAG2,
        name        = "Yagudo Kunoichi",
        type        = xi.objType.MOB,
        look        = 587, -- NIN
        flags       = 592,
        groupId     = 36,
        groupZoneId = 119,
        area        = "Meriphataud_Mountains",
        pos         = POS_RIGHT, -- !pos 643.500 -23.976 -73.564 119
        level       = 56,
        jobSpecial  = true,
        mods        =
        {
            [xi.mod.FASTCAST] = 30,
            [xi.mod.MATT]     = 30,
        },
        loot        =
        {
            { cexi.rate.COMMON,     17304 }, -- Fuma Shuriken   (15%)
            { cexi.rate.UNCOMMON,     498 }, -- Yagudo Necklace (10%)
            { cexi.rate.RARE,         749 }, -- Mtl. Beastcoin  ( 5%)
        },
    },

    -----------------------------------
    -- Outstanding One
    -----------------------------------
    {
        id          = B3_YAG1,
        name        = "Yagudo Pugilist",
        type        = xi.objType.MOB,
        look        = 581, -- MNK
        flags       = 592,
        groupId     = 21,
        groupZoneId = 119,
        area        = "Meriphataud_Mountains",
        pos         = POS_MIDDLE, -- !pos 646.004 -24.257 -76.733 119
        level       = 60,
        jobSpecial  = true,
        aeffect     = xi.mob.ae.ENAERO,
        loot        =
        {
            { cexi.rate.UNCOMMON,     498 }, -- Yagudo Necklace (10%)
            { cexi.rate.RARE,         749 }, -- Mtl. Beastcoin  ( 5%)
            { cexi.rate.RARE,       18353 }, -- Adargas         ( 5%)
        },
    },

    -----------------------------------
    -- Mighty Monster-tamer
    -----------------------------------
    {
        id          = B4_YAG1,
        name        = "Yagudo Wildling",
        type        = xi.objType.MOB,
        look        = 581, -- MNK
        flags       = 592,
        groupId     = 21,
        groupZoneId = 119,
        area        = "Meriphataud_Mountains",
        pos         = POS_MIDDLE, -- !pos 646.004 -24.257 -76.733 119
        level       = 56,
        jobSpecial  = true,
        loot        =
        {
            { cexi.rate.UNCOMMON,    4377 }, -- Coeurl Meat    (10%)
            { cexi.rate.RARE,         863 }, -- Coeurl Hide    ( 5%)
            { cexi.rate.RARE,         749 }, -- Mtl. Beastcoin ( 5%)
        },
    },
    {
        id          = B4_MON1,
        name        = "Frost Raptor",
        type        = xi.objType.MOB,
        flags       = 592,
        groupId     = 30, -- Daggerclaw Dracos
        groupZoneId = 119,
        area        = "Meriphataud_Mountains",
        pos         = POS_LEFT, -- !pos 640.096, -23.876, -73.490 119
        level       = 52,
        jobSpecial  = true,
        aeffect     = xi.mob.ae.ENBLIZZARD,
        loot        =
        {
            { cexi.rate.VERY_COMMON, 853 }, -- Raptor Skin (24%)
            { cexi.rate.RARE,        936 }, -- Rock Salt   ( 5%)
        },
    },
    {
        id          = B4_MON2,
        name        = "Flame Raptor",
        type        = xi.objType.MOB,
        look        = 1938,
        flags       = 592,
        groupId     = 30, -- Daggerclaw Dracos
        groupZoneId = 119,
        area        = "Meriphataud_Mountains",
        pos         = POS_RIGHT, -- !pos 643.500 -23.976 -73.564 119
        level       = 52,
        jobSpecial  = true,
        aeffect     = xi.mob.ae.ENFIRE,
        loot        =
        {
            { cexi.rate.VERY_COMMON,  853 }, -- Raptor Skin (24%)
            { cexi.rate.RARE,        1108 }, -- Sulfur      ( 5%)
        },
    },

    -----------------------------------
    -- Serpent Singers
    -----------------------------------
    {
        id          = B5_YAG1,
        name        = "Yagudo Flutist",
        type        = xi.objType.MOB,
        look        = 592, -- BRD
        flags       = 592,
        groupId     = 151,
        groupZoneId = 26,
        area        = "Meriphataud_Mountains",
        pos         = POS_LEFT, -- !pos 640.096, -23.876, -73.490 119
        level       = 56,
        jobSpecial  = true,
        loot        =
        {
            { cexi.rate.COMMON,       917 }, -- Parchment      (15%)
            { cexi.rate.RARE,         749 }, -- Mtl. Beastcoin ( 5%)
            { cexi.rate.RARE,       17350 }, -- Angel's Flute  ( 5%)
        },
    },
    {
        id          = B5_YAG2,
        name        = "Yagudo Charmer",
        type        = xi.objType.MOB,
        look        = 581, -- MNK
        flags       = 592,
        groupId     = 151,
        groupZoneId = 26,
        area        = "Meriphataud_Mountains",
        pos         = POS_RIGHT, -- !pos 643.500 -23.976 -73.564 119
        level       = 56,
        jobSpecial  = true,
        loot        =
        {
            { cexi.rate.COMMON,       917 }, -- Parchment      (15%)
            { cexi.rate.RARE,         749 }, -- Mtl. Beastcoin ( 5%)
            { cexi.rate.RARE,       17345 }, -- Flute          ( 5%)
        },
    },
}

-- Rewards:
-- 1 Colored rock
-- 3-4 Items from junk
-- 2-3 Unaugmented armor pieces

local rocks =
{
    [xi.element.FIRE   ] = xi.item.RED_ROCK,
    [xi.element.ICE    ] = xi.item.TRANSLUCENT_ROCK,
    [xi.element.WIND   ] = xi.item.GREEN_ROCK,
    [xi.element.EARTH  ] = xi.item.YELLOW_ROCK,
    [xi.element.THUNDER] = xi.item.PURPLE_ROCK,
    [xi.element.WATER  ] = xi.item.BLUE_ROCK,
    [xi.element.LIGHT  ] = xi.item.WHITE_ROCK,
    [xi.element.DARK   ] = xi.item.BLACK_ROCK,
}

local ores =
{
    [xi.element.FIRE   ] = xi.item.FIRE_ORE,
    [xi.element.ICE    ] = xi.item.ICE_ORE,
    [xi.element.WIND   ] = xi.item.WIND_ORE,
    [xi.element.EARTH  ] = xi.item.EARTH_ORE,
    [xi.element.THUNDER] = xi.item.THUNDER_ORE,
    [xi.element.WATER  ] = xi.item.WATER_ORE,
    [xi.element.LIGHT  ] = xi.item.LIGHT_ORE,
    [xi.element.DARK   ] = xi.item.DARK_ORE,
}

local junk =
{
    { cexi.rate.VERY_COMMON, 841                     }, -- Yagudo Feather        (24%)
    { cexi.rate.COMMON,      xi.item.ARENA_TOKEN     }, -- Arena Token           (15%)
    { cexi.rate.RARE,        656                     }, -- Beastcoin             ( 5%)
    { cexi.rate.RARE,        4155                    }, -- Remedy                ( 5%)
    { cexi.rate.RARE,        4132                    }, -- Hi-Ether              ( 5%)
    { cexi.rate.RARE,        4116                    }, -- Hi-Potion             ( 5%)
    { cexi.rate.RARE,        4558                    }, -- Yagudo Drink          ( 5%)
    { cexi.rate.RARE,        498                     }, -- Yagudo Bead Necklace  ( 5%)
    { cexi.rate.RARE,        xi.item.AETHER_FRAGMENT }, -- Aether Fragment       ( 5%)
    { cexi.rate.RARE,        xi.item.ARCANE_ARBALEST }, -- Arcane Arbalest       ( 5%)
    { cexi.rate.RARE,        xi.item.OUTLAWS_EARRING }, -- Outlaw's Earring      ( 5%)
    { cexi.rate.RARE,        xi.item.TALON_TATHLUM   }, -- Talon Tathlum         ( 5%)
    { cexi.rate.RARE,        xi.item.EXILES_CLOAK    }, -- Exile's Cloak         ( 5%)
    { cexi.rate.RARE,        6297                    }, -- Juji Shuriken Pouch   ( 5%)
    { cexi.rate.RARE,        6298                    }, -- Manji Shuriken Pouch  ( 5%)
    { cexi.rate.VERY_RARE,   17302                   }, -- Juji Shuriken         ( 1%)
    { cexi.rate.VERY_RARE,   17303                   }, -- Manji Shuriken        ( 1%)
    { cexi.rate.VERY_RARE,   4704                    }, -- Auspice               ( 1%)
    { cexi.rate.VERY_RARE,   4743                    }, -- Reraise               ( 1%)
    { cexi.rate.VERY_RARE,   4953                    }, -- Hojo: Ni              ( 1%)
    { cexi.rate.VERY_RARE,   4956                    }, -- Kurayami: Ni          ( 1%)
    { cexi.rate.VERY_RARE,   4962                    }, -- Tonko: Ni             ( 1%)
    { cexi.rate.VERY_RARE,   5020                    }, -- Gold Capriccio        ( 1%)
    { cexi.rate.VERY_RARE,   4980                    }, -- Foe Requiem V         ( 1%)
    { cexi.rate.VERY_RARE,   5030                    }, -- Carnage Elegy         ( 1%)
    { cexi.rate.VERY_RARE,   4764                    }, -- Aero III              ( 1%)
    { cexi.rate.VERY_RARE,   4816                    }, -- Tornado               ( 1%)
    { cexi.rate.VERY_RARE,   4898                    }, -- Air Spirit Pact       ( 1%)
    { cexi.rate.VERY_RARE,   748                     }, -- Gold Beastcoin        ( 1%)
}

local armorLoot =
{
    12460, -- Shinobi Hachigane
    12588, -- Shinobi Gi
    12716, -- Shinobi Tekko
    12844, -- Shinobi Hakama
    12972, -- Shinobi Kyahan
    12611, -- White Cloak
    12739, -- Black Mitts
    12867, -- White Slacks
    12995, -- Moccasins
    12417, -- Mythril Sallet
    12545, -- Mythril Breastplate
    12673, -- Mythril Gauntlets
    12801, -- Mythril Cuisses
    12929, -- Mythril Leggings
    12444, -- Raptor Helm
    12572, -- Raptor Jerkin
    12700, -- Raptor Gloves
    12828, -- Raptor Trousers
    12956, -- Raptor Ledelsens
}

local yags =
{
    { 633.498, -24.237, -71.526,  39 },
    { 636.051, -23.743, -70.844,  57 },
    { 638.321, -23.725, -70.472,  57 },
    { 641.132, -23.787, -70.558,  67 },
    { 643.656, -23.961, -23.961,  82 },
    { 643.408, -23.940, -71.025,  80 },

    { 645.565, -26.141, -71.698,  94 },
    { 647.493, -25.477, -73.557, 107 },
    { 648.974, -24.945, -75.950, 120 },
    { 649.262, -25.038, -78.295, 128 },
    { 649.006, -24.939, -80.437, 138 },
    { 648.585, -24.784, -82.514, 143 },
    { 647.910, -24.610, -84.618, 147 },
    { 647.237, -24.776, -86.741, 153 },
    { 646.004, -25.175, -88.694, 154 },
}

local yagudoModels =
{
    585, -- Zealot
    593, -- Lutenist
    592, -- Drummer
    596, -- Oracle
    599, -- Interrogator
}

local function rollRewards(text, countVar, battleVar)
    return function(player, npc, entity)
        if player:getFreeSlotsCount() < 5 then
            player:sys("You don't have enough inventory space.")
            return
        end

        -- Update current step immediately so players can't spam this
        player:setCharVar(info.var, 2)
        player:setLocalVar(battleVar, 0)


        -- Display NPC event
        cexi.util.dialog(player, entity.dialog[text], "", { npc = npc })

        npc:timer(5000, function()
            local result = {}
            local rolls = math.random(1, 2)

            for i = 1, rolls do
                table.insert(result, armorLoot[math.random(1, #armorLoot)])
            end

            table.insert(result, cexi.util.pickItem(junk)[2])
            table.insert(result, cexi.util.pickItem(junk)[2])

            if math.random(0, 100) < 15 then
                table.insert(result, ores[VanadielDayElement()])
            else
                table.insert(result, rocks[VanadielDayElement()])
            end

            -- Distribute points and increment wins
            local roll = math.random(100, 120)
            player:incrementCharVar("[CW]ARENA_WINS", 1)
            player:incrementCharVar(info.points, roll)
            player:sys("{} gains {} arena points.", player:getName(), roll)

            cexi.util.giveItem(player, result)
        end)
    end
end

m:addOverride("xi.zones.Meriphataud_Mountains.Zone.onInitialize", function(zone)
    super(zone)

    for k, v in pairs(yags) do
        local watcher = zone:insertDynamicEntity({
            id       = "WATCHER",
            name     = "Yagudo Watcher",
            type     = xi.objType.NPC,
            hidden   = true,
            look     = yagudoModels[math.random(1, #yagudoModels)],
            area     = "Meriphataud_Mountains",
            x        = v[1],
            y        = v[2],
            z        = v[3],
            rotation = v[4],
        })

        watcher:hideName(true)
        watcher:setUntargetable(true)
        watcher:setStatus(xi.status.DISAPPEAR)
    end
end)

local delaySendMenu = function(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local trade1    = { info.required.seven_knot, info.required.thirteen_knot }
local trade2    = { { info.required.silver_beastcoin, 4 } }
local outlawPos = { -169.077, -16.283,  82.198,  35, 151 }
local arenaPos  = {  641.793, -24.286, -85.110, 205, 119 }

local battles =
{
    {
        helper   = xi.item.DRAGON_CHRONICLES,
        cooldown = "[CW]ARENA_REPEAT",
        wave     =
        {
            B1_YAG1,
            B1_YAG2,
            B1_YAG3,
        },
        setLocal =
        {
            var = "[CW]ARENA_BATTLE",
            val = 1,
        },
        dialog  = "Announcer : Introducing... the Terrible Trio of Tahrongi! From the dangerous dusty valley, these three bring their stunning combined forces!",
        channel = xi.msg.channel.NS_SHOUT,
        raise   = 1,
    },
    {
        helper   = xi.item.DRAGON_CHRONICLES,
        cooldown = "[CW]ARENA_REPEAT",
        wave     =
        {
            B2_YAG1,
            B2_YAG2,
        },
        setLocal =
        {
            var = "[CW]ARENA_BATTLE",
            val = 2,
        },
        dialog  = "Announcer : Introducing... the Deadly Duo from the green grasses of Giddeus! Be amazed by how swiftly they eliminate these competitors!",
        channel = xi.msg.channel.NS_SHOUT,
        raise   = 1,
    },
    {
        helper   = xi.item.DRAGON_CHRONICLES,
        cooldown = "[CW]ARENA_REPEAT",
        wave     =
        {
            B3_YAG1,
        },
        setLocal =
        {
            var = "[CW]ARENA_BATTLE",
            val = 3,
        },
        dialog  = "Announcer : Introducing... the Outstanding One of Oztroja! Don't let looks deceive, this battle hardened brute is a master black belt!",
        channel = xi.msg.channel.NS_SHOUT,
        raise   = 1,
    },
    {
        helper   = xi.item.DRAGON_CHRONICLES,
        cooldown = "[CW]ARENA_REPEAT",
        wave     =
        {
            B4_YAG1,
            B4_MON1,
            B4_MON2,
        },
        setLocal =
        {
            var = "[CW]ARENA_BATTLE",
            val = 4,
        },
        dialog  = "Announcer : Introducing... the Mighty Monster-tamer of Meriphataud! Expect a wild performance from this absolute beast!",
        channel = xi.msg.channel.NS_SHOUT,
        raise   = 1,
    },
    {
        helper   = xi.item.DRAGON_CHRONICLES,
        cooldown = "[CW]ARENA_REPEAT",
        wave     =
        {
            B5_YAG1,
            B5_YAG2,
        },
        setLocal =
        {
            var = "[CW]ARENA_BATTLE",
            val = 5,
        },
        dialog  = "Announcer : Introducing... the Serpent Singers of Sauromugue! This all singing, all dancing duo is sure to excite your ears!",
        channel = xi.msg.channel.NS_SHOUT,
        raise   = 1,
    },
}

-----------------------------------
-- Upgrade Items
-----------------------------------
local cost     = { 1, 2, 3, 4 }
local upgrades =
{
    {
        name = "Arcane Arbalest",
        item = xi.item.ARCANE_ARBALEST,
        augs =
        {
            { 45, 0, 515, 0 }, -- DMG+1, AGI+1
            { 45, 1, 515, 1 }, -- DMG+2, AGI+2
            { 45, 2, 515, 2 }, -- DMG+3, AGI+3
            { 45, 3, 515, 3 }, -- DMG+4, AGI+4
        },
    },
    {
        name = "Outlaw's Earring",
        item = xi.item.OUTLAWS_EARRING,
        augs =
        {
            { 25, 0, 31, 0 }, -- Attack+1, Evasion+1
            { 25, 1, 31, 1 }, -- Attack+2, Evasion+2
            { 25, 2, 31, 2 }, -- Attack+3, Evasion+3
            { 25, 3, 31, 3 }, -- Attack+4, Evasion+4
        },
    },
    {
        name = "Talon Tathlum",
        item = xi.item.TALON_TATHLUM,
        augs =
        {
            {  1, 1, 23, 0 }, -- HP+2, Accuracy+1
            {  1, 3, 23, 1 }, -- HP+4, Accuracy+2
            {  1, 5, 23, 2 }, -- HP+6, Accuracy+3
            {  1, 7, 23, 3 }, -- HP+8, Accuracy+4
        },
    },
    {
        name = "Exile's Cloak",
        item = xi.item.EXILES_CLOAK,
        augs =
        {
            { 33, 0, 512, 0 }, -- DEF+1, STR+1
            { 33, 1, 512, 1 }, -- DEF+2, STR+2
            { 33, 2, 512, 2 }, -- DEF+3, STR+3
            { 33, 3, 512, 3 }, -- DEF+4, STR+4
        },
    },
    {
        name = "Yagudo Crown",
        item = 26702,
        augs =
        {
            { 515, 0, 25, 0 }, -- AGI+1, Attack+1
            { 515, 1, 25, 1 }, -- AGI+2, Attack+2
            { 515, 2, 25, 2 }, -- AGI+3, Attack+3
            { 515, 3, 25, 3 }, -- AGI+4, Attack+4
        },
    },
}

local shop = cq.shop({
    var    = info.points,
    title  = "Spend Arena Points ({}):",
    dialog = { "Yagudo Fence : *Squark* You here spend arena points?" },
    list   =
    {
        { "Yagudo Drink",   4558,  200 },
        { "Arena Token",    9491,  800 },
        { "Yagudo Crown",  26702, 5000 },
    },
})

local requirements =
{
    100,
    200,
    300,
}

local function getAugTier(itemInfo, itemAug)
    local tier = 0

    for augTier = 1, #itemInfo.augs do
        if
            itemInfo.augs[augTier][1] == itemAug[1][1] and
            itemInfo.augs[augTier][2] == itemAug[1][2] and
            itemInfo.augs[augTier][3] == itemAug[2][1] and
            itemInfo.augs[augTier][4] == itemAug[2][2]
        then
            tier = augTier
        end
    end

    return tier
end

local function tradeArmor()
    return function(player, npc, trade, entity, var, step)
        for _, itemInfo in pairs(upgrades) do
            if npcUtil.tradeHas(trade, itemInfo.item, false) then
                local item = cexi.util.augment.getTradedItem(trade, itemInfo.item)
                local augs = cexi.util.augment.getAugments(player, item)
                local tier = 0

                if #augs > 0 then
                    tier = getAugTier(itemInfo, augs)
                end

                if tier == #itemInfo.augs then
                    cexi.util.dialog(player, { fmt("*Squark* {} at limit now!", itemInfo.name) }, npc:getPacketName(), { npc = npc })
                    return
                end

                if npcUtil.tradeHasExactly(trade, itemInfo.item) then
                    cexi.util.dialog(player, { fmt("You bring {} tokens, I make {} stronger!", cost[tier + 1], itemInfo.name) }, npc:getPacketName(), { npc = npc })
                    return
                end

                if npcUtil.tradeHasExactly(trade, { { itemInfo.item, 1 }, { xi.item.ARENA_TOKEN, cost[tier + 1] } } ) then
                    player:tradeComplete()
                    cexi.util.dialog(player, { fmt("{} so strong now!", itemInfo.name) }, npc:getPacketName(), { npc = npc })
                    npc:independentAnimation(player, 12, 2)

                    player:addItem(itemInfo.item, 1, itemInfo.augs[tier + 1][1], itemInfo.augs[tier + 1][2], itemInfo.augs[tier + 1][3], itemInfo.augs[tier + 1][4])
                    player:timer(100, function()
                        player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, itemInfo.item)
                    end)
                end
            end
        end

        for itemID, itemInfo in pairs(cexi.augments.arena_augments) do
            if cexi.util.tradeHasExactly(trade, { { itemID, 1 }, { itemInfo.hq[1], 1 } } ) then
                cexi.util.dialog(player, { fmt("Hmm... you wish {} be as {}?", itemInfo.hq[2], itemInfo.name) }, npc:getPacketName(), { npc = npc })
                npc:facePlayer(player, true)

                delaySendMenu(player, {
                    title   = fmt("Transfer stats to {}?", itemInfo.hq[2]),
                    options =
                    {
                        {
                            "No",
                            function()
                            end,
                        },
                        {
                            "Yes",
                            function()
                                cexi.util.dialog(player, { fmt("{} gone. {} have power now.", itemInfo.name, itemInfo.hq[2]) }, npc:getPacketName(), { npc = npc })
                                npc:facePlayer(player, true)
                                npc:independentAnimation(player, 12, 2)
                                cexi.util.augment.transferAugments(player, trade, itemID, itemInfo.hq[1])
                            end,
                        },
                    },
                })

                return
            end

            if
                cexi.util.tradeHasExactly(trade, itemID) or
                cexi.util.tradeHasExactly(trade, itemInfo.hq[1])
            then
                local tradedItem =
                {
                    id   = itemID,
                    name = itemInfo.name,
                    hq   = false
                }

                if cexi.util.tradeHasExactly(trade, itemInfo.hq[1]) then
                    tradedItem.id   = itemInfo.hq[1]
                    tradedItem.name = itemInfo.hq[2]
                    tradedItem.hq   = true
                end

                local item = cexi.util.augment.getTradedItem(trade, tradedItem.id)
                local augs = cexi.util.augment.getAugments(player, item)
                local tier = cexi.augments.arenaGetTier(itemID, augs)

                if tier >= 3 then
                    cexi.util.dialog(player, { fmt("*Squark* {} at limit now!", tradedItem.name) }, npc:getPacketName(), { npc = npc })
                    return
                end

                local points = player:getCharVar(info.points)
                local reqs   = requirements[tier + 1]

                if points < reqs then
                    cexi.util.dialog(player, { fmt("*Squark* {} arena points need but you {}.", reqs, points) }, npc:getPacketName(), { npc = npc })
                    return
                end

                npc:facePlayer(player, true)

                delaySendMenu(player, {
                    title   = fmt("Upgrade {} to A{}?", tradedItem.name, tier + 1),
                    options =
                    {
                        {
                            "No",
                            function()
                                cexi.util.dialog(player, { "*Squark* Be leaving then!" }, npc:getPacketName(), { npc = npc })
                                return
                            end,
                        },
                        {
                            fmt("Yes ({} arena points)", reqs),
                            function()
                                npc:independentAnimation(player, 12, 2)
                                cexi.util.dialog(player, { "Smoothskin armor be stronger now." }, npc:getPacketName(), { npc = npc })

                                player:tradeComplete()
                                player:incrementCharVar(info.points, -reqs)
                                cexi.augments.arenaGiveTier(player, itemID, tier + 1, tradedItem.hq)
                            end,
                        },
                    },
                })
            end
        end
    end
end

local step =
{
    {
        check  = cq.checks({ CW = true, level = 50 }),
        [OUTLAW] = cq.talkStep("START", info.name),
    },
    {
        [OUTLAW] =
        {
            onTrigger = cq.talkOnly("START"),
            onTrade   = cq.tradeStep("ACCEPTED", "DECLINED", trade1, info.reward, info.name, cexi.music.NONE),
        },
    },
    {
        [TRACKS] = cq.teleOnly({ "Return to the Yagudo Outlaw?", "Not yet.", "Let's go." }, outlawPos),
        [OUTLAW] =
        {
            check     = cq.checks({ zero = "[CW]ARENA_REPEAT" }),
            onTrigger = cq.talkOnly("REMINDER2"),
            onTrade   = cq.tradeStep("ACCEPTED2", "DECLINED", trade2, info.reward),
        },
        [FENCE]  =
        {
            onTrade   = tradeArmor(),
            onTrigger = shop,
        },
    },
    {
        [OUTLAW]  = cq.teleOnly({ "Travel to the Arena?", "Not yet.", "I'm Ready." }, arenaPos),
        [TRACKS]  = cq.menuSpawn({ prop = { "Yagudo_Watcher" } }, "Stand your ground?", { { "Not yet." }, { "I'm ready.", "START" } }, 2, true, { levelCap = 50, random = battles }),
        [FENCE]  =
        {
            onTrade   = tradeArmor(),
            onTrigger = shop,
        },

        [B1_YAG1] = cq.killStep(TRACKS, battles[1].wave, nil, battles[1]),
        [B1_YAG2] = cq.killStep(TRACKS, battles[1].wave, nil, battles[1]),
        [B1_YAG3] = cq.killStep(TRACKS, battles[1].wave, nil, battles[1]),

        [B2_YAG1] = cq.killStep(TRACKS, battles[2].wave, nil, battles[2]),
        [B2_YAG2] = cq.killStep(TRACKS, battles[2].wave, nil, battles[2]),

        [B3_YAG1] = cq.killStep(TRACKS, battles[3].wave, nil, battles[3]),

        [B4_YAG1] = cq.killStep(TRACKS, battles[4].wave, nil, battles[4]),
        [B4_MON1] = cq.killStep(TRACKS, battles[4].wave, nil, battles[4]),
        [B4_MON2] = cq.killStep(TRACKS, battles[4].wave, nil, battles[4]),

        [B5_YAG1] = cq.killStep(TRACKS, battles[5].wave, nil, battles[5]),
        [B5_YAG2] = cq.killStep(TRACKS, battles[5].wave, nil, battles[5]),
    },
    {
        [TRACKS] = rollRewards("AFTER", info.points, "[CW]ARENA_BATTLE"),
        [FENCE]  =
        {
            onTrade   = tradeArmor(),
            onTrigger = shop,
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
