-----------------------------------
-- The Dragonslayer (Lv60)
-----------------------------------
-- !setvar [CQ]DRAGONSLAYER 0
-- Valsang !pos -30.608 -0.700 72.861 244
-- Sigmund !pos 16.579 -8.000 61.308 249
-- Ivaldi  !pos 77.388 6.845 232.066 121
-- === Wyrms ===
-- !additem golden_rings
-- Arfarvegr    !pos -192.878 24.787 132.298 109
-- Skrudningr   !pos 458.978 3.750 -135.825 104
-- Midgardsormr !pos 671.446 0.871 -415.133 119
-----------------------------------
-- !setvar [CQ]DRAGONSLAYER 6
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cq-the_dragonslayer")

local info =
{
    name     = "The Dragonslayer",
    author   = "Loxley",
    var      = "[CQ]DRAGONSLAYER",
    points   = "[DS]POINTS",
    merits   = "[DS]MERITS",
    instance = "[DS]INSTANCE_{}",
    tally    = "[DS]TALLY_{}",
}

local cost     = { 200, 400, 600, 800, 1000 }
local lowCost  = { 100, 200, 300, 400,  500 }

local upgrade =
{
    PLATE   =
    {
        { mats = { { xi.item.PLATINUM_INGOT, 1 }, { xi.item.TITANIUM_INGOT,   1 } }, desc = "One platinum ingot and one titanium ingot."       },
        { mats = { { xi.item.PLATINUM_INGOT, 2 }, { xi.item.TITANIUM_INGOT,   2 } }, desc = "Two platinum ingots and two titanium ingots."     },
        { mats = { { xi.item.PLATINUM_INGOT, 3 }, { xi.item.TITANIUM_INGOT,   3 } }, desc = "Three platinum ingots and three titanium ingots." },
        { mats = { { xi.item.WYRM_SCALE,     2 }, { xi.item.TITANIUM_INGOT,   3 } }, desc = "Two wyrm scales and three titanium ingots."       },
        { mats = { { xi.item.WYRM_SCALE,     3 }, { xi.item.EMBERSTEEL_INGOT, 1 } }, desc = "Three wyrm scales and one embersteel ingot."      },
    },

    LEATHER =
    {
        { mats = { { xi.item.OVINNIK_LEATHER,  1 }, { xi.item.WYRM_SCALE,       1 } }, desc = "One squares of ovinnik leather and one wyrm scales."          },
        { mats = { { xi.item.OVINNIK_LEATHER,  2 }, { xi.item.WYRM_SCALE,       2 } }, desc = "Two squares of ovinnik leather and two wyrm scales."          },
        { mats = { { xi.item.OVINNIK_LEATHER,  3 }, { xi.item.WYRM_SCALE,       3 } }, desc = "Three squares of ovinnik leather and three wyrm scales."      },
        { mats = { { xi.item.BEHEMOTH_LEATHER, 2 }, { xi.item.WYRM_SCALE,       3 } }, desc = "Two squares of behemoth leathers and three wyrm scales."      },
        { mats = { { xi.item.BEHEMOTH_LEATHER, 3 }, { xi.item.EMBERSTEEL_INGOT, 1 } }, desc = "Three squares of behemoth leathers and one embersteel ingot." },
    },

    CLOTH   =
    {
        { mats = { { xi.item.RAINBOW_CLOTH,   1 }, { xi.item.FABLE_CLOTH,      1 } }, desc = "One rainbow cloth and one fable cloth."           },
        { mats = { { xi.item.RAINBOW_CLOTH,   2 }, { xi.item.FABLE_CLOTH,      2 } }, desc = "Two rainbow cloths and two fable cloths."         },
        { mats = { { xi.item.RAINBOW_CLOTH,   3 }, { xi.item.FABLE_CLOTH,      3 } }, desc = "Three rainbow cloths and three fable cloths."     },
        { mats = { { xi.item.CASHMERE_THREAD, 2 }, { xi.item.FABLE_CLOTH,      3 } }, desc = "Two cashmere threads and three fable cloth."      },
        { mats = { { xi.item.CASHMERE_THREAD, 3 }, { xi.item.EMBERSTEEL_INGOT, 1 } }, desc = "Three cashmere threads and one embersteel ingot." },
    },

    WEAPON  =
    {
        { mats = { { xi.item.ORICHALCUM_INGOT, 1 }, { xi.item.WYRM_TOOTH,       1 } }, desc = "One orichalcum ingot and one wyrm tooth."                },
        { mats = { { xi.item.ORICHALCUM_INGOT, 2 }, { xi.item.WYRM_TOOTH,       2 } }, desc = "Two orichalcum ingot and two wyrm teeth."                },
        { mats = { { xi.item.ORICHALCUM_INGOT, 3 }, { xi.item.WYRM_TOOTH,       3 } }, desc = "Three orichalcum ingot and three wyrm teeth."            },
        { mats = { { xi.item.DIVINE_LUMBER,    2 }, { xi.item.WYRM_TOOTH,       3 } }, desc = "Two pieces of divine lumber and three wyrm teeth."       },
        { mats = { { xi.item.DIVINE_LUMBER,    3 }, { xi.item.EMBERSTEEL_INGOT, 1 } }, desc = "Three pieces of divine lumber and one embersteel ingot." },
    },
}

local upgrades =
{
    -----------------------------------
    -- Searing Eldrake (Lv60)
    -----------------------------------
    {
        name = "Adept's Earring",
        item = 28514,
        cost = lowCost,
        tier =
        {
            { augs = { 1,  2, 9,  2         }, mats = { {  744, 1 }, {                      745, 1 } }, desc = "One silver ingot and one gold ingot."            }, -- HP+3,  MP+3
            { augs = { 1,  5, 9,  5         }, mats = { {  744, 2 }, {                      745, 2 } }, desc = "Two silver ingots and two gold ingots."          }, -- HP+6,  MP+6
            { augs = { 1,  8, 9,  8         }, mats = { {  744, 3 }, {                      745, 3 } }, desc = "Three silver ingots and three gold ingots."      }, -- HP+9,  MP+9
            { augs = { 1, 11, 9, 11         }, mats = { {  746, 2 }, {                      745, 3 } }, desc = "Two platinum ingot and three gold ingots."       }, -- HP+12, MP+12
            { augs = { 1, 14, 9, 14, 141, 1 }, mats = { {  746, 3 }, { xi.item.EMBERSTEEL_INGOT, 1 } }, desc = "Three platinum ingots and one embersteel ingot." }, -- HP+15, MP+15, Conserve MP+2
        },
    },
    {
        name = "Cinderstone",
        item = 21385,
        cost = lowCost,
        tier =
        {
            { augs = { 1,  2, 23, 0        }, mats = { {  790, 1 }, {                      803, 1 } }, desc = "One garnet and one sunstone."               }, -- HP+3,  Accuracy+1
            { augs = { 1,  5, 23, 1        }, mats = { {  790, 2 }, {                      803, 2 } }, desc = "Two garnets and two sunstones."             }, -- HP+6,  Accuracy+2
            { augs = { 1,  8, 23, 2        }, mats = { {  786, 1 }, {                     1255, 1 } }, desc = "One ruby and one fire ore."                 }, -- HP+9,  Accuracy+3
            { augs = { 1, 11, 23, 3        }, mats = { {  786, 2 }, {                     1255, 2 } }, desc = "Two rubies and two fire ores."              }, -- HP+12, Accuracy+4
            { augs = { 1, 14, 23, 4, 25, 1 }, mats = { { 1299, 3 }, { xi.item.EMBERSTEEL_INGOT, 1 } }, desc = "Three fire beads and one embersteel ingot." }, -- HP+15, Accuracy+5, Attack+2
        },
    },

    -----------------------------------
    -- Glacial Wyvern (Lv60)
    -----------------------------------
    {
        name = "Hierarch's Mantle",
        item = 28640,
        cost = lowCost,
        tier =
        {
            { augs = { 9,  2, 99, 0         }, mats = { {                 829, 1 }, {                      830, 1 } }, desc = "One silk cloth and one rainbow cloth."         }, -- MP+3,  Pet: DEF+1
            { augs = { 9,  5, 99, 1         }, mats = { {                 829, 2 }, {                      830, 2 } }, desc = "Two silk cloths and two rainbow cloths."       }, -- MP+6,  Pet: DEF+2
            { augs = { 9,  8, 99, 2         }, mats = { {                 829, 3 }, {                      830, 3 } }, desc = "Three silk cloths and three rainbow cloths."   }, -- MP+9,  Pet: DEF+3
            { augs = { 9, 11, 99, 3         }, mats = { { xi.item.FABLE_CLOTH, 2 }, {                      830, 3 } }, desc = "Two fable cloth and three rainbow cloths."     }, -- MP+12, Pet: DEF+4
            { augs = { 9, 14, 99, 4, 140, 1 }, mats = { { xi.item.FABLE_CLOTH, 3 }, { xi.item.EMBERSTEEL_INGOT, 1 } }, desc = "Three fable cloths and one embersteel ingot."  }, -- MP+15, Pet: DEF+5, Fast Cast+2%
        },
    },
    {
        name = "Rimestone",
        item = 21384,
        cost = lowCost,
        tier =
        {
            { augs = { 9,  2, 40, 0         }, mats = { {  808, 1 }, {                      805, 1 } }, desc = "One goshenite and one zircon."             }, -- MP+3,  Enmity-1
            { augs = { 9,  5, 40, 1         }, mats = { {  808, 2 }, {                      805, 2 } }, desc = "Two goshenites and two zircons."           }, -- MP+6,  Enmity-2
            { augs = { 9,  8, 40, 2         }, mats = { {  787, 1 }, {                     1256, 1 } }, desc = "One diamond and one ice ore."              }, -- MP+9,  Enmity-3
            { augs = { 9, 11, 40, 3         }, mats = { {  787, 2 }, {                     1256, 2 } }, desc = "Two diamonds and two ice ores."            }, -- MP+12, Enmity-4
            { augs = { 9, 14, 40, 4, 516, 2 }, mats = { { 1300, 3 }, { xi.item.EMBERSTEEL_INGOT, 1 } }, desc = "Three ice beads and one embersteel ingot." }, -- MP+15, Enmity-5, INT+3
        },
    },

    -----------------------------------
    -- Midgardsormr
    -----------------------------------
    {
        name = "Titanium Band",
        item = 28577,
        cost = cost,
        buy  = 2500,
        sell = 500,
        tier =
        {
            { augs = { 514, 0, 23, 0        }, mats = upgrade.PLATE[1].mats, desc = upgrade.PLATE[1].desc }, -- VIT+1, Accuracy+1
            { augs = { 514, 1, 23, 1        }, mats = upgrade.PLATE[2].mats, desc = upgrade.PLATE[2].desc }, -- VIT+2, Accuracy+2
            { augs = { 514, 2, 23, 2        }, mats = upgrade.PLATE[3].mats, desc = upgrade.PLATE[3].desc }, -- VIT+3, Accuracy+3
            { augs = { 514, 3, 23, 3        }, mats = upgrade.PLATE[4].mats, desc = upgrade.PLATE[4].desc }, -- VIT+4, Accuracy+4
            { augs = { 514, 4, 23, 4, 71, 1 }, mats = upgrade.PLATE[5].mats, desc = upgrade.PLATE[5].desc }, -- VIT+5, Accuracy+5, Damage taken -2%
        },
    },
    {
        name = "Acrobat's Breeches",
        item = 28201,
        cost = cost,
        buy  = 2500,
        sell = 500,
        tier =
        {
            { augs = { 513, 0, 25, 0         }, mats = upgrade.LEATHER[1].mats, desc = upgrade.LEATHER[1].desc }, -- DEX+1, Attack+1
            { augs = { 513, 1, 25, 1         }, mats = upgrade.LEATHER[2].mats, desc = upgrade.LEATHER[2].desc }, -- DEX+2, Attack+2
            { augs = { 513, 2, 25, 2         }, mats = upgrade.LEATHER[3].mats, desc = upgrade.LEATHER[3].desc }, -- DEX+3, Attack+3
            { augs = { 513, 3, 25, 3         }, mats = upgrade.LEATHER[4].mats, desc = upgrade.LEATHER[4].desc }, -- DEX+4, Attack+4
            { augs = { 513, 4, 25, 4, 146, 1 }, mats = upgrade.LEATHER[5].mats, desc = upgrade.LEATHER[5].desc }, -- DEX+5, Attack+5, Dual Wield +2
        },
    },
    {
        name = "Erudite Cap",
        item = 27767,
        cost = cost,
        buy  = 2500,
        sell = 500,
        tier =
        {
            { augs = { 517, 0, 40, 0         }, mats = upgrade.CLOTH[1].mats, desc = upgrade.CLOTH[1].desc }, -- MND+1, Enmity-1
            { augs = { 517, 1, 40, 1         }, mats = upgrade.CLOTH[2].mats, desc = upgrade.CLOTH[2].desc }, -- MND+2, Enmity-2
            { augs = { 517, 2, 40, 2         }, mats = upgrade.CLOTH[3].mats, desc = upgrade.CLOTH[3].desc }, -- MND+3, Enmity-3
            { augs = { 517, 3, 40, 3         }, mats = upgrade.CLOTH[4].mats, desc = upgrade.CLOTH[4].desc }, -- MND+4, Enmity-4
            { augs = { 517, 4, 40, 4, 140, 1 }, mats = upgrade.CLOTH[5].mats, desc = upgrade.CLOTH[5].desc }, -- MND+5, Enmity-5, Fast Cast +2%
        },
    },
    {
        name = "Steady Fists",
        item = 20554,
        cost = cost,
        buy  = 5000,
        sell = 1000,
        tier =
        {
            { augs = { 25, 0, 39, 0         }, mats = upgrade.WEAPON[1].mats, desc = upgrade.WEAPON[1].desc }, -- Attack+1, Enmity+1
            { augs = { 25, 1, 39, 1         }, mats = upgrade.WEAPON[2].mats, desc = upgrade.WEAPON[2].desc }, -- Attack+2, Enmity+2
            { augs = { 25, 2, 39, 2         }, mats = upgrade.WEAPON[3].mats, desc = upgrade.WEAPON[3].desc }, -- Attack+3, Enmity+3
            { augs = { 25, 3, 39, 3         }, mats = upgrade.WEAPON[4].mats, desc = upgrade.WEAPON[4].desc }, -- Attack+4, Enmity+4
            { augs = { 25, 4, 39, 4, 145, 1 }, mats = upgrade.WEAPON[5].mats, desc = upgrade.WEAPON[5].desc }, -- Attack+5, Enmity+5, Counter+2
        },
    },

    -----------------------------------
    -- Arfarvegr
    -----------------------------------
    {
        name = "Assailant's Visor",
        item = 27738,
        cost = cost,
        buy  = 2500,
        sell = 500,
        tier =
        {
            { augs = { 25, 0, 23, 0         }, mats = upgrade.PLATE[1].mats, desc = upgrade.PLATE[1].desc }, -- Attack+1, Accuracy+1
            { augs = { 25, 1, 23, 1         }, mats = upgrade.PLATE[2].mats, desc = upgrade.PLATE[2].desc }, -- Attack+2, Accuracy+2
            { augs = { 25, 2, 23, 2         }, mats = upgrade.PLATE[3].mats, desc = upgrade.PLATE[3].desc }, -- Attack+3, Accuracy+3
            { augs = { 25, 3, 23, 3         }, mats = upgrade.PLATE[4].mats, desc = upgrade.PLATE[4].desc }, -- Attack+4, Accuracy+4
            { augs = { 25, 4, 23, 4, 143, 1 }, mats = upgrade.PLATE[5].mats, desc = upgrade.PLATE[5].desc }, -- Attack+5, Accuracy+5, Double Attack+2%
        },
    },
    {
        name = "Subtle Sash",
        item = 28459,
        cost = cost,
        buy  = 2500,
        sell = 500,
        tier =
        {
            { augs = { 513, 0, 282, 0         }, mats = upgrade.LEATHER[1].mats, desc = upgrade.LEATHER[1].desc }, -- DEX+1, Marksmanship skill+1
            { augs = { 513, 1, 282, 1         }, mats = upgrade.LEATHER[2].mats, desc = upgrade.LEATHER[2].desc }, -- DEX+2, Marksmanship skill+2
            { augs = { 513, 2, 282, 2         }, mats = upgrade.LEATHER[3].mats, desc = upgrade.LEATHER[3].desc }, -- DEX+3, Marksmanship skill+3
            { augs = { 513, 3, 282, 3         }, mats = upgrade.LEATHER[4].mats, desc = upgrade.LEATHER[4].desc }, -- DEX+4, Marksmanship skill+4
            { augs = { 513, 4, 282, 4, 515, 1 }, mats = upgrade.LEATHER[5].mats, desc = upgrade.LEATHER[5].desc }, -- DEX+5, Marksmanship skill+5, AGI+2
        },
    },
    {
        name = "Ornate Gloves",
        item = 28062,
        cost = cost,
        buy  = 2500,
        sell = 500,
        tier =
        {
            { augs = { 516, 0, 40, 0        }, mats = upgrade.CLOTH[1].mats, desc = upgrade.CLOTH[1].desc }, -- INT+1, Enmity-1
            { augs = { 516, 1, 40, 1        }, mats = upgrade.CLOTH[2].mats, desc = upgrade.CLOTH[2].desc }, -- INT+2, Enmity-2
            { augs = { 516, 2, 40, 2        }, mats = upgrade.CLOTH[3].mats, desc = upgrade.CLOTH[3].desc }, -- INT+3, Enmity-3
            { augs = { 516, 3, 40, 3        }, mats = upgrade.CLOTH[4].mats, desc = upgrade.CLOTH[4].desc }, -- INT+4, Enmity-4
            { augs = { 516, 4, 40, 4, 57, 1 }, mats = upgrade.CLOTH[5].mats, desc = upgrade.CLOTH[5].desc }, -- INT+5, Enmity-5, Magic crit rate +2%
        },
    },
    {
        name = "Unbreakable",
        item = 20740,
        cost = cost,
        buy  = 5000,
        sell = 1000,
        tier =
        {
            { augs = { 514, 0, 1472, 0        }, mats = upgrade.WEAPON[1].mats, desc = upgrade.WEAPON[1].desc }, -- VIT+1, Parrying Rate+1%
            { augs = { 514, 1, 1472, 1        }, mats = upgrade.WEAPON[2].mats, desc = upgrade.WEAPON[2].desc }, -- VIT+2, Parrying Rate+2%
            { augs = { 514, 2, 1472, 2        }, mats = upgrade.WEAPON[3].mats, desc = upgrade.WEAPON[3].desc }, -- VIT+3, Parrying Rate+3%
            { augs = { 514, 3, 1472, 3        }, mats = upgrade.WEAPON[4].mats, desc = upgrade.WEAPON[4].desc }, -- VIT+4, Parrying Rate+4%
            { augs = { 514, 4, 1472, 4, 55, 1 }, mats = upgrade.WEAPON[5].mats, desc = upgrade.WEAPON[5].desc }, -- VIT+5, Parrying Rate+5%, Magic damage taken -2%
        },
    },

    -----------------------------------
    -- Skrudningr
    -----------------------------------
    {
        name = "Conqueror's Helm",
        item = 27779,
        cost = cost,
        buy  = 2500,
        sell = 500,
        tier =
        {
            { augs = { 25, 0, 23, 0         }, mats = upgrade.PLATE[1].mats, desc = upgrade.PLATE[1].desc }, -- Attack+1, Accuracy+1
            { augs = { 25, 1, 23, 1         }, mats = upgrade.PLATE[2].mats, desc = upgrade.PLATE[2].desc }, -- Attack+2, Accuracy+2
            { augs = { 25, 2, 23, 2         }, mats = upgrade.PLATE[3].mats, desc = upgrade.PLATE[3].desc }, -- Attack+3, Accuracy+3
            { augs = { 25, 3, 23, 3         }, mats = upgrade.PLATE[4].mats, desc = upgrade.PLATE[4].desc }, -- Attack+4, Accuracy+4
            { augs = { 25, 4, 23, 4, 146, 1 }, mats = upgrade.PLATE[5].mats, desc = upgrade.PLATE[5].desc }, -- Attack+5, Accuracy+5, Dual Wield +2
        },
    },
    {
        name = "Loxo Scarf",
        item = 28384,
        cost = cost,
        buy  = 2500,
        sell = 500,
        tier =
        {
            { augs = { 512, 0, 25, 0         }, mats = upgrade.LEATHER[1].mats, desc = upgrade.LEATHER[1].desc }, -- STR+1, Attack+1
            { augs = { 512, 1, 25, 1         }, mats = upgrade.LEATHER[2].mats, desc = upgrade.LEATHER[2].desc }, -- STR+2, Attack+2
            { augs = { 512, 2, 25, 2         }, mats = upgrade.LEATHER[3].mats, desc = upgrade.LEATHER[3].desc }, -- STR+3, Attack+3
            { augs = { 512, 3, 25, 3         }, mats = upgrade.LEATHER[4].mats, desc = upgrade.LEATHER[4].desc }, -- STR+4, Attack+4
            { augs = { 512, 4, 25, 4, 211, 1 }, mats = upgrade.LEATHER[5].mats, desc = upgrade.LEATHER[5].desc }, -- STR+5, Attack+5, Snapshot +2
        },
    },
    {
        name = "Covenant Belt",
        item = 28458,
        cost = cost,
        buy  = 2500,
        sell = 500,
        tier =
        {
            { augs = { 9,  2, 517, 0         }, mats = upgrade.CLOTH[1].mats, desc = upgrade.CLOTH[1].desc }, -- MP+3,  MND+1
            { augs = { 9,  5, 517, 1         }, mats = upgrade.CLOTH[2].mats, desc = upgrade.CLOTH[2].desc }, -- MP+6,  MND+2
            { augs = { 9,  8, 517, 2         }, mats = upgrade.CLOTH[3].mats, desc = upgrade.CLOTH[3].desc }, -- MP+9,  MND+3
            { augs = { 9, 11, 517, 3         }, mats = upgrade.CLOTH[4].mats, desc = upgrade.CLOTH[4].desc }, -- MP+12, MND+4
            { augs = { 9, 14, 517, 4, 320, 1 }, mats = upgrade.CLOTH[5].mats, desc = upgrade.CLOTH[5].desc }, -- MP+15, MND+5, "Blood Pact" ability delay-2
        },
    },
    {
        name = "Stormblade",
        item = 21915,
        cost = cost,
        buy  = 5000,
        sell = 1000,
        tier =
        {
            { augs = { 740, 0, 513, 0        }, mats = upgrade.WEAPON[1].mats, desc = upgrade.WEAPON[1].desc }, -- DMG+1, DEX+1
            { augs = { 740, 1, 513, 1        }, mats = upgrade.WEAPON[2].mats, desc = upgrade.WEAPON[2].desc }, -- DMG+2, DEX+2
            { augs = { 740, 2, 513, 2        }, mats = upgrade.WEAPON[3].mats, desc = upgrade.WEAPON[3].desc }, -- DMG+3, DEX+3
            { augs = { 740, 3, 513, 3        }, mats = upgrade.WEAPON[4].mats, desc = upgrade.WEAPON[4].desc }, -- DMG+4, DEX+4
            { augs = { 740, 4, 513, 4, 49, 1 }, mats = upgrade.WEAPON[5].mats, desc = upgrade.WEAPON[5].desc }, -- DMG+5, DEX+5, Haste+2%
        },
    },

    -----------------------------------
    -- Brjota
    -----------------------------------
    {
        name = "Ruthless Greaves",
        item = 28305,
        cost = cost,
        buy  = 4000,
        sell = 800,
        tier =
        {
            { augs = { 25, 0, 23, 0         }, mats = upgrade.PLATE[1].mats, desc = upgrade.PLATE[1].desc }, -- Attack+1, Accuracy+1
            { augs = { 25, 1, 23, 1         }, mats = upgrade.PLATE[2].mats, desc = upgrade.PLATE[2].desc }, -- Attack+2, Accuracy+2
            { augs = { 25, 2, 23, 2         }, mats = upgrade.PLATE[3].mats, desc = upgrade.PLATE[3].desc }, -- Attack+3, Accuracy+3
            { augs = { 25, 3, 23, 3         }, mats = upgrade.PLATE[4].mats, desc = upgrade.PLATE[4].desc }, -- Attack+4, Accuracy+4
            { augs = { 25, 4, 23, 4, 142, 1 }, mats = upgrade.PLATE[5].mats, desc = upgrade.PLATE[5].desc }, -- Attack+5, Accuracy+5, Store TP +2
        },
    },
    {
        name = "Swift Gages",
        item = 28050,
        cost = cost,
        buy  = 4000,
        sell = 800,
        tier =
        {
            { augs = { 513, 0, 25, 0         }, mats = upgrade.LEATHER[1].mats, desc = upgrade.LEATHER[1].desc }, -- DEX+1, Attack+1
            { augs = { 513, 1, 25, 1         }, mats = upgrade.LEATHER[2].mats, desc = upgrade.LEATHER[2].desc }, -- DEX+2, Attack+2
            { augs = { 513, 2, 25, 2         }, mats = upgrade.LEATHER[3].mats, desc = upgrade.LEATHER[3].desc }, -- DEX+3, Attack+3
            { augs = { 513, 3, 25, 3         }, mats = upgrade.LEATHER[4].mats, desc = upgrade.LEATHER[4].desc }, -- DEX+4, Attack+4
            { augs = { 513, 4, 25, 4, 143, 1 }, mats = upgrade.LEATHER[5].mats, desc = upgrade.LEATHER[5].desc }, -- DEX+5, Attack+5, Double Attack +2%
        },
    },
    {
        name = "Windfall Hat",
        item = 27781,
        cost = cost,
        buy  = 4000,
        sell = 800,
        tier =
        {
            { augs = { 515, 0, 23, 0,        }, mats = upgrade.CLOTH[1].mats, desc = upgrade.CLOTH[1].desc }, -- AGI+1, Accuracy+1
            { augs = { 515, 1, 23, 1,        }, mats = upgrade.CLOTH[2].mats, desc = upgrade.CLOTH[2].desc }, -- AGI+2, Accuracy+2
            { augs = { 515, 2, 23, 2,        }, mats = upgrade.CLOTH[3].mats, desc = upgrade.CLOTH[3].desc }, -- AGI+3, Accuracy+3
            { augs = { 515, 3, 23, 3,        }, mats = upgrade.CLOTH[4].mats, desc = upgrade.CLOTH[4].desc }, -- AGI+4, Accuracy+4
            { augs = { 515, 4, 23, 4, 142, 1 }, mats = upgrade.CLOTH[5].mats, desc = upgrade.CLOTH[5].desc }, -- AGI+5, Accuracy+5, Store TP +2
        },
    },
    {
        name = "Hurricane",
        item = 20936,
        cost = cost,
        buy  = 6000,
        sell = 1200,
        tier =
        {
            { augs = { 23, 0, 198, 0         }, mats = upgrade.WEAPON[1].mats, desc = upgrade.WEAPON[1].desc }, -- Accuracy+1, Zanshin+1
            { augs = { 23, 1, 198, 1         }, mats = upgrade.WEAPON[2].mats, desc = upgrade.WEAPON[2].desc }, -- Accuracy+2, Zanshin+2
            { augs = { 23, 2, 198, 2         }, mats = upgrade.WEAPON[3].mats, desc = upgrade.WEAPON[3].desc }, -- Accuracy+3, Zanshin+3
            { augs = { 23, 3, 198, 3         }, mats = upgrade.WEAPON[4].mats, desc = upgrade.WEAPON[4].desc }, -- Accuracy+4, Zanshin+4
            { augs = { 23, 4, 198, 4, 144, 1 }, mats = upgrade.WEAPON[5].mats, desc = upgrade.WEAPON[5].desc }, -- Accuracy+5, Zanshin+5, Triple attack+2%
        },
    },
}

local shopList =
{
    { "Golden Bangle",   9444,  50, { "To use this lure, journey through the fire and the flames to the depths of Ifrit's Cauldron, or into the caves of Xarcabard under the black winter night." } },
    { "Golden Rings",    9445, 200, { "To use this lure, travel through the mountains of Meriphataud into the valley of the damned, face the fury of the storm in Jugner Forest, or find the land where dragons rule in Pashhow Marshlands." } },
    { "Golden Rings +1", 9446, 300, { "To use this lure, journey to the edge of the world at the shores of Purgonorgo Isle." } },
}

local classicShopList =
{
    { "Golden Bangle",   9444,  25, { "To use this lure, journey through the fire and the flames to the depths of Ifrit's Cauldron, or into the caves of Xarcabard under the black winter night." } },
    { "Golden Rings",    9445,  75, { "To use this lure, travel through the mountains of Meriphataud into the valley of the damned, face the fury of the storm in Jugner Forest, or find the land where dragons rule in Pashhow Marshlands." } },
    { "Golden Rings +1", 9446, 125, { "To use this lure, journey to the edge of the world at the shores of Purgonorgo Isle." } },
}

local dkpList =
{
    { "Kejusu Satin",   1764, 300 },
    { "Divine Log",      722, 300 },
    { "Dragon Bone",    1771, 300 },
    { "Goblin Brew +2", 9437, 500 },
}

for _, itemInfo in pairs(upgrades) do
    if itemInfo.buy ~= nil then
        table.insert(dkpList, { itemInfo.name, itemInfo.item, itemInfo.buy })
    end
end

local wyrmMats =
{
    { cexi.rate.VERY_COMMON,  722 }, -- Divine Log       (24%)
    { cexi.rate.VERY_COMMON, 1110 }, -- Beetle Blood     (24%)
    { cexi.rate.VERY_COMMON,  836 }, -- Damascene Cloth  (24%)
    { cexi.rate.VERY_COMMON,  655 }, -- Adaman Ingot     (24%)
    { cexi.rate.VERY_COMMON, 1313 }, -- Siren's Hair     (24%)
    { cexi.rate.COMMON,       903 }, -- Dragon Talon     (15%)
    { cexi.rate.COMMON,      4272 }, -- Dragon Meat      (15%)
    { cexi.rate.COMMON,      4486 }, -- Dragon Heart     (15%)
    { cexi.rate.COMMON,      1712 }, -- Cashmere Wool    (15%)
    { cexi.rate.COMMON,       860 }, -- Behemoth Hide    (15%)
    { cexi.rate.COMMON,      9454 }, -- Embersteel Ingot (15%)
    { cexi.rate.UNCOMMON,     734 }, -- Thokcha Ore      (10%)
    { cexi.rate.UNCOMMON,     647 }, -- Molybdenum Ore   (10%)
    { cexi.rate.UNCOMMON,    1703 }, -- Kunwu Ore        (10%)
    { cexi.rate.RARE,        1311 }, -- Oxblood          ( 5%)
    { cexi.rate.RARE,        1816 }, -- Wyrm Horn        ( 5%)
}

local wyrmTrash =
{
    { cexi.rate.VERY_COMMON,  867 }, -- Dragon Scales    (24%)
    { cexi.rate.VERY_COMMON, 1133 }, -- Dragon Blood     (15%)
    { cexi.rate.UNCOMMON,    9447 }, -- Wyrm Scale       (10%)
    { cexi.rate.UNCOMMON,    9453 }, -- Wyrm Tooth       (10%)
    { cexi.rate.COMMON,      9454 }, -- Embersteel Ingot (10%)
}

local upgradeMats =
{
    { cexi.rate.VERY_COMMON, 9447 }, -- Wyrm Scale   (24%)
    { cexi.rate.VERY_COMMON, 9453 }, -- Wyrm Tooth   (24%)
}

local mobSets =
{
    FOREST_WYVERN =
    {
        { name = "Forest Wyvern 1", pos = { 449.730, 4.970, -139.574, 10 }, level = 90, hp = 15000 }, -- !pos 449.730 4.970 -139.574 104
        { name = "Forest Wyvern 2", pos = { 466.018, 2.197, -122.521, 74 }, level = 90, hp = 15000 }, -- !pos 466.018 2.197 -122.521 104
    },
    MOUNTAIN_DARTER =
    {
        { name = "Mountain Darter 1", pos = { 688.490, -3.068, -424.019, 144 }, level = 85, hp = 5000 }, -- !pos 688.490 -3.068 -424.019 119
        { name = "Mountain Darter 2", pos = { 663.987, -3.085, -448.625, 190 }, level = 85, hp = 5000 }, -- !pos 663.987 -3.085 -448.625 119
        { name = "Mountain Darter 3", pos = { 631.530, -3.065, -416.665, 248 }, level = 85, hp = 5000 }, -- !pos 631.530 -3.065 -416.665 119
    },
    SWAMP_SNIPPER =
    {
        { name = "Swamp Snipper 1", pos = { -187.043, 24.952, 143.375, 110 }, level = 80, hp = 10000 }, -- !pos -187.043 24.952 143.375 109
        { name = "Swamp Snipper 2", pos = { -196.585, 25.000, 152.429,  75 }, level = 80, hp = 10000 }, -- !pos -196.585 25.000 152.429 109
        { name = "Swamp Snipper 3", pos = { -212.782, 25.000, 141.279, 252 }, level = 80, hp = 10000 }, -- !pos -212.782 25.000 141.279 109
        { name = "Swamp Snipper 4", pos = { -204.990, 25.000, 127.846, 218 }, level = 80, hp = 10000 }, -- !pos -204.990 25.000 127.846 109
    },
    GALEWEAVER =
    {
        { name = "Galeweaver 1", pos = { -646.838, 0.300, -743.161, 4 }, level = 90, hp = 10000 }, -- !pos -646.838 0.300 -743.161 4
        { name = "Galeweaver 2", pos = { -633.443, 0.300, -740.764, 4 }, level = 90, hp = 10000 }, -- !pos -633.443 0.300 -740.764 4
        { name = "Galeweaver 3", pos = { -621.967, 0.105, -752.243, 4 }, level = 90, hp = 10000 }, -- !pos -621.967 0.105 -752.243 4
    },
}

local mobs =
{
    {
        name = "Forest Wyvern",
        base = { 89, 32 }, -- Ajattara
        area = "Jugner_Forest",
        pos  =
        {
            mobSets.FOREST_WYVERN[1].pos,
            mobSets.FOREST_WYVERN[2].pos,
        },
        loot =
        {
            { cexi.rate.COMMON,   1122 }, -- Wyvern Skin  (15%)
            { cexi.rate.UNCOMMON, 4372 }, -- G.Sheep Meat (10%)
            { cexi.rate.RARE,      694 }, -- Chestnut Log ( 5%)
        },
        mods =
        {
            [xi.mod.REGAIN] = { 20, 3, 0 },
        },
    },
    {
        name = "Mountain Darter",
        base = { 154, 3 }, -- Darter
        area = "Meriphataud_Mountains",
        pos  =
        {
            mobSets.MOUNTAIN_DARTER[1].pos,
            mobSets.MOUNTAIN_DARTER[2].pos,
            mobSets.MOUNTAIN_DARTER[3].pos,
        },
        mods =
        {
            [xi.mod.UDMGPHYS] = -2500,
            [xi.mod.REGAIN]   = { 20, 3, 0 },
        },
    },
    {
        name = "Swamp Snipper",
        base = { 104, 7 }, -- King Arthro
        area = "Pashhow_Marshlands",
        pos  =
        {
            mobSets.SWAMP_SNIPPER[1].pos,
            mobSets.SWAMP_SNIPPER[2].pos,
            mobSets.SWAMP_SNIPPER[3].pos,
            mobSets.SWAMP_SNIPPER[4].pos,
        },
    },
    {
        name = "Galeweaver",
        base = { 254, 50 }, -- Air elemental
        area = "Bibiki_Bay",
        pos  =
        {
            mobSets.GALEWEAVER[1].pos,
            mobSets.GALEWEAVER[2].pos,
            mobSets.GALEWEAVER[3].pos,
        },
        mods =
        {
            [xi.mod.MDEF]       = 30,
            [xi.mod.UDMGPHYS]   = -5000,
            [xi.mod.UDMGRANGE]  = -5000,
            [xi.mod.FIRE_NULL]  = 100,
            [xi.mod.WIND_NULL]  = 100,
            [xi.mod.EARTH_NULL] = 100,
            [xi.mod.LTNG_NULL]  = 100,
            [xi.mod.WATER_NULL] = 100,
            [xi.mod.LIGHT_NULL] = 100,
            [xi.mod.DARK_NULL]  = 100,

            [xi.mod.EARTH_RES_RANK] =  8,
            [xi.mod.ICE_RES_RANK]   = -8,
        },
        loot =
        {
            { cexi.rate.GUARANTEED, 4106 }, -- wind cluster (100%)
            { cexi.rate.COMMON,     4106 }, -- wind cluster ( 15%)
            { cexi.rate.RARE,       4106 }, -- wind cluster (  5%)
        },
    },
}

local matches = -- [element id][resonance id]
{
--    1  2  3  4  5  6  7  8  9  10 11 12 13 14 15 16 17
--    N  T  C  L  S  R  D  I  I  G  D  F  F  L  D  L  D
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, -- (1) NONE
    { 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0 }, -- (2) FIRE
    { 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1 }, -- (3) ICE
    { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0 }, -- (4) WIND
    { 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1 }, -- (5) EARTH
    { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0 }, -- (6) THUNDER
    { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1 }, -- (7) WATER
    { 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0 }, -- (8) LIGHT
    { 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1 }, -- (9) DARK
    -- Blue mage spells.  Included for the sake of completeness
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, -- (10) BLU - Physical Blunt
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, -- (11) BLU - Physical Hand-to-Hand
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, -- (12) BLU - Physical Piercing
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, -- (13) BLU - Physical Slashing
}

local tierDecrement =
{
    -- Physical / Ranged / Magic
    { 150, 100, 100 }, -- MB x1
    { 225, 150, 150 }, -- MB x2
    { 300, 250, 250 }, -- MB x3
}

local function decayShield(mob, tier)
    mob:setMod(xi.mod.UDMGPHYS,   mob:getMod(xi.mod.UDMGPHYS)   + tierDecrement[tier][1])
    mob:setMod(xi.mod.UDMGRANGE,  mob:getMod(xi.mod.UDMGRANGE)  + tierDecrement[tier][2])
    mob:setMod(xi.mod.UDMGMAGIC,  mob:getMod(xi.mod.UDMGMAGIC)  + tierDecrement[tier][3])
    mob:setMod(xi.mod.UDMGBREATH, mob:getMod(xi.mod.UDMGBREATH) + tierDecrement[tier][3])
end

local function canPerformAction(mob)
    local act = mob:getCurrentAction()
    local isBusy = act == xi.act.MOBABILITY_START
        or act == xi.act.MOBABILITY_USING
        or act == xi.act.MOBABILITY_FINISH
        or act == xi.act.MAGIC_CASTING
        or act == xi.act.MAGIC_START
        or act == xi.act.MAGIC_FINISH

    local isActionQueueEmpty = mob:actionQueueEmpty()
    local isAlive = mob:isAlive()
    local canAct = isAlive and isActionQueueEmpty and not isBusy

    return canAct
end

local wyrmModsBase =
{
    [xi.mod.UDMGPHYS]   = -9500,
    [xi.mod.UDMGRANGE]  = -8000,
    [xi.mod.UDMGMAGIC]  = -6500,
    [xi.mod.UDMGBREATH] = -7500,

    [xi.mod.MDEF] =  30,
    [xi.mod.ACC]  = 404, -- 500 total acc
    [xi.mod.ATT]  = 450, -- 500 total atk
    [xi.mod.DEF]  =  88, -- 500 total def
    [xi.mod.EVA]  = 409, -- 420 total eva
    [xi.mod.MND]  =  72, -- 150 total mnd
}

local wyrmMods =
{
    Midgardsormr =
    {
        [xi.mod.WIND_RES_RANK]     = -4,
        [xi.mod.THUNDER_RES_RANK]  = 3,
    },

    Arfarvegr    =
    {
        [xi.mod.THUNDER_RES_RANK] = -4,
        [xi.mod.FIRE_RES_RANK]    = 3,
    },

    Skrudningr   =
    {
        [xi.mod.EARTH_RES_RANK] = -4,
        [xi.mod.WATER_RES_RANK] = 3,
    },
}

for wyrmName, _ in pairs(wyrmMods) do
    for modID, modValue in pairs(wyrmModsBase) do
        wyrmMods[wyrmName][modID] = modValue
    end
end

local wyrmModsTwo =
{
    [xi.mod.UDMGPHYS]   = -9500,
    [xi.mod.UDMGRANGE]  = -8000,
    [xi.mod.UDMGMAGIC]  = -6500,
    [xi.mod.UDMGBREATH] = -7500,

    [xi.mod.MDEF] =  30,
    [xi.mod.ACC]  = 500, -- 500 total acc
    [xi.mod.ATT]  = 700, -- 800 total atk
    [xi.mod.DEF]  = 537, -- 600 total def
    [xi.mod.EVA]  = 372, -- 430 total eva
    [xi.mod.MND]  =  53, -- 150 total mnd
    [xi.mod.MAIN_DMG_RATING] = 50,

    [xi.mod.EARTH_RES_RANK] =  5,
    [xi.mod.ICE_RES_RANK]   = -5,
}

local galeweaverMods =
    -- (!)TODO: this is wrong and not applying correctly
{
    [xi.mod.UDMGPHYS]   = -5000,
    [xi.mod.UDMGRANGE]  = -5000,

    [xi.mod.MDEF] =  30,
    [xi.mod.FIRE_NULL]  = 100,
    [xi.mod.WIND_NULL]  = 100,
    [xi.mod.EARTH_NULL] = 100,
    [xi.mod.LTNG_NULL] = 100,
    [xi.mod.WATER_NULL] = 100,
    [xi.mod.LIGHT_NULL] = 100,
    [xi.mod.DARK_NULL]  = 100,
}

local dragonType =
{
    earth   = 731, -- Ouryu
    water   = 732, -- Jormungand
    thunder = 730, -- Tiamat
}

local function triggerFlight(mob, skillListID)
    mob:setAnimationSub(1)  -- Flying animation
    mob:addStatusEffectEx(xi.effect.ALL_MISS, 0, 1, 0, 0)
    mob:setMod(xi.mod.REGEN, 100)
    mob:setMobSkillAttack(skillListID)
end

local function triggerLanding(mob)
    mob:useMobAbility(1292)  -- This ability changes animation to landing
    mob:setMod(xi.mod.REGEN, 0)
end

local function matchResonance(ele, resonance)
    local isMatch = matches[ele + 1][resonance:getPower() + 1]
    return (isMatch ~= nil and isMatch > 0)
end

local typeToElement =
{
    [xi.damageType.FIRE]    = xi.element.FIRE,
    [xi.damageType.ICE]     = xi.element.ICE,
    [xi.damageType.WIND]    = xi.element.WIND,
    [xi.damageType.EARTH]   = xi.element.EARTH,
    [xi.damageType.THUNDER] = xi.element.THUNDER,
    [xi.damageType.WATER]   = xi.element.WATER,
    [xi.damageType.LIGHT]   = xi.element.LIGHT,
    [xi.damageType.DARK]    = xi.element.DARK,
}

local function mbCounter(mob, element)
    mob:addListener('TAKE_DAMAGE', 'MB_COUNTER', function(target, amount, attacker, attackType, damageType)
        if attackType ~= xi.attackType.MAGICAL then
            return
        end

        local animation         = mob:getAnimationSub()
        local nextAction        = mob:getLocalVar("nextAction")
        local magicBurstCounter = mob:getLocalVar("magicBurstCounter")
        local timesLanded       = mob:getLocalVar("timesLanded")
        local nextWindow        = mob:getLocalVar("nextWindow")

        if os.time() < nextWindow then
            return
        end

        -- Require more MB damage if more shield is gone
        local threshold = (500 / 20) * (mob:getMod(xi.mod.UDMGPHYS) / -9500)

        if amount < threshold then
            return
        end

        if timesLanded > 0 and animation == 2 and nextAction == 1 then
            if (attacker:isPC() or attacker:isPet()) and typeToElement[damageType] == element then
                local resonance = target:getStatusEffect(xi.effect.SKILLCHAIN)

                if
                    resonance ~= nil and
                    resonance:getTier() > 0 and
                    matchResonance(element, resonance)
                then
                    local mbWindow = mob:getLocalVar("mbWindow")
                    mob:setLocalVar("mbWindow", mbWindow + 1)
                    mob:setLocalVar("magicBurstCounter", magicBurstCounter + 1)
                    mob:setLocalVar("nextWindow", os.time() + 10)
                end
            end
        end
    end)
end

local function mbCounterBrjota(mob, element)
    mob:addListener('TAKE_DAMAGE', 'MB_COUNTER', function(target, amount, attacker, attackType, damageType)
        if attackType ~= xi.attackType.MAGICAL then
            return
        end

        local animation         = mob:getAnimationSub()
        local nextAction        = mob:getLocalVar("nextAction")
        local magicBurstCounter = mob:getLocalVar("magicBurstCounter")
        local nextWindow        = mob:getLocalVar("nextWindow")

        if os.time() < nextWindow then
            return
        end

        -- Require more MB damage if more shield is gone
        local threshold = (300 / 20) * (mob:getMod(xi.mod.UDMGPHYS) / -9500)

        if amount < threshold then
            return
        end

        if animation ~= 4 and animation ~= 1 then
            if (attacker:isPC() or attacker:isPet()) and typeToElement[damageType] == element then
                local resonance = target:getStatusEffect(xi.effect.SKILLCHAIN)

                if
                    resonance ~= nil and
                    resonance:getTier() > 0 and
                    matchResonance(element, resonance)
                then
                    local mbWindow = mob:getLocalVar("mbWindow")
                    mob:setLocalVar("mbWindow", mbWindow + 1)
                    mob:setLocalVar("magicBurstCounter", magicBurstCounter + 1)
                    mob:setLocalVar("nextWindow", os.time() + 10)
                end
            end
        end
    end)
end

local function mbWeaken(mob)
    local mobName = mob:getPacketName()
    local phase   = mob:getAnimationSub()

    -- Only apply on landing
    if
        mobName == "Brjota" and
        (phase == 1 or phase == 4)  -- Wings open - can't be weakened.
    then
        return
    elseif phase ~= 2 then
        return
    end

    local weaknessCounter = mob:getLocalVar("weaknessCounter")

    -- Remove once maxed out
    if mob:getMod(xi.mod.UDMGPHYS) >= 0 then
        mob:removeListener("MB_COUNTER")
        return
    end

    local magicBurstCounter = mob:getLocalVar("magicBurstCounter")
    local mbWindow = mob:getLocalVar("mbWindow")

    if
        weaknessCounter < magicBurstCounter and
        mbWindow <= 3
    then
        mob:setLocalVar("weaknessCounter", weaknessCounter + 1)

        mob:timer(1000, function()
            if mbWindow == 1 then
                mob:weaknessTrigger(1)
                decayShield(mob, 1)

            elseif mbWindow == 2 then
                mob:addStatusEffectEx(xi.effect.TERROR, xi.effect.TERROR, 0, 0, 3)
                mob:weaknessTrigger(2)
                decayShield(mob, 3)

            elseif mbWindow == 3 then
                mob:addStatusEffectEx(xi.effect.TERROR, xi.effect.TERROR, 0, 0, 5)
                mob:weaknessTrigger(3)
                decayShield(mob, 3)
            end
        end)
    end
end

local function wyrmFlying(mob)
    local fightTime          = mob:getLocalVar("fightTime")
    local landedIntervalTime = math.random(60, 120)  -- time on the ground
    local flyingIntervalTime = math.random(30, 60)  -- time in the air
    local intervalTime       = 0
    local animation          = mob:getAnimationSub()
    local currentBattleTime  = mob:getBattleTime()
    local nextAction         = mob:getLocalVar("nextAction")
    local timesLanded        = mob:getLocalVar("timesLanded")

    if animation == 2 then
        intervalTime = landedIntervalTime
    elseif animation == 1 then
        intervalTime = flyingIntervalTime
    end

    if canPerformAction(mob) then
        if animation == 0 then
            mob:setLocalVar("fightTime", currentBattleTime) -- initial setup for this var
            mob:setLocalVar("nextAction", 1) -- next action is to fly
            mob:setAnimationSub(2) -- stay on the ground for now
        elseif animation == 2 and currentBattleTime - fightTime > intervalTime then
            triggerFlight(mob, dragonType.earth) -- fly up
            mob:setLocalVar("fightTime", currentBattleTime) -- update fightTime
            mob:setLocalVar("nextAction", 2) -- next action is to land
        elseif animation == 1 and currentBattleTime - fightTime > intervalTime then
            triggerLanding(mob) -- land
            mob:setLocalVar("mbWindow", 0) -- Reset MB window so 1-3 triggers can occur again
            mob:setLocalVar("fightTime", currentBattleTime) -- update fightTime
            mob:setLocalVar("nextAction", 1) -- next action is to fly again
            mob:setLocalVar("timesLanded", timesLanded + 1)
        end
    end
end

local function triggerWingsOpen(mob)
    local animation = mob:getAnimationSub()

    mob:addStatusEffect(xi.effect.MIGHTY_STRIKES, 1, 0, 0)
    mob:setMod(xi.mod.REGEN, 125)

    if animation == 2 then  -- aura off, wings closed
        mob:setAnimationSub(4) -- aura off, wings open
    elseif animation == 3 then  -- aura on, wings closed
        mob:setAnimationSub(1) -- aura on, wings open
    end
end

local function triggerWingsClosed(mob)
    local animation = mob:getAnimationSub()

    mob:delStatusEffect(xi.effect.MIGHTY_STRIKES)
    mob:setMod(xi.mod.REGEN, 0)

    if animation == 4 then -- aura off, wings open
        mob:setAnimationSub(2) -- aura off, wings closed
    elseif animation == 1 then -- aura on, wings open
        mob:setAnimationSub(3) -- aura on, wings closed
    end
end

local function zilantWings(mob)
    local fightTime          = mob:getLocalVar("fightTime")
    local wingsClosedTime    = math.random(60, 120)  -- time with closed wings - weaker
    local wingsOpenedTime    = math.random(30, 60)  -- time with open wings - stronger
    local intervalTime       = 0
    local animation          = mob:getAnimationSub()
    local currentBattleTime  = mob:getBattleTime()
    local nextAction         = mob:getLocalVar("nextAction")

    if animation == 2 or animation == 3 then
        intervalTime = wingsClosedTime
    elseif animation == 1 or animation == 4 then
        intervalTime = wingsOpenedTime
    end

    if canPerformAction(mob) then
        if animation == 0 then  -- initial setup
            mob:setLocalVar("fightTime", currentBattleTime) -- initial setup for this var
            mob:setLocalVar("nextAction", 1) -- next action is to open wings
            mob:setAnimationSub(2) -- aura off, wings closed
        elseif (animation == 2 or animation == 3) and nextAction == 1 and (currentBattleTime - fightTime > intervalTime) then
            triggerWingsOpen(mob) -- open wings
            mob:setLocalVar("fightTime", currentBattleTime) -- update fightTime
            mob:setLocalVar("nextAction", 2) -- next action is to close wings
        elseif (animation == 1 or animation == 4) and nextAction == 2 and (currentBattleTime - fightTime > intervalTime) then
            triggerWingsClosed(mob) -- close wings
            mob:setLocalVar("mbWindow", 0) -- Reset MB window so 1-3 triggers can occur again
            mob:setLocalVar("fightTime", currentBattleTime) -- update fightTime
            mob:setLocalVar("nextAction", 1) -- next action is to open wings
        end
    end
end

local function getTotalGaleweavers(mob)
    local total = 0
    local weavers = {
        mob:getLocalVar("GALEWEAVER_1"),
        mob:getLocalVar("GALEWEAVER_2"),
        mob:getLocalVar("GALEWEAVER_3"),
    }

    for _, weaver in pairs(weavers) do
        local weaverMob = GetMobByID(weaver)
        if weaverMob and weaverMob:isAlive() then
            total = total + 1
        end
    end

    return total
end
    -- (!) Memo: animation states for Brjota - Zilant
    -- 1 = aura on, wings open
    -- 2 = aura off, wings closed
    -- 3 = aura on, wings closed
    -- 4 = aura off, wings open

    local function auraZilant(mob)
        local animation = mob:getAnimationSub()
        local weavers = getTotalGaleweavers(mob)
        local tierOneEffect = mob:getLocalVar("tierOneEffect")
        local tierTwoEffect = mob:getLocalVar("tierTwoEffect")
        local tierThreeEffect = mob:getLocalVar("tierThreeEffect")
        local lastWeaverCount = mob:getLocalVar("lastWeaverCount")

        -- aura animation logic
        if weavers > 0 then
            if animation == 2 then
                mob:setAnimationSub(3) -- aura on, wings closed
            elseif animation == 4 then
                mob:setAnimationSub(1) -- aura on, wings open
            end
        elseif weavers < 1 then
            if animation == 3 then
                mob:setAnimationSub(2) -- aura off, wings closed
            elseif animation == 1 then
                mob:setAnimationSub(4) -- aura off, wings open
            end
        end

        -- apply effects based on the number of Galeweavers alive
        if weavers > 0 and tierOneEffect == 0 then
            mob:setLocalVar("tierOneEffect", 1)
            mob:setMod(xi.mod.DOUBLE_ATTACK, 30)
        end
        if weavers > 1 and tierTwoEffect == 0 then
            mob:setLocalVar("tierTwoEffect", 1)
            mob:setMod(xi.mod.REGEN, 250) -- 250 HP/tick regen
        end
        if weavers > 2 and tierThreeEffect == 0 then
            mob:setLocalVar("tierThreeEffect", 1)
            mob:setMod(xi.mod.REGAIN, 50) -- 50 TP/tick regain
        end

        -- logic to remove effects if the number of Galeweavers decreases
        if weavers < lastWeaverCount then
            if weavers < 3 and tierThreeEffect == 1 then
                mob:setLocalVar("tierThreeEffect", 0)
                mob:setMod(xi.mod.REGAIN, 25)  -- Default
            end
            if weavers < 2 and tierTwoEffect == 1 then
                mob:setLocalVar("tierTwoEffect", 0)
                mob:setMod(xi.mod.REGEN, 0)
            end
            if weavers < 1 and tierOneEffect == 1 then
                mob:setLocalVar("tierOneEffect", 0)
                mob:setMod(xi.mod.DOUBLE_ATTACK, 0)
            end
        end

        -- update the last known count of Galeweavers. track state
        mob:setLocalVar("lastWeaverCount", weavers)
    end

local battles =
{
    [xi.item.GOLDEN_BANGLE] =
    {
        {
            name = "Searing Eldrake",
            base = { 112, 5 }, -- Shadow Dragon
            look = 421,        -- Dahak
            pop  = "Large Claw Mark",
            desc = "You see a huge claw mark belonging to a dragon.",
            area = "Ifrits_Cauldron",
            pos  = { 61.530, 20.177, -51.503, 98 }, -- !pos 61.530 20.177 -51.503 205
            lv   = 66,
            hp   = 30000, -- 30k
            cap  = 60,
            pts  = { 25, 40 },
            exp  = 9000,
            tally = fmt(info.tally, "ELDRAKE"),
            mods =
            {
                [xi.mod.ATTP]  = 50,
                [xi.mod.DELAY] = -200,
                [xi.mod.UDMGPHYS]   = -3000,
                [xi.mod.UDMGRANGE]  = -2000,
                [xi.mod.UDMGMAGIC]  = -1500,
                [xi.mod.UDMGBREATH] = -2000,
            },
            ae   = xi.mob.ae.ENFIRE,
            ja2h = true,
            pool =
            {
                {
                    { cexi.rate.VERY_COMMON, 2015 }, -- Beast Blood  (38%)
                    { cexi.rate.VERY_COMMON, 1133 }, -- Dragon Blood (38%)
                    { cexi.rate.COMMON,      1133 }, -- Dragon Blood (24%)
                },
                {
                    { cexi.rate.VERY_COMMON, 2015 }, -- Beast Blood  (38%)
                    { cexi.rate.VERY_COMMON, 1133 }, -- Dragon Blood (38%)
                    { cexi.rate.COMMON,      1133 }, -- Dragon Blood (24%)
                },
                {
                    { cexi.rate.VERY_COMMON,  867 }, -- Dragon Scales (44%)
                    { cexi.rate.COMMON,      3297 }, -- Flame Geode   (28%)
                    { cexi.rate.UNCOMMON,     928 }, -- Bomb Ash      (19%)
                    { cexi.rate.RARE,        1108 }, -- Sulfur        ( 9%)
                },
                {
                    { cexi.rate.VERY_COMMON, 643 }, -- Iron Ore      (33%)
                    { cexi.rate.VERY_COMMON, 645 }, -- Darksteel Ore (33%)
                    { cexi.rate.VERY_COMMON, 737 }, -- Gold Ore      (33%)
                },
                {
                    { 520, 0 },                       -- Nothing         (52%)
                    { cexi.rate.VERY_COMMON, 21385 }, -- Cinderstone     (24%)
                    { cexi.rate.VERY_COMMON, 28514 }, -- Adept's Earring (24%)
                },
                {
                    { 800, 0 },                    -- Nothing         (80%)
                    { cexi.rate.UNCOMMON, 21385 }, -- Cinderstone     (10%)
                    { cexi.rate.UNCOMMON, 28514 }, -- Adept's Earring (10%)
                },
            },
        },
        {
            name = "Glacial Wyvern",
            base = { 212, 6 }, -- Bune
            look = 399,        -- Seiryu
            pop  = "Bitten Ice Lump",
            desc = "You see a large lump of ice with a chunk bitten out of it.",
            area = "Xarcabard",
            pos  = { 580.834, -0.773, -21.179, 168 }, -- !pos 580.834 -0.773 -21.179 112
            lv   = 66,
            hp   = 30000, -- 30k
            cap  = 60,
            pts  = { 25, 40 },
            exp  = 9000,
            tally = fmt(info.tally, "GLACIAL"),
            mods =
            {
                [xi.mod.ATTP]  = 50,
                [xi.mod.DELAY] = -400,
                [xi.mod.UDMGPHYS]   = -3000,
                [xi.mod.UDMGRANGE]  = -2000,
                [xi.mod.UDMGMAGIC]  = -1500,
                [xi.mod.UDMGBREATH] = -2000,
            },
            ae   = xi.mob.ae.ENBLIZZARD,
            ja2h = true,
            pool =
            {
                {
                    { cexi.rate.VERY_COMMON, 2015 }, -- Beast Blood  (38%)
                    { cexi.rate.VERY_COMMON, 1133 }, -- Dragon Blood (38%)
                    { cexi.rate.COMMON,      1133 }, -- Dragon Blood (24%)
                },
                {
                    { cexi.rate.VERY_COMMON, 2015 }, -- Beast Blood  (38%)
                    { cexi.rate.VERY_COMMON, 1133 }, -- Dragon Blood (38%)
                    { cexi.rate.COMMON,      1133 }, -- Dragon Blood (24%)
                },
                {
                    { cexi.rate.VERY_COMMON,  867 }, -- Dragon Scales (44%)
                    { cexi.rate.COMMON,      3298 }, -- Snow Geode    (28%)
                    { cexi.rate.UNCOMMON,    4105 }, -- Ice Cluster   (19%)
                    { cexi.rate.RARE,        1108 }, -- Sulfur        ( 9%)
                },
                {
                    { cexi.rate.VERY_COMMON, 644 }, -- Mythril Ore   (33%)
                    { cexi.rate.VERY_COMMON, 736 }, -- Silver Ore    (33%)
                    { cexi.rate.VERY_COMMON, 738 }, -- Platinum Ore  (33%)
                },
                {
                    { 520, 0 },                       -- Nothing           (80%)
                    { cexi.rate.VERY_COMMON, 21384 }, -- Rimestone         (24%)
                    { cexi.rate.VERY_COMMON, 28640 }, -- Hierarch's Mantle (24%)
                },
                {
                    { 800, 0 },                    -- Nothing           (80%)
                    { cexi.rate.UNCOMMON, 21384 }, -- Rimestone         (10%)
                    { cexi.rate.UNCOMMON, 28640 }, -- Hierarch's Mantle (10%)
                },
            },
        },
    },
    [xi.item.GOLDEN_RINGS] =
    {
        {
            name = "Midgardsormr",
            base = { 154, 5 }, -- Fafnir
            look = 610,        -- Ouryu
            pop  = "Trodden Earth",
            desc = "This ground has been crushed by an enormous creature.",
            area = "Meriphataud_Mountains",
            pos  = { 671.446, 0.871, -415.133, 159 }, -- !pos 671.446 0.871 -415.133 119
            lv   = 97,
            hp   = 180000, -- 180k
            pts  = { 110, 160 },
            exp  = 18000,
            ae   = { xi.mob.ae.ENSTONE, 30, 60 },
            ja2h = true,
            mods = wyrmMods.Midgardsormr,
            tally = fmt(info.tally, "MIDGARDSORMR"),
            onMobSpawn = function(mob)
                mob:setLocalVar("nextWindow", 1)
                mob:addImmunity(xi.immunity.DARK_SLEEP)
                mob:addImmunity(xi.immunity.GRAVITY)
                mob:addImmunity(xi.immunity.LIGHT_SLEEP)
                mob:addImmunity(xi.immunity.PETRIFY)
                mob:addImmunity(xi.immunity.SILENCE)
                mbCounter(mob, xi.element.WIND)
                cexi.mob_util.wsPenalty(mob)
            end,
            onMobFight = function(mob, target)
                cexi.mob_util.ignorePet(mob, target)
                cq.spawnWave({
                    parent = mob,
                    target = target,
                    cap    = 75,
                    waves  =
                    {
                        { hp = 90, mobs = mobSets.MOUNTAIN_DARTER },
                        { hp = 80, mobs = mobSets.MOUNTAIN_DARTER },
                        { hp = 70, mobs = mobSets.MOUNTAIN_DARTER },
                        { hp = 60, mobs = mobSets.MOUNTAIN_DARTER },
                        { hp = 50, mobs = mobSets.MOUNTAIN_DARTER },
                        { hp = 40, mobs = mobSets.MOUNTAIN_DARTER },
                        { hp = 30, mobs = mobSets.MOUNTAIN_DARTER },
                        { hp = 20, mobs = mobSets.MOUNTAIN_DARTER },
                        { hp = 10, mobs = mobSets.MOUNTAIN_DARTER },
                    },
                    raiseAllowed = true,
                })

                mbWeaken(mob)
                wyrmFlying(mob)
            end,
            pool =
            {
                upgradeMats,
                wyrmTrash,
                wyrmMats,
                wyrmMats,
                {
                    { 750, 0 },               -- Nothing                    (75%)
                    { cexi.rate.RARE, 1333 }, -- Martial Abjuration: Feet   ( 5%)
                    { cexi.rate.RARE, 1326 }, -- Aquarian Abjuration: Hands ( 5%)
                    { cexi.rate.RARE, 1322 }, -- Earthen Abjuration: Legs   ( 5%)
                    { cexi.rate.RARE, 1335 }, -- Wyrmal Abjuration: Body    ( 5%)
                    { cexi.rate.RARE, 9515 }, -- Fine Ochre                 ( 5%)
                },
                {
                    { cexi.rate.VERY_COMMON, 1333 }, -- Martial Abjuration: Feet   (25%)
                    { cexi.rate.VERY_COMMON, 1326 }, -- Aquarian Abjuration: Hands (25%)
                    { cexi.rate.VERY_COMMON, 1322 }, -- Earthen Abjuration: Legs   (25%)
                    { cexi.rate.VERY_COMMON, 1335 }, -- Wyrmal Abjuration: Body    (25%)
                },
                {
                    { cexi.rate.COMMON, 28577 }, -- Titanium Band      (30%)
                    { cexi.rate.COMMON, 27767 }, -- Erudite Cap        (30%)
                    { cexi.rate.COMMON, 28201 }, -- Acrobat's Breeches (30%)
                    { cexi.rate.RARE,   20554 }, -- Steady Fists       (10%)
                },
                {
                    { 840, 0 },                     -- Nothing            (84%)
                    { cexi.rate.RARE,      28577 }, -- Titanium Band      ( 5%)
                    { cexi.rate.RARE,      27767 }, -- Erudite Cap        ( 5%)
                    { cexi.rate.RARE,      28201 }, -- Acrobat's Breeches ( 5%)
                    { cexi.rate.VERY_RARE, 20554 }, -- Steady Fists       ( 1%)
                },
            },
        },
        {
            name = "Arfarvegr",
            base = { 154, 5 }, -- Fafnir
            look = 609,        -- Jormungand
            pop  = "Scraped Dirt",
            desc = "The mud here has been scraped by a huge claw.",
            area = "Pashhow_Marshlands",
            pos  = { -192.878, 24.787, 132.298, 7 }, -- !pos -192.878 24.787 132.298 109
            lv   = 97,
            hp   = 180000, -- 180k
            pts  = { 110, 160 },
            exp  = 18000,
            ae   = { xi.mob.ae.ENWATER, 30, 60 },
            ja2h = true,
            mods = wyrmMods.Arfarvegr,
            tally = fmt(info.tally, "ARFARVEGR"),
            onMobSpawn = function(mob)
                mob:setLocalVar("nextWindow", 1)
                mob:addImmunity(xi.immunity.DARK_SLEEP)
                mob:addImmunity(xi.immunity.GRAVITY)
                mob:addImmunity(xi.immunity.LIGHT_SLEEP)
                mob:addImmunity(xi.immunity.PETRIFY)
                mob:addImmunity(xi.immunity.SILENCE)

                mbCounter(mob, xi.element.THUNDER)
                cexi.mob_util.wsPenalty(mob)
            end,
            onMobFight = function(mob, target)
                cexi.mob_util.ignorePet(mob, target)
                cq.spawnWave({
                    parent = mob,
                    target = target,
                    cap    = 75,
                    waves  =
                    {
                        { hp = 30, mobs = mobSets.SWAMP_SNIPPER },
                    },
                    raiseAllowed = true,
                })

                mbWeaken(mob)
                wyrmFlying(mob)
            end,
            pool =
            {
                upgradeMats,
                wyrmTrash,
                wyrmMats,
                wyrmMats,
                {
                    { 750, 0 },               -- Nothing                   (75%)
                    { cexi.rate.RARE, 1342 }, -- Neptunal Abjuration: Legs ( 5%)
                    { cexi.rate.RARE, 1328 }, -- Aquarian Abjuration: Feet ( 5%)
                    { cexi.rate.RARE, 1331 }, -- Martial Abjuration: Hands ( 5%)
                    { cexi.rate.RARE, 1315 }, -- Dryadic Abjuration: Body  ( 5%)
                    { cexi.rate.RARE, 9515 }, -- Fine Ochre                ( 5%)
                },
                {
                    { cexi.rate.VERY_COMMON, 1342 }, -- Neptunal Abjuration: Legs (25%)
                    { cexi.rate.VERY_COMMON, 1328 }, -- Aquarian Abjuration: Feet (25%)
                    { cexi.rate.VERY_COMMON, 1331 }, -- Martial Abjuration: Hands (25%)
                    { cexi.rate.VERY_COMMON, 1315 }, -- Dryadic Abjuration: Body  (25%)
                },
                {
                    { cexi.rate.COMMON, 27738 }, -- Assailant's Visor  (30%)
                    { cexi.rate.COMMON, 28459 }, -- Subtle Sash        (30%)
                    { cexi.rate.COMMON, 28062 }, -- Ornate Gloves      (30%)
                    { cexi.rate.RARE,   20740 }, -- Unbreakable        (10%)
                },
                {
                    { 840, 0 },                     -- Nothing            (84%)
                    { cexi.rate.RARE,      27738 }, -- Assailant's Visor  ( 5%)
                    { cexi.rate.RARE,      28459 }, -- Subtle Sash        ( 5%)
                    { cexi.rate.RARE,      28062 }, -- Ornate Gloves      ( 5%)
                    { cexi.rate.VERY_RARE, 20740 }, -- Unbreakable        ( 1%)
                },
            },
        },
        {
            name = "Skrudningr",
            base = { 154, 5 }, -- Fafnir
            look = 611,        -- Vrtra
            flag = 157,
            pop  = "Shredded Bark",
            desc = "This bark from a nearby tree has been shredded by large teeth.",
            area = "Jugner_Forest",
            pos  = { 458.978, 3.750, -135.825, 27 }, -- !pos 458.978 3.750 -135.825 104
            lv   = 97,
            hp   = 180000, -- 180k
            pts  = { 110, 160 },
            exp  = 18000,
            ae   = { xi.mob.ae.ENTHUNDER, 30, 60 },
            mods = wyrmMods.Skrudningr,
            tally = fmt(info.tally, "SKRUDNINGR"),
            ja2h = true,
            onMobSpawn = function(mob)
                mob:setLocalVar("nextWindow", 1)
                mob:addImmunity(xi.immunity.DARK_SLEEP)
                mob:addImmunity(xi.immunity.GRAVITY)
                mob:addImmunity(xi.immunity.LIGHT_SLEEP)
                mob:addImmunity(xi.immunity.PETRIFY)
                mob:addImmunity(xi.immunity.SILENCE)

                mbCounter(mob, xi.element.EARTH)
                cexi.mob_util.wsPenalty(mob)
            end,
            onMobFight = function(mob, target)
                cexi.mob_util.ignorePet(mob, target)
                cq.spawnWave({
                    parent = mob,
                    target = target,
                    cap    = 75,
                    waves  =
                    {
                        { hp = 75, mobs = mobSets.FOREST_WYVERN },
                        { hp = 50, mobs = mobSets.FOREST_WYVERN },
                        { hp = 25, mobs = mobSets.FOREST_WYVERN },
                    },
                    raiseAllowed = true,
                })

                mbWeaken(mob)
                wyrmFlying(mob)
            end,
            pool =
            {
                upgradeMats,
                wyrmTrash,
                wyrmMats,
                wyrmMats,
                {
                    { 750, 0 },                      -- Nothing                   (75%)
                    { cexi.rate.VERY_COMMON, 1321 }, -- Earthen Abjuration: Hands ( 5%)
                    { cexi.rate.VERY_COMMON, 1334 }, -- Wyrmal Abjuration: Head   ( 5%)
                    { cexi.rate.VERY_COMMON, 1317 }, -- Dryadic Abjuration: Legs  ( 5%)
                    { cexi.rate.VERY_COMMON, 1340 }, -- Neptunal Abjuration: Body ( 5%)
                    { cexi.rate.RARE,        9515 }, -- Fine Ochre                ( 5%)
                },
                {
                    { cexi.rate.VERY_COMMON, 1321 }, -- Earthen Abjuration: Hands (25%)
                    { cexi.rate.VERY_COMMON, 1334 }, -- Wyrmal Abjuration: Head   (25%)
                    { cexi.rate.VERY_COMMON, 1317 }, -- Dryadic Abjuration: Legs  (25%)
                    { cexi.rate.VERY_COMMON, 1340 }, -- Neptunal Abjuration: Body (25%)
                },
                {
                    { cexi.rate.COMMON, 27779 }, -- Conqueror's Helm (30%)
                    { cexi.rate.COMMON, 28384 }, -- Loxo Scarf       (30%)
                    { cexi.rate.COMMON, 28458 }, -- Covenant Belt    (30%)
                    { cexi.rate.RARE,   21915 }, -- Stormblade       (10%)
                },
                {
                    { 840, 0 },                     -- Nothing          (80%)
                    { cexi.rate.RARE,      27779 }, -- Conqueror's Helm ( 5%)
                    { cexi.rate.RARE,      28384 }, -- Loxo Scarf       ( 5%)
                    { cexi.rate.RARE,      28458 }, -- Covenant Belt    ( 5%)
                    { cexi.rate.VERY_RARE, 21915 }, -- Stormblade       ( 1%)
                },
            },
        },
    },
    [xi.item.GOLDEN_RINGS_P1] =
    {
        {
            name = "Brjota",
            base = { 154, 5 }, -- Fafnir
            look = 2174,       -- Lofty Zilant
            flag = 157,        -- Big
            skills = 470,      -- Zilant
            pop  = "Dark Scale",
            desc = "You see a mysterious dark scale floating on the surface of the water.",
            area = "Bibiki_Bay",
            pos  = { -641.215, 0.300, -757.848, 219 }, -- !pos -641.215 0.300 -757.848 4
            lv   = 99,
            hp   = 250000, -- 250k
            pts  = { 350, 500 },
            exp  = 27000,
            ae   = { xi.mob.ae.ENAERO, 80, 160 },
            ja2h = true,
            mods = wyrmModsTwo,
            tally = fmt(info.tally, "BRJOTA"),

            onMobSpawn = function(mob)
                mob:addImmunity(xi.immunity.DARK_SLEEP)
                mob:addImmunity(xi.immunity.GRAVITY)
                mob:addImmunity(xi.immunity.LIGHT_SLEEP)
                mob:addImmunity(xi.immunity.PETRIFY)
                mob:addImmunity(xi.immunity.SILENCE)

                mob:setMod(xi.mod.REGAIN, 25)  -- default

                mbCounterBrjota(mob, xi.element.ICE)
                cexi.mob_util.wsPenalty(mob)

                local zone = mob:getZone()

                for index = 1, 3 do
                    local result = zone:queryEntitiesByName(fmt("DE_Galeweaver {}", index))

                    if
                        result    ~= nil and
                        result[1] ~= nil
                    then
                        mob:setLocalVar(fmt("GALEWEAVER_{}", index), result[1]:getID())
                    end
                end
            end,

            onMobFight = function(mob, target)
                cexi.mob_util.ignorePet(mob, target)
                local currentTime = mob:getBattleTime()
                local lastAuraCheck = mob:getLocalVar("auraCheckTime")
                -- Check and update aura every 5 seconds
                if currentTime - lastAuraCheck >= 5 then
                    mob:setLocalVar("auraCheckTime", currentTime)
                    auraZilant(mob)
                end
                cq.spawnWave({
                    parent = mob,
                    target = target,
                    cap    = 75,
                    waves  =
                    {
                        { hp = 90, mobs = mobSets.GALEWEAVER },
                        { hp = 80, mobs = mobSets.GALEWEAVER },
                        { hp = 70, mobs = mobSets.GALEWEAVER },
                        { hp = 60, mobs = mobSets.GALEWEAVER },
                        { hp = 50, mobs = mobSets.GALEWEAVER },
                        { hp = 40, mobs = mobSets.GALEWEAVER },
                        { hp = 30, mobs = mobSets.GALEWEAVER },
                        { hp = 20, mobs = mobSets.GALEWEAVER },
                        { hp = 10, mobs = mobSets.GALEWEAVER },
                    },
                    raiseAllowed = true,
                })

                mbWeaken(mob)
                zilantWings(mob)
            end,

            pool =
            {
                {
                    { cexi.rate.GUARANTEED,  9454 }, -- Embersteel Ingot (100%)
                },
                upgradeMats,
                wyrmMats,
                wyrmMats,
                {
                    { 600, 0 },                      -- Nothing                     (60%)
                    { cexi.rate.VERY_COMMON, 1320 }, -- Earthen Abjuration: Body    ( 5%)
                    { cexi.rate.VERY_COMMON, 1325 }, -- Aquarian Abjuration: Body   ( 5%)
                    { cexi.rate.VERY_COMMON, 2430 }, -- Phantasmal Abjuration: Body ( 5%)
                    { cexi.rate.VERY_COMMON, 2435 }, -- Hadean Abjuration: Body     ( 5%)
                    { cexi.rate.COMMON,      5965 }, -- Isleracea                   (15%)
                    { cexi.rate.RARE,        3545 }, -- Serica Cloth                ( 5%)
                },
                {
                    { cexi.rate.VERY_COMMON, 1320 }, -- Earthen Abjuration: Body    (24%)
                    { cexi.rate.VERY_COMMON, 1325 }, -- Aquarian Abjuration: Body   (24%)
                    { cexi.rate.VERY_COMMON, 2430 }, -- Phantasmal Abjuration: Body (24%)
                    { cexi.rate.VERY_COMMON, 2435 }, -- Hadean Abjuration: Body     (24%)
                },
                {
                    { cexi.rate.COMMON, 28305 }, -- Ruthless Greaves (30%)
                    { cexi.rate.COMMON, 28050 }, -- Swift Gages      (30%)
                    { cexi.rate.COMMON, 27781 }, -- Windfall Hat     (30%)
                    { cexi.rate.RARE,   20936 }, -- Hurricane        (10%)
                },
                {
                    { 840, 0 },                     -- Nothing          (80%)
                    { cexi.rate.RARE,      28305 }, -- Ruthless Greaves ( 5%)
                    { cexi.rate.RARE,      28050 }, -- Swift Gages      ( 5%)
                    { cexi.rate.RARE,      27781 }, -- Windfall Hat     ( 5%)
                    { cexi.rate.VERY_RARE, 20936 }, -- Hurricane        ( 1%)
                },
            },
        },
    },
}

-----------------------------------
-- Searing Eldrake
-----------------------------------
m:addOverride("xi.actions.mobskills.heavy_stomp.onMobWeaponSkill", function(target, mob, skill)
    local mobName = mob:getPacketName()

    if mobName == "Searing Eldrake" then
        if target ~= nil then
            target:addStatusEffect(xi.effect.BURN,    12, 0, 30)
        end
    end

    return super(target, mob, skill)
end)

m:addOverride("xi.actions.mobskills.body_slam.onMobWeaponSkill", function(target, mob, skill)
    local mobName = mob:getPacketName()

    if mobName == "Searing Eldrake" then
        if target ~= nil then
            target:addStatusEffect(xi.effect.BURN,    12, 0, 30)
        end
    end

    return super(target, mob, skill)
end)

m:addOverride("xi.actions.mobskills.petro_eyes.onMobWeaponSkill", function(target, mob, skill)
    local mobName = mob:getPacketName()

    if mobName == "Searing Eldrake" then
        if target ~= nil then
            mob:resetEnmity(target)
        end
    end

    return super(target, mob, skill)
end)

-----------------------------------
-- Glacial Wyvern
-----------------------------------
m:addOverride("xi.actions.mobskills.dread_shriek.onMobWeaponSkill", function(target, mob, skill)
    local mobName = mob:getPacketName()

    if mobName == "Glacial Wyvern" then
        if target ~= nil then
            target:addStatusEffect(xi.effect.FROST,    15, 0, 30)
        end
    end

    return super(target, mob, skill)
end)

m:addOverride("xi.actions.mobskills.wind_wall.onMobWeaponSkill", function(target, mob, skill)
    local mobName = mob:getPacketName()

    if mobName == "Glacial Wyvern" then
        if target ~= nil then
            target:addStatusEffect(xi.effect.BLINK, math.random(6, 12), 0, 120)
        end
    end

    return super(target, mob, skill)
end)

-----------------------------------
-- Wyrms
-----------------------------------
m:addOverride("xi.actions.mobskills.hurricane_wing.onMobWeaponSkill", function(target, mob, skill)
    local mobName = mob:getPacketName()

    if mobName == "Midgardsormr" then
        mob:addStatusEffect(xi.effect.STONESKIN, 500 * (mob:getLocalVar("weaknessCounter") + 1), 0, 0)

        if target ~= nil then
            target:addStatusEffect(xi.effect.SLOW, 2500, 0, 120)
        end

    elseif mobName == "Arfarvegr" then
        mob:addStatusEffect(xi.effect.BLOOD_WEAPON, 200, 0, 60)

        if target ~= nil then
            target:addStatusEffect(xi.effect.DROWN, 50, 0, 60)
        end

    elseif mobName == "Skrudningr" then
        mob:addStatusEffect(xi.effect.SHOCK_SPIKES, 80, 0, 60)

        if target ~= nil then
            target:addStatusEffect(xi.effect.STUN, 1, 0, 10)
        end

    elseif mobName == "Brjota" then
        if target ~= nil then
            target:addStatusEffect(xi.effect.SILENCE, 25, 0, 60)
            target:addStatusEffect(xi.effect.CHOKE,   25, 0, 60)
        end
    end

    return super(target, mob, skill)
end)

m:addOverride("xi.actions.mobskills.inferno_blast_alt.onMobWeaponSkill", function(target, mob, skill)
    if mob:getPacketName() == "Skrudningr" then
        local dmgmod = 1
        local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.THUNDER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.THUNDER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.THUNDER)
        skill:setMsg(xi.msg.basic.HIT_DMG)
        return dmg
    else
        return super(target, mob, skill)
    end
end)

m:addOverride("xi.actions.mobskills.sleet_blast_alt.onMobWeaponSkill", function(target, mob, skill)
    if mob:getPacketName() == "Arfarvegr" then
        local dmgmod = 1
        local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.WATER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WATER, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WATER)
        skill:setMsg(xi.msg.basic.HIT_DMG)
        return dmg
    else
        return super(target, mob, skill)
    end
end)

local VALSANG      = "VALSANG"
local SIGMUND      = "SIGMUND"
local PILE         = "PILE"
local PileOfStones = "Pile of Stones"
local IVALDI       = "IVALDI"

local entity =
{
    {
        id     = VALSANG,
        name   = "Valsang",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.HUME_M,
            face = cexi.face.A1,
            main = 265, -- Onion Sword
            body = cexi.model.DOUBLET,
            hand = cexi.model.DOUBLET,
            legs = cexi.model.DOUBLET,
            feet = cexi.model.DOUBLET,
        }),
        area   = "Upper_Jeuno",
        pos    = { -30.608, -0.700, 72.861, 199 }, -- !pos -30.608 -0.700 72.861 244
        dialog =
        {
            DEFAULT =
            {
                "Valsang : Wow, this place is so cool!",
            },
        },
    },
    {
        id     = SIGMUND,
        name   = "Sigmund",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A1,
            main = 432, -- Naglering
            head = 326, -- Taeon Chapeau
            body = cexi.model.CRIMSON_SCALE_MAIL,
            hand = 336, -- Dux Finger Gauntlets
            legs = cexi.model.CRIMSON_SCALE_MAIL,
            feet = 336, -- Dux Greaves
        }),
        area   = "Mhaura",
        pos    = { 16.629, -8.000, 61.415, 95 }, -- !pos 16.579 -8.000 61.308 249
        dialog =
        {
            DEFAULT = { "Sigmund : Some legends are better left forgotten..." },
        },
    },
    {
        id       = PILE,
        name     = PileOfStones,
        type     = xi.objType.NPC,
        hidename = true,
        look     = 2777,
        area     = "The_Sanctuary_of_ZiTah", -- (H-7)
        pos      = { 77.818, 6.947, 230.420, 123 }, -- !pos 77.818 6.947 230.420 121
        dialog   =
        {
            DEFAULT = { "You hear nothing but the wind." },
        },
    },
    {
        id       = IVALDI,
        name     = "Ivaldi",
        type     = xi.objType.NPC,
        namevis  = 0x80, -- Ghost
        notarget = true,
        look     = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A8,
            main = 307, -- Mjollnir
            offh = 40,  -- Viking Shield
            body = cexi.model.BLACKSMITHS_SMOCK,
            hand = 118, -- Smithy's Mitts
            legs = 115, -- Penance Slops
            feet = 115, -- Penance Sabots
        }),
        area     = "The_Sanctuary_of_ZiTah",
        pos      = { 77.388, 6.845, 232.066, 112 }, -- !pos 77.388 6.845 232.066 121
        hidden   = true,
    },
}

local function createAdd(mobInfo, name, pos)
    table.insert(entity, {
        id          = string.upper(name),
        packetName  = mobInfo.name,
        name        = name,
        type        = xi.objType.MOB,
        groupId     = mobInfo.base[2],
        groupZoneId = mobInfo.base[1],
        area        = mobInfo.area,
        pos         = pos,
        level       = mobInfo.level,
        loot        = mobInfo.loot,
        mods        = mobInfo.mods,
        effects     = mobInfo.effects,
        immunities  =
        {
            xi.immunity.DARK_SLEEP,
            xi.immunity.GRAVITY,
            xi.immunity.LIGHT_SLEEP,
            xi.immunity.PETRIFY,
            xi.immunity.SILENCE,
            xi.immunity.TERROR,
        },

        restore     = true,
        onMobRoam   = function(mob)
            mob:setHP(0)
        end,
    })
end

for _, mobInfo in pairs(mobs) do
    if #mobInfo.pos > 0 then
        for index, mobPos in pairs(mobInfo.pos) do
            createAdd(mobInfo, fmt("{} {}", mobInfo.name, index), mobPos)
        end
    else
        createAdd(mobInfo, mobInfo.name, mobInfo.pos)
    end
end

local function ivaldiDialog(tbl)
    return cq.npcSpawner(tbl, "Ivaldi", PileOfStones, true)
end

local function delaySendMenu(player, menu)
    player:timer(200, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function ivaldiOnTrigger(player, npc)
    if player:getLocalVar("BUSY") == 1 then
        return
    end

    player:setLocalVar("BUSY", 1)

    local tbl = ivaldiDialog({
        "Ivaldi : So you've become a dragon slayer like old Sigmund eh.",
        " We worked together for many years but that was long ago.",
        { entity = "Ivaldi", emote = xi.emote.SIGH },
        { delay = 3000 },
        "Ivaldi : My spirit cannot rest while Vana'diel is still plagued by dragons.",
        " If you find any potent items in their spoils, leave them at my feet and I will infuse them with additional power.",
        "Ivaldi : Perhaps armed with my skills and your determination, we may finally rid the land of these foul beasts.",
    })

    local delay = cexi.util.dialogDelay(tbl)
    cexi.util.dialog(player, tbl)

    player:timer(delay, function()
        player:setLocalVar("BUSY", 0)
    end)
end

-----------------------------------
-- Ivaldi (Upgrades)
-----------------------------------
local function getAugTier(itemInfo, itemAug)
    local tier = 0

    for augTier = 1, #itemInfo.tier do
        if
            itemInfo.tier[augTier].augs[1] == itemAug[1][1] and
            itemInfo.tier[augTier].augs[2] == itemAug[1][2] and
            itemInfo.tier[augTier].augs[3] == itemAug[2][1] and
            itemInfo.tier[augTier].augs[4] == itemAug[2][2]
        then
            tier = augTier
        end
    end

    return tier
end

local function getTotalCost(player, cost)
    if player:getCharVar("[DS]TALLY_BRJOTA") > 0 then
        return math.floor(cost * 0.75)
    end

    return cost
end

local function ivaldiOnTrade(player, npc, trade)
    for _, itemInfo in pairs(upgrades) do
        if npcUtil.tradeHas(trade, itemInfo.item, false) then
            local item = cexi.util.augment.getTradedItem(trade, itemInfo.item)
            local augs = cexi.util.augment.getAugments(player, item)
            local tier = 0

            if #augs > 0 then
                tier = getAugTier(itemInfo, augs)
            end

            if tier == #itemInfo.cost then
                cexi.util.dialog(player, ivaldiDialog({ "Ivaldi : I've done the most I possibly can to enhance this item." }))
                return
            end

            local tierInfo = itemInfo.tier[tier + 1]

            if npcUtil.tradeHasExactly(trade, itemInfo.item) then
                local totalCost = getTotalCost(player, itemInfo.cost[tier + 1])

                cexi.util.dialog(player, ivaldiDialog({
                    fmt("Ivaldi : I can increase the power of your {} if you bring me the following materials together with {} dragon killer points:", itemInfo.name, totalCost),
                    tierInfo.desc,
                }))
                return
            end

            if cexi.util.tradeHasExactly(trade, { { itemInfo.item, 1 },tierInfo.mats[1], tierInfo.mats[2] } ) then
                local totalCost = getTotalCost(player, itemInfo.cost[tier + 1])

                if player:getCharVar(info.points) < totalCost then
                    cexi.util.dialog(player, ivaldiDialog({
                        fmt("Ivaldi : Ah... I'm glad you've brought me this, but you don't yet have enough dragon killer points.")
                    }))

                    return
                end

                player:incrementCharVar(info.points, -totalCost)
                player:tradeComplete()
                cexi.util.dialog(player, ivaldiDialog({ "Ivaldi : It is done." }))

                player:addItem(itemInfo.item, 1, tierInfo.augs[1], tierInfo.augs[2], tierInfo.augs[3], tierInfo.augs[4], tierInfo.augs[5], tierInfo.augs[6])
                player:timer(2000, function()
                    npc:independentAnimation(player, 12, 2)
                    player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, itemInfo.item)
                end)

                if tier == 5 then
                    local varName = fmt("WYRM_{}", string.upper(itemInfo.name))
                    local message = fmt("{} obtained the first fully upgraded {}!", player:getName())
                    cexi.crystal_warrior.announcement.worldFirst(player, varName, message)
                end
            end
        end
    end
end

-----------------------------------
-- Sigmund
-----------------------------------
local function storeMeritPoints(player, npc)
    local merits = player:getMeritCount()

    delaySendMenu(player, {
        title   = fmt("Store {} Merit Points?", merits),
        options =
        {
            {
                "No",
                function()
                end,
            },
            {
                "Yes",
                function()
                    local stored = player:getCharVar(info.merits)
                    local total  = stored + merits

                    player:setCharVar(info.merits, total)
                    player:setMerits(0)
                    player:fmt("You store {} Merit Points (Total stored: {}).", merits, total)
                end,
            },
        },
    })
end

local function spendMeritPoints(player, npc, item)
    local balance = player:getCharVar(info.merits)

    if balance < item[3] then
        player:sys("You can't afford that yet.")
        return
    end

    delaySendMenu(player, {
        title   = fmt("Purchase {} ({})?", item[1], item[3]),
        options =
        {
            {
                "No",
                function()
                end,
            },
            {
                "Yes",
                function()
                    cexi.util.dialog(player, item[4], npc:getPacketName(), { npc = npc })

                    if npcUtil.giveItem(player, item[2]) then
                        player:incrementCharVar(info.merits, -item[3])
                    end
                end,
            },
        },
    })
end

local function spendDragonKillerPoints(player, npc, item)
    local balance = player:getCharVar(info.points)

    if balance < item[3] then
        player:sys("You can't afford that yet.")
        return
    end

    delaySendMenu(player, {
        title   = fmt("Purchase {} ({})?", item[1], item[3]),
        options =
        {
            {
                "No",
                function()
                end,
            },
            {
                "Yes",
                function()
                    cexi.util.dialog(player, {
                        "It's all yours.",
                    }, npc:getPacketName(), { npc = npc } )

                    if npcUtil.giveItem(player, item[2]) then
                        player:incrementCharVar(info.points, -item[3])
                    end
                end,
            },
        },
    })
end

local function sigmundOnTrigger(player, npc, tbl)
    local balance = player:getCharVar(info.merits)

    delaySendMenu(player, {
        title   = "What will it be?",
        options =
        {
            {
                "Nothing",
                function()
                end,
            },
            {
                "Store Merit Points",
                storeMeritPoints,
            },
            {
                "Spend Merit Points",
                function()
                    if
                        player:isCrystalWarrior() or
                        player:isClassicMode()
                    then
                        cexi.util.simpleShop(player, npc, classicShopList, spendMeritPoints, fmt("Purchase a lure ({} merit points):", balance))
                    else
                        cexi.util.simpleShop(player, npc, shopList, spendMeritPoints, fmt("Purchase a lure ({} merit points):", balance))
                    end
                end,
            },
            {
                "Spend Dragon Killer Points",
                function()
                    local dkp = player:getCharVar(info.points)
                    cexi.util.simpleShop(player, npc, dkpList, spendDragonKillerPoints, fmt("Spend DKP ({}):", dkp))
                end,
            },
        },
    })
end

local function sigmundOnTrade(player, npc, trade)
    for _, itemInfo in pairs(upgrades) do
        if cexi.util.tradeHasExactly(trade, itemInfo.item) then
            delaySendMenu(player, {
                title   = fmt("Sell {} for {} points?", itemInfo.name, itemInfo.sell),
                options =
                {
                    {
                        "No",
                        function()
                        end,
                    },
                    {
                        "Yes",
                        function()
                            cexi.util.dialog(player, {
                                "Consider it done.",
                            }, npc:getPacketName(), { npc = npc } )
                            player:tradeComplete()
                            player:incrementCharVar(info.points, itemInfo.sell)
                            player:sys("{} gains {} dragon killer points.", player:getName(), itemInfo.sell)
                        end,
                    },
                },
            })
        end
    end

    if cexi.util.tradeHasExactly(trade, xi.item.WYRM_GOLD) then
        player:tradeComplete()

        cexi.util.dialog(player, {
            "Absolutely incredible! You've uncovered a wyrm's most prized treasure!",
        }, npc:getPacketName(), { npc = npc })

        player:timer(1000, function()
            npcUtil.giveCurrency(player, "gil", 150000)
            player:incrementCharVar(info.points, 600)
            player:sys("{} gains {} dragon killer points.", player:getName(), 600)
        end)
    end
end

local step =
{
    {
        check     = cq.checks({ level = 60 }),
        [VALSANG] = cq.dialog({
            quest = info.name,
            event =
            {
                "Valsang : H-hey! Have you heard about Sigmund the Dragonslayer?",
                { emote = xi.emote.AMAZED },
                { delay = 1000 },
                " They say he defeated a grand Wyrm single-handedly!",
                "Zelma : There he goes again... More of his thoroughly ridiculous fairy tales.",
                { delay = 1000 },
                { emote = xi.emote.SIGH },
                "Valsang : Umm... Anyway, legend has it, after the very last dragon was defeated, Sigmund retired to the quiet coastal town of Mhaura.",
                " At least that's how the story goes...",
            },
        }),
    },
    {
        [VALSANG] = cq.dialog({
            step  = false,
            name  = "Valsang",
            event =
            {
                "Umm... Anyway, legend has it, after the very last dragon was defeated Sigmund retired to the coastal town of Mhaura.",
                " At least that's how the story goes...",
            },
        }),
        [SIGMUND] = cq.dialog({
            name  = "Sigmund",
            event =
            {
                "Dragonslaying? Haha... Please settle down. That was a lifetime ago.",
                " You? You can't be serious.",
                { emote = xi.emote.THINK },
                { delay = 2000 },
                "Well. I suppose if you're willing to do me a favor I could teach you a thing or two.",
                { emote = xi.emote.YES },
                { delay = 1000 },
                " Though I must warn you, it isn't all as glamarous as the epics make it out to be.",
                " You must train hard. You must be willing to risk it all.",
                { delay = 1000 },
                { emote = xi.emote.PSYCH },
                "It is no easy task to face off against the most fierocious and deadly creatures on Vana'diel!",
                { delay = 2000 },
                " ...Fine. Let's not get carried away... Not just yet.",
            },
        }),
    },
    {
        [SIGMUND] =
        {
            onTrigger = cq.dialog({
                name  = "Sigmund",
                event =
                {
                    "There is a sword buried somewhere in the Sanctuary of Zi'Tah.",
                    " It has great sentimental value to me. Bring me the sword, and I'll teach you.",
                },
            }),
        },
    },
    {
        [PILE] =
        {
            onTrigger = cq.dialog({
                step  = false,
                event =
                {
                    { noturn = true },
                    "Excavation is possible here if you have a pickaxe."
                },
            }),
            onTrade   = cq.trade({
                required = xi.item.PICKAXE,
                declined =
                {
                    { noturn = true },
                    "Excavation is possible here if you have a pickaxe."
                },
                accepted =
                {
                    { noturn  = true },
                    { entity  = "player", emote = xi.emote.EXCAVATION },
                    { delay   = 1500 },
                    { spawn   = { "Ivaldi" } },
                    { delay   = 500 },
                    { entity  = "Ivaldi", face = "player" },
                    { delay   = 500 },
                    { entity  = "player", emote = xi.emote.SHOCKED },
                    "Ivaldi : ...Why have you disturbed me?",
                    { entity  = "Ivaldi", emote = xi.emote.SIGH },
                    { delay   = 3000 },
                    " Ah, Sigmund? Yes... I have a sword for him.",
                    { entity  = "Ivaldi", emote = xi.emote.YES },
                    { delay   = 2000 },
                    "Ivaldi : Return the sword. I have a feeling we will be meeting again very soon.",
                    { emotion = "takes Sigmund's Sword." },
                    { delay   = 1000 },
                    { despawn = { "Ivaldi" } },
                },
            }),
        },
    },
    {
        [SIGMUND] =
        {
            onTrigger = cq.dialog({
                name  = "Sigmund",
                event =
                {
                    "You have the sword? Very good.",
                    { emote = xi.emote.CLAP },
                    { delay = 2000 },
                    " You were met by a ghost?",
                    { emote = xi.emote.LAUGH },
                    { delay = 2000 },
                    " In time you will come to understand. Let us begin.",
                },
            }),
        },
    },
    {
        [SIGMUND] =
        {
            onTrigger = cq.dialog({
                name  = "Sigmund",
                event =
                {
                    "I will honor our agreement and teach you the art of Dragonslaying.",
                    { delay = 1000 },
                    { emote = xi.emote.YES },
                    " The hardest part is knowing where to look. However...",
                    " Armed with the right treasures, one can simply lure the beasts out of hiding.",
                    { emote = xi.emote.THINK },
                    { delay = 2000 },
                    "Speak to me when you're ready to begin, and I shall give you an assignment befitting your current level of experience.",
                },
            }),
        },
    },
    {
        [SIGMUND] =
        {
            onTrigger = sigmundOnTrigger,
            onTrade   = sigmundOnTrade,
        },
        [PILE]    =
        {
            onTrigger = ivaldiOnTrigger,
            onTrade   = ivaldiOnTrade,
        },
    },
}

local function isMobAlive(zone, name)
    local result = zone:queryEntitiesByName("DE_" .. name)

    for _, mob in pairs(result) do
        if mob ~= nil and mob:isAlive() then
            return true
        end
    end

    return false
end

local function joinInstance(obj)
    return function(player, npc, tbl)
        local instance = player:getCharVar(obj.instance)

        if instance == 0 then
            local zoneID   = player:getZoneID()
            local alliance = player:getAlliance()

            for i = 1, #alliance do
                if
                    alliance[i]:isPC() and
                    alliance[i]:getZoneID() == zoneID
                then
                    if alliance[i]:getCharVar(obj.instance) ~= 0 then
                        player:fmt("Members of your party must wait longer to repeat this battle.")
                        return
                    end
                end
            end

            cexi.util.dialog(player, obj.event)
            return
        end

        if player:hasStatusEffect(xi.effect.LEVEL_RESTRICTION) then
            return
        end

        local zone = player:getZone()

        if isMobAlive(zone, obj.name) then
            local serverVar = GetServerVariable(obj.instance)

            if instance ~= serverVar then
                player:fmt("You are not participating in this battle.")
            else
                delaySendMenu(player, {
                    title   = "Return the battle?",
                    options =
                    {
                        {
                            "Not yet",
                            function()
                            end,
                        },
                        {
                            "I'm ready",
                            function(playerArg)
                                playerArg:addStatusEffectEx(
                                    xi.effect.LEVEL_RESTRICTION,
                                    xi.effect.LEVEL_RESTRICTION,
                                    obj.levelCap,
                                    0,
                                    0,
                                    0,
                                    0,
                                    0,
                                    xi.effectFlag.ON_ZONE + xi.effectFlag.CONFRONTATION
                                )

                                playerArg:addStatusEffect(xi.effect.WEAKNESS, 1, 0, 300)
                            end,
                        },
                    } ,
                })
            end
        else
            player:fmt("You must wait longer to repeat this battle.")
        end
    end
end

local function nameToID(str)
    return string.upper(string.gsub(str, " ", "_"))
end

for itemID, tier in pairs(battles) do
    for _, battle in pairs(tier) do
        local popID = nameToID(battle.pop)
        local mobID = nameToID(battle.name)

        table.insert(entity, {
            id          = popID,
            name        = battle.pop,
            marker      = cq.MAIN_QUEST,
            area        = battle.area,
            pos         = battle.pos,
            dialog      =
            {
                DEFAULT = cq.NOTHING,
                AFTER   = cq.NOTHING_ELSE,
            },
        })

        table.insert(entity, {
            id          = mobID,
            name        = battle.name,
            type        = xi.objType.MOB,
            groupId     = battle.base[2],
            groupZoneId = battle.base[1],
            look        = battle.look,
            flags       = battle.flag or 592,
            area        = battle.area,
            pos         = battle.pos,
            level       = battle.lv,
            hp          = battle.hp,
            skillList   = battle.skills,
            mods        = battle.mods,
            effects     = battle.fx,
            aeffect     = battle.ae,
            tally       = battle.tally,
            immunities  =
            {
                xi.immunity.DARK_SLEEP,
                xi.immunity.GRAVITY,
                xi.immunity.LIGHT_SLEEP,
                xi.immunity.PETRIFY,
                xi.immunity.SILENCE,
            },
            jobSpecial  = battle.ja2h,
            pool        = battle.pool,
            onMobSpawn  = battle.onMobSpawn,
            onMobFight  = battle.onMobFight,
            casket      = true,
            points      =
            {
                var     = info.points,
                message = "{} gains {} dragon killer points.",
                amount  = battle.pts,
                exp     = battle.exp,
            },
        })

        local instanceVar = fmt(info.instance, mobID)

        step[7][popID] =
        {
            onTrigger = joinInstance({
                name         = battle.name,
                levelCap     = battle.cap or 75,
                raiseAllowed = true,
                instance     = instanceVar,
                event        = { battle.desc },
            }),
            onTrade   = cq.tradeSpawn(mobID, itemID, {
                check        = { allzero = instanceVar },
                levelCap     = battle.cap or 75,
                raiseAllowed = true,
                instance     = instanceVar,
            }),
        }

        step[7][mobID] = cq.killStep(popID, { mobID }, 6)
    end
end

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
