-----------------------------------
-- Job Mastery System
-----------------------------------
-- NOT CURRENTLY LIVE
-----------------------------------
-- Job Master !pos -27.221 2.002 57.085 243
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/utils")
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cq_mastery")

local info =
{
    name   = "Mastery System",
    author = "Loxley",
    var    = "[CQ]MASTERY_STEP",
    tier   = "[CQ]MASTERY_{}",
    lock   = "[CQ]MASTERY_NM",
    flag   = "[CQ]MASTERY_POP",
    npc    = "Job Master",
}

local matsRequired =
{
    [xi.slot.HEAD]  = { 3, 3 },
    [xi.slot.BODY]  = { 5, 5 },
    [xi.slot.HANDS] = { 2, 2 },
    [xi.slot.LEGS]  = { 4, 4 },
    [xi.slot.FEET]  = { 2, 2 },
}

local tiers =
{
    xi.slot.FEET,
    xi.slot.HANDS,
    xi.slot.HEAD,
    xi.slot.LEGS,
    xi.slot.BODY,
}

local reduction =
{
    20,
    30,
    40,
    50,
    60,
}

-----------------------------------
-- Data
-----------------------------------
local jobs =
{
    [xi.job.WAR] =
    {
        armor =
        {
            [xi.slot.HEAD]  = { "Fighter's Mask",     15225, 23040,  49,   41,  2, 0 },
            [xi.slot.BODY]  = { "Fighter's Lorica",   14473, 23107,  54,   39,  0, 3 },
            [xi.slot.HANDS] = { "Fighter's Mufflers", 14890, 23174,  54,   39,  0, 3 },
            [xi.slot.LEGS]  = { "Fighter's Cuisses",  15561, 23241,  54,   39,  0, 3 },
            [xi.slot.FEET]  = { "Fighter's Calligae", 15352, 23308, 143,  142,  0, 3 },
        },
        mats  =
        {
            { "Behemoth Leather",  862 },
            { "Cyan Orb",         9256 },
        },
        battle =
        {
            name = "Warrior Master",
            pop  = "Ancient Grit",
            base = { 208, 34 }, -- Antican_Consul
            zone = "Quicksand_Caves", -- (G-7)
            pos  = { -853.764, -0.750, -391.081, 162 }, -- !pos -853.764 -0.750 -391.081 208
        },
    },
}

-----------------------------------
-- NPC Functions
-----------------------------------
local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function onTrigger(player, npc)
    local jobID    = player:getMainJob()
    local jobLevel = player:getMainLvl()
    local jobName  = xi.jobNames[jobID][2]

    if jobLevel == 75 then
        local tierVar = fmt(info.tier, xi.jobNames[jobID][1])
        local tier    = player:getCharVar(tierVar)

        if tier == 0 then
            cexi.util.dialog(player, {
                fmt("Looking to undertake {} Mastery?", jobName),
                fmt(" As a first timer, you'll be able to receive the {} +2.", jobs[jobID].armor[tiers[1]][1]),
                fmt(" Your {} EXP will be reduced by {} percent until you reach Level 75.", jobName, reduction[1]),
            }, info.npc, { npc = npc })

            delaySendMenu(player, {
                title   = "Are you sure?",
                options =
                {
                    {
                        "No way!",
                        function()
                        end,
                    },
                    {
                        fmt("Reset {} to Level 1", xi.jobNames[jobID][1]),
                        function()
                            player:setLevel(1)
                            player:setCharVar(tierVar, 1)
                            player:sys("You are now undertaking {} Mastery {}.", jobName, cexi.numeral[tier + 1])
                        end,
                    },
                },
            })
        else
            local slot     = tiers[tier]
            local nextTier = tier + 1
            local nextSlot = tiers[nextTier]
            local armor    = jobs[jobID].armor

            if player:hasItem(armor[slot][3]) then
                if tier == #tiers then
                    cexi.util.dialog(player, {
                        fmt("Congratulations on completing your {} Mastery!", jobName)
                    }, info.npc, { npc = npc })

                    return
                end

                cexi.util.dialog(player, {
                    fmt("Ready to take on {} Mastery {}?", jobName, cexi.numeral[nextTier]),
                    fmt(" After reaching Level 75 again, you'll be able to receive the {} +2.", armor[nextSlot][1]),
                    fmt(" Your {} EXP will be reduced by {} percent until you reach Level 75.", jobName, reduction[nextTier]),
                }, info.npc, { npc = npc })

                delaySendMenu(player, {
                    title   = "Are you sure?",
                    options =
                    {
                        {
                            "No way!",
                            function()
                            end,
                        },
                        {
                            fmt("Reset {} to Level 1", xi.jobNames[jobID][1]),
                            function()
                                player:setLevel(1)
                                player:setCharVar(tierVar, nextTier)
                                player:sys("You are now undertaking {} Mastery {}.", jobName, cexi.numeral[nextTier])
                            end,
                        },
                    },
                })
            else
                cexi.util.dialog(player, {
                    fmt("Congratulations on reaching Level 75 on {}!", jobName),
                    fmt(" To finish this Mastery tier and obtain the {} +2, you'll first need to trade me some materials.", armor[slot][1]),
                    fmt("For this piece, you'll need to bring me {} {} and {} {}.", matsRequired[slot][1], jobs[jobID].mats[1][1], matsRequired[slot][2], jobs[jobID].mats[2][1]),
                    fmt(" You'll also need to provide a maximally augmented {} +1 from the Vision system.", armor[slot][1]),
                }, info.npc, { npc = npc })
            end
        end
    else
        local tierVar = fmt(info.tier, xi.jobNames[jobID][1])
        local tier    = player:getCharVar(tierVar)

        if tier > 0 then
            cexi.util.dialog(player, {
                fmt("You are currently undertaking {} Mastery.", jobName),
                " How goes the journey? Once you reach Level 75, return to me.",
            }, info.npc, { npc = npc })
        else
            cexi.util.dialog(player, {
                fmt("You'll need to reach Level 75 on {} before you can undertake Mastery.", jobName)
            }, info.npc, { npc = npc })
        end
    end
end

local function onTrade(player, npc, trade)
    local jobLevel = player:getMainLvl()

    if jobLevel == 75 then
        local jobID   = player:getMainJob()
        local tierVar = fmt(info.tier, xi.jobNames[jobID][1])
        local tier    = player:getCharVar(tierVar)
        local slot    = tiers[tier]
        local piece   = jobs[jobID].armor[slot]

        if
            tier > 0 and
            not player:hasItem(piece[3]) and
            cexi.util.tradeHasExactly(trade, {
                { piece[2], 1 },
                { jobs[jobID].mats[1][2], matsRequired[slot][1] },
                { jobs[jobID].mats[2][2], matsRequired[slot][2] },
            })
        then

            local item = cexi.util.augment.getTradedItem(trade, piece[2])
            local aug1 = item:getAugment(0)
            local aug2 = item:getAugment(1)

            if
                aug1[1] == piece[4] and
                aug1[2] == piece[6] + 2 and
                aug2[1] == piece[5] and
                aug2[2] == piece[7] + 2
            then
                player:tradeComplete()

                cexi.util.dialog(player, {
                    fmt("Well done. Your next step is to defeat {} in {}.", jobs[jobID].battle.name, string.gsub(jobs[jobID].battle.zone, "_", " ")),
                    fmt(" The difficulty will be set to Tier {} and you must face this battle alone.", cexi.numeral[tier]),
                    fmt("Once you've returned with proof, I shall award you with the {} +2.", piece[1] ),
                }, info.npc, { npc = npc })

                player:setCharVar(info.var,      1)
                player:setCharVar(info.lock, jobID)
            else
                cexi.util.dialog(player, {
                    fmt("I see you have everything here... However."),
                    fmt(" Unfortunately that {} +1 has not yet reached its maximum augment potential using the Vision system.", piece[1]),
                    "Please return once it's fully augmented.",
                }, info.npc, { npc = npc })
            end
        end
    end
end

local function onFinish(player, npc)
    local jobID   = player:getCharVar(info.lock)
    local jobName = xi.jobNames[jobID][2]
    local tierVar = fmt(info.tier, xi.jobNames[jobID][1])
    local tier    = player:getCharVar(tierVar)
    local slot    = tiers[tier]
    local piece   = jobs[jobID].armor[slot]

    local tbl =
    {
        fmt("Congratulations on completing {} Mastery {}!", jobName, cexi.numeral[tier]),
        fmt(" I gladly bestow upon you this well earned {} +2.", piece[1]),
        { emote = xi.emote.BOW },
    }

    cexi.util.dialog(player, tbl, info.npc, { npc = npc })

    local delay = cexi.util.dialogDelay(tbl)

    player:timer(delay, function()
        if npcUtil.giveItem(player, piece[3]) then
            player:setCharVar(info.var,  0)
            player:setCharVar(info.lock, 0)
        end
    end)
end

-----------------------------------
-- Quest Framework
-----------------------------------
local JOB_MASTER = "JOB_MASTER"

local entity =
{
    {
        id   = JOB_MASTER,
        name = string.char(0xAA) .. info.npc,
        type = xi.objType.NPC,
        hidden = true,
        look = cexi.util.look({
            race = xi.race.GALKA,
            face = A1,
            head = 459, -- Byakko Masque
            main = 320,
            body = 309, -- Chocobo Shirt
            hand = cexi.model.DUSK_JERKIN,
            legs = cexi.model.DUSK_JERKIN,
            feet = cexi.model.DUSK_JERKIN,
        }),
        area   = "RuLude_Gardens", -- (G-7)
        pos    = { -27.221, 2.002, 57.085, 159, 243 }, -- !pos -27.221 2.002 57.085 243
        dialog =
        {
            DEFAULT = cq.NOTHING,
        },
    },
}

local step =
{
    {
        [JOB_MASTER] =
        {
            onTrigger = onTrigger,
            onTrade   = onTrade,
        },
    },
    {
        -- Placeholder for NM battles
    },
    {
        -- Placeholder for after battle
    },
    {
        [JOB_MASTER] = onFinish,
    },
}

-----------------------------------
-- Create NM Battles
-----------------------------------
local function nameToID(str)
    return string.upper(string.gsub(str, " ", "_"))
end

for jobID, jobInfo in pairs(jobs) do
    local battle = jobInfo.battle
    local mobID = nameToID(battle.name)
    local popID = fmt("MASTERY_NM_{}", index)

    table.insert(entity, {
        id     = popID,
        name   = "Mastery Seal",
        hidden = true,
        marker = cq.MAIN_QUEST,
        area   = battle.zone,
        pos    = battle.pos,
        dialog =
        {
            DEFAULT = cq.NOTHING,
        },
    })

    table.insert(entity, {
        id          = mobID,
        name        = battle.name,
        type        = xi.objType.MOB,
        groupId     = battle.base[2],
        groupZoneId = battle.base[1],
        look        = battle.look,
        flags       = battle.flags or 592,
        area        = battle.zone,
        pos         = battle.pos,
        level       = 74,
        hp          = 50000,
        mods        = battle.mods,
        effects     = battle.effects,
        aeffect     = battle.aeffect,
        onMobSpawn  = battle.onMobSpawn,
        onMobFight  = battle.onMobFight,
    })

    step[2][popID] = cq.menu({
        check     = cq.checks({ job = jobID }),
        spawn     = { mobID },
        title     = "Ready to battle?",
        levelCap  = 75,
        partySize = 1,
        flag      = info.flag,
        scaleVar  = fmt(info.tier, xi.jobNames[jobID][1]),
        options   =
        {
            {
                "Not yet",
            },
            {
                "I'm ready",
                true,
            },
        },
    })

    step[2][mobID] = cq.killStep(popID, { mobID }, nil, { flag = info.flag })

    step[3][popID] = cq.dialog({
        event =
        {
            { animation = 48, target = "player", duration = 3000 }, -- Crouch down
            { message = "You obtained proof of Mastery!" },
        },
    })
end

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
