-----------------------------------
-- Letter from Adoulin
-----------------------------------
-- !setvar [CQ]ADOULIN_MSG 1
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cq_letter_from_adoulin")

local info =
{
    name     = "Letter from Adoulin",
    author   = "Hax/Loxley",
    var      = "[CQ]ADOULIN_MSG",
    flag     = "[CQ]ADOULIN_MSG_POP",
    required = xi.item.ADOULIN_LETTER,
}

local materials =
{
    -- 30%
    { cexi.rate.COMMON,   3445 }, -- Runic Scales (15%)
    { cexi.rate.COMMON,   9500 }, -- Geoweave     (15%)

    -- 70%
    { cexi.rate.UNCOMMON,  823 }, -- Gold thread    (10%)
    { cexi.rate.UNCOMMON,  821 }, -- Rainbow Thread (10%)
    { cexi.rate.UNCOMMON, 3552 }, -- Squamous Hide  (10%)
    { cexi.rate.UNCOMMON, 4026 }, -- Akaso          (10%)
    { cexi.rate.UNCOMMON, 8707 }, -- Raaz Hide      (10%)
    { cexi.rate.UNCOMMON, 3934 }, -- Matamata Shell (10%)
    { cexi.rate.UNCOMMON,  867 }, -- Dragon Scales  (10%)
}

local rewards =
{
    {
        -- 100%
        { cexi.rate.COMMON,   3445 }, -- Runic Scales (15%)
        { cexi.rate.COMMON,   9500 }, -- Geoweave     (15%)
    },
    {
        -- 100%
        { cexi.rate.COMMON, 1255 }, -- Fire Ore
        { cexi.rate.COMMON, 1256 }, -- Ice Ore
        { cexi.rate.COMMON, 1257 }, -- Wind Ore
        { cexi.rate.COMMON, 1258 }, -- Earth Ore
        { cexi.rate.COMMON, 1259 }, -- Lightning Ore
        { cexi.rate.COMMON, 1260 }, -- Water Ore
        { cexi.rate.COMMON, 1261 }, -- Light Ore
        { cexi.rate.COMMON, 1262 }, -- Dark Ore
    },
    materials,
    {
        {                   700, 0                    }, -- Nothing      (70%)
        { cexi.rate.VERY_COMMON, xi.item.BROKEN_SWORD }, -- Broken Sword (15%)
        { cexi.rate.VERY_COMMON, xi.item.BROKEN_WAND  }, -- Broken Wand  (15%)
    },
}

local geoModes =
{
    { spell = xi.magic.spell.FIRA,     aura = xi.effect.AMNESIA,        additionalEffect = xi.mob.ae.ENFIRE     },
    { spell = xi.magic.spell.STONERA,  aura = xi.effect.SLOW,           additionalEffect = xi.mob.ae.ENSTONE    },
    { spell = xi.magic.spell.WATERA,   aura = xi.effect.ATTACK_DOWN,    additionalEffect = xi.mob.ae.ENWATER    },
    { spell = xi.magic.spell.AERA,     aura = xi.effect.SILENCE,        additionalEffect = xi.mob.ae.ENAERO     },
    { spell = xi.magic.spell.BLIZZARA, aura = xi.effect.PARALYSIS,      additionalEffect = xi.mob.ae.ENBLIZZARD },
    { spell = xi.magic.spell.THUNDARA, aura = xi.effect.MAGIC_DEF_DOWN, additionalEffect = xi.mob.ae.ENTHUNDER  },
    { spell = xi.magic.spell.BANISHGA, aura = xi.effect.DIA,            additionalEffect = xi.mob.ae.ENLIGHT    },
    { spell = xi.magic.spell.STUN,     aura = xi.effect.BIO,            additionalEffect = xi.mob.ae.ENDARK     },
}

local runeModes =
{
    { spell1 = xi.magic.spell.FLASH,      spell2 = xi.magic.spell.BARFIRE,     additionalEffect = xi.mob.ae.ENFIRE,     animation = 291, isBuff = false },  -- fire mode
    { spell1 = xi.magic.spell.STONESKIN,  spell2 = xi.magic.spell.BARSTONE,    additionalEffect = xi.mob.ae.ENSTONE,    animation = 294, isBuff = true },  -- stone mode
    { spell1 = xi.magic.spell.SHELL_IV,   spell2 = xi.magic.spell.BARWATER,    additionalEffect = xi.mob.ae.ENWATER,    animation = 296, isBuff = true },  -- water mode
    { spell1 = xi.magic.spell.PROTECT_IV, spell2 = xi.magic.spell.BARAERO,     additionalEffect = xi.mob.ae.ENAERO,     animation = 293, isBuff = true },  -- wind mode
    { spell1 = xi.magic.spell.PHALANX,    spell2 = xi.magic.spell.BARBLIZZARD, additionalEffect = xi.mob.ae.ENBLIZZARD, animation = 292, isBuff = true },  -- ice mode
    { spell1 = xi.magic.spell.BLINK,      spell2 = xi.magic.spell.BARTHUNDER,  additionalEffect = xi.mob.ae.ENTHUNDER,  animation = 295, isBuff = true },  -- thunder mode
    { spell1 = xi.magic.spell.REGEN_III,  spell2 = xi.magic.spell.BARSLEEP,    additionalEffect = xi.mob.ae.ENLIGHT,    animation = 297, isBuff = true },  -- light mode
    { spell1 = xi.magic.spell.CRUSADE,    spell2 = xi.magic.spell.BARBLIND,    additionalEffect = xi.mob.ae.ENDARK,     animation = 298, isBuff = true }  -- dark mode
}

local elementWeakness =
{
    [xi.magic.spell.FIRA]     = xi.mod.WATER_ABSORB,
    [xi.magic.spell.STONERA]  = xi.mod.WIND_ABSORB,
    [xi.magic.spell.WATERA]   = xi.mod.LTNG_ABSORB,
    [xi.magic.spell.AERA]     = xi.mod.ICE_ABSORB,
    [xi.magic.spell.BLIZZARA] = xi.mod.FIRE_ABSORB,
    [xi.magic.spell.THUNDARA] = xi.mod.EARTH_ABSORB,
    [xi.magic.spell.BANISHGA] = xi.mod.DARK_ABSORB,
    [xi.magic.spell.STUN]     = xi.mod.LIGHT_ABSORB,
}

local allAbsorbs =
{
    xi.mod.FIRE_ABSORB,
    xi.mod.EARTH_ABSORB,
    xi.mod.WATER_ABSORB,
    xi.mod.WIND_ABSORB,
    xi.mod.ICE_ABSORB,
    xi.mod.LTNG_ABSORB,
    xi.mod.LIGHT_ABSORB,
    xi.mod.DARK_ABSORB
}

local function canPerformAction(mob)
    local act = mob:getCurrentAction()

    local isBusy = act == xi.act.MOBABILITY_START
        or act == xi.act.MOBABILITY_USING
        or act == xi.act.MOBABILITY_FINISH
        or act == xi.act.MAGIC_CASTING
        or act == xi.act.MAGIC_START
        or act == xi.act.MAGIC_FINISH

    local isActionQueueEmpty = mob:actionQueueEmpty()
    local isAlive = mob:isAlive()
    local canAct = isAlive and isActionQueueEmpty and not isBusy

    return canAct
end

local function toggleAbsorbMods(mob, modes, modeIndex)
    -- reset all absorbs to off
    for _, absorbType in ipairs(allAbsorbs) do
        mob:setMod(absorbType, 0)
    end

    -- get the current mode
    local mode = modes[modeIndex]  

    if not mode then
        return
    end

    -- get the absorb and weak types from the table
    local weakType = elementWeakness[mode.spell1]

    if not weakType then
        return
    end

    -- set absorb for all elements except the weak element
    for _, absorbType in ipairs(allAbsorbs) do
        if absorbType == weakType then
            -- turn off absorb for the weak element
            mob:setMod(absorbType, 0)
        else
            -- to absorb
            mob:setMod(absorbType, 100)  
        end
    end
end

local function animateGeo(mob, mode)  -- cleanly animate and advance mob modes
    mob:queue(2000, function(mobArg)
        mobArg:timer(2000, function(mobArgTwo)  -- idle state
            if mobArgTwo:isAlive() then
                mobArgTwo:setMobMod(xi.mobMod.NO_MOVE, 1)
                mobArgTwo:setAutoAttackEnabled(false)
                mobArgTwo:setMobAbilityEnabled(false)
                mobArgTwo:setMagicCastingEnabled(false)
                mobArgTwo:setBehaviour(bit.bor(mob:getBehaviour(), xi.behavior.STANDBACK))
                mobArgTwo:setBehaviour(bit.bor(mob:getBehaviour(), xi.behavior.NO_TURN))
            end
        end)

        mobArg:timer(4000, function(mobArgTwo)
            if mobArgTwo:isAlive() then
                mobArgTwo:entityAnimationPacket("ls11")  -- casting animation
            end
        end)

        mobArg:timer(8000, function(mobArgTwo)  -- finish casting, return mods, advance modes
            if mobArgTwo:isAlive() then
                mobArgTwo:setMobMod(xi.mobMod.NO_MOVE, 0)
                mobArgTwo:setAutoAttackEnabled(true)
                mobArgTwo:setMobAbilityEnabled(true)
                mobArgTwo:setMagicCastingEnabled(true)
                mobArgTwo:setBehaviour(bit.band(mob:getBehaviour(), bit.bnot(xi.behavior.STANDBACK)))
                mobArgTwo:setBehaviour(bit.band(mob:getBehaviour(), bit.bnot(xi.behavior.NO_TURN)))
                mobArgTwo:addStatusEffectEx(xi.effect.COLURE_ACTIVE, xi.effect.COLURE_ACTIVE, 6, 3, 0, mode.aura, 50, xi.auraTarget.ENEMIES, xi.effectFlag.AURA)
                mobArgTwo:setLocalVar("currentSpell", mode.spell)
                mobArgTwo:setLocalVar("currentAdditionalEffect", mode.additionalEffect)
            end
        end)
    end)
end

local function animateRun(mob, mode)  -- cleanly animate and advance mob modes
    mob:queue(0, function(mobArg)
        mobArg:timer(2000, function(mobArgTwo)  -- idle state
            if mobArgTwo:isAlive() then
                mobArgTwo:setMobMod(xi.mobMod.NO_MOVE, 1)
                mobArgTwo:setAutoAttackEnabled(false)
                mobArgTwo:setMobAbilityEnabled(false)
                mobArgTwo:setMagicCastingEnabled(false)
                mobArgTwo:setBehaviour(bit.bor(mob:getBehaviour(), xi.behavior.STANDBACK))
                mobArgTwo:setBehaviour(bit.bor(mob:getBehaviour(), xi.behavior.NO_TURN))
            end
        end)

        mobArg:timer(4000, function(mobArgTwo)
            if mobArgTwo:isAlive() then
                mobArgTwo:injectActionPacket(mobArgTwo:getID(), 6, mode.animation, 0, 0, 0, 0, 0)  -- inject animation based on mode
            end
        end)

        mobArg:timer(8000, function(mobArgTwo)  -- finish casting, return mods, advance modes
            if mobArgTwo:isAlive() then
                mobArgTwo:setMobMod(xi.mobMod.NO_MOVE, 0)
                mobArgTwo:setAutoAttackEnabled(true)
                mobArgTwo:setMobAbilityEnabled(true)
                mobArgTwo:setMagicCastingEnabled(true)
                mobArgTwo:setBehaviour(bit.band(mob:getBehaviour(), bit.bnot(xi.behavior.STANDBACK)))
                mobArgTwo:setBehaviour(bit.band(mob:getBehaviour(), bit.bnot(xi.behavior.NO_TURN)))
                mobArgTwo:setLocalVar("currentSpell", mode.spell1)
                mobArgTwo:setLocalVar("currentAdditionalEffect", mode.additionalEffect)
            end
        end)
    end)
end

local function applyMode(mob, modes, modeIndex)
    if not modes[modeIndex] then
        return nil
    end

    local mode = modes[modeIndex]
    if not mode.spell or not mode.aura or not mode.additionalEffect then
        return nil
    end

    toggleAbsorbMods(mob, modes, modeIndex)

    return mode
end

local function cycleModes(mob, modes)
    local currentBattleTime = mob:getBattleTime()
    local nextAction        = mob:getLocalVar("nextAction")
    local currentModeIndex  = mob:getLocalVar("currentModeIndex")
    local fightTime         = mob:getLocalVar("fightTime")

    if currentModeIndex == 0 then
        currentModeIndex = 1
        mob:setLocalVar("currentModeIndex", currentModeIndex)
    end

    if nextAction == 0 then
        nextAction = currentBattleTime + math.random(45, 60)
        mob:setLocalVar("nextAction", nextAction)
    end

    if currentBattleTime >= nextAction then
        currentModeIndex = (currentModeIndex % #modes) + 1
        mob:setLocalVar("currentModeIndex", currentModeIndex)
        mob:setLocalVar("nextAction", currentBattleTime + math.random(45, 60))

        return applyMode(mob, modes, currentModeIndex)
    end
end

local FOOTPRINT_TRAIL = "FOOTPRINT_TRAIL"
local CHEST           = "ABANDONED_CHEST"
local LOST_ONE        = "LOST_ONE"
local VOID_WARDEN     = "VOID_WARDEN"

local entity =
{
    {
        id     = FOOTPRINT_TRAIL,
        name   = "Footprint Trail",
        marker = cq.MAIN_QUEST,
        area   = "Uleguerand_Range",
        pos    = { -597.345, -40.000, 41.601, 68 }, -- !pos -597.345 -40.000 41.601 5
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   =
            {
                { despawn = { "Footprint Trail" } },
                { spawn   = { "Abandoned Chest" } },
                { delay   = 3000 },
                { entity  = "Abandoned Chest", packet = "open" },
                { delay   = 6000 },
                { despawn = { "Abandoned Chest" } },
                { spawn   = { "Footprint Trail" } },
            },
        },
    },
    {
        id        = CHEST,
        name      = "Abandoned Chest",
        type      = xi.objType.NPC,
        look      = 969,
        area      = "Uleguerand_Range",
        pos       = { -597.345, -40.000, 41.601, 68 }, -- !pos -597.345 -40.000 41.601 5
        hidden    = true,
        hidename  = true,
        notarget  = true,
        dialog    =
        {
            DEFAULT = { "It's locked." },
        },
    },
    {
        id          = LOST_ONE,
        name        = "Lost One",
        type        = xi.objType.MOB,
        area        = "Uleguerand_Range",
        pos         = { -587.082, -40.500, 44.578, 90 },
        look        = "0x01001D0236113621BA30BA40BA5042636E700080",
        groupId     = 7,
        groupZoneId = 104,
        level       = 85,
        spellList   = 0, -- we script our own spell casting
        skillList   = 0, -- we script our own skills

        mods        =
        {
            [xi.mod.INT]       =    38,  -- 100 total INT
            [xi.mod.MND]       =    44,  -- 120 total MND
            [xi.mod.UFASTCAST] =    50,
            [xi.mod.UDMGPHYS]  = -5000,
            [xi.mod.UDMGRANGE] = -5000,
            [xi.mod.MDEF]      =    20,
            [xi.mod.MATT]      =    35,
            [xi.mod.REGAIN]    =    20,
            [xi.mod.ACC]       =   169, -- 500 total acc
            [xi.mod.ATT]       =   152, -- 550 total atk
            [xi.mod.DEF]       =    86, -- 450 total def
            [xi.mod.EVA]       =    35, -- 375 total eva
        },

        immunities  =
        {
            xi.immunity.DARK_SLEEP,
            xi.immunity.GRAVITY,
            xi.immunity.LIGHT_SLEEP,
            xi.immunity.PETRIFY,
            xi.immunity.SILENCE,
            xi.immunity.TERROR,
        },

        onMobSpawn = function(mob)
            mob:setLocalVar("auraSetup", 1)
            mob:setLocalVar("currentModeIndex", 1)
            mob:setLocalVar("nextAction", 0)
            mob:setLocalVar("fightTime", mob:getBattleTime())
            mob:setLocalVar("spellRecast", os.time() + math.random(15, 20))
            mob:setLocalVar("isCasting", 0)

            mob:setMobMod(xi.mobMod.MULTI_HIT, 1)
            mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)

            mob:setMod(xi.mod.REFRESH, 200)

            mob:timer(3000, function(mobArg)   -- delay the initial applyMode to allow for clean animation
                local mode = applyMode(mobArg, geoModes, 1)

                if mode ~= nil then
                    animateGeo(mob, mode)
                end
            end)
        end,

        onAdditionalEffect = function(mob, target, damage)
            local modeIndex        = mob:getLocalVar("currentModeIndex")
            local mode             = geoModes[modeIndex]
            local additionalEffect = mode.additionalEffect

            if additionalEffect then
                return xi.mob.onAddEffect(mob, target, damage, additionalEffect, { power = math.random(15, 45)})
            end
        end,

        onMobFight = function(mob, target)
            local spellRecast = mob:getLocalVar("spellRecast")
            local time        = os.time()
            local mode        = cycleModes(mob, geoModes)

            if mode ~= nil then
                animateGeo(mob, mode)
            end

            if canPerformAction(mob) then
                if mob:getTP() >= 1000 then
                    if math.random() < 0.5 then
                        local mobSkills = { 168, 169 }  -- hexa strike and black halo
                        local skill = mobSkills[math.random(#mobSkills)]

                        mob:queue(2000, function(mobArg)
                            mobArg:useMobAbility(skill)
                        end)
                    end
                end

                local spellRecast = mob:getLocalVar("spellRecast")
                local isCasting = mob:getLocalVar("isCasting")

                if isCasting == 0 then
                    if time > spellRecast then
                        local currentSpell = mob:getLocalVar("currentSpell")

                        if currentSpell then
                            mob:queue(2000, function(mobArg)
                                mobArg:castSpell(currentSpell, target)
                                mobArg:setLocalVar("isCasting", 1)
                                mobArg:setLocalVar("spellRecast", time + math.random(15, 25))
                                mobArg:timer(4000, function(mobArgTwo)
                                    mobArgTwo:setLocalVar("isCasting", 0)  -- reset the casting gate to false
                                end)
                            end)
                        end
                    end
                end
            end
        end,

        onSpellPrecast = function(mob, spell)
            if spell:getID() == xi.magic.spell.STUN then
                spell:setAoE(xi.magic.aoe.RADIAL)
                spell:setFlag(xi.magic.spellFlag.HIT_ALL)
                spell:setRadius(30)
            end
        end
    },
    {
        id          = VOID_WARDEN,
        name        = "Void Warden",
        type        = xi.objType.MOB,
        area        = "Uleguerand_Range",
        pos         = { -600.674, -40.523, 49.180, 48 },
        look        = "0x01001D0373115221733173417351416300700080",
        groupId     = 7,
        groupZoneId = 104,
        level       = 85,
        spellList   = 0, -- we script our own spell casting
        skillList   = 0, -- we script our own skills

        mods        =
        {
            [xi.mod.DEX]        = 37,  -- 120
            [xi.mod.STR]        = 41,  -- 120
            [xi.mod.AGI]        = 60,  -- 120
            [xi.mod.INT]        = 38,  -- 100
            [xi.mod.MND]        = 44,  -- 120
            [xi.mod.MDEF]       = 20,
            [xi.mod.MATT]       = 25,
            [xi.mod.REGAIN]     = 20,
            [xi.mod.INQUARTATA] = 56,

            [xi.mod.ACC] =  69, -- 400 total acc
            [xi.mod.ATT] = 217, -- 600 total atk
            [xi.mod.DEF] = 136, -- 500 total def
            [xi.mod.EVA] =  25, -- 375 total eva
        },

        immunities  =
        {
            xi.immunity.DARK_SLEEP,
            xi.immunity.GRAVITY,
            xi.immunity.LIGHT_SLEEP,
            xi.immunity.PETRIFY,
            xi.immunity.SILENCE,
            xi.immunity.TERROR,
        },

        onMobSpawn = function(mob)
            mob:setLocalVar("currentModeIndex", 1)
            mob:setLocalVar("nextAction", 0)
            mob:setLocalVar("fightTime", mob:getBattleTime())
            mob:setLocalVar("spellRecast", os.time() + math.random(15, 20))
            mob:setLocalVar("isCasting", 0)
            mob:setSpellList(0) -- we script our own spell casting

            mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
            mob:setMobMod(xi.mobMod.CAN_PARRY, 3)

            mob:setMod(xi.mod.REFRESH, 200)
            mob:setMod(xi.mod.UFASTCAST, 50)
            mob:setMod(xi.mod.UDMGMAGIC, -5000)

            -- delay the initial applyMode to allow for clean animation
            mob:timer(3000, function(mobArg)
                local mode = applyMode(mobArg, runeModes, 1)

                if mode ~= nil then
                    animateRun(mob, mode)
                end
            end)
        end,

        onAdditionalEffect = function(mob, target, damage)
            local modeIndex        = mob:getLocalVar("currentModeIndex")
            local mode             = modes[modeIndex]
            local additionalEffect = mode.additionalEffect

            if additionalEffect then
                return xi.mob.onAddEffect(mob, target, damage, additionalEffect, { power = math.random(15, 45)})
            end
        end,

        onMobFight = function(mob, target)
            local spellRecast = mob:getLocalVar("spellRecast")
            local time        = os.time()
            local mode        = cycleModes(mob, runeModes)

            if mode ~= nil then
                animateRun(mob, mode)
            end

            if canPerformAction(mob) then
                if mob:getTP() >= 1000 then
                    if math.random() < 0.5 then
                        local mobSkills = { 49, 56 }  -- power slash and ground strike
                        local skill     = mobSkills[math.random(#mobSkills)]

                        mob:queue(2000, function(mobArg)
                            mobArg:useMobAbility(skill)
                        end)
                    end
                end

                local spellRecast = mob:getLocalVar("spellRecast")
                local isCasting = mob:getLocalVar("isCasting")

                if isCasting == 0 then
                    if time > spellRecast then
                        local modeIndex = mob:getLocalVar("currentModeIndex")
                        local mode      = runeModes[modeIndex]

                        if mode then
                            local isSpell2     = math.random() < 0.5  -- pick between spell1 and spell2
                            local currentSpell = isSpell2 and mode.spell2 or mode.spell1
                            local target       = isSpell2 and mob or (mode.isBuff and mob or target)

                            mob:queue(2000, function(mobArg)
                                mobArg:castSpell(currentSpell, target)
                                mobArg:setLocalVar("isCasting", 1)
                                mobArg:setLocalVar("spellRecast", time + math.random(15, 25))

                                mobArg:timer(4000, function(mobArgTwo)
                                    -- reset the casting gate to false
                                    mobArgTwo:setLocalVar("isCasting", 0)
                                end)
                            end)
                        end
                    end
                end
            end
        end,
    },
}

local function rollRewards(text)
    return function(player, npc, entity)
        -- Update current step immediately so players can't spam this
        player:setCharVar(info.var,   0)
        player:setLocalVar(info.flag, 0)

        -- Display NPC event
        cexi.util.dialog(player, entity.dialog[text], "", { npc = npc })

        local zone   = player:getZone()
        local result = zone:queryEntitiesByName("DE_Abandoned Chest")

        if result ~= nil then
            cexi.util.treasurePool(player, rewards, result[1])
        end
    end
end

local wave =
{
    LOST_ONE,
    VOID_WARDEN,
}

local step =
{
    {
        [FOOTPRINT_TRAIL] =
        {
            onTrigger = cq.dialog({
                step  = false,
                event = { { noturn = true }, "You see a trail of footprints..." },
            }),
            onTrade = cq.tradeSpawn(wave, info.required, {
                flag = info.flag,
            }),
        },
        [LOST_ONE]    = cq.killStep(FOOTPRINT_TRAIL, wave, nil, { flag = info.flag }),
        [VOID_WARDEN] = cq.killStep(FOOTPRINT_TRAIL, wave, nil, { flag = info.flag }),
    },
    {
        [FOOTPRINT_TRAIL] = rollRewards("AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
