-----------------------------------
-- Guild NM
-----------------------------------
-- Guild Associate !pos -31.679 -1.000 -2.829 245
-- !setvar [CQ]GUILD_NM 2
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cq_guild_nm")

local info =
{
    name   = "Guild NM",
    author = "Loxley",
    var    = "[CQ]GUILD_NM",
    lock   = "[Guild]Type",
    points = "[Guild]Gallantry",
    msg    = "{} gains {} guild gallantry.",
}

local locations = {}

-- Each NM has a 10% chance to drop Twilight Gold used to spawn Smaug (10 Required)
local twilightGold =
{
    {                900,                     0 }, -- 90%
    { cexi.rate.UNCOMMON, xi.item.TWILIGHT_GOLD }, -- 10%
}

-----------------------------------
-- Fishing
-----------------------------------
-- Orobon
-- Can we make this sleep do damage over time?
-- Stockfish (Furnishing)

-----------------------------------
-- Woodworking
-----------------------------------
-- Treant
-- Lituus
-- Tomeshelf
-- Warmage's Pole
-- Exalted Log

-----------------------------------
-- Smithing
-----------------------------------
-- Falcata
-- Robur Mace
-- Reverend Mail +1 (Saintly Mail)
-- Beryllium Ore
locations[xi.guild.SMITHING + 1] =
{
    {
        name = "Minestrosity",
        base = { 160, 28 }, -- Doom_Toad
        lv   = 92,
        hp   = 150000,
        area = "Gusgen_Mines",
        pos  = { -134.807, 2.304, 350.043, 81 }, -- !pos -134.807 2.304 350.043 196
        mods =
        {
            [xi.mod.DOUBLE_ATTACK] = 15,
            [xi.mod.ATT]           = 800,
            [xi.mod.UDMGPHYS]      = -2500,
            [xi.mod.UDMGRANGE]     = -2500,
            [xi.mod.UDMGMAGIC]     = -2500,
            [xi.mod.UDMGBREATH]    = -2500,
        },
        mobMods =
        {
            [xi.mobMod.MULTI_HIT] = 3,
        },
        immunities = cq.standardImmunities,
        pool =
        {
            {
                { cexi.rate.COMMON,   xi.item.DAMASCUS_INGOT }, -- Damascus Ingot (15%)
                { cexi.rate.UNCOMMON, xi.item.BERYLLIUM_ORE  }, -- Beryllium Ore  (10%)
            },
            {
                { cexi.rate.COMMON, 1234 }, -- Iron Nugget
                { cexi.rate.COMMON, 1235 }, -- Steel Nugget
                { cexi.rate.COMMON, 1228 }, -- Dst. Nugget
                { cexi.rate.COMMON, 1229 }, -- Adaman Nugget
            },
            {
                quantity = 2,
                { cexi.rate.VERY_COMMON,  645 }, -- Darksteel Ore
                { cexi.rate.COMMON,       657 }, -- Tama-Hagane
                { cexi.rate.UNCOMMON,     734 }, -- Thokcha Ore
                { cexi.rate.UNCOMMON,     646 }, -- Adaman Ore
                { cexi.rate.UNCOMMON,    1469 }, -- Wootz Ore
                { cexi.rate.RARE,         658 }, -- Damascus Ingot
            },
            twilightGold,
        },
    },
}

-----------------------------------
-- Goldsmithing
-----------------------------------
-- Pacifying Chain
-- Rhodium Ore (+7/8 Ring) (Use +6 stat ring to make?)
-- Hapatizon Ore
locations[xi.guild.GOLDSMITHING + 1] =
{
    {
        name = "Jank Jackson",
        base = { 174, 37 }, -- Phantom_Worm
        lv   = 92,
        hp   = 150000,
        area = "Western_Altepa_Desert",
        pos  = { -350.195, 0.322, -155.064, 216 }, -- !pos -350.195 0.322 -155.064 125
        mods =
        {
            [xi.mod.DOUBLE_ATTACK] = 15,
            [xi.mod.ATT]           = 800,
            [xi.mod.MATT]          = 100,
            [xi.mod.UDMGPHYS]      = -2500,
            [xi.mod.UDMGRANGE]     = -2500,
            [xi.mod.UDMGMAGIC]     = -2500,
            [xi.mod.UDMGBREATH]    = -2500,
        },
        immunities = cq.standardImmunities,
        pool =
        {
            {
                { cexi.rate.COMMON, 1233 }, -- Silver Nugget
                { cexi.rate.COMMON, 1225 }, -- Gold Nugget
                { cexi.rate.COMMON, 1226 }, -- Mythril Nugget
                { cexi.rate.COMMON, 1227 }, -- Platinum Nugget
            },
            {
                quantity = 2,
                { cexi.rate.VERY_COMMON,  736 }, -- Silver Ore
                { cexi.rate.COMMON,       737 }, -- Gold Ore
                { cexi.rate.UNCOMMON,     644 }, -- Mythril Ore
                { cexi.rate.UNCOMMON,     738 }, -- Platinum Ore
                { cexi.rate.UNCOMMON,     739 }, -- Orichalcum Ore
                { cexi.rate.RARE,        2228 }, -- Luminium Ore
            },
            twilightGold,
        },
    },
}

-----------------------------------
-- Clothcraft
-----------------------------------
-- Wamoura?
-- Sweven/Nebula
-- Asura Samue
-- Hyksos Robe/Khat
-- Nefer Kalasiris/Khat
-- Sif's Lock
-- Warwolf Belt +1 (Thread)

-----------------------------------
-- Leathercraft
-----------------------------------
-- Behemoth
-- Gatta Strap
-- Verse Strap
-- Vivid Strap
-- Defending Ring +1

-----------------------------------
-- Bonecraft
-----------------------------------
-- Reverie Earring
-- Cecchino's Fucile
-- Kacura Harness Set
-- Brutal Earring +1
locations[xi.guild.BONECRAFT + 1] =
{
    {
        name = "Chen",
        base = { 260, 14 }, -- Bight_Uragnite
        lv   = 92,
        hp   = 150000,
        area = "Bibiki_Bay",
        pos  = { 362.055, -20.000, 321.926, 123 }, -- !pos 362.055 -20.000 321.926 4
        mods =
        {
            [xi.mod.DOUBLE_ATTACK] = 15,
            [xi.mod.ATT]           = 800,
            [xi.mod.DEFP]          = 120,
            [xi.mod.UDMGPHYS]      = -4500,
            [xi.mod.UDMGRANGE]     = -3500,
            [xi.mod.UDMGMAGIC]     = -2500,
            [xi.mod.UDMGBREATH]    = -2500,
        },
        immunities = cq.standardImmunities,
        pool =
        {
            {
                { cexi.rate.COMMON,   xi.item.PIECE_OF_ANGEL_SKIN }, -- Angel Skin         (15%)
                { cexi.rate.UNCOMMON, xi.item.MALIYAKALEYA_CORAL  }, -- Maliyakaleya Coral (10%)
            },
            {
                { cexi.rate.COMMON, 1233 }, -- Silver Nugget
                { cexi.rate.COMMON, 1225 }, -- Gold Nugget
                { cexi.rate.COMMON, 1226 }, -- Mythril Nugget
                { cexi.rate.COMMON, 1227 }, -- Platinum Nugget
            },
            {
                quantity = 2,
                { cexi.rate.VERY_COMMON, 1618 }, -- Uragnite Shell
                { cexi.rate.COMMON,      4484 }, -- Shall Shell
                { cexi.rate.UNCOMMON,     644 }, -- Mythril Ore
                { cexi.rate.UNCOMMON,     738 }, -- Platinum Ore
                { cexi.rate.UNCOMMON,     739 }, -- Orichalcum Ore
                { cexi.rate.RARE,        2228 }, -- Luminium Ore
            },
            twilightGold,
        },
    },
}

-----------------------------------
-- Alchemy
-----------------------------------
-- Psycheflayer
-- Flask Set (Furnishing)
-- Purifying Ewer (Furnishing)

-----------------------------------
-- Cooking
-----------------------------------
-- Custard / Flan
-- Bavarois Potiron (Furnishing)


local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local ASSOCIATE = "ASSOCIATE"

local entity = {}

table.insert(entity, {
    id   = ASSOCIATE,
    name = "Guild Associate",
    type = xi.objType.NPC,
    look = cexi.util.look({
        race = xi.race.HUME_F,
        face = 13,
        head = 0,
        body = cexi.model.GOLDSMITHS_SMOCK,
        hand = cexi.model.PLASTRON,
        legs = cexi.model.PLASTRON,
        feet = cexi.model.PLASTRON,
    }),
    area = "Lower_Jeuno",
    pos  = { -31.679, -1.000, -2.829, 42 }, -- !pos -31.679 -1.000 -2.829 245
    dialog =
    {
        DEFAULT = "We have nothing to discuss.",
    },
    hidden = true,
})

local function getAssignments(guildID)
    local result = {}

    for _, assignment in pairs(locations[guildID]) do
        local areaName = string.gsub(assignment.area, "_", " ")
        table.insert(result, areaName)
    end

    return cexi.util.printList(result)
end

local function confirmAssignment(player, npc, assignment)
    local balance = player:getCurrency(assignment[3])

    delaySendMenu(player, {
        title = fmt("Take {} assignment? ({} GP)", assignment[1], balance),
        options =
        {
            {
                "Not yet",
                function()
                end,
            },
            {
                "Accept assignment (300,000 GP)",
                function()
                    if balance < 300000 then
                        player:sys("You do not have enough {} Guild Points.", assignment[1])
                        return
                    end

                    cexi.util.dialog(player, {
                        fmt("Excellent. Make your way to a Guild Seal in one of the following areas: {}", getAssignments(assignment[2]))
                    })

                    player:setCharVar(info.var,  2)
                    player:setCharVar(info.lock, assignment[2])
                    player:delCurrency(assignment[3], 300000)
                end,
            },
        },
    })
end

local function confirmPurchase(player, npc, item)
    if player:getCharVar(info.points) < item[3] then
        player:sys("You do not have enough Guild Gallantry.")
        return
    end

    delaySendMenu(player, {
        title   = fmt("Purchase {}?", item[1]),
        options =
        {
            {
                "No",
                function()
                end,
            },
            {
                fmt("Yes ({} GG)", item[3]),
                function()
                    if npcUtil.giveItem(player, item[2]) then
                        player:incrementCharVar(-item[3])
                    end
                end,
            },
        },
    })
end

local step =
{
    {
        [ASSOCIATE] = cq.dialog({
            name  = "Guild Associate",
            event =
            {
                "Greetings, I am here on behalf of the Jeuno Guild Alliance representing the industries of the Duchy.",
                { emote = xi.emote.YES },
                " We are looking for talented adventurers such as yourself to assist us by clearing our supply lines.",
                { emote = xi.emote.THINK },
                { delay = 2000 },
                "Wild creatures are preventing further shipments of raw materials that our city needs for continuous production.",
                " As this is a sensitive matter, I can only divulge information for guilds which you have proven your service.",
            },
        }),
    },
    {
        [ASSOCIATE] = function(player, npc)
            delaySendMenu(player, {
                title   = "Ready to take an assignment?",
                options =
                {
                    {
                        "Spend Guild Gallantry",
                        function()
                            local balance = player:getCharVar(info.points)
                            cexi.util.simpleShop(player, npc, {
                                -- TODO: We can offer some crafting ring upgrades here
                                { "Fire Cluster x12",   { { xi.item.FIRE_CLUSTER,      12 } },  500 },
                                { "Ice Cluster x12",    { { xi.item.ICE_CLUSTER,       12 } },  500 },
                                { "Wind Cluster x12",   { { xi.item.WIND_CLUSTER,      12 } },  500 },
                                { "Earth Cluster x12",  { { xi.item.EARTH_CLUSTER,     12 } },  500 },
                                { "Ltng. Cluster x12",  { { xi.item.LIGHTNING_CLUSTER, 12 } },  500 },
                                { "Water Cluster x12",  { { xi.item.WATER_CLUSTER,     12 } },  500 },
                                { "Light Cluster x12",  { { xi.item.LIGHT_CLUSTER,     12 } },  500 },
                                { "Dark Cluster x12",   { { xi.item.DARK_CLUSTER,      12 } },  500 },
                            }, confirmPurchase, fmt("Select an item ({} GG):", balance))
                        end,
                    },
                    {
                        "Choose an assignment",
                        function()
                            cexi.util.simpleMenu(player, npc, {
                                { "Fishing",      xi.guild.FISHING      + 1, 'guild_fishing'      },
                                { "Woodworking",  xi.guild.WOODWORKING  + 1, 'guild_woodworking'  },
                                { "Smithing",     xi.guild.SMITHING     + 1, 'guild_smithing'     },
                                { "Goldsmithing", xi.guild.GOLDSMITHING + 1, 'guild_goldsmithing' },
                                { "Clothcraft",   xi.guild.CLOTHCRAFT   + 1, 'guild_weaving'      },
                                { "Leathercraft", xi.guild.LEATHERCRAFT + 1, 'guild_leathercraft' },
                                { "Bonecraft",    xi.guild.BONECRAFT    + 1, 'guild_bonecraft'    },
                                { "Alchemy",      xi.guild.ALCHEMY      + 1, 'guild_alchemy'      },
                                { "Cooking",      xi.guild.COOKING      + 1, 'guild_cooking'      },
                            }, confirmAssignment, "Choose an assignment:")
                        end,
                    },
                },
            })
        end,
    },
    {
        [ASSOCIATE] = function(player, npc)
            local assignmentType = player:getCharVar(info.lock)

            cexi.util.dialog(player, {
                fmt("Make your way to a Guild Seal in one of the following areas: {}", getAssignments(assignmentType)),
            }, npc:getPacketName(), { npc = npc })
        end,
    },
}

local GOLD_DUST = "GOLD_DUST"
local SMAUG     = "SMAUG"

table.insert(entity, {
    id     = GOLD_DUST,
    name   = "Gold Dust",
    marker = cq.SIDE_QUEST,
    area   = "Halvung",
    pos    = { -376.202, 1.000, 359.499, 130 }, -- (G-7)
    dialog =
    {
        DEFAULT = cq.NOTHING,
    },
})

table.insert(entity, {
    id          = SMAUG,
    name        = "Smaug",
    type        = xi.objType.MOB,
    groupId     = 46, -- Tiamat
    groupZoneId = 7,
    -- flags       = 1157,
    area        = "Halvung",
    pos         = { -376.202, 1.000, 359.499, 130 }, -- !pos -376.202 1.000 359.499 62
    level       = 95,
    hp          = 180000,
    pool        =
    {
        {
            -- TODO:
            { cexi.rate.COMMON, 936 },
        },
    },

    onMobSpawn  = function(mob)
        cexi.mob_util.wsPenalty(mob)
    end,

    onMobFight  = function(mob, target)
        cexi.mob_util.ignorePet(mob, target)
    end,

    points      =
    {
        var     = info.points,
        message = info.msg,
        amount  = { 2000, 2500 },
        exp     = 18000,
        gil     = 60000,
    },
})

cexi.util.addSkillEffect(m, "tebbad_wing", "Smaug", { xi.effect.BURN, 40, 0, 60 })

for i = 1, 3 do
    step[i][GOLD_DUST] =
    {
        onTrigger = cq.dialog({
            step  = false,
            event = { { noturn = true }, "You see a sprinkle of gold dust..." },
        }),
        onTrade = cq.tradeSpawn({ SMAUG }, { { xi.item.TWILIGHT_GOLD, 10 } }),
    }
end


local function nameToID(str)
    return string.upper(string.gsub(str, " ", "_"))
end

for typeID, battleList in pairs(locations) do
    for index, battle in pairs(battleList) do
        local mobID = nameToID(battle.name)
        local popID = fmt("GUILD_SEAL_{}", typeID)

        table.insert(entity, {
            id     = popID,
            name   = "Guild Seal",
            marker = cq.SIDE_QUEST,
            area   = battle.area,
            pos    = battle.pos,
            dialog =
            {
                DEFAULT = cq.NOTHING,
            },
        })

        table.insert(entity, {
            id          = mobID,
            name        = battle.name,
            type        = xi.objType.MOB,
            groupId     = battle.base[2],
            groupZoneId = battle.base[1],
            look        = battle.look,
            flags       = battle.flags or 1157,
            area        = battle.area,
            pos         = battle.pos,
            level       = battle.lv,
            hp          = battle.hp,
            pool        = battle.pool,
            mods        = battle.mods,
            effects     = battle.effects,
            aeffect     = battle.aeffect,

            onMobSpawn  = function(mob)
                cexi.mob_util.wsPenalty(mob)

                if battle.onMobSpawn ~= nil then
                    battle.onMobSpawn(mob)
                end
            end,

            onMobFight  = function(mob, target)
                cexi.mob_util.ignorePet(mob, target)

                if battle.onMobFight ~= nil then
                    battle.onMobFight(mob, target)
                end
            end,

            points      =
            {
                var     = info.points,
                message = info.msg,
                amount  = { 400, 500 },
                exp     = 8000,
                gil     = 15000,
            },
        })

        step[3][popID] = cq.menu({
            check    = cq.checks({ vareq = { info.lock, typeID } }),
            spawn    = { mobID },
            title    = "Commence battle?",
            levelCap = battle.cap,
            setVar   = { { info.var, 1 } },
            options  =
            {
                {
                    "Not yet",
                },
                {
                    "I'm ready",
                    true,
                },
            },
        })
    end
end

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
