-----------------------------------
-- Gobbie Brew (Lv15)
-----------------------------------
-- !setvar [CQ]GOBBIE_BREW 0
-- !setvar [CQ]GOBBIE_BREW_NM 0
-- Brewnix !pos -20.023 -0.100 -58.305 245
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cq_gobbie_brew")

local info =
{
    name   = "Gobbie Brew",
    author = "Loxley",
    var    = "[CQ]GOBBIE_BREW",
    lock   = "[CQ]GOBBIE_BREW_NM",
    flag   = "[CQ]GOBBIE_BREW_POP",
    points = "[VENTURE]BATTLE_POINTS",
    msg    = "{} gains {} venture battle points.",
}

local BREWNIX = "BREWNIX"
local entity  =
{
    {
        id     = BREWNIX,
        name   = "Brewnix",
        type   = xi.objType.NPC,
        look   = 85,
        area   = "Lower_Jeuno",
        pos    = { -20.023, -0.100, -58.305, 150 }, -- !pos -20.023 -0.100 -58.305 245
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Aw man, I'm so thirsty." },
        },
    },
}

local beastcoins =
{
    { cexi.rate.VERY_COMMON,   750 }, -- Silver Beastcoin (24%)
    { cexi.rate.COMMON,        749 }, -- Mtl. Beastcoin   (15%)
    { cexi.rate.UNCOMMON,      748 }, -- Gold Beastcoin   (10%)
    { cexi.rate.RARE,          751 }, -- Plt. Beastcoin   ( 5%)
}

local trash =
{
    { cexi.rate.VERY_COMMON, 17336 }, -- Crossbow Bolt    (24%)
    { cexi.rate.VERY_COMMON,   750 }, -- Silver Beastcoin (24%)
    { cexi.rate.COMMON,        749 }, -- Mtl. Beastcoin   (15%)
    { cexi.rate.UNCOMMON,      748 }, -- Gold Beastcoin   (10%)
    { cexi.rate.COMMON,        511 }, -- Goblin Mask      (15%)
    { cexi.rate.RARE,          510 }, -- Goblin Armor     ( 5%)
}

local gobMats =
{
    { cexi.rate.COMMON,  2121 }, -- Ovinnik Hide     (10%)
    { cexi.rate.COMMON,  2123 }, -- Catoblepas Hide  (10%)
    { cexi.rate.COMMON,  1628 }, -- Buffalo Hide     (10%)
    { cexi.rate.COMMON,  2512 }, -- Lynx Hide        (10%)
    { cexi.rate.COMMON,  2518 }, -- Smilodon Hide    (10%)

    { cexi.rate.COMMON,   861 }, -- Tiger Hide       (10%)
    { cexi.rate.COMMON,   863 }, -- Coeurl Hide      (10%)
    { cexi.rate.COMMON,   505 }, -- Sheepskin        (10%)
    { cexi.rate.COMMON,   859 }, -- Ram Skin         (10%)
    { cexi.rate.COMMON,   860 }, -- Behemoth Hide    (10%)
}

local wyrmMats =
{
    { cexi.rate.VERY_COMMON,  4020 }, -- Titanium Ore        (24%)
    { cexi.rate.VERY_COMMON,  9455 }, -- Fable Thread        (24%)
}

local materials =
{
    { cexi.rate.VERY_COMMON,   644 }, -- Mythril Ore         (24%)
    { cexi.rate.VERY_COMMON,   819 }, -- Linen Thread        (24%)
    { cexi.rate.COMMON,       4020 }, -- Titanium Ore        (15%)
    { cexi.rate.COMMON,       9455 }, -- Fable Thread        (15%)
    { cexi.rate.COMMON,       4035 }, -- Goblin Commendation (15%)
    { cexi.rate.UNCOMMON,      737 }, -- Gold Ore            (10%)
    { cexi.rate.RARE,          817 }, -- Grass Thread        ( 5%)
    { cexi.rate.RARE,          640 }, -- Copper Thread       ( 5%)
}

local extraMats =
{
    { cexi.rate.VERY_COMMON,  4035 }, -- Goblin Commendation (24%)
    { cexi.rate.COMMON,       4020 }, -- Titanium Ore        (15%)
    { cexi.rate.COMMON,       9455 }, -- Fable Thread        (15%)
    { cexi.rate.UNCOMMON,      908 }, -- Adamantoise Shell   (10%)
    { cexi.rate.UNCOMMON,     1771 }, -- Dragon Bone         (10%)
    { cexi.rate.UNCOMMON,      722 }, -- Divine Log          (10%)
    { cexi.rate.UNCOMMON,      646 }, -- Adaman Ore          (10%)
    { cexi.rate.UNCOMMON,      739 }, -- Orichalcum Ore      (10%)
    { cexi.rate.UNCOMMON,     1311 }, -- Oxblood             (10%)
    { cexi.rate.UNCOMMON,     1313 }, -- Siren's Hair        (10%)
    { cexi.rate.UNCOMMON,      836 }, -- Damascene Cloth     (10%)
    { cexi.rate.UNCOMMON,     1312 }, -- Angel Skin          (10%)
    { cexi.rate.UNCOMMON,     1712 }, -- Cashmere Wool       (10%)
    { cexi.rate.RARE,         1110 }, -- Beetle Blood        ( 5%)
    { cexi.rate.RARE,          837 }, -- Malboro Fiber       ( 5%)
    { cexi.rate.RARE,          880 }, -- Bone Chip           ( 5%)
}

local ingots =
{
    { cexi.rate.COMMON,        654 }, -- Darksteel Ingot     (15%)
    { cexi.rate.COMMON,        653 }, -- Mythril Ingot       (15%)
    { cexi.rate.COMMON,       9454 }, -- Embersteel Ingot    (15%)
    { cexi.rate.COMMON,        745 }, -- Gold Ingot          (15%)
    { cexi.rate.COMMON,        746 }, -- Platinum Ingot      (15%)
    { cexi.rate.UNCOMMON,      655 }, -- Adaman Ingot        (10%)
    { cexi.rate.UNCOMMON,      747 }, -- Orichalcum Ingot    (10%)
    { cexi.rate.UNCOMMON,      743 }, -- Ph. Gold Ingot      (10%)
    { cexi.rate.RARE,          658 }, -- Damascus Ingot      ( 5%)
}

local eleOres =
{
    { cexi.rate.VERY_COMMON, 1255 },
    { cexi.rate.VERY_COMMON, 1256 },
    { cexi.rate.VERY_COMMON, 1257 },
    { cexi.rate.VERY_COMMON, 1258 },
    { cexi.rate.VERY_COMMON, 1259 },
    { cexi.rate.VERY_COMMON, 1260 },
    { cexi.rate.VERY_COMMON, 1261 },
    { cexi.rate.VERY_COMMON, 1262 },
}

local hqBrew =
{
    {              850,     4035 }, -- Goblin Commendation (85%)
    { cexi.rate.COMMON,     9436 }, -- Goblin Brew +1      (15%)
}

local hq2Brew =
{
    {              850,     4035 }, -- Goblin Commendation (85%)
    { cexi.rate.COMMON,     9437 }, -- Goblin Brew +2      (15%)
}

local hq3Brew =
{
    {                   660,  4035 }, -- Goblin Commendation (66%)
    { cexi.rate.VERY_COMMON,  9454 }, -- Embersteel Ingot    (24%)
    { cexi.rate.UNCOMMON,     9438 }, -- Goblin Brew +3      (10%)
}

local helmLocations =
{
    {
        area   = "La_Theine_Plateau",
        type   = cexi.helmID.LOGGING,
        pos    = { 601.232, 40.000, -520.600, 195 }, -- !pos 601.232 40.000 -520.600 102
        immediate = true,
        items  =
        {
            { cexi.rate.VERY_COMMON, xi.item.ASH_LOG,            "an ash log"           },
            { cexi.rate.VERY_COMMON, xi.item.CHESTNUT_LOG,       "a chestnut log"       },
            { cexi.rate.COMMON,      xi.item.EBONY_LOG,          "an ebony log"         },
            { cexi.rate.COMMON,      xi.item.MAHOGANY_LOG,       "a mahogany log"       },
            { cexi.rate.UNCOMMON,    xi.item.PETRIFIED_LOG,      "a petrified log"      },
            { cexi.rate.RARE,        xi.item.ACORN,              "an acorn"             },
            { cexi.rate.RARE,        xi.item.LACQUER_TREE_LOG,   "a lacquer tree log"   },
            { cexi.rate.VERY_RARE,   xi.item.DIVINE_LOG,         "a divine log"         },
            { cexi.rate.VERY_RARE,   xi.item.UNION_COMMENDATION, "a union commendation" },
        },
        points =
        {
            { 602.2137, 40.1271, -485.6990 },
            { 605.6656, 40.1271, -477.9645 },
            { 597.5203, 40.1271, -473.9701 },
            { 591.2360, 39.0989, -468.9555 },
            { 599.6550, 40.9229, -460.6609 },
            { 610.1938, 40.1704, -470.1837 },
            { 614.5729, 40.5252, -478.5592 },
            { 618.0307, 40.2949, -485.9793 },
            { 634.1876, 39.4957, -485.8911 },
            { 625.8323, 40.5602, -477.6656 },

            { 626.1995, 40.2983, -465.9375 },
            { 645.9409, 40.4360, -457.8705 },
            { 645.9818, 40.4360, -445.7070 },
            { 638.8464, 40.4360, -449.0728 },
            { 621.5029, 40.4167, -446.0074 },
            { 609.8118, 40.4167, -442.4180 },
            { 591.1834, 40.4167, -444.4820 },
            { 585.2272, 40.9133, -436.8281 },
            { 578.0533, 40.9133, -446.1093 },
            { 606.1526, 40.2424, -449.1262 },

            { 614.3567, 40.2424, -454.0743 },
            { 618.4703, 40.2424, -458.4027 },
            { 626.1140, 40.2424, -466.1014 },
            { 638.1616, 40.2424, -469.9531 },
            { 645.8479, 40.2424, -457.9023 },
            { 646.4222, 40.2424, -446.2320 },
            { 629.4789, 40.3550, -442.1763 },
            { 621.6176, 40.3550, -437.9371 },
            { 630.2646, 40.3550, -425.6567 },
            { 634.1818, 40.3550, -429.6711 },
        },
    },
    {
        area   = "Tahrongi_Canyon",
        type   = cexi.helmID.HARVESTING,
        pos    = { -363.040, 8.822, 223.523, 230 }, -- !pos -363.040 8.822 223.523 117\
        immediate = true,
        items  =
        {

            { cexi.rate.VERY_COMMON, xi.item.PIECE_OF_CRAWLER_COCOON,    "a piece of crawler cocoon"    },
            { cexi.rate.VERY_COMMON, xi.item.BAG_OF_CACTUS_STEMS,        "a bag of cactus stems"        },
            { cexi.rate.COMMON,      xi.item.CLUMP_OF_GARIDAV_WILDGRASS, "a clump of garidav wildgrass" },
            { cexi.rate.COMMON,      xi.item.TAHRONGI_CACTUS,            "a tahrongi cactus"            },
            { cexi.rate.UNCOMMON,    xi.item.DRAGON_FRUIT,               "a dragon fruit"               },
            { cexi.rate.RARE,        xi.item.BALL_OF_SARUTA_COTTON,      "a ball of saruta cotton"      },
            { cexi.rate.RARE,        xi.item.KITRON,                     "a kitron"                     },
            { cexi.rate.VERY_RARE,   xi.item.PERSIKOS,                   "a persikos"                   },
            { cexi.rate.VERY_RARE,   xi.item.UNION_COMMENDATION,         "a union commendation"         },
        },
        points =
        {
            { -340.4200, 7.3546, 257.9206 },
            { -338.5527, 7.3546, 254.2756 },
            { -339.0155, 7.3546, 252.6397 },
            { -319.1093, 8.8936, 262.5544 },
            { -319.0241, 8.8936, 265.9701 },
            { -314.4955, 8.0327, 275.2904 },
            { -321.0803, 8.0000, 284.8411 },
            { -321.0803, 8.0000, 284.8411 },
            { -319.1569, 8.0000, 286.2378 },
            { -314.5520, 7.8259, 274.9155 },

            { -319.2044, 8.5499, 265.6732 },
            { -319.1525, 8.5499, 262.7104 },
            { -304.0670, 8.5499, 274.8470 },
            { -295.3274, 8.5499, 278.9462 },
            { -295.5334, 8.5002, 276.3050 },
            { -290.9508, 8.5002, 274.1679 },
            { -297.5015, 7.5982, 264.7186 },
            { -298.7145, 7.5982, 263.5407 },
            { -302.7559, 7.5982, 257.2104 },
            { -302.7559, 7.5982, 257.2104 },

            { -310.2241, 7.8103, 255.8876 },
            { -306.6554, 7.8103, 253.2788 },
            { -286.1102, 8.0563, 249.9259 },
            { -284.5604, 8.0563, 248.8552 },
            { -284.5604, 8.0563, 248.8552 },
            { -300.8080, 7.4652, 227.7160 },
            { -302.6902, 7.4652, 226.2514 },
            { -280.1802, 8.0000, 237.8187 },
            { -279.1191, 8.0000, 237.0250 },
            { -279.8893, 8.1426, 232.3939 },
        },
    },
    {
        area   = "Konschtat_Highlands",
        type   = cexi.helmID.MINING,
        pos    = { -121.024, -56.000, -677.207, 87 }, -- (G-12) !pos -121.024 -56.000 -677.207 108
        immediate = true,
        items  =
        {

            { cexi.rate.VERY_COMMON, xi.item.CHUNK_OF_IRON_ORE,          "a chunk of iron ore"          },
            { cexi.rate.VERY_COMMON, xi.item.CHUNK_OF_SILVER_ORE,        "a chunk of silver ore"        },
            { cexi.rate.COMMON,      xi.item.CHUNK_OF_GOLD_ORE,          "a chunk of gold ore"          },
            { cexi.rate.COMMON,      xi.item.CHUNK_OF_DARKSTEEL_ORE,     "a chunk of darksteel ore"     },
            { cexi.rate.UNCOMMON,    xi.item.FIRE_CLUSTER,               "a fire cluster"               },
            { cexi.rate.RARE,        xi.item.CHUNK_OF_ADAMAN_ORE,        "a chunk of adaman ore"        },
            { cexi.rate.RARE,        xi.item.CHUNK_OF_PLATINUM_ORE,      "a chunk of platinum ore"      },
            { cexi.rate.VERY_RARE,   xi.item.CHUNK_OF_ORICHALCUM_ORE,    "a chunk of orichalcum ore"    },
            { cexi.rate.VERY_RARE,   xi.item.UNION_COMMENDATION,         "a union commendation"         },
        },
        points =
        {
            { -129.4616, -61.5699, -651.7100 },
            { -134.5850, -62.2521, -656.0934 },
            { -137.3228, -62.6049, -659.7482 },
            { -141.1283, -62.3615, -665.0784 },
            { -146.5371, -63.0623, -668.8579 },
            { -152.0306, -63.8490, -672.1808 },
            { -155.6355, -67.5995, -670.7508 },
            { -161.6542, -67.3956, -671.4812 },
            { -165.9547, -66.4543, -676.7694 },
            { -168.6535, -67.4430, -681.7133 },

            { -165.8385, -65.5427, -686.8151 },
            { -164.6934, -63.9685, -701.3902 },
            { -167.0138, -65.0985, -705.4076 },
            { -168.5253, -66.7478, -711.1060 },
            { -168.7592, -67.6451, -722.5865 },
            { -170.5732, -70.0951, -729.4542 },
            { -160.8926, -67.4237, -728.4908 },
            { -154.1859, -66.6125, -727.3035 },
            { -143.2951, -62.8715, -732.6805 },
            { -134.9153, -60.9708, -730.1835 },

            { -126.3806, -58.9908, -727.6268 },
            { -118.3570, -59.3372, -728.3974 },
            { -111.3165, -59.4543, -721.7266 },
            { -111.3649, -59.3407, -713.0327 },
            { -105.4918, -57.6180, -701.9092 },
            {  -95.6428, -58.0125, -693.1417 },
            {  -82.6514, -59.7086, -688.7783 },
            {  -78.3441, -59.3631, -688.4645 },
            {  -71.3989, -59.4138, -681.7668 },
            {  -74.3278, -57.3889, -672.6478 },
        },
    },
}

local locations =
{
    -----------------------------------
    -- Lv30
    -----------------------------------
    {
        name = "Coral Wyvern",
        base = { 30, 6 }, -- Firedrake
        lv   = 33,
        cap  = 30,
        hp   = 1500,
        area = "Korroloka_Tunnel",
        pos  =
        {
            { -151.052,  0.500, -79.626, 143 }, -- (F-8) !pos -151.052 0.500 -79.626 173
            { -120.227,  0.500, -30.245,  59 }, -- (G-7) !pos -120.227 0.500 -30.245 173
            {  -41.330,  0.302, -29.318,  78 }, -- (I-7) !pos -41.330 0.302 -29.318 173
            {   20.562,  0.257, -59.725, 189 }, -- (J-8) !pos 20.562 0.257 -59.725 173
            {   55.008,  1.144, -25.986,  49 }, -- (K-7) !pos 55.008 1.144 -25.986 173
        },
        pool =
        {
            {
                { cexi.rate.VERY_COMMON, 1122 }, -- Wyvern Skin (24%)
                { cexi.rate.COMMON,      1124 }, -- Wyvern Wing (15%)
            },
            materials,
            materials,
            {
                {              850,     0 }, -- Nothing      (85%)
                { cexi.rate.COMMON, 21425 }, -- Zhulong Bell (15%)
            },
            hqBrew,
        },
        ja2h = 688, -- Mighty Strikes
    },
    {
        name = "Mystic Urn",
        base = { 157, 14 }, -- Magic_Pot
        look = 413,         -- Magic Millstone
        lv   = 33,
        cap  = 30,
        hp   = 1500,
        area = "Outer_Horutoto_Ruins",
        pos  =
        {
            { 330.380, 0.000, 772.245,   0 }, -- (G-6) !pos 330.380  0.000 772.245 194
            { 349.462, 0.000, 772.955, 127 }, -- (G-6) !pos 349.462 0.000 772.955 194
            { 330.811, 0.000, 707.803,   0 }, -- (G-7) !pos 330.811 0.000 707.803 194
            { 509.677, 0.000, 772.672, 127 }, -- (I-6) !pos 509.677 0.000 772.672 194
            { 530.345, 0.000, 707.821,   0 }, -- (J-7) !pos 530.345 0.000 707.821 194
        },
        pool =
        {
            {
                { cexi.rate.VERY_COMMON, 954 }, -- Magic Pot Shard (24%)
                { cexi.rate.COMMON,      931 }, -- Cermet Chunk    (15%)
            },
            materials,
            materials,
            {
                {              850,     0 }, -- Nothing       (85%)
                { cexi.rate.COMMON, 21426 }, -- Enlightenment (15%)
            },
            hqBrew,
        },
        ja2hr = 689, -- Benediction
    },
    {
        name = "Fallen Sorcerer",
        base = { 27, 39 }, -- Fomor_Black_Mage
        look = cexi.util.look({
            race = xi.race.TARU_M,
            face = 29, -- Fomor
            head = cexi.model.BLACK_MAGE_ARTIFACT,
            body = cexi.model.ERRANT_HOUPPELANDE,
            hand = cexi.model.ERRANT_HOUPPELANDE,
            legs = cexi.model.ERRANT_HOUPPELANDE,
            feet = cexi.model.ERRANT_HOUPPELANDE,
            main = 366, -- Ivory Sickle
        }),
        lv   = 33,
        cap  = 30,
        hp   = 1500,
        area = "Batallia_Downs",
        pos  =
        {
            {   61.135, -13.883, 145.218, 103 }, -- (I-7) !pos 61.135 -13.883 145.218 105
            { -219.706, -21.906, 135.010, 148 }, -- (G-7) !pos -219.706 -21.906 135.010 105
            { -118.198, -24.000,  -1.829,  38 }, -- (H-8) !pos -118.198 -24.000 -1.829 105
            { -241.272, -40.000, -81.758,  13 }, -- (G-8) !pos -241.272 -40.000 -81.758 105
            { -677.248, -32.000, 156.995,  30 }, -- (D-7) !pos -677.248 -32.000 156.995 105
        },
        pool =
        {
            {
                { cexi.rate.VERY_COMMON,   940 }, -- Revival Tree Root (24%)
                { cexi.rate.COMMON,      17096 }, -- Holly Pole        (15%)
            },
            materials,
            materials,
            {
                {              850,     0 }, -- Nothing         (85%)
                { cexi.rate.COMMON, 20829 }, -- Sinister Sickle (15%)
            },
            hqBrew,
        },
        ja2h = 692, -- Chainspell
    },

    -----------------------------------
    -- Lv40
    -----------------------------------
    {
        name = "Desert Prowler",
        base = { 5, 2 }, -- Uleguerand Tiger
        lv   = 44,
        cap  = 40,
        hp   = 2500,
        area = "Western_Altepa_Desert",
        pos  =
        {
            { -200.988, -2.248, 372.812,  60 }, -- (H-5) !pos -200.988 -2.248 372.812 125
            { -279.685,  0.000, 317.153,  93 }, -- (G-5) !pos -279.685 0.000 317.153 125
            { -224.152, -8.385, 110.380, 236 }, -- (G-7) !pos -224.152 -8.385 110.380 125
            { -564.313, -1.736, 148.702, 241 }, -- (E-6) !pos -564.313 -1.736 148.702 125
            { -477.466,  0.409, 267.752,   0 }, -- (F-6) !pos -477.466 0.409 267.752 125
        },
        pool =
        {
            {
                { cexi.rate.VERY_COMMON,  861 }, -- Tiger Hide      (24%)
                { cexi.rate.COMMON,       884 }, -- Blk. Tiger Fang (15%)
            },
            materials,
            materials,
            {
                {              850,     0 }, -- Nothing     (85%)
                { cexi.rate.COMMON, 21428 }, -- Tigris Grip (15%)
            },
            hqBrew,
        },
        ja2h = 693, -- Perfect Dodge
    },
    {
        name = "Jungle Toad",
        base = { 65, 23 }, -- Poroggo
        lv   = 44,
        cap  = 40,
        hp   = 2500,
        area = "Yhoator_Jungle",
        pos  =
        {
            { 237.131, 0.000, -392.899,  44 }, -- (I-10) !pos 237.131 0.000 -392.899 124
            { 220.908, 0.082, -537.967, 188 }, -- (I-11) !pos 220.908 0.082 -537.967 124
            { 196.905, 0.000, -249.429, 209 }, -- (I-9)  !pos 196.905 0.000 -249.429 124
            { 202.927, 0.000,   31.124, 202 }, -- (I-8)  !pos 202.927 0.000 31.124 124
            { 121.736, 0.075, -389.184,  71 }, -- (I-10) !pos 121.736 0.075 -389.184 124
        },
        pool =
        {
            {
                { cexi.rate.VERY_COMMON, 2334 }, -- Poroggo Hat     (24%)
                { cexi.rate.COMMON,      2334 }, -- Poroggo Hat     (15%)
            },
            materials,
            materials,
            {
                {              850,     0 }, -- Nothing       (85%)
                { cexi.rate.COMMON, 28611 }, -- Slippery Cape (15%)
            },
            hqBrew,
        },
        ja2h = 730, -- Meikyo Shisui
    },
    {
        name = "Cave Crab",
        base = { 153, 14 }, -- Aquarius
        look = 2965,
        lv   = 44,
        cap  = 40,
        hp   = 2500,
        area = "Quicksand_Caves",
        pos  =
        {
            { 813.322,  1.787, -571.018, 149 }, -- (I-10) !pos 813.322 1.787 -571.018 208
            { 742.905,  0.616, -573.986, 184 }, -- (G-10) !pos 742.905 0.616 -573.986 208
            { 695.736, -0.515, -535.872,  52 }, -- (F-9)  !pos 695.736 -0.515 -535.872 208
            { 787.883,  1.017, -649.874,  97 }, -- (H-12) !pos 787.883 1.017 -649.874 208
            { 786.867,  1.282, -708.824, 157 }, -- (H-13) !pos 786.867 1.282 -708.824 208
        },
        pool =
        {
            {
                { cexi.rate.VERY_COMMON,  881 }, -- Crab Shell     (24%)
                { cexi.rate.COMMON,      4400 }, -- Land Crab Meat (15%)
            },
            materials,
            materials,
            {
                {              850,     0 }, -- Nothing          (85%)
                { cexi.rate.COMMON, 20965 }, -- Chivalric Emblem (15%)
            },
            hqBrew,
        },
        ja2h = 690, -- Hundred Fists
    },

    -----------------------------------
    -- Lv50
    -----------------------------------
    {
        name = "Coastal Antlion",
        base = { 7, 20 }, -- Hunter Antlion
        lv   = 55,
        cap  = 50,
        hp   = 3000,
        area = "Bibiki_Bay",
        pos  =
        {
            { 440.690, -20.447, 845.805,  79 }, -- (H-6) !pos 440.690 -20.447 845.805 4
            { 226.569, -40.004, 845.598, 127 }, -- (G-6) !pos 226.569 -40.004 845.598 4
            { 246.908, -29.264, 754.240, 155 }, -- (G-7) !pos 246.908 -29.264 754.240 4
            { 124.610, -44.922, 886.284,  83 }, -- (F-6) !pos 124.610 -44.922 886.284 4
            { 111.645, -45.045, 798.074, 255 }, -- (F-7) !pos 111.645 -45.045 798.074 4
        },
        pool =
        {
            {
                { cexi.rate.VERY_COMMON,  846 }, -- Insect Wing (24%)
                { cexi.rate.COMMON,      1616 }, -- Antlion Jaw (15%)
            },
            materials,
            materials,
            {
                {              850,      0 }, -- Nothing       (85%)
                { cexi.rate.COMMON,  28576 }, -- Myrmeleo Ring (15%)
            },
            hqBrew,
        },
        ja2h = 695, -- Blood Weapon
    },
    {
        name = "Burrow Spinner",
        base = { 114, 6 }, -- Giant Spider
        look = 312,        -- Attercop
        lv   = 55,
        cap  = 50,
        hp   = 3000,
        area = "Carpenters_Landing",
        pos  =
        {
            { -378.429, -0.697, -483.345, 233 }, -- (F-10) !pos -378.429 -0.697 -483.345 2
            { -383.915, -0.039, -355.842, 102 }, -- (F-9)  !pos -383.915 -0.039 -355.842 2
            { -373.068, -1.399, -326.499, 236 }, -- (F-9)  !pos -373.068 -1.399 -326.499 2
            { -421.939,  0.213, -311.159, 206 }, -- (F-9)  !pos -421.939 0.213 -311.159 2
            { -291.412, -7.570, -171.474,  84 }, -- (G-8)  !pos -291.412 -7.570 -171.474 2

        },
        pool =
        {
            {
                { cexi.rate.VERY_COMMON,  838 }, -- Spider Web      (24%)
                { cexi.rate.COMMON,      2198 }, -- W. Spider's Web (15%)
            },
            materials,
            materials,
            {
                {              850,      0 }, -- Nothing (85%)
                { cexi.rate.COMMON,  21257 }, -- Liberty (15%)
            },
            hqBrew,
        },
        ja2h = 690, -- Hundred Fists
    },
    {
        name = "Sequoia Sapling",
        base = { 68, 5 }, -- Treant Sapling
        lv   = 55,
        cap  = 50,
        hp   = 4500,
        area = "The_Sanctuary_of_ZiTah",
        pos  =
        {
            {  -47.171,  0.150,   -3.866, 227 }, -- (H-9)  !pos -47.171 0.150 -3.866 121
            { -242.323,  0.149,   89.286, 253 }, -- (F-8)  !pos -242.323 0.149 89.286 121
            { -169.391, -1.442,   24.555, 197 }, -- (G-8)  !pos -169.391 -1.442 24.555 121
            { -447.380,  0.168,  -79.062,   0 }, -- (E-9)  !pos -447.380 0.168 -79.062 121
            { -209.909,  0.125, -282.565, 227 }, -- (F-10) !pos -209.909 0.125 -282.565 121
        },
        pool =
        {
            {
                { cexi.rate.VERY_COMMON,  953 }, -- Treant Bulb (24%)
                { cexi.rate.COMMON,       575 }, -- Grain Seeds (15%)
            },
            materials,
            materials,
            {
                {              850,      0 }, -- Nothing     (85%)
                { cexi.rate.COMMON,  28400 }, -- Wyrt Gorget (15%)
            },
            hqBrew,
        },
        ja2h = 694, -- Invincible
    },
}

local mobSets =
{
    GOBLIN_CRONY =
    {
        { name = "Goblin Crony 1", level = 88, hp = 10000 },
        { name = "Goblin Crony 2", level = 88, hp = 10000 },
    },
    ICE_WOLF =
    {
        { name = "Ice Wolf 1", level = 92, hp = 25000 },
        { name = "Ice Wolf 2", level = 92, hp = 25000 },
        { name = "Ice Wolf 3", level = 92, hp = 25000 },
    },
    ORICHALTOISE =
    {
        { name = "Orichaltoise 1", level = 92, hp = 25000 },
        { name = "Orichaltoise 2", level = 92, hp = 25000 },
    },
    CHASM_TOUCAN =
    {
        { name = "Chasm Toucan 1", level = 92, hp = 15000 },
        { name = "Chasm Toucan 2", level = 92, hp = 15000 },
    },
}

local mobs =
{
    {
        name = "Goblin Crony",
        base = { 212, 17 }, -- Wyvernpoacher_Drachlox
        area =
        {
            "Labyrinth_of_Onzozo",
            "Kuftal_Tunnel",
            "Gustav_Tunnel",
        },
        num  = 2,
        pool = { trash },
    },
    {
        name = "Ice Wolf",
        base = { 112, 26 }, -- Boreal_Hound
        area =
        {
            "Uleguerand_Range"
        },
        num  = 3,
        pool =
        {
            {
                { cexi.rate.VERY_COMMON,   858 }, -- Wolf Hide
                { cexi.rate.COMMON,       4097 }, -- Ice Crystal
            },
        },
    },
    {
        name = "Orichaltoise",
        base = { 128, 6 }, -- Adamantoise
        area =
        {
            "Cape_Teriggan"
        },
        num  = 2,
        pool =
        {
            {
                { cexi.rate.VERY_COMMON,  4099 }, -- Earth Crystal
                { cexi.rate.COMMON,        739 }, -- Orichalcum Ore
            },
        },
        mods =
        {
            [xi.mod.REGAIN] = { 30, 3, 0 },
        },
    },
    {
        name = "Chasm Toucan",
        base = { 4, 14 }, -- Toucan
        area =
        {
            "Attohwa_Chasm"
        },
        num  = 2,
        pool =
        {
            {
                { cexi.rate.VERY_COMMON,   847 }, -- Bird Feather
                { cexi.rate.COMMON,       4096 }, -- Fire Crystal
            },
        },
        onMobFight = function(mob, target)
            cq.abilityAt({
                mob    = mob,
                target = target,
                list   =
                {
                    { hp = 99, ability = 688 }, -- Mighty Strikes
                    { hp = 80, ability = 689 }, -- Benediction
                    { hp = 25, ability = 688 }, -- Mighty Strikes
                },
            })
        end,
    },
}

local goblins =
{
    {
        name = "Smugnix",
        base = { 188, 41 }, -- Snypestix Eaglebeak
        lv   = 85,
        area =
        {
            {
                name = "Labyrinth_of_Onzozo",
                pos  =
                {
                    { 164.783,  0.303, -138.862, 128 }, -- (J-9) !pos 164.783 0.303 -138.862 213
                    {  29.058,  0.000,  -78.255,   9 }, -- (H-8) !pos 29.058 0.000 -78.255 213
                    {  53.957,  3.722,  -28.903,  23 }, -- (I-8) !pos 53.957 3.722 -28.903 213
                    {  78.276, 10.399,   10.210,  69 }, -- (I-7) !pos 78.276 10.399 10.210 213
                    { 110.015, 13.915,  101.802, 115 }, -- (I-6) !pos 110.015 13.915 101.802 213
                },
                pool =
                {
                    beastcoins,
                    wyrmMats,
                    wyrmMats,
                    materials,
                    gobMats,
                    eleOres,
                    {
                        {              850,     0 }, -- Nothing (85%)
                        { cexi.rate.COMMON, 21697 }, -- Avarice (15%)
                    },
                    hq2Brew,
                },
            },
            {
                name = "Kuftal_Tunnel",
                pos  =
                {
                    { 180.314, 11.184,  82.725,  63 }, -- (K-7) !pos 180.314 11.184 82.725 174
                    { 267.557,  9.067,  27.541, 174 }, -- (M-9) !pos 267.557 9.067 27.541 174
                    { 122.594, 20.662, 105.578,  61 }, -- (J-7) !pos 122.594 20.662 105.578 174
                    {  16.662, 19.694, 120.210,   4 }, -- (G-7) !pos 16.662 19.694 120.210 174
                    { 122.596, 19.451,  16.671, 162 }, -- (J-9) !pos 122.596 19.451 16.671 174
                },
                pool =
                {
                    beastcoins,
                    wyrmMats,
                    wyrmMats,
                    materials,
                    gobMats,
                    eleOres,
                    {
                        {              850,     0 }, -- Nothing    (85%)
                        { cexi.rate.COMMON, 21054 }, -- Kyugutachi (15%)
                    },
                    hq2Brew,
                },
            },
            {
                name = "Gustav_Tunnel",
                pos  =
                {
                    {  4.170,  -10.767, -169.961, 161 }, -- (H-10) !pos 4.170 -10.767 -169.961 212
                    { -14.263,  -9.398, -113.922,  18 }, -- (G-9)  !pos -14.263 -9.398 -113.922 212
                    {  35.651, -10.743,  -69.909,  32 }, -- (H-8)  !pos 35.651 -10.743 -69.909 212
                    { 109.052, -10.000,  -36.964,  63 }, -- (I-9)  !pos 109.052 -10.000 -36.964 212
                    { 169.054, -10.386,  -68.188, 121 }, -- (J-8)  !pos 169.054 -10.386 -68.188 212
                },
                pool =
                {
                    beastcoins,
                    wyrmMats,
                    wyrmMats,
                    materials,
                    gobMats,
                    eleOres,
                    {
                        {              850,     0 }, -- Nothing           (85%)
                        { cexi.rate.COMMON, 21386 }, -- Sprightly Feather (15%)
                    },
                    hq2Brew,
                },
            },
        },
    },
}

local extraLocations =
{
    {
        name    = "Ice Lord",
        base    = { 137, 3 }, -- Gigas_Lopper
        look    = 640,
        flags   = 1183,
        lv      = 93,
        hp      = 100000,
        area    = "Uleguerand_Range",
        aeffect = xi.mob.ae.ENBLIZZARD,
        mods    =
        {
            [xi.mod.UDMGPHYS]      = -9000,
            [xi.mod.UDMGRANGE]     = -7500,
            [xi.mod.UDMGMAGIC]     = -6500,
            [xi.mod.UDMGBREATH]    = -7500,
            [xi.mod.MDEF]          =  30,
            [xi.mod.WIND_ABSORB]   = 1000,
            [xi.mod.FIRE_RES_RANK] = -4,
            [xi.mod.ICE_RES_RANK]  = 3,
        },
        effects =
        {
            [xi.effect.REGAIN] = { 10, 3, 0 },
        },

        onMobSpawn = function(mob)
            mob:addImmunity(xi.immunity.DARK_SLEEP)
            mob:addImmunity(xi.immunity.GRAVITY)
            mob:addImmunity(xi.immunity.LIGHT_SLEEP)
            mob:addImmunity(xi.immunity.PETRIFY)
            mob:addImmunity(xi.immunity.SILENCE)

            cq.mbCounter(mob, xi.element.FIRE, 10, 15, 2)
        end,

        onMobFight = function(mob, target)
            cq.mbWeaken(mob, 18, {
                [xi.mod.UDMGPHYS]  = 500,
                [xi.mod.UDMGRANGE] = 500,
                [xi.mod.UDMGMAGIC] = 300,
            })

            cq.abilityAt({
                mob    = mob,
                target = target,
                list   =
                {
                    { hp = 90, ability = 690 }, -- Hundred Fists
                    { hp = 80, ability = 690 }, -- Hundred Fists
                    { hp = 70, ability = 690 }, -- Hundred Fists
                    { hp = 60, ability = 688 }, -- Mighty Strikes
                    { hp = 50, ability = 688 }, -- Mighty Strikes
                    { hp = 40, ability = 688 }, -- Mighty Strikes

                    { hp = 20, ability = 690 }, -- Hundred Fists
                },
            })

            cq.spawnWave({
                parent = mob,
                target = target,
                waves  =
                {
                    { hp = 30, mobs = mobSets.ICE_WOLF },
                    { hp = 10, mobs = mobSets.ICE_WOLF },
                },
            })
        end,

        pos  =
        {
            {  241.221, -116.002, 395.980, 167 }, -- (J-6) !pos 241.221 -116.002 395.980 5
            {   85.578, -124.230, 394.659, 155 }, -- (I-6) !pos 85.578 -124.230 394.659 5
            {   -3.839, -140.191, 525.499,  48 }, -- (H-5) !pos -3.839 -140.191 525.499 5
            {  116.400, -124.126, 566.507,  46 }, -- (I-5) !pos 116.400 -124.126 566.507 5
            {  202.514, -108.116, 566.319,  79 }, -- (I-5) !pos 202.514 -108.116 566.319 5
        },
        pool =
        {
            {
                { cexi.rate.GUARANTEED, xi.item.PRISMATIC_CLUSTER },
            },
            extraMats,
            extraMats,
            ingots,
            wyrmMats,
            {
                { cexi.rate.VERY_COMMON, xi.item.COMMENDATION_BAG }, -- Commendation Bag (24%)
                { cexi.rate.VERY_COMMON,                    28575 }, -- Hibernal Ring    (24%)
                { cexi.rate.VERY_COMMON,                    28166 }, -- Hailstone Hose   (24%)
            },
            {
                { cexi.rate.VERY_COMMON,   497 }, -- Gigas Socks    (24%)
                { cexi.rate.COMMON,        499 }, -- Gigas Necklace (15%)
                { cexi.rate.UNCOMMON,     1256 }, -- Ice Ore        (10%)
                { cexi.rate.UNCOMMON,     1257 }, -- Wind Ore       (10%)
                { cexi.rate.UNCOMMON,    28575 }, -- Hibernal Ring  (10%)
                { cexi.rate.UNCOMMON,    28166 }, -- Hailstone Hose (10%)
            },
            hq3Brew,
        },
    },
    {
        name = "Cape Chelonian",
        base = { 128, 6 }, -- Adamantoise
        look = 2376,
        lv   = 93,
        hp   = 100000,
        area = "Cape_Teriggan",
        pos  =
        {
            {  168.036,  -0.634, 244.354,  99 }, -- (F-8) !pos 168.036 -0.634, 244.354 113
            {    8.838,  -1.169, 285.422,  95 }, -- (H-6) !pos 8.838 -1.169 285.422 113
            {  -67.428,  -9.483, 188.325, 112 }, -- (H-7) !pos -67.428 -9.483 188.325 113
            { -174.519,  -7.186, 249.126,  22 }, -- (G-6) !pos -174.519 -7.186 249.126 113
            { -250.924, -10.835, 171.872,  26 }, -- (F-7) !pos -250.924 -10.835 171.872 113
        },
        pool =
        {
            {
                { cexi.rate.GUARANTEED, xi.item.PRISMATIC_CLUSTER },
            },
            extraMats,
            extraMats,
            ingots,
            wyrmMats,
            {
                { cexi.rate.VERY_COMMON, xi.item.COMMENDATION_BAG }, -- Commendation Bag (24%)
                { cexi.rate.VERY_COMMON,                    28385 }, -- Rikugame Nodowa  (24%)
                { cexi.rate.VERY_COMMON,                    28387 }, -- Tellus Pendulum  (24%)
            },
            {
                { cexi.rate.VERY_COMMON,   908 }, -- Adamantoise Shell (24%)
                { cexi.rate.COMMON,        646 }, -- Adaman Ore        (15%)
                { cexi.rate.UNCOMMON,     1258 }, -- Earth Ore         (10%)
                { cexi.rate.UNCOMMON,     1260 }, -- Water Ore         (10%)
                { cexi.rate.UNCOMMON,    28385 }, -- Rikugame Nodowa   (10%)
                { cexi.rate.UNCOMMON,    28387 }, -- Tellus Pendulum   (10%)
            },
            hq3Brew,
        },
        aeffect = xi.mob.ae.ENSTONE,
        mods    =
        {
            [xi.mod.UDMGPHYS]       = -9000,
            [xi.mod.UDMGRANGE]      = -7500,
            [xi.mod.UDMGMAGIC]      = -6500,
            [xi.mod.UDMGBREATH]     = -7500,
            [xi.mod.MDEF]           = 30,
            [xi.mod.LTNG_ABSORB]    = 1000,
            [xi.mod.WIND_RES_RANK]  = -4,
            [xi.mod.EARTH_RES_RANK] = 3,
        },
        effects =
        {
            [xi.effect.REGAIN] = { 20, 3, 0 },
        },

        onMobSpawn = function(mob)
            mob:addImmunity(xi.immunity.DARK_SLEEP)
            mob:addImmunity(xi.immunity.GRAVITY)
            mob:addImmunity(xi.immunity.LIGHT_SLEEP)
            mob:addImmunity(xi.immunity.PETRIFY)
            mob:addImmunity(xi.immunity.SILENCE)

            cq.mbCounter(mob, xi.element.WIND, 10, 15, 2)
        end,

        onMobFight = function(mob, target)
            cq.mbWeaken(mob, 18, {
                [xi.mod.UDMGPHYS]  = 500,
                [xi.mod.UDMGRANGE] = 500,
                [xi.mod.UDMGMAGIC] = 300,
            })

            cq.abilityAt({
                mob    = mob,
                target = target,
                list   =
                {
                    { hp = 90, ability = 689 }, -- Benediction
                    { hp = 80, ability = 689 }, -- Benediction
                    { hp = 70, ability = 689 }, -- Benediction
                    { hp = 50, ability = 695 }, -- Blood Weapon
                    { hp = 25, ability = 694 }, -- Invincible
                },
            })

            cq.spawnWave({
                parent = mob,
                target = target,
                waves  =
                {
                    { hp = 75, mobs = mobSets.ORICHALTOISE },
                    { hp = 25, mobs = mobSets.ORICHALTOISE },
                },
            })
        end,
    },
    {
        name = "Avalerion",
        base = { 24, 31 }, -- Abraxas
        look = 339, -- Bennu
        lv   = 93,
        hp   = 100000,
        area = "Attohwa_Chasm",
        pos  =
        {
            { 236.782, 20.000, 241.774,  34 }, -- (J-7) !pos 236.782 20.000 241.774 7
            { 361.675, 19.924, 244.254,  79 }, -- (K-7) !pos 361.675 19.924 244.254 7
            { 445.840, 19.548, 200.815,  92 }, -- (K-7) !pos 445.840 19.548 200.815 7
            { 562.599, 12.000,  83.143,  98 }, -- (L-8) !pos 562.599 12.000 83.143 7
            { 515.491, 19.929, -37.209, 236 }, -- (K-9) !pos 515.491 19.929 -37.209 7
        },
        pool =
        {
            {
                { cexi.rate.GUARANTEED, xi.item.PRISMATIC_CLUSTER },
            },
            extraMats,
            extraMats,
            ingots,
            wyrmMats,
            {
                { cexi.rate.VERY_COMMON, xi.item.COMMENDATION_BAG }, -- Commendation Bag (24%)
                { cexi.rate.VERY_COMMON,                    28548 }, -- Bagua Ring       (24%)
                { cexi.rate.VERY_COMMON,                    28613 }, -- Luminous Earring (24%)
            },
            {
                { cexi.rate.VERY_COMMON,   842 }, -- Giant Bird Feather (24%)
                { cexi.rate.COMMON,        843 }, -- Giant Bird Plume   (15%)
                { cexi.rate.UNCOMMON,     1261 }, -- Light Ore          (10%)
                { cexi.rate.UNCOMMON,     1262 }, -- Dark Ore           (10%)
                { cexi.rate.UNCOMMON,    28548 }, -- Bagua Ring         (10%)
                { cexi.rate.UNCOMMON,    28613 }, -- Luminous Earring   (10%)
            },
            hq3Brew,
        },
        aeffect = { xi.mob.ae.ENLIGHT, 25, 50 },
        mods    =
        {
            [xi.mod.UDMGPHYS]       = -6500,
            [xi.mod.UDMGRANGE]      = -2500,
            [xi.mod.UDMGMAGIC]      = -3500,
            [xi.mod.UDMGBREATH]     = -3500,
            [xi.mod.MDEF]           = 30,
            [xi.mod.LIGHT_ABSORB]   = 1000,
            [xi.mod.DARK_RES_RANK]  = -4,
            [xi.mod.LIGHT_RES_RANK] = 3,
            [xi.mod.TRIPLE_ATTACK]  = 20,
        },
        effects =
        {
            [xi.mod.REGAIN] = { 10, 3, 0 },
        },

        onMobSpawn = function(mob)
            mob:addImmunity(xi.immunity.DARK_SLEEP)
            mob:addImmunity(xi.immunity.GRAVITY)
            mob:addImmunity(xi.immunity.LIGHT_SLEEP)
            mob:addImmunity(xi.immunity.PETRIFY)
            mob:addImmunity(xi.immunity.SILENCE)
        end,

        onMobFight = function(mob, target)
            cexi.mob_util.ignorePet(mob, target)

            cq.abilityAt({
                mob    = mob,
                target = target,
                list   =
                {
                    { hp = 95, ability = 690 }, -- Hundred Fists
                    { hp = 90, ability = 689 }, -- Benediction

                    { hp = 85, ability = 690 }, -- Hundred Fists
                    { hp = 80, ability = 693 }, -- Perfect Dodge

                    { hp = 75, ability = 690 }, -- Hundred Fists
                    { hp = 70, ability = 688 }, -- Mighty Strikes

                    { hp = 65, ability = 690 }, -- Hundred Fists
                    { hp = 60, ability = 694 }, -- Invincible

                    { hp = 55, ability = 690 }, -- Hundred Fists
                    -- Adds: 50

                    { hp = 45, ability = 690 }, -- Hundred Fists
                    { hp = 40, ability = 688 }, -- Mighty Strikes

                    { hp = 35, ability = 690 }, -- Hundred Fists
                    -- Adds: 30

                    { hp = 10, ability = 694 }, -- Invincible
                },
            })

            cq.spawnWave({
                parent = mob,
                target = target,
                waves  =
                {
                    { hp = 50, mobs = mobSets.CHASM_TOUCAN },
                    { hp = 30, mobs = mobSets.CHASM_TOUCAN },
                },
            })
        end,
    },
    {
        name  = "Pyrolynx",
        base  = { 97, 10 }, -- Muq_Shabeel
        look  = 2108,
        flags = 1181,
        lv    = 93,
        hp    = 100000,
        area  = "Ifrits_Cauldron",
        pos   =
        {
            { -104.323, 4.095, 105.209, 167 }, -- (F-10) !pos -104.323 4.095 105.209 205
            { -135.698, 4.047, 175.445,  39 }, -- (F-9)  !pos -135.698 4.047 175.445 205
            {  -56.739, 3.944, 296.073,  34 }, -- (H-6)  !pos -56.739 3.944 296.073 205
            {   14.494, 4.063, 295.175,  98 }, -- (I-6)  !pos 14.494 4.063 295.175 205
            {   14.762, 4.062, 226.149, 164 }, -- (I-7)  !pos 14.762 4.062 226.149 205
        },
        pool =
        {
            {
                { cexi.rate.GUARANTEED, xi.item.PRISMATIC_CLUSTER },
            },
            extraMats,
            extraMats,
            ingots,
            wyrmMats,
            {
                { cexi.rate.VERY_COMMON, xi.item.COMMENDATION_BAG }, -- Commendation Bag   (24%)
                { cexi.rate.VERY_COMMON,                    28612 }, -- Emberpearl Earring (24%)
                { cexi.rate.VERY_COMMON,                    21026 }, -- Flamedancer Glaive (24%)
            },
            {
                { cexi.rate.VERY_COMMON,  2512 }, -- Lynx Hide          (24%)
                { cexi.rate.COMMON,       5667 }, -- Lynx Meat          (15%)
                { cexi.rate.UNCOMMON,     1255 }, -- Fire Ore           (10%)
                { cexi.rate.UNCOMMON,     1259 }, -- Lightning Ore      (10%)
                { cexi.rate.UNCOMMON,    28612 }, -- Emberpearl Earring (10%)
                { cexi.rate.UNCOMMON,    21026 }, -- Flamedancer Glaive (10%)
            },
            hq3Brew,
        },
        aeffect = { xi.mob.ae.ENFIRE, 60, 110 },
        mods    =
        {
            [xi.mod.UDMGPHYS]       = -6500,
            [xi.mod.UDMGRANGE]      = -4250,
            [xi.mod.UDMGMAGIC]      = -3250,
            [xi.mod.UDMGBREATH]     = -7500,
            [xi.mod.MDEF]           = 30,
            [xi.mod.ICE_ABSORB]     = 1000,
            [xi.mod.WATER_RES_RANK] = -4,
            [xi.mod.FIRE_RES_RANK]  = 3,
            [xi.mod.TRIPLE_ATTACK]  = 15,
        },

        onMobSpawn = function(mob)
            mob:addImmunity(xi.immunity.DARK_SLEEP)
            mob:addImmunity(xi.immunity.GRAVITY)
            mob:addImmunity(xi.immunity.LIGHT_SLEEP)
            mob:addImmunity(xi.immunity.PETRIFY)
            mob:addImmunity(xi.immunity.SILENCE)

            cq.mbCounter(mob, xi.element.WATER, 10, 15, 2)
        end,

        onMobFight = function(mob, target)
            cq.mbWeaken(mob, 18, {
                [xi.mod.UDMGPHYS]  = 350,
                [xi.mod.UDMGRANGE] = 250,
                [xi.mod.UDMGMAGIC] = 150,
            })

            cexi.mob_util.ignorePet(mob, target)

            cq.abilityAt({
                mob    = mob,
                target = target,
                list   =
                {
                    { hp = 75, ability = 690 }, -- Hundred Fists
                    { hp = 50, ability = 730 }, -- Meikyo Shisui
                    { hp = 25, ability = 690 }, -- Hundred Fists
                    { hp = 10, ability = 693 }, -- Perfect Dodge
                    { hp =  1, ability = 693 }, -- Perfect Dodge
                },
            })
        end,
    },
}

local elements =
{
    {
        element = xi.element.FIRE,
        counter = xi.element.WATER,
        ability = 2786, -- Searing Halitus
        spells  = 895,
        list    = cexi.util.createLookup({
            xi.weaponskill.WASP_STING,
            xi.weaponskill.VIPER_BITE,
            xi.weaponskill.BLADE_TEKI,
            xi.weaponskill.BLADE_YU,
        }),
    },
    {
        element = xi.element.ICE,
        counter = xi.element.FIRE,
        ability = 2789, -- Crippling Rime
        spells  = 894,
        list    = cexi.util.createLookup({
            xi.weaponskill.BURNING_BLADE,
            xi.weaponskill.RED_LOTUS_BLADE,
            xi.weaponskill.SKULLBREAKER,
            xi.weaponskill.TACHI_KAGERO,
            xi.weaponskill.FLAMING_ARROW,
            xi.weaponskill.DULLING_ARROW,
            xi.weaponskill.HOT_SHOT,
            xi.weaponskill.SNIPER_SHOT,
        }),
    },
    {
        element = xi.element.WIND,
        counter = xi.element.ICE,
        ability = 2787, -- Divesting Gale
        spells  = 893,
        list    = cexi.util.createLookup({
            xi.weaponskill.FROSTBITE,
            xi.weaponskill.FREEZEBITE,
            xi.weaponskill.HERCULEAN_SLASH,
            xi.weaponskill.SHADOWSTITCH,
            xi.weaponskill.BLADE_RETSU,
            xi.weaponskill.BLADE_TO,
        }),
    },
    {
        element = xi.element.EARTH,
        counter = xi.element.WIND,
        ability = 2785, -- Kurnurgi Collapse
        spells  = 892,
        list    = cexi.util.createLookup({
            xi.weaponskill.GUST_SLASH,
            xi.weaponskill.CYCLONE,
            xi.weaponskill.AEOLIAN_EDGE,
            xi.weaponskill.TACHI_JINPU,
            xi.weaponskill.TACHI_GEKKO,
            xi.weaponskill.GUILLOTINE,
            xi.weaponskill.GALE_AXE,
            xi.weaponskill.PIERCING_ARROW,
            xi.weaponskill.SPLIT_SHOT,
        }),
    },
    {
        element = xi.element.THUNDER,
        counter = xi.element.EARTH,
        ability = 2788, -- Bolt of Perditiion
        spells  = 891,
        list    = cexi.util.createLookup({
            xi.weaponskill.ROCK_CRUSHER,
            xi.weaponskill.EARTH_CRUSHER,
            xi.weaponskill.BLADE_CHI,
            xi.weaponskill.CLOUD_SPLITTER,
        }),
    },
    {
        element = xi.element.WATER,
        counter = xi.element.THUNDER,
        ability = 2784, -- Diluvial Wake
        spells  = 890,
        list    = cexi.util.createLookup({
            xi.weaponskill.THUNDER_THRUST,
            xi.weaponskill.RAIDEN_THRUST,
            xi.weaponskill.LEG_SWEEP,
            xi.weaponskill.SMASH_AXE,
            xi.weaponskill.TACHI_HOBAKU,
            xi.weaponskill.TACHI_GOTEN,
            xi.weaponskill.SHOULDER_TACKLE,
        }),
    },
}

local function updateElement(mob, prev)
    local roll = 1

    if prev ~= nil then
        roll = cexi.util.randomNoRepeat(#elements, prev)
    else
        roll = math.random(1, #elements)
    end

    mob:setLocalVar("ELEMENT", roll)
    mob:setLocalVar("PROCS", 0)
    mob:setSpellList(elements[roll].spells)

    mob:setMod(xi.mod.UDMGPHYS,   mob:getMod(xi.mod.UDMGPHYS)   + 600)
    mob:setMod(xi.mod.UDMGRANGE,  mob:getMod(xi.mod.UDMGRANGE)  + 600)
    mob:setMod(xi.mod.UDMGMAGIC,  mob:getMod(xi.mod.UDMGMAGIC)  + 600)
    mob:setMod(xi.mod.UDMGBREATH, mob:getMod(xi.mod.UDMGBREATH) + 600)

    mob:weaknessTrigger(3)
    mob:addStatusEffectEx(xi.effect.TERROR, xi.effect.TERROR, 0, 0, 3)
    mob:useMobAbility(elements[roll].ability)
    mob:resetEnmity(target)

    return roll
end

local function removeProc(mob)
    if mob:getHPP() < 25 then
        mob:setLocalVar("ELEMENT", 0)
        mob:setSpellList(889) -- Non-Elemental

        mob:weaknessTrigger(3)
        mob:addStatusEffectEx(xi.effect.TERROR, xi.effect.TERROR, 0, 0, 3)
        mob:useMobAbility(2790)

        mob:removeListener("WEAPONSKILL_TAKE")
        mob:removeListener("MAGIC_PROC")

        return
    end
end

local function addTrigger(mob)
    mob:addListener('WEAPONSKILL_TAKE', 'WS_PROC', function(target, user, wsid)
        local element = mob:getLocalVar("ELEMENT")
        local procWS  = mob:getLocalVar("PROC_WS")

        if element == 0 then
            element = updateElement(mob, prev)
        end

        if os.time() < procWS then
            return
        end

        removeProc(mob)

        local procs  = mob:getLocalVar("PROCS")

        if elements[element].list[wsid] ~= nil then
            local procs  = mob:getLocalVar("PROCS")
            local result = procs + 8

            mob:setLocalVar("PROC_WS", os.time() + 3)

            if result > 30 then
                updateElement(mob, element)
            else
                mob:setLocalVar("PROCS", result)
                mob:weaknessTrigger(2)

                mob:addStatusEffectEx(xi.effect.TERROR,         xi.effect.TERROR,          0, 0,  5)
                mob:addStatusEffectEx(xi.effect.DEFENSE_DOWN,   xi.effect.DEFENSE_DOWN,   25, 0, 10)
                mob:addStatusEffectEx(xi.effect.MAGIC_DEF_DOWN, xi.effect.MAGIC_DEF_DOWN, 25, 0, 10)
            end
        end
    end)

    mob:addListener("MAGIC_TAKE", "MAGIC_PROC", function(target, user, spell)
        local element   = mob:getLocalVar("ELEMENT")
        local procMagic = mob:getLocalVar("PROC_MAGIC")

        if element == 0 then
            element = updateElement(mob)
        end

        if os.time() < procMagic then
            return
        end

        removeProc(mob)

        if spell:getElement() == elements[element].counter then
            local procs  = mob:getLocalVar("PROCS")
            local result = procs + 2

            mob:setLocalVar("PROC_MAGIC", os.time() + 3)

            if result > 30 then
                updateElement(mob, element)
            else
                mob:setLocalVar("PROCS", result)
                mob:weaknessTrigger(1)
            end
        end
    end)
end

local finalLocations =
{
    {
        name    = "Yasuo Hasaki",
        base    = { 183, 33 }, -- Paramount_Gallu
        flag    = 135,
        lv      = 110,
        hp      = 300000,
        area    = "Castle_Zvahl_Keep",
        aeffect = { xi.mob.ae.ENDARK, 40, 90 },
        mods    =
        {
            [xi.mod.UDMGPHYS]       = -9000,
            [xi.mod.UDMGRANGE]      = -7500,
            [xi.mod.UDMGMAGIC]      = -6500,
            [xi.mod.UDMGBREATH]     = -7500,
            [xi.mod.MDEF]           =  30,
            [xi.mod.LIGHT_RES_RANK] = -4,
            [xi.mod.DARK_RES_RANK]  = 3,
            [xi.mod.ATT]            = 800,
            [xi.mod.ACC]            = 300,
            [xi.mod.MATT]           = 200,
        },
        effects =
        {
            [xi.effect.REGAIN] = { 10, 3, 0 },
        },

        onMobSpawn = function(mob)
            mob:addImmunity(xi.immunity.DARK_SLEEP)
            mob:addImmunity(xi.immunity.GRAVITY)
            mob:addImmunity(xi.immunity.LIGHT_SLEEP)
            mob:addImmunity(xi.immunity.PETRIFY)
            mob:addImmunity(xi.immunity.SILENCE)
            mob:addImmunity(xi.immunity.TERROR)

            addTrigger(mob)

            local roll = math.random(1, #elements)
            mob:setLocalVar("ELEMENT", roll)
            mob:setSpellList(elements[roll].spells)
        end,

        onMobFight = function(mob, target)
            cq.abilityAt({
                mob    = mob,
                target = target,
                list   =
                {
                    { hp = 90, ability = 730 }, -- Meikyo Shisui
                    { hp = 80, ability = 730 }, -- Meikyo Shisui
                    { hp = 75, ability = 690 }, -- Hundred Fists
                    { hp = 70, ability = 730 }, -- Meikyo Shisui
                    { hp = 60, ability = 730 }, -- Meikyo Shisui
                    { hp = 50, ability = 692 }, -- Chainspell
                    { hp = 40, ability = 730 }, -- Meikyo Shisui
                    { hp = 30, ability = 730 }, -- Meikyo Shisui
                    { hp = 25, ability = 690 }, -- Hundred Fists
                    { hp = 20, ability = 730 }, -- Meikyo Shisui
                    { hp = 10, ability = 730 }, -- Meikyo Shisui
                },
            })
        end,

        pos  =
        {
            { -496.714, -68.000, 60.040, 127 }, -- (H-7) !pos -496.714 -68.000 60.040 162
        },
        pool =
        {
            {
                { cexi.rate.GUARANTEED, xi.item.PRISMATIC_CLUSTER },
            },
            {
                { cexi.rate.GUARANTEED,  6547 }, -- Commendation Bag (100%)
            },
            {
                { cexi.rate.VERY_COMMON, 4020 }, -- Titanium Ore        (24%)
                { cexi.rate.VERY_COMMON, 9455 }, -- Fable Thread        (24%)
            },
            {
                { cexi.rate.VERY_COMMON, 4020 }, -- Titanium Ore     (24%)
                { cexi.rate.VERY_COMMON, 9455 }, -- Fable Thread     (24%)
                { cexi.rate.VERY_COMMON,  722 }, -- Divine Log       (24%)
                { cexi.rate.VERY_COMMON, 1110 }, -- Beetle Blood     (24%)
                { cexi.rate.VERY_COMMON,  836 }, -- Damascene Cloth  (24%)
                { cexi.rate.VERY_COMMON,  655 }, -- Adaman Ingot     (24%)
                { cexi.rate.VERY_COMMON, 1313 }, -- Siren's Hair     (24%)
                { cexi.rate.COMMON,      1712 }, -- Cashmere Wool    (15%)
                { cexi.rate.COMMON,       860 }, -- Behemoth Hide    (15%)
                { cexi.rate.COMMON,      9454 }, -- Embersteel Ingot (15%)
                { cexi.rate.UNCOMMON,     734 }, -- Thokcha Ore      (10%)
                { cexi.rate.UNCOMMON,     647 }, -- Molybdenum Ore   (10%)
                { cexi.rate.UNCOMMON,    1703 }, -- Kunwu Ore        (10%)
                { cexi.rate.RARE,        1311 }, -- Oxblood          ( 5%)
            },
            {
                { cexi.rate.VERY_COMMON,  722 }, -- Divine Log       (24%)
                { cexi.rate.VERY_COMMON, 1110 }, -- Beetle Blood     (24%)
                { cexi.rate.VERY_COMMON,  836 }, -- Damascene Cloth  (24%)
                { cexi.rate.VERY_COMMON,  655 }, -- Adaman Ingot     (24%)
                { cexi.rate.VERY_COMMON, 1313 }, -- Siren's Hair     (24%)
                { cexi.rate.COMMON,      1712 }, -- Cashmere Wool    (15%)
                { cexi.rate.COMMON,       860 }, -- Behemoth Hide    (15%)
                { cexi.rate.COMMON,      9454 }, -- Embersteel Ingot (15%)
                { cexi.rate.UNCOMMON,     734 }, -- Thokcha Ore      (10%)
                { cexi.rate.UNCOMMON,     647 }, -- Molybdenum Ore   (10%)
                { cexi.rate.UNCOMMON,    1703 }, -- Kunwu Ore        (10%)
                { cexi.rate.RARE,        1311 }, -- Oxblood          ( 5%)
            },
            {
                { cexi.rate.GUARANTEED,  9454 }, -- Embersteel Ingot (100%)
            },
            {
                { cexi.rate.VERY_COMMON, xi.item.KENNANS_LONGBOW }, -- Kennan's Longbox (24%)
                { cexi.rate.VERY_COMMON, xi.item.OATHBREAKER     }, -- Oathbreaker      (24%)
                { cexi.rate.VERY_COMMON, xi.item.MANAFLOW_SASH   }, -- Manaflow Sash    (24%)
                { cexi.rate.VERY_COMMON, xi.item.BEASTLY_GIRDLE  }, -- Beastly Girdle   (24%)
            },
            {
                {                600,                         0 }, -- Nothing          (40%)
                { cexi.rate.UNCOMMON,   xi.item.KENNANS_LONGBOW }, -- Kennan's Longbox (10%)
                { cexi.rate.UNCOMMON,   xi.item.OATHBREAKER     }, -- Oathbreaker      (10%)
                { cexi.rate.UNCOMMON,   xi.item.MANAFLOW_SASH   }, -- Manaflow Sash    (10%)
                { cexi.rate.UNCOMMON,   xi.item.BEASTLY_GIRDLE  }, -- Beastly Girdle   (10%)
            },
        },
    },
}

-----------------------------------
-- Ice Lord
-----------------------------------
m:addOverride("xi.actions.mobskills.impact_roar.onMobWeaponSkill", function(target, mob, skill)
    if mob:getPacketName() == "Ice Lord" then
        mob:addStatusEffect(xi.effect.ICE_SPIKES, 35, 0, 0)
    end

    return super(target, mob, skill)
end)

m:addOverride("xi.actions.mobskills.grand_slam.onMobWeaponSkill", function(target, mob, skill)
    if
        mob:getPacketName() == "Ice Lord" and
        target ~= nil
    then
        target:addStatusEffect(xi.effect.FROST, 25, 0, 60)
    end

    return super(target, mob, skill)
end)

-----------------------------------
-- Cape Chelonian
-----------------------------------
m:addOverride("xi.actions.mobskills.harden_shell.onMobWeaponSkill", function(target, mob, skill)
    if mob:getPacketName() == "Cape Chelonian" then
        mob:addStatusEffect(xi.effect.STONESKIN, 400 * (mob:getLocalVar("weaknessCounter") + 1), 0, 0)
    end

    return super(target, mob, skill)
end)

m:addOverride("xi.actions.mobskills.tortoise_stomp.onMobWeaponSkill", function(target, mob, skill)
    local mobName = mob:getPacketName()

    if target == nil then
        return super(target, mob, skill)
    end

    if mobName == "Cape Chelonian" then
        target:addStatusEffect(xi.effect.RASP, 30, 0, 60)
    elseif mobName == "Orichaltoise" then
        target:addStatusEffect(xi.effect.FROST, 50, 0, 60)
    end

    return super(target, mob, skill)
end)

-----------------------------------
-- Avalerion
-----------------------------------
m:addOverride("xi.actions.mobskills.stormwind.onMobWeaponSkill", function(target, mob, skill)
    local mobName = mob:getPacketName()

    if
        mob:getPacketName() == "Avalerion" and
        target ~= nil
    then
        target:addStatusEffect(xi.effect.DIA, 25, 0, 90)
    end

    return super(target, mob, skill)
end)

-----------------------------------
-- Pyrolynx
-----------------------------------
m:addOverride("xi.actions.mobskills.petrifactive_breath.onMobWeaponSkill", function(target, mob, skill)
    local mobName = mob:getPacketName()

    if
        mob:getPacketName() == "Pyrolynx" and
        target ~= nil
    then
        target:addStatusEffect(xi.effect.BURN, 80, 0, 30)
        mob:addStatusEffect(xi.effect.BLAZE_SPIKES, 25, 0, 0)

        -- 20% chance to reset enmity
        if math.random(0, 100) > 80 then
            mob:resetEnmity(target)
        end
    end

    return super(target, mob, skill)
end)

local function createAdd(mobInfo, name, areaName)
    table.insert(entity, {
        id          = string.upper(name),
        packetName  = mobInfo.name,
        name        = name,
        type        = xi.objType.MOB,
        groupId     = mobInfo.base[2],
        groupZoneId = mobInfo.base[1],
        area        = areaName,
        pos         = { 1, 1, 1, 1 },
        level       = mobInfo.level,
        loot        = mobInfo.loot,
        pool        = mobInfo.pool,
        mods        = mobInfo.mods,
        effects     = mobInfo.effects,
        aeffect     = mobInfo.aeffect,
        onMobFight  = mobInfo.onMobFight,
        onMobRoam   = function(mob)
            mob:setHP(0)
        end,
    })
end

for _, mobInfo in pairs(mobs) do
    for _, areaName in pairs(mobInfo.area) do
        if mobInfo.num > 0 then
            for index = 1, mobInfo.num do
                createAdd(mobInfo, fmt("{} {}", mobInfo.name, index), areaName)
            end
        else
            createAdd(mobInfo, mobInfo.name, areaName)
        end
    end
end

local function brewnixNormalQuality(player, npc)
    local roll = player:getCharVar(info.lock)

    if roll == 0 then
        roll = math.random(1, #locations)
        player:setCharVar(info.lock, roll)
    end

    local areaName = locations[roll].area
    areaName = string.gsub(areaName, "_", " ")

    cexi.util.dialog(player, {
        fmt("All right so... Word on the street is, there's a very rare beastie about to show up in {}!", areaName),
        { delay = 1000 },
        " How do I know that? Trust me, I just do. Gobbie secrets!",
    }, npc:getPacketName(), { npc = npc })
end

local function brewnixHighQuality(player, npc)
    local roll = player:getCharVar(info.lock)

    if roll == 0 then
        roll = math.random(1, #goblins[1].area)
        player:setCharVar(info.lock, roll)
    end

    local areaName = goblins[1].area[roll].name
    areaName = string.gsub(areaName, "_", " ")

    cexi.util.dialog(player, {
        fmt("All right so... Word on the street is, Smugnix and his band of cronies have buried something good in {}.", areaName),
        { delay = 1000 },
        " If you can beat them to the punch, maybe you can take that treasure for yourself!",
        " How do I know that? Trust me, I just do. Gobbie secrets!",
    }, npc:getPacketName(), { npc = npc })
end

local function brewnixExtraQuality(player, npc)
    cexi.util.dialog(player, {
        fmt("All right so... There's well kept gobbie secret that extremely rare beasties can be found in certain areas.", areaName),
        { delay = 1000 },
        " If you look for our special mark in Uleguerand Range, Cape Teriggan, Attohwa Chasm, or Ifrits Cauldron, I'm sure something will turn up.",
        { delay = 1000 },
        "Don't underestimate these ones or you might not be able to bring me another brew! Haha... You should probably take some friends.",
    }, npc:getPacketName(), { npc = npc })
end

local function brewnixFinalQuality(player, npc)
    player:setCharVar(info.lock, 1)

    cexi.util.dialog(player, {
        fmt("All right so... When there's a really dangerous monster, us gobbies place down a special gobbie seal to warn each other!", areaName),
        { delay = 1000 },
        " I'm aware of such a seal in Castle Zvahl Keep. A monster that powerful must be carrying some really good stuff!",
        { delay = 1000 },
        "If you happen to go check it out, I think you'll want to take a lot of friends. And I mean a lot.",
    }, npc:getPacketName(), { npc = npc })
end

local function brewnixSpecialQuality(player, npc)
    player:setCharVar(info.lock, 1)

    cexi.util.dialog(player, {
        "I guess I can let ya in on it. Find a Gatherer's Mark in La Theine Plateau, Konschtat Highlands or Tahrongi Canyon.",
    }, npc:getPacketName(), { npc = npc })
end


local brewShop =
{
    { "M. Carp Creel x12", { { 5810, 12 } },  40 },
    { "Titanium Ore",                  4020,  60 },
    { "Fable Thread",                  9455,  60 },
    { "Gob. Commendation",             4035,  80 },
    { "Eltoro Leather",                1767, 150 },
    { "Viridian Urushi",               1763, 150 },
    { "Galateia",                      1769, 150 },
    { "Cashmere Wool",                 1712, 500 },
}

local function brewnixMenu(dialog)
    return function(player, npc, tbl)
        local balance = player:getCharVar(info.points)

        if balance == 0 then
            cexi.util.dialog(player, dialog, npc:getPacketName(), { npc = npc })
        else
            cexi.util.dialog(player, { "Here to spend points? Fine, but please bring that brew afterwards!" }, npc:getPacketName(), { npc = npc })
            cexi.util.simpleShop(player, npc, brewShop, function(player, npc, item)
                cq.purchaseItem(player, npc, item, { var = info.points })
            end, fmt("Select reward ({} Battle Points):", balance))
        end
    end
end

local step =
{
    {
        check     = cq.checks({ level = 15 }),
        [BREWNIX] = cq.dialog({
            quest = info.name,
            name  = "Brewnix",
            event =
            {
                "Not so fast haha... where you going buddy? It's your round!",
                { delay = 2000 },
                { entity = "Brewnix", animate = 243, mode = 4 }, -- Sweating
                " Just kidding *hic*! Erm, look actually, could you *gulp* help a gobbie out?",
                { delay = 1000 },
                " Look! My glass is empty and I'm out of goblin brew! This is an *hic* emergency!",
            },
            after = function(player)
                player:setCharVar(info.lock, 0)
            end,
        })
    },
    {
        [BREWNIX] =
        {
            onTrigger = brewnixMenu({
                "W-what's in it for you? Haha, glad ya asked. Gobs have all the secrets you know!",
                " You bring me a goblin brew and I'll tell ya where to find a very special beastie!",
                "Now what'dya say? Are you going to bring me that Goblin Brew?",
            }),
            onTrade = cq.trade({
                name = "Brewnix",
                list =
                {
                    {
                        required  = 9435,
                        increment = 1,
                        accepted  =
                        {
                            { entity = "Brewnix", animate = 243, mode = 4 }, -- Sweating
                            "This *gulp* is *gulp* the stuff! Yes! Hmmm... This really hits the spot. *gulp*",
                            { delay = 1000 },
                            " All right, you're a hero! I betcha wanna know all the gobbie secrets now huh?",
                        },
                    },
                    {
                        required  = 9436,
                        increment = 2,
                        accepted  =
                        {
                            { entity = "Brewnix", animate = 243, mode = 4 }, -- Sweating
                            "Woah!! Not only did you bring me a *gulp* but this is a real nice brew! Wait a minu~ *gulp* *gulp*",
                            { delay = 1000 },
                            " You're a hero! And because you're such a pal, I'm gonna let ya in on a really BIG gobbie secret!",
                        },
                    },
                    {
                        required  = 9437,
                        increment = 3,
                        accepted  =
                        {
                            { entity = "Brewnix", animate = 243, mode = 4 }, -- Sweating
                            "This far exceeded my expectations, friend! You really needn't have... haha *gulp* *gulp*... Mmm... That's real good stuff.",
                            { delay = 1500 },
                            " *gulp* Oh... you wanna know a gobbie secret?",
                        }
                    },
                    {
                        required  = 9438,
                        increment = 4,
                        accepted  =
                        {
                            { entity = "Brewnix", animate = 243, mode = 4 }, -- Sweating
                            "...I can't believe my little gobbie eyes! I've never seen such an incredible brew in all my life...",
                            " *gulp* *gulp* *gulp*... Mmm... *gulp... All right, this is a big one. I'm gonna let you know the biggest gobbie secret of them all!",
                        },
                    },
                    {
                        required  = xi.item.SPECIAL_GOBLIN_BREW,
                        increment = 5,
                        accepted  =
                        {
                            { entity = "Brewnix", animate = 243, mode = 4 }, -- Sweating
                            "Well, well, you one of those gatherers? Gobs have the best places all mapped out you know! Harvesting, excavating, logging, mining, you name it!",
                            " *gulp* *gulp* *gulp*... Mmm... *gulp... All right, I guess I can let ya in on it.",
                            "Find a Gatherer's Mark in La Theine Plateau, Konschtat Highlands or Tahrongi Canyon.",
                        },
                    },
                },
                declined =
                {
                    "Aw man, this isn't what I'm after. Please bring a goblin brew, I'm getting desperate!",
                },
            })
        },
    },
    {
        [BREWNIX] = brewnixNormalQuality,
    },
    {
        [BREWNIX] = brewnixHighQuality,
    },
    {
        [BREWNIX] = brewnixExtraQuality,
    },
    {
        [BREWNIX] = brewnixFinalQuality,
    },
    {
        [BREWNIX] = brewnixSpecialQuality,
    },
}

local function nameToID(str)
    return string.upper(string.gsub(str, " ", "_"))
end

for index, battle in pairs(locations) do
    local pos   = battle.pos[math.random(1, #battle.pos)]
    local mobID = nameToID(battle.name)
    local popID = fmt("MARK_{}", mobID)

    table.insert(entity, {
        id          = popID,
        name        = "Goblin Mark",
        marker      = cq.SIDE_QUEST,
        area        = battle.area,
        pos         = pos,
        dialog      =
        {
            DEFAULT = { "Goblins have marked something of importance here." },
        },
    })

    table.insert(entity, {
        id          = mobID,
        name        = battle.name,
        type        = xi.objType.MOB,
        groupId     = battle.base[2],
        groupZoneId = battle.base[1],
        look        = battle.look,
        flags       = battle.flag or 592,
        area        = battle.area,
        pos         = pos,
        level       = battle.lv,
        hp          = battle.hp,
        pool        = battle.pool,
        ja2h        = battle.ja2h,
        delCap      = true,
        points =
        {
            var     = info.points,
            message = info.msg,
            amount  = { 5, 12 },
            exp     = 2500,
        },
        onMobFight = function(mob, target)
            cq.abilityAt({
                mob    = mob,
                target = target,
                list   =
                {
                    { hp = 50, ability = battle.ja2h },
                },
            })
        end,
    })

    step[3][popID] = cq.menu({
        check    = cq.checks({ vareq = { info.lock, index } }),
        spawn    = { mobID },
        title    = "Ready to battle?",
        levelCap = battle.cap,
        nextPos  = battle.pos,
        setVar   = { { info.var, 1 }, { info.lock, 0 } },
        options  =
        {
            {
                "Not yet",
            },
            {
                "I'm ready",
                true,
            },
        },
    })
end

for _, battle in pairs(goblins) do
    for index, areaInfo in pairs(battle.area) do
        local pos   = areaInfo.pos[math.random(1, #areaInfo.pos)]
        local mobID = nameToID(battle.name)
        local popID = fmt("{}_{}", string.upper(areaInfo.name), mobID)

        table.insert(entity, {
            id          = popID,
            name        = "Goblin Stash",
            marker      = cq.SIDE_QUEST,
            area        = areaInfo.name,
            pos         = pos,
            dialog      =
            {
                DEFAULT = { "Goblins have buried something of importance here." },
            },
        })

        table.insert(entity, {
            id          = mobID,
            name        = battle.name,
            type        = xi.objType.MOB,
            groupId     = battle.base[2],
            groupZoneId = battle.base[1],
            look        = battle.look,
            flags       = battle.flag or 159,
            area        = areaInfo.name,
            pos         = pos,
            level       = battle.lv,
            hp          = 20000,
            pool        = areaInfo.pool,
            points      =
            {
                var     = info.points,
                message = info.msg,
                amount  = { 8, 15 },
                exp     = 4000,
            },
            onMobFight = function(mob, target)
                cexi.mob_util.ignorePet(mob, target)
                cq.spawnWave({
                    parent = mob,
                    target = target,
                    waves  =
                    {
                        { hp = 90, mobs = mobSets.GOBLIN_CRONY },
                    },
                })
            end,
        })

        step[4][popID] = cq.menu({
            check   = cq.checks({ vareq = { info.lock, index } }),
            spawn   = { mobID },
            title   = "Start digging?",
            nextPos = areaInfo.pos,
            setVar  = { { info.var, 1 }, { info.lock, 0 } },
            options =
            {
                {
                    "Not yet",
                },
                {
                    "I'm ready",
                    true,
                },
            },
        })
    end
end

for index, battle in pairs(extraLocations) do
    local pos   = battle.pos[math.random(1, #battle.pos)]
    local mobID = nameToID(battle.name)
    local popID = fmt("MARK_{}", mobID)

    table.insert(entity, {
        id          = popID,
        name        = "Special Mark",
        marker      = cq.SIDE_QUEST,
        area        = battle.area,
        pos         = pos,
        dialog      =
        {
            DEFAULT = { "Goblins have marked something of special importance here." },
        },
    })

    table.insert(entity, {
        id          = mobID,
        name        = battle.name,
        type        = xi.objType.MOB,
        groupId     = battle.base[2],
        groupZoneId = battle.base[1],
        look        = battle.look,
        flags       = battle.flags or 592,
        area        = battle.area,
        pos         = pos,
        level       = battle.lv,
        hp          = battle.hp,
        pool        = battle.pool,
        mods        = battle.mods,
        effects     = battle.effects,
        aeffect     = battle.aeffect,
        onMobSpawn  = battle.onMobSpawn,
        onMobFight  = battle.onMobFight,
        points      =
        {
            var     = info.points,
            message = info.msg,
            amount  = { 35, 50 },
            exp     = 5000,
        },
    })

    step[5][popID] = cq.menu({
        spawn    = { mobID },
        title    = "Ready to battle?",
        levelCap = battle.cap,
        nextPos  = battle.pos,
        setVar   = { { info.var, 1 }, { info.lock, 0 } },
        options  =
        {
            {
                "Not yet",
            },
            {
                "I'm ready",
                true,
            },
        },
    })
end

for index, battle in pairs(finalLocations) do
    local pos   = battle.pos[math.random(1, #battle.pos)]
    local mobID = nameToID(battle.name)
    local popID = fmt("SEAL_{}", mobID)

    table.insert(entity, {
        id          = popID,
        name        = "Goblin Seal",
        marker      = cq.SIDE_QUEST,
        area        = battle.area,
        pos         = pos,
        dialog      =
        {
            DEFAULT = { "Goblins have made a mark here denoting extreme danger." },
        },
    })

    table.insert(entity, {
        id          = mobID,
        name        = battle.name,
        type        = xi.objType.MOB,
        groupId     = battle.base[2],
        groupZoneId = battle.base[1],
        look        = battle.look,
        flags       = battle.flag or 592,
        area        = battle.area,
        pos         = pos,
        level       = battle.lv,
        hp          = battle.hp,
        pool        = battle.pool,
        mods        = battle.mods,
        effects     = battle.effects,
        aeffect     = battle.aeffect,
        onMobSpawn  = battle.onMobSpawn,
        onMobFight  = battle.onMobFight,
        points =
        {
            var     = info.points,
            message = info.msg,
            amount  = { 120, 160 },
            exp     = 9000,
        },
    })

    step[6][popID] = cq.menu({
        check    = cq.checks({ vareq = { info.lock, index } }),
        spawn    = { mobID },
        title    = "Ready to battle?",
        levelCap = battle.cap,
        nextPos  = battle.pos,
        setVar   = { { info.var, 1 }, { info.lock, 0 } },
        options  =
        {
            {
                "Not yet",
            },
            {
                "I'm ready",
                true,
            },
        },
    })
end

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

for _, location in pairs(helmLocations) do
    local popID = fmt("GMARK_{}", mobID)

    table.insert(entity, {
        id          = popID,
        name        = "Gatherer's Mark",
        marker      = cq.SIDE_QUEST,
        area        = location.area,
        pos         = location.pos,
        dialog      =
        {
            DEFAULT = { "Goblins have made a mark indicating a lucrative gathering spot." },
        },
    })

    step[7][popID] = function(player, npc)
        local alliance = player:getAlliance()

        if #alliance > 6 then
            player:sys("You may not enter this event with more than 6 players.")
            return
        end

        delaySendMenu(player, {
            title   = "Ready to begin? (Duration: 10 Mins)",
            options =
            {
                {
                    "Not yet",
                    function()
                    end,
                },
                {
                    "I'm ready",
                    function()
                        -- Reset player's quest so they cannot respawn event
                        player:setCharVar(info.var, 1)

                        local zoneID = player:getZoneID()

                        for _, member in pairs(alliance) do
                            if member:getZoneID() == zoneID then
                                member:setCharVar("[CQ]SPECIAL_BREW", 1, os.time() + 600) -- 10 Min expiry
                                member:sys("Gobbie Gathering has begun! (10 Minutes remaining)")

                                member:countdown(600)

                                member:timer(300000, function(playerArg)
                                    if
                                        playerArg ~= nil and
                                        playerArg:getZoneID() == zoneID
                                    then
                                        playerArg:sys("Gobbie Gathering: 5 Minutes remaining!")
                                    end
                                end)

                                member:timer(540000, function(playerArg)
                                    if
                                        playerArg ~= nil and
                                        playerArg:getZoneID() == zoneID
                                    then
                                        playerArg:sys("Gobbie Gathering: 1 Minute remaining!")
                                    end
                                end)

                                member:timer(601000, function(playerArg)
                                    if
                                        playerArg ~= nil and
                                        playerArg:getZoneID() == zoneID
                                    then
                                        member:countdown()
                                        playerArg:sys("Gobbie Gathering: Your time is up!")
                                    end
                                end)
                            end
                        end
                    end,
                },
            },
        })
    end

    cexi.helm.helmAdd(m, {
        info   =
        {
            zone = location.area,
            type = location.type,
            var  = "[CQ]SPECIAL_BREW",
        },
        items  = location.items,
        points = location.points,
    })
end

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
