-----------------------------------
-- Forgotten Kings
-----------------------------------
-- !setvar [CQ]FORGOTTEN_KINGS 0
-- Indech !pos 99.664 -60.065 242.362 136
-- Trail  !pos 280.624 0.000 237.571 136
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cq_forgotten_kings")

local info =
{
    name     = "Forgotten Kings",
    author   = "Loxley/Hax",
    var      = "[CQ]FORGOTTEN_KINGS",
    flag     = "[CQ]FORGOTTEN_KINGS_POP",
    tally    = "[CQ]FORGOTTEN_GOLD",
    points   = "[CQ]FORGOTTEN_FAVOR",
    required = xi.item.MUIRIDIAN_GOLD,
}

local materials =
{
    { cexi.rate.UNCOMMON, xi.item.SPECTRAL_ORE }, -- Spectral Ore      (10%)
    { cexi.rate.UNCOMMON,                  908 }, -- Adamantoise Shell (10%)
    { cexi.rate.UNCOMMON,                  722 }, -- Divine Log        (10%)
    { cexi.rate.UNCOMMON,                  646 }, -- Adaman Ore        (10%)
    { cexi.rate.UNCOMMON,                  739 }, -- Orichalcum Ore    (10%)
    { cexi.rate.UNCOMMON,                 1311 }, -- Oxblood           (10%)
    { cexi.rate.UNCOMMON,                 1313 }, -- Siren's Hair      (10%)
    { cexi.rate.UNCOMMON,                  836 }, -- Damascene Cloth   (10%)
    { cexi.rate.UNCOMMON,                 1312 }, -- Angel Skin        (10%)
    { cexi.rate.UNCOMMON,                 1110 }, -- Beetle Blood      (10%)
}

local potions =
{
    { cexi.rate.COMMON,   4150 }, -- Eye Drops  (15%)
    { cexi.rate.COMMON,   4151 }, -- Echo Drops (15%)
    { cexi.rate.COMMON,   4154 }, -- Holy Water (15%)
    { cexi.rate.COMMON,   4113 }, -- Potion +1  (15%)
    { cexi.rate.COMMON,   4129 }, -- Ether +1   (15%)
    { cexi.rate.UNCOMMON, 4145 }, -- Elixir     (10%)
    { cexi.rate.RARE,     4130 }, -- Ether +2   ( 5%)
    { cexi.rate.RARE,     4114 }, -- Potion +2  ( 5%)
    { cexi.rate.RARE,     4155 }, -- Remedy     ( 5%)
}

local rewards =
{
    {
        -- 100%
        { cexi.rate.COMMON, 1255 }, -- Fire Ore
        { cexi.rate.COMMON, 1256 }, -- Ice Ore
        { cexi.rate.COMMON, 1257 }, -- Wind Ore
        { cexi.rate.COMMON, 1258 }, -- Earth Ore
        { cexi.rate.COMMON, 1259 }, -- Lightning Ore
        { cexi.rate.COMMON, 1260 }, -- Water Ore
        { cexi.rate.COMMON, 1261 }, -- Light Ore
        { cexi.rate.COMMON, 1262 }, -- Dark Ore
    },
    {
        { cexi.rate.GUARANTEED, xi.item.SPECTRAL_ORE }, -- Spectral Ore (100%)
    },
    materials,
    materials,
    potions,
    {
        {              400, 0                     }, -- Nothing       (40%)
        { cexi.rate.COMMON, xi.item.SLUMBER_RING  }, -- Slumber Ring  (15%)
        { cexi.rate.COMMON, xi.item.GHOST_PENDANT }, -- Ghost Pendant (15%)
        { cexi.rate.COMMON, xi.item.SOMBER_SHROUD }, -- Somber Shroud (15%)
        { cexi.rate.COMMON, xi.item.TERROR_TALONS }, -- Terror Talons (15%)
    },
}

local costs = { 1000, 2000, 3000 }

local upgrades =
{
    {
        name = "Bloodbead Gorget",
        item = xi.item.BLOODBEAD_GORGET,
        cost = costs,
        tier =
        {
            { augs = { 514, 0, 23, 2        }, mats = { { xi.item.WOLFRAM_STEEL, 2 }, { xi.item.COBALT_ORE, 2 } }, desc = "Two wolfram steel and two cobalt ore."    }, -- VIT+1, Accuracy +3
            { augs = { 514, 1, 23, 3        }, mats = { { xi.item.WOLFRAM_STEEL, 4 }, { xi.item.COBALT_ORE, 4 } }, desc = "Four wolfram steel and four cobalt ores." }, -- VIT+2, Accuracy +4
            { augs = { 514, 2, 23, 4, 54, 1 }, mats = { { xi.item.WOLFRAM_STEEL, 6 }, { xi.item.COBALT_ORE, 6 } }, desc = "Six wolfram steel and six cobalt ores."   }, -- VIT+3, Accuracy +5, Phys. dmg. taken -2%
        },
    },
    {
        name = "Bahram Cuisses",
        item = xi.item.BAHRAM_CUISSES,
        cost = costs,
        tier =
        {
            { augs = { 512, 0, 25, 2         }, mats = { { xi.item.WOLFRAM_STEEL, 2 }, { xi.item.COBALT_ORE, 2 } }, desc = "Two wolfram steel and two cobalt ore."    }, -- STR+1, Attack +3
            { augs = { 512, 1, 25, 3         }, mats = { { xi.item.WOLFRAM_STEEL, 4 }, { xi.item.COBALT_ORE, 4 } }, desc = "Four wolfram steel and four cobalt ores." }, -- STR+2, Attack +4
            { augs = { 512, 2, 25, 4, 143, 1 }, mats = { { xi.item.WOLFRAM_STEEL, 6 }, { xi.item.COBALT_ORE, 6 } }, desc = "Six wolfram steel and six cobalt ores."   }, -- STR+3, Attack +5, Dbl. Atk. +2%
        },
    },
    {
        name = "Setanta's Ledelsens",
        item = xi.item.SETANTAS_LEDELSENS,
        cost = costs,
        tier =
        {
            { augs = { 518, 0, 25, 2         }, mats = { { xi.item.WOLFRAM_STEEL, 2 }, { xi.item.COBALT_ORE, 2 } }, desc = "Two wolfram steel and two cobalt ore."    }, -- CHR+1, Attack +3
            { augs = { 518, 1, 25, 3         }, mats = { { xi.item.WOLFRAM_STEEL, 4 }, { xi.item.COBALT_ORE, 4 } }, desc = "Four wolfram steel and four cobalt ores." }, -- CHR+2, Attack +4
            { augs = { 518, 2, 25, 4, 142, 1 }, mats = { { xi.item.WOLFRAM_STEEL, 6 }, { xi.item.COBALT_ORE, 6 } }, desc = "Six wolfram steel and six cobalt ores."   }, -- CHR+3, Attack +5, Store TP +2
        },
    },
    {
        name = "Bricta's Cuffs",
        item = xi.item.BRICTAS_CUFFS,
        cost = costs,
        tier =
        {
            { augs = { 9,  4, 374, 2         }, mats = { { xi.item.WOLFRAM_STEEL, 2 }, { xi.item.COBALT_ORE, 2 } }, desc = "Two wolfram steel and two cobalt ore."    }, -- MP+5,  Enhancing Mag. Duration +3
            { augs = { 9,  9, 374, 3         }, mats = { { xi.item.WOLFRAM_STEEL, 4 }, { xi.item.COBALT_ORE, 4 } }, desc = "Four wolfram steel and four cobalt ores." }, -- MP+10, Enhancing Mag. Duration +4
            { augs = { 9, 14, 374, 4, 355, 1 }, mats = { { xi.item.WOLFRAM_STEEL, 6 }, { xi.item.COBALT_ORE, 6 } }, desc = "Six wolfram steel and six cobalt ores."   }, -- MP+15, Enhancing Mag. Duration +5, Enhancing Mag. Recast -2
        },
    },
    {
        name = "Shrewd Pumps",
        item = xi.item.SHREWD_PUMPS,
        cost = costs,
        tier =
        {
            { augs = { 9,  4, 35, 0        }, mats = { { xi.item.WOLFRAM_STEEL, 2 }, { xi.item.COBALT_ORE, 2 } }, desc = "Two wolfram steel and two cobalt ore."    }, -- MP+5,  Magic Accuracy+1
            { augs = { 9,  9, 35, 1        }, mats = { { xi.item.WOLFRAM_STEEL, 4 }, { xi.item.COBALT_ORE, 4 } }, desc = "Four wolfram steel and four cobalt ores." }, -- MP+10, Magic Accuracy+2
            { augs = { 9, 14, 35, 2, 49, 0 }, mats = { { xi.item.WOLFRAM_STEEL, 6 }, { xi.item.COBALT_ORE, 6 } }, desc = "Six wolfram steel and six cobalt ores."   }, -- MP+15, Magic Accuracy+3, Haste +1%
        },
    },
}

local CROWN         = "WEATHERED_CROWN"
local FORLORN_TRAIL = "FORLORN_TRAIL"
local CHEST         = "MUIRIDIAN_TROVE"

local WeatheredCrown = "Weathered Crown"
local Indech         = "Indech"

local TETHRA     = "TETHRA"
local ETHNIU     = "ETHNIU"
local LUGH       = "LUGH"
local ELATHA     = "ELATHA"
local BUARAINECH = "BUARAINECH"

local function indechDialog(tbl)
    return cq.npcSpawner(tbl, Indech, WeatheredCrown)
end

local entity =
{
    {
        id     = CROWN,
        name   = WeatheredCrown,
        marker = cq.MAIN_QUEST,
        area   = "Beaucedine_Glacier_[S]",
        pos    = { 99.664, -60.065, 242.362, 50 }, -- (I-7) !pos 99.664 -60.065 242.362 136
        dialog =
        {
            DEFAULT = cq.NOTHING,
        },
    },
    {
        id     = "INDECH",
        name   = Indech,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = 29,  -- Fomor
            main = 112, -- Darksteel Maul
            offh = 29,  -- Hard Shield
            head = 105, -- Crown
            body = 202, -- Nzingha Cuirass
            hand = cexi.model.PLASTRON,
            legs = cexi.model.PLASTRON,
            feet = cexi.model.PLASTRON,
        }),
        area   = "Beaucedine_Glacier_[S]",
        pos    = { 99.664, -60.065, 242.362, 50 }, -- (I-7) !pos 99.664 -60.065 242.362 136
        hidden = true,
    },
    {
        id     = FORLORN_TRAIL,
        name   = "Forlorn Trail",
        marker = cq.MAIN_QUEST,
        area   = "Beaucedine_Glacier_[S]",
        pos    = { 280.624, 0.000, 237.571, 94 }, -- (J-7) !pos 280.624 0.000 237.571 136
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   =
            {
                { despawn = { "Forlorn Trail" } },
                { spawn   = { "Muiridian Trove" } },
                { delay   = 3000 },
                { entity  = "Muiridian Trove", packet = "open" },
                { delay   = 6000 },
                { despawn = { "Muiridian Trove" } },
                { spawn   = { "Forlorn Trail" } },
            },
        },
    },
    {
        id        = CHEST,
        name      = "Muiridian Trove",
        type      = xi.objType.NPC,
        look      = 969,
        area      = "Beaucedine_Glacier_[S]",
        pos       = { 280.624, 0.000, 237.571, 94 }, -- (J-7) !pos 280.624 0.000 237.571 136
        hidden    = true,
        hidename  = true,
        notarget  = true,
        dialog    =
        {
            DEFAULT = { "It's locked." },
        },
    },
    {
        id          = TETHRA,
        name        = "Tethra",
        type        = xi.objType.MOB,
        area        = "Beaucedine_Glacier_[S]",
        pos         = { 276.206, -0.011, 243.519, 39 },
        groupId     = 23,
        groupZoneId = 175,
        level       = 85,
    },
    {
        id          = ETHNIU,
        name        = "Ethniu",
        type        = xi.objType.MOB,
        area        = "Beaucedine_Glacier_[S]",
        pos         = { 280.200, -0.510, 244.999, 56 },
        groupId     = 14,
        groupZoneId = 175,
        level       = 85,
    },
    {
        id          = LUGH,
        name        = "Lugh",
        type        = xi.objType.MOB,
        area        = "Beaucedine_Glacier_[S]",
        pos         = { 285.715, -0.086, 241.852, 95 },
        groupId     = 18,
        groupZoneId = 171,
        level       = 85,
    },
    {
        id          = ELATHA,
        name        = "Elatha",
        type        = xi.objType.MOB,
        area        = "Beaucedine_Glacier_[S]",
        pos         = { 285.264, -0.064, 235.853, 131 },
        groupId     = 15,
        groupZoneId = 164,
        level       = 85,
    },
    {
        id          = BUARAINECH,
        name        = "Burainech",
        type        = xi.objType.MOB,
        area        = "Beaucedine_Glacier_[S]",
        pos         = { 281.382, 0.258, 230.801, 159 },
        groupId     = 18,
        groupZoneId = 164,
        level       = 85,
    },
}

local function rollRewards(text)
    return function(player, npc, entity)
        -- Update current step immediately so players can't spam this
        player:setCharVar(info.var,   1) -- Skip quest intro
        player:setLocalVar(info.flag, 0)

        -- Display NPC event
        cexi.util.dialog(player, entity.dialog[text], "", { npc = npc })

        local zone   = player:getZone()
        local result = zone:queryEntitiesByName("DE_Muiridian Trove")

        if result ~= nil then
            cexi.util.treasurePool(player, rewards, result[1])
        end
    end
end

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local goldList =
{
    { "Battle Fomor Kings",     "FOMOR_KINGS",    50 },
    { "Vaquero Hat",                    23806,   100 },
    { "Levin",                          22067,   200 },
}

local favorList =
{
    { "Cobalt Ore",                      2859,  800 },
    { "Wolfram Steel",                   2858,  800 },
    { "Fable Thread",                    9455, 1500 },
    { "Titanium Ore",                    4020, 1500 },
    { "Slumber Ring",    xi.item.SLUMBER_RING, 3000 },
    { "Ghost Pendant",  xi.item.GHOST_PENDANT, 3000 },
    { "Somber Shroud",  xi.item.SOMBER_SHROUD, 3000 },
    { "Terror Talons",  xi.item.TERROR_TALONS, 5000 },
}

local rewardFunctions =
{
    ["FOMOR_KINGS"] = function(player, npc, item)
        if player:getCharVar(info.var) == 0 then
            player:sys("You are already ready for battle.")
            return
        end

        player:incrementCharVar(info.tally, -item[3])
        player:setCharVar(info.var, 2)

        cexi.util.dialog(player, indechDialog({
            "Indech : ...",
            { delay = 1000 },
            " Find the Forlorn Trail ...",
            { delay = 1000 },
            "Indech : ... There you will find what you seek.",
        }))
    end,
}

local function spendGold(player, npc, item)
    local balance = player:getCharVar(info.tally)

    if balance < item[3] then
        player:sys("You haven't stored enough gold.")
        return
    end

    local menu    =
    {
        title   = fmt("Spend {} coins? ({} available)", item[3], balance),
        options =
        {
            {
                "Decline.",
                function()
                end,
            },
            {
                fmt("Purchase: {}", item[1]),
                function(playerArg)
                    if type(item[2]) == "string" then
                        rewardFunctions[item[2]](player, npc, item)
                    else
                        if npcUtil.giveItem(player, item[2]) then
                            player:incrementCharVar(info.tally, -item[3])
                        end
                    end
                end,
            },
        },
    }

    delaySendMenu(player, menu)
end

local function spendFavor(player, npc, item)
    local balance = player:getCharVar(info.points)

    if balance < item[3] then
        player:sys("You haven't accumulated enough favor.")
        return
    end

    local menu    =
    {
        title   = fmt("Spend {} favor? ({} available)", item[3], balance),
        options =
        {
            {
                "Decline.",
                function()
                end,
            },
            {
                fmt("Purchase: {}", item[1]),
                function(playerArg)
                    if npcUtil.giveItem(player, item[2]) then
                        player:incrementCharVar(info.points, -item[3])
                    end
                end,
            },
        },
    }

    delaySendMenu(player, menu)
end

local qtyList =
{
    {  "x1",  1 },
    {  "x2",  2 },
    {  "x3",  3 },
    {  "x6",  6 },
    { "x12", 12 },
    { "x24", 24 },
    { "x36", 36 },
    { "x99", 99 },
}

local function selectQty(player, npc)
    local balance = player:getCharVar(info.tally)
    local tbl     = {}

    for _, qtyInfo in pairs(qtyList) do
        if qtyInfo[2] <= balance then
            table.insert(tbl, {
                qtyInfo[1],
                function()
                    if npcUtil.giveItem(player, { { info.required, qtyInfo[2] } }) then
                        player:incrementCharVar(info.tally, -qtyInfo[2])

                        if balance - qtyInfo[2] > 0 then
                            selectQty(player, npc)
                        end
                    end
                end,
            })
        end
    end

    delaySendMenu(player, {
        title   = fmt("Withdraw coins ({}):", balance),
        options = tbl,
    })
end

-----------------------------------
-- Upgrades
-----------------------------------
local function getAugTier(itemInfo, itemAug)
    local tier = 0

    for augTier = 1, #itemInfo.tier do
        if
            itemInfo.tier[augTier].augs[1] == itemAug[1][1] and
            itemInfo.tier[augTier].augs[2] == itemAug[1][2] and
            itemInfo.tier[augTier].augs[3] == itemAug[2][1] and
            itemInfo.tier[augTier].augs[4] == itemAug[2][2]
        then
            tier = augTier
        end
    end

    return tier
end

local function indechOnTrade(player, npc, trade)
    if npcUtil.tradeHasOnly(trade, xi.item.MUIRIDIAN_GOLD) then
        local balance = player:getCharVar(info.tally)
        local qty     = trade:getItemQty(xi.item.MUIRIDIAN_GOLD)

        cexi.util.dialog(player, indechDialog({
            fmt("Indech : ...Good. {} gold coins makes {}.", qty, balance + qty),
            { entity = Indech, emote = xi.emote.YES },
            { delay = 2000 },
        }))

        return
    end

    for _, itemInfo in pairs(upgrades) do
        if npcUtil.tradeHas(trade, itemInfo.item, false) then
            local item = cexi.util.augment.getTradedItem(trade, itemInfo.item)
            local augs = cexi.util.augment.getAugments(player, item)
            local tier = 0

            if #augs > 0 then
                tier = getAugTier(itemInfo, augs)
            end

            if tier == #itemInfo.cost then
                cexi.util.dialog(player, indechDialog({ "Indech : There is nothing else I can do with this..." }))
                return
            end

            local tierInfo = itemInfo.tier[tier + 1]

            if npcUtil.tradeHasExactly(trade, itemInfo.item) then
                local totalCost = itemInfo.cost[tier + 1]

                cexi.util.dialog(player, indechDialog({
                    fmt("Indech : Ah.... The {}. Win our favor and bring the following materials:", itemInfo.name),
                    fmt("(Favor required: {})", totalCost),
                    tierInfo.desc,
                }))
                return
            end

            if cexi.util.tradeHasExactly(trade, { { itemInfo.item, 1 },tierInfo.mats[1], tierInfo.mats[2] } ) then
                local totalCost = itemInfo.cost[tier + 1]

                if player:getCharVar(info.points) < totalCost then
                    cexi.util.dialog(player, indechDialog({
                        fmt("Indech : You must earn enough favor...")
                    }))

                    return
                end

                player:incrementCharVar(info.points, -totalCost)
                player:tradeComplete()
                cexi.util.dialog(player, indechDialog({ "Indech : It is done." }))

                player:addItem(itemInfo.item, 1, tierInfo.augs[1], tierInfo.augs[2], tierInfo.augs[3], tierInfo.augs[4], tierInfo.augs[5], tierInfo.augs[6])
                player:timer(2000, function()
                    npc:independentAnimation(player, 12, 2)
                    player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, itemInfo.item)
                end)
            end
        end
    end
end

local function mainMenu()
    return function(player, npc, tbl)
        delaySendMenu(player, {
            title   = "...What is your desire?",
            options =
            {
                {
                    "Nothing",
                    function()
                    end,
                },
                {
                    "Redeem favor",
                    function()
                        local balance = player:getCharVar(info.points)
                        cexi.util.simpleShop(player, npc, favorList, spendFavor, fmt("Redeem favor ({}):", balance))
                    end,
                },
                {
                    "Spend stored coins",
                    function()
                        local balance = player:getCharVar(info.tally)
                        cexi.util.simpleShop(player, npc, goldList, spendGold, fmt("Spend gold coins ({})", balance))
                    end,
                },
                {
                    "Retrieve stored coins",
                    function()
                        local balance = player:getCharVar(info.tally)

                        if balance > 0 then
                            selectQty(player, npc)
                        else
                            cexi.util.dialog(player, {
                                "There is nothing for you here..."
                            }, npc:getPacketName(), { npc = npc })
                        end
                    end,
                },
            },
        })
    end
end

local wave =
{
    TETHRA,
    ETHNIU,
    LUGH,
    ELATHA,
    BUARAINECH,
}

local battleInfo =
{
    flag      = info.flag,
    pointsVar = info.points,
    points    = { 300, 500 },
    message   = "{} gains {} Muiridian favor.",
}

local step =
{
    {
        [CROWN] = cq.dialog({
            quest = info.name,
            event = indechDialog({
                "Indech : ...",
                { delay = 2000 },
                " Why have you disturbed me?",
                { delay = 2000 },
                "Indech : ...",
                { delay = 2000 },
                "Indech : Restore me the pieces of my kingdom... And you shall be rewarded.",
                { delay = 3000 },
            }),
        }),
    },
    {
        [CROWN] =
        {
            onTrigger = mainMenu(),
            onTrade   = indechOnTrade,
        },
    },
    {
        [FORLORN_TRAIL] = cq.menu({
            title    = "You hear a thunderous echo...",
            spawn    = wave,
            flag     = info.flag,
            options  =
            {
                {
                    "Run away",
                },
                {
                    "Stand your ground",
                    true,
                },
            },
        }),
        [TETHRA]     = cq.killStep(FORLORN_TRAIL, wave, nil, battleInfo),
        [ETHNIU]     = cq.killStep(FORLORN_TRAIL, wave, nil, battleInfo),
        [LUGH]       = cq.killStep(FORLORN_TRAIL, wave, nil, battleInfo),
        [ELATHA]     = cq.killStep(FORLORN_TRAIL, wave, nil, battleInfo),
        [BUARAINECH] = cq.killStep(FORLORN_TRAIL, wave, nil, battleInfo),
    },
    {
        [FORLORN_TRAIL] = rollRewards("AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
