-----------------------------------
-- Epic Battles
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cq_epic_battles")

local info =
{
    name     = "Epic Battles",
    author   = "Loxley",
    var      = "[CQ]EPIC_BATTLES",
    required = xi.item.EPIC_LURE,
}

local battles  =
{
    {
        name = "Murky Depths",
        zone = "Caedarva_Mire", -- (H-7) Map #4
        pos  = { 697.674, -7.000, 528.958,  68 }, -- !pos 697.674 -7.000 528.958 79
        mob  =
        {
            name    = "Depth Dweller",
            base    = { 54, 52 }, -- Nostokulshedra
            level   = 99,
            hp      = 125000,
            aeffect = { xi.mob.ae.ENDARK, 40, 90 },
            mods    =
            {
                [xi.mod.ATT]    = 700,
                [xi.mod.REGAIN] = 20,
            },
            mobMods =
            {
                [xi.mobMod.MULTI_HIT] = 5,
            },
            pool    =
            {
                {
                    { cexi.rate.GUARANTEED,   4109 }, -- Water Cluster
                },
                {
                    { cexi.rate.GUARANTEED, xi.item.SLIMY_TENTACLE }, -- Slimy Tentacle
                },
                {
                    { cexi.rate.VERY_COMMON,   887 }, -- Coral Fragment
                    { cexi.rate.COMMON,        888 }, -- Seashell
                    { cexi.rate.COMMON,       4484 }, -- Shall Shell
                    { cexi.rate.COMMON,       1311 }, -- Oxblood
                    { cexi.rate.UNCOMMON,     5449 }, -- Hamsi
                    { cexi.rate.UNCOMMON,      936 }, -- Rock Salt
                    { cexi.rate.UNCOMMON,     1312 }, -- Angel Skin
                    { cexi.rate.RARE,          685 }, -- Khroma Ore
                },
                {
                    { cexi.rate.VERY_COMMON,   876 }, -- Manta Skin
                    { cexi.rate.COMMON,        702 }, -- Ebony Log
                    { cexi.rate.COMMON,        700 }, -- Mahogany Log
                    { cexi.rate.COMMON,        703 }, -- Petrified Log
                    { cexi.rate.UNCOMMON,      792 }, -- Pearl
                    { cexi.rate.UNCOMMON,      793 }, -- Black Pearl
                    { cexi.rate.UNCOMMON,      722 }, -- Divine Log
                    { cexi.rate.RARE,         2359 }, -- Star Sapphire
                },
                {
                    -- 100%
                    { cexi.rate.COMMON, 1255 }, -- Fire Ore
                    { cexi.rate.COMMON, 1256 }, -- Ice Ore
                    { cexi.rate.COMMON, 1257 }, -- Wind Ore
                    { cexi.rate.COMMON, 1258 }, -- Earth Ore
                    { cexi.rate.COMMON, 1259 }, -- Lightning Ore
                    { cexi.rate.COMMON, 1260 }, -- Water Ore
                    { cexi.rate.COMMON, 1261 }, -- Light Ore
                    { cexi.rate.COMMON, 1262 }, -- Dark Ore
                },
            },
        },
    },
}

local entity = {}
local step   = { {} }

for _, battle in pairs(battles) do
    local spawnerID = string.upper(battle.name)
    local mobID     = string.upper(battle.mob.name)

    table.insert(entity, {
        id     = spawnerID,
        name   = battle.name,
        marker = cq.MAIN_QUEST,
        area   = battle.zone,
        pos    = battle.pos,
        dialog =
        {
            DEFAULT = cq.NOTHING,
        },
    })

    table.insert(entity, {
        id          = mobID,
        name        = battle.mob.name,
        type        = xi.objType.MOB,
        area        = battle.zone,
        pos         = battle.pos,
        groupId     = battle.mob.base[2],
        groupZoneId = battle.mob.base[1],
        flags       = 159,
        level       = battle.mob.level,
        hp          = battle.mob.hp,
        aeffect     = battle.mob.aeffect,
        mods        = battle.mob.mods,
        mobMods     = battle.mob.mobMods,
        effects     = battle.mob.effects,
        pool        = battle.mob.pool,
    })

    step[1][spawnerID] =
    {
        onTrigger = cq.dialog({
            step  = false,
            event = { { noturn = true }, "Something may happen here if you have an Epic Lure..." },
        }),
        onTrade = cq.tradeSpawn({ mobID }, info.required),
    }
end

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
