-----------------------------------
-- Thread Bare (Lv45)
-----------------------------------
-- Steps
-----------------------------------
-- !setvar [CW]THREAD_BARE 0
-- Mathias       !pos 48.906 -16.000 -28.922 237
-- Vantage Point !pos 129.538 -40.902 -71.095 197
-- Mathias       !pos 48.906 -16.000 -28.922 237
-- Reward:  Sickle x12
-- Unlocks: Crawler's Nest Harvesting
-----------------------------------
-- !setvar [CW]THREAD_BARE 4

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-thread_bare")

local info =
{
    name   = "Thread Bare",
    author = "Loxley",
    var    = "[CW]THREAD_BARE",
    reward =
    {
        item  = { { 1020, 12 } },
        after = function(player)
            player:setCharVar("[CW]CN_HARVESTING", 1)
            player:printToPlayer("You have unlocked the ability to perform Harvesting in Crawler's Nest.", xi.msg.channel.SYSTEM_3)
            return true
        end,
    },
}

local MATT    = "MATT"
local Mathias = "Mathias"
local VANTAGE = "VANTAGE"

local entity =
{
    {
        id     = MATT,
        name   = Mathias,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.HUME_M,
            face = cexi.face.A4,
            head = cexi.model.NOTHING,
            body = cexi.model.EARTH_DOUBLET,
            hand = cexi.model.TRADERS_SAIO,
            legs = cexi.model.TRADERS_SAIO,
            feet = cexi.model.TRADERS_SAIO,
        }),
        area   = "Metalworks",
        pos    = { 48.906, -16.000, -28.922, 19 }, -- !pos 48.906 -16.000 -28.922 237
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "This predicament is deeply troubling..." },
            START    =
            {
                { emote = xi.emote.SALUTE },
                "Adventurer, we have a serious shortage of materials in our reserves.",
                "This is deeply concerning. And the matter must be resolved immediately.",
                { delay = 1000},
                { emote = xi.emote.THINK },
                { delay = 3000},
                "If war broke out, we wouldn't even have enough for clothes, let alone bandages!",
                "We are sorely in need of your assistance.",
            },

            ACCEPTED =
            {
                -- (Player performs /hurray in response to menu option)
                { entity = "player", emote = xi.emote.HURRAY },
                { delay = 3000 },

                -- Dialog begins
                "Thank you for agreeing to assist us.",
                "Our scouts have reported potential new sites for these raw materials.",
                { delay = 2000 },
                { emote = xi.emote.THINK },
                "They believe the Crawler's Nest in Derfland seems most promising.",
                { delay = 2000 },
                "However, our men cannot go inside. It is much too dangerous.",
                { emote = xi.emote.SALUTE },
                "We need you to investigate. Look for a vantage point and report your findings.",
            },

            REMINDER =
            {
                "Scout a vantage point in Crawler's Nest and report your findings.",
            },

            FINISH =
            {
                "This sounds very encouraging. And not as dangerous as we had initially thought.",
                { delay = 1000 },
                "I shall send our men out at once to begin gathering the materials we need.",
                { delay = 2000 },
                { emote = xi.emote.SALUTE },
                "Thank you for your services. You are dismissed.",
            },

            AFTER = { "Thanks to your help, things are starting to look up." },
        },
    },

    {
        id     = VANTAGE,
        name   = "Vantage Point",
        marker = cq.SIDE_QUEST,
        area   = "Crawlers_Nest",
        pos    = { 129.538, -40.902, -71.095, 0 }, --!pos 129.538 -40.902 -71.095 197
        dialog =
        {
            DEFAULT = cq.NOTHING,
            LOOK    =
            {
                { emotion = "looks out and surveys the surroundings." },
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
            },
            AFTER = cq.NOTHING_ELSE,
        },
    },
}

local step =
{
    {
        check  = cq.checks({ level = 45 }),
        [MATT] = cq.talkStep("START"),
    },
    {
        [MATT] = cq.menuStep("Will you help Bastok?", { { "For the Republic!", "ACCEPTED" }, { "Not my problem." } }, 1, info.name),
    },
    {
        [MATT]    = cq.talkOnly("REMINDER"),
        [VANTAGE] = cq.talkStep("LOOK"),
    },
    {
        [VANTAGE] = cq.talkOnly("AFTER"),
        [MATT]    = cq.giveStep("FINISH", info.reward, info.name, cexi.music.METALWORKS),
    },
    {
        [MATT] = cq.talkOnly("AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
