-----------------------------------
-- The Way of Wadi (Lv10)
-----------------------------------
-- !setvar [CW]WAY_OF_WADI 0
-- Galka Footprint !pos -145.861 3.272 -178.789 191
-- Sunk Junk       !pos -231.452 4.407 -108.065 191
-- Damaged Debris  !pos -212.251 -0.258 -217.423 191
-- Dusty Rust      !pos -63.360 4.576 -218.178 191
-- Galka Footprint !pos -145.861 3.272 -178.789 191
-- Brave Fang      !pos -62.498 2.779 -32.970 237
-- Reward: Onion Sword INT -5 CHR -5, Degen INT +3 CHR +3
-----------------------------------
-- !setvar [CW]WAY_OF_WADI 12

require("modules/module_utils")
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-the_way_of_wadi")

local info =
{
    name    = "The Way of Wadi",
    author  = "Loxley",
    var     = "[CW]WAY_OF_WADI",
    reward  =
    {
        item    = 16534,              -- Onion Sword
        augment = { 523, 4, 525, 4 }, -- INT -5, CHR -5
    },

    reward2 =
    {
        item    = 16517,              -- Degen
        augment = { 516, 2, 518, 2 }, -- INT +3 CHR +3
    },
}

local PASS            = "GALKA_FOOTPRINT"
local Footprint       = "Galka Footprint"
local PassingSunrise  = "Passing Sunrise"

local BRAVE  = "BRAVE"

local SUNK   = "SUNK"
local CRAB   = "CRAB"

local DEBRIS = "DEBRIS"
local HARE   = "HARE"

local DUSTY  = "DUSTY"
local WORM   = "WORM"

local GOBLIN = "GOBLIN"

local entity =
{
    {
        id     = "PASSING",
        name   = PassingSunrise,
        type   = xi.objType.NPC,
        hidden = true,
        look   = cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.A8,
            head = cexi.model.LEATHER_VEST,
            body = 0,
            hand = cexi.model.DOUBLET,
            legs = cexi.model.LIZARD_JERKIN,
            feet = cexi.model.LEATHER_VEST,
            main = 131,
            offh = 131,
        }),
        area   = "Dangruf_Wadi",                     -- (I-12)
        pos    = { -145.861, 3.272, -178.789, 170 }, -- !pos -145.861 3.272 -178.789 191
    },
    {
        id     = PASS,
        name   = "Galka Footprint",
        marker = cq.SIDE_QUEST,
        area   = "Dangruf_Wadi",                     -- (I-12)
        pos    = { -145.861, 3.272, -178.789, 170 }, -- !pos -145.861 3.272 -178.789 191
        from   = "Passing Sunrise",
        dialog =
        {
            DEFAULT  = cq.NOTHING,
            START    =
            {
                { despawn = { Footprint } },
                { spawn = { PassingSunrise } },
                { delay = 2000 },
                { entity = PassingSunrise, face = "player" },
                { delay = 1000 },
                { entity = PassingSunrise, emote = xi.emote.THINK },
                "Passing Sunrise : Let me tell you a story...",
                "Passing Sunrise : Long ago, a young warrior lived in this very wasteland.",
                " He hunted here day and night, fighting hares, crabs and the like.",
                { delay = 2000 },
                "Passing Sunrise : Some say his combat prowess was legendary.",
                " But since he never left this place, nobody really knows for sure.",
                { entity = PassingSunrise, emote = xi.emote.HUH },
                { delay = 1000 },
                "Passing Sunrise : One day, he suddenly disappeared and the pieces of his sword were scattered.",
                " If you find anything left by the fabled Warrior of Wadi, bring it to me.",
                { delay = 2000 },
                { despawn = { PassingSunrise } },
                { spawn = { Footprint } },
            },

            FIRST =
            {
                { despawn = { Footprint } },
                { spawn = { PassingSunrise } },
                { delay = 2000 },
                { entity = PassingSunrise, face = "player" },
                { delay = 1000 },
                { emote = xi.emote.SHOCKED },
                "Passing Sunrise : This is a piece of the Wadi Warrior's sword... So the tales were true!",
                " There must be more of them! Find all the pieces and bring them to me.",
                { delay = 2000 },
                { despawn = { PassingSunrise } },
                { spawn = { Footprint } },
            },

            SECOND =
            {
                { despawn = { Footprint } },
                { spawn = { PassingSunrise } },
                { delay = 2000 },
                { entity = PassingSunrise, face = "player" },
                "Passing Sunrise : This grip looks well worn.",
                " The Warrior of Wadi must have spent countless hours using this!",
                { delay = 2000 },
                { despawn = { PassingSunrise } },
                { spawn = { Footprint } },
            },

            THIRD =
            {
                { despawn = { Footprint } },
                { spawn = { PassingSunrise } },
                { delay = 2000 },
                { entity = PassingSunrise, face = "player" },
                "Passing Sunrise : That's the last piece of the sword!",
                " Let's see how it...",
                { music = cexi.music.RAOGRIMMS_THEME },
                "Passing Sunrise : Wait...",
                " Hold on a minute...",
                { entity = PassingSunrise, emote = xi.emote.CRY },
                "Passing Sunrise : Oh dear, oh dear.",
                " Look at this thing!",
                { entity = PassingSunrise, emote = xi.emote.STAGGER },
                { delay = 1000 },
                "Passing Sunrise : This sword is absolutely terrible!",
                " How could anyone be stupid enough to use this piece of junk for so long!?",
                { entity = PassingSunrise, emote = xi.emote.SIGH },
                { delay = 1000 },
                "Passing Sunrise : I guess the Warrior of Wadi was better left as legend.",
                { delay = 1000 },
                { entity = PassingSunrise, emote = xi.emote.TOSS },
                "Passing Sunrise : Maybe if you take this sword to Brave Fang in the Metalworks...",
                " He'll take pity on you and give you something worth using.",
                { delay = 2000 },
                { music = cexi.music.NONE },
                { despawn = { PassingSunrise } },
                { spawn = { Footprint } },
            },
        },
    },
    {
        id     = BRAVE,
        name   = "Brave Fang",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.A3,
            head = cexi.model.BONE_HARNESS,
            body = cexi.model.BONE_HARNESS,
            hand = cexi.model.BONE_HARNESS,
            legs = cexi.model.BONE_HARNESS,
            feet = cexi.model.BONE_HARNESS,
        }),
        area   = "Metalworks",                     -- (F-9)
        pos    = { -62.498, 2.779, -32.970, 227 }, -- !pos -62.498 2.779 -32.970 237
        dialog =
        {
            NAME    = true,
            DEFAULT =
            {
                "There's lots to do around here.",
            },
            START   =
            {
                { emote = xi.emote.LAUGH },
                "Hahaha... So you've been chasing the trail of the Warrior of Wadi too, huh?",
                { delay = 1000 },

                { music = cexi.music.SORROW },
                " The truth is, there were many such warriors...",
                { delay = 3000 },
                "These warriors spent a lifetime and yet none were particularly outstanding.",
                " I guess there is only so much you can learn from one small place.",
                { delay = 3000 },

                { entity = "player", emote = xi.emote.SIGH },
                "Oh, don't be sad. Hey, listen here...",
                { emote = xi.emote.COMFORT },
                { delay = 2000 },

                "What makes a place special isn't famous heroes.",
                " What makes it special is...",
                " The people we meet there, and the stories we make with them.",
                { delay = 2000 },

                { emote = xi.emote.YES },
                "There is so much to this world. Dangruf Wadi is just one small part of it!",
                " You have many more adventures ahead of you.",
                { delay = 2000 },

                "One day, maybe you'll even have a legendary tale of your own!",
                { emote = xi.emote.LAUGH },
            },
        },
    },
    {
        id       = SUNK,
        name     = "Sunken Junk",
        marker   = cq.SIDE_QUEST,
        area     = "Dangruf_Wadi",
        pos      = { -231.452, 4.407, -108.065, 69 }, --!pos -231.452 4.407 -108.065 191
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            DIG     =
            {
                { animation = 48, target = "player", duration = 2000 }, -- Crouch down
                { emotion = "digs and finds a shattered sword!"}
            },
        },
    },
    {
        id       = DEBRIS,
        name     = "Damaged Debris",
        marker   = cq.SIDE_QUEST,
        area     = "Dangruf_Wadi",
        pos      = { -212.251, -0.258, -217.423, 37 }, --!pos -212.251 -0.258 -217.423 191
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            DIG     =
            {
                { animation = 48, target = "player", duration = 2000 }, -- Crouch down
                { emotion = "digs and finds a haggard hilt!" },
            },
        },
    },
    {
        id       = DUSTY,
        name     = "Dusty Rust",
        marker   = cq.SIDE_QUEST,
        area     = "Dangruf_Wadi",
        pos      = { -63.360, 4.576, -218.178, 39 }, --!pos -63.360 4.576 -218.178 191
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            DIG     =
            {
                { animation = 48, target = "player", duration = 2000 }, -- Crouch down
                { emotion = "digs and finds a broken blade!" },
            },
        },
    },
    {
        id          = CRAB,
        name        = "Weary Crab",
        type        = xi.objType.MOB,
        groupId     = 18,
        groupZoneId = 191,
        area        = "Dangruf_Wadi",
        pos         = { -231.452, 4.407, -108.065, 69 }, --!pos -231.452 4.407 -108.065 191
        level       = 5,
    },
    {
        id          = HARE,
        name        = "Weary Hare",
        type        = xi.objType.MOB,
        groupId     = 14,
        groupZoneId = 191,
        area        = "Dangruf_Wadi",
        pos         = { -212.251, -0.258, -217.423, 37 }, --!pos -212.251 -0.258 -217.423 191
        level       = 5,
    },
    {
        id          = WORM,
        name        = "Weary Worm",
        type        = xi.objType.MOB,
        groupId     = 17,
        groupZoneId = 191,
        area        = "Dangruf_Wadi",
        pos         = { -63.466, 4.573, -218.209, 56 }, --!pos -63.466 4.573 -218.209 191
        level       = 5,
    },
    {
        id          = GOBLIN,
        name        = "Gobby Grindalox",
        type        = xi.objType.MOB,
        groupId     = 13,
        groupZoneId = 191,
        area        = "Dangruf_Wadi",
        pos         = { -140.533, 3.245, -175.324, 112 }, --!pos -140.533 3.245 -175.324 191
        level       = 5,
    },
}

local step =
{
    {
        check  = cq.checks({ CW = true, level = 10 }),
        [PASS] = cq.talkStep("START", info.name),
    },
    {
        [SUNK] = cq.spawnMob(CRAB),
        [CRAB] = cq.killStep(SUNK),
    },
    {
        [SUNK] = cq.talkStep("DIG"),
    },
    {
        [PASS] = cq.talkStep("FIRST"),
    },
    {
        [SUNK]   = cq.talkOnly("AFTER"),
        [DEBRIS] = cq.spawnMob(HARE),
        [HARE]   = cq.killStep(DEBRIS),
    },
    {
        [DEBRIS] = cq.talkStep("DIG"),
    },
    {
        [PASS] = cq.talkStep("SECOND"),
    },
    {
        [DEBRIS] = cq.talkOnly("AFTER"),
        [DUSTY]  = cq.spawnMob(WORM),
        [WORM]   = cq.killStep(DUSTY),
    },
    {
        [DUSTY] = cq.talkStep("DIG"),
    },
    {
        [DUSTY]  = cq.talkOnly("AFTER"),
        [PASS]   = cq.spawnMob(GOBLIN),
        [GOBLIN] = cq.killStep(PASS),
    },
    {
        [PASS]  = cq.giveStep("THIRD", info.reward),
    },
    {
        [BRAVE] = cq.giveStep("START", info.reward2, info.name, cexi.music.METALWORKS),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
