-----------------------------------
-- That's All Folks (Lv10)
-- In a Bucket      (Lv12)
-----------------------------------
-- !setvar [CW]THATS_ALL_FOLKS 0
-- !setvar [CW]CRAB_SHELL 0
-- Conchata-Potata !pos -145.155 -7.480 7.991 236
-- Hare Tracks     !pos -550.685 40.000 -379.522 107
-- Reward: 1500 gil
-----------------------------------
-- Conchata-Potata !pos -145.155 -7.480 7.991 236
-- !additem 881 3
-- Reward: 1800 gil
-----------------------------------
-- !setvar [CW]THATS_ALL_FOLKS 4

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-thats_all_folks")

local info =
{
    name    = "That's All Folks",
    author  = "Loxley",
    var     = "[CW]THATS_ALL_FOLKS",
    counter = "[CW]CRAB_SHELL",

    reward1 =
    {
        gil = 1500,
    },

    reward  =
    {
        gil = 1800,
    },

    required =
    {
        item = { { 881, 3 } },
        name = "three crab shells",
    },
}

local CONCH          = "CONCH"
local ConchataPotata = "Conchata-Potata"
local HARE           = "HARE"
local TRACKS         = "TRACKS"
local HareTracks     = "Hare Tracks"

local entity =
{
    {
        id     = CONCH,
        name   = ConchataPotata,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.TARU_M,
            face = cexi.face.B4,
            head = 119, -- Magnifying Spectacles
            body = cexi.model.VELVET_ROBE,
            hand = cexi.model.ROBE,
            legs = cexi.model.ROBE,
            feet = cexi.model.ROBE,
        }),
        area   = "Port_Bastok",                    -- (E-6)
        pos    = { -145.155, -7.480, 7.991, 177 }, -- !pos -145.155 -7.480 7.991 236
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Many years ago, wild hare inhibated the land around Bastok." },
            START    =
            {
                { emote = xi.emote.THINK },
                "Many years ago, wild hare inhibated the land around Bastok.",
                " They're a rare sight today, having mostly migrated to Dangruf.",
                { delay = 2000 },
                "If you find any traces of the the Gustaberg Hare, let me know.",
                " I've heard a rumor that one was sighted around the Fumaroles.",
            },
            REMINDER =
            {
                { emote = xi.emote.THINK },
                "If you find any traces of the the Gustaberg Hare, let me know.",
                " I've heard a rumor that one was sighted around the Fumaroles.",
            },
            AFTER =
            {
                { emote = xi.emote.AMAZED },
                "You were able to track one down? Yes, they can be quite aggressive.",
                { delay = 1000 },
                { entity = "player", emote = xi.emote.SIGH },
                { emote = xi.emote.YES },
                "I see. Not to worry. It's probably for the best.",
                " Here's a little something for your time.",
            },
            NEXT  =
            {
                "Do you have any plans to visit the Fumaroles again soon?",
                " I'm in need of some crab shells for my research.",
                { emote = xi.emote.THINK },
                { delay = 2000 },
                "I'll pay you for every three crab shells you bring me.",
            },
            REMINDER2 =
            {
                "I'll pay you for every three crab shells you bring me.",
            },
            ACCEPTED =
            {
                { emote = xi.emote.BOW },
                "This will do nicely for my research. That makes %u.",
                " I'll take another three whenever you have them.",
            },
        },
    },
    {
        id       = TRACKS,
        name     = HareTracks,
        marker   = cq.SIDE_QUEST,
        area     = "South_Gustaberg",
        pos      = { -550.685, 40.000, -379.522, 153 }, --!pos -550.685 40.000 -379.522 107
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id          = HARE,
        name        = "Gustaberg Hare",
        type        = xi.objType.MOB,
        look        = 268,
        groupId     = 9,
        groupZoneId = 191,
        area        = "South_Gustaberg",
        pos         = { -550.685, 40.000, -379.522, 153 }, --!pos -550.685 40.000 -379.522 107
        level       = 7,
    },
}

local step =
{
    {
        check   = cq.checks({ CW = true, level = 10 }),
        [CONCH] = cq.talkStep("START", info.name),
    },
    {
        [CONCH]  = cq.talkOnly("REMINDER"),
        [TRACKS] = cq.menuSpawn(HARE, "Inspect the tracks?", { { "No." }, { "Yes." } }, 2),
        [HARE]   = cq.killStep(TRACKS),
    },
    {
        [TRACKS] = cq.talkOnly("AFTER"),
        [CONCH]  = cq.giveStep("AFTER", info.reward1, info.name, cexi.music.BASTOK),
    },
    {
        check   = cq.checks({ CW = true, level = 12 }),
        [CONCH] = cq.talkStep("NEXT", "In a Bucket"),
    },
    {
        [CONCH] =
        {
            onTrigger = cq.talkOnly("REMINDER2"),
            onTrade   = cq.tradeOnly("ACCEPTED", "REMINDER2", info.required.item, info.reward, info.counter, 3, "In a Bucket", cexi.music.BASTOK),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
