-----------------------------------
-- Running Rings Around (Lv1)
-----------------------------------
-- Steps
-----------------------------------
-- !setvar [CW]RUNNING_RINGS_AROUND 0
-- Verona  !pos -78.994 -4.000 -88.088 235
-- Julberg !pos -151.168 -4.819 -79.144 235
-- Repeat 4 times
-- Reward: Bastokan Ring
-----------------------------------
-- !setvar [CW]RUNNING_RINGS_AROUND 9

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-running_rings_around")

local info =
{
    name   = "Running Rings Around",
    author = "Loxley",
    var    = "[CW]RUNNING_RINGS_AROUND",
    reward =
    {
        item  = 13497, -- Bastokan Ring (Lv1)
    },
}

local VERONA   = "VERONA"
local Verona1  = "Verona"
local JULBERG  = "JULBERG"
local julberg1 = "Julberg"

local entity =
{
    {
        id     = VERONA,
        name   = Verona1,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.HUME_F,
            face = 13,
            head = 0,
            body = cexi.model.ERRANT_HOUPPELANDE,
            hand = cexi.model.STARTER_RSE,
            legs = cexi.model.TACTICIAN_MAGICIAN,
            feet = cexi.model.STARTER_RSE,
        }),
        area   = "Bastok_Markets",
        pos    = { -78.994, -4.000, -88.088, 90 }, -- !pos -78.994 -4.000 -88.088 235
        dialog =
        {
            NAME     = true,
            DEFAULT  =
            {
                "Um excuse me, I am quite busy!",
            },
            START  =
            {
                { entity = Verona1, emote = xi.emote.THINK },
                "Carmelide's right here in Bastok simply has the most wonderful jewelry!",
                { delay = 2000 },
                { entity = Verona1, emote = xi.emote.POINT },
                "...Why, You there, Errand boy... or.. uh girl!",
                { entity = "player", emote = xi.emote.SHOCKED },
                { delay = 1000 },
                "You will be a dear and fetch that latest ring for me, won't you?",
                " Go to Julberg at Carmelide's Jewelry and collect my order.",
                { delay = 3000 },
                "I can't wait to try it on!",
            },
            REMINDER =
            {
                { entity = Verona1, emote = xi.emote.DOUBT },
                "Please do hurry up and fetch that ring.",
            },
            RING1  =
            {
                { emotion = "hands over the new ring." },
                { entity = Verona1, emote = xi.emote.DISGUSTED },
                "Oh, no, no, no! This ring clashes too much with my shoes!",
                " Please go back to Carmelide's and see what else they have.",
            },
            RING2 =
            {
                { emotion = "hands over the new ring." },
                { entity = Verona1, emote = xi.emote.DISGUSTED },
                "Hmmm... this ring is too shiny.",
                "Go get a different one for me to try on.",
            },
            RING3 =
            {
                { emotion = "hands over the new ring." },
                { entity = Verona1, emote = xi.emote.FUME },
                "This... monstrosity?! Absolutely not. This ring is hideous!",
                "Go get a different one for me to try on.",
            },
            RING4 =
            {
                { emotion = "hands over the new ring." },
                { entity = Verona1, emote = xi.emote.PRAISE },
                "PERFECT!~ WONDERFUL!~",
                "This is it! This is the one!",
                "Oh, I look absolutely fabulous!",
                { entity = Verona1, emote = xi.emote.THINK },
                "I'm going to be the talk of the town!",
                { delay = 4000 },
                { entity = Verona1, emote = xi.emote.ANGRY },
                "Why you! What are you still doing here?",
                "I need not that crude, brutish specimen you brought here earlier!",
                "Get it out of my sight!",
                "Take this ghastly trinket at once and leave me in peace!",
            },
            AFTER =
            {
                { entity = Verona1, emote = xi.emote.NO },
                "Excuse me, can't you see I'm very busy? I am quite important after all."
            },
        },
    },
    {
        id     = JULBERG,
        name   = julberg1,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.HUME_M,
            face = 9,
            head = cexi.model.BRONZE_HARNESS,
            body = cexi.model.GAMBISON,
            hand = cexi.model.TUNIC,
            legs = cexi.model.TUNIC,
            feet = cexi.model.STARTER_RSE,
        }),
        area   = "Bastok_Markets",
        pos    = { -151.168, -4.819, -79.144, 180 }, --!pos -151.168 -4.819 -79.144 235
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Welcome, customer. Gaze upon the finest jewelry in all of Vana'diel!" }, -- Clicking
            RING1    =
            {
                { entity = julberg1, animate = 243, mode = 4 }, -- Sweating
                "An order? For Verona? Oh no...",
                { delay = 3000 },
                { entity = julberg1, emote = xi.emote.YES },
                "I mean... yes, it's right here!",
                { say = "You take Verona's new ring." },
            },
            RING2    =
            {
                { entity = julberg1, emote = xi.emote.SULK },
                "I was worried this would happen.... again.",
                "Very well, take her this ring instead",
                { say = "You take Verona's new ring." },
            },
            RING3    =
            {
                { entity = julberg1, emote = xi.emote.STAGGER },
                "Back again? Verona is impossible to please",
                "One last try then... how about this one?",
                { say = "You take Verona's new ring." },
            },
            RING4    =
            {
                { entity = julberg1, emote = xi.emote.CRY },
                "Enough! Enough! This is an insult to this very fine establishment!",
                "Take this nasty clunker of a ring and see how she likes THAT one!",
                { say = "You take Verona's new ring." },
            }
        }
    },
}

local step =
{
    {
        check     = cq.checks({ CW = true }),
        [VERONA]  = cq.talkStep("START", info.name),
    },
    {
        [VERONA]  = cq.talkOnly("REMINDER"),
        [JULBERG] = cq.talkStep("RING1"),
    },
    {
        [VERONA]  = cq.talkStep("RING1"),
    },
    {
        [VERONA]  = cq.talkOnly("REMINDER"),
        [JULBERG] = cq.talkStep("RING2"),
    },
    {
        [VERONA]  = cq.talkStep("RING2"),
    },
    {
        [VERONA]  = cq.talkOnly("REMINDER"),
        [JULBERG] = cq.talkStep("RING3"),
    },
    {
        [VERONA]  = cq.talkStep("RING3"),
    },
    {
        [VERONA]  = cq.talkOnly("REMINDER"),
        [JULBERG] = cq.talkStep("RING4"),
    },
    {
        [VERONA]  = cq.giveStep("RING4", info.reward, info.name, cexi.music.BASTOK),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
