-----------------------------------------------------------
-- Runic Restoration -- Unlocks RUN (Lv75)
-----------------------------------------------------------
-- Steps
-----------------------------------------------------------
-- !setvar [CW]RUNIC_INSURRECTION 0
-- Octavien   !pos -291.332 -16.319 -124.813 235
-- Hetfield   !pos -31.655 -3.791 15.654 233
-- Fireflower !pos -321.507 -6.787 637.429 2
-- Hetfield   !pos -31.655 -3.791 15.654 233
-- Sun Gate   !pos 434.754 -10.000 183.014 96
-- Hetfield   !pos -31.655 -3.791 15.654 233
-- Octavien   !pos -291.332 -16.319 -124.813 235
-- Reward:  Scroll of Foil
-- Unlocks: Runefencer
-----------------------------------------------------------
-- !setvar [CW]RUNIC_INSURRECTION 7

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------------------------------
local m = Module:new("cw_runic_insurrection")

local info =
{
    author = "Carver",
    name   = "Runic Insurrection",
    var    = "[CW]RUNIC_INSURRECTION",  --NOTE: Ending var value is 7
}

local entity =
{
    {
        id     = "OCTAVIEN",
        name   = "Octavien",
        type   = xi.objType.NPC,
        look   = "0x01000F0352115221523152415251006000700000",
        area   = "Bastok_Markets",
        pos    = { -291.332, -16.319, -124.813, 192 }, -- !pos -291.332 -16.319 -124.813 235
        dialog =
        {
            NAME  = true,
            INTRO =
            {
                "Hello there, adventurer. My name is Octavien and I hail from the Order of Orvail.",
                " I traveled here to the Republic of Bastok in hopes of recruiting some fine warriors to our order.",
                { delay = 1000 },
                { emote = xi.emote.THINK },
                "The gait, posture and powers that lay dormant within a person provide ample evidence as to a warrior's capability.",
                { delay = 2000 },
                { emote = xi.emote.POINT },
                " What say you, are you up to the task of joining the Order of Orvail and becoming a Rune Fencer?",
                { delay = 1000 },
                "You may return to me once you've made your choice."
            },
            STEP1 =
            {
                "Fine choice, adventurer. I assure you these trials are no easy feat, but the risk meets the reward.",
                { emote = xi.emote.YES },
                { delay = 1000 },
                " Your first task is to travel to the Kingdom of San d'Oria and find Hetfield in the Chateau d'Oraguille.",
            },
            DECLINE =
            {
                "Understood. Come back when you've changed your mind."
            },
            REMINDER =
            {
                "Your first task is to Travel to the Kingdom of San d'Oria and find Hetfield in the Chateau d'Oraguille.",
            },
        },
    },
    {
        id     = "HETFIELD",
        name   = "Hetfield",
        type   = xi.objType.NPC,
        look   = "0x0100060300104B214B314B414B51006000700000",
        area   = "Chateau_dOraguille",
        pos    = { -31.655, -3.791, 15.654, 65 }, -- !pos -31.655 -3.791 15.654 233
        dialog =
        {
            NAME  = true,
            STEP2 =
            {
                "Well met, adventurer. My name is Hetfield, head of House Orvail.",
                { emote = xi.emote.CHEER },
                " If Octavien sent you, that must mean he thinks very highly of you. You should feel quite proud of that.",
                { delay = 3000 },
                "First, travel to Carpenter's Landing and fetch one of the fireflowers that grow atop the wild mushrooms there.",
            },
            STEP3 =
            {
                "A demon worm was guarding the fireflower, you say?",
                { emote = xi.emote.THINK },
                { delay = 1000 },
                "Those legendary worms are said to only exist in Fort Karugo-Narugo.",
                " The last of them were locked behind the sun gate during Crystal War.",
                { emote = xi.emote.SIGH},
                { delay = 1000 },
                "If the gate's magical defense has been compromised, it could mean trouble for the Federation of Windurst.",
                { emote = xi.emote.NO },
                { delay = 2000 },
                "Please go and see if you can find the sun gate at Fort Karugo-Narugo and investigate further.",
            },
            FINISH =
            {
                { emote = xi.emote.SHOCKED },
                "Just as I suspected!",
                "Diabolos is planning to take control of the remaining demon worms...",
                " And use them to launch an assault on the good citizens of Windurst!",
                { delay = 2000 },
                "Great work, adventurer. I think you've earned your rite of passage into the Order of Orvail.",
                { emote = xi.emote.BOW },
                "I now pronounce you a decorated Rune Fencer. You may see yourself out.",
            },
            AFTER = { "You may see yourself out." },
            REMINDER_NM1 = { "Travel to Carpenter's Landing, and fetch me one of the fireflowers that grows atop the wild mushrooms there." },
        },
    },
    {
        id     = "FIREFLOWER",
        name   = "Fireflower",
        marker = cq.SIDE_QUEST,
        area   = "Carpenters_Landing",
        pos    = { -321.507, -6.787, 637.429 }, -- !pos -321.507 -6.787 637.429 2
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id          = "DIABOLOS_MINION",
        name        = "Diabolos Minion",
        type        = xi.objType.MOB,
        groupId     = 35,
        groupZoneId = 84,
        look        = 2906,
        area        = "Carpenters_Landing",
        pos         = { -304.786, -1.1474, 623.907, 151 }, -- !pos -304.786 -1.1474 623.907 2
        widescan    = 1,
        level       = 48,
    },
    {
        id          = "DIABOLOS_ZEALOT",
        name        = "Diabolos Zealot",
        type        = xi.objType.MOB,
        groupId     = 3,
        groupZoneId = 155,
        look        = 2885,
        area        = "Fort_Karugo-Narugo_[S]",
        pos         = { 461.663, -9.388, 180.265, 132 }, -- !pos 461.663 -9.388 180.265 96
        widescan    = 1,
        level       = 48,
    },
    {
        id          = "SUN_GATE",
        name        = "Sun Gate",
        marker      = cq.SIDE_QUEST,
        area        = "Fort_Karugo-Narugo_[S]",
        pos         = { 434.754, -10.000, 183.014 }, -- !pos 434.754 -10.000 183.014 96
        dialog =
        {
            REMINDER =
            {
                "You should report your findings back to Hetfield in Chateau d'Oraguille.",
            },
        },
    },
}

local step =
{
    {
        check = cq.checks({ era = true, level = 75 }),
        ["OCTAVIEN"] = cq.talkStep("INTRO"),
    },
    {
        ["OCTAVIEN"] = cq.menuStep("Join the Order of Orvail?", { { "Yes", "STEP1" }, { "No", "DECLINE" } }, 1, info.name ),
    },
    {
        ["OCTAVIEN"] = cq.talkOnly("REMINDER"),
        ["HETFIELD"] = cq.talkStep("STEP2"),
    },
    {
        ["OCTAVIEN"]        = cq.talkOnly("REMINDER"),
        ["HETFIELD"]        = cq.talkOnly("REMINDER_NM1"),
        ["FIREFLOWER"]      = cq.menuSpawn("DIABOLOS_MINION", "Pick the fireflower?", { { "Run away!" }, { "Yes." } }, 2 ),
        ["DIABOLOS_MINION"] = cq.killStep("FIREFLOWER"),
    },
    {
        ["OCTAVIEN"]         = cq.talkOnly("REMINDER"),
        ["HETFIELD"]         = cq.talkOnly("STEP3"),
        ["FIREFLOWER"]       = cq.talkOnly("AFTER"),
        ["SUN_GATE"]         = cq.menuSpawn("DIABOLOS_ZEALOT", "Breach the door?", { { "Run away!" }, { "Yes." } }, 2 ),
        ["DIABOLOS_ZEALOT"]  = cq.killStep("SUN_GATE"),
    },
    {
        ["SUN_GATE"] = cq.talkOnly("REMINDER"),
        ["HETFIELD"] = cq.talkStep("FINISH"),
    },
    {
        ["HETFIELD"] = cq.talkOnly("AFTER"),
    },
}

-- Prince Regent's Room -- Opens during quest
m:addOverride("xi.zones.Chateau_dOraguille.npcs._6h1.onTrigger", function(player, npc)
    local doorVar = player:getCharVar(info.var)

    -- Quest is done, prevent further access into this room.
    if doorVar == 6 then
        player:injectActionPacket(player:getID(), 6, 600, 0, 0, 0, 0, 0)

        -- Move player outside of room
        player:timer(2000, function(playerArg)
            player:setPos(-37.948, -3, 35.021, 190)
        end)

        player:timer(2750, function(playerArg)
            player:injectActionPacket(player:getID(), 6, 602, 0, 0, 0, 0, 0)
        end)

        -- Unlock Rune Fencer
        player:timer(3500, function(npcArg)
            if npcUtil.giveItem(player, { 20781, 5102 }) then -- Sowilo Claymore, Scroll of Foil
                player:printToPlayer(string.format("\129\159 Quest Completed: %s", info.name), xi.msg.channel.SYSTEM_3)

                player:changeMusic(0, 67)
                player:changeMusic(1, 67)
                player:timer(5000, function(playerArg)
                    player:changeMusic(0, cexi.music.CHATEAU)
                    player:changeMusic(1, cexi.music.CHATEAU)
                end)

                cq.rewardSlots(player, { xi.inv.WARDROBE, 1 })
                npcUtil.giveKeyItem(player, xi.ki.JOB_GESTURE_RUNE_FENCER)
                player:unlockJob(xi.job.RUN)
                player:setCharVar("[RUN]Unlocked", 1)
                player:setCharVar(info.var, 7)
                player:printToPlayer("\129\154 You can now become a Rune Fencer. \129\154", xi.msg.channel.SYSTEM_3)
            else
                -- Something went wrong
                player:printToPlayer("Something is wrong, is your inventory full?", xi.msg.channel.SYSTEM_3)
            end
        end)

        return
    end

    -- If player is on proper steps of the quest, open door.
    if doorVar >= 2 and doorVar < 6 then
        npc:openDoor(5)
        return
    end

    super(player, npc)
end)

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
